/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.j2ee.transaction;

import java.io.ObjectStreamException;
import java.io.Serializable;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.UserTransaction;
import javax.transaction.xa.XAResource;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.Terminator;
import org.omg.CosTransactions.TransactionFactory;
import org.omg.CosTransactions.TransactionFactoryHelper;
import org.omg.CosTransactions.Unavailable;
import weblogic.corba.j2ee.naming.ORBHelper;
import weblogic.corba.j2ee.naming.ORBInfo;
import weblogic.corba.j2ee.transaction.Utils;
import weblogic.transaction.ClientTransactionManager;

public class TransactionManagerImpl
implements UserTransaction,
ClientTransactionManager,
Transaction,
Serializable {
    public static final String COS_TRANSACTION_FACTORY_SERVICE = "TransactionFactory";
    private TransactionFactory txFactory = null;
    private int timeout = 0;
    private Control control = null;
    private PropagationContext ctx = null;

    TransactionManagerImpl() {
    }

    public TransactionFactory getTxFactory() throws SystemException {
        try {
            ORBInfo oRBInfo = ORBHelper.getORBHelper().getCurrent();
            if (oRBInfo == null) {
                throw new SystemException("No default ORB selected for the current thread");
            }
            this.txFactory = TransactionFactoryHelper.narrow(oRBInfo.getORB().resolve_initial_references(COS_TRANSACTION_FACTORY_SERVICE));
        }
        catch (InvalidName invalidName) {
            throw new SystemException("Could not access TransactionFactory");
        }
        return this.txFactory;
    }

    public void begin() throws NotSupportedException, SystemException {
        if (this.control != null) {
            throw new NotSupportedException("A transaction is already in progress");
        }
        try {
            this.control = this.getTxFactory().create(this.timeout);
            this.ctx = this.control.get_coordinator().get_txcontext();
            ORBHelper.getORBHelper().getCurrent().setTransaction(this);
        }
        catch (Inactive inactive) {
            throw new NotSupportedException(inactive.getMessage());
        }
        catch (Unavailable unavailable) {
            throw new NotSupportedException(unavailable.getMessage());
        }
        catch (NO_IMPLEMENT nO_IMPLEMENT) {
            throw new NotSupportedException(nO_IMPLEMENT.getMessage());
        }
        catch (INVALID_TRANSACTION iNVALID_TRANSACTION) {
            throw new SystemException(iNVALID_TRANSACTION.getMessage());
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        try {
            if (this.control == null) {
                throw new IllegalStateException("No transaction in progress");
            }
            Terminator terminator = this.control.get_terminator();
            ORBHelper.getORBHelper().getCurrent().setTransaction(null);
            terminator.commit(true);
        }
        catch (Unavailable unavailable) {
            throw new IllegalStateException("Transaction unavailable");
        }
        catch (HeuristicMixed heuristicMixed) {
            throw new HeuristicMixedException();
        }
        catch (HeuristicHazard heuristicHazard) {
            throw new HeuristicRollbackException();
        }
        catch (INVALID_TRANSACTION iNVALID_TRANSACTION) {
            throw new IllegalStateException("No transaction in progress");
        }
        catch (TRANSACTION_ROLLEDBACK tRANSACTION_ROLLEDBACK) {
            throw new RollbackException(tRANSACTION_ROLLEDBACK.getMessage());
        }
        finally {
            this.control = null;
            this.ctx = null;
        }
    }

    public int getStatus() throws SystemException {
        if (this.control == null) {
            return 6;
        }
        try {
            Coordinator coordinator = this.control.get_coordinator();
            return Utils.ots2jtaStatus(coordinator.get_status());
        }
        catch (Unavailable unavailable) {
            throw new SystemException("Transaction unavailable");
        }
        catch (INVALID_TRANSACTION iNVALID_TRANSACTION) {
            this.control = null;
            this.ctx = null;
            throw new SystemException("No transaction in progress");
        }
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        if (this.control == null) {
            throw new IllegalStateException("No transaction in progress");
        }
        try {
            Terminator terminator = this.control.get_terminator();
            ORBHelper.getORBHelper().getCurrent().setTransaction(null);
            terminator.rollback();
        }
        catch (Unavailable unavailable) {
            throw new IllegalStateException("Transaction unavailable");
        }
        catch (INVALID_TRANSACTION iNVALID_TRANSACTION) {
            throw new IllegalStateException("No transaction in progress");
        }
        finally {
            this.control = null;
            this.ctx = null;
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        if (this.control == null) {
            throw new SystemException("No transaction in progress");
        }
        try {
            Coordinator coordinator = this.control.get_coordinator();
            coordinator.rollback_only();
        }
        catch (INVALID_TRANSACTION iNVALID_TRANSACTION) {
            this.control = null;
            this.ctx = null;
            throw new SystemException("No transaction in progress");
        }
        catch (Unavailable unavailable) {
            throw new SystemException("Transaction unavailable");
        }
        catch (Inactive inactive) {
            throw new IllegalStateException("Inactive transaction");
        }
    }

    public void setTransactionTimeout(int n) throws SystemException {
        this.timeout = n;
    }

    public void resume(Transaction transaction) throws InvalidTransactionException, IllegalStateException, SystemException {
        try {
            ORBHelper.getORBHelper().getCurrent().setTransaction((TransactionManagerImpl)transaction);
        }
        catch (ClassCastException classCastException) {
            throw new SystemException(classCastException.getMessage());
        }
    }

    public Transaction suspend() throws SystemException {
        if (this.control == null) {
            throw new SystemException("No transaction in progress");
        }
        ORBHelper.getORBHelper().getCurrent().setTransaction(null);
        return this;
    }

    public void forceResume(Transaction transaction) {
        if (transaction == null) {
            return;
        }
        try {
            TransactionManagerImpl transactionManagerImpl = (TransactionManagerImpl)transaction;
            ORBHelper.getORBHelper().getCurrent().setTransaction(transactionManagerImpl);
        }
        catch (SystemException systemException) {
            // empty catch block
        }
    }

    public Transaction forceSuspend() {
        if (this.control == null) {
            return null;
        }
        try {
            ORBHelper.getORBHelper().getCurrent().setTransaction(null);
        }
        catch (SystemException systemException) {
            // empty catch block
        }
        return this;
    }

    public Transaction getTransaction() throws SystemException {
        if (this.control == null) {
            return null;
        }
        return this;
    }

    public void registerSynchronization(Synchronization synchronization) throws RollbackException, IllegalStateException, SystemException {
        throw new SystemException("Not implemented");
    }

    public boolean delistResource(XAResource xAResource, int n) throws IllegalStateException, SystemException {
        throw new SystemException("Not implemented");
    }

    public boolean enlistResource(XAResource xAResource) throws RollbackException, IllegalStateException, SystemException {
        throw new SystemException("Not implemented");
    }

    public PropagationContext get_txcontext() {
        return this.ctx;
    }

    public Object writeReplace() throws ObjectStreamException {
        return this.txFactory;
    }

    public String toString() {
        return super.toString() + " TransactionManagerImpl()";
    }
}

