/*
 * Decompiled with CFR 0.152.
 */
package weblogic.kernel;

import java.util.Arrays;
import weblogic.kernel.AuditableThread;

public class ResettableThreadLocal {
    private static final InheritableThreadLocal threadLocals = new InheritableThreadLocal(){

        protected Object initialValue() {
            return new ThreadStorage();
        }

        protected Object childValue(Object object) {
            return ((ThreadStorage)object).createChildCopy();
        }
    };
    protected boolean inherit = false;
    private final int index = ThreadStorage.newSlot(this);
    static /* synthetic */ Class class$weblogic$kernel$ResettableThreadLocal$ThreadStorage;

    public ResettableThreadLocal() {
    }

    public ResettableThreadLocal(boolean bl) {
        this.inherit = bl;
    }

    public Object get() {
        return this.currentStorage().get(this.index);
    }

    public Object get(AuditableThread auditableThread) {
        if (auditableThread == null) {
            return null;
        }
        ThreadStorage threadStorage = auditableThread.getThreadStorage();
        if (threadStorage == null) {
            return null;
        }
        return threadStorage.get(this.index);
    }

    public void set(Object object) {
        this.currentStorage().set(this.index, object);
    }

    protected Object initialValue() {
        return null;
    }

    protected Object childValue(Object object) {
        if (this.inherit) {
            return object;
        }
        return ThreadStorage.UNINITIALIZED;
    }

    protected Object resetValue(Object object) {
        return this.initialValue();
    }

    private final ThreadStorage currentStorage() {
        Thread thread = Thread.currentThread();
        ThreadStorage threadStorage = null;
        if (thread instanceof AuditableThread) {
            threadStorage = ((AuditableThread)thread).getThreadStorage();
            if (threadStorage == null) {
                threadStorage = (ThreadStorage)threadLocals.get();
                ((AuditableThread)thread).setThreadStorage(threadStorage);
            }
        } else {
            threadStorage = (ThreadStorage)threadLocals.get();
        }
        return threadStorage;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static final class ThreadStorage {
        public static final Object UNINITIALIZED = new Object();
        private static ResettableThreadLocal[] varList = new ResettableThreadLocal[0];
        private Object[] storage = new Object[varList.length];

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static int newSlot(ResettableThreadLocal resettableThreadLocal) {
            Class clazz = class$weblogic$kernel$ResettableThreadLocal$ThreadStorage == null ? (class$weblogic$kernel$ResettableThreadLocal$ThreadStorage = ResettableThreadLocal.class$("weblogic.kernel.ResettableThreadLocal$ThreadStorage")) : class$weblogic$kernel$ResettableThreadLocal$ThreadStorage;
            synchronized (clazz) {
                int n = varList.length;
                ResettableThreadLocal[] resettableThreadLocalArray = new ResettableThreadLocal[n + 1];
                System.arraycopy(varList, 0, resettableThreadLocalArray, 0, n);
                resettableThreadLocalArray[n] = resettableThreadLocal;
                varList = resettableThreadLocalArray;
                return n;
            }
        }

        public ThreadStorage() {
            Arrays.fill(this.storage, UNINITIALIZED);
        }

        public void set(int n, Object object) {
            if (n >= this.storage.length) {
                this.expand(n + 1);
            }
            this.storage[n] = object;
        }

        public Object get(int n) {
            Object object;
            if (n >= this.storage.length) {
                this.expand(n + 1);
            }
            if ((object = this.storage[n]) == UNINITIALIZED) {
                object = varList[n].initialValue();
                this.set(n, object);
            }
            return object;
        }

        public ThreadStorage createChildCopy() {
            ThreadStorage threadStorage = new ThreadStorage();
            Object[] objectArray = threadStorage.storage;
            Object[] objectArray2 = this.storage;
            ResettableThreadLocal[] resettableThreadLocalArray = varList;
            int n = objectArray2.length;
            for (int i = 0; i < n; ++i) {
                Object object = objectArray2[i];
                if (object == UNINITIALIZED) continue;
                objectArray[i] = resettableThreadLocalArray[i].childValue(object);
            }
            return threadStorage;
        }

        final void reset() {
            Object[] objectArray = this.storage;
            ResettableThreadLocal[] resettableThreadLocalArray = varList;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object object = objectArray[i];
                if (object == UNINITIALIZED) continue;
                objectArray[i] = resettableThreadLocalArray[i].resetValue(object);
            }
        }

        private void expand(int n) {
            int n2 = this.storage.length;
            Object[] objectArray = new Object[n];
            System.arraycopy(this.storage, 0, objectArray, 0, n2);
            for (int i = n2; i < n; ++i) {
                objectArray[i] = UNINITIALIZED;
            }
            this.storage = objectArray;
        }
    }
}

