/*
 * Decompiled with CFR 0.152.
 */
package weblogic.rmi.extensions.server;

import java.rmi.Remote;
import java.util.HashMap;
import java.util.HashSet;
import weblogic.kernel.KernelStatus;
import weblogic.rmi.extensions.server.HeartbeatHelper;
import weblogic.rmi.extensions.server.HeartbeatMonitor;
import weblogic.rmi.extensions.server.HeartbeatMonitorDelegate;
import weblogic.rmi.extensions.server.HeartbeatMonitorException;
import weblogic.rmi.extensions.server.HeartbeatMonitorListener;

public abstract class AbstractHeartbeatMonitorDelegate
implements HeartbeatMonitorDelegate {
    private static final boolean DEBUG = AbstractHeartbeatMonitorDelegate.getDebug();
    private final HashMap listenerSet = new HashMap();
    private final HashMap remote2Helper = new HashMap();
    private static ThreadGroup hbmThreadGroup = null;
    private static boolean hasThreadGroupAccess = true;
    static /* synthetic */ Class class$weblogic$rmi$extensions$server$AbstractHeartbeatMonitorDelegate;

    private static final boolean getDebug() {
        try {
            return Boolean.getBoolean("weblogic.debug.client.dgc");
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static final void p(String string) {
        System.out.println("<AbstractHeartbeatMonitorDelegate>: " + string);
    }

    public AbstractHeartbeatMonitorDelegate() {
        HeartbeatMonitor.getHeartbeatMonitor().addHeartbeatMonitorDelegate(this);
    }

    protected abstract HeartbeatHelper getHeartbeatHelper(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addHeartbeatMonitorListener(Remote remote, HeartbeatMonitorListener heartbeatMonitorListener) {
        HeartbeatHelper heartbeatHelper = this.getHeartbeatHelper(remote);
        if (heartbeatHelper == null) {
            return false;
        }
        if (DEBUG) {
            AbstractHeartbeatMonitorDelegate.p("addHeartbeatMonitorListener...");
        }
        HashMap hashMap = this.listenerSet;
        synchronized (hashMap) {
            this.remote2Helper.put(heartbeatMonitorListener, heartbeatHelper);
            HelperEntry helperEntry = (HelperEntry)this.listenerSet.get(heartbeatHelper);
            if (helperEntry == null) {
                helperEntry = new HelperEntry(this.startPinger(heartbeatHelper));
                this.listenerSet.put(heartbeatHelper, helperEntry);
            }
            helperEntry.listeners.add(heartbeatMonitorListener);
        }
        return true;
    }

    private Timer startPinger(HeartbeatHelper heartbeatHelper) {
        Timer timer = new Timer(this, heartbeatHelper);
        Thread thread = AbstractHeartbeatMonitorDelegate.createThread(timer, "Request Timer Thread");
        thread.setDaemon(true);
        Pinger pinger = new Pinger(this, heartbeatHelper, timer);
        Thread thread2 = AbstractHeartbeatMonitorDelegate.createThread(pinger, "Heartbeat Request Thread");
        thread2.setDaemon(true);
        thread2.start();
        thread.start();
        if (DEBUG) {
            AbstractHeartbeatMonitorDelegate.p("timer/pinger started");
        }
        return timer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeHeartbeatMonitorListener(Remote remote, HeartbeatMonitorListener heartbeatMonitorListener) {
        HashMap hashMap = this.listenerSet;
        synchronized (hashMap) {
            HeartbeatHelper heartbeatHelper = (HeartbeatHelper)this.remote2Helper.remove(heartbeatMonitorListener);
            if (heartbeatHelper == null) {
                return false;
            }
            HelperEntry helperEntry = (HelperEntry)this.listenerSet.get(heartbeatHelper);
            if (helperEntry != null) {
                helperEntry.listeners.remove(heartbeatMonitorListener);
                if (helperEntry.listeners.isEmpty()) {
                    helperEntry.timer.cancel();
                    this.listenerSet.remove(heartbeatHelper);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverHeartbeatMonitorListenerException(Exception exception, Object object) {
        Object object2;
        HashSet hashSet = null;
        Object object3 = this.listenerSet;
        synchronized (object3) {
            object2 = (HelperEntry)this.listenerSet.remove(object);
            if (object2 == null) {
                return;
            }
            hashSet = (HashSet)((HelperEntry)object2).listeners.clone();
        }
        if (DEBUG) {
            AbstractHeartbeatMonitorDelegate.p("deliver [" + exception + "] to listeners");
        }
        object3 = hashSet.iterator();
        while (object3.hasNext()) {
            object2 = (HeartbeatMonitorListener)object3.next();
            object2.callback(exception);
        }
    }

    private static Thread createThread(Runnable runnable, String string) {
        if (!KernelStatus.isApplet()) {
            return new Thread(runnable, string);
        }
        AbstractHeartbeatMonitorDelegate.initializeHBMThreadGroup();
        if (hbmThreadGroup != null) {
            return new Thread(hbmThreadGroup, runnable, string);
        }
        return new Thread(runnable, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeHBMThreadGroup() {
        if (hasThreadGroupAccess && hbmThreadGroup == null) {
            Class clazz = class$weblogic$rmi$extensions$server$AbstractHeartbeatMonitorDelegate == null ? (class$weblogic$rmi$extensions$server$AbstractHeartbeatMonitorDelegate = AbstractHeartbeatMonitorDelegate.class$("weblogic.rmi.extensions.server.AbstractHeartbeatMonitorDelegate")) : class$weblogic$rmi$extensions$server$AbstractHeartbeatMonitorDelegate;
            synchronized (clazz) {
                if (hbmThreadGroup == null) {
                    try {
                        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
                        while (true) {
                            if (threadGroup.getName().equals("main") && threadGroup.getParent().getName().equals("system")) {
                                ThreadGroup threadGroup2 = threadGroup;
                                hbmThreadGroup = new ThreadGroup(threadGroup2, "HeartbeatMonitor ThreadGroup"){

                                    public String toString() {
                                        return "HBMThreadGroup(name=" + this.getName() + ", parent=" + this.getParent() + ")";
                                    }
                                };
                                return;
                            }
                            threadGroup = threadGroup.getParent();
                        }
                    }
                    catch (SecurityException securityException) {
                        System.out.println(" +++ <Warining> Don't have permissions to access ThreadGroup.  We strongly recommend to use signed applet.");
                        System.out.println(" +++ <Warining> Proceed further without creating ThreadGroup.");
                        hasThreadGroupAccess = false;
                    }
                }
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static class Pinger
    implements Runnable {
        protected AbstractHeartbeatMonitorDelegate delegate;
        protected HeartbeatHelper helper;
        protected Timer timer;

        protected Pinger(AbstractHeartbeatMonitorDelegate abstractHeartbeatMonitorDelegate, HeartbeatHelper heartbeatHelper, Timer timer) {
            this.delegate = abstractHeartbeatMonitorDelegate;
            this.helper = heartbeatHelper;
            this.timer = timer;
        }

        public void run() {
            try {
                while (true) {
                    if (DEBUG) {
                        AbstractHeartbeatMonitorDelegate.p("pinger called");
                    }
                    this.helper.ping();
                    if (DEBUG) {
                        AbstractHeartbeatMonitorDelegate.p("pinger renews lease");
                    }
                    this.timer.renewLease();
                }
            }
            catch (Exception exception) {
                this.timer.cancel();
                if (DEBUG) {
                    AbstractHeartbeatMonitorDelegate.p("pinger caught: [" + exception + "]");
                    exception.printStackTrace();
                }
                this.delegate.deliverHeartbeatMonitorListenerException(new HeartbeatMonitorException("HeartbeatMonitor fails", exception), this.helper);
                return;
            }
        }
    }

    protected static class Timer
    implements Runnable {
        protected AbstractHeartbeatMonitorDelegate delegate;
        protected Object key;
        protected int lease = 1;
        protected volatile boolean cancel = false;

        protected Timer(AbstractHeartbeatMonitorDelegate abstractHeartbeatMonitorDelegate, Object object) {
            this.delegate = abstractHeartbeatMonitorDelegate;
            this.key = object;
        }

        protected void renewLease() {
            ++this.lease;
        }

        protected synchronized void cancel() {
            this.cancel = true;
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long l = System.currentTimeMillis();
            int n = this.lease;
            try {
                long l2;
                while (true) {
                    if (DEBUG) {
                        AbstractHeartbeatMonitorDelegate.p("timer waits...");
                    }
                    try {
                        Timer timer = this;
                        synchronized (timer) {
                            this.wait(60000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.cancel) {
                        if (DEBUG) {
                            AbstractHeartbeatMonitorDelegate.p("timer canceled");
                        }
                        return;
                    }
                    if (n < this.lease) {
                        n = this.lease;
                        l = System.currentTimeMillis();
                        continue;
                    }
                    l2 = System.currentTimeMillis() - l;
                    if (DEBUG) {
                        AbstractHeartbeatMonitorDelegate.p("timer fires after " + l2 + "ms, oldLease=" + n + ", lease=" + this.lease);
                    }
                    if (l2 >= 240000L) break;
                }
                this.delegate.deliverHeartbeatMonitorListenerException(new HeartbeatMonitorException("HeartbeatMonitor timed out after " + l2 / 1000L + "s."), this.key);
                return;
            }
            catch (Throwable throwable) {
                if (DEBUG) {
                    throwable.printStackTrace();
                }
                this.delegate.deliverHeartbeatMonitorListenerException(new HeartbeatMonitorException("Internal failure: " + throwable.getMessage()), this.key);
                return;
            }
        }
    }

    private static class HelperEntry {
        private Timer timer;
        private HashSet listeners = new HashSet();

        private HelperEntry(Timer timer) {
            this.timer = timer;
        }
    }
}

