/*===========================================================================*
 *                                                                           *
 *  amqpcli_serial.java description...                                       *
 *                                                                           *
 *  Written:        5/02/18   Gustavo Broos                                  *
 *  Revised:        5/02/18                                                  *
 *                                                                           *
 *  Skeleton generated by LIBERO 2.4 on 18 Feb, 2005, 14:39.                 *
 *===========================================================================*/
import java.awt.*;
import java.applet.*;
import java.net.*;
import java.util.*;
import java.io.*;
import java.security.*;
import org.openamq.*;
import org.openamq.frames.*;

public class amqpcli_transactions extends amqpcli_serial
{


///////////////////////////   P A R A M E T E R S   ///////////////////////////

// Test parameters
int
    case_nbr;                           /* Which case to perform             */
boolean
    commit_sent,                        /* Commit sent messages?             */
    commit_received;                    /* Commit received messages?         */

//////////////////////////////   G L O B A L S   //////////////////////////////

String
    CLIENT_NAME =                       /* Client name                       */
        "Java transactions test client";


///////////////////////////   C O N T R U C T O R S  //////////////////////////

public amqpcli_transactions (String args[])
{
    amqpcli_serial_execute(args);
}


//////////////////////////////////   M A I N   ////////////////////////////////

public static void main (String args[])
{
    amqpcli_serial                      /* The client object                 */
        single = new amqpcli_transactions(args);

}

public int amqpcli_serial_execute (String args[])
{
    final String
        USAGE =                             /* Usage                             */
            "Syntax: clientname [options...]\n"                                       +
            "Options:\n"                                                              +
            "  -c clientname    Client identifier (default: '" + CLIENT_NAME + "')\n" +
            "  -s server        Name or address of server (localhost)\n"              +
            "  -a number        Case to test (default = 1)\n"                         +
            "     1. send, rollback\n"                                                +
            "        => messages gone\n"                                              +
            "     2. send, commit; receive, acknowledge, rollback\n"                  +
            "        => messages persist\n"                                           +
            "  -r repeat        Repeat test N times (1)\n"                            +
            "  -t level         Set trace level (default = 0)\n"                      +
            "  -p               Use persistent messages (no)\n"                       +
            "  -q               Quiet mode: no messages\n"                            +
            "  -v               Show version information\n"                           +
            "  -h               Show summary of command-line options\n"               +
            "\nThe order of arguments is not important. Switches and filenames\n"     +
            "are case sensitive.\n",
        CLIENT_NAME_PRINT =             /* Full name for console             */
            CLIENT_NAME + " - " + AMQFramingFactory.VERSION + "\n";
    String
        argparm = null;                 /* Command line argument             */
    int
        feedback;                       /* Console return int                */
    boolean
        args_ok = true;                 /* Arguments parsing status          */

    for (int argn = 0; argn < args.length; argn++) {
        /*  If argparm is set, we have to collect an argument parameter      */
        if (argparm != null) {
            if (!args[argn].startsWith("-")) {  /*  Parameter can't start with '-'   */
                arguments.setProperty(argparm, args[argn]);
                argparm = null;
            } else {
                args_ok = false;
                break;
            }
        } else if (args[argn].startsWith("-")) {
            switch (args[argn].charAt(1)) {
                /*  These switches take a parameter                          */
                case 'c':
                    argparm = "opt_client";
                    break;
                case 's':
                    argparm = "opt_server";
                    break;
                case 'a':
                    argparm = "opt_case";
                    break;
                case 't':
                    argparm = "opt_trace";
                    break;
                case 'r':
                    argparm = "opt_repeats";
                    break;

                /*  These switches have an immediate effect                  */
                case 'p':
                    persistent = true;
                    break;
                case 'q':
                    quiet_mode = true;
                    break;
                case 'v':
                    System.out.println(CLIENT_NAME_PRINT);
                    System.out.println(COPYRIGHT);
                    System.out.println(NOWARRANTY);
                    System.exit(0);
                case 'h':
                    System.out.println(CLIENT_NAME_PRINT);
                    System.out.println(COPYRIGHT);
                    System.out.println(NOWARRANTY);
                    System.out.println(USAGE);
                    System.exit(0);

                /*  Anything else is an error                                */
                default:
                    args_ok = false;
            }
        } else {
            args_ok = false;
            break;
        }
    }
    /*  If there was a missing parameter or an argument error, quit          */
    if (argparm != null) {
        System.out.println("Argument missing - use -h for help");
        System.exit(1);
    } else if (!args_ok) {
        System.out.println("Invalid arguments - use -h for help");
        System.exit(1);
    }

    message_size = 1024;
    messages = 1000;
    batch_size = 100;
    case_nbr = Integer.parseInt(arguments.getProperty("opt_case", "1"));
    repeats = Integer.parseInt(arguments.getProperty("opt_repeats", "1"));
    verbose = Integer.parseInt(arguments.getProperty("opt_trace", "0")) > 0;
    
    // Set flags according to case
    switch (case_nbr) {
        case 1: // send, rollback
            commit_sent = false;
            commit_received = true;
            break;
        case 2: // send, commit; receive, acknowledge, rollback
            commit_sent = true;
            commit_received = false;
            break;
    }

    feedback = execute ();

    return (feedback);
}


/////////////////////////////////   DO TESTS   ////////////////////////////////

public void do_tests ()
{
    try
    {
        // Channel
        AMQChannel.Open                 /* Channel open command              */
            channel_open = (AMQChannel.Open)amq_framing.constructFrame(AMQChannel.OPEN);
        AMQChannel.Commit               /* Channel commit command            */
            channel_commit = (AMQChannel.Commit)amq_framing.constructFrame(AMQChannel.COMMIT);
        AMQChannel.Rollback             /* Channel commit command            */
            channel_rollback = (AMQChannel.Rollback)amq_framing.constructFrame(AMQChannel.ROLLBACK);
        AMQChannel.Ack                  /* Channel ack command               */
            channel_ack = (AMQChannel.Ack)amq_framing.constructFrame(AMQChannel.ACK);
        AMQChannel.Close                /* Channel close command             */
            channel_close = (AMQChannel.Close)amq_framing.constructFrame(AMQChannel.CLOSE);
        // Handle
        AMQHandle.Open                  /* Handle open command               */
            handle_open = (AMQHandle.Open)amq_framing.constructFrame(AMQHandle.OPEN);
        AMQHandle.Send                  /* Handle send command               */
            handle_send = (AMQHandle.Send)amq_framing.constructFrame(AMQHandle.SEND);
        AMQHandle.Consume               /* Handle consume command            */
            handle_consume = (AMQHandle.Consume)amq_framing.constructFrame(AMQHandle.CONSUME);
        AMQHandle.Flow                  /* Handle flow command               */
            handle_flow = (AMQHandle.Flow)amq_framing.constructFrame(AMQHandle.FLOW);
        AMQHandle.Notify
            handle_notify = null;       /* Handle notify reply               */
        AMQHandle.Created
            handle_created = null;      /* Handle created reply              */
        // Message
        AMQMessage.Head                 /* Message header                    */
            message_head = (AMQMessage.Head)amq_framing.constructMessageHead();
        byte[]
            message_body;               /* Message body                      */
        long head_size;

        // Open channel
        channel_open.channelId = 1;
        channel_open.confirmTag = 0;
        channel_open.transacted = true;
        channel_open.restartable = false;
        channel_open.options = null;
        channel_open.outOfBand = "";
        amq_framing.sendFrame(channel_open);

        // Open hadle
        handle_open.channelId = 1;
        handle_open.handleId = 1;
        handle_open.serviceType = 1;
        handle_open.confirmTag = 0;
        handle_open.producer = true;
        handle_open.consumer = true;
        handle_open.browser = false;
        handle_open.temporary = !persistent;
        handle_open.mimeType = "";
        handle_open.encoding = "";
        handle_open.options = null;
        amq_framing.sendFrame(handle_open);
        // Get handle created
        if (handle_open.temporary)
            handle_created = (AMQHandle.Created)amq_framing.receiveFrame();

        // Pause incoming messages
        handle_flow.handleId = 1;
        handle_flow.confirmTag = 0;

        // Prepare commit and ack
        channel_commit.channelId = 1;
        channel_commit.confirmTag = 0;
        channel_commit.options = null;
        channel_rollback.channelId = 1;
        channel_rollback.confirmTag = 0;
        channel_rollback.options = null;
        channel_ack.channelId = 1;
        channel_ack.confirmTag = 0;
        channel_ack.messageNbr = 0;

        // Send handles and growing messages; commit on the fly
        handle_send.handleId = 1;
        handle_send.confirmTag = 0;
        handle_send.fragmentSize = 0;
        handle_send.partial = false;
        handle_send.outOfBand = false;
        handle_send.recovery = false;
        handle_send.immediate = false;
        handle_send.destName = persistent ? "test" : handle_created.destName;
        message_head.bodySize = 0;
        message_head.persistent = persistent;
        message_head.priority = 1;
        message_head.expiration = 0;
        message_head.mimeType = "";
        message_head.encoding = "";
        message_head.identifier = "";
        message_head.headers = null;
        head_size = message_head.size();
        message_head.bodySize = message_size - head_size;
        if (message_head.bodySize  < 0 )
            message_head.bodySize = message_size;
        message_size = head_size + message_head.bodySize;
        // Allocate the message body
        int heapMax = 1024 * 1024 * 128, done;
        message_body = new byte[(int)Math.min(message_head.bodySize, heapMax)];
        body_fill(message_body, 1, message_body.length);
        // Allocate the digests
        digests = new byte[messages][];
        digest = MessageDigest.getInstance("md5");
        for (int repeat_count = 1; repeat_count <= repeats; repeat_count++) {
            // Pause incoming messages
            handle_flow.flowPause = true;
            amq_framing.sendFrame(handle_flow);
            if (message_size > amq_framing.getFrameMax())
                System.out.println("(" + repeat_count + ") Sending " + messages + " (fragmented) message(s) to server...");
            else
                System.out.println("(" + repeat_count + ") Sending " + messages + " message(s) to server...");
            for (int i = 1; i <= messages; i++) {
                OutputStream dos;

                // Set the fragment size
                handle_send.partial = message_size > amq_framing.getFrameMax();
                handle_send.fragmentSize = Math.min(amq_framing.getFrameMax(), message_size);
                // Send message
                if (pattern_checking)
                    dos = new DigestOutputStream(amq_framing.sendMessage(handle_send, message_head, null, false), digest);
                else
                    dos = amq_framing.sendMessage(handle_send, message_head, null, false);
                done = 0;
                while (done < message_head.bodySize) {
                    int chunk = (int)Math.min(heapMax, message_head.bodySize - done);
                    if (pattern_checking)
                        body_fill(message_body, i, Math.min(1024, message_body.length));
                    dos.write(message_body, 0, chunk);
                    dos.flush();
                    done += chunk;
                }
                if (pattern_checking)
                    digests[i - 1] = ((DigestOutputStream)dos).getMessageDigest().digest();
                dos.close();
                // Commit/rollback as the case demands
                if (!commit_sent) {
                    if (i == messages -1) {
                        amq_framing.sendFrame(channel_rollback);
                        if (!quiet_mode)
                            System.out.println("Rollback " + (messages - 1) + " messages...");
                    } else if (i == messages) {
                        amq_framing.sendFrame(channel_commit);
                        if (!quiet_mode) 
                            System.out.println("Commit sentinel message...");
                    }
                } else {
                    if (i % batch_size == 0) {
                        amq_framing.sendFrame(channel_commit);
                        if (!quiet_mode) 
                            System.out.println("Commit batch " + (i / batch_size) + "...");
                    }
                }
            }
            // Commit leftovers if case allows
            if (commit_sent) {
                amq_framing.sendFrame(channel_commit);
                if (!quiet_mode)
                    System.out.println("Commit final batch...");
            }   

            // Resume incoming messages
            handle_flow.flowPause = false;
            amq_framing.sendFrame(handle_flow);

            // Read back
            for (int r = 0; r < (commit_received ? 1 : 2); r++) {
                handle_consume.handleId = 1;
                handle_consume.confirmTag = 0;
                handle_consume.prefetch = batch_size;
                handle_consume.noLocal = false;
                handle_consume.noAck = false;
                handle_consume.dynamic = false;
                handle_consume.destName = persistent ? "test" : handle_created.destName;
                handle_consume.selector = null;
                // Request consume messages
                amq_framing.sendFrame(handle_consume);
                if (commit_sent) 
                    System.out.println("(" + repeat_count + ") Reading message(s) back from server...");
                else 
                    System.out.println("(" + repeat_count + ") Pattern-testing sentinel message back from server...");
                for (int i = (commit_sent ? 1 : messages); i <= messages; i++) {
                    InputStream dis;
    
                    // Get handle notify
                    handle_notify = (AMQHandle.Notify)amq_framing.receiveFrame();
                    message_head = amq_framing.constructMessageHead();
                    if (pattern_checking)
                        dis = new DigestInputStream(amq_framing.receiveMessage(handle_notify, message_head, null, false), digest);
                    else
                        dis = amq_framing.receiveMessage(handle_notify, message_head, null, false);
                    done = 0;
                    while (done < message_head.bodySize) {
                        int chunk = (int)Math.min(heapMax, message_head.bodySize - done);
                        done += dis.read(message_body, 0, chunk);
                    }
                    if (pattern_checking) {
                        if (!MessageDigest.isEqual(digests[i - 1], ((DigestInputStream)dis).getMessageDigest().digest()))
                            System.err.println("amqpcli_serial: do_tests: returning message contents mismatch.");
                    }
                    dis.close();
                    if ((delay_mode || messages < 100) && !quiet_mode)
                        System.out.println("Message number " + handle_notify.messageNbr + " arrived");
                    if (done != message_size - head_size) {
                        System.err.println("amqpcli_serial: do_tests: returning message size mismatch (is "
                            + done + " should be " + (message_size - head_size) + ").");
                        System.exit(1);
                    }
                    // Acknowledge/commit as the case demands
                    if (commit_sent) {
                        if (i % batch_size == 0) {
                            channel_ack.messageNbr = handle_notify.messageNbr;
                            amq_framing.sendFrame(channel_ack);
                            if (commit_received)
                                amq_framing.sendFrame(channel_commit);
                            else
                                System.out.println("No commit");
                            if (!quiet_mode)
                                System.out.println("Acknowledge batch " + (i / batch_size) + "...");
                        }
                    }
                    if (delay_mode) {
                        try {
                            Thread.sleep(1000);
                        } catch (InterruptedException e) {}
                    }
                }
                // Acknowledge/commit leftovers if case allows
                channel_ack.messageNbr = handle_notify.messageNbr;
                amq_framing.sendFrame(channel_ack);
                if (commit_received)
                    amq_framing.sendFrame(channel_commit);
                else
                    System.out.println("No commit");
                if (!quiet_mode) {
                    if (commit_sent) 
                        System.out.println("Acknowledge final batch...");
                    else
                        System.out.println("Acknowledge sentinel message...");
                }    
                if (!commit_received) {
                    amq_framing.sendFrame(channel_rollback);
                    if (!quiet_mode)
                        System.out.println("Rollback " + messages + " messages...");
                }
            }    
        }

        // Say bye
        channel_close.channelId = 1;
        channel_close.replyCode = 200;
        channel_close.replyText = "amqpcli_serial.java: I'll be back";
        amq_framing.sendFrame(channel_close);
        channel_close = (AMQChannel.Close)amq_framing.receiveFrame();
        amq_framing.sendFrame(client_close);
        client_close = (AMQConnection.Close)amq_framing.receiveFrame();
        if (!quiet_mode)
            System.out.println("Closing, server says: " + client_close.replyText + ".");
    }
    catch (ClassCastException e)
    {
        raise_exception(exception_event, e, "amqpci_java", "do_tests", "unexpected frame from server");
    }
    catch (IOException e)
    {
        raise_exception(exception_event, e, "amqpci_java", "do_tests", "IOException");
    }
    catch (AMQException e)
    {
        raise_exception(exception_event, e, "amqpci_java", "do_tests", "framing error");
    }
    catch (NoSuchAlgorithmException e)
    {
        raise_exception(exception_event, e, "amqpci_java", "do_tests", "requested message digest not available");
    }

    the_next_event = done_event;
}


//%END MODULE
}
