/*===========================================================================*
 *                                                                           *
 *  amqpcli_serial.java description...                                       *
 *                                                                           *
 *  Written:        5/02/18   Gustavo Broos                                  *
 *  Revised:        5/02/18                                                  *
 *                                                                           *
 *  Skeleton generated by LIBERO 2.4 on 18 Feb, 2005, 14:39.                 *
 *===========================================================================*/
package org.openamq.rawclient;

import java.awt.*;
import java.applet.*;
import java.net.*;
import java.util.*;
import java.io.*;
import java.security.*;
import org.openamq.*;
import org.openamq.frames.*;

public class amqpcli_serial extends amqpcli_seriali
{


///////////////////////////   P A R A M E T E R S   ///////////////////////////

// Some protocol defaults for this client
AMQConnection.Tune
    client_tune;                        /* Tune parameters                   */
AMQFieldTable
    a_table;                            /* A field table                     */
AMQConnection.Open
    client_open;                        /* Connection parameters             */
AMQConnection.Close
    client_close;                       /* Default close parameters          */
short
    protocol_port = 7654,               /* Server port                       */
    protocol_id = 128,                  /* Protocol id                       */
    protocol_ver = 1;                   /* Protocol version                  */
int
    socket_timeout = 0;                 /* Socket timeout im ms              */
long
    frame_max = 65536;
// Test parameters
int
    messages,                           /* Size of test set                  */
    batch_size,                         /* Size of batches                   */
    repeats,                            /* Test repetitions                  */
    service_type = 1;                   /* Queue or topic                    */
long
    message_size;                       /* Message size                      */
boolean
    verbose,                            /* Verbose mode                      */
    persistent = false,                 /* Use persistent messages?          */
    quiet_mode = false,                 /* -q means suppress messages        */
    delay_mode = false,                 /* -d means work slowly              */
    pattern_checking = true;            /* Enable pattern checking           */


//////////////////////////////   G L O B A L S   //////////////////////////////

final String
    COPYRIGHT =                         /* Copyright                         */
        "Copyright (c) 2004-2005 JPMorgan",
    NOWARRANTY =                        /* Warranty                          */
        "This is free software; see the source for copying conditions.  There is NO\n"  +
        "warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\n";
String
    client_name =                       /* Client name                       */
        "Java serial test client";
// Outcomes
String
    error_message = null,               /* Error details                     */
    module;                             /* Module in which error occured     */
Exception
    exception = null;                   /* Exception                         */
// Our connection
Socket
    amqp = null;                        /* Network socket                    */
// Framing utility
AMQFramingFactory
    amq_framing = null;                 /* Framing utility                   */
Properties
    arguments = new Properties();       /* Command-line arguments            */
byte[][]
    digests;                            /* Sha1 digests for integrity check  */
MessageDigest
    digest;


///////////////////////////   C O N T R U C T O R S  //////////////////////////

public amqpcli_serial () {
}

public amqpcli_serial (String args[])
{
    amqpcli_serial_execute(args);
}


//////////////////////////////////   M A I N   ////////////////////////////////

public static void main (String args[])
{
    amqpcli_serial                      /* The client object                 */
        single = new amqpcli_serial(args);

}

public int amqpcli_serial_execute (String args[])
{
    final String
        USAGE =                             /* Usage                             */
            "Syntax: clientname [options...]\n"                                       +
            "Options:\n"                                                              +
            "  -c clientname    Client identifier (default: '" + client_name + "')\n" +
            "  -s server        Name or address of server (localhost)\n"              +
            "  -m number        Number of messages to send/receive (1000)\n"          +
            "  -b batch         Size of each batch (100)\n"                           +
            "  -x size          Size of each message (default = 1K)\n"                +
            "                   B=bytes, K=kilos, M=megas, G=gigas.\n"                +
            "  -r repeat        Repeat test N times (1)\n"                            +
            "  -t level         Set trace level (default = 0)\n"                      +
            "  -T               Use topic service (default is queue)\n"               +
            "  -p               Use persistent messages (no)\n"                       +
            "  -n               No pattern checking\n"                                +
            "  -q               Quiet mode: no messages\n"                            +
            "  -d               Delayed mode; sleeps after receiving a message\n"     +
            "  -v               Show version information\n"                           +
            "  -h               Show summary of command-line options\n"               +
            "\nThe order of arguments is not important. Switches and filenames\n"     +
            "are case sensitive.\n",
        CLIENT_NAME_PRINT =             /* Full name for console             */
            client_name + " - " + AMQFramingFactory.VERSION + "\n";
    String
        argparm = null;                 /* Command line argument             */
    int
        feedback;                       /* Console return int                */
    boolean
        args_ok = true;                 /* Arguments parsing status          */

    for (int argn = 0; argn < args.length; argn++) {
        /*  If argparm is set, we have to collect an argument parameter      */
        if (argparm != null) {
            if (!args[argn].startsWith("-")) {  /*  Parameter can't start with '-'   */
                arguments.setProperty(argparm, args[argn]);
                argparm = null;
            } else {
                args_ok = false;
                break;
            }
        } else if (args[argn].startsWith("-")) {
            switch (args[argn].charAt(1)) {
                /*  These switches take a parameter                          */
                case 'c':
                    argparm = "opt_client";
                    break;
                case 's':
                    argparm = "opt_server";
                    break;
                case 'm':
                    argparm = "opt_messages";
                    break;
                case 'b':
                    argparm = "opt_batch";
                    break;
                case 't':
                    argparm = "opt_trace";
                    break;
                case 'x':
                    argparm = "opt_msgsize";
                    break;
                case 'r':
                    argparm = "opt_repeats";
                    break;

                /*  These switches have an immediate effect                  */
                case 'T':
                    service_type = 2;
                    break;
                case 'p':
                    persistent = true;
                    break;
                case 'n':
                    pattern_checking = false;
                    break;
                case 'q':
                    quiet_mode = true;
                    break;
                case 'd':
                    delay_mode = true;
                    break;
                case 'v':
                    System.out.println(CLIENT_NAME_PRINT);
                    System.out.println(COPYRIGHT);
                    System.out.println(NOWARRANTY);
                    System.exit(0);
                case 'h':
                    System.out.println(CLIENT_NAME_PRINT);
                    System.out.println(COPYRIGHT);
                    System.out.println(NOWARRANTY);
                    System.out.println(USAGE);
                    System.exit(0);

                /*  Anything else is an error                                */
                default:
                    args_ok = false;
            }
        } else {
            args_ok = false;
            break;
        }
    }
    /*  If there was a missing parameter or an argument error, quit          */
    if (argparm != null) {
        System.out.println("Argument missing - use -h for help");
        System.exit(1);
    } else if (!args_ok) {
        System.out.println("Invalid arguments - use -h for help");
        System.exit(1);
    }

    { // Parse the message size argument
     String message_size_str = arguments.getProperty("opt_msgsize", "1024");
     try {
        message_size = Long.parseLong(message_size_str);
     } catch(NumberFormatException e) {
         int
            last = message_size_str.length() - 1;

         message_size = Long.parseLong(message_size_str.substring(0, last));
         switch (message_size_str.charAt(last)) {
            case 'g':
            case 'G':
                message_size *= 1024;
            case 'm':
            case 'M':
                message_size *= 1024;
            case 'k':
            case 'K':
                message_size *= 1024;
            case 'b':
            case 'B':
         }
     }
    }
    messages = Integer.parseInt(arguments.getProperty("opt_messages", "1000"));
    batch_size = Integer.parseInt(arguments.getProperty("opt_batch", "100"));
    repeats = Integer.parseInt(arguments.getProperty("opt_repeats", "1"));
    verbose = Integer.parseInt(arguments.getProperty("opt_trace", "0")) > 0;

    feedback = execute ();

    return (feedback);
}


//////////////////////////   INITIALISE THE PROGRAM   /////////////////////////

public void initialise_the_program ()
{
    the_next_event = ok_event;
}


////////////////////////////   GET EXTERNAL EVENT   ///////////////////////////

public void get_external_event ()
{
}

//%START MODULE

//////////////////////////////////   SETUP   //////////////////////////////////

public void setup ()
{
    String
        opt_server = arguments.getProperty("opt_server", "localhost");

    try
    {
        // Network setup
        System.out.println("Connecting to " + opt_server + "...");
        amqp = new Socket(opt_server, protocol_port);
        if (socket_timeout > 0)
            amqp.setSoTimeout(socket_timeout);
        amq_framing = new AMQFramingFactory(amqp);
        amq_framing.verbose = verbose;
        System.out.println("I: connected to AMQP server on " + opt_server + ":" + protocol_port);
        // Client tune capabilities
        client_tune = (AMQConnection.Tune)amq_framing.constructFrame(AMQConnection.TUNE);
        client_tune.options = null;
        client_tune.dictionary = null;
        // Client name and connection open defaults
        client_open = (AMQConnection.Open)amq_framing.constructFrame(AMQConnection.OPEN);
        client_open.confirmTag = 0;
        client_open.virtualPath = null;
        client_open.clientName = arguments.getProperty("opt_client", client_name);
        client_open.options = null;
        // Connection close defaults
        client_close = (AMQConnection.Close)amq_framing.constructFrame(AMQConnection.CLOSE);
        client_close.replyCode = 200;
        client_close.replyText = "amqpcli_serial.java: bye";
    }
    catch (UnknownHostException e)
    {
        raise_exception(exception_event, e, "amqpci_java", "setup", "unknown host");
    }
    catch (SocketTimeoutException e) {
        raise_exception(timeout_event, e, "amqpci_java", "setup", "SocketTimeoutException");
    }
    catch (IOException e)
    {
        raise_exception(exception_event, e, "amqpci_java", "setup", "IOException");
    }
    catch (AMQException e) {}

    the_next_event = send_connection_initiation_event;
}


//////////////////////////////   HANDLE TIMEOUT   /////////////////////////////

public void handle_timeout ()
{
    forced_shutdown ();
    System.exit(1);
}


/////////////////////////////   FORCED SHUTDOWN   /////////////////////////////

public void forced_shutdown ()
{
    // Close connection
    try
    {
        if (exception != null)
            AMQFramingFactory.exception(exception, "java/amqpcli_serial", module, error_message);

        if (amqp != null)
            amqp.close();
    }
    catch (IOException e) {}
    catch (AMQException e) {}
}


//////////////////////////   TERMINATE THE PROGRAM   //////////////////////////

public void terminate_the_program ()
{
    System.exit(error_message != null ? 1 : 0);
}


////////////////////////   SEND CONNECTION INITIATION   ///////////////////////

public void send_connection_initiation ()
{
    try
    {
        // Send initiation
        amq_framing.sendConnectionInitiation(protocol_id, protocol_ver);
    }
    catch (AMQException e)
    {
        raise_exception(exception_event, e, "amqpci_java", "send_connection_initiation", "unable to connect");
    }

    the_next_event = connection_challenge_event;
}


///////////////////////////   SEND CONNECTION OPEN   //////////////////////////

public void send_connection_open ()
{
    try
    {
        client_open.virtualPath = "/test";
        amq_framing.sendFrame(client_open);
    }
    catch (IOException e)
    {
        raise_exception(exception_event, e, "amqpci_java", "send_connection_open", "IOException");
    }
    catch (AMQException e)
    {
        raise_exception(exception_event, e, "amqpci_java", "send_connection_open", "cannot open connection");
    }

    the_next_event = do_tests_event;
}


/////////////////////////////////   DO TESTS   ////////////////////////////////

public void do_tests ()
{
    try
    {
        // Channel
        AMQChannel.Open                 /* Channel open command              */
            channel_open = (AMQChannel.Open)amq_framing.constructFrame(AMQChannel.OPEN);
        AMQChannel.Commit               /* Channel commit command            */
            channel_commit = (AMQChannel.Commit)amq_framing.constructFrame(AMQChannel.COMMIT);
        AMQChannel.Ack                  /* Channel ack command               */
            channel_ack = (AMQChannel.Ack)amq_framing.constructFrame(AMQChannel.ACK);
        AMQChannel.Close                /* Channel close command             */
            channel_close = (AMQChannel.Close)amq_framing.constructFrame(AMQChannel.CLOSE);
        // Handle
        AMQHandle.Open                  /* Handle open command               */
            handle_open = (AMQHandle.Open)amq_framing.constructFrame(AMQHandle.OPEN);
        AMQHandle.Send                  /* Handle send command               */
            handle_send = (AMQHandle.Send)amq_framing.constructFrame(AMQHandle.SEND);
        AMQHandle.Consume               /* Handle consume command            */
            handle_consume = (AMQHandle.Consume)amq_framing.constructFrame(AMQHandle.CONSUME);
        AMQHandle.Flow                  /* Handle flow command               */
            handle_flow = (AMQHandle.Flow)amq_framing.constructFrame(AMQHandle.FLOW);
        AMQHandle.Notify
            handle_notify = null;       /* Handle notify reply               */
        AMQHandle.Created
            handle_created = null;      /* Handle created reply              */
        // Message
        AMQMessage.Head                 /* Message header                    */
            message_head = (AMQMessage.Head)amq_framing.constructMessageHead();
        byte[]
            message_body;               /* Message body                      */
        long head_size;

        // Open channel
        channel_open.channelId = 1;
        channel_open.confirmTag = 0;
        channel_open.transacted = true;
        channel_open.restartable = false;
        channel_open.options = null;
        channel_open.outOfBand = "";
        amq_framing.sendFrame(channel_open);

        // Open hadle
        handle_open.channelId = 1;
        handle_open.handleId = 1;
        handle_open.serviceType = 1;
        handle_open.confirmTag = 0;
        handle_open.producer = true;
        handle_open.consumer = true;
        handle_open.browser = false;
        //handle_open.temporary = !persistent;
        handle_open.mimeType = "";
        handle_open.encoding = "";
        handle_open.options = null;
        amq_framing.sendFrame(handle_open);
        // Get handle created
        //if (handle_open.temporary)
          //  handle_created = (AMQHandle.Created)amq_framing.receiveFrame();

        // Pause incoming messages
        handle_flow.handleId = 1;
        handle_flow.confirmTag = 0;

        // Prepare commit and ack
        channel_commit.channelId = 1;
        channel_commit.confirmTag = 0;
        channel_commit.options = null;
        channel_ack.channelId = 1;
        channel_ack.confirmTag = 0;
        channel_ack.messageNbr = 0;

        // Send handles and growing messages; commit on the fly
        handle_send.handleId = 1;
        handle_send.confirmTag = 0;
        handle_send.fragmentSize = 0;
        handle_send.partial = false;
        handle_send.outOfBand = false;
        handle_send.recovery = false;
        handle_send.immediate = false;
        handle_send.destName = persistent ? "test" : handle_created.destName;
        message_head.bodySize = 0;
        message_head.persistent = persistent;
        message_head.priority = 1;
        message_head.expiration = 0;
        message_head.mimeType = "";
        message_head.encoding = "";
        message_head.identifier = "";
        message_head.headers = null;
        head_size = message_head.size();
        message_head.bodySize = message_size - head_size;
        if (message_head.bodySize  < 0 )
            message_head.bodySize = message_size;
        message_size = head_size + message_head.bodySize;
        // Allocate the message body
        int heapMax = 1024 * 1024 * 128, done;
        message_body = new byte[(int)Math.min(message_head.bodySize, heapMax)];
        body_fill(message_body, 1, message_body.length);
        // Allocate the digests
        digests = new byte[messages][];
        digest = MessageDigest.getInstance("md5");
        for (int repeat_count = 1; repeat_count <= repeats; repeat_count++) {
            // Pause incoming messages
            handle_flow.flowPause = true;
            amq_framing.sendFrame(handle_flow);
            if (message_size > amq_framing.getFrameMax())
                System.out.println("(" + repeat_count + ") Sending " + messages + " (fragmented) message(s) to server...");
            else
                System.out.println("(" + repeat_count + ") Sending " + messages + " message(s) to server...");
            for (int i = 1; i <= messages; i++) {
                OutputStream dos;

                // Set the fragment size
                handle_send.partial = message_size > amq_framing.getFrameMax();
                handle_send.fragmentSize = Math.min(amq_framing.getFrameMax(), message_size);
                // Send message
                if (pattern_checking)
                    dos = new DigestOutputStream(amq_framing.sendMessage(handle_send, message_head, null, false), digest);
                else
                    dos = amq_framing.sendMessage(handle_send, message_head, null, false);
                done = 0;
                while (done < message_head.bodySize) {
                    int chunk = (int)Math.min(heapMax, message_head.bodySize - done);
                    if (pattern_checking)
                        body_fill(message_body, i, Math.min(1024, message_body.length));
                    dos.write(message_body, 0, chunk);
                    dos.flush();
                    done += chunk;
                }
                if (pattern_checking)
                    digests[i - 1] = ((DigestOutputStream)dos).getMessageDigest().digest();
                dos.close();
                // Commit from time to time
                if (i % batch_size == 0) {
                    amq_framing.sendFrame(channel_commit);
                    if (!quiet_mode)
                        System.out.println("Commit batch " + (i / batch_size) + "...");
                }
            }
            // Commit leftovers
            amq_framing.sendFrame(channel_commit);
            if (!quiet_mode)
                System.out.println("Commit final batch...");

            // Resume incoming messages
            handle_flow.flowPause = false;
            amq_framing.sendFrame(handle_flow);

            // Read back
            handle_consume.handleId = 1;
            handle_consume.confirmTag = 0;
            handle_consume.prefetch = batch_size;
            handle_consume.noLocal = false;
            handle_consume.noAck = false;
            handle_consume.dynamic = false;
            handle_consume.destName = persistent ? "test" : handle_created.destName;
            handle_consume.selector = null;
            // Request consume messages
            amq_framing.sendFrame(handle_consume);
            System.out.println("(" + repeat_count + ") Reading message(s) back from server...");
            for (int i = 1; i <= messages; i++) {
                InputStream dis;

                // Get handle notify
                handle_notify = (AMQHandle.Notify)amq_framing.receiveFrame();
                message_head = amq_framing.constructMessageHead();
                if (pattern_checking)
                    dis = new DigestInputStream(amq_framing.receiveMessage(handle_notify, message_head, null, false), digest);
                else
                    dis = amq_framing.receiveMessage(handle_notify, message_head, null, false);
                done = 0;
                while (done < message_head.bodySize) {
                    int chunk = (int)Math.min(heapMax, message_head.bodySize - done);
                    done += dis.read(message_body, 0, chunk);
                }
                if (pattern_checking) {
                    if (!MessageDigest.isEqual(digests[i - 1], ((DigestInputStream)dis).getMessageDigest().digest()))
                        System.err.println("amqpcli_serial: do_tests: returning message contents mismatch.");
                }
                dis.close();
                if ((delay_mode || messages < 100) && !quiet_mode)
                    System.out.println("Message number " + handle_notify.messageNbr + " arrived");
                if (done != message_size - head_size) {
                    System.err.println("amqpcli_serial: do_tests: returning message size mismatch (is "
                        + done + " should be " + (message_size - head_size) + ").");
                    System.exit(1);
                }
                // Acknowledge & commit from time to time
                if (i % batch_size == 0) {
                    channel_ack.messageNbr = handle_notify.messageNbr;
                    amq_framing.sendFrame(channel_ack);
                    amq_framing.sendFrame(channel_commit);
                    if (!quiet_mode)
                        System.out.println("Acknowledge batch " + (i / batch_size) + "...");
                }
                if (delay_mode) {
                    try {
                        Thread.sleep(1000);
                    } catch (InterruptedException e) {}
                }
            }
            // Acknowledge & commit leftovers
            channel_ack.messageNbr = handle_notify.messageNbr;
            amq_framing.sendFrame(channel_ack);
            amq_framing.sendFrame(channel_commit);
            if (!quiet_mode)
                System.out.println("Acknowledge final batch...");
        }

        // Say bye
        channel_close.channelId = 1;
        channel_close.replyCode = 200;
        channel_close.replyText = "amqpcli_serial.java: I'll be back";
        amq_framing.sendFrame(channel_close);
        channel_close = (AMQChannel.Close)amq_framing.receiveFrame();
        amq_framing.sendFrame(client_close);
        client_close = (AMQConnection.Close)amq_framing.receiveFrame();
        if (!quiet_mode)
            System.out.println("Closing, server says: " + client_close.replyText + ".");
    }
    catch (ClassCastException e)
    {
        raise_exception(exception_event, e, "amqpci_java", "do_tests", "unexpected frame from server");
    }
    catch (IOException e)
    {
        raise_exception(exception_event, e, "amqpci_java", "do_tests", "IOException");
    }
    catch (AMQException e)
    {
        raise_exception(exception_event, e, "amqpci_java", "do_tests", "framing error");
    }
    catch (NoSuchAlgorithmException e)
    {
        raise_exception(exception_event, e, "amqpci_java", "do_tests", "requested message digest not available");
    }

    the_next_event = done_event;
}



/////////////////////////   GET CONNECTION CHALLENGE   ////////////////////////

public void face_connection_challenge ()
{
    try
    {
        AMQConnection.Challenge         /* Challenge from server             */
            challenge = (AMQConnection.Challenge)amq_framing.receiveFrame();
        AMQConnection.Response          /* our response                      */
            response = (AMQConnection.Response)amq_framing.constructFrame(AMQConnection.RESPONSE);
        // Send the response
        response.mechanism = "PLAIN";
        a_table = new AMQFieldTable();
        a_table.putString("LOGIN", amq_framing.string2Bytes("guest"));
        a_table.putString("PASSWORD", amq_framing.string2Bytes("guest"));
        response.responses = a_table.storeToBucket();
        amq_framing.sendFrame(response);
    }
    catch (ClassCastException e)
    {
        raise_exception(exception_event, e, "amqpci_java", "face_connection_challenge", "unexpected frame from server");
    }
    catch (SocketTimeoutException e) {
        raise_exception(timeout_event, e, "amqpci_java", "face_connection_challenge", "SocketTimeoutException");
    }
    catch (IOException e)
    {
        raise_exception(exception_event, e, "amqpci_java", "face_connection_challenge", "IOException");
    }
    catch (AMQException e)
    {
        raise_exception(exception_event, e, "amqpci_java", "face_connection_challenge", "authentication error");
    }

    the_next_event = connection_tune_event;
}


////////////////////////   NEGOTIATE CONNECTION TUNE   ////////////////////////

public void negotiate_connection_tune ()
{
    AMQFrame
        frame = null;               /* Raw frame                         */
    AMQConnection.Tune              /* Tune parameters from server       */
        tune_server = (AMQConnection.Tune)frame;

    try
    {
        frame = amq_framing.receiveFrame();
        tune_server = (AMQConnection.Tune)frame;
        amq_framing.setTuneParameters(tune_server);
        // Send the reply
        a_table = new AMQFieldTable();
        a_table.putInteger("FRAME_MAX", Math.min(frame_max, amq_framing.getFrameMax()));
        a_table.putInteger("HEARTBEAT", 0);
        client_tune.options = a_table.storeToBucket();
        amq_framing.sendFrame(client_tune);
        amq_framing.setTuneParameters(client_tune);
        if (verbose)
            System.out.println("I: Frame max: " + amq_framing.getFrameMax());
    }
    catch (ClassCastException e)
    {
        frame.dump();
        raise_exception(exception_event, e, "amqpci_java", "negotiate_connection_tune", "unexpected frame from server");
    }
    catch (SocketTimeoutException e) {
        raise_exception(timeout_event, e, "amqpci_java", "negotiate_connection_tune", "SocketTimeoutException");
    }
    catch (IOException e)
    {
        raise_exception(exception_event, e, "amqpci_java", "negotiate_connection_tune", "IOException");
    }
    catch (AMQException e)
    {
        raise_exception(exception_event, e, "amqpci_java", "negotiate_connection_tune", "tune error");
    }
}


/////////////////////////////////   SHUTDOWN   ////////////////////////////////

public void shutdown ()
{
}


//- Standard dialog routines --------------------------------------------
public void raise_exception (int event, Exception e, String _class, String module, String message)
{
    error_message = message;
    this.module = module;
    exception = e;

    if (e != null && !(e instanceof AMQException) && !(e instanceof AMQIOException))
        System.out.println("E: " + e.getMessage());
    System.err.println(_class + ": " + module + ": " + message + ".");

    // Reset exception
    exception = null;

    raise_exception (event);
}


//- Auxiliary routines --------------------------------------------
final byte[] body_fill(byte[] body, int seed, int len) {
    int a = 1664525, b = 1013904223;
    long m = ((long)1 << 32) - 1, v = seed;

    if (verbose)
        System.out.println("I: Filling message of size: " + len);
    // Fill with patterns from a linear congruential generator
    for (int i = 0; i < len; i++) {
        v = (a * v + b) & m;
        body[i] = (byte)v;
    }

    return body;
}

//%END MODULE
}
