Aliases: /docs/wrappers /docs/contribute /docs/community
Icon: github-alt


# Community plugins and articles



## Where to go
ImageResizer is [developed in the open on GitHub](http://github.com/imazen/resizer). We happily accept and test any [correctly licensed](/licenses/contribute) pull requests we receive against the 'develop' branch. We also try to promote third-party plugins.

[Ideas for new functionality can be posted to the UserVoice forum](http://resizer.uservoice.com/forums/108373-image-resizer) in order gauge general interest. If you have a clear picture of how to implement the feature, you should also open a GitHub issue and link the two. 

We try to track and support seamless integration with a wide range of CMSes, WYSIYG editors, and media tooling; but this is an area that we are quite dependent upon community (your!) expertise and support. We cannot be experts in all tools and all CMSes. 

Our open plugin model makes it simple to add server-side functionality, and our [rigorously standardized and backwards-compatible URL API](http://riapi.org) (along with [our client-side wrappers](https://github.com/nathanaeljones/studiojs)) make it easy to integrate on the front-end. 

**Also, check out [the Redistribution and CMS Integration Guide](/docs/redist) if you're interested in redistributing ImageResizer with your product.** We provide priority assistance to other open-source projects using ImageResizer. 
    
## Community Support

Many ImageResizer users [monitor Stack Overflow for questions tagged *imageresizer* (300+)](http://stackoverflow.com/questions/tagged/imageresizer), and may answer your question before we can get to it. 

Please be courteous; vote good answers up, and mark them as accepted. Make sure your questions include a gist with the diagnostics page output, and you've included all relevant details and detailed error messages. It's best to register and select a username instead of posting anonymously; anonymous posts are often considered spam.

We strongly suggest [reading the support page](/support) before posting, as nearly all common mistakes are explained there.

Confirmed bugs should also be reported via GitHub issues. 



## Community Plugins & Extensions

 We try to maintain a complete list of all plugins and CMS modules based on ImageResizer.

 * [**A Fluent API for ImageResizer by Ben Foster**](https://github.com/benfoster/ImageResizer.FluentExtensions)
 * [**Responsive web design for images: the ResponsivePresets plugin**](https://github.com/mindrevolution/ImageResizer-ResponsivePresets)
 * [**GUI image editor: StudioJS, a jQuery plugin**](https://github.com/nathanaeljones/studiojs)
 * [**Eksponent CropUp - Plugin for weighted semi-auto cropping**](http://cropup.codeplex.com/)
 * [**Slimmage - sane &amp; simple responsive images**](https://github.com/imazen/slimmage)
 * [Adaptive Images port by Hady Osman](https://github.com/hadynz/ImageResizer.Plugins.AdaptiveImages)
 * [jQuery NailThumb by Garralabs](http://www.garralab.com/nailthumb-serverside-demo.php)

### Umbraco Packages & Kits

* [HybridFramework Umbraco Starter Solution](https://github.com/jbreuer/Hybrid-Framework-Best-Practices)
* [uBootstrap](http://our.umbraco.org/projects/starter-kits/ubootstrap)
* [eksponent CropUp](http://our.umbraco.org/projects/website-utilities/eksponent-cropup)
* [Go Basic - Denmark government website starter kit](http://gobasic.dk/)
* [Umbraco Hybrid Framework](http://our.umbraco.org/projects/developer-tools/hybrid-framework)

### Orchard Modules
* [Image Power Tools Module for Orchard CMS (RIAPI friendly)](http://imagepowertools.codeplex.com/)
* [Building the Cascade Gallery for Orchard](http://bigsitesdoneright.com/big-blog/orchard-cascade-gallery-tutorial-series)
* [Orchard CMS Image MultiPicker (deprecated)](http://imagemultipicker.codeplex.com/)
* [Contrib.Thumbnails. Not RIAPI-compliant](https://github.com/pnmcosta/orchardcontribthumbnails/)
* [Orchard CMS ImageResizer. Not RIAPI-compliant.](http://orchardimageresizer.codeplex.com/)

**Click the edit button if we missed your plugin!**

   
## Popular Community Articles

* [Greg Duncan, Channel 9: Funny, you look bigger in real life... Server side image resizing with the free and open source ImageResizer](http://channel9.msdn.com/coding4fun/blog/Funny-you-look-bigger-in-real-life-Server-side-image-resizing-with-the-free-and-open-source-ImageRes)
* [Scott Hanselman: NuGet Package of the Week: ImageResizer](http://www.hanselman.com/blog/NuGetPackageOfWeek11ImageResizerEnablesCleanClearImageResizingInASPNET.aspx)
* [Scott Hanselman (podcast): Deep inside image resizing and scaling with ASP.NET and IIS, with ImageResizing.net author Nathanael Jones](http://www.hanselminutes.com/313/deep-inside-image-resizing-and-scaling-with-aspnet-and-iis-with-imageresizingnet-author-na)
* [Ben Foster: FluentExtensions for ImageResizer](https://github.com/benfoster/ImageResizer.FluentExtensions)
* [cskardon: Using ImageResizer on Azure 2.0](http://geekswithblogs.net/cskardon/archive/2013/02/26/imageresizer-azurereader2-and-wellhellip-azure-duh.aspx)
* [Dave Gardner: Building a Gallery Module for Orchard with ImageResizer (7-part series!)](http://bigsitesdoneright.com/big-blog/orchard-cascade-gallery-tutorial-series)
* [Frederik Vig: Add powerful image resizing, cropping and manipulation support to your EPiServer website](http://www.frederikvig.com/2013/01/add-powerful-image-resizing-cropping-and-manipulation-support-to-your-episerver-website/)
* [Nathanael Jones: 29 image resizing pitfalls](http://www.nathanaeljones.com/blog/2009/20-image-resizing-pitfalls)

* [How we built MSN UK's Responsive Olympics Site](http://www.netmagazine.com/features/how-we-built-msn-uks-responsive-olympics-site)
* [Scott Hanselman: Dynamic Image Generation](http://www.hanselman.com/blog/BackToBasicsDynamicImageGenerationASPNETControllersRoutingIHttpHandlersAndRunAllManagedModulesForAllRequests.aspx)
* [Bertrand Le Roy (Orchard author): State of .NET Image Resizing: how does imageresizer do?](http://weblogs.asp.net/bleroy/archive/2011/10/22/state-of-net-image-resizing-how-does-imageresizer-do.aspx) * Note the performance chart is bogus due to a mistake in the Bertrand's benchmark code. [The corrected chart](http://downloads.imageresizing.net/Oct29-2011-comparison.png) displays actual apples-to-apples data, instead of comparing low-quality and high-quality image resizing as the original benchmark does.
* [Anders Hattestad: Automatically change images in a responsive design to scale (EPiServer)](http://world.episerver.com/Blogs/Anders-Hattestad/Dates/2012/8/Automatically-change-images-in-a-responsive-design-to-scale/)
* [Nokia Developer Guide: Delivering image tiles to Windows Phone with ImageResizer](http://www.developer.nokia.com/Community/Wiki/Generating_Live_tiles_for_Windows_Phone_from_Live_Data#ImageResizer) (Note - while they're using an MVC action, we strongly suggest using the HttpModule instead if you wish to have caching work properly)
* [Nathanael Jones: Using JCrop with ImageResizer in 11 lines of javascript](http://nathanaeljones.com/573/combining-jcrop-and-server-side-image-resizing/)
* [heltBlank: Umbraco and ImageResizer](http://heltblank.wordpress.com/2012/02/13/imageresizing-net-and-umbraco-5-jupiter/)
* [uBootstrap for Umbraco](http://our.umbraco.org/projects/starter-kits/ubootstrap) now [includes ImageResizer to handle responsive imaging needs](http://jlusar.es/ubootstrap-fluent-layout)

There are also over [300 Stack Overflow posts about ImageResizer](http://stackoverflow.com/questions/tagged/imageresizer).




