// Copyright (c) Imazen LLC.
// No part of this project, including this file, may be copied, modified,
// propagated, or distributed except as permitted in COPYRIGHT.txt.
// Licensed under the GNU Affero General Public License, Version 3.0.
// Commercial licenses available at http://imageresizing.net/

using System.Collections.Specialized;

namespace ImageResizer.Plugins.RemoteReader
{
    public delegate void RemoteRequest(object sender, RemoteRequestEventArgs args);

    public class RemoteRequestEventArgs
    {
        private string remoteUrl = null;

        /// <summary>
        ///     The URL to the remotely hosted image.
        /// </summary>
        public string RemoteUrl
        {
            get => remoteUrl;
            set => remoteUrl = value;
        }

        private NameValueCollection queryString = null;

        /// <summary>
        ///     Resizing settings. These are not signed - other parties can manipulate them.
        /// </summary>
        public NameValueCollection QueryString
        {
            get => queryString;
            set => queryString = value;
        }

        private bool signedRequest = false;

        /// <summary>
        ///     True if the remote URL was (correctly) signed with an HMAC SHA-256 to verify that it had not be altered since it
        ///     was generated by the same server (or another server with the same key).
        /// </summary>
        public bool SignedRequest
        {
            get => signedRequest;
            set => signedRequest = value;
        }

        /// <summary>
        ///     True to deny the request
        /// </summary>
        private bool denyRequest = true;

        public bool DenyRequest
        {
            get => denyRequest;
            set => denyRequest = value;
        }
    }
}