/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/rook/rook/pkg/apis/ceph.rook.io/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// CephObjectZoneGroupLister helps list CephObjectZoneGroups.
// All objects returned here must be treated as read-only.
type CephObjectZoneGroupLister interface {
	// List lists all CephObjectZoneGroups in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.CephObjectZoneGroup, err error)
	// CephObjectZoneGroups returns an object that can list and get CephObjectZoneGroups.
	CephObjectZoneGroups(namespace string) CephObjectZoneGroupNamespaceLister
	CephObjectZoneGroupListerExpansion
}

// cephObjectZoneGroupLister implements the CephObjectZoneGroupLister interface.
type cephObjectZoneGroupLister struct {
	indexer cache.Indexer
}

// NewCephObjectZoneGroupLister returns a new CephObjectZoneGroupLister.
func NewCephObjectZoneGroupLister(indexer cache.Indexer) CephObjectZoneGroupLister {
	return &cephObjectZoneGroupLister{indexer: indexer}
}

// List lists all CephObjectZoneGroups in the indexer.
func (s *cephObjectZoneGroupLister) List(selector labels.Selector) (ret []*v1.CephObjectZoneGroup, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.CephObjectZoneGroup))
	})
	return ret, err
}

// CephObjectZoneGroups returns an object that can list and get CephObjectZoneGroups.
func (s *cephObjectZoneGroupLister) CephObjectZoneGroups(namespace string) CephObjectZoneGroupNamespaceLister {
	return cephObjectZoneGroupNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// CephObjectZoneGroupNamespaceLister helps list and get CephObjectZoneGroups.
// All objects returned here must be treated as read-only.
type CephObjectZoneGroupNamespaceLister interface {
	// List lists all CephObjectZoneGroups in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.CephObjectZoneGroup, err error)
	// Get retrieves the CephObjectZoneGroup from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1.CephObjectZoneGroup, error)
	CephObjectZoneGroupNamespaceListerExpansion
}

// cephObjectZoneGroupNamespaceLister implements the CephObjectZoneGroupNamespaceLister
// interface.
type cephObjectZoneGroupNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all CephObjectZoneGroups in the indexer for a given namespace.
func (s cephObjectZoneGroupNamespaceLister) List(selector labels.Selector) (ret []*v1.CephObjectZoneGroup, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.CephObjectZoneGroup))
	})
	return ret, err
}

// Get retrieves the CephObjectZoneGroup from the indexer for a given namespace and name.
func (s cephObjectZoneGroupNamespaceLister) Get(name string) (*v1.CephObjectZoneGroup, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("cephobjectzonegroup"), name)
	}
	return obj.(*v1.CephObjectZoneGroup), nil
}
