// eslint-disable-next-line no-use-before-define
import * as React from 'react'
import { View, Image, Platform } from 'react-native'

interface BackButtonProps {
  tintColor: string
}
export const blackArrow = 'data:image/png;base64,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'

export const whiteArrow = 'data:image/png;base64,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'

export default class BackButton extends React.PureComponent<BackButtonProps> {
  // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
  render () {
    const { tintColor = '#ffffff' } = this.props
    const color = tintColor.toLowerCase()
    const imageSource = (color === '#ffffff' || color === 'white' || color === '#fff') ? whiteArrow : blackArrow
    return <View style={{ marginHorizontal: Platform.OS === 'ios' ? 10 : 0, marginRight: 25, marginVertical: 10 }}>
      <Image
        style={{ width: 22, height: 22 }}
        source={{ uri: imageSource }}
      />
    </View>
  }
}
