const { jsWithTs: tsjPreset } = require('ts-jest/presets')

module.exports = {
  testEnvironment: 'jsdom',
  transform: {
    ...tsjPreset.transform
  },
  testURL: 'http://localhost/',
  moduleFileExtensions: [
    'ts',
    'tsx',
    'js',
    'jsx',
    'json',
    'node'
  ],
  globals: {
    'ts-jest': {
      diagnostics: false,
      tsConfig: {
        jsx: 'react',
        allowJs: true,
        target: 'ES6'
      }
    }
  },
  testPathIgnorePatterns: [
    'node_modules',
    'utils'
  ]
}
