from nesi.softbox.api import db


class Emu(db.Model):
    id = db.Column(db.Integer(), primary_key=True)
    name = db.Column(db.String(64))
    box_id = db.Column(db.Integer, db.ForeignKey('box.id'))
    number = db.Column(db.Integer(), nullable=False, unique=True)
    type = db.Column(db.Enum('FAN', 'H831PMU', 'H831VESC'), default='H831VESC')
    emu_state = db.Column(db.Enum('Normal', 'fail'), default='Normal')
    used = db.Column(db.Enum('Used', 'Not'), default='Used')
    frame_id = db.Column(db.Integer(), default=0)
    subnode = db.Column(db.Integer(), default=0)
    com_port = db.Column(db.Enum('RS232', 'RS485'), default='RS232')
    limit_state = db.Column(db.String(), default='No limit')
    charge_state = db.Column(db.Enum('Charged', 'Floating'), default='Floating')
    charge_control = db.Column(db.Enum('Automatic control'), default='Automatic control')
    module_number = db.Column(db.Integer(), default=1)
    module_0_address = db.Column(db.Integer(), default=0)
    module_0_type = db.Column(db.Enum('AC/DC'), default='AC/DC')
    module_0_current = db.Column(db.String(), default='1.20A')
    module_0_voltage = db.Column(db.String(), default='53.75V')
    battery_capacity = db.Column(db.Integer(), default=100)
    battery_0_current = db.Column(db.String(), default='0.00A')
    dc_voltage = db.Column(db.String(), default='52.91V')
