# This file is part of the NESi software.
#
# Copyright (c) 2020
# Original Software Design by Ilya Etingof <https://github.com/etingof>.
#
# Software adapted by inexio <https://github.com/inexio>.
# - Janis Groß <https://github.com/unkn0wn-user>
# - Philip Konrath <https://github.com/Connyko65>
# - Alexander Dincher <https://github.com/Dinker1996>
# - Philipp-Noah Groß <https://github.com/pngross>
#
# License: https://github.com/inexio/NESi/LICENSE.rst
import uuid
from nesi.softbox.api import db


class Srvc(db.Model):
    id = db.Column(db.Integer(), primary_key=True)
    name = db.Column(db.String(64))
    box_id = db.Column(db.Integer, db.ForeignKey('box.id'))
    service_type = db.Column(db.Enum('1to1doubletag', '1to1singletag', 'mcast', 'nto1', 'pls', 'tls'))
    address = db.Column(db.String(), default='')
    svid = db.Column(db.Integer(), default=None)
    stag_priority = db.Column(db.Enum('CoS0', 'CoS1', 'CoS2', 'CoS3', 'CoS4', 'CoS5', 'CoS6', 'CoS7'), default=None)
    vlan_handling = db.Column(db.Enum('Add', 'Transparent', 'Swap'), default=None)
