import{_ as r,C as t,o as E,c as y,H as n,w as o,k as s,a,Q as p}from"./chunks/framework.f0e9ff50.js";const bs=JSON.parse('{"title":"星盘","description":"iztro紫微斗数星盘介绍，iztro的astro对象使用方法以及示例代码。","frontmatter":{"outline":"deep","description":"iztro紫微斗数星盘介绍，iztro的astro对象使用方法以及示例代码。"},"headers":[],"relativePath":"posts/astrolabe.md","filePath":"posts/astrolabe.md"}'),i={name:"posts/astrolabe.md"},F=p('<h1 id="星盘" tabindex="-1">星盘 <a class="header-anchor" href="#星盘" aria-label="Permalink to &quot;星盘&quot;">​</a></h1><h3 id="概述" tabindex="-1">概述 <a class="header-anchor" href="#概述" aria-label="Permalink to &quot;概述&quot;">​</a></h3><p>紫微斗数星盘又叫紫微斗数命盘，是由 <code>十二个宫位</code> 和一个 <code>中宫</code> 构成，宫位的 <code>地支</code> 是固定的，并且是由 <code>寅</code> 开始，而不是由 <code>子</code> 开始。这是因为农历的正月是寅月，这就是所谓的 <code>正月建寅</code>。在 <code>iztro</code> 里面，<code>寅宫</code> 的索引是 <code>0</code>，<code>卯宫</code> 的索引是 <code>1</code>，如此按照顺时针的方向排列。如下面表格所示：</p><table class="astrolabe"><tr><td>巳 <code>3</code></td><td>午 <code>4</code></td><td>未 <code>5</code></td><td>申 <code>6</code></td></tr><tr><td>辰 <code>2</code></td><td class="center-palace" rowspan="2" colspan="2">中宫</td><td>酉 <code>7</code></td></tr><tr><td>卯 <code>1</code></td><td>戌 <code>8</code></td></tr><tr><td>寅 <code>0</code></td><td>丑 <code>11</code></td><td>子 <code>10</code></td><td>亥 <code>9</code></td></tr></table><p><code>中宫</code> 通常可以用来展示任何你想展示的信息，一般不会对整个星盘产生影响。周围的 <code>十二宫</code> 用于存放星耀，四化，运限，宫位名称等信息。关于 <code>宫位</code> 的详细信息，可以进入 <a href="./palace.html">宫位传送门</a> 查看详细介绍，本页面主要关注星盘的信息。紫微斗数星盘是由宫位和星耀组成的，如果你还没有建立起它们的概念，我们强烈推荐你进入 <a href="/learn/basis.html">传送门</a> 开始学习有趣的紫微斗数知识。</p><p>在安装好 <code>iztro</code> 依赖以后你可以用如下代码将 <code>星盘(astro)</code> 对象引入你的代码。如果你还不知道如何安装 <code>iztro</code>，请点击 <a href="/quick-start.html#安装">传送门</a> 跳转到相关说明文档。</p><h3 id="astro-的静态方法" tabindex="-1"><code>astro</code> 的静态方法 <a class="header-anchor" href="#astro-的静态方法" aria-label="Permalink to &quot;`astro` 的静态方法&quot;">​</a></h3><p>要使用该对象的静态方法，请先将该对象 <code>import</code> 到你的代码里</p>',8),d=s("div",{class:"language-ts vp-adaptive-theme"},[s("button",{title:"Copy Code",class:"copy"}),s("span",{class:"lang"},"ts"),s("pre",{class:"shiki github-dark vp-code-dark"},[s("code",null,[s("span",{class:"line"},[s("span",{style:{color:"#F97583"}},"import"),s("span",{style:{color:"#E1E4E8"}}," { astro } "),s("span",{style:{color:"#F97583"}},"from"),s("span",{style:{color:"#E1E4E8"}}," "),s("span",{style:{color:"#9ECBFF"}},'"iztro"'),s("span",{style:{color:"#E1E4E8"}},";")])])]),s("pre",{class:"shiki github-light vp-code-light"},[s("code",null,[s("span",{class:"line"},[s("span",{style:{color:"#D73A49"}},"import"),s("span",{style:{color:"#24292E"}}," { astro } "),s("span",{style:{color:"#D73A49"}},"from"),s("span",{style:{color:"#24292E"}}," "),s("span",{style:{color:"#032F62"}},'"iztro"'),s("span",{style:{color:"#24292E"}},";")])])])],-1),C=s("div",{class:"language-js vp-adaptive-theme"},[s("button",{title:"Copy Code",class:"copy"}),s("span",{class:"lang"},"js"),s("pre",{class:"shiki github-dark vp-code-dark"},[s("code",null,[s("span",{class:"line"},[s("span",{style:{color:"#F97583"}},"var"),s("span",{style:{color:"#E1E4E8"}}," { astro } "),s("span",{style:{color:"#F97583"}},"="),s("span",{style:{color:"#E1E4E8"}}," "),s("span",{style:{color:"#B392F0"}},"require"),s("span",{style:{color:"#E1E4E8"}},"("),s("span",{style:{color:"#9ECBFF"}},'"iztro"'),s("span",{style:{color:"#E1E4E8"}},");")])])]),s("pre",{class:"shiki github-light vp-code-light"},[s("code",null,[s("span",{class:"line"},[s("span",{style:{color:"#D73A49"}},"var"),s("span",{style:{color:"#24292E"}}," { astro } "),s("span",{style:{color:"#D73A49"}},"="),s("span",{style:{color:"#24292E"}}," "),s("span",{style:{color:"#6F42C1"}},"require"),s("span",{style:{color:"#24292E"}},"("),s("span",{style:{color:"#032F62"}},'"iztro"'),s("span",{style:{color:"#24292E"}},");")])])])],-1),h=p(`<hr><h4 id="astrolabebysolardate" tabindex="-1">astrolabeBySolarDate <a class="header-anchor" href="#astrolabebysolardate" aria-label="Permalink to &quot;astrolabeBySolarDate&quot;">​</a></h4><ul><li><p>用途</p><p>通过阳历获取星盘信息</p></li><li><p>定义</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">export</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">type</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">astrolabeBySolarDate</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> (</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#FFAB70;">solarDateStr</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">string</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#FFAB70;">timeIndex</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">number</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#FFAB70;">gender</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">GenderName</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#FFAB70;">fixLeap</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;"> = </span><span style="color:#79B8FF;">true</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#FFAB70;">language</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">Language</span><span style="color:#E1E4E8;"> = </span><span style="color:#9ECBFF;">&quot;zh-CN&quot;</span></span>
<span class="line"><span style="color:#E1E4E8;">) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">FunctionalAstrolabe</span><span style="color:#E1E4E8;">;</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">export</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">type</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">astrolabeBySolarDate</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> (</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#E36209;">solarDateStr</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">string</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#E36209;">timeIndex</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">number</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#E36209;">gender</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">GenderName</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#E36209;">fixLeap</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;"> = </span><span style="color:#005CC5;">true</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#E36209;">language</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">Language</span><span style="color:#24292E;"> = </span><span style="color:#032F62;">&quot;zh-CN&quot;</span></span>
<span class="line"><span style="color:#24292E;">) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">FunctionalAstrolabe</span><span style="color:#24292E;">;</span></span></code></pre></div></li><li><p>参数</p><table><thead><tr><th>参数</th><th>类型</th><th>是否必填</th><th>默认值</th><th>说明</th></tr></thead><tbody><tr><td>solarDateStr</td><td><code>string</code></td><td><code>true</code></td><td>-</td><td>阳历日期【YYYY-M-D】</td></tr><tr><td>timeIndex</td><td><code>number</code></td><td><code>true</code></td><td>-</td><td>出生时辰序号【0~12】，对应从早子时（0）一直到晚子时（12）的序号</td></tr><tr><td>gender</td><td><a href="/type-definition.html#gendername"><code>GenderName</code></a></td><td><code>true</code></td><td>-</td><td>性别【男/女】</td></tr><tr><td>fixLeap</td><td><code>boolean</code></td><td><code>false</code></td><td><code>true</code></td><td>是否调整闰月，为<code>true</code>闰月的前半个月算上个月，后半个月算下个月</td></tr><tr><td>language</td><td><a href="./../type-definition.html#language"><code>Language</code></a></td><td><code>false</code></td><td><code>zh-CN</code></td><td>返回数据将被国际化为指定语言。目前支持 <code>zh-CN</code>,<code>zh-TW</code>,<code>en-US</code>,<code>ko-KR</code> 和 <code>ja-JP</code></td></tr></tbody></table></li><li><p>返回值</p><p><a href="./astrolabe.html#functionalastrolabe"><code>FunctionalAstrolabe</code></a></p></li><li><p>示例</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">import</span><span style="color:#E1E4E8;"> { astro } </span><span style="color:#F97583;">from</span><span style="color:#E1E4E8;"> </span><span style="color:#9ECBFF;">&quot;iztro&quot;</span><span style="color:#E1E4E8;">;</span></span>
<span class="line"></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">astrolabe</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astro.</span><span style="color:#B392F0;">astrolabeBySolarDate</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;2000-8-16&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">2</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;女&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">true</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;zh-CN&quot;</span><span style="color:#E1E4E8;">);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">import</span><span style="color:#24292E;"> { astro } </span><span style="color:#D73A49;">from</span><span style="color:#24292E;"> </span><span style="color:#032F62;">&quot;iztro&quot;</span><span style="color:#24292E;">;</span></span>
<span class="line"></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">astrolabe</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astro.</span><span style="color:#6F42C1;">astrolabeBySolarDate</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;2000-8-16&quot;</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">2</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;女&quot;</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">true</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;zh-CN&quot;</span><span style="color:#24292E;">);</span></span></code></pre></div></li><li><p>示例返回值</p><details class="details custom-block"><summary>返回值</summary><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#E1E4E8;">{</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#6A737D;">// 阳历日期</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#B392F0;">solarDate</span><span style="color:#E1E4E8;">: </span><span style="color:#9ECBFF;">&#39;2000-8-16&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#6A737D;">// 农历日期</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#B392F0;">lunarDate</span><span style="color:#E1E4E8;">: </span><span style="color:#9ECBFF;">&#39;二〇〇〇年七月十七&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#6A737D;">// 四柱</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#B392F0;">chineseDate</span><span style="color:#E1E4E8;">: </span><span style="color:#9ECBFF;">&#39;庚辰 甲申 丙午 庚寅&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#6A737D;">// 时辰</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#B392F0;">time</span><span style="color:#E1E4E8;">: </span><span style="color:#9ECBFF;">&#39;寅时&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#6A737D;">// 时辰对应的时间段</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#B392F0;">timeRange</span><span style="color:#E1E4E8;">: </span><span style="color:#9ECBFF;">&#39;03:00~05:00&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#6A737D;">// 星座</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#B392F0;">sign</span><span style="color:#E1E4E8;">: </span><span style="color:#9ECBFF;">&#39;狮子座&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#6A737D;">// 生肖</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#B392F0;">zodiac</span><span style="color:#E1E4E8;">: </span><span style="color:#9ECBFF;">&#39;龙&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#6A737D;">// 命宫地支</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#B392F0;">earthlyBranchOfSoulPalace</span><span style="color:#E1E4E8;">: </span><span style="color:#9ECBFF;">&#39;午&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#6A737D;">// 身宫地支</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#B392F0;">earthlyBranchOfBodyPalace</span><span style="color:#E1E4E8;">: </span><span style="color:#9ECBFF;">&#39;戌&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#6A737D;">// 命主</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#B392F0;">soul</span><span style="color:#E1E4E8;">: </span><span style="color:#9ECBFF;">&#39;破军&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#6A737D;">// 身主</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#B392F0;">body</span><span style="color:#E1E4E8;">: </span><span style="color:#9ECBFF;">&#39;文昌&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#6A737D;">// 五行局</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#B392F0;">fiveElementsClass</span><span style="color:#E1E4E8;">: </span><span style="color:#9ECBFF;">&#39;木三局&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#6A737D;">// 十二宫数据</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#B392F0;">palaces</span><span style="color:#E1E4E8;">: [</span></span>
<span class="line"><span style="color:#E1E4E8;">    {</span></span>
<span class="line"><span style="color:#E1E4E8;">      </span><span style="color:#6A737D;">// 宫名</span></span>
<span class="line"><span style="color:#E1E4E8;">      name: </span><span style="color:#9ECBFF;">&#39;财帛&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      </span><span style="color:#6A737D;">// 是否身宫</span></span>
<span class="line"><span style="color:#E1E4E8;">      isBodyPalace: </span><span style="color:#79B8FF;">false</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      </span><span style="color:#6A737D;">// 是否来因宫</span></span>
<span class="line"><span style="color:#E1E4E8;">      isOriginalPalace: </span><span style="color:#79B8FF;">false</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      </span><span style="color:#6A737D;">// 宫位天干</span></span>
<span class="line"><span style="color:#E1E4E8;">      heavenlyStem: </span><span style="color:#9ECBFF;">&#39;戊&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      </span><span style="color:#6A737D;">// 宫位地支</span></span>
<span class="line"><span style="color:#E1E4E8;">      earthlyBranch: </span><span style="color:#9ECBFF;">&#39;寅&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      </span><span style="color:#6A737D;">// 主星（含天马禄存）</span></span>
<span class="line"><span style="color:#E1E4E8;">      majorStars: [</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;武曲&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;major&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;">, brightness: </span><span style="color:#9ECBFF;">&#39;得&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;天相&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;major&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;">, brightness: </span><span style="color:#9ECBFF;">&#39;庙&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;天马&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;tianma&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;">, brightness: </span><span style="color:#9ECBFF;">&#39;&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">      ],</span></span>
<span class="line"><span style="color:#E1E4E8;">      </span><span style="color:#6A737D;">// 辅星（含六吉六煞）</span></span>
<span class="line"><span style="color:#E1E4E8;">      minorStars: [],</span></span>
<span class="line"><span style="color:#E1E4E8;">      </span><span style="color:#6A737D;">// 杂耀</span></span>
<span class="line"><span style="color:#E1E4E8;">      adjectiveStars: [</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;月解&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;helper&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;三台&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;adjective&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;天寿&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;adjective&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;天巫&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;adjective&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;天厨&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;adjective&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;阴煞&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;adjective&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;天哭&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;adjective&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">      ],</span></span>
<span class="line"><span style="color:#E1E4E8;">      </span><span style="color:#6A737D;">// 长生12神</span></span>
<span class="line"><span style="color:#E1E4E8;">      changsheng12: </span><span style="color:#9ECBFF;">&#39;绝&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      </span><span style="color:#6A737D;">// 博士12神</span></span>
<span class="line"><span style="color:#E1E4E8;">      boshi12: </span><span style="color:#9ECBFF;">&#39;蜚廉&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      </span><span style="color:#6A737D;">// 流年将前12神</span></span>
<span class="line"><span style="color:#E1E4E8;">      jiangqian12: </span><span style="color:#9ECBFF;">&#39;岁驿&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      </span><span style="color:#6A737D;">// 流年岁前12神</span></span>
<span class="line"><span style="color:#E1E4E8;">      suiqian12: </span><span style="color:#9ECBFF;">&#39;吊客&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      </span><span style="color:#6A737D;">// 大限</span></span>
<span class="line"><span style="color:#E1E4E8;">      stage: { range: [</span><span style="color:#79B8FF;">44</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">53</span><span style="color:#E1E4E8;">], heavenlyStem: </span><span style="color:#9ECBFF;">&#39;戊&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">      </span><span style="color:#6A737D;">// 小限</span></span>
<span class="line"><span style="color:#E1E4E8;">      ages: [</span><span style="color:#79B8FF;">9</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">21</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">33</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">45</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">57</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">69</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">81</span><span style="color:#E1E4E8;">],</span></span>
<span class="line"><span style="color:#E1E4E8;">    },</span></span>
<span class="line"><span style="color:#E1E4E8;">    {</span></span>
<span class="line"><span style="color:#E1E4E8;">      name: </span><span style="color:#9ECBFF;">&#39;子女&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      isBodyPalace: </span><span style="color:#79B8FF;">false</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      isOriginalPalace: </span><span style="color:#79B8FF;">false</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      heavenlyStem: </span><span style="color:#9ECBFF;">&#39;己&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      earthlyBranch: </span><span style="color:#9ECBFF;">&#39;卯&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      majorStars: [</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;太阳&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;major&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;">, brightness: </span><span style="color:#9ECBFF;">&#39;庙&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;天梁&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;major&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;">, brightness: </span><span style="color:#9ECBFF;">&#39;庙&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">      ],</span></span>
<span class="line"><span style="color:#E1E4E8;">      minorStars: [],</span></span>
<span class="line"><span style="color:#E1E4E8;">      adjectiveStars: [{ name: </span><span style="color:#9ECBFF;">&#39;天刑&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;adjective&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;"> }],</span></span>
<span class="line"><span style="color:#E1E4E8;">      changsheng12: </span><span style="color:#9ECBFF;">&#39;墓&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      boshi12: </span><span style="color:#9ECBFF;">&#39;奏书&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      jiangqian12: </span><span style="color:#9ECBFF;">&#39;息神&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      suiqian12: </span><span style="color:#9ECBFF;">&#39;病符&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      stage: { range: [</span><span style="color:#79B8FF;">34</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">43</span><span style="color:#E1E4E8;">], heavenlyStem: </span><span style="color:#9ECBFF;">&#39;己&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">      ages: [</span><span style="color:#79B8FF;">8</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">20</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">32</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">44</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">56</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">68</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">80</span><span style="color:#E1E4E8;">],</span></span>
<span class="line"><span style="color:#E1E4E8;">    },</span></span>
<span class="line"><span style="color:#E1E4E8;">    {</span></span>
<span class="line"><span style="color:#E1E4E8;">      name: </span><span style="color:#9ECBFF;">&#39;夫妻&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      isBodyPalace: </span><span style="color:#79B8FF;">false</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      isOriginalPalace: </span><span style="color:#79B8FF;">true</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      heavenlyStem: </span><span style="color:#9ECBFF;">&#39;庚&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      earthlyBranch: </span><span style="color:#9ECBFF;">&#39;辰&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      majorStars: [{ name: </span><span style="color:#9ECBFF;">&#39;七杀&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;major&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;">, brightness: </span><span style="color:#9ECBFF;">&#39;庙&#39;</span><span style="color:#E1E4E8;"> }],</span></span>
<span class="line"><span style="color:#E1E4E8;">      minorStars: [</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;右弼&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;soft&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;">, brightness: </span><span style="color:#9ECBFF;">&#39;&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;火星&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;tough&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;">, brightness: </span><span style="color:#9ECBFF;">&#39;陷&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">      ],</span></span>
<span class="line"><span style="color:#E1E4E8;">      adjectiveStars: [</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;封诰&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;adjective&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;华盖&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;adjective&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">      ],</span></span>
<span class="line"><span style="color:#E1E4E8;">      changsheng12: </span><span style="color:#9ECBFF;">&#39;死&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      boshi12: </span><span style="color:#9ECBFF;">&#39;将军&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      jiangqian12: </span><span style="color:#9ECBFF;">&#39;华盖&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      suiqian12: </span><span style="color:#9ECBFF;">&#39;岁建&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      stage: { range: [</span><span style="color:#79B8FF;">24</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">33</span><span style="color:#E1E4E8;">], heavenlyStem: </span><span style="color:#9ECBFF;">&#39;庚&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">      ages: [</span><span style="color:#79B8FF;">7</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">19</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">31</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">43</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">55</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">67</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">79</span><span style="color:#E1E4E8;">],</span></span>
<span class="line"><span style="color:#E1E4E8;">    },</span></span>
<span class="line"><span style="color:#E1E4E8;">    {</span></span>
<span class="line"><span style="color:#E1E4E8;">      name: </span><span style="color:#9ECBFF;">&#39;兄弟&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      isBodyPalace: </span><span style="color:#79B8FF;">false</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      isOriginalPalace: </span><span style="color:#79B8FF;">false</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      heavenlyStem: </span><span style="color:#9ECBFF;">&#39;辛&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      earthlyBranch: </span><span style="color:#9ECBFF;">&#39;巳&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      majorStars: [{ name: </span><span style="color:#9ECBFF;">&#39;天机&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;major&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;">, brightness: </span><span style="color:#9ECBFF;">&#39;平&#39;</span><span style="color:#E1E4E8;"> }],</span></span>
<span class="line"><span style="color:#E1E4E8;">      minorStars: [],</span></span>
<span class="line"><span style="color:#E1E4E8;">      adjectiveStars: [</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;天喜&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;flower&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;天空&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;adjective&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;孤辰&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;adjective&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">      ],</span></span>
<span class="line"><span style="color:#E1E4E8;">      changsheng12: </span><span style="color:#9ECBFF;">&#39;病&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      boshi12: </span><span style="color:#9ECBFF;">&#39;小耗&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      jiangqian12: </span><span style="color:#9ECBFF;">&#39;劫煞&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      suiqian12: </span><span style="color:#9ECBFF;">&#39;晦气&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      stage: { range: [</span><span style="color:#79B8FF;">14</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">23</span><span style="color:#E1E4E8;">], heavenlyStem: </span><span style="color:#9ECBFF;">&#39;辛&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">      ages: [</span><span style="color:#79B8FF;">6</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">18</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">30</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">42</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">54</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">66</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">78</span><span style="color:#E1E4E8;">],</span></span>
<span class="line"><span style="color:#E1E4E8;">    },</span></span>
<span class="line"><span style="color:#E1E4E8;">    {</span></span>
<span class="line"><span style="color:#E1E4E8;">      name: </span><span style="color:#9ECBFF;">&#39;命宫&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      isBodyPalace: </span><span style="color:#79B8FF;">false</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      isOriginalPalace: </span><span style="color:#79B8FF;">false</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      heavenlyStem: </span><span style="color:#9ECBFF;">&#39;壬&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      earthlyBranch: </span><span style="color:#9ECBFF;">&#39;午&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      majorStars: [{ name: </span><span style="color:#9ECBFF;">&#39;紫微&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;major&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;">, brightness: </span><span style="color:#9ECBFF;">&#39;庙&#39;</span><span style="color:#E1E4E8;"> }],</span></span>
<span class="line"><span style="color:#E1E4E8;">      minorStars: [{ name: </span><span style="color:#9ECBFF;">&#39;文曲&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;soft&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;">, brightness: </span><span style="color:#9ECBFF;">&#39;陷&#39;</span><span style="color:#E1E4E8;"> }],</span></span>
<span class="line"><span style="color:#E1E4E8;">      adjectiveStars: [</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;年解&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;helper&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;凤阁&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;adjective&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;天福&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;adjective&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;截路&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;adjective&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;蜚廉&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;adjective&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">      ],</span></span>
<span class="line"><span style="color:#E1E4E8;">      changsheng12: </span><span style="color:#9ECBFF;">&#39;衰&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      boshi12: </span><span style="color:#9ECBFF;">&#39;青龙&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      jiangqian12: </span><span style="color:#9ECBFF;">&#39;灾煞&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      suiqian12: </span><span style="color:#9ECBFF;">&#39;丧门&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      stage: { range: [</span><span style="color:#79B8FF;">4</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">13</span><span style="color:#E1E4E8;">], heavenlyStem: </span><span style="color:#9ECBFF;">&#39;壬&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">      ages: [</span><span style="color:#79B8FF;">5</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">17</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">29</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">41</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">53</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">65</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">77</span><span style="color:#E1E4E8;">],</span></span>
<span class="line"><span style="color:#E1E4E8;">    },</span></span>
<span class="line"><span style="color:#E1E4E8;">    {</span></span>
<span class="line"><span style="color:#E1E4E8;">      name: </span><span style="color:#9ECBFF;">&#39;父母&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      isBodyPalace: </span><span style="color:#79B8FF;">false</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      isOriginalPalace: </span><span style="color:#79B8FF;">false</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      heavenlyStem: </span><span style="color:#9ECBFF;">&#39;癸&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      earthlyBranch: </span><span style="color:#9ECBFF;">&#39;未&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      majorStars: [],</span></span>
<span class="line"><span style="color:#E1E4E8;">      minorStars: [</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;天钺&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;soft&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;">, brightness: </span><span style="color:#9ECBFF;">&#39;&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;陀罗&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;tough&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;">, brightness: </span><span style="color:#9ECBFF;">&#39;庙&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">      ],</span></span>
<span class="line"><span style="color:#E1E4E8;">      adjectiveStars: [</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;天姚&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;flower&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;空亡&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;adjective&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">      ],</span></span>
<span class="line"><span style="color:#E1E4E8;">      changsheng12: </span><span style="color:#9ECBFF;">&#39;帝旺&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      boshi12: </span><span style="color:#9ECBFF;">&#39;力士&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      jiangqian12: </span><span style="color:#9ECBFF;">&#39;天煞&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      suiqian12: </span><span style="color:#9ECBFF;">&#39;贯索&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      stage: { range: [</span><span style="color:#79B8FF;">114</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">123</span><span style="color:#E1E4E8;">], heavenlyStem: </span><span style="color:#9ECBFF;">&#39;癸&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">      ages: [</span><span style="color:#79B8FF;">4</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">16</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">28</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">40</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">52</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">64</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">76</span><span style="color:#E1E4E8;">],</span></span>
<span class="line"><span style="color:#E1E4E8;">    },</span></span>
<span class="line"><span style="color:#E1E4E8;">    {</span></span>
<span class="line"><span style="color:#E1E4E8;">      name: </span><span style="color:#9ECBFF;">&#39;福德&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      isBodyPalace: </span><span style="color:#79B8FF;">false</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      isOriginalPalace: </span><span style="color:#79B8FF;">false</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      heavenlyStem: </span><span style="color:#9ECBFF;">&#39;甲&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      earthlyBranch: </span><span style="color:#9ECBFF;">&#39;申&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      majorStars: [</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;破军&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;major&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;">, brightness: </span><span style="color:#9ECBFF;">&#39;得&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;禄存&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;lucun&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;">, brightness: </span><span style="color:#9ECBFF;">&#39;&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">      ],</span></span>
<span class="line"><span style="color:#E1E4E8;">      minorStars: [{ name: </span><span style="color:#9ECBFF;">&#39;文昌&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;soft&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;">, brightness: </span><span style="color:#9ECBFF;">&#39;得&#39;</span><span style="color:#E1E4E8;"> }],</span></span>
<span class="line"><span style="color:#E1E4E8;">      adjectiveStars: [</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;龙池&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;adjective&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;台辅&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;adjective&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;旬空&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;adjective&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">      ],</span></span>
<span class="line"><span style="color:#E1E4E8;">      changsheng12: </span><span style="color:#9ECBFF;">&#39;临官&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      boshi12: </span><span style="color:#9ECBFF;">&#39;博士&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      jiangqian12: </span><span style="color:#9ECBFF;">&#39;指背&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      suiqian12: </span><span style="color:#9ECBFF;">&#39;官符&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      stage: { range: [</span><span style="color:#79B8FF;">104</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">113</span><span style="color:#E1E4E8;">], heavenlyStem: </span><span style="color:#9ECBFF;">&#39;甲&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">      ages: [</span><span style="color:#79B8FF;">3</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">15</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">27</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">39</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">51</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">63</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">75</span><span style="color:#E1E4E8;">],</span></span>
<span class="line"><span style="color:#E1E4E8;">    },</span></span>
<span class="line"><span style="color:#E1E4E8;">    {</span></span>
<span class="line"><span style="color:#E1E4E8;">      name: </span><span style="color:#9ECBFF;">&#39;田宅&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      isBodyPalace: </span><span style="color:#79B8FF;">false</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      isOriginalPalace: </span><span style="color:#79B8FF;">false</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      heavenlyStem: </span><span style="color:#9ECBFF;">&#39;乙&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      earthlyBranch: </span><span style="color:#9ECBFF;">&#39;酉&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      majorStars: [],</span></span>
<span class="line"><span style="color:#E1E4E8;">      minorStars: [</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;地空&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;tough&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;">, brightness: </span><span style="color:#9ECBFF;">&#39;&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;擎羊&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;tough&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;">, brightness: </span><span style="color:#9ECBFF;">&#39;陷&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">      ],</span></span>
<span class="line"><span style="color:#E1E4E8;">      adjectiveStars: [</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;咸池&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;flower&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;天贵&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;adjective&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;月德&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;adjective&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">      ],</span></span>
<span class="line"><span style="color:#E1E4E8;">      changsheng12: </span><span style="color:#9ECBFF;">&#39;冠带&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      boshi12: </span><span style="color:#9ECBFF;">&#39;官府&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      jiangqian12: </span><span style="color:#9ECBFF;">&#39;咸池&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      suiqian12: </span><span style="color:#9ECBFF;">&#39;小耗&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      stage: { range: [</span><span style="color:#79B8FF;">94</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">103</span><span style="color:#E1E4E8;">], heavenlyStem: </span><span style="color:#9ECBFF;">&#39;乙&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">      ages: [</span><span style="color:#79B8FF;">2</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">14</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">26</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">38</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">50</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">62</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">74</span><span style="color:#E1E4E8;">],</span></span>
<span class="line"><span style="color:#E1E4E8;">    },</span></span>
<span class="line"><span style="color:#E1E4E8;">    {</span></span>
<span class="line"><span style="color:#E1E4E8;">      name: </span><span style="color:#9ECBFF;">&#39;官禄&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      isBodyPalace: </span><span style="color:#79B8FF;">true</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      isOriginalPalace: </span><span style="color:#79B8FF;">false</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      heavenlyStem: </span><span style="color:#9ECBFF;">&#39;丙&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      earthlyBranch: </span><span style="color:#9ECBFF;">&#39;戌&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      majorStars: [</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;廉贞&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;major&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;">, brightness: </span><span style="color:#9ECBFF;">&#39;利&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;天府&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;major&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;">, brightness: </span><span style="color:#9ECBFF;">&#39;庙&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">      ],</span></span>
<span class="line"><span style="color:#E1E4E8;">      minorStars: [{ name: </span><span style="color:#9ECBFF;">&#39;左辅&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;soft&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;">, brightness: </span><span style="color:#9ECBFF;">&#39;&#39;</span><span style="color:#E1E4E8;"> }],</span></span>
<span class="line"><span style="color:#E1E4E8;">      adjectiveStars: [</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;天才&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;adjective&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;天虚&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;adjective&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">      ],</span></span>
<span class="line"><span style="color:#E1E4E8;">      changsheng12: </span><span style="color:#9ECBFF;">&#39;沐浴&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      boshi12: </span><span style="color:#9ECBFF;">&#39;伏兵&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      jiangqian12: </span><span style="color:#9ECBFF;">&#39;月煞&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      suiqian12: </span><span style="color:#9ECBFF;">&#39;大耗&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      stage: { range: [</span><span style="color:#79B8FF;">84</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">93</span><span style="color:#E1E4E8;">], heavenlyStem: </span><span style="color:#9ECBFF;">&#39;丙&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">      ages: [</span><span style="color:#79B8FF;">1</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">13</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">25</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">37</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">49</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">61</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">73</span><span style="color:#E1E4E8;">],</span></span>
<span class="line"><span style="color:#E1E4E8;">    },</span></span>
<span class="line"><span style="color:#E1E4E8;">    {</span></span>
<span class="line"><span style="color:#E1E4E8;">      name: </span><span style="color:#9ECBFF;">&#39;仆役&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      isBodyPalace: </span><span style="color:#79B8FF;">false</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      isOriginalPalace: </span><span style="color:#79B8FF;">false</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      heavenlyStem: </span><span style="color:#9ECBFF;">&#39;丁&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      earthlyBranch: </span><span style="color:#9ECBFF;">&#39;亥&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      majorStars: [{ name: </span><span style="color:#9ECBFF;">&#39;太阴&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;major&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;">, brightness: </span><span style="color:#9ECBFF;">&#39;庙&#39;</span><span style="color:#E1E4E8;"> }],</span></span>
<span class="line"><span style="color:#E1E4E8;">      minorStars: [],</span></span>
<span class="line"><span style="color:#E1E4E8;">      adjectiveStars: [</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;红鸾&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;flower&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;恩光&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;adjective&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;天官&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;adjective&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;天月&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;adjective&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;天伤&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;adjective&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">      ],</span></span>
<span class="line"><span style="color:#E1E4E8;">      changsheng12: </span><span style="color:#9ECBFF;">&#39;长生&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      boshi12: </span><span style="color:#9ECBFF;">&#39;大耗&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      jiangqian12: </span><span style="color:#9ECBFF;">&#39;亡神&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      suiqian12: </span><span style="color:#9ECBFF;">&#39;龙德&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      stage: { range: [</span><span style="color:#79B8FF;">74</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">83</span><span style="color:#E1E4E8;">], heavenlyStem: </span><span style="color:#9ECBFF;">&#39;丁&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">      ages: [</span><span style="color:#79B8FF;">12</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">24</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">36</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">48</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">60</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">72</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">84</span><span style="color:#E1E4E8;">],</span></span>
<span class="line"><span style="color:#E1E4E8;">    },</span></span>
<span class="line"><span style="color:#E1E4E8;">    {</span></span>
<span class="line"><span style="color:#E1E4E8;">      name: </span><span style="color:#9ECBFF;">&#39;迁移&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      isBodyPalace: </span><span style="color:#79B8FF;">false</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      isOriginalPalace: </span><span style="color:#79B8FF;">false</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      heavenlyStem: </span><span style="color:#9ECBFF;">&#39;戊&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      earthlyBranch: </span><span style="color:#9ECBFF;">&#39;子&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      majorStars: [{ name: </span><span style="color:#9ECBFF;">&#39;贪狼&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;major&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;">, brightness: </span><span style="color:#9ECBFF;">&#39;旺&#39;</span><span style="color:#E1E4E8;"> }],</span></span>
<span class="line"><span style="color:#E1E4E8;">      minorStars: [{ name: </span><span style="color:#9ECBFF;">&#39;铃星&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;tough&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;">, brightness: </span><span style="color:#9ECBFF;">&#39;陷&#39;</span><span style="color:#E1E4E8;"> }],</span></span>
<span class="line"><span style="color:#E1E4E8;">      adjectiveStars: [{ name: </span><span style="color:#9ECBFF;">&#39; 八座&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;adjective&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;"> }],</span></span>
<span class="line"><span style="color:#E1E4E8;">      changsheng12: </span><span style="color:#9ECBFF;">&#39;养&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      boshi12: </span><span style="color:#9ECBFF;">&#39;病符&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      jiangqian12: </span><span style="color:#9ECBFF;">&#39;将星&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      suiqian12: </span><span style="color:#9ECBFF;">&#39;白虎&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      stage: { range: [</span><span style="color:#79B8FF;">64</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">73</span><span style="color:#E1E4E8;">], heavenlyStem: </span><span style="color:#9ECBFF;">&#39;戊&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">      ages: [</span><span style="color:#79B8FF;">11</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">23</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">35</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">47</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">59</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">71</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">83</span><span style="color:#E1E4E8;">],</span></span>
<span class="line"><span style="color:#E1E4E8;">    },</span></span>
<span class="line"><span style="color:#E1E4E8;">    {</span></span>
<span class="line"><span style="color:#E1E4E8;">      name: </span><span style="color:#9ECBFF;">&#39;疾厄&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      isBodyPalace: </span><span style="color:#79B8FF;">false</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      isOriginalPalace: </span><span style="color:#79B8FF;">false</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      heavenlyStem: </span><span style="color:#9ECBFF;">&#39;己&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      earthlyBranch: </span><span style="color:#9ECBFF;">&#39;丑&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      majorStars: [</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;天同&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;major&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;">, brightness: </span><span style="color:#9ECBFF;">&#39;不&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;巨门&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;major&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;">, brightness: </span><span style="color:#9ECBFF;">&#39;不&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">      ],</span></span>
<span class="line"><span style="color:#E1E4E8;">      minorStars: [</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;天魁&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;soft&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;">, brightness: </span><span style="color:#9ECBFF;">&#39;&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;地劫&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;tough&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;">, brightness: </span><span style="color:#9ECBFF;">&#39;&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">      ],</span></span>
<span class="line"><span style="color:#E1E4E8;">      adjectiveStars: [</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;天德&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;adjective&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;寡宿&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;adjective&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;破碎&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;adjective&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">        { name: </span><span style="color:#9ECBFF;">&#39;天使&#39;</span><span style="color:#E1E4E8;">, type: </span><span style="color:#9ECBFF;">&#39;adjective&#39;</span><span style="color:#E1E4E8;">, scope: </span><span style="color:#9ECBFF;">&#39;origin&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">      ],</span></span>
<span class="line"><span style="color:#E1E4E8;">      changsheng12: </span><span style="color:#9ECBFF;">&#39;胎&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      boshi12: </span><span style="color:#9ECBFF;">&#39;喜神&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      jiangqian12: </span><span style="color:#9ECBFF;">&#39;攀鞍&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      suiqian12: </span><span style="color:#9ECBFF;">&#39;天德&#39;</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">      stage: { range: [</span><span style="color:#79B8FF;">54</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">63</span><span style="color:#E1E4E8;">], heavenlyStem: </span><span style="color:#9ECBFF;">&#39;己&#39;</span><span style="color:#E1E4E8;"> },</span></span>
<span class="line"><span style="color:#E1E4E8;">      ages: [</span><span style="color:#79B8FF;">10</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">22</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">34</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">46</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">58</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">70</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">82</span><span style="color:#E1E4E8;">],</span></span>
<span class="line"><span style="color:#E1E4E8;">    },</span></span>
<span class="line"><span style="color:#E1E4E8;">  ],</span></span>
<span class="line"><span style="color:#E1E4E8;">}</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#24292E;">{</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6A737D;">// 阳历日期</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6F42C1;">solarDate</span><span style="color:#24292E;">: </span><span style="color:#032F62;">&#39;2000-8-16&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6A737D;">// 农历日期</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6F42C1;">lunarDate</span><span style="color:#24292E;">: </span><span style="color:#032F62;">&#39;二〇〇〇年七月十七&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6A737D;">// 四柱</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6F42C1;">chineseDate</span><span style="color:#24292E;">: </span><span style="color:#032F62;">&#39;庚辰 甲申 丙午 庚寅&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6A737D;">// 时辰</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6F42C1;">time</span><span style="color:#24292E;">: </span><span style="color:#032F62;">&#39;寅时&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6A737D;">// 时辰对应的时间段</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6F42C1;">timeRange</span><span style="color:#24292E;">: </span><span style="color:#032F62;">&#39;03:00~05:00&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6A737D;">// 星座</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6F42C1;">sign</span><span style="color:#24292E;">: </span><span style="color:#032F62;">&#39;狮子座&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6A737D;">// 生肖</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6F42C1;">zodiac</span><span style="color:#24292E;">: </span><span style="color:#032F62;">&#39;龙&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6A737D;">// 命宫地支</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6F42C1;">earthlyBranchOfSoulPalace</span><span style="color:#24292E;">: </span><span style="color:#032F62;">&#39;午&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6A737D;">// 身宫地支</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6F42C1;">earthlyBranchOfBodyPalace</span><span style="color:#24292E;">: </span><span style="color:#032F62;">&#39;戌&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6A737D;">// 命主</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6F42C1;">soul</span><span style="color:#24292E;">: </span><span style="color:#032F62;">&#39;破军&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6A737D;">// 身主</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6F42C1;">body</span><span style="color:#24292E;">: </span><span style="color:#032F62;">&#39;文昌&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6A737D;">// 五行局</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6F42C1;">fiveElementsClass</span><span style="color:#24292E;">: </span><span style="color:#032F62;">&#39;木三局&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6A737D;">// 十二宫数据</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6F42C1;">palaces</span><span style="color:#24292E;">: [</span></span>
<span class="line"><span style="color:#24292E;">    {</span></span>
<span class="line"><span style="color:#24292E;">      </span><span style="color:#6A737D;">// 宫名</span></span>
<span class="line"><span style="color:#24292E;">      name: </span><span style="color:#032F62;">&#39;财帛&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      </span><span style="color:#6A737D;">// 是否身宫</span></span>
<span class="line"><span style="color:#24292E;">      isBodyPalace: </span><span style="color:#005CC5;">false</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      </span><span style="color:#6A737D;">// 是否来因宫</span></span>
<span class="line"><span style="color:#24292E;">      isOriginalPalace: </span><span style="color:#005CC5;">false</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      </span><span style="color:#6A737D;">// 宫位天干</span></span>
<span class="line"><span style="color:#24292E;">      heavenlyStem: </span><span style="color:#032F62;">&#39;戊&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      </span><span style="color:#6A737D;">// 宫位地支</span></span>
<span class="line"><span style="color:#24292E;">      earthlyBranch: </span><span style="color:#032F62;">&#39;寅&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      </span><span style="color:#6A737D;">// 主星（含天马禄存）</span></span>
<span class="line"><span style="color:#24292E;">      majorStars: [</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;武曲&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;major&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;">, brightness: </span><span style="color:#032F62;">&#39;得&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;天相&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;major&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;">, brightness: </span><span style="color:#032F62;">&#39;庙&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;天马&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;tianma&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;">, brightness: </span><span style="color:#032F62;">&#39;&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">      ],</span></span>
<span class="line"><span style="color:#24292E;">      </span><span style="color:#6A737D;">// 辅星（含六吉六煞）</span></span>
<span class="line"><span style="color:#24292E;">      minorStars: [],</span></span>
<span class="line"><span style="color:#24292E;">      </span><span style="color:#6A737D;">// 杂耀</span></span>
<span class="line"><span style="color:#24292E;">      adjectiveStars: [</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;月解&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;helper&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;三台&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;adjective&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;天寿&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;adjective&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;天巫&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;adjective&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;天厨&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;adjective&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;阴煞&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;adjective&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;天哭&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;adjective&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">      ],</span></span>
<span class="line"><span style="color:#24292E;">      </span><span style="color:#6A737D;">// 长生12神</span></span>
<span class="line"><span style="color:#24292E;">      changsheng12: </span><span style="color:#032F62;">&#39;绝&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      </span><span style="color:#6A737D;">// 博士12神</span></span>
<span class="line"><span style="color:#24292E;">      boshi12: </span><span style="color:#032F62;">&#39;蜚廉&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      </span><span style="color:#6A737D;">// 流年将前12神</span></span>
<span class="line"><span style="color:#24292E;">      jiangqian12: </span><span style="color:#032F62;">&#39;岁驿&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      </span><span style="color:#6A737D;">// 流年岁前12神</span></span>
<span class="line"><span style="color:#24292E;">      suiqian12: </span><span style="color:#032F62;">&#39;吊客&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      </span><span style="color:#6A737D;">// 大限</span></span>
<span class="line"><span style="color:#24292E;">      stage: { range: [</span><span style="color:#005CC5;">44</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">53</span><span style="color:#24292E;">], heavenlyStem: </span><span style="color:#032F62;">&#39;戊&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">      </span><span style="color:#6A737D;">// 小限</span></span>
<span class="line"><span style="color:#24292E;">      ages: [</span><span style="color:#005CC5;">9</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">21</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">33</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">45</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">57</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">69</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">81</span><span style="color:#24292E;">],</span></span>
<span class="line"><span style="color:#24292E;">    },</span></span>
<span class="line"><span style="color:#24292E;">    {</span></span>
<span class="line"><span style="color:#24292E;">      name: </span><span style="color:#032F62;">&#39;子女&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      isBodyPalace: </span><span style="color:#005CC5;">false</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      isOriginalPalace: </span><span style="color:#005CC5;">false</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      heavenlyStem: </span><span style="color:#032F62;">&#39;己&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      earthlyBranch: </span><span style="color:#032F62;">&#39;卯&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      majorStars: [</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;太阳&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;major&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;">, brightness: </span><span style="color:#032F62;">&#39;庙&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;天梁&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;major&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;">, brightness: </span><span style="color:#032F62;">&#39;庙&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">      ],</span></span>
<span class="line"><span style="color:#24292E;">      minorStars: [],</span></span>
<span class="line"><span style="color:#24292E;">      adjectiveStars: [{ name: </span><span style="color:#032F62;">&#39;天刑&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;adjective&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;"> }],</span></span>
<span class="line"><span style="color:#24292E;">      changsheng12: </span><span style="color:#032F62;">&#39;墓&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      boshi12: </span><span style="color:#032F62;">&#39;奏书&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      jiangqian12: </span><span style="color:#032F62;">&#39;息神&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      suiqian12: </span><span style="color:#032F62;">&#39;病符&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      stage: { range: [</span><span style="color:#005CC5;">34</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">43</span><span style="color:#24292E;">], heavenlyStem: </span><span style="color:#032F62;">&#39;己&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">      ages: [</span><span style="color:#005CC5;">8</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">20</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">32</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">44</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">56</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">68</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">80</span><span style="color:#24292E;">],</span></span>
<span class="line"><span style="color:#24292E;">    },</span></span>
<span class="line"><span style="color:#24292E;">    {</span></span>
<span class="line"><span style="color:#24292E;">      name: </span><span style="color:#032F62;">&#39;夫妻&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      isBodyPalace: </span><span style="color:#005CC5;">false</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      isOriginalPalace: </span><span style="color:#005CC5;">true</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      heavenlyStem: </span><span style="color:#032F62;">&#39;庚&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      earthlyBranch: </span><span style="color:#032F62;">&#39;辰&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      majorStars: [{ name: </span><span style="color:#032F62;">&#39;七杀&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;major&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;">, brightness: </span><span style="color:#032F62;">&#39;庙&#39;</span><span style="color:#24292E;"> }],</span></span>
<span class="line"><span style="color:#24292E;">      minorStars: [</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;右弼&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;soft&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;">, brightness: </span><span style="color:#032F62;">&#39;&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;火星&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;tough&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;">, brightness: </span><span style="color:#032F62;">&#39;陷&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">      ],</span></span>
<span class="line"><span style="color:#24292E;">      adjectiveStars: [</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;封诰&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;adjective&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;华盖&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;adjective&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">      ],</span></span>
<span class="line"><span style="color:#24292E;">      changsheng12: </span><span style="color:#032F62;">&#39;死&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      boshi12: </span><span style="color:#032F62;">&#39;将军&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      jiangqian12: </span><span style="color:#032F62;">&#39;华盖&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      suiqian12: </span><span style="color:#032F62;">&#39;岁建&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      stage: { range: [</span><span style="color:#005CC5;">24</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">33</span><span style="color:#24292E;">], heavenlyStem: </span><span style="color:#032F62;">&#39;庚&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">      ages: [</span><span style="color:#005CC5;">7</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">19</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">31</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">43</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">55</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">67</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">79</span><span style="color:#24292E;">],</span></span>
<span class="line"><span style="color:#24292E;">    },</span></span>
<span class="line"><span style="color:#24292E;">    {</span></span>
<span class="line"><span style="color:#24292E;">      name: </span><span style="color:#032F62;">&#39;兄弟&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      isBodyPalace: </span><span style="color:#005CC5;">false</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      isOriginalPalace: </span><span style="color:#005CC5;">false</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      heavenlyStem: </span><span style="color:#032F62;">&#39;辛&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      earthlyBranch: </span><span style="color:#032F62;">&#39;巳&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      majorStars: [{ name: </span><span style="color:#032F62;">&#39;天机&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;major&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;">, brightness: </span><span style="color:#032F62;">&#39;平&#39;</span><span style="color:#24292E;"> }],</span></span>
<span class="line"><span style="color:#24292E;">      minorStars: [],</span></span>
<span class="line"><span style="color:#24292E;">      adjectiveStars: [</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;天喜&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;flower&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;天空&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;adjective&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;孤辰&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;adjective&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">      ],</span></span>
<span class="line"><span style="color:#24292E;">      changsheng12: </span><span style="color:#032F62;">&#39;病&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      boshi12: </span><span style="color:#032F62;">&#39;小耗&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      jiangqian12: </span><span style="color:#032F62;">&#39;劫煞&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      suiqian12: </span><span style="color:#032F62;">&#39;晦气&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      stage: { range: [</span><span style="color:#005CC5;">14</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">23</span><span style="color:#24292E;">], heavenlyStem: </span><span style="color:#032F62;">&#39;辛&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">      ages: [</span><span style="color:#005CC5;">6</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">18</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">30</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">42</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">54</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">66</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">78</span><span style="color:#24292E;">],</span></span>
<span class="line"><span style="color:#24292E;">    },</span></span>
<span class="line"><span style="color:#24292E;">    {</span></span>
<span class="line"><span style="color:#24292E;">      name: </span><span style="color:#032F62;">&#39;命宫&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      isBodyPalace: </span><span style="color:#005CC5;">false</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      isOriginalPalace: </span><span style="color:#005CC5;">false</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      heavenlyStem: </span><span style="color:#032F62;">&#39;壬&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      earthlyBranch: </span><span style="color:#032F62;">&#39;午&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      majorStars: [{ name: </span><span style="color:#032F62;">&#39;紫微&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;major&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;">, brightness: </span><span style="color:#032F62;">&#39;庙&#39;</span><span style="color:#24292E;"> }],</span></span>
<span class="line"><span style="color:#24292E;">      minorStars: [{ name: </span><span style="color:#032F62;">&#39;文曲&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;soft&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;">, brightness: </span><span style="color:#032F62;">&#39;陷&#39;</span><span style="color:#24292E;"> }],</span></span>
<span class="line"><span style="color:#24292E;">      adjectiveStars: [</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;年解&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;helper&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;凤阁&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;adjective&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;天福&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;adjective&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;截路&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;adjective&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;蜚廉&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;adjective&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">      ],</span></span>
<span class="line"><span style="color:#24292E;">      changsheng12: </span><span style="color:#032F62;">&#39;衰&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      boshi12: </span><span style="color:#032F62;">&#39;青龙&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      jiangqian12: </span><span style="color:#032F62;">&#39;灾煞&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      suiqian12: </span><span style="color:#032F62;">&#39;丧门&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      stage: { range: [</span><span style="color:#005CC5;">4</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">13</span><span style="color:#24292E;">], heavenlyStem: </span><span style="color:#032F62;">&#39;壬&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">      ages: [</span><span style="color:#005CC5;">5</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">17</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">29</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">41</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">53</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">65</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">77</span><span style="color:#24292E;">],</span></span>
<span class="line"><span style="color:#24292E;">    },</span></span>
<span class="line"><span style="color:#24292E;">    {</span></span>
<span class="line"><span style="color:#24292E;">      name: </span><span style="color:#032F62;">&#39;父母&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      isBodyPalace: </span><span style="color:#005CC5;">false</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      isOriginalPalace: </span><span style="color:#005CC5;">false</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      heavenlyStem: </span><span style="color:#032F62;">&#39;癸&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      earthlyBranch: </span><span style="color:#032F62;">&#39;未&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      majorStars: [],</span></span>
<span class="line"><span style="color:#24292E;">      minorStars: [</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;天钺&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;soft&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;">, brightness: </span><span style="color:#032F62;">&#39;&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;陀罗&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;tough&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;">, brightness: </span><span style="color:#032F62;">&#39;庙&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">      ],</span></span>
<span class="line"><span style="color:#24292E;">      adjectiveStars: [</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;天姚&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;flower&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;空亡&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;adjective&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">      ],</span></span>
<span class="line"><span style="color:#24292E;">      changsheng12: </span><span style="color:#032F62;">&#39;帝旺&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      boshi12: </span><span style="color:#032F62;">&#39;力士&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      jiangqian12: </span><span style="color:#032F62;">&#39;天煞&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      suiqian12: </span><span style="color:#032F62;">&#39;贯索&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      stage: { range: [</span><span style="color:#005CC5;">114</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">123</span><span style="color:#24292E;">], heavenlyStem: </span><span style="color:#032F62;">&#39;癸&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">      ages: [</span><span style="color:#005CC5;">4</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">16</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">28</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">40</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">52</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">64</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">76</span><span style="color:#24292E;">],</span></span>
<span class="line"><span style="color:#24292E;">    },</span></span>
<span class="line"><span style="color:#24292E;">    {</span></span>
<span class="line"><span style="color:#24292E;">      name: </span><span style="color:#032F62;">&#39;福德&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      isBodyPalace: </span><span style="color:#005CC5;">false</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      isOriginalPalace: </span><span style="color:#005CC5;">false</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      heavenlyStem: </span><span style="color:#032F62;">&#39;甲&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      earthlyBranch: </span><span style="color:#032F62;">&#39;申&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      majorStars: [</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;破军&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;major&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;">, brightness: </span><span style="color:#032F62;">&#39;得&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;禄存&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;lucun&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;">, brightness: </span><span style="color:#032F62;">&#39;&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">      ],</span></span>
<span class="line"><span style="color:#24292E;">      minorStars: [{ name: </span><span style="color:#032F62;">&#39;文昌&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;soft&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;">, brightness: </span><span style="color:#032F62;">&#39;得&#39;</span><span style="color:#24292E;"> }],</span></span>
<span class="line"><span style="color:#24292E;">      adjectiveStars: [</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;龙池&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;adjective&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;台辅&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;adjective&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;旬空&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;adjective&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">      ],</span></span>
<span class="line"><span style="color:#24292E;">      changsheng12: </span><span style="color:#032F62;">&#39;临官&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      boshi12: </span><span style="color:#032F62;">&#39;博士&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      jiangqian12: </span><span style="color:#032F62;">&#39;指背&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      suiqian12: </span><span style="color:#032F62;">&#39;官符&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      stage: { range: [</span><span style="color:#005CC5;">104</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">113</span><span style="color:#24292E;">], heavenlyStem: </span><span style="color:#032F62;">&#39;甲&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">      ages: [</span><span style="color:#005CC5;">3</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">15</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">27</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">39</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">51</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">63</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">75</span><span style="color:#24292E;">],</span></span>
<span class="line"><span style="color:#24292E;">    },</span></span>
<span class="line"><span style="color:#24292E;">    {</span></span>
<span class="line"><span style="color:#24292E;">      name: </span><span style="color:#032F62;">&#39;田宅&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      isBodyPalace: </span><span style="color:#005CC5;">false</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      isOriginalPalace: </span><span style="color:#005CC5;">false</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      heavenlyStem: </span><span style="color:#032F62;">&#39;乙&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      earthlyBranch: </span><span style="color:#032F62;">&#39;酉&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      majorStars: [],</span></span>
<span class="line"><span style="color:#24292E;">      minorStars: [</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;地空&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;tough&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;">, brightness: </span><span style="color:#032F62;">&#39;&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;擎羊&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;tough&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;">, brightness: </span><span style="color:#032F62;">&#39;陷&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">      ],</span></span>
<span class="line"><span style="color:#24292E;">      adjectiveStars: [</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;咸池&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;flower&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;天贵&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;adjective&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;月德&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;adjective&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">      ],</span></span>
<span class="line"><span style="color:#24292E;">      changsheng12: </span><span style="color:#032F62;">&#39;冠带&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      boshi12: </span><span style="color:#032F62;">&#39;官府&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      jiangqian12: </span><span style="color:#032F62;">&#39;咸池&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      suiqian12: </span><span style="color:#032F62;">&#39;小耗&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      stage: { range: [</span><span style="color:#005CC5;">94</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">103</span><span style="color:#24292E;">], heavenlyStem: </span><span style="color:#032F62;">&#39;乙&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">      ages: [</span><span style="color:#005CC5;">2</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">14</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">26</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">38</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">50</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">62</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">74</span><span style="color:#24292E;">],</span></span>
<span class="line"><span style="color:#24292E;">    },</span></span>
<span class="line"><span style="color:#24292E;">    {</span></span>
<span class="line"><span style="color:#24292E;">      name: </span><span style="color:#032F62;">&#39;官禄&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      isBodyPalace: </span><span style="color:#005CC5;">true</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      isOriginalPalace: </span><span style="color:#005CC5;">false</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      heavenlyStem: </span><span style="color:#032F62;">&#39;丙&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      earthlyBranch: </span><span style="color:#032F62;">&#39;戌&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      majorStars: [</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;廉贞&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;major&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;">, brightness: </span><span style="color:#032F62;">&#39;利&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;天府&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;major&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;">, brightness: </span><span style="color:#032F62;">&#39;庙&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">      ],</span></span>
<span class="line"><span style="color:#24292E;">      minorStars: [{ name: </span><span style="color:#032F62;">&#39;左辅&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;soft&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;">, brightness: </span><span style="color:#032F62;">&#39;&#39;</span><span style="color:#24292E;"> }],</span></span>
<span class="line"><span style="color:#24292E;">      adjectiveStars: [</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;天才&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;adjective&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;天虚&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;adjective&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">      ],</span></span>
<span class="line"><span style="color:#24292E;">      changsheng12: </span><span style="color:#032F62;">&#39;沐浴&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      boshi12: </span><span style="color:#032F62;">&#39;伏兵&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      jiangqian12: </span><span style="color:#032F62;">&#39;月煞&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      suiqian12: </span><span style="color:#032F62;">&#39;大耗&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      stage: { range: [</span><span style="color:#005CC5;">84</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">93</span><span style="color:#24292E;">], heavenlyStem: </span><span style="color:#032F62;">&#39;丙&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">      ages: [</span><span style="color:#005CC5;">1</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">13</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">25</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">37</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">49</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">61</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">73</span><span style="color:#24292E;">],</span></span>
<span class="line"><span style="color:#24292E;">    },</span></span>
<span class="line"><span style="color:#24292E;">    {</span></span>
<span class="line"><span style="color:#24292E;">      name: </span><span style="color:#032F62;">&#39;仆役&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      isBodyPalace: </span><span style="color:#005CC5;">false</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      isOriginalPalace: </span><span style="color:#005CC5;">false</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      heavenlyStem: </span><span style="color:#032F62;">&#39;丁&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      earthlyBranch: </span><span style="color:#032F62;">&#39;亥&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      majorStars: [{ name: </span><span style="color:#032F62;">&#39;太阴&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;major&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;">, brightness: </span><span style="color:#032F62;">&#39;庙&#39;</span><span style="color:#24292E;"> }],</span></span>
<span class="line"><span style="color:#24292E;">      minorStars: [],</span></span>
<span class="line"><span style="color:#24292E;">      adjectiveStars: [</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;红鸾&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;flower&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;恩光&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;adjective&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;天官&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;adjective&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;天月&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;adjective&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;天伤&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;adjective&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">      ],</span></span>
<span class="line"><span style="color:#24292E;">      changsheng12: </span><span style="color:#032F62;">&#39;长生&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      boshi12: </span><span style="color:#032F62;">&#39;大耗&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      jiangqian12: </span><span style="color:#032F62;">&#39;亡神&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      suiqian12: </span><span style="color:#032F62;">&#39;龙德&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      stage: { range: [</span><span style="color:#005CC5;">74</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">83</span><span style="color:#24292E;">], heavenlyStem: </span><span style="color:#032F62;">&#39;丁&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">      ages: [</span><span style="color:#005CC5;">12</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">24</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">36</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">48</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">60</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">72</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">84</span><span style="color:#24292E;">],</span></span>
<span class="line"><span style="color:#24292E;">    },</span></span>
<span class="line"><span style="color:#24292E;">    {</span></span>
<span class="line"><span style="color:#24292E;">      name: </span><span style="color:#032F62;">&#39;迁移&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      isBodyPalace: </span><span style="color:#005CC5;">false</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      isOriginalPalace: </span><span style="color:#005CC5;">false</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      heavenlyStem: </span><span style="color:#032F62;">&#39;戊&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      earthlyBranch: </span><span style="color:#032F62;">&#39;子&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      majorStars: [{ name: </span><span style="color:#032F62;">&#39;贪狼&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;major&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;">, brightness: </span><span style="color:#032F62;">&#39;旺&#39;</span><span style="color:#24292E;"> }],</span></span>
<span class="line"><span style="color:#24292E;">      minorStars: [{ name: </span><span style="color:#032F62;">&#39;铃星&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;tough&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;">, brightness: </span><span style="color:#032F62;">&#39;陷&#39;</span><span style="color:#24292E;"> }],</span></span>
<span class="line"><span style="color:#24292E;">      adjectiveStars: [{ name: </span><span style="color:#032F62;">&#39; 八座&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;adjective&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;"> }],</span></span>
<span class="line"><span style="color:#24292E;">      changsheng12: </span><span style="color:#032F62;">&#39;养&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      boshi12: </span><span style="color:#032F62;">&#39;病符&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      jiangqian12: </span><span style="color:#032F62;">&#39;将星&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      suiqian12: </span><span style="color:#032F62;">&#39;白虎&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      stage: { range: [</span><span style="color:#005CC5;">64</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">73</span><span style="color:#24292E;">], heavenlyStem: </span><span style="color:#032F62;">&#39;戊&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">      ages: [</span><span style="color:#005CC5;">11</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">23</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">35</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">47</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">59</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">71</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">83</span><span style="color:#24292E;">],</span></span>
<span class="line"><span style="color:#24292E;">    },</span></span>
<span class="line"><span style="color:#24292E;">    {</span></span>
<span class="line"><span style="color:#24292E;">      name: </span><span style="color:#032F62;">&#39;疾厄&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      isBodyPalace: </span><span style="color:#005CC5;">false</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      isOriginalPalace: </span><span style="color:#005CC5;">false</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      heavenlyStem: </span><span style="color:#032F62;">&#39;己&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      earthlyBranch: </span><span style="color:#032F62;">&#39;丑&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      majorStars: [</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;天同&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;major&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;">, brightness: </span><span style="color:#032F62;">&#39;不&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;巨门&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;major&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;">, brightness: </span><span style="color:#032F62;">&#39;不&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">      ],</span></span>
<span class="line"><span style="color:#24292E;">      minorStars: [</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;天魁&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;soft&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;">, brightness: </span><span style="color:#032F62;">&#39;&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;地劫&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;tough&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;">, brightness: </span><span style="color:#032F62;">&#39;&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">      ],</span></span>
<span class="line"><span style="color:#24292E;">      adjectiveStars: [</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;天德&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;adjective&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;寡宿&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;adjective&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;破碎&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;adjective&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">        { name: </span><span style="color:#032F62;">&#39;天使&#39;</span><span style="color:#24292E;">, type: </span><span style="color:#032F62;">&#39;adjective&#39;</span><span style="color:#24292E;">, scope: </span><span style="color:#032F62;">&#39;origin&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">      ],</span></span>
<span class="line"><span style="color:#24292E;">      changsheng12: </span><span style="color:#032F62;">&#39;胎&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      boshi12: </span><span style="color:#032F62;">&#39;喜神&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      jiangqian12: </span><span style="color:#032F62;">&#39;攀鞍&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      suiqian12: </span><span style="color:#032F62;">&#39;天德&#39;</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">      stage: { range: [</span><span style="color:#005CC5;">54</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">63</span><span style="color:#24292E;">], heavenlyStem: </span><span style="color:#032F62;">&#39;己&#39;</span><span style="color:#24292E;"> },</span></span>
<span class="line"><span style="color:#24292E;">      ages: [</span><span style="color:#005CC5;">10</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">22</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">34</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">46</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">58</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">70</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">82</span><span style="color:#24292E;">],</span></span>
<span class="line"><span style="color:#24292E;">    },</span></span>
<span class="line"><span style="color:#24292E;">  ],</span></span>
<span class="line"><span style="color:#24292E;">}</span></span></code></pre></div></details></li></ul><hr><h4 id="astrolabebylunardate" tabindex="-1">astrolabeByLunarDate <a class="header-anchor" href="#astrolabebylunardate" aria-label="Permalink to &quot;astrolabeByLunarDate&quot;">​</a></h4><ul><li><p>用途</p><p>通过农历日期获取星盘信息。我们强烈建议你优先使用 <code>astrolabeBySolarDate</code> 方法，因为该方法也是将农历日期转化为阳历以后调用 <code>astrolabeBySolarDate</code> 获得结果的。</p></li><li><p>定义</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">export</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">type</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">astrolabeByLunarDate</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> (</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#FFAB70;">lunarDateStr</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">string</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#FFAB70;">timeIndex</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">number</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#FFAB70;">gender</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">GenderName</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#FFAB70;">isLeapMonth</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;"> = </span><span style="color:#79B8FF;">false</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#FFAB70;">fixLeap</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;"> = </span><span style="color:#79B8FF;">true</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#FFAB70;">language</span><span style="color:#F97583;">?:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">Language</span></span>
<span class="line"><span style="color:#E1E4E8;">) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">FunctionalAstrolabe</span><span style="color:#E1E4E8;">;</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">export</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">type</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">astrolabeByLunarDate</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> (</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#E36209;">lunarDateStr</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">string</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#E36209;">timeIndex</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">number</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#E36209;">gender</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">GenderName</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#E36209;">isLeapMonth</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;"> = </span><span style="color:#005CC5;">false</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#E36209;">fixLeap</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;"> = </span><span style="color:#005CC5;">true</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#E36209;">language</span><span style="color:#D73A49;">?:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">Language</span></span>
<span class="line"><span style="color:#24292E;">) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">FunctionalAstrolabe</span><span style="color:#24292E;">;</span></span></code></pre></div></li><li><p>参数</p><table><thead><tr><th>参数</th><th>类型</th><th>是否必填</th><th>默认值</th><th>说明</th></tr></thead><tbody><tr><td>lunarDateStr</td><td><code>string</code></td><td><code>true</code></td><td>-</td><td>农历日期【YYYY-M-D】，例如 <code>2000年七月十七</code> 则传入 <code>2000-7-17</code></td></tr><tr><td>timeIndex</td><td><code>number</code></td><td><code>true</code></td><td>-</td><td>出生时辰序号【0~12】，对应从早子时（0）一直到晚子时（12）的序号</td></tr><tr><td>gender</td><td><a href="/type-definition.html#gendername"><code>GenderName</code></a></td><td><code>true</code></td><td>-</td><td>性别【男/女】</td></tr><tr><td>isLeapMonth</td><td><code>boolean</code></td><td><code>false</code></td><td><code>false</code></td><td>是否闰月，当实际月份没有闰月时该参数不生效</td></tr><tr><td>fixLeap</td><td><code>boolean</code></td><td><code>false</code></td><td><code>true</code></td><td>是否调整闰月，为<code>true</code>闰月的前半个月算上个月，后半个月算下个月</td></tr><tr><td>language</td><td><a href="./../type-definition.html#language"><code>Language</code></a></td><td><code>false</code></td><td><code>zh-CN</code></td><td>返回数据将被国际化为指定语言。目前支持 <code>zh-CN</code>,<code>zh-TW</code>,<code>en-US</code>,<code>ko-KR</code> 和 <code>ja-JP</code></td></tr></tbody></table></li><li><p>返回值</p><p><a href="./astrolabe.html#functionalastrolabe"><code>FunctionalAstrolabe</code></a></p></li><li><p>示例</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">import</span><span style="color:#E1E4E8;"> { astro } </span><span style="color:#F97583;">from</span><span style="color:#E1E4E8;"> </span><span style="color:#9ECBFF;">&quot;iztro&quot;</span><span style="color:#E1E4E8;">;</span></span>
<span class="line"></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">astrolabe</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astro.</span><span style="color:#B392F0;">astrolabeBySolarDate</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;2000-8-16&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">2</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;女&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">false</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">true</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;zh-CN&quot;</span><span style="color:#E1E4E8;">);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">import</span><span style="color:#24292E;"> { astro } </span><span style="color:#D73A49;">from</span><span style="color:#24292E;"> </span><span style="color:#032F62;">&quot;iztro&quot;</span><span style="color:#24292E;">;</span></span>
<span class="line"></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">astrolabe</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astro.</span><span style="color:#6F42C1;">astrolabeBySolarDate</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;2000-8-16&quot;</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">2</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;女&quot;</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">false</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">true</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;zh-CN&quot;</span><span style="color:#24292E;">);</span></span></code></pre></div></li><li><p>示例返回值</p><p>参考 <a href="./astrolabe.html#astrolabebysolardate">astrolabeBySolarDate</a> 的示例返回值</p></li></ul><hr>`,7),g={id:"getmajorstarbysolardate",tabindex:"-1"},u=s("a",{class:"header-anchor",href:"#getmajorstarbysolardate","aria-label":'Permalink to "getMajorStarBySolarDate <Badge type="warning" text="^1.2.1" />"'},"​",-1),B=p(`<ul><li><p>用途</p><p>通过阳历获取命宫主星</p></li><li><p>定义</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">type</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">getMajorStarBySolarDate</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> (</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#FFAB70;">solarDateStr</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">string</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#FFAB70;">timeIndex</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">number</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#FFAB70;">fixLeap</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;"> = </span><span style="color:#79B8FF;">true</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#FFAB70;">language</span><span style="color:#F97583;">?:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">Language</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">string</span><span style="color:#E1E4E8;">;</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">type</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">getMajorStarBySolarDate</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> (</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#E36209;">solarDateStr</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">string</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#E36209;">timeIndex</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">number</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#E36209;">fixLeap</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;"> = </span><span style="color:#005CC5;">true</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#E36209;">language</span><span style="color:#D73A49;">?:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">Language</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">string</span><span style="color:#24292E;">;</span></span></code></pre></div></li><li><p>参数</p><table><thead><tr><th>参数</th><th>类型</th><th>是否必填</th><th>默认值</th><th>说明</th></tr></thead><tbody><tr><td>solarDateStr</td><td><code>string</code></td><td><code>true</code></td><td>-</td><td>阳历日期【YYYY-M-D】</td></tr><tr><td>timeIndex</td><td><code>number</code></td><td><code>true</code></td><td>-</td><td>出生时辰序号【0~12】，对应从早子时（0）一直到晚子时（12）的序号</td></tr><tr><td>fixLeap</td><td><code>boolean</code></td><td><code>false</code></td><td><code>true</code></td><td>是否调整闰月，为<code>true</code>闰月的前半个月算上个月，后半个月算下个月</td></tr><tr><td>language</td><td><a href="./../type-definition.html#language"><code>Language</code></a></td><td><code>false</code></td><td><code>zh-CN</code></td><td>返回数据将被国际化为指定语言。目前支持 <code>zh-CN</code>,<code>zh-TW</code>,<code>en-US</code>,<code>ko-KR</code> 和 <code>ja-JP</code></td></tr></tbody></table></li><li><p>示例</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">import</span><span style="color:#E1E4E8;"> { astro } </span><span style="color:#F97583;">from</span><span style="color:#E1E4E8;"> </span><span style="color:#9ECBFF;">&#39;isztro&#39;</span><span style="color:#E1E4E8;">;</span></span>
<span class="line"></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">result</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">getMajorStarBySolarDate</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&#39;2023-4-7&#39;</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">0</span><span style="color:#E1E4E8;">);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">import</span><span style="color:#24292E;"> { astro } </span><span style="color:#D73A49;">from</span><span style="color:#24292E;"> </span><span style="color:#032F62;">&#39;isztro&#39;</span><span style="color:#24292E;">;</span></span>
<span class="line"></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">result</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">getMajorStarBySolarDate</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&#39;2023-4-7&#39;</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">0</span><span style="color:#24292E;">);</span></span></code></pre></div></li><li><p>示例返回值</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#E1E4E8;">贪狼</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#24292E;">贪狼</span></span></code></pre></div></li></ul><hr>`,2),m={id:"getmajorstarbylunardate",tabindex:"-1"},b=s("a",{class:"header-anchor",href:"#getmajorstarbylunardate","aria-label":'Permalink to "getMajorStarByLunarDate <Badge type="warning" text="^1.2.1" />"'},"​",-1),D=p(`<ul><li><p>用途</p><p>通过农历获取命宫主星</p></li><li><p>定义</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">type</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">getMajorStarByLunarDate</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> (</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#FFAB70;">lunarDateStr</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">string</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#FFAB70;">timeIndex</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">number</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#FFAB70;">isLeapMonth</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;"> = </span><span style="color:#79B8FF;">false</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#FFAB70;">fixLeap</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;"> = </span><span style="color:#79B8FF;">true</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#FFAB70;">language</span><span style="color:#F97583;">?:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">Language</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">) </span><span style="color:#F97583;">=&gt;</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">type</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">getMajorStarByLunarDate</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> (</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#E36209;">lunarDateStr</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">string</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#E36209;">timeIndex</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">number</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#E36209;">isLeapMonth</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;"> = </span><span style="color:#005CC5;">false</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#E36209;">fixLeap</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;"> = </span><span style="color:#005CC5;">true</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#E36209;">language</span><span style="color:#D73A49;">?:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">Language</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">) </span><span style="color:#D73A49;">=&gt;</span></span></code></pre></div></li><li><p>参数</p><table><thead><tr><th>参数</th><th>类型</th><th>是否必填</th><th>默认值</th><th>说明</th></tr></thead><tbody><tr><td>lunarDateStr</td><td><code>string</code></td><td><code>true</code></td><td>-</td><td>农历日期【YYYY-M-D】，例如 <code>2000年七月十七</code> 则传入 <code>2000-7-17</code></td></tr><tr><td>timeIndex</td><td><code>number</code></td><td><code>true</code></td><td>-</td><td>出生时辰序号【0~12】，对应从早子时（0）一直到晚子时（12）的序号</td></tr><tr><td>isLeapMonth</td><td><code>boolean</code></td><td><code>false</code></td><td><code>false</code></td><td>是否闰月，当实际月份没有闰月时该参数不生效</td></tr><tr><td>fixLeap</td><td><code>boolean</code></td><td><code>false</code></td><td><code>true</code></td><td>是否调整闰月，为<code>true</code>闰月的前半个月算上个月，后半个月算下个月</td></tr><tr><td>language</td><td><a href="./../type-definition.html#language"><code>Language</code></a></td><td><code>false</code></td><td><code>zh-CN</code></td><td>返回数据将被国际化为指定语言。目前支持 <code>zh-CN</code>,<code>zh-TW</code>,<code>en-US</code>,<code>ko-KR</code> 和 <code>ja-JP</code></td></tr></tbody></table></li><li><p>示例</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">import</span><span style="color:#E1E4E8;"> { astro } </span><span style="color:#F97583;">from</span><span style="color:#E1E4E8;"> </span><span style="color:#9ECBFF;">&#39;isztro&#39;</span><span style="color:#E1E4E8;">;</span></span>
<span class="line"></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">result</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">getMajorStarByLunarDate</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&#39;2023-2-17&#39;</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">0</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">true</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">false</span><span style="color:#E1E4E8;">);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">import</span><span style="color:#24292E;"> { astro } </span><span style="color:#D73A49;">from</span><span style="color:#24292E;"> </span><span style="color:#032F62;">&#39;isztro&#39;</span><span style="color:#24292E;">;</span></span>
<span class="line"></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">result</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">getMajorStarByLunarDate</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&#39;2023-2-17&#39;</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">0</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">true</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">false</span><span style="color:#24292E;">);</span></span></code></pre></div></li><li><p>示例返回值</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#E1E4E8;">紫微,贪狼</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#24292E;">紫微,贪狼</span></span></code></pre></div></li></ul><hr>`,2),A={id:"getsignbysolardate",tabindex:"-1"},v=s("a",{class:"header-anchor",href:"#getsignbysolardate","aria-label":'Permalink to "getSignBySolarDate <Badge type="warning" text="^1.2.1" />"'},"​",-1),S=p(`<ul><li><p>用途</p><p>通过阳历获取星座</p></li><li><p>定义</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">type</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">getSignBySolarDate</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> (</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#FFAB70;">solarDateStr</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">string</span><span style="color:#E1E4E8;">, </span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#FFAB70;">language</span><span style="color:#F97583;">?:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">Language</span></span>
<span class="line"><span style="color:#E1E4E8;">) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">string</span><span style="color:#E1E4E8;">;</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">type</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">getSignBySolarDate</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> (</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#E36209;">solarDateStr</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">string</span><span style="color:#24292E;">, </span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#E36209;">language</span><span style="color:#D73A49;">?:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">Language</span></span>
<span class="line"><span style="color:#24292E;">) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">string</span><span style="color:#24292E;">;</span></span></code></pre></div></li><li><p>参数</p><table><thead><tr><th>参数</th><th>类型</th><th>是否必填</th><th>默认值</th><th>说明</th></tr></thead><tbody><tr><td>solarDateStr</td><td><code>string</code></td><td><code>true</code></td><td>-</td><td>阳历日期【YYYY-M-D】</td></tr><tr><td>language</td><td><a href="./../type-definition.html#language"><code>Language</code></a></td><td><code>false</code></td><td><code>zh-CN</code></td><td>返回数据将被国际化为指定语言。目前支持 <code>zh-CN</code>,<code>zh-TW</code>,<code>en-US</code>,<code>ko-KR</code> 和 <code>ja-JP</code></td></tr></tbody></table></li><li><p>示例</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">import</span><span style="color:#E1E4E8;"> { astro } </span><span style="color:#F97583;">from</span><span style="color:#E1E4E8;"> </span><span style="color:#9ECBFF;">&#39;isztro&#39;</span><span style="color:#E1E4E8;">;</span></span>
<span class="line"></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">result</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">getSignBySolarDate</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&#39;2023-9-5&#39;</span><span style="color:#E1E4E8;">);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">import</span><span style="color:#24292E;"> { astro } </span><span style="color:#D73A49;">from</span><span style="color:#24292E;"> </span><span style="color:#032F62;">&#39;isztro&#39;</span><span style="color:#24292E;">;</span></span>
<span class="line"></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">result</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">getSignBySolarDate</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&#39;2023-9-5&#39;</span><span style="color:#24292E;">);</span></span></code></pre></div></li><li><p>示例返回值</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#E1E4E8;">处女座</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#24292E;">处女座</span></span></code></pre></div></li></ul><hr>`,2),_={id:"getsignbylunardate",tabindex:"-1"},q=s("a",{class:"header-anchor",href:"#getsignbylunardate","aria-label":'Permalink to "getSignByLunarDate <Badge type="warning" text="^1.2.1" />"'},"​",-1),f=p(`<ul><li><p>用途</p><p>通过农历获取星座</p></li><li><p>定义</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">type</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">getSignByLunarDate</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> (</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#FFAB70;">lunarDateStr</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">string</span><span style="color:#E1E4E8;">, </span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#FFAB70;">isLeapMonth</span><span style="color:#F97583;">?:</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;">, </span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#FFAB70;">language</span><span style="color:#F97583;">?:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">Language</span></span>
<span class="line"><span style="color:#E1E4E8;">) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">string</span><span style="color:#E1E4E8;">;</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">type</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">getSignByLunarDate</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> (</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#E36209;">lunarDateStr</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">string</span><span style="color:#24292E;">, </span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#E36209;">isLeapMonth</span><span style="color:#D73A49;">?:</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;">, </span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#E36209;">language</span><span style="color:#D73A49;">?:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">Language</span></span>
<span class="line"><span style="color:#24292E;">) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">string</span><span style="color:#24292E;">;</span></span></code></pre></div></li><li><p>参数</p><table><thead><tr><th>参数</th><th>类型</th><th>是否必填</th><th>默认值</th><th>说明</th></tr></thead><tbody><tr><td>lunarDateStr</td><td><code>string</code></td><td><code>true</code></td><td>-</td><td>农历日期【YYYY-M-D】，例如 <code>2000年七月十七</code> 则传入 <code>2000-7-17</code></td></tr><tr><td>isLeapMonth</td><td><code>boolean</code></td><td><code>false</code></td><td><code>false</code></td><td>是否闰月，当实际月份没有闰月时该参数不生效</td></tr><tr><td>language</td><td><a href="./../type-definition.html#language"><code>Language</code></a></td><td><code>false</code></td><td><code>zh-CN</code></td><td>返回数据将被国际化为指定语言。目前支持 <code>zh-CN</code>,<code>zh-TW</code>,<code>en-US</code>,<code>ko-KR</code> 和 <code>ja-JP</code></td></tr></tbody></table></li><li><p>示例</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">import</span><span style="color:#E1E4E8;"> { astro } </span><span style="color:#F97583;">from</span><span style="color:#E1E4E8;"> </span><span style="color:#9ECBFF;">&#39;isztro&#39;</span><span style="color:#E1E4E8;">;</span></span>
<span class="line"></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">result</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">getSignByLunarDate</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&#39;2023-7-21&#39;</span><span style="color:#E1E4E8;">);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">import</span><span style="color:#24292E;"> { astro } </span><span style="color:#D73A49;">from</span><span style="color:#24292E;"> </span><span style="color:#032F62;">&#39;isztro&#39;</span><span style="color:#24292E;">;</span></span>
<span class="line"></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">result</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">getSignByLunarDate</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&#39;2023-7-21&#39;</span><span style="color:#24292E;">);</span></span></code></pre></div></li><li><p>示例返回值</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#E1E4E8;">处女座</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#24292E;">处女座</span></span></code></pre></div></li></ul><hr>`,2),k={id:"getzodiacbysolardate",tabindex:"-1"},j=s("a",{class:"header-anchor",href:"#getzodiacbysolardate","aria-label":'Permalink to "getZodiacBySolarDate <Badge type="warning" text="^1.2.1" />"'},"​",-1),P=p(`<ul><li><p>用途</p><p>通过公历获取十二生肖</p></li><li><p>定义</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">type</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">getZodiacBySolarDate</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> (</span><span style="color:#FFAB70;">solarDateStr</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">string</span><span style="color:#E1E4E8;">, </span><span style="color:#FFAB70;">language</span><span style="color:#F97583;">?:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">Language</span><span style="color:#E1E4E8;">) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">string</span><span style="color:#E1E4E8;">;</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">type</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">getZodiacBySolarDate</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> (</span><span style="color:#E36209;">solarDateStr</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">string</span><span style="color:#24292E;">, </span><span style="color:#E36209;">language</span><span style="color:#D73A49;">?:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">Language</span><span style="color:#24292E;">) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">string</span><span style="color:#24292E;">;</span></span></code></pre></div></li><li><p>参数</p><table><thead><tr><th>参数</th><th>类型</th><th>是否必填</th><th>默认值</th><th>说明</th></tr></thead><tbody><tr><td>solarDateStr</td><td><code>string</code></td><td><code>true</code></td><td>-</td><td>阳历日期【YYYY-M-D】</td></tr><tr><td>language</td><td><a href="./../type-definition.html#language"><code>Language</code></a></td><td><code>false</code></td><td><code>zh-CN</code></td><td>返回数据将被国际化为指定语言。目前支持 <code>zh-CN</code>,<code>zh-TW</code>,<code>en-US</code>,<code>ko-KR</code> 和 <code>ja-JP</code></td></tr></tbody></table></li><li><p>示例</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">import</span><span style="color:#E1E4E8;"> { astro } </span><span style="color:#F97583;">from</span><span style="color:#E1E4E8;"> </span><span style="color:#9ECBFF;">&#39;isztro&#39;</span><span style="color:#E1E4E8;">;</span></span>
<span class="line"></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">result</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">getZodiacBySolarDate</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&#39;2023-2-20&#39;</span><span style="color:#E1E4E8;">);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">import</span><span style="color:#24292E;"> { astro } </span><span style="color:#D73A49;">from</span><span style="color:#24292E;"> </span><span style="color:#032F62;">&#39;isztro&#39;</span><span style="color:#24292E;">;</span></span>
<span class="line"></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">result</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">getZodiacBySolarDate</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&#39;2023-2-20&#39;</span><span style="color:#24292E;">);</span></span></code></pre></div></li><li><p>示例返回值</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#E1E4E8;">兔</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#24292E;">兔</span></span></code></pre></div></li></ul><hr>`,2),N={id:"getzodiacbylunaryear",tabindex:"-1"},x=s("a",{class:"header-anchor",href:"#getzodiacbylunaryear","aria-label":'Permalink to "getZodiacByLunarYear <Badge type="warning" text="^1.2.1" />"'},"​",-1),T=p(`<ul><li><p>用途</p><p>通过农历年份获取十二生肖</p></li><li><p>定义</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">type</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">getZodiacByLunarYear</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> (</span><span style="color:#FFAB70;">year</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">number</span><span style="color:#E1E4E8;">, </span><span style="color:#FFAB70;">language</span><span style="color:#F97583;">?:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">Language</span><span style="color:#E1E4E8;">) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">string</span><span style="color:#E1E4E8;">;</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">type</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">getZodiacByLunarYear</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> (</span><span style="color:#E36209;">year</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">number</span><span style="color:#24292E;">, </span><span style="color:#E36209;">language</span><span style="color:#D73A49;">?:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">Language</span><span style="color:#24292E;">) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">string</span><span style="color:#24292E;">;</span></span></code></pre></div></li><li><p>参数</p><table><thead><tr><th>参数</th><th>类型</th><th>是否必填</th><th>默认值</th><th>说明</th></tr></thead><tbody><tr><td>year</td><td><code>number</code></td><td><code>true</code></td><td>-</td><td>农历年份</td></tr><tr><td>language</td><td><a href="./../type-definition.html#language"><code>Language</code></a></td><td><code>false</code></td><td><code>zh-CN</code></td><td>返回数据将被国际化为指定语言。目前支持 <code>zh-CN</code>,<code>zh-TW</code>,<code>en-US</code>,<code>ko-KR</code> 和 <code>ja-JP</code></td></tr></tbody></table></li><li><p>示例</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">import</span><span style="color:#E1E4E8;"> { astro } </span><span style="color:#F97583;">from</span><span style="color:#E1E4E8;"> </span><span style="color:#9ECBFF;">&#39;isztro&#39;</span><span style="color:#E1E4E8;">;</span></span>
<span class="line"></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">result</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">getZodiacByLunarYear</span><span style="color:#E1E4E8;">(</span><span style="color:#79B8FF;">2023</span><span style="color:#E1E4E8;">);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">import</span><span style="color:#24292E;"> { astro } </span><span style="color:#D73A49;">from</span><span style="color:#24292E;"> </span><span style="color:#032F62;">&#39;isztro&#39;</span><span style="color:#24292E;">;</span></span>
<span class="line"></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">result</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">getZodiacByLunarYear</span><span style="color:#24292E;">(</span><span style="color:#005CC5;">2023</span><span style="color:#24292E;">);</span></span></code></pre></div></li><li><p>示例返回值</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#E1E4E8;">兔</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#24292E;">兔</span></span></code></pre></div></li></ul><hr><h3 id="功能类定义" tabindex="-1">功能类定义 <a class="header-anchor" href="#功能类定义" aria-label="Permalink to &quot;功能类定义&quot;">​</a></h3><div class="warning custom-block"><p class="custom-block-title">开发建议</p><p>我们推荐你直接调用 <a href="./astrolabe.html#astro-的静态方法">astro 的静态方法</a> 来获取数据，而不是手动去创建一个 <code>FunctionalAstrolabe</code> 类的实例。</p></div><h4 id="functionalastrolabe" tabindex="-1">FunctionalAstrolabe <a class="header-anchor" href="#functionalastrolabe" aria-label="Permalink to &quot;FunctionalAstrolabe&quot;">​</a></h4><hr>`,6),z=s("code",null,"IFunctionalAstrolabe",-1),O=s("a",{href:"./../type-definition.html#astrolabe"},[s("code",null,"Astrolabe")],-1),L=s("p",null,[a("该类所有属性都是继承自 "),s("a",{href:"./../type-definition.html#astrolabe"},"Astrolabe"),a("，然后在接口内定义了一些方法用于对星盘的分析。"),s("a",{href:"./astrolabe.html#astrolabebysolardate"},[s("code",null,"astrolabeBySolarDate()")]),a(" 和 "),s("a",{href:"./astrolabe.html#astrolabeByLunarDate"},[s("code",null,"astrolabeByLunarDate()")]),a(" 方法会返回一个该类的实例。")],-1),I=p(`<li><p>接口定义</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">interface</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">IFunctionalAstrolabe</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">extends</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">Astrolabe</span><span style="color:#E1E4E8;"> {</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#B392F0;">horoscope</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> (</span><span style="color:#FFAB70;">date</span><span style="color:#F97583;">?:</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">string</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">|</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">Date</span><span style="color:#E1E4E8;">, </span><span style="color:#FFAB70;">timeIndex</span><span style="color:#F97583;">?:</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">number</span><span style="color:#E1E4E8;">) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">Horoscope</span><span style="color:#E1E4E8;">;</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#B392F0;">palace</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> (</span><span style="color:#FFAB70;">indexOrName</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">number</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">|</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">PalaceName</span><span style="color:#E1E4E8;">) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">IFunctionalPalace</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">|</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">undefined</span><span style="color:#E1E4E8;">;</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#B392F0;">surroundedPalaces</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> (</span><span style="color:#FFAB70;">indexOrName</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">number</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">|</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">PalaceName</span><span style="color:#E1E4E8;">) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">SurroundedPalaces</span><span style="color:#E1E4E8;">;</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#B392F0;">isSurrounded</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> (</span></span>
<span class="line"><span style="color:#E1E4E8;">    </span><span style="color:#FFAB70;">indexOrName</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">number</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">|</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">PalaceName</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">    </span><span style="color:#FFAB70;">stars</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">StarName</span><span style="color:#E1E4E8;">[]</span></span>
<span class="line"><span style="color:#E1E4E8;">  ) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;">;</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#B392F0;">isSurroundedOneOf</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> (</span></span>
<span class="line"><span style="color:#E1E4E8;">    </span><span style="color:#FFAB70;">indexOrName</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">number</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">|</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">PalaceName</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">    </span><span style="color:#FFAB70;">stars</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">StarName</span><span style="color:#E1E4E8;">[]</span></span>
<span class="line"><span style="color:#E1E4E8;">  ) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;">;</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#B392F0;">notSurrounded</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> (</span></span>
<span class="line"><span style="color:#E1E4E8;">    </span><span style="color:#FFAB70;">indexOrName</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">number</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">|</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">PalaceName</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">    </span><span style="color:#FFAB70;">stars</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">StarName</span><span style="color:#E1E4E8;">[]</span></span>
<span class="line"><span style="color:#E1E4E8;">  ) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;">;</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#B392F0;">hasMutagenInSurroundedPalace</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> (</span></span>
<span class="line"><span style="color:#E1E4E8;">    </span><span style="color:#FFAB70;">indexOrName</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">number</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">|</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">PalaceName</span><span style="color:#E1E4E8;">, </span></span>
<span class="line"><span style="color:#E1E4E8;">    </span><span style="color:#FFAB70;">mutagen</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">Mutagen</span></span>
<span class="line"><span style="color:#E1E4E8;">  ) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;">;</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#B392F0;">hasMutagenInOppositePalace</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> (</span></span>
<span class="line"><span style="color:#E1E4E8;">    </span><span style="color:#FFAB70;">indexOrName</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">number</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">|</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">PalaceName</span><span style="color:#E1E4E8;">,</span></span>
<span class="line"><span style="color:#E1E4E8;">    </span><span style="color:#FFAB70;">mutagen</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">Mutagen</span></span>
<span class="line"><span style="color:#E1E4E8;">  ) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;">;</span></span>
<span class="line"><span style="color:#E1E4E8;">}</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">interface</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">IFunctionalAstrolabe</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">extends</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">Astrolabe</span><span style="color:#24292E;"> {</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6F42C1;">horoscope</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> (</span><span style="color:#E36209;">date</span><span style="color:#D73A49;">?:</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">string</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">|</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">Date</span><span style="color:#24292E;">, </span><span style="color:#E36209;">timeIndex</span><span style="color:#D73A49;">?:</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">number</span><span style="color:#24292E;">) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">Horoscope</span><span style="color:#24292E;">;</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6F42C1;">palace</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> (</span><span style="color:#E36209;">indexOrName</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">number</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">|</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">PalaceName</span><span style="color:#24292E;">) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">IFunctionalPalace</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">|</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">undefined</span><span style="color:#24292E;">;</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6F42C1;">surroundedPalaces</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> (</span><span style="color:#E36209;">indexOrName</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">number</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">|</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">PalaceName</span><span style="color:#24292E;">) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">SurroundedPalaces</span><span style="color:#24292E;">;</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6F42C1;">isSurrounded</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> (</span></span>
<span class="line"><span style="color:#24292E;">    </span><span style="color:#E36209;">indexOrName</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">number</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">|</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">PalaceName</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">    </span><span style="color:#E36209;">stars</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">StarName</span><span style="color:#24292E;">[]</span></span>
<span class="line"><span style="color:#24292E;">  ) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;">;</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6F42C1;">isSurroundedOneOf</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> (</span></span>
<span class="line"><span style="color:#24292E;">    </span><span style="color:#E36209;">indexOrName</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">number</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">|</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">PalaceName</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">    </span><span style="color:#E36209;">stars</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">StarName</span><span style="color:#24292E;">[]</span></span>
<span class="line"><span style="color:#24292E;">  ) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;">;</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6F42C1;">notSurrounded</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> (</span></span>
<span class="line"><span style="color:#24292E;">    </span><span style="color:#E36209;">indexOrName</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">number</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">|</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">PalaceName</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">    </span><span style="color:#E36209;">stars</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">StarName</span><span style="color:#24292E;">[]</span></span>
<span class="line"><span style="color:#24292E;">  ) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;">;</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6F42C1;">hasMutagenInSurroundedPalace</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> (</span></span>
<span class="line"><span style="color:#24292E;">    </span><span style="color:#E36209;">indexOrName</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">number</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">|</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">PalaceName</span><span style="color:#24292E;">, </span></span>
<span class="line"><span style="color:#24292E;">    </span><span style="color:#E36209;">mutagen</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">Mutagen</span></span>
<span class="line"><span style="color:#24292E;">  ) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;">;</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6F42C1;">hasMutagenInOppositePalace</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> (</span></span>
<span class="line"><span style="color:#24292E;">    </span><span style="color:#E36209;">indexOrName</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">number</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">|</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">PalaceName</span><span style="color:#24292E;">,</span></span>
<span class="line"><span style="color:#24292E;">    </span><span style="color:#E36209;">mutagen</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">Mutagen</span></span>
<span class="line"><span style="color:#24292E;">  ) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;">;</span></span>
<span class="line"><span style="color:#24292E;">}</span></span></code></pre></div></li><li><p>属性</p><p>参考 <a href="./../type-definition.html#astrolabe">Astrolabe</a></p></li>`,2),Y=s("p",null,"方法",-1),w={id:"horoscope",tabindex:"-1"},M=s("a",{class:"header-anchor",href:"#horoscope","aria-label":'Permalink to "horoscope() <Badge type="warning" text="^0.2.0" />"'},"​",-1),V=p('<li><p>用途</p><p>获取运限数据。如果只是想获取调用时的运限数据，可以不传任何参数，该方法会获取系统当前时间进行计算。</p><div class="warning custom-block"><p class="custom-block-title">注意</p><ul><li>当 <code>date</code> 为 <code>YYYY-M-D</code> 格式的字符串而没有传 <code>timeIndex</code> 参数时，会取 <code>date</code> 当日 <code>早子时</code> 的时间点作为 <code>流时</code> 的时间</li><li>当 <code>date</code> 为 <code>YYYY-M-D HH</code> 格式时间或是一个 <code>Date</code> 实例而没有传 <code>timeIndex</code> 参数时，会将 <code>date</code> 里的小时转化为时辰作为 <code>流时</code> 的时间</li><li>当传入 <code>timeIndex</code> 参数时，会优先使用该参数</li></ul></div></li><li><p>定义</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">type</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">horoscope</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> (</span><span style="color:#FFAB70;">date</span><span style="color:#F97583;">?:</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">string</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">|</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">Date</span><span style="color:#E1E4E8;">, </span><span style="color:#FFAB70;">timeIndex</span><span style="color:#F97583;">?:</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">number</span><span style="color:#E1E4E8;">) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">Horoscope</span><span style="color:#E1E4E8;">;</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">type</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">horoscope</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> (</span><span style="color:#E36209;">date</span><span style="color:#D73A49;">?:</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">string</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">|</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">Date</span><span style="color:#24292E;">, </span><span style="color:#E36209;">timeIndex</span><span style="color:#D73A49;">?:</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">number</span><span style="color:#24292E;">) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">Horoscope</span><span style="color:#24292E;">;</span></span></code></pre></div></li><li><p>参数</p><table><thead><tr><th>参数</th><th>类型</th><th>是否必填</th><th>默认值</th><th>说明</th></tr></thead><tbody><tr><td>date</td><td><code>string</code> | <code>Date</code></td><td><code>false</code></td><td><code>new Date()</code></td><td>阳历日期【YYYY-M-D】</td></tr><tr><td>timeIndex</td><td><code>number</code></td><td><code>false</code></td><td><code>0</code></td><td>时辰索引【0~12】</td></tr></tbody></table></li><li><p>返回值</p><p><a href="./../type-definition.html#horoscope"><code>Horoscope</code></a></p></li>',4),R=s("p",null,"示例",-1),Z=s("div",{class:"language-ts vp-adaptive-theme"},[s("button",{title:"Copy Code",class:"copy"}),s("span",{class:"lang"},"ts"),s("pre",{class:"shiki github-dark vp-code-dark"},[s("code",null,[s("span",{class:"line"},[s("span",{style:{color:"#F97583"}},"import"),s("span",{style:{color:"#E1E4E8"}}," { astro } "),s("span",{style:{color:"#F97583"}},"from"),s("span",{style:{color:"#E1E4E8"}}," "),s("span",{style:{color:"#9ECBFF"}},'"iztro"'),s("span",{style:{color:"#E1E4E8"}},";")]),a(`
`),s("span",{class:"line"}),a(`
`),s("span",{class:"line"},[s("span",{style:{color:"#F97583"}},"const"),s("span",{style:{color:"#E1E4E8"}}," "),s("span",{style:{color:"#79B8FF"}},"astrolabe"),s("span",{style:{color:"#E1E4E8"}}," "),s("span",{style:{color:"#F97583"}},"="),s("span",{style:{color:"#E1E4E8"}}," astro."),s("span",{style:{color:"#B392F0"}},"astrolabeBySolarDate"),s("span",{style:{color:"#E1E4E8"}},"("),s("span",{style:{color:"#9ECBFF"}},'"2000-8-16"'),s("span",{style:{color:"#E1E4E8"}},", "),s("span",{style:{color:"#79B8FF"}},"2"),s("span",{style:{color:"#E1E4E8"}},", "),s("span",{style:{color:"#9ECBFF"}},'"女"'),s("span",{style:{color:"#E1E4E8"}},", "),s("span",{style:{color:"#79B8FF"}},"true"),s("span",{style:{color:"#E1E4E8"}},", "),s("span",{style:{color:"#9ECBFF"}},'"zh-CN"'),s("span",{style:{color:"#E1E4E8"}},");")]),a(`
`),s("span",{class:"line"},[s("span",{style:{color:"#F97583"}},"const"),s("span",{style:{color:"#E1E4E8"}}," "),s("span",{style:{color:"#79B8FF"}},"horoscope"),s("span",{style:{color:"#E1E4E8"}}," "),s("span",{style:{color:"#F97583"}},"="),s("span",{style:{color:"#E1E4E8"}}," astrolabe."),s("span",{style:{color:"#B392F0"}},"horoscope"),s("span",{style:{color:"#E1E4E8"}},"();")])])]),s("pre",{class:"shiki github-light vp-code-light"},[s("code",null,[s("span",{class:"line"},[s("span",{style:{color:"#D73A49"}},"import"),s("span",{style:{color:"#24292E"}}," { astro } "),s("span",{style:{color:"#D73A49"}},"from"),s("span",{style:{color:"#24292E"}}," "),s("span",{style:{color:"#032F62"}},'"iztro"'),s("span",{style:{color:"#24292E"}},";")]),a(`
`),s("span",{class:"line"}),a(`
`),s("span",{class:"line"},[s("span",{style:{color:"#D73A49"}},"const"),s("span",{style:{color:"#24292E"}}," "),s("span",{style:{color:"#005CC5"}},"astrolabe"),s("span",{style:{color:"#24292E"}}," "),s("span",{style:{color:"#D73A49"}},"="),s("span",{style:{color:"#24292E"}}," astro."),s("span",{style:{color:"#6F42C1"}},"astrolabeBySolarDate"),s("span",{style:{color:"#24292E"}},"("),s("span",{style:{color:"#032F62"}},'"2000-8-16"'),s("span",{style:{color:"#24292E"}},", "),s("span",{style:{color:"#005CC5"}},"2"),s("span",{style:{color:"#24292E"}},", "),s("span",{style:{color:"#032F62"}},'"女"'),s("span",{style:{color:"#24292E"}},", "),s("span",{style:{color:"#005CC5"}},"true"),s("span",{style:{color:"#24292E"}},", "),s("span",{style:{color:"#032F62"}},'"zh-CN"'),s("span",{style:{color:"#24292E"}},");")]),a(`
`),s("span",{class:"line"},[s("span",{style:{color:"#D73A49"}},"const"),s("span",{style:{color:"#24292E"}}," "),s("span",{style:{color:"#005CC5"}},"horoscope"),s("span",{style:{color:"#24292E"}}," "),s("span",{style:{color:"#D73A49"}},"="),s("span",{style:{color:"#24292E"}}," astrolabe."),s("span",{style:{color:"#6F42C1"}},"horoscope"),s("span",{style:{color:"#24292E"}},"();")])])])],-1),J=s("div",{class:"language-ts vp-adaptive-theme"},[s("button",{title:"Copy Code",class:"copy"}),s("span",{class:"lang"},"ts"),s("pre",{class:"shiki github-dark vp-code-dark"},[s("code",null,[s("span",{class:"line"},[s("span",{style:{color:"#F97583"}},"import"),s("span",{style:{color:"#E1E4E8"}}," { astro } "),s("span",{style:{color:"#F97583"}},"from"),s("span",{style:{color:"#E1E4E8"}}," "),s("span",{style:{color:"#9ECBFF"}},'"iztro"'),s("span",{style:{color:"#E1E4E8"}},";")]),a(`
`),s("span",{class:"line"}),a(`
`),s("span",{class:"line"},[s("span",{style:{color:"#F97583"}},"const"),s("span",{style:{color:"#E1E4E8"}}," "),s("span",{style:{color:"#79B8FF"}},"astrolabe"),s("span",{style:{color:"#E1E4E8"}}," "),s("span",{style:{color:"#F97583"}},"="),s("span",{style:{color:"#E1E4E8"}}," astro."),s("span",{style:{color:"#B392F0"}},"astrolabeBySolarDate"),s("span",{style:{color:"#E1E4E8"}},"(")]),a(`
`),s("span",{class:"line"},[s("span",{style:{color:"#E1E4E8"}},"  "),s("span",{style:{color:"#9ECBFF"}},'"2000-8-16"'),s("span",{style:{color:"#E1E4E8"}},",")]),a(`
`),s("span",{class:"line"},[s("span",{style:{color:"#E1E4E8"}},"  "),s("span",{style:{color:"#79B8FF"}},"2"),s("span",{style:{color:"#E1E4E8"}},",")]),a(`
`),s("span",{class:"line"},[s("span",{style:{color:"#E1E4E8"}},"  "),s("span",{style:{color:"#9ECBFF"}},'"女"'),s("span",{style:{color:"#E1E4E8"}},",")]),a(`
`),s("span",{class:"line"},[s("span",{style:{color:"#E1E4E8"}},"  "),s("span",{style:{color:"#79B8FF"}},"true"),s("span",{style:{color:"#E1E4E8"}},",")]),a(`
`),s("span",{class:"line"},[s("span",{style:{color:"#E1E4E8"}},"  "),s("span",{style:{color:"#9ECBFF"}},'"zh-CN"')]),a(`
`),s("span",{class:"line"},[s("span",{style:{color:"#E1E4E8"}},");")]),a(`
`),s("span",{class:"line"},[s("span",{style:{color:"#F97583"}},"const"),s("span",{style:{color:"#E1E4E8"}}," "),s("span",{style:{color:"#79B8FF"}},"horoscope"),s("span",{style:{color:"#E1E4E8"}}," "),s("span",{style:{color:"#F97583"}},"="),s("span",{style:{color:"#E1E4E8"}}," astrolabe."),s("span",{style:{color:"#B392F0"}},"horoscope"),s("span",{style:{color:"#E1E4E8"}},"("),s("span",{style:{color:"#9ECBFF"}},'"2023-8-31"'),s("span",{style:{color:"#E1E4E8"}},");")])])]),s("pre",{class:"shiki github-light vp-code-light"},[s("code",null,[s("span",{class:"line"},[s("span",{style:{color:"#D73A49"}},"import"),s("span",{style:{color:"#24292E"}}," { astro } "),s("span",{style:{color:"#D73A49"}},"from"),s("span",{style:{color:"#24292E"}}," "),s("span",{style:{color:"#032F62"}},'"iztro"'),s("span",{style:{color:"#24292E"}},";")]),a(`
`),s("span",{class:"line"}),a(`
`),s("span",{class:"line"},[s("span",{style:{color:"#D73A49"}},"const"),s("span",{style:{color:"#24292E"}}," "),s("span",{style:{color:"#005CC5"}},"astrolabe"),s("span",{style:{color:"#24292E"}}," "),s("span",{style:{color:"#D73A49"}},"="),s("span",{style:{color:"#24292E"}}," astro."),s("span",{style:{color:"#6F42C1"}},"astrolabeBySolarDate"),s("span",{style:{color:"#24292E"}},"(")]),a(`
`),s("span",{class:"line"},[s("span",{style:{color:"#24292E"}},"  "),s("span",{style:{color:"#032F62"}},'"2000-8-16"'),s("span",{style:{color:"#24292E"}},",")]),a(`
`),s("span",{class:"line"},[s("span",{style:{color:"#24292E"}},"  "),s("span",{style:{color:"#005CC5"}},"2"),s("span",{style:{color:"#24292E"}},",")]),a(`
`),s("span",{class:"line"},[s("span",{style:{color:"#24292E"}},"  "),s("span",{style:{color:"#032F62"}},'"女"'),s("span",{style:{color:"#24292E"}},",")]),a(`
`),s("span",{class:"line"},[s("span",{style:{color:"#24292E"}},"  "),s("span",{style:{color:"#005CC5"}},"true"),s("span",{style:{color:"#24292E"}},",")]),a(`
`),s("span",{class:"line"},[s("span",{style:{color:"#24292E"}},"  "),s("span",{style:{color:"#032F62"}},'"zh-CN"')]),a(`
`),s("span",{class:"line"},[s("span",{style:{color:"#24292E"}},");")]),a(`
`),s("span",{class:"line"},[s("span",{style:{color:"#D73A49"}},"const"),s("span",{style:{color:"#24292E"}}," "),s("span",{style:{color:"#005CC5"}},"horoscope"),s("span",{style:{color:"#24292E"}}," "),s("span",{style:{color:"#D73A49"}},"="),s("span",{style:{color:"#24292E"}}," astrolabe."),s("span",{style:{color:"#6F42C1"}},"horoscope"),s("span",{style:{color:"#24292E"}},"("),s("span",{style:{color:"#032F62"}},'"2023-8-31"'),s("span",{style:{color:"#24292E"}},");")])])])],-1),H=s("div",{class:"language-ts vp-adaptive-theme"},[s("button",{title:"Copy Code",class:"copy"}),s("span",{class:"lang"},"ts"),s("pre",{class:"shiki github-dark vp-code-dark"},[s("code",null,[s("span",{class:"line"},[s("span",{style:{color:"#F97583"}},"import"),s("span",{style:{color:"#E1E4E8"}}," { astro } "),s("span",{style:{color:"#F97583"}},"from"),s("span",{style:{color:"#E1E4E8"}}," "),s("span",{style:{color:"#9ECBFF"}},'"iztro"'),s("span",{style:{color:"#E1E4E8"}},";")]),a(`
`),s("span",{class:"line"}),a(`
`),s("span",{class:"line"},[s("span",{style:{color:"#F97583"}},"const"),s("span",{style:{color:"#E1E4E8"}}," "),s("span",{style:{color:"#79B8FF"}},"astrolabe"),s("span",{style:{color:"#E1E4E8"}}," "),s("span",{style:{color:"#F97583"}},"="),s("span",{style:{color:"#E1E4E8"}}," astro."),s("span",{style:{color:"#B392F0"}},"astrolabeBySolarDate"),s("span",{style:{color:"#E1E4E8"}},"("),s("span",{style:{color:"#9ECBFF"}},'"2000-8-16"'),s("span",{style:{color:"#E1E4E8"}},", "),s("span",{style:{color:"#79B8FF"}},"2"),s("span",{style:{color:"#E1E4E8"}},", "),s("span",{style:{color:"#9ECBFF"}},'"女"'),s("span",{style:{color:"#E1E4E8"}},", "),s("span",{style:{color:"#79B8FF"}},"true"),s("span",{style:{color:"#E1E4E8"}},", "),s("span",{style:{color:"#9ECBFF"}},'"zh-CN"'),s("span",{style:{color:"#E1E4E8"}},");")]),a(`
`),s("span",{class:"line"},[s("span",{style:{color:"#F97583"}},"const"),s("span",{style:{color:"#E1E4E8"}}," "),s("span",{style:{color:"#79B8FF"}},"horoscope"),s("span",{style:{color:"#E1E4E8"}}," "),s("span",{style:{color:"#F97583"}},"="),s("span",{style:{color:"#E1E4E8"}}," astrolabe."),s("span",{style:{color:"#B392F0"}},"horoscope"),s("span",{style:{color:"#E1E4E8"}},"("),s("span",{style:{color:"#F97583"}},"new"),s("span",{style:{color:"#E1E4E8"}}," "),s("span",{style:{color:"#B392F0"}},"Date"),s("span",{style:{color:"#E1E4E8"}},"("),s("span",{style:{color:"#79B8FF"}},"1693494208392"),s("span",{style:{color:"#E1E4E8"}},"));")])])]),s("pre",{class:"shiki github-light vp-code-light"},[s("code",null,[s("span",{class:"line"},[s("span",{style:{color:"#D73A49"}},"import"),s("span",{style:{color:"#24292E"}}," { astro } "),s("span",{style:{color:"#D73A49"}},"from"),s("span",{style:{color:"#24292E"}}," "),s("span",{style:{color:"#032F62"}},'"iztro"'),s("span",{style:{color:"#24292E"}},";")]),a(`
`),s("span",{class:"line"}),a(`
`),s("span",{class:"line"},[s("span",{style:{color:"#D73A49"}},"const"),s("span",{style:{color:"#24292E"}}," "),s("span",{style:{color:"#005CC5"}},"astrolabe"),s("span",{style:{color:"#24292E"}}," "),s("span",{style:{color:"#D73A49"}},"="),s("span",{style:{color:"#24292E"}}," astro."),s("span",{style:{color:"#6F42C1"}},"astrolabeBySolarDate"),s("span",{style:{color:"#24292E"}},"("),s("span",{style:{color:"#032F62"}},'"2000-8-16"'),s("span",{style:{color:"#24292E"}},", "),s("span",{style:{color:"#005CC5"}},"2"),s("span",{style:{color:"#24292E"}},", "),s("span",{style:{color:"#032F62"}},'"女"'),s("span",{style:{color:"#24292E"}},", "),s("span",{style:{color:"#005CC5"}},"true"),s("span",{style:{color:"#24292E"}},", "),s("span",{style:{color:"#032F62"}},'"zh-CN"'),s("span",{style:{color:"#24292E"}},");")]),a(`
`),s("span",{class:"line"},[s("span",{style:{color:"#D73A49"}},"const"),s("span",{style:{color:"#24292E"}}," "),s("span",{style:{color:"#005CC5"}},"horoscope"),s("span",{style:{color:"#24292E"}}," "),s("span",{style:{color:"#D73A49"}},"="),s("span",{style:{color:"#24292E"}}," astrolabe."),s("span",{style:{color:"#6F42C1"}},"horoscope"),s("span",{style:{color:"#24292E"}},"("),s("span",{style:{color:"#D73A49"}},"new"),s("span",{style:{color:"#24292E"}}," "),s("span",{style:{color:"#6F42C1"}},"Date"),s("span",{style:{color:"#24292E"}},"("),s("span",{style:{color:"#005CC5"}},"1693494208392"),s("span",{style:{color:"#24292E"}},"));")])])])],-1),K=s("div",{class:"language-ts vp-adaptive-theme"},[s("button",{title:"Copy Code",class:"copy"}),s("span",{class:"lang"},"ts"),s("pre",{class:"shiki github-dark vp-code-dark"},[s("code",null,[s("span",{class:"line"},[s("span",{style:{color:"#F97583"}},"import"),s("span",{style:{color:"#E1E4E8"}}," { astro } "),s("span",{style:{color:"#F97583"}},"from"),s("span",{style:{color:"#E1E4E8"}}," "),s("span",{style:{color:"#9ECBFF"}},'"iztro"'),s("span",{style:{color:"#E1E4E8"}},";")]),a(`
`),s("span",{class:"line"}),a(`
`),s("span",{class:"line"},[s("span",{style:{color:"#F97583"}},"const"),s("span",{style:{color:"#E1E4E8"}}," "),s("span",{style:{color:"#79B8FF"}},"astrolabe"),s("span",{style:{color:"#E1E4E8"}}," "),s("span",{style:{color:"#F97583"}},"="),s("span",{style:{color:"#E1E4E8"}}," astro."),s("span",{style:{color:"#B392F0"}},"astrolabeBySolarDate"),s("span",{style:{color:"#E1E4E8"}},"("),s("span",{style:{color:"#9ECBFF"}},'"2000-8-16"'),s("span",{style:{color:"#E1E4E8"}},", "),s("span",{style:{color:"#79B8FF"}},"2"),s("span",{style:{color:"#E1E4E8"}},", "),s("span",{style:{color:"#9ECBFF"}},'"女"'),s("span",{style:{color:"#E1E4E8"}},", "),s("span",{style:{color:"#79B8FF"}},"true"),s("span",{style:{color:"#E1E4E8"}},", "),s("span",{style:{color:"#9ECBFF"}},'"zh-CN"'),s("span",{style:{color:"#E1E4E8"}},");")]),a(`
`),s("span",{class:"line"},[s("span",{style:{color:"#F97583"}},"const"),s("span",{style:{color:"#E1E4E8"}}," "),s("span",{style:{color:"#79B8FF"}},"horoscope"),s("span",{style:{color:"#E1E4E8"}}," "),s("span",{style:{color:"#F97583"}},"="),s("span",{style:{color:"#E1E4E8"}}," astrolabe."),s("span",{style:{color:"#B392F0"}},"horoscope"),s("span",{style:{color:"#E1E4E8"}},"("),s("span",{style:{color:"#F97583"}},"new"),s("span",{style:{color:"#E1E4E8"}}," "),s("span",{style:{color:"#B392F0"}},"Date"),s("span",{style:{color:"#E1E4E8"}},"("),s("span",{style:{color:"#79B8FF"}},"1693494208392"),s("span",{style:{color:"#E1E4E8"}},"), "),s("span",{style:{color:"#79B8FF"}},"3"),s("span",{style:{color:"#E1E4E8"}},");")])])]),s("pre",{class:"shiki github-light vp-code-light"},[s("code",null,[s("span",{class:"line"},[s("span",{style:{color:"#D73A49"}},"import"),s("span",{style:{color:"#24292E"}}," { astro } "),s("span",{style:{color:"#D73A49"}},"from"),s("span",{style:{color:"#24292E"}}," "),s("span",{style:{color:"#032F62"}},'"iztro"'),s("span",{style:{color:"#24292E"}},";")]),a(`
`),s("span",{class:"line"}),a(`
`),s("span",{class:"line"},[s("span",{style:{color:"#D73A49"}},"const"),s("span",{style:{color:"#24292E"}}," "),s("span",{style:{color:"#005CC5"}},"astrolabe"),s("span",{style:{color:"#24292E"}}," "),s("span",{style:{color:"#D73A49"}},"="),s("span",{style:{color:"#24292E"}}," astro."),s("span",{style:{color:"#6F42C1"}},"astrolabeBySolarDate"),s("span",{style:{color:"#24292E"}},"("),s("span",{style:{color:"#032F62"}},'"2000-8-16"'),s("span",{style:{color:"#24292E"}},", "),s("span",{style:{color:"#005CC5"}},"2"),s("span",{style:{color:"#24292E"}},", "),s("span",{style:{color:"#032F62"}},'"女"'),s("span",{style:{color:"#24292E"}},", "),s("span",{style:{color:"#005CC5"}},"true"),s("span",{style:{color:"#24292E"}},", "),s("span",{style:{color:"#032F62"}},'"zh-CN"'),s("span",{style:{color:"#24292E"}},");")]),a(`
`),s("span",{class:"line"},[s("span",{style:{color:"#D73A49"}},"const"),s("span",{style:{color:"#24292E"}}," "),s("span",{style:{color:"#005CC5"}},"horoscope"),s("span",{style:{color:"#24292E"}}," "),s("span",{style:{color:"#D73A49"}},"="),s("span",{style:{color:"#24292E"}}," astrolabe."),s("span",{style:{color:"#6F42C1"}},"horoscope"),s("span",{style:{color:"#24292E"}},"("),s("span",{style:{color:"#D73A49"}},"new"),s("span",{style:{color:"#24292E"}}," "),s("span",{style:{color:"#6F42C1"}},"Date"),s("span",{style:{color:"#24292E"}},"("),s("span",{style:{color:"#005CC5"}},"1693494208392"),s("span",{style:{color:"#24292E"}},"), "),s("span",{style:{color:"#005CC5"}},"3"),s("span",{style:{color:"#24292E"}},");")])])])],-1),U=s("hr",null,null,-1),W={id:"star",tabindex:"-1"},G=s("a",{class:"header-anchor",href:"#star","aria-label":'Permalink to "star() <Badge type="warning" text="^1.2.0" />"'},"​",-1),$=p(`<ul><li><p>用途</p><p>通过星耀名称获取到当前星耀的对象实例</p></li><li><p>定义</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">type</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">star</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> (</span><span style="color:#FFAB70;">starName</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">StarName</span><span style="color:#E1E4E8;">) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">IFunctionalStar</span><span style="color:#E1E4E8;">;</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">type</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">star</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> (</span><span style="color:#E36209;">starName</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">StarName</span><span style="color:#24292E;">) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">IFunctionalStar</span><span style="color:#24292E;">;</span></span></code></pre></div></li><li><p>参数</p><table><thead><tr><th>参数</th><th>类型</th><th>是否必填</th><th>默认值</th><th>说明</th></tr></thead><tbody><tr><td>starName</td><td><a href="./../type-definition.html#starname"><code>StarName</code></a></td><td><code>true</code></td><td>-</td><td>星耀名称</td></tr></tbody></table></li><li><p>返回值</p><p><a href="./star.html#functionalstar"><code>FunctionalStar</code></a></p></li><li><p>示例</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">import</span><span style="color:#E1E4E8;"> { astro } </span><span style="color:#F97583;">from</span><span style="color:#E1E4E8;"> </span><span style="color:#9ECBFF;">&quot;iztro&quot;</span><span style="color:#E1E4E8;">;</span></span>
<span class="line"></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">astrolabe</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astro.</span><span style="color:#B392F0;">astrolabeBySolarDate</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;2000-8-16&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">2</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;女&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">true</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;zh-CN&quot;</span><span style="color:#E1E4E8;">);</span></span>
<span class="line"></span>
<span class="line"><span style="color:#6A737D;">// 获取 \`紫微星\` 所在宫位</span></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">star</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">star</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;紫微&quot;</span><span style="color:#E1E4E8;">);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">import</span><span style="color:#24292E;"> { astro } </span><span style="color:#D73A49;">from</span><span style="color:#24292E;"> </span><span style="color:#032F62;">&quot;iztro&quot;</span><span style="color:#24292E;">;</span></span>
<span class="line"></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">astrolabe</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astro.</span><span style="color:#6F42C1;">astrolabeBySolarDate</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;2000-8-16&quot;</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">2</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;女&quot;</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">true</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;zh-CN&quot;</span><span style="color:#24292E;">);</span></span>
<span class="line"></span>
<span class="line"><span style="color:#6A737D;">// 获取 \`紫微星\` 所在宫位</span></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">star</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">star</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;紫微&quot;</span><span style="color:#24292E;">);</span></span></code></pre></div></li></ul><hr>`,2),Q={id:"palace",tabindex:"-1"},X=s("a",{class:"header-anchor",href:"#palace","aria-label":'Permalink to "palace() <Badge type="warning" text="^1.0.0" />"'},"​",-1),ss=p(`<ul><li><p>用途</p><p>获取星盘的指定 <code>宫位</code></p></li><li><p>定义</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">type</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">palace</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> (</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#FFAB70;">indexOrName</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">number</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">|</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">PalaceName</span></span>
<span class="line"><span style="color:#E1E4E8;">) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">IFunctionalPalace</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">|</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">undefined</span><span style="color:#E1E4E8;">;</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">type</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">palace</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> (</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#E36209;">indexOrName</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">number</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">|</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">PalaceName</span></span>
<span class="line"><span style="color:#24292E;">) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">IFunctionalPalace</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">|</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">undefined</span><span style="color:#24292E;">;</span></span></code></pre></div></li><li><p>参数</p><table><thead><tr><th>参数</th><th>类型</th><th>是否必填</th><th>默认值</th><th>说明</th></tr></thead><tbody><tr><td>indexOrName</td><td><code>number</code> | <a href="./../type-definition.html#palacename"><code>PalaceName</code></a></td><td><code>true</code></td><td>-</td><td>宫位索引或者宫位名称</td></tr></tbody></table></li><li><p>返回值</p><p><a href="./palace.html#functionalpalace"><code>FunctionalPalace</code></a></p></li><li><p>示例</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">import</span><span style="color:#E1E4E8;"> { astro } </span><span style="color:#F97583;">from</span><span style="color:#E1E4E8;"> </span><span style="color:#9ECBFF;">&quot;iztro&quot;</span><span style="color:#E1E4E8;">;</span></span>
<span class="line"></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">astrolabe</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astro.</span><span style="color:#B392F0;">astrolabeBySolarDate</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;2000-8-16&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">2</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;女&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">true</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;zh-CN&quot;</span><span style="color:#E1E4E8;">);</span></span>
<span class="line"></span>
<span class="line"><span style="color:#6A737D;">// 获取 \`寅宫\`</span></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">palace</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">palace</span><span style="color:#E1E4E8;">(</span><span style="color:#79B8FF;">0</span><span style="color:#E1E4E8;">);</span></span>
<span class="line"></span>
<span class="line"><span style="color:#6A737D;">// 获取 \`命宫\`</span></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">soulPalace</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">palace</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;命宫&quot;</span><span style="color:#E1E4E8;">);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">import</span><span style="color:#24292E;"> { astro } </span><span style="color:#D73A49;">from</span><span style="color:#24292E;"> </span><span style="color:#032F62;">&quot;iztro&quot;</span><span style="color:#24292E;">;</span></span>
<span class="line"></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">astrolabe</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astro.</span><span style="color:#6F42C1;">astrolabeBySolarDate</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;2000-8-16&quot;</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">2</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;女&quot;</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">true</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;zh-CN&quot;</span><span style="color:#24292E;">);</span></span>
<span class="line"></span>
<span class="line"><span style="color:#6A737D;">// 获取 \`寅宫\`</span></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">palace</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">palace</span><span style="color:#24292E;">(</span><span style="color:#005CC5;">0</span><span style="color:#24292E;">);</span></span>
<span class="line"></span>
<span class="line"><span style="color:#6A737D;">// 获取 \`命宫\`</span></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">soulPalace</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">palace</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;命宫&quot;</span><span style="color:#24292E;">);</span></span></code></pre></div></li></ul><hr>`,2),as={id:"surroundedpalaces",tabindex:"-1"},ns=s("a",{class:"header-anchor",href:"#surroundedpalaces","aria-label":'Permalink to "surroundedPalaces() <Badge type="warning" text="^1.1.0" />"'},"​",-1),ls=p(`<ul><li><p>用途</p><p>获取 <code>三方四正</code> 宫位，所谓三方四正就是传入的 <code>目标宫</code>，以及其 <code>对宫</code>，<code>财帛位</code> 和 <code>官禄位</code>，总共四个宫位。<code>宫</code> 和 <code>位</code> 是两个概念，如果你对宫位和三方四正的概念不清楚，可以点击 <a href="./palace.html">宫位</a> 查看详细信息。</p></li><li><p>定义</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">type</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">surroundedPalaces</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> (</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#FFAB70;">indexOrName</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">number</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">|</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">PalaceName</span></span>
<span class="line"><span style="color:#E1E4E8;">) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">IFunctionalSurpalaces</span><span style="color:#E1E4E8;">;</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">type</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">surroundedPalaces</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> (</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#E36209;">indexOrName</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">number</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">|</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">PalaceName</span></span>
<span class="line"><span style="color:#24292E;">) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">IFunctionalSurpalaces</span><span style="color:#24292E;">;</span></span></code></pre></div></li><li><p>参数</p><table><thead><tr><th>参数</th><th>类型</th><th>是否必填</th><th>默认值</th><th>说明</th></tr></thead><tbody><tr><td>indexOrName</td><td><code>number</code> | <a href="./../type-definition.html#palacename"><code>PalaceName</code></a></td><td><code>true</code></td><td>-</td><td>宫位索引或者宫位名称</td></tr></tbody></table></li><li><p>返回值</p><p><a href="./palace.html#functionalsurpalaces"><code>FunctionalSurpalaces</code></a></p></li><li><p>示例</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">import</span><span style="color:#E1E4E8;"> { astro } </span><span style="color:#F97583;">from</span><span style="color:#E1E4E8;"> </span><span style="color:#9ECBFF;">&quot;iztro&quot;</span><span style="color:#E1E4E8;">;</span></span>
<span class="line"></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">astrolabe</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astro.</span><span style="color:#B392F0;">astrolabeBySolarDate</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;2000-8-16&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">2</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;女&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">true</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;zh-CN&quot;</span><span style="color:#E1E4E8;">);</span></span>
<span class="line"></span>
<span class="line"><span style="color:#6A737D;">// 获取 \`寅宫\` 三方四正</span></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">surroundedPalaces</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">surroundedPalaces</span><span style="color:#E1E4E8;">(</span><span style="color:#79B8FF;">0</span><span style="color:#E1E4E8;">);</span></span>
<span class="line"></span>
<span class="line"><span style="color:#6A737D;">// 获取 \`命宫\` 三方四正</span></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">surroundedPalacesOfSoul</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">surroundedPalaces</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;命宫&quot;</span><span style="color:#E1E4E8;">);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">import</span><span style="color:#24292E;"> { astro } </span><span style="color:#D73A49;">from</span><span style="color:#24292E;"> </span><span style="color:#032F62;">&quot;iztro&quot;</span><span style="color:#24292E;">;</span></span>
<span class="line"></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">astrolabe</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astro.</span><span style="color:#6F42C1;">astrolabeBySolarDate</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;2000-8-16&quot;</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">2</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;女&quot;</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">true</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;zh-CN&quot;</span><span style="color:#24292E;">);</span></span>
<span class="line"></span>
<span class="line"><span style="color:#6A737D;">// 获取 \`寅宫\` 三方四正</span></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">surroundedPalaces</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">surroundedPalaces</span><span style="color:#24292E;">(</span><span style="color:#005CC5;">0</span><span style="color:#24292E;">);</span></span>
<span class="line"></span>
<span class="line"><span style="color:#6A737D;">// 获取 \`命宫\` 三方四正</span></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">surroundedPalacesOfSoul</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">surroundedPalaces</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;命宫&quot;</span><span style="color:#24292E;">);</span></span></code></pre></div></li></ul><hr>`,2),ps={id:"issurrounded",tabindex:"-1"},os=s("a",{class:"header-anchor",href:"#issurrounded","aria-label":'Permalink to "isSurrounded() <Badge type="warning" text="^1.0.0" /> <Badge type="danger" text="deprecated" />"'},"​",-1),es=p('<div class="danger custom-block"><p class="custom-block-title">注意</p><p>该方法已经在 <code>v1.2.0</code> 废弃，请使用 <a href="./palace.html#functionalsurpalaces">FunctionalSurpalaces</a> 的 <a href="./palace.html#have">have()</a> 方法代替</p></div><ul><li><p>用途</p><p>判断某一个宫位 <code>三方四正</code> 是否包含目标 <code>星耀</code>，必须要<strong>全部</strong>包含才会返回 <code>true</code></p></li><li><p>定义</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">type</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">isSurrounded</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> (</span></span>\n<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#FFAB70;">indexOrName</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">number</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">|</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">PalaceName</span><span style="color:#E1E4E8;">,</span></span>\n<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#FFAB70;">stars</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">StarName</span><span style="color:#E1E4E8;">[]</span></span>\n<span class="line"><span style="color:#E1E4E8;">) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;">;</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">type</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">isSurrounded</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> (</span></span>\n<span class="line"><span style="color:#24292E;">  </span><span style="color:#E36209;">indexOrName</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">number</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">|</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">PalaceName</span><span style="color:#24292E;">,</span></span>\n<span class="line"><span style="color:#24292E;">  </span><span style="color:#E36209;">stars</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">StarName</span><span style="color:#24292E;">[]</span></span>\n<span class="line"><span style="color:#24292E;">) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;">;</span></span></code></pre></div></li><li><p>参数</p><table><thead><tr><th>参数</th><th>类型</th><th>是否必填</th><th>默认值</th><th>说明</th></tr></thead><tbody><tr><td>indexOrName</td><td><code>number</code> | <a href="./../type-definition.html#palacename"><code>PalaceName</code></a></td><td><code>true</code></td><td>-</td><td>宫位索引或者宫位名称</td></tr><tr><td>stars</td><td><a href="./../type-definition.html#starname"><code>StarName[]</code></a></td><td><code>true</code></td><td>-</td><td>星耀名称数组</td></tr></tbody></table></li><li><p>返回值</p><p><code>boolean</code></p></li><li><p>示例</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">import</span><span style="color:#E1E4E8;"> { astro } </span><span style="color:#F97583;">from</span><span style="color:#E1E4E8;"> </span><span style="color:#9ECBFF;">&quot;iztro&quot;</span><span style="color:#E1E4E8;">;</span></span>\n<span class="line"></span>\n<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">astrolabe</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astro.</span><span style="color:#B392F0;">astrolabeBySolarDate</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;2000-8-16&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">2</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;女&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">true</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;zh-CN&quot;</span><span style="color:#E1E4E8;">);</span></span>\n<span class="line"></span>\n<span class="line"><span style="color:#6A737D;">// 判断 `寅宫` 三方四正是否含有 `天府` 星、`红鸾` 星和 `禄存` 星</span></span>\n<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">palace</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">isSurrounded</span><span style="color:#E1E4E8;">(</span><span style="color:#79B8FF;">0</span><span style="color:#E1E4E8;">, [</span><span style="color:#9ECBFF;">&quot;天府&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;红鸾&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;禄存&quot;</span><span style="color:#E1E4E8;">]);</span></span>\n<span class="line"></span>\n<span class="line"><span style="color:#6A737D;">// 判断 `命宫` 三方四正是否含有 `天府` 星、`红鸾` 星和 `禄存` 星</span></span>\n<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">soulPalace</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">isSurrounded</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;命宫&quot;</span><span style="color:#E1E4E8;">, [</span><span style="color:#9ECBFF;">&quot;天府&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;红鸾&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;禄存&quot;</span><span style="color:#E1E4E8;">]);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">import</span><span style="color:#24292E;"> { astro } </span><span style="color:#D73A49;">from</span><span style="color:#24292E;"> </span><span style="color:#032F62;">&quot;iztro&quot;</span><span style="color:#24292E;">;</span></span>\n<span class="line"></span>\n<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">astrolabe</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astro.</span><span style="color:#6F42C1;">astrolabeBySolarDate</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;2000-8-16&quot;</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">2</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;女&quot;</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">true</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;zh-CN&quot;</span><span style="color:#24292E;">);</span></span>\n<span class="line"></span>\n<span class="line"><span style="color:#6A737D;">// 判断 `寅宫` 三方四正是否含有 `天府` 星、`红鸾` 星和 `禄存` 星</span></span>\n<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">palace</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">isSurrounded</span><span style="color:#24292E;">(</span><span style="color:#005CC5;">0</span><span style="color:#24292E;">, [</span><span style="color:#032F62;">&quot;天府&quot;</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;红鸾&quot;</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;禄存&quot;</span><span style="color:#24292E;">]);</span></span>\n<span class="line"></span>\n<span class="line"><span style="color:#6A737D;">// 判断 `命宫` 三方四正是否含有 `天府` 星、`红鸾` 星和 `禄存` 星</span></span>\n<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">soulPalace</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">isSurrounded</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;命宫&quot;</span><span style="color:#24292E;">, [</span><span style="color:#032F62;">&quot;天府&quot;</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;红鸾&quot;</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;禄存&quot;</span><span style="color:#24292E;">]);</span></span></code></pre></div></li></ul><hr>',3),ts={id:"issurroundedoneof",tabindex:"-1"},cs=s("a",{class:"header-anchor",href:"#issurroundedoneof","aria-label":'Permalink to "isSurroundedOneOf() <Badge type="warning" text="^1.1.0" /> <Badge type="danger" text="deprecated" />"'},"​",-1),rs=p('<div class="danger custom-block"><p class="custom-block-title">注意</p><p>该方法已经在 <code>v1.2.0</code> 废弃，请使用 <a href="./palace.html#functionalsurpalaces">FunctionalSurpalaces</a> 的 <a href="./palace.html#haveoneof">haveOneOf()</a> 方法代替</p></div><ul><li><p>用途</p><p>判断指定宫位 <code>三方四正</code> 内是否有传入星耀的 <code>其中一个</code>，只要命中 <code>一个</code> 就会返回 <code>true</code></p></li><li><p>定义</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">type</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">isSurroundedOneOf</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> (</span></span>\n<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#FFAB70;">indexOrName</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">number</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">|</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">PalaceName</span><span style="color:#E1E4E8;">,</span></span>\n<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#FFAB70;">stars</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">StarName</span><span style="color:#E1E4E8;">[]</span></span>\n<span class="line"><span style="color:#E1E4E8;">) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;">;</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">type</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">isSurroundedOneOf</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> (</span></span>\n<span class="line"><span style="color:#24292E;">  </span><span style="color:#E36209;">indexOrName</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">number</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">|</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">PalaceName</span><span style="color:#24292E;">,</span></span>\n<span class="line"><span style="color:#24292E;">  </span><span style="color:#E36209;">stars</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">StarName</span><span style="color:#24292E;">[]</span></span>\n<span class="line"><span style="color:#24292E;">) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;">;</span></span></code></pre></div></li><li><p>参数</p><table><thead><tr><th>参数</th><th>类型</th><th>是否必填</th><th>默认值</th><th>说明</th></tr></thead><tbody><tr><td>indexOrName</td><td><code>number</code> | <a href="./../type-definition.html#palacename"><code>PalaceName</code></a></td><td><code>true</code></td><td>-</td><td>宫位索引或者宫位名称</td></tr><tr><td>stars</td><td><a href="./../type-definition.html#starname"><code>StarName[]</code></a></td><td><code>true</code></td><td>-</td><td>星耀名称数组</td></tr></tbody></table></li><li><p>返回值</p><p><code>boolean</code></p></li><li><p>示例</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">import</span><span style="color:#E1E4E8;"> { astro } </span><span style="color:#F97583;">from</span><span style="color:#E1E4E8;"> </span><span style="color:#9ECBFF;">&quot;iztro&quot;</span><span style="color:#E1E4E8;">;</span></span>\n<span class="line"></span>\n<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">astrolabe</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astro.</span><span style="color:#B392F0;">astrolabeBySolarDate</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;2000-8-16&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">2</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;女&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">true</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;zh-CN&quot;</span><span style="color:#E1E4E8;">);</span></span>\n<span class="line"></span>\n<span class="line"><span style="color:#6A737D;">// 判断 `寅宫` 三方四正是否含有 `天府` 星、`红鸾` 星和 `禄存` 星中的一颗</span></span>\n<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">palace</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">isSurroundedOneOf</span><span style="color:#E1E4E8;">(</span><span style="color:#79B8FF;">0</span><span style="color:#E1E4E8;">, [</span><span style="color:#9ECBFF;">&quot;天府&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;红鸾&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;禄存&quot;</span><span style="color:#E1E4E8;">]);</span></span>\n<span class="line"></span>\n<span class="line"><span style="color:#6A737D;">// 判断 `命宫` 三方四正是否含有 `天府` 星、`红鸾` 星和 `禄存` 星中的一颗</span></span>\n<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">soulPalace</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">isSurroundedOneOf</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;命宫&quot;</span><span style="color:#E1E4E8;">, [</span><span style="color:#9ECBFF;">&quot;天府&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;红鸾&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;禄存&quot;</span><span style="color:#E1E4E8;">]);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">import</span><span style="color:#24292E;"> { astro } </span><span style="color:#D73A49;">from</span><span style="color:#24292E;"> </span><span style="color:#032F62;">&quot;iztro&quot;</span><span style="color:#24292E;">;</span></span>\n<span class="line"></span>\n<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">astrolabe</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astro.</span><span style="color:#6F42C1;">astrolabeBySolarDate</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;2000-8-16&quot;</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">2</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;女&quot;</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">true</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;zh-CN&quot;</span><span style="color:#24292E;">);</span></span>\n<span class="line"></span>\n<span class="line"><span style="color:#6A737D;">// 判断 `寅宫` 三方四正是否含有 `天府` 星、`红鸾` 星和 `禄存` 星中的一颗</span></span>\n<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">palace</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">isSurroundedOneOf</span><span style="color:#24292E;">(</span><span style="color:#005CC5;">0</span><span style="color:#24292E;">, [</span><span style="color:#032F62;">&quot;天府&quot;</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;红鸾&quot;</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;禄存&quot;</span><span style="color:#24292E;">]);</span></span>\n<span class="line"></span>\n<span class="line"><span style="color:#6A737D;">// 判断 `命宫` 三方四正是否含有 `天府` 星、`红鸾` 星和 `禄存` 星中的一颗</span></span>\n<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">soulPalace</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">isSurroundedOneOf</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;命宫&quot;</span><span style="color:#24292E;">, [</span><span style="color:#032F62;">&quot;天府&quot;</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;红鸾&quot;</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;禄存&quot;</span><span style="color:#24292E;">]);</span></span></code></pre></div></li></ul><hr>',3),Es={id:"notsurrounded",tabindex:"-1"},ys=s("a",{class:"header-anchor",href:"#notsurrounded","aria-label":'Permalink to "notSurrounded() <Badge type="warning" text="^1.1.0" /> <Badge type="danger" text="deprecated" />"'},"​",-1),is=p('<div class="danger custom-block"><p class="custom-block-title">注意</p><p>该方法已经在 <code>v1.2.0</code> 废弃，请使用 <a href="./palace.html#functionalsurpalaces">FunctionalSurpalaces</a> 的 <a href="./palace.html#nothave-1">notHave()</a> 方法代替</p></div><ul><li><p>用途</p><p>判断指定宫位 <code>三方四正</code> 是否 <code>不含</code> 目标星耀，必须要全部都 <code>不在</code> 三方四正内含才会返回 <code>true</code></p></li><li><p>定义</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">type</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">notSurrounded</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> (</span></span>\n<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#FFAB70;">indexOrName</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">number</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">|</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">PalaceName</span><span style="color:#E1E4E8;">,</span></span>\n<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#FFAB70;">stars</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">StarName</span><span style="color:#E1E4E8;">[]</span></span>\n<span class="line"><span style="color:#E1E4E8;">) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;">;</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">type</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">notSurrounded</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> (</span></span>\n<span class="line"><span style="color:#24292E;">  </span><span style="color:#E36209;">indexOrName</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">number</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">|</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">PalaceName</span><span style="color:#24292E;">,</span></span>\n<span class="line"><span style="color:#24292E;">  </span><span style="color:#E36209;">stars</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">StarName</span><span style="color:#24292E;">[]</span></span>\n<span class="line"><span style="color:#24292E;">) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;">;</span></span></code></pre></div></li><li><p>参数</p><table><thead><tr><th>参数</th><th>类型</th><th>是否必填</th><th>默认值</th><th>说明</th></tr></thead><tbody><tr><td>indexOrName</td><td><code>number</code> | <a href="./../type-definition.html#palacename"><code>PalaceName</code></a></td><td><code>true</code></td><td>-</td><td>宫位索引或者宫位名称</td></tr><tr><td>stars</td><td><a href="./../type-definition.html#starname"><code>StarName[]</code></a></td><td><code>true</code></td><td>-</td><td>星耀名称数组</td></tr></tbody></table></li><li><p>返回值</p><p><code>boolean</code></p></li><li><p>示例</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">import</span><span style="color:#E1E4E8;"> { astro } </span><span style="color:#F97583;">from</span><span style="color:#E1E4E8;"> </span><span style="color:#9ECBFF;">&quot;iztro&quot;</span><span style="color:#E1E4E8;">;</span></span>\n<span class="line"></span>\n<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">astrolabe</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astro.</span><span style="color:#B392F0;">astrolabeBySolarDate</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;2000-8-16&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">2</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;女&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">true</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;zh-CN&quot;</span><span style="color:#E1E4E8;">);</span></span>\n<span class="line"></span>\n<span class="line"><span style="color:#6A737D;">// 判断 `寅宫` 三方四正是否不含有 `天府` 星、`红鸾` 星和 `禄存` 星</span></span>\n<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">palace</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">notSurrounded</span><span style="color:#E1E4E8;">(</span><span style="color:#79B8FF;">0</span><span style="color:#E1E4E8;">, [</span><span style="color:#9ECBFF;">&quot;天府&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;红鸾&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;禄存&quot;</span><span style="color:#E1E4E8;">]);</span></span>\n<span class="line"></span>\n<span class="line"><span style="color:#6A737D;">// 判断 `命宫` 三方四正是否不含有 `天府` 星、`红鸾` 星和 `禄存` 星</span></span>\n<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">soulPalace</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">notSurrounded</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;命宫&quot;</span><span style="color:#E1E4E8;">, [</span><span style="color:#9ECBFF;">&quot;天府&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;红鸾&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;禄存&quot;</span><span style="color:#E1E4E8;">]);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">import</span><span style="color:#24292E;"> { astro } </span><span style="color:#D73A49;">from</span><span style="color:#24292E;"> </span><span style="color:#032F62;">&quot;iztro&quot;</span><span style="color:#24292E;">;</span></span>\n<span class="line"></span>\n<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">astrolabe</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astro.</span><span style="color:#6F42C1;">astrolabeBySolarDate</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;2000-8-16&quot;</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">2</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;女&quot;</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">true</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;zh-CN&quot;</span><span style="color:#24292E;">);</span></span>\n<span class="line"></span>\n<span class="line"><span style="color:#6A737D;">// 判断 `寅宫` 三方四正是否不含有 `天府` 星、`红鸾` 星和 `禄存` 星</span></span>\n<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">palace</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">notSurrounded</span><span style="color:#24292E;">(</span><span style="color:#005CC5;">0</span><span style="color:#24292E;">, [</span><span style="color:#032F62;">&quot;天府&quot;</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;红鸾&quot;</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;禄存&quot;</span><span style="color:#24292E;">]);</span></span>\n<span class="line"></span>\n<span class="line"><span style="color:#6A737D;">// 判断 `命宫` 三方四正是否不含有 `天府` 星、`红鸾` 星和 `禄存` 星</span></span>\n<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">soulPalace</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">notSurrounded</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;命宫&quot;</span><span style="color:#24292E;">, [</span><span style="color:#032F62;">&quot;天府&quot;</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;红鸾&quot;</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;禄存&quot;</span><span style="color:#24292E;">]);</span></span></code></pre></div></li></ul>',2);function Fs(ds,Cs,hs,gs,us,Bs){const e=t("PluginTabsTab"),c=t("PluginTabs"),l=t("Badge");return E(),y("div",null,[F,n(c,null,{default:o(()=>[n(e,{label:"ES6 Module"},{default:o(()=>[d]),_:1}),n(e,{label:"CommonJS"},{default:o(()=>[C]),_:1})]),_:1}),h,s("h4",g,[a("getMajorStarBySolarDate "),n(l,{type:"warning",text:"^1.2.1"}),a(),u]),B,s("h4",m,[a("getMajorStarByLunarDate "),n(l,{type:"warning",text:"^1.2.1"}),a(),b]),D,s("h4",A,[a("getSignBySolarDate "),n(l,{type:"warning",text:"^1.2.1"}),a(),v]),S,s("h4",_,[a("getSignByLunarDate "),n(l,{type:"warning",text:"^1.2.1"}),a(),q]),f,s("h4",k,[a("getZodiacBySolarDate "),n(l,{type:"warning",text:"^1.2.1"}),a(),j]),P,s("h4",N,[a("getZodiacByLunarYear "),n(l,{type:"warning",text:"^1.2.1"}),a(),x]),T,n(l,{type:"tip",text:"implements"}),a(),z,a(),n(l,{type:"tip",text:"extends"}),a(),O,L,s("ul",null,[I,s("li",null,[Y,s("h5",w,[a("horoscope() "),n(l,{type:"warning",text:"^0.2.0"}),a(),M]),s("ul",null,[V,s("li",null,[R,n(c,null,{default:o(()=>[n(e,{label:"不传参数"},{default:o(()=>[Z]),_:1}),n(e,{label:"传入 date 字符串"},{default:o(()=>[J]),_:1}),n(e,{label:"传入 Date 对象"},{default:o(()=>[H]),_:1}),n(e,{label:"传入 date 和 timeIndex"},{default:o(()=>[K]),_:1})]),_:1})])]),U,s("h5",W,[a("star() "),n(l,{type:"warning",text:"^1.2.0"}),a(),G]),$,s("h5",Q,[a("palace() "),n(l,{type:"warning",text:"^1.0.0"}),a(),X]),ss,s("h5",as,[a("surroundedPalaces() "),n(l,{type:"warning",text:"^1.1.0"}),a(),ns]),ls,s("h5",ps,[a("isSurrounded() "),n(l,{type:"warning",text:"^1.0.0"}),a(),n(l,{type:"danger",text:"deprecated"}),a(),os]),es,s("h5",ts,[a("isSurroundedOneOf() "),n(l,{type:"warning",text:"^1.1.0"}),a(),n(l,{type:"danger",text:"deprecated"}),a(),cs]),rs,s("h5",Es,[a("notSurrounded() "),n(l,{type:"warning",text:"^1.1.0"}),a(),n(l,{type:"danger",text:"deprecated"}),a(),ys]),is])])])}const Ds=r(i,[["render",Fs]]);export{bs as __pageData,Ds as default};
