import{_ as p,C as e,o as t,c,H as l,a,k as s,Q as n}from"./chunks/framework.f0e9ff50.js";const Q=JSON.parse('{"title":"宫位","description":"iztro紫微斗数宫位介绍，iztro的palace对象使用方法以及示例代码。","frontmatter":{"outline":"deep","description":"iztro紫微斗数宫位介绍，iztro的palace对象使用方法以及示例代码。"},"headers":[],"relativePath":"posts/palace.md","filePath":"posts/palace.md"}'),r={name:"posts/palace.md"},y=n(`<h1 id="宫位" tabindex="-1">宫位 <a class="header-anchor" href="#宫位" aria-label="Permalink to &quot;宫位&quot;">​</a></h1><h3 id="概述" tabindex="-1">概述 <a class="header-anchor" href="#概述" aria-label="Permalink to &quot;概述&quot;">​</a></h3><p>紫微斗数中一共有 <code>十二</code> 个宫位，叫做 <code>十二人事宫</code>，囊括了与人有关的其他人和事物，这十二宫按顺序分别是 <code>命宫</code>、<code>兄弟宫</code>、<code>夫妻宫</code>、<code>子女宫</code>、<code>财帛宫</code>、<code>疾厄宫</code>、<code>迁移宫</code>、<code>仆役宫</code>、<code>官禄宫</code>、<code>田宅宫</code>、<code>福德宫</code>、<code>父母宫</code>。除了这展示在 <a href="./astrolabe.html">星盘</a> 里的十二宫以外，紫微斗数还有三个隐藏宫位，它们分别是 <code>身宫</code>、<code>来因宫</code>、<code>暗合宫</code>。每一个宫位有着它特殊的意义，但本页不详细展开来叙述。如果你对紫微斗数的宫位没有概念，或者想深入研究，可以点击 <a href="./../learn/palace.html">传送门</a> 查看详细资料。与宫位地支顺时针排列相反，宫位名称是按逆时针排列的。如下面表格所示：</p><table class="astrolabe"><tr><td>巳 <code>田宅</code></td><td>午 <code>官禄</code></td><td>未 <code>仆役</code></td><td>申 <code>迁移</code></td></tr><tr><td>辰 <code>福德</code></td><td class="center-palace" rowspan="2" colspan="2">中宫</td><td>酉 <code>疾厄</code></td></tr><tr><td>卯 <code>父母</code></td><td>戌 <code>财帛</code></td></tr><tr><td>寅 <code>命宫</code></td><td>丑 <code>兄弟</code></td><td>子 <code>夫妻</code></td><td>亥 <code>子女</code></td></tr></table><blockquote><p>以上表格只是一个例子，<code>命宫</code> 的位置会根据你的 <code>出生日期</code> 和 <code>出生时间</code> 的不同而不同，它可能出现在上述任何一个宫位，但这个顺序是不会变的。</p></blockquote><p>宫位其实是 <code>宫</code> 和 <code>位</code> 两个概念组成的，通过 <code>出生日期</code> 和 <code>出生时间</code> 计算出来的，叫 <code>宫</code>，所以你星盘中的 <code>财帛宫</code> 位置在本命盘中是固定的，如果你不知道什么叫 <code>本命盘</code>，我们强烈建议你点击 <a href="/learn/basis.html">传送门</a> 学习。<code>位</code> 则是一个 <code>相对</code> 位置，比如 <code>夫妻宫</code> 的 <code>财帛位</code> 是 <code>迁移宫</code>。这听起来有些绕，好消息是，你不需要记忆这些烧脑的信息，只需要有这么一个概念就可以了。</p><h3 id="功能类定义" tabindex="-1">功能类定义 <a class="header-anchor" href="#功能类定义" aria-label="Permalink to &quot;功能类定义&quot;">​</a></h3><div class="warning custom-block"><p class="custom-block-title">开发建议</p><p>因为宫位是基于星盘而存在的，所以我们并不推荐你手动 <code>new</code> 一个宫位对象，而是使用星盘静态方法返回的对象使用。星盘的 <code>palaces</code> 属性包含了十二宫的数据，为了和地支的顺序保持一致，它是从 <code>寅宫</code> 开始按照地支顺序顺时针排列的。</p></div><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">import</span><span style="color:#E1E4E8;"> { astro } </span><span style="color:#F97583;">from</span><span style="color:#E1E4E8;"> </span><span style="color:#9ECBFF;">&quot;iztro&quot;</span><span style="color:#E1E4E8;">;</span></span>
<span class="line"></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">astrolabe</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astro.</span><span style="color:#B392F0;">astrolabeBySolarDate</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;2000-8-16&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">2</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;女&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">true</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;zh-CN&quot;</span><span style="color:#E1E4E8;">);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">import</span><span style="color:#24292E;"> { astro } </span><span style="color:#D73A49;">from</span><span style="color:#24292E;"> </span><span style="color:#032F62;">&quot;iztro&quot;</span><span style="color:#24292E;">;</span></span>
<span class="line"></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">astrolabe</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astro.</span><span style="color:#6F42C1;">astrolabeBySolarDate</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;2000-8-16&quot;</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">2</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;女&quot;</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">true</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;zh-CN&quot;</span><span style="color:#24292E;">);</span></span></code></pre></div><p>你可以有几种方式从上述 <code>astrolabe</code> 变量里获取到目标宫位，请根据实际需求使用：</p><ol><li><p>通过 <code>palaces</code> 的下标获取</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#6A737D;">// 获取卯宫宫位</span></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">palace</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.palaces[</span><span style="color:#79B8FF;">1</span><span style="color:#E1E4E8;">];</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#6A737D;">// 获取卯宫宫位</span></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">palace</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.palaces[</span><span style="color:#005CC5;">1</span><span style="color:#24292E;">];</span></span></code></pre></div></li><li><p>通过 <code>FunctionalAstrolabe</code> 类的 <code>palace()</code> 方法传入宫位 <code>索引</code> 获取</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#6A737D;">// 获取卯宫宫位</span></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">palace</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">palace</span><span style="color:#E1E4E8;">(</span><span style="color:#79B8FF;">1</span><span style="color:#E1E4E8;">);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#6A737D;">// 获取卯宫宫位</span></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">palace</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">palace</span><span style="color:#24292E;">(</span><span style="color:#005CC5;">1</span><span style="color:#24292E;">);</span></span></code></pre></div></li><li><p>通过 <code>FunctionalAstrolabe</code> 类的 <code>palace()</code> 方法传入宫位 <code>名称</code> 获取</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#6A737D;">// 获取命宫</span></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">palace</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">palace</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;命宫&quot;</span><span style="color:#E1E4E8;">);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#6A737D;">// 获取命宫</span></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">palace</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">palace</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;命宫&quot;</span><span style="color:#24292E;">);</span></span></code></pre></div></li></ol><h4 id="functionalpalace" tabindex="-1">FunctionalPalace <a class="header-anchor" href="#functionalpalace" aria-label="Permalink to &quot;FunctionalPalace&quot;">​</a></h4><hr>`,13),E=s("code",null,"IFuncionalPalace",-1),d=s("a",{href:"./../type-definition.html#palace"},[s("code",null,"Palace")],-1),i=s("p",null,[a("该类所有属性都是继承自 "),s("a",{href:"./../type-definition.html#palace"},"Palace"),a("，然后在接口内定义了一些方法用于对星耀进行分析。")],-1),u=n(`<li><p>接口定义</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">interface</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">IFunctionalPalace</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">extends</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">Palace</span><span style="color:#E1E4E8;"> {</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#B392F0;">has</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> (</span><span style="color:#FFAB70;">stars</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">StarName</span><span style="color:#E1E4E8;">[]) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;">;</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#B392F0;">notHave</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> (</span><span style="color:#FFAB70;">stars</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">StarName</span><span style="color:#E1E4E8;">[]) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;">;</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#B392F0;">hasOneOf</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> (</span><span style="color:#FFAB70;">stars</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">StarName</span><span style="color:#E1E4E8;">[]) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;">;</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#B392F0;">hasMutagen</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> (</span><span style="color:#FFAB70;">mutagen</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">Mutagen</span><span style="color:#E1E4E8;">)</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;">;</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#B392F0;">notHaveMutagen</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> (</span><span style="color:#FFAB70;">mutagen</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">Mutagen</span><span style="color:#E1E4E8;">)</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;">;</span></span>
<span class="line"><span style="color:#E1E4E8;">}</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">interface</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">IFunctionalPalace</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">extends</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">Palace</span><span style="color:#24292E;"> {</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6F42C1;">has</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> (</span><span style="color:#E36209;">stars</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">StarName</span><span style="color:#24292E;">[]) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;">;</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6F42C1;">notHave</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> (</span><span style="color:#E36209;">stars</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">StarName</span><span style="color:#24292E;">[]) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;">;</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6F42C1;">hasOneOf</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> (</span><span style="color:#E36209;">stars</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">StarName</span><span style="color:#24292E;">[]) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;">;</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6F42C1;">hasMutagen</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> (</span><span style="color:#E36209;">mutagen</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">Mutagen</span><span style="color:#24292E;">)</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;">;</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6F42C1;">notHaveMutagen</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> (</span><span style="color:#E36209;">mutagen</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">Mutagen</span><span style="color:#24292E;">)</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;">;</span></span>
<span class="line"><span style="color:#24292E;">}</span></span></code></pre></div></li><li><p>属性</p><p>参考 <a href="./../type-definition.html#palace">Palace</a></p></li>`,2),F=s("p",null,"方法",-1),h={id:"has",tabindex:"-1"},g=s("a",{class:"header-anchor",href:"#has","aria-label":'Permalink to "has() <Badge type="warning" text="^1.0.0" />"'},"​",-1),C=n(`<ul><li><p>用途</p><p>判断某个宫位内是否有传入的 <code>星耀</code>，要 <code>所有</code> 星耀 <code>都在</code> 宫位内才会返回 <code>true</code></p></li><li><p>定义</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">type</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">has</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> (</span><span style="color:#FFAB70;">stars</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">StarName</span><span style="color:#E1E4E8;">[]) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;">;</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">type</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">has</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> (</span><span style="color:#E36209;">stars</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">StarName</span><span style="color:#24292E;">[]) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;">;</span></span></code></pre></div></li><li><p>参数</p><table><thead><tr><th>参数</th><th>类型</th><th>是否必填</th><th>默认值</th><th>说明</th></tr></thead><tbody><tr><td>stars</td><td><a href="./../type-definition.html#starname"><code>StarName[]</code></a></td><td><code>true</code></td><td>-</td><td>星耀名称，可以包含主星、辅星、杂耀</td></tr></tbody></table></li><li><p>返回值</p><p><code>boolean</code></p></li><li><p>示例</p><p>如果你想查看 <code>命宫</code> 是否有 <code>紫微星</code> 和 <code>右弼星</code></p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">palace</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">palace</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;命宫&quot;</span><span style="color:#E1E4E8;">);</span></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">result</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> palace.</span><span style="color:#B392F0;">has</span><span style="color:#E1E4E8;">([</span><span style="color:#9ECBFF;">&quot;紫微&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;右弼&quot;</span><span style="color:#E1E4E8;">]);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">palace</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">palace</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;命宫&quot;</span><span style="color:#24292E;">);</span></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">result</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> palace.</span><span style="color:#6F42C1;">has</span><span style="color:#24292E;">([</span><span style="color:#032F62;">&quot;紫微&quot;</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;右弼&quot;</span><span style="color:#24292E;">]);</span></span></code></pre></div><p>当然你也可以使用 <code>链式调用</code> 来简化代码</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">result</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">palace</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;命宫&quot;</span><span style="color:#E1E4E8;">).</span><span style="color:#B392F0;">has</span><span style="color:#E1E4E8;">([</span><span style="color:#9ECBFF;">&quot;紫微&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;右弼&quot;</span><span style="color:#E1E4E8;">]);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">result</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">palace</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;命宫&quot;</span><span style="color:#24292E;">).</span><span style="color:#6F42C1;">has</span><span style="color:#24292E;">([</span><span style="color:#032F62;">&quot;紫微&quot;</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;右弼&quot;</span><span style="color:#24292E;">]);</span></span></code></pre></div></li></ul><hr>`,2),b={id:"nothave",tabindex:"-1"},v=s("a",{class:"header-anchor",href:"#nothave","aria-label":'Permalink to "notHave() <Badge type="warning" text="^1.0.0" />"'},"​",-1),q=n(`<ul><li><p>用途</p><p>判断某个宫位内是否没有传入的 <code>星耀</code>，要所有星耀 <code>都不在</code> 宫位内才会返回 <code>true</code></p></li><li><p>定义</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">type</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">notHave</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> (</span><span style="color:#FFAB70;">stars</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">StarName</span><span style="color:#E1E4E8;">[]) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;">;</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">type</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">notHave</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> (</span><span style="color:#E36209;">stars</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">StarName</span><span style="color:#24292E;">[]) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;">;</span></span></code></pre></div></li><li><p>参数</p><table><thead><tr><th>参数</th><th>类型</th><th>是否必填</th><th>默认值</th><th>说明</th></tr></thead><tbody><tr><td>stars</td><td><a href="./../type-definition.html#starname"><code>StarName[]</code></a></td><td><code>true</code></td><td>-</td><td>星耀名称，可以包含主星、辅星、杂耀</td></tr></tbody></table></li><li><p>返回值</p><p><code>boolean</code></p></li><li><p>示例</p><p>如果你想查看 <code>命宫</code> 是没有 <code>地空星</code> 和 <code>地劫星</code></p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">palace</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">palace</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;命宫&quot;</span><span style="color:#E1E4E8;">);</span></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">result</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> palace.</span><span style="color:#B392F0;">notHave</span><span style="color:#E1E4E8;">([</span><span style="color:#9ECBFF;">&quot;地空&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;地劫&quot;</span><span style="color:#E1E4E8;">]);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">palace</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">palace</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;命宫&quot;</span><span style="color:#24292E;">);</span></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">result</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> palace.</span><span style="color:#6F42C1;">notHave</span><span style="color:#24292E;">([</span><span style="color:#032F62;">&quot;地空&quot;</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;地劫&quot;</span><span style="color:#24292E;">]);</span></span></code></pre></div><p>当然你也可以使用 <code>链式调用</code> 来简化代码</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">result</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">palace</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;命宫&quot;</span><span style="color:#E1E4E8;">).</span><span style="color:#B392F0;">notHave</span><span style="color:#E1E4E8;">([</span><span style="color:#9ECBFF;">&quot;地空&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;地劫&quot;</span><span style="color:#E1E4E8;">]);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">result</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">palace</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;命宫&quot;</span><span style="color:#24292E;">).</span><span style="color:#6F42C1;">notHave</span><span style="color:#24292E;">([</span><span style="color:#032F62;">&quot;地空&quot;</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;地劫&quot;</span><span style="color:#24292E;">]);</span></span></code></pre></div></li></ul><hr>`,2),B={id:"hasoneof",tabindex:"-1"},A=s("a",{class:"header-anchor",href:"#hasoneof","aria-label":'Permalink to "hasOneOf() <Badge type="warning" text="^1.0.0" />"'},"​",-1),k=n(`<ul><li><p>用途</p><p>判断某个宫位内是否有传入 <code>星耀</code> 的其中一个，只要 <code>命中一个</code> 就会返回 <code>true</code></p></li><li><p>定义</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">type</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">hasOneOf</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> (</span><span style="color:#FFAB70;">stars</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">StarName</span><span style="color:#E1E4E8;">[]) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;">;</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">type</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">hasOneOf</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> (</span><span style="color:#E36209;">stars</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">StarName</span><span style="color:#24292E;">[]) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;">;</span></span></code></pre></div></li><li><p>参数</p><table><thead><tr><th>参数</th><th>类型</th><th>是否必填</th><th>默认值</th><th>说明</th></tr></thead><tbody><tr><td>stars</td><td><a href="./../type-definition.html#starname"><code>StarName[]</code></a></td><td><code>true</code></td><td>-</td><td>星耀名称，可以包含主星、辅星、杂耀</td></tr></tbody></table></li><li><p>返回值</p><p><code>boolean</code></p></li><li><p>示例</p><p>如果你想查看 <code>命宫</code> 是否有 <code>天魁星</code> 或 <code>天钺星</code></p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">palace</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">palace</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;命宫&quot;</span><span style="color:#E1E4E8;">);</span></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">result</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> palace.</span><span style="color:#B392F0;">hasOneOf</span><span style="color:#E1E4E8;">([</span><span style="color:#9ECBFF;">&quot;天魁&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;天钺&quot;</span><span style="color:#E1E4E8;">]);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">palace</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">palace</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;命宫&quot;</span><span style="color:#24292E;">);</span></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">result</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> palace.</span><span style="color:#6F42C1;">hasOneOf</span><span style="color:#24292E;">([</span><span style="color:#032F62;">&quot;天魁&quot;</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;天钺&quot;</span><span style="color:#24292E;">]);</span></span></code></pre></div><p>当然你也可以使用 <code>链式调用</code> 来简化代码</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">result</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">palace</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;命宫&quot;</span><span style="color:#E1E4E8;">).</span><span style="color:#B392F0;">hasOneOf</span><span style="color:#E1E4E8;">([</span><span style="color:#9ECBFF;">&quot;天魁&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;天钺&quot;</span><span style="color:#E1E4E8;">]);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">result</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">palace</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;命宫&quot;</span><span style="color:#24292E;">).</span><span style="color:#6F42C1;">hasOneOf</span><span style="color:#24292E;">([</span><span style="color:#032F62;">&quot;天魁&quot;</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;天钺&quot;</span><span style="color:#24292E;">]);</span></span></code></pre></div></li></ul><hr>`,2),D={id:"hasmutagen",tabindex:"-1"},_=s("a",{class:"header-anchor",href:"#hasmutagen","aria-label":'Permalink to "hasMutagen() <Badge type="warning" text="^1.2.0" />"'},"​",-1),m=n(`<ul><li><p>用途</p><p>判断宫位内是否有生年四化</p></li><li><p>定义</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">type</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">hasMutagen</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> (</span><span style="color:#FFAB70;">mutagen</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">Mutagen</span><span style="color:#E1E4E8;">) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;">;</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">type</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">hasMutagen</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> (</span><span style="color:#E36209;">mutagen</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">Mutagen</span><span style="color:#24292E;">) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;">;</span></span></code></pre></div></li><li><p>参数</p><table><thead><tr><th>参数</th><th>类型</th><th>是否必填</th><th>默认值</th><th>说明</th></tr></thead><tbody><tr><td>mutagen</td><td><a href="./../type-definition.html#mutagen"><code>Mutagen</code></a></td><td><code>true</code></td><td>-</td><td>四化名称【禄｜权｜科｜忌】</td></tr></tbody></table></li><li><p>返回值</p><p><code>boolean</code></p></li><li><p>示例</p><p>如果你想查看 <code>命宫</code> 是否有 <code>化禄</code></p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">palace</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">palace</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;命宫&quot;</span><span style="color:#E1E4E8;">);</span></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">result</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> palace.</span><span style="color:#B392F0;">hasMutagen</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;禄&quot;</span><span style="color:#E1E4E8;">);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">palace</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">palace</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;命宫&quot;</span><span style="color:#24292E;">);</span></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">result</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> palace.</span><span style="color:#6F42C1;">hasMutagen</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;禄&quot;</span><span style="color:#24292E;">);</span></span></code></pre></div><p>当然你也可以使用 <code>链式调用</code> 来简化代码</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">result</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">palace</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;命宫&quot;</span><span style="color:#E1E4E8;">).</span><span style="color:#B392F0;">hasMutagen</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;禄&quot;</span><span style="color:#E1E4E8;">);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">result</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">palace</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;命宫&quot;</span><span style="color:#24292E;">).</span><span style="color:#6F42C1;">hasMutagen</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;禄&quot;</span><span style="color:#24292E;">);</span></span></code></pre></div></li></ul><hr>`,2),f={id:"nothavemutagen",tabindex:"-1"},P=s("a",{class:"header-anchor",href:"#nothavemutagen","aria-label":'Permalink to "notHaveMutagen() <Badge type="warning" text="^1.2.0" />"'},"​",-1),S=n(`<ul><li><p>用途</p><p>判断宫位内是否没有生年四化</p></li><li><p>定义</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">type</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">notHaveMutagen</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> (</span><span style="color:#FFAB70;">mutagen</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">Mutagen</span><span style="color:#E1E4E8;">) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;">;</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">type</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">notHaveMutagen</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> (</span><span style="color:#E36209;">mutagen</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">Mutagen</span><span style="color:#24292E;">) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;">;</span></span></code></pre></div></li><li><p>参数</p><table><thead><tr><th>参数</th><th>类型</th><th>是否必填</th><th>默认值</th><th>说明</th></tr></thead><tbody><tr><td>mutagen</td><td><a href="./../type-definition.html#mutagen"><code>Mutagen</code></a></td><td><code>true</code></td><td>-</td><td>四化名称【禄｜权｜科｜忌】</td></tr></tbody></table></li><li><p>返回值</p><p><code>boolean</code></p></li><li><p>示例</p><p>如果你想查看 <code>命宫</code> 是不是没有 <code>化忌</code></p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">palace</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">palace</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;命宫&quot;</span><span style="color:#E1E4E8;">);</span></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">result</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> palace.</span><span style="color:#B392F0;">notHaveMutagen</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;忌&quot;</span><span style="color:#E1E4E8;">);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">palace</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">palace</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;命宫&quot;</span><span style="color:#24292E;">);</span></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">result</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> palace.</span><span style="color:#6F42C1;">notHaveMutagen</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;忌&quot;</span><span style="color:#24292E;">);</span></span></code></pre></div><p>当然你也可以使用 <code>链式调用</code> 来简化代码</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">result</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">palace</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;命宫&quot;</span><span style="color:#E1E4E8;">).</span><span style="color:#B392F0;">notHaveMutagen</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;忌&quot;</span><span style="color:#E1E4E8;">);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">result</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">palace</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;命宫&quot;</span><span style="color:#24292E;">).</span><span style="color:#6F42C1;">notHaveMutagen</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;忌&quot;</span><span style="color:#24292E;">);</span></span></code></pre></div></li></ul>`,1),M={id:"functionalsurpalaces",tabindex:"-1"},T=s("a",{class:"header-anchor",href:"#functionalsurpalaces","aria-label":'Permalink to "FunctionalSurpalaces <Badge type="warning" text="^1.2.0" />"'},"​",-1),N=s("hr",null,null,-1),x=s("code",null,"IFunctionalSurpalaces",-1),H=n(`<a href="./../type-definition.html#surroundedpalaces"><code>SurroundedPalaces</code></a><p>该类所有属性都是继承自 <a href="./../type-definition.html#surroundedpalaces">SurroundedPalaces</a>，然后在接口内定义了一些方法用于对星耀进行分析。</p><ul><li><p>接口定义</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">interface</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">FunctionalSurpalaces</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">extends</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">SurroundedPalaces</span><span style="color:#E1E4E8;"> {</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#B392F0;">have</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> (</span><span style="color:#FFAB70;">stars</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">StarName</span><span style="color:#E1E4E8;">[]) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;">;</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#B392F0;">notHave</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> (</span><span style="color:#FFAB70;">stars</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">StarName</span><span style="color:#E1E4E8;">[]) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;">;</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#B392F0;">haveOneOf</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> (</span><span style="color:#FFAB70;">stars</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">StarName</span><span style="color:#E1E4E8;">[]) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;">;</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#B392F0;">haveMutagen</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> (</span><span style="color:#FFAB70;">mutagen</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">Mutagen</span><span style="color:#E1E4E8;">) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;">;</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#B392F0;">notHaveMutagen</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> (</span><span style="color:#FFAB70;">mutagen</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">Mutagen</span><span style="color:#E1E4E8;">)</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;">;</span></span>
<span class="line"><span style="color:#E1E4E8;">}</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">interface</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">FunctionalSurpalaces</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">extends</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">SurroundedPalaces</span><span style="color:#24292E;"> {</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6F42C1;">have</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> (</span><span style="color:#E36209;">stars</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">StarName</span><span style="color:#24292E;">[]) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;">;</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6F42C1;">notHave</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> (</span><span style="color:#E36209;">stars</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">StarName</span><span style="color:#24292E;">[]) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;">;</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6F42C1;">haveOneOf</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> (</span><span style="color:#E36209;">stars</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">StarName</span><span style="color:#24292E;">[]) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;">;</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6F42C1;">haveMutagen</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> (</span><span style="color:#E36209;">mutagen</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">Mutagen</span><span style="color:#24292E;">) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;">;</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6F42C1;">notHaveMutagen</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> (</span><span style="color:#E36209;">mutagen</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">Mutagen</span><span style="color:#24292E;">)</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;">;</span></span>
<span class="line"><span style="color:#24292E;">}</span></span></code></pre></div></li><li><p>属性</p><p>参考 <a href="./../type-definition.html#surroundedpalaces">SurroundedPalaces</a></p></li><li><p>方法</p><h5 id="have" tabindex="-1">have() <a class="header-anchor" href="#have" aria-label="Permalink to &quot;have()&quot;">​</a></h5><ul><li><p>用途</p><p>判断某个宫三方四正内是否有传入的 <code>星耀</code>，要 <code>所有</code> 星耀 <code>都在</code> 三方四正内才会返回 <code>true</code></p></li><li><p>定义</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">type</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">have</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> (</span><span style="color:#FFAB70;">stars</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">StarName</span><span style="color:#E1E4E8;">[]) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;">;</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">type</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">have</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> (</span><span style="color:#E36209;">stars</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">StarName</span><span style="color:#24292E;">[]) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;">;</span></span></code></pre></div></li><li><p>参数</p><table><thead><tr><th>参数</th><th>类型</th><th>是否必填</th><th>默认值</th><th>说明</th></tr></thead><tbody><tr><td>stars</td><td><a href="./../type-definition.html#starname"><code>StarName[]</code></a></td><td><code>true</code></td><td>-</td><td>星耀名称，可以包含主星、辅星、杂耀</td></tr></tbody></table></li><li><p>返回值</p><p><code>boolean</code></p></li><li><p>示例</p><p>如果你想查看 <code>命宫</code> 三方四正是否有 <code>紫微星</code> 和 <code>右弼星</code></p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">palaces</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">surroundedPalaces</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;命宫&quot;</span><span style="color:#E1E4E8;">);</span></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">result</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> palaces.</span><span style="color:#B392F0;">have</span><span style="color:#E1E4E8;">([</span><span style="color:#9ECBFF;">&quot;紫微&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;右弼&quot;</span><span style="color:#E1E4E8;">]);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">palaces</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">surroundedPalaces</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;命宫&quot;</span><span style="color:#24292E;">);</span></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">result</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> palaces.</span><span style="color:#6F42C1;">have</span><span style="color:#24292E;">([</span><span style="color:#032F62;">&quot;紫微&quot;</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;右弼&quot;</span><span style="color:#24292E;">]);</span></span></code></pre></div><p>当然你也可以使用 <code>链式调用</code> 来简化代码</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">result</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">surroundedPalaces</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;命宫&quot;</span><span style="color:#E1E4E8;">).</span><span style="color:#B392F0;">have</span><span style="color:#E1E4E8;">([</span><span style="color:#9ECBFF;">&quot;紫微&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;右弼&quot;</span><span style="color:#E1E4E8;">]);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">result</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">surroundedPalaces</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;命宫&quot;</span><span style="color:#24292E;">).</span><span style="color:#6F42C1;">have</span><span style="color:#24292E;">([</span><span style="color:#032F62;">&quot;紫微&quot;</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;右弼&quot;</span><span style="color:#24292E;">]);</span></span></code></pre></div></li></ul><hr><h5 id="nothave-1" tabindex="-1">notHave() <a class="header-anchor" href="#nothave-1" aria-label="Permalink to &quot;notHave()&quot;">​</a></h5><ul><li><p>用途</p><p>判断某个宫三方四正内是否没有传入的 <code>星耀</code>，要所有星耀 <code>都不在</code> 三方四正内才会返回 <code>true</code></p></li><li><p>定义</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">type</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">notHave</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> (</span><span style="color:#FFAB70;">stars</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">StarName</span><span style="color:#E1E4E8;">[]) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;">;</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">type</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">notHave</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> (</span><span style="color:#E36209;">stars</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">StarName</span><span style="color:#24292E;">[]) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;">;</span></span></code></pre></div></li><li><p>参数</p><table><thead><tr><th>参数</th><th>类型</th><th>是否必填</th><th>默认值</th><th>说明</th></tr></thead><tbody><tr><td>stars</td><td><a href="./../type-definition.html#starname"><code>StarName[]</code></a></td><td><code>true</code></td><td>-</td><td>星耀名称，可以包含主星、辅星、杂耀</td></tr></tbody></table></li><li><p>返回值</p><p><code>boolean</code></p></li><li><p>示例</p><p>如果你想查看 <code>命宫</code> 三方四正是否没有 <code>地空星</code> 和 <code>地劫星</code></p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">palaces</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">surroundedPalaces</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;命宫&quot;</span><span style="color:#E1E4E8;">);</span></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">result</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> palaces.</span><span style="color:#B392F0;">notHave</span><span style="color:#E1E4E8;">([</span><span style="color:#9ECBFF;">&quot;地空&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;地劫&quot;</span><span style="color:#E1E4E8;">]);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">palaces</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">surroundedPalaces</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;命宫&quot;</span><span style="color:#24292E;">);</span></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">result</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> palaces.</span><span style="color:#6F42C1;">notHave</span><span style="color:#24292E;">([</span><span style="color:#032F62;">&quot;地空&quot;</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;地劫&quot;</span><span style="color:#24292E;">]);</span></span></code></pre></div><p>当然你也可以使用 <code>链式调用</code> 来简化代码</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">result</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">surroundedPalaces</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;命宫&quot;</span><span style="color:#E1E4E8;">).</span><span style="color:#B392F0;">notHave</span><span style="color:#E1E4E8;">([</span><span style="color:#9ECBFF;">&quot;地空&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;地劫&quot;</span><span style="color:#E1E4E8;">]);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">result</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">surroundedPalaces</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;命宫&quot;</span><span style="color:#24292E;">).</span><span style="color:#6F42C1;">notHave</span><span style="color:#24292E;">([</span><span style="color:#032F62;">&quot;地空&quot;</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;地劫&quot;</span><span style="color:#24292E;">]);</span></span></code></pre></div></li></ul><hr><h5 id="haveoneof" tabindex="-1">haveOneOf() <a class="header-anchor" href="#haveoneof" aria-label="Permalink to &quot;haveOneOf()&quot;">​</a></h5><ul><li><p>用途</p><p>判断某个宫位的三方四正内是否有传入 <code>星耀</code> 的其中一个，只要 <code>命中一个</code> 就会返回 <code>true</code></p></li><li><p>定义</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">type</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">haveOneOf</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> (</span><span style="color:#FFAB70;">stars</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">StarName</span><span style="color:#E1E4E8;">[]) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;">;</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">type</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">haveOneOf</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> (</span><span style="color:#E36209;">stars</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">StarName</span><span style="color:#24292E;">[]) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;">;</span></span></code></pre></div></li><li><p>参数</p><table><thead><tr><th>参数</th><th>类型</th><th>是否必填</th><th>默认值</th><th>说明</th></tr></thead><tbody><tr><td>stars</td><td><a href="./../type-definition.html#starname"><code>StarName[]</code></a></td><td><code>true</code></td><td>-</td><td>星耀名称，可以包含主星、辅星、杂耀</td></tr></tbody></table></li><li><p>返回值</p><p><code>boolean</code></p></li><li><p>示例</p><p>如果你想查看 <code>命宫</code> 三方四正是否有 <code>天魁星</code> 或 <code>天钺星</code></p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">palaces</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">surroundedPalaces</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;命宫&quot;</span><span style="color:#E1E4E8;">);</span></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">result</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> palaces.</span><span style="color:#B392F0;">haveOneOf</span><span style="color:#E1E4E8;">([</span><span style="color:#9ECBFF;">&quot;天魁&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;天钺&quot;</span><span style="color:#E1E4E8;">]);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">palaces</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">surroundedPalaces</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;命宫&quot;</span><span style="color:#24292E;">);</span></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">result</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> palaces.</span><span style="color:#6F42C1;">haveOneOf</span><span style="color:#24292E;">([</span><span style="color:#032F62;">&quot;天魁&quot;</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;天钺&quot;</span><span style="color:#24292E;">]);</span></span></code></pre></div><p>当然你也可以使用 <code>链式调用</code> 来简化代码</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">result</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">surroundedPalaces</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;命宫&quot;</span><span style="color:#E1E4E8;">).</span><span style="color:#B392F0;">haveOneOf</span><span style="color:#E1E4E8;">([</span><span style="color:#9ECBFF;">&quot;天魁&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;天钺&quot;</span><span style="color:#E1E4E8;">]);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">result</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">surroundedPalaces</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;命宫&quot;</span><span style="color:#24292E;">).</span><span style="color:#6F42C1;">haveOneOf</span><span style="color:#24292E;">([</span><span style="color:#032F62;">&quot;天魁&quot;</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;天钺&quot;</span><span style="color:#24292E;">]);</span></span></code></pre></div></li></ul><hr><h5 id="havemutagen" tabindex="-1">haveMutagen() <a class="header-anchor" href="#havemutagen" aria-label="Permalink to &quot;haveMutagen()&quot;">​</a></h5><ul><li><p>用途</p><p>判断宫位三方四正内是否有生年四化</p></li><li><p>定义</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">type</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">haveMutagen</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> (</span><span style="color:#FFAB70;">mutagen</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">Mutagen</span><span style="color:#E1E4E8;">) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;">;</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">type</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">haveMutagen</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> (</span><span style="color:#E36209;">mutagen</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">Mutagen</span><span style="color:#24292E;">) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;">;</span></span></code></pre></div></li><li><p>参数</p><table><thead><tr><th>参数</th><th>类型</th><th>是否必填</th><th>默认值</th><th>说明</th></tr></thead><tbody><tr><td>mutagen</td><td><a href="./../type-definition.html#mutagen"><code>Mutagen</code></a></td><td><code>true</code></td><td>-</td><td>四化名称【禄｜权｜科｜忌】</td></tr></tbody></table></li><li><p>返回值</p><p><code>boolean</code></p></li><li><p>示例</p><p>如果你想查看 <code>命宫</code> 三方四正是否有 <code>化禄</code></p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">palaces</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">surroundedPalaces</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;命宫&quot;</span><span style="color:#E1E4E8;">);</span></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">result</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> palaces.</span><span style="color:#B392F0;">haveMutagen</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;禄&quot;</span><span style="color:#E1E4E8;">);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">palaces</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">surroundedPalaces</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;命宫&quot;</span><span style="color:#24292E;">);</span></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">result</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> palaces.</span><span style="color:#6F42C1;">haveMutagen</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;禄&quot;</span><span style="color:#24292E;">);</span></span></code></pre></div><p>当然你也可以使用 <code>链式调用</code> 来简化代码</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">result</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">surroundedPalaces</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;命宫&quot;</span><span style="color:#E1E4E8;">).</span><span style="color:#B392F0;">haveMutagen</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;禄&quot;</span><span style="color:#E1E4E8;">);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">result</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">surroundedPalaces</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;命宫&quot;</span><span style="color:#24292E;">).</span><span style="color:#6F42C1;">haveMutagen</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;禄&quot;</span><span style="color:#24292E;">);</span></span></code></pre></div></li></ul><hr><h5 id="nothavemutagen-1" tabindex="-1">notHaveMutagen() <a class="header-anchor" href="#nothavemutagen-1" aria-label="Permalink to &quot;notHaveMutagen()&quot;">​</a></h5><ul><li><p>用途</p><p>判断宫位三方四正内是否没有生年四化</p></li><li><p>定义</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">type</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">notHaveMutagen</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> (</span><span style="color:#FFAB70;">mutagen</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">Mutagen</span><span style="color:#E1E4E8;">) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;">;</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">type</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">notHaveMutagen</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> (</span><span style="color:#E36209;">mutagen</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">Mutagen</span><span style="color:#24292E;">) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;">;</span></span></code></pre></div></li><li><p>参数</p><table><thead><tr><th>参数</th><th>类型</th><th>是否必填</th><th>默认值</th><th>说明</th></tr></thead><tbody><tr><td>mutagen</td><td><a href="./../type-definition.html#mutagen"><code>Mutagen</code></a></td><td><code>true</code></td><td>-</td><td>四化名称【禄｜权｜科｜忌】</td></tr></tbody></table></li><li><p>返回值</p><p><code>boolean</code></p></li><li><p>示例</p><p>如果你想查看 <code>命宫</code> 三方四正是不是没有 <code>化忌</code></p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">palace</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">surroundedPalaces</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;命宫&quot;</span><span style="color:#E1E4E8;">);</span></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">result</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> palace.</span><span style="color:#B392F0;">notHaveMutagen</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;忌&quot;</span><span style="color:#E1E4E8;">);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">palace</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">surroundedPalaces</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;命宫&quot;</span><span style="color:#24292E;">);</span></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">result</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> palace.</span><span style="color:#6F42C1;">notHaveMutagen</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;忌&quot;</span><span style="color:#24292E;">);</span></span></code></pre></div><p>当然你也可以使用 <code>链式调用</code> 来简化代码</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">result</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">surroundedPalaces</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;命宫&quot;</span><span style="color:#E1E4E8;">).</span><span style="color:#B392F0;">notHaveMutagen</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;忌&quot;</span><span style="color:#E1E4E8;">);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">result</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">surroundedPalaces</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;命宫&quot;</span><span style="color:#24292E;">).</span><span style="color:#6F42C1;">notHaveMutagen</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;忌&quot;</span><span style="color:#24292E;">);</span></span></code></pre></div></li></ul></li></ul>`,3);function O(I,V,w,z,R,$){const o=e("Badge");return t(),c("div",null,[y,l(o,{type:"tip",text:"implements"}),a(),E,a(),l(o,{type:"tip",text:"extends"}),a(),d,i,s("ul",null,[u,s("li",null,[F,s("h5",h,[a("has() "),l(o,{type:"warning",text:"^1.0.0"}),a(),g]),C,s("h5",b,[a("notHave() "),l(o,{type:"warning",text:"^1.0.0"}),a(),v]),q,s("h5",B,[a("hasOneOf() "),l(o,{type:"warning",text:"^1.0.0"}),a(),A]),k,s("h5",D,[a("hasMutagen() "),l(o,{type:"warning",text:"^1.2.0"}),a(),_]),m,s("h5",f,[a("notHaveMutagen() "),l(o,{type:"warning",text:"^1.2.0"}),a(),P]),S])]),s("h4",M,[a("FunctionalSurpalaces "),l(o,{type:"warning",text:"^1.2.0"}),a(),T]),N,l(o,{type:"tip",text:"implements"}),a(),x,a(),l(o,{type:"tip",text:"extends"}),a(),H])}const j=p(r,[["render",O]]);export{Q as __pageData,j as default};
