import{_ as p,C as e,o as t,c,H as l,a,k as s,Q as n}from"./chunks/framework.f0e9ff50.js";const J=JSON.parse('{"title":"宮位","description":"iztro紫微鬥數宮位介紹，iztro的palace對象使用方法以及示例代碼。","frontmatter":{"outline":"deep","description":"iztro紫微鬥數宮位介紹，iztro的palace對象使用方法以及示例代碼。"},"headers":[],"relativePath":"zh_TW/posts/palace.md","filePath":"zh_TW/posts/palace.md"}'),r={name:"zh_TW/posts/palace.md"},y=n(`<h1 id="宮位" tabindex="-1">宮位 <a class="header-anchor" href="#宮位" aria-label="Permalink to &quot;宮位&quot;">​</a></h1><h3 id="概述" tabindex="-1">概述 <a class="header-anchor" href="#概述" aria-label="Permalink to &quot;概述&quot;">​</a></h3><p>紫微鬥數中壹共有 <code>十二</code> 個宮位，叫做 <code>十二人事宮</code>，囊括了與人有關的其他人和事物，這十二宮按順序分別是 <code>命宮</code>、<code>兄弟宮</code>、<code>夫妻宮</code>、<code>子女宮</code>、<code>財帛宮</code>、<code>疾厄宮</code>、<code>遷移宮</code>、<code>仆役宮</code>、<code>官祿宮</code>、<code>田宅宮</code>、<code>福德宮</code>、<code>父母宮</code>。除了這展示在 <a href="./astrolabe.html">星盤</a> 裏的十二宮以外，紫微鬥數還有三個隱藏宮位，它們分別是 <code>身宮</code>、<code>來因宮</code>、<code>暗合宮</code>。每壹個宮位有著它特殊的意義，但本頁不詳細展開來敘述。如果妳對紫微鬥數的宮位沒有概念，或者想深入研究，可以點擊 <a href="./../learn/palace.html">傳送門</a> 查看詳細資料。與宮位地支順時針排列相反，宮位名稱是按逆時針排列的。如下面表格所示：</p><table class="astrolabe"><tr><td>巳 <code>田宅</code></td><td>午 <code>官祿</code></td><td>未 <code>仆役</code></td><td>申 <code>遷移</code></td></tr><tr><td>辰 <code>福德</code></td><td class="center-palace" rowspan="2" colspan="2">中宮</td><td>酉 <code>疾厄</code></td></tr><tr><td>卯 <code>父母</code></td><td>戌 <code>財帛</code></td></tr><tr><td>寅 <code>命宮</code></td><td>醜 <code>兄弟</code></td><td>子 <code>夫妻</code></td><td>亥 <code>子女</code></td></tr></table><blockquote><p>以上表格隻是壹個例子，<code>命宮</code> 的位置會根據妳的 <code>出生日期</code> 和 <code>出生時間</code> 的不同而不同，它可能出現在上述任何壹個宮位，但這個順序是不會變的。</p></blockquote><p>宮位其實是 <code>宮</code> 和 <code>位</code> 兩個概念組成的，通過 <code>出生日期</code> 和 <code>出生時間</code> 計算出來的，叫 <code>宮</code>，所以妳星盤中的 <code>財帛宮</code> 位置在本命盤中是固定的，如果妳不知道什麽叫 <code>本命盤</code>，我們強烈建議妳點擊 <a href="/learn/basis.html">傳送門</a> 學習。<code>位</code> 則是壹個 <code>相對</code> 位置，比如 <code>夫妻宮</code> 的 <code>財帛位</code> 是 <code>遷移宮</code>。這聽起來有些繞，好消息是，妳不需要記憶這些燒腦的信息，隻需要有這麽壹個概念就可以了。</p><h3 id="功能類定義" tabindex="-1">功能類定義 <a class="header-anchor" href="#功能類定義" aria-label="Permalink to &quot;功能類定義&quot;">​</a></h3><div class="warning custom-block"><p class="custom-block-title">開發建議</p><p>因為宮位是基於星盤而存在的，所以我們並不推薦妳手動 <code>new</code> 壹個宮位對象，而是使用星盤靜態方法返回的對象使用。星盤的 <code>palaces</code> 屬性包含了十二宮的數據，為了和地支的順序保持壹致，它是從 <code>寅宮</code> 開始按照地支順序順時針排列的。</p></div><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">import</span><span style="color:#E1E4E8;"> { astro } </span><span style="color:#F97583;">from</span><span style="color:#E1E4E8;"> </span><span style="color:#9ECBFF;">&quot;iztro&quot;</span><span style="color:#E1E4E8;">;</span></span>
<span class="line"></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">astrolabe</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astro.</span><span style="color:#B392F0;">astrolabeBySolarDate</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;2000-8-16&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">2</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;女&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">true</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;zh-CN&quot;</span><span style="color:#E1E4E8;">);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">import</span><span style="color:#24292E;"> { astro } </span><span style="color:#D73A49;">from</span><span style="color:#24292E;"> </span><span style="color:#032F62;">&quot;iztro&quot;</span><span style="color:#24292E;">;</span></span>
<span class="line"></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">astrolabe</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astro.</span><span style="color:#6F42C1;">astrolabeBySolarDate</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;2000-8-16&quot;</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">2</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;女&quot;</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">true</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;zh-CN&quot;</span><span style="color:#24292E;">);</span></span></code></pre></div><p>妳可以有幾種方式從上述 <code>astrolabe</code> 變量裏獲取到目標宮位，請根據實際需求使用：</p><ol><li><p>通過 <code>palaces</code> 的下標獲取</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#6A737D;">// 獲取卯宮宮位</span></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">palace</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.palaces[</span><span style="color:#79B8FF;">1</span><span style="color:#E1E4E8;">];</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#6A737D;">// 獲取卯宮宮位</span></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">palace</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.palaces[</span><span style="color:#005CC5;">1</span><span style="color:#24292E;">];</span></span></code></pre></div></li><li><p>通過 <code>FunctionalAstrolabe</code> 類的 <code>palace()</code> 方法傳入宮位 <code>索引</code> 獲取</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#6A737D;">// 獲取卯宮宮位</span></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">palace</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">palace</span><span style="color:#E1E4E8;">(</span><span style="color:#79B8FF;">1</span><span style="color:#E1E4E8;">);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#6A737D;">// 獲取卯宮宮位</span></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">palace</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">palace</span><span style="color:#24292E;">(</span><span style="color:#005CC5;">1</span><span style="color:#24292E;">);</span></span></code></pre></div></li><li><p>通過 <code>FunctionalAstrolabe</code> 類的 <code>palace()</code> 方法傳入宮位 <code>名稱</code> 獲取</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#6A737D;">// 獲取命宮</span></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">palace</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">palace</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;命宮&quot;</span><span style="color:#E1E4E8;">);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#6A737D;">// 獲取命宮</span></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">palace</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">palace</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;命宮&quot;</span><span style="color:#24292E;">);</span></span></code></pre></div></li></ol><h4 id="functionalpalace" tabindex="-1">FunctionalPalace <a class="header-anchor" href="#functionalpalace" aria-label="Permalink to &quot;FunctionalPalace&quot;">​</a></h4><hr>`,13),E=s("code",null,"IFuncionalPalace",-1),d=s("a",{href:"./../type-definition.html#palace"},[s("code",null,"Palace")],-1),i=s("p",null,[a("該類所有屬性都是繼承自 "),s("a",{href:"./../type-definition.html#palace"},"Palace"),a("，然後在接口內定義了壹些方法用於對星耀進行分析。")],-1),u=n(`<li><p>接口定義</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">interface</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">IFunctionalPalace</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">extends</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">Palace</span><span style="color:#E1E4E8;"> {</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#B392F0;">has</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> (</span><span style="color:#FFAB70;">stars</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">StarName</span><span style="color:#E1E4E8;">[]) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;">;</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#B392F0;">notHave</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> (</span><span style="color:#FFAB70;">stars</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">StarName</span><span style="color:#E1E4E8;">[]) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;">;</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#B392F0;">hasOneOf</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> (</span><span style="color:#FFAB70;">stars</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">StarName</span><span style="color:#E1E4E8;">[]) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;">;</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#B392F0;">hasMutagen</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> (</span><span style="color:#FFAB70;">mutagen</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">Mutagen</span><span style="color:#E1E4E8;">)</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;">;</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#B392F0;">notHaveMutagen</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> (</span><span style="color:#FFAB70;">mutagen</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">Mutagen</span><span style="color:#E1E4E8;">)</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;">;</span></span>
<span class="line"><span style="color:#E1E4E8;">}</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">interface</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">IFunctionalPalace</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">extends</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">Palace</span><span style="color:#24292E;"> {</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6F42C1;">has</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> (</span><span style="color:#E36209;">stars</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">StarName</span><span style="color:#24292E;">[]) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;">;</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6F42C1;">notHave</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> (</span><span style="color:#E36209;">stars</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">StarName</span><span style="color:#24292E;">[]) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;">;</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6F42C1;">hasOneOf</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> (</span><span style="color:#E36209;">stars</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">StarName</span><span style="color:#24292E;">[]) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;">;</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6F42C1;">hasMutagen</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> (</span><span style="color:#E36209;">mutagen</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">Mutagen</span><span style="color:#24292E;">)</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;">;</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6F42C1;">notHaveMutagen</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> (</span><span style="color:#E36209;">mutagen</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">Mutagen</span><span style="color:#24292E;">)</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;">;</span></span>
<span class="line"><span style="color:#24292E;">}</span></span></code></pre></div></li><li><p>屬性</p><p>參考 <a href="./../type-definition.html#palace">Palace</a></p></li>`,2),F=s("p",null,"方法",-1),h={id:"has",tabindex:"-1"},g=s("a",{class:"header-anchor",href:"#has","aria-label":'Permalink to "has() <Badge type="warning" text="^1.0.0" />"'},"​",-1),C=n(`<ul><li><p>用途</p><p>判斷某個宮位內是否有傳入的 <code>星耀</code>，要 <code>所有</code> 星耀 <code>都在</code> 宮位內才會返回 <code>true</code></p></li><li><p>定義</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">type</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">has</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> (</span><span style="color:#FFAB70;">stars</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">StarName</span><span style="color:#E1E4E8;">[]) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;">;</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">type</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">has</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> (</span><span style="color:#E36209;">stars</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">StarName</span><span style="color:#24292E;">[]) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;">;</span></span></code></pre></div></li><li><p>參數</p><table><thead><tr><th>參數</th><th>類型</th><th>是否必填</th><th>默認值</th><th>說明</th></tr></thead><tbody><tr><td>stars</td><td><a href="./../type-definition.html#starname"><code>StarName[]</code></a></td><td><code>true</code></td><td>-</td><td>星耀名稱，可以包含主星、輔星、雜耀</td></tr></tbody></table></li><li><p>返回值</p><p><code>boolean</code></p></li><li><p>示例</p><p>如果妳想查看 <code>命宮</code> 是否有 <code>紫微星</code> 和 <code>右弼星</code></p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">palace</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">palace</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;命宮&quot;</span><span style="color:#E1E4E8;">);</span></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">result</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> palace.</span><span style="color:#B392F0;">has</span><span style="color:#E1E4E8;">([</span><span style="color:#9ECBFF;">&quot;紫微&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;右弼&quot;</span><span style="color:#E1E4E8;">]);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">palace</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">palace</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;命宮&quot;</span><span style="color:#24292E;">);</span></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">result</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> palace.</span><span style="color:#6F42C1;">has</span><span style="color:#24292E;">([</span><span style="color:#032F62;">&quot;紫微&quot;</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;右弼&quot;</span><span style="color:#24292E;">]);</span></span></code></pre></div><p>當然妳也可以使用 <code>鏈式調用</code> 來簡化代碼</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">result</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">palace</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;命宮&quot;</span><span style="color:#E1E4E8;">).</span><span style="color:#B392F0;">has</span><span style="color:#E1E4E8;">([</span><span style="color:#9ECBFF;">&quot;紫微&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;右弼&quot;</span><span style="color:#E1E4E8;">]);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">result</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">palace</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;命宮&quot;</span><span style="color:#24292E;">).</span><span style="color:#6F42C1;">has</span><span style="color:#24292E;">([</span><span style="color:#032F62;">&quot;紫微&quot;</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;右弼&quot;</span><span style="color:#24292E;">]);</span></span></code></pre></div></li></ul><hr>`,2),b={id:"nothave",tabindex:"-1"},v=s("a",{class:"header-anchor",href:"#nothave","aria-label":'Permalink to "notHave() <Badge type="warning" text="^1.0.0" />"'},"​",-1),q=n(`<ul><li><p>用途</p><p>判斷某個宮位內是否沒有傳入的 <code>星耀</code>，要所有星耀 <code>都不在</code> 宮位內才會返回 <code>true</code></p></li><li><p>定義</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">type</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">notHave</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> (</span><span style="color:#FFAB70;">stars</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">StarName</span><span style="color:#E1E4E8;">[]) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;">;</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">type</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">notHave</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> (</span><span style="color:#E36209;">stars</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">StarName</span><span style="color:#24292E;">[]) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;">;</span></span></code></pre></div></li><li><p>參數</p><table><thead><tr><th>參數</th><th>類型</th><th>是否必填</th><th>默認值</th><th>說明</th></tr></thead><tbody><tr><td>stars</td><td><a href="./../type-definition.html#starname"><code>StarName[]</code></a></td><td><code>true</code></td><td>-</td><td>星耀名稱，可以包含主星、輔星、雜耀</td></tr></tbody></table></li><li><p>返回值</p><p><code>boolean</code></p></li><li><p>示例</p><p>如果妳想查看 <code>命宮</code> 是沒有 <code>地空星</code> 和 <code>地劫星</code></p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">palace</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">palace</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;命宮&quot;</span><span style="color:#E1E4E8;">);</span></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">result</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> palace.</span><span style="color:#B392F0;">notHave</span><span style="color:#E1E4E8;">([</span><span style="color:#9ECBFF;">&quot;地空&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;地劫&quot;</span><span style="color:#E1E4E8;">]);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">palace</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">palace</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;命宮&quot;</span><span style="color:#24292E;">);</span></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">result</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> palace.</span><span style="color:#6F42C1;">notHave</span><span style="color:#24292E;">([</span><span style="color:#032F62;">&quot;地空&quot;</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;地劫&quot;</span><span style="color:#24292E;">]);</span></span></code></pre></div><p>當然妳也可以使用 <code>鏈式調用</code> 來簡化代碼</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">result</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">palace</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;命宮&quot;</span><span style="color:#E1E4E8;">).</span><span style="color:#B392F0;">notHave</span><span style="color:#E1E4E8;">([</span><span style="color:#9ECBFF;">&quot;地空&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;地劫&quot;</span><span style="color:#E1E4E8;">]);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">result</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">palace</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;命宮&quot;</span><span style="color:#24292E;">).</span><span style="color:#6F42C1;">notHave</span><span style="color:#24292E;">([</span><span style="color:#032F62;">&quot;地空&quot;</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;地劫&quot;</span><span style="color:#24292E;">]);</span></span></code></pre></div></li></ul><hr>`,2),B={id:"hasoneof",tabindex:"-1"},A=s("a",{class:"header-anchor",href:"#hasoneof","aria-label":'Permalink to "hasOneOf() <Badge type="warning" text="^1.0.0" />"'},"​",-1),k=n(`<ul><li><p>用途</p><p>判斷某個宮位內是否有傳入 <code>星耀</code> 的其中壹個，隻要 <code>命中壹個</code> 就會返回 <code>true</code></p></li><li><p>定義</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">type</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">hasOneOf</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> (</span><span style="color:#FFAB70;">stars</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">StarName</span><span style="color:#E1E4E8;">[]) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;">;</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">type</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">hasOneOf</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> (</span><span style="color:#E36209;">stars</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">StarName</span><span style="color:#24292E;">[]) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;">;</span></span></code></pre></div></li><li><p>參數</p><table><thead><tr><th>參數</th><th>類型</th><th>是否必填</th><th>默認值</th><th>說明</th></tr></thead><tbody><tr><td>stars</td><td><a href="./../type-definition.html#starname"><code>StarName[]</code></a></td><td><code>true</code></td><td>-</td><td>星耀名稱，可以包含主星、輔星、雜耀</td></tr></tbody></table></li><li><p>返回值</p><p><code>boolean</code></p></li><li><p>示例</p><p>如果妳想查看 <code>命宮</code> 是否有 <code>天魁星</code> 或 <code>天鉞星</code></p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">palace</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">palace</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;命宮&quot;</span><span style="color:#E1E4E8;">);</span></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">result</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> palace.</span><span style="color:#B392F0;">hasOneOf</span><span style="color:#E1E4E8;">([</span><span style="color:#9ECBFF;">&quot;天魁&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;天鉞&quot;</span><span style="color:#E1E4E8;">]);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">palace</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">palace</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;命宮&quot;</span><span style="color:#24292E;">);</span></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">result</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> palace.</span><span style="color:#6F42C1;">hasOneOf</span><span style="color:#24292E;">([</span><span style="color:#032F62;">&quot;天魁&quot;</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;天鉞&quot;</span><span style="color:#24292E;">]);</span></span></code></pre></div><p>當然妳也可以使用 <code>鏈式調用</code> 來簡化代碼</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">result</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">palace</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;命宮&quot;</span><span style="color:#E1E4E8;">).</span><span style="color:#B392F0;">hasOneOf</span><span style="color:#E1E4E8;">([</span><span style="color:#9ECBFF;">&quot;天魁&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;天鉞&quot;</span><span style="color:#E1E4E8;">]);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">result</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">palace</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;命宮&quot;</span><span style="color:#24292E;">).</span><span style="color:#6F42C1;">hasOneOf</span><span style="color:#24292E;">([</span><span style="color:#032F62;">&quot;天魁&quot;</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;天鉞&quot;</span><span style="color:#24292E;">]);</span></span></code></pre></div></li></ul><hr>`,2),_={id:"hasmutagen",tabindex:"-1"},D=s("a",{class:"header-anchor",href:"#hasmutagen","aria-label":'Permalink to "hasMutagen() <Badge type="warning" text="^1.2.0" />"'},"​",-1),m=n(`<ul><li><p>用途</p><p>判斷宮位內是否有生年四化</p></li><li><p>定義</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">type</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">hasMutagen</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> (</span><span style="color:#FFAB70;">mutagen</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">Mutagen</span><span style="color:#E1E4E8;">) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;">;</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">type</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">hasMutagen</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> (</span><span style="color:#E36209;">mutagen</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">Mutagen</span><span style="color:#24292E;">) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;">;</span></span></code></pre></div></li><li><p>參數</p><table><thead><tr><th>參數</th><th>類型</th><th>是否必填</th><th>默認值</th><th>說明</th></tr></thead><tbody><tr><td>mutagen</td><td><a href="./../type-definition.html#mutagen"><code>Mutagen</code></a></td><td><code>true</code></td><td>-</td><td>四化名稱【祿｜權｜科｜忌】</td></tr></tbody></table></li><li><p>返回值</p><p><code>boolean</code></p></li><li><p>示例</p><p>如果妳想查看 <code>命宮</code> 是否有 <code>化祿</code></p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">palace</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">palace</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;命宮&quot;</span><span style="color:#E1E4E8;">);</span></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">result</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> palace.</span><span style="color:#B392F0;">hasMutagen</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;祿&quot;</span><span style="color:#E1E4E8;">);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">palace</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">palace</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;命宮&quot;</span><span style="color:#24292E;">);</span></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">result</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> palace.</span><span style="color:#6F42C1;">hasMutagen</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;祿&quot;</span><span style="color:#24292E;">);</span></span></code></pre></div><p>當然妳也可以使用 <code>鏈式調用</code> 來簡化代碼</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">result</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">palace</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;命宮&quot;</span><span style="color:#E1E4E8;">).</span><span style="color:#B392F0;">hasMutagen</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;祿&quot;</span><span style="color:#E1E4E8;">);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">result</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">palace</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;命宮&quot;</span><span style="color:#24292E;">).</span><span style="color:#6F42C1;">hasMutagen</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;祿&quot;</span><span style="color:#24292E;">);</span></span></code></pre></div></li></ul><hr>`,2),f={id:"nothavemutagen",tabindex:"-1"},P=s("a",{class:"header-anchor",href:"#nothavemutagen","aria-label":'Permalink to "notHaveMutagen() <Badge type="warning" text="^1.2.0" />"'},"​",-1),S=n(`<ul><li><p>用途</p><p>判斷宮位內是否沒有生年四化</p></li><li><p>定義</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">type</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">notHaveMutagen</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> (</span><span style="color:#FFAB70;">mutagen</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">Mutagen</span><span style="color:#E1E4E8;">) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;">;</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">type</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">notHaveMutagen</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> (</span><span style="color:#E36209;">mutagen</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">Mutagen</span><span style="color:#24292E;">) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;">;</span></span></code></pre></div></li><li><p>參數</p><table><thead><tr><th>參數</th><th>類型</th><th>是否必填</th><th>默認值</th><th>說明</th></tr></thead><tbody><tr><td>mutagen</td><td><a href="./../type-definition.html#mutagen"><code>Mutagen</code></a></td><td><code>true</code></td><td>-</td><td>四化名稱【祿｜權｜科｜忌】</td></tr></tbody></table></li><li><p>返回值</p><p><code>boolean</code></p></li><li><p>示例</p><p>如果妳想查看 <code>命宮</code> 是不是沒有 <code>化忌</code></p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">palace</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">palace</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;命宮&quot;</span><span style="color:#E1E4E8;">);</span></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">result</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> palace.</span><span style="color:#B392F0;">notHaveMutagen</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;忌&quot;</span><span style="color:#E1E4E8;">);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">palace</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">palace</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;命宮&quot;</span><span style="color:#24292E;">);</span></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">result</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> palace.</span><span style="color:#6F42C1;">notHaveMutagen</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;忌&quot;</span><span style="color:#24292E;">);</span></span></code></pre></div><p>當然妳也可以使用 <code>鏈式調用</code> 來簡化代碼</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">result</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">palace</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;命宮&quot;</span><span style="color:#E1E4E8;">).</span><span style="color:#B392F0;">notHaveMutagen</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;忌&quot;</span><span style="color:#E1E4E8;">);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">result</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">palace</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;命宮&quot;</span><span style="color:#24292E;">).</span><span style="color:#6F42C1;">notHaveMutagen</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;忌&quot;</span><span style="color:#24292E;">);</span></span></code></pre></div></li></ul>`,1),M={id:"functionalsurpalaces",tabindex:"-1"},T=s("a",{class:"header-anchor",href:"#functionalsurpalaces","aria-label":'Permalink to "FunctionalSurpalaces <Badge type="warning" text="^1.2.0" />"'},"​",-1),N=s("hr",null,null,-1),x=s("code",null,"IFunctionalSurpalaces",-1),H=n(`<a href="./../type-definition.html#surroundedpalaces"><code>SurroundedPalaces</code></a><p>該類所有屬性都是繼承自 <a href="./../type-definition.html#surroundedpalaces">SurroundedPalaces</a>，然後在接口內定義了壹些方法用於對星耀進行分析。</p><ul><li><p>接口定義</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">interface</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">FunctionalSurpalaces</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">extends</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">SurroundedPalaces</span><span style="color:#E1E4E8;"> {</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#B392F0;">have</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> (</span><span style="color:#FFAB70;">stars</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">StarName</span><span style="color:#E1E4E8;">[]) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;">;</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#B392F0;">notHave</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> (</span><span style="color:#FFAB70;">stars</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">StarName</span><span style="color:#E1E4E8;">[]) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;">;</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#B392F0;">haveOneOf</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> (</span><span style="color:#FFAB70;">stars</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">StarName</span><span style="color:#E1E4E8;">[]) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;">;</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#B392F0;">haveMutagen</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> (</span><span style="color:#FFAB70;">mutagen</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">Mutagen</span><span style="color:#E1E4E8;">) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;">;</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#B392F0;">notHaveMutagen</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> (</span><span style="color:#FFAB70;">mutagen</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">Mutagen</span><span style="color:#E1E4E8;">)</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;">;</span></span>
<span class="line"><span style="color:#E1E4E8;">}</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">interface</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">FunctionalSurpalaces</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">extends</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">SurroundedPalaces</span><span style="color:#24292E;"> {</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6F42C1;">have</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> (</span><span style="color:#E36209;">stars</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">StarName</span><span style="color:#24292E;">[]) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;">;</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6F42C1;">notHave</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> (</span><span style="color:#E36209;">stars</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">StarName</span><span style="color:#24292E;">[]) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;">;</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6F42C1;">haveOneOf</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> (</span><span style="color:#E36209;">stars</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">StarName</span><span style="color:#24292E;">[]) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;">;</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6F42C1;">haveMutagen</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> (</span><span style="color:#E36209;">mutagen</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">Mutagen</span><span style="color:#24292E;">) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;">;</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6F42C1;">notHaveMutagen</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> (</span><span style="color:#E36209;">mutagen</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">Mutagen</span><span style="color:#24292E;">)</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;">;</span></span>
<span class="line"><span style="color:#24292E;">}</span></span></code></pre></div></li><li><p>屬性</p><p>參考 <a href="./../type-definition.html#surroundedpalaces">SurroundedPalaces</a></p></li><li><p>方法</p><h5 id="have" tabindex="-1">have() <a class="header-anchor" href="#have" aria-label="Permalink to &quot;have()&quot;">​</a></h5><ul><li><p>用途</p><p>判斷某個宮三方四正內是否有傳入的 <code>星耀</code>，要 <code>所有</code> 星耀 <code>都在</code> 三方四正內才會返回 <code>true</code></p></li><li><p>定義</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">type</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">have</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> (</span><span style="color:#FFAB70;">stars</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">StarName</span><span style="color:#E1E4E8;">[]) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;">;</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">type</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">have</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> (</span><span style="color:#E36209;">stars</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">StarName</span><span style="color:#24292E;">[]) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;">;</span></span></code></pre></div></li><li><p>參數</p><table><thead><tr><th>參數</th><th>類型</th><th>是否必填</th><th>默認值</th><th>說明</th></tr></thead><tbody><tr><td>stars</td><td><a href="./../type-definition.html#starname"><code>StarName[]</code></a></td><td><code>true</code></td><td>-</td><td>星耀名稱，可以包含主星、輔星、雜耀</td></tr></tbody></table></li><li><p>返回值</p><p><code>boolean</code></p></li><li><p>示例</p><p>如果妳想查看 <code>命宮</code> 三方四正是否有 <code>紫微星</code> 和 <code>右弼星</code></p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">palaces</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">surroundedPalaces</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;命宮&quot;</span><span style="color:#E1E4E8;">);</span></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">result</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> palaces.</span><span style="color:#B392F0;">have</span><span style="color:#E1E4E8;">([</span><span style="color:#9ECBFF;">&quot;紫微&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;右弼&quot;</span><span style="color:#E1E4E8;">]);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">palaces</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">surroundedPalaces</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;命宮&quot;</span><span style="color:#24292E;">);</span></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">result</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> palaces.</span><span style="color:#6F42C1;">have</span><span style="color:#24292E;">([</span><span style="color:#032F62;">&quot;紫微&quot;</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;右弼&quot;</span><span style="color:#24292E;">]);</span></span></code></pre></div><p>當然妳也可以使用 <code>鏈式調用</code> 來簡化代碼</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">result</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">surroundedPalaces</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;命宮&quot;</span><span style="color:#E1E4E8;">).</span><span style="color:#B392F0;">have</span><span style="color:#E1E4E8;">([</span><span style="color:#9ECBFF;">&quot;紫微&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;右弼&quot;</span><span style="color:#E1E4E8;">]);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">result</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">surroundedPalaces</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;命宮&quot;</span><span style="color:#24292E;">).</span><span style="color:#6F42C1;">have</span><span style="color:#24292E;">([</span><span style="color:#032F62;">&quot;紫微&quot;</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;右弼&quot;</span><span style="color:#24292E;">]);</span></span></code></pre></div></li></ul><hr><h5 id="nothave-1" tabindex="-1">notHave() <a class="header-anchor" href="#nothave-1" aria-label="Permalink to &quot;notHave()&quot;">​</a></h5><ul><li><p>用途</p><p>判斷某個宮三方四正內是否沒有傳入的 <code>星耀</code>，要所有星耀 <code>都不在</code> 三方四正內才會返回 <code>true</code></p></li><li><p>定義</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">type</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">notHave</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> (</span><span style="color:#FFAB70;">stars</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">StarName</span><span style="color:#E1E4E8;">[]) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;">;</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">type</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">notHave</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> (</span><span style="color:#E36209;">stars</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">StarName</span><span style="color:#24292E;">[]) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;">;</span></span></code></pre></div></li><li><p>參數</p><table><thead><tr><th>參數</th><th>類型</th><th>是否必填</th><th>默認值</th><th>說明</th></tr></thead><tbody><tr><td>stars</td><td><a href="./../type-definition.html#starname"><code>StarName[]</code></a></td><td><code>true</code></td><td>-</td><td>星耀名稱，可以包含主星、輔星、雜耀</td></tr></tbody></table></li><li><p>返回值</p><p><code>boolean</code></p></li><li><p>示例</p><p>如果妳想查看 <code>命宮</code> 三方四正是否沒有 <code>地空星</code> 和 <code>地劫星</code></p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">palaces</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">surroundedPalaces</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;命宮&quot;</span><span style="color:#E1E4E8;">);</span></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">result</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> palaces.</span><span style="color:#B392F0;">notHave</span><span style="color:#E1E4E8;">([</span><span style="color:#9ECBFF;">&quot;地空&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;地劫&quot;</span><span style="color:#E1E4E8;">]);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">palaces</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">surroundedPalaces</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;命宮&quot;</span><span style="color:#24292E;">);</span></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">result</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> palaces.</span><span style="color:#6F42C1;">notHave</span><span style="color:#24292E;">([</span><span style="color:#032F62;">&quot;地空&quot;</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;地劫&quot;</span><span style="color:#24292E;">]);</span></span></code></pre></div><p>當然妳也可以使用 <code>鏈式調用</code> 來簡化代碼</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">result</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">surroundedPalaces</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;命宮&quot;</span><span style="color:#E1E4E8;">).</span><span style="color:#B392F0;">notHave</span><span style="color:#E1E4E8;">([</span><span style="color:#9ECBFF;">&quot;地空&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;地劫&quot;</span><span style="color:#E1E4E8;">]);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">result</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">surroundedPalaces</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;命宮&quot;</span><span style="color:#24292E;">).</span><span style="color:#6F42C1;">notHave</span><span style="color:#24292E;">([</span><span style="color:#032F62;">&quot;地空&quot;</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;地劫&quot;</span><span style="color:#24292E;">]);</span></span></code></pre></div></li></ul><hr><h5 id="haveoneof" tabindex="-1">haveOneOf() <a class="header-anchor" href="#haveoneof" aria-label="Permalink to &quot;haveOneOf()&quot;">​</a></h5><ul><li><p>用途</p><p>判斷某個宮位的三方四正內是否有傳入 <code>星耀</code> 的其中壹個，隻要 <code>命中壹個</code> 就會返回 <code>true</code></p></li><li><p>定義</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">type</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">haveOneOf</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> (</span><span style="color:#FFAB70;">stars</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">StarName</span><span style="color:#E1E4E8;">[]) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;">;</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">type</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">haveOneOf</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> (</span><span style="color:#E36209;">stars</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">StarName</span><span style="color:#24292E;">[]) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;">;</span></span></code></pre></div></li><li><p>參數</p><table><thead><tr><th>參數</th><th>類型</th><th>是否必填</th><th>默認值</th><th>說明</th></tr></thead><tbody><tr><td>stars</td><td><a href="./../type-definition.html#starname"><code>StarName[]</code></a></td><td><code>true</code></td><td>-</td><td>星耀名稱，可以包含主星、輔星、雜耀</td></tr></tbody></table></li><li><p>返回值</p><p><code>boolean</code></p></li><li><p>示例</p><p>如果妳想查看 <code>命宮</code> 三方四正是否有 <code>天魁星</code> 或 <code>天鉞星</code></p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">palaces</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">surroundedPalaces</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;命宮&quot;</span><span style="color:#E1E4E8;">);</span></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">result</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> palaces.</span><span style="color:#B392F0;">haveOneOf</span><span style="color:#E1E4E8;">([</span><span style="color:#9ECBFF;">&quot;天魁&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;天鉞&quot;</span><span style="color:#E1E4E8;">]);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">palaces</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">surroundedPalaces</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;命宮&quot;</span><span style="color:#24292E;">);</span></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">result</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> palaces.</span><span style="color:#6F42C1;">haveOneOf</span><span style="color:#24292E;">([</span><span style="color:#032F62;">&quot;天魁&quot;</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;天鉞&quot;</span><span style="color:#24292E;">]);</span></span></code></pre></div><p>當然妳也可以使用 <code>鏈式調用</code> 來簡化代碼</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">result</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">surroundedPalaces</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;命宮&quot;</span><span style="color:#E1E4E8;">).</span><span style="color:#B392F0;">haveOneOf</span><span style="color:#E1E4E8;">([</span><span style="color:#9ECBFF;">&quot;天魁&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;天鉞&quot;</span><span style="color:#E1E4E8;">]);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">result</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">surroundedPalaces</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;命宮&quot;</span><span style="color:#24292E;">).</span><span style="color:#6F42C1;">haveOneOf</span><span style="color:#24292E;">([</span><span style="color:#032F62;">&quot;天魁&quot;</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;天鉞&quot;</span><span style="color:#24292E;">]);</span></span></code></pre></div></li></ul><hr><h5 id="havemutagen" tabindex="-1">haveMutagen() <a class="header-anchor" href="#havemutagen" aria-label="Permalink to &quot;haveMutagen()&quot;">​</a></h5><ul><li><p>用途</p><p>判斷宮位三方四正內是否有生年四化</p></li><li><p>定義</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">type</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">haveMutagen</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> (</span><span style="color:#FFAB70;">mutagen</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">Mutagen</span><span style="color:#E1E4E8;">) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;">;</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">type</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">haveMutagen</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> (</span><span style="color:#E36209;">mutagen</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">Mutagen</span><span style="color:#24292E;">) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;">;</span></span></code></pre></div></li><li><p>參數</p><table><thead><tr><th>參數</th><th>類型</th><th>是否必填</th><th>默認值</th><th>說明</th></tr></thead><tbody><tr><td>mutagen</td><td><a href="./../type-definition.html#mutagen"><code>Mutagen</code></a></td><td><code>true</code></td><td>-</td><td>四化名稱【祿｜權｜科｜忌】</td></tr></tbody></table></li><li><p>返回值</p><p><code>boolean</code></p></li><li><p>示例</p><p>如果妳想查看 <code>命宮</code> 三方四正是否有 <code>化祿</code></p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">palaces</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">surroundedPalaces</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;命宮&quot;</span><span style="color:#E1E4E8;">);</span></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">result</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> palaces.</span><span style="color:#B392F0;">haveMutagen</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;祿&quot;</span><span style="color:#E1E4E8;">);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">palaces</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">surroundedPalaces</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;命宮&quot;</span><span style="color:#24292E;">);</span></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">result</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> palaces.</span><span style="color:#6F42C1;">haveMutagen</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;祿&quot;</span><span style="color:#24292E;">);</span></span></code></pre></div><p>當然妳也可以使用 <code>鏈式調用</code> 來簡化代碼</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">result</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">surroundedPalaces</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;命宮&quot;</span><span style="color:#E1E4E8;">).</span><span style="color:#B392F0;">haveMutagen</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;祿&quot;</span><span style="color:#E1E4E8;">);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">result</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">surroundedPalaces</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;命宮&quot;</span><span style="color:#24292E;">).</span><span style="color:#6F42C1;">haveMutagen</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;祿&quot;</span><span style="color:#24292E;">);</span></span></code></pre></div></li></ul><hr><h5 id="nothavemutagen-1" tabindex="-1">notHaveMutagen() <a class="header-anchor" href="#nothavemutagen-1" aria-label="Permalink to &quot;notHaveMutagen()&quot;">​</a></h5><ul><li><p>用途</p><p>判斷宮位三方四正內是否沒有生年四化</p></li><li><p>定義</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">type</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">notHaveMutagen</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> (</span><span style="color:#FFAB70;">mutagen</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">Mutagen</span><span style="color:#E1E4E8;">) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;">;</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">type</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">notHaveMutagen</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> (</span><span style="color:#E36209;">mutagen</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">Mutagen</span><span style="color:#24292E;">) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;">;</span></span></code></pre></div></li><li><p>參數</p><table><thead><tr><th>參數</th><th>類型</th><th>是否必填</th><th>默認值</th><th>說明</th></tr></thead><tbody><tr><td>mutagen</td><td><a href="./../type-definition.html#mutagen"><code>Mutagen</code></a></td><td><code>true</code></td><td>-</td><td>四化名稱【祿｜權｜科｜忌】</td></tr></tbody></table></li><li><p>返回值</p><p><code>boolean</code></p></li><li><p>示例</p><p>如果妳想查看 <code>命宮</code> 三方四正是不是沒有 <code>化忌</code></p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">palace</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">surroundedPalaces</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;命宮&quot;</span><span style="color:#E1E4E8;">);</span></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">result</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> palace.</span><span style="color:#B392F0;">notHaveMutagen</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;忌&quot;</span><span style="color:#E1E4E8;">);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">palace</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">surroundedPalaces</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;命宮&quot;</span><span style="color:#24292E;">);</span></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">result</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> palace.</span><span style="color:#6F42C1;">notHaveMutagen</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;忌&quot;</span><span style="color:#24292E;">);</span></span></code></pre></div><p>當然妳也可以使用 <code>鏈式調用</code> 來簡化代碼</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">result</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">surroundedPalaces</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;命宮&quot;</span><span style="color:#E1E4E8;">).</span><span style="color:#B392F0;">notHaveMutagen</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;忌&quot;</span><span style="color:#E1E4E8;">);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">result</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">surroundedPalaces</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;命宮&quot;</span><span style="color:#24292E;">).</span><span style="color:#6F42C1;">notHaveMutagen</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;忌&quot;</span><span style="color:#24292E;">);</span></span></code></pre></div></li></ul></li></ul>`,3);function O(I,V,w,z,R,$){const o=e("Badge");return t(),c("div",null,[y,l(o,{type:"tip",text:"implements"}),a(),E,a(),l(o,{type:"tip",text:"extends"}),a(),d,i,s("ul",null,[u,s("li",null,[F,s("h5",h,[a("has() "),l(o,{type:"warning",text:"^1.0.0"}),a(),g]),C,s("h5",b,[a("notHave() "),l(o,{type:"warning",text:"^1.0.0"}),a(),v]),q,s("h5",B,[a("hasOneOf() "),l(o,{type:"warning",text:"^1.0.0"}),a(),A]),k,s("h5",_,[a("hasMutagen() "),l(o,{type:"warning",text:"^1.2.0"}),a(),D]),m,s("h5",f,[a("notHaveMutagen() "),l(o,{type:"warning",text:"^1.2.0"}),a(),P]),S])]),s("h4",M,[a("FunctionalSurpalaces "),l(o,{type:"warning",text:"^1.2.0"}),a(),T]),N,l(o,{type:"tip",text:"implements"}),a(),x,a(),l(o,{type:"tip",text:"extends"}),a(),H])}const Q=p(r,[["render",O]]);export{J as __pageData,Q as default};
