import{_ as p,C as t,o as e,c,k as a,a as s,H as o,Q as l}from"./chunks/framework.f0e9ff50.js";const m=JSON.parse('{"title":"星耀","description":"iztro紫微鬥數星耀介紹，iztro的star對象使用方法以及示例代碼。","frontmatter":{"outline":"deep","description":"iztro紫微鬥數星耀介紹，iztro的star對象使用方法以及示例代碼。"},"headers":[],"relativePath":"zh_TW/posts/star.md","filePath":"zh_TW/posts/star.md"}'),r={name:"zh_TW/posts/star.md"},y=l('<h1 id="星耀" tabindex="-1">星耀 <a class="header-anchor" href="#星耀" aria-label="Permalink to &quot;星耀&quot;">​</a></h1><h3 id="概述" tabindex="-1">概述 <a class="header-anchor" href="#概述" aria-label="Permalink to &quot;概述&quot;">​</a></h3><p>星耀是紫微鬥數裏的重要組成部分，人的個性主要收到星耀的影響。不同的星耀組合形成了不同的個性，如果妳對星耀部分感興趣，我們強烈建議妳點擊 <a href="/learn/star.html">傳送門</a> 進行相關知識學習。本篇主要關註的是開發層面。</p><div class="tip custom-block"><p class="custom-block-title">提示</p><p>在 <code>iztro</code> 裏，<code>主星</code>、<code>輔星</code>、<code>雜耀</code> 都被統歸到星耀係統裏，但是 <code>48神煞</code> 沒有被歸類到星耀，如果妳還不知道 <code>48神煞</code> 是什麽，歡迎點擊 <a href="/learn/dec-star.html">傳送門</a> 進行學習。</p></div><h3 id="功能類定義" tabindex="-1">功能類定義 <a class="header-anchor" href="#功能類定義" aria-label="Permalink to &quot;功能類定義&quot;">​</a></h3><p>與 <a href="./astrolabe.html#functionalastrolabe">FunctionalAstrolabe</a> 和 <a href="./palace.html#functionalpalace">FunctionalPalace</a> 壹樣，我們並不建議妳手動去創建壹個 <code>FunctionalStar</code> 對象，而是使用其他對象返回的實例。</p>',6),E={id:"functionalstar",tabindex:"-1"},i=a("a",{class:"header-anchor",href:"#functionalstar","aria-label":'Permalink to "FunctionalStar <Badge type="warning" text="^1.2.0" />"'},"​",-1),d=a("hr",null,null,-1),F=a("code",null,"IFunctionalStar",-1),u=l(`<a href="/type-definition.html#star"><code>Star</code></a><ul><li><p>接口定義</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">interface</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">IFunctionalStar</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">extends</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">Star</span><span style="color:#E1E4E8;"> {</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#B392F0;">palace</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> () </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">IFunctionalPalace</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">|</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">undefined</span><span style="color:#E1E4E8;">;</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#B392F0;">setPalace</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> (</span><span style="color:#FFAB70;">p</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">IFunctionalPalace</span><span style="color:#E1E4E8;">) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">void</span><span style="color:#E1E4E8;">;</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#B392F0;">setAstrolabe</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> (</span><span style="color:#FFAB70;">a</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">IFunctionalAstrolabe</span><span style="color:#E1E4E8;">) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">void</span><span style="color:#E1E4E8;">;</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#B392F0;">surroundedPalaces</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> () </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">IFunctionalSurpalaces</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">|</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">undefined</span><span style="color:#E1E4E8;">;</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#B392F0;">oppositePalace</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> () </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">IFunctionalPalace</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">|</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">undefined</span><span style="color:#E1E4E8;">;</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#B392F0;">withBrightness</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> (</span><span style="color:#FFAB70;">brightness</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">Brightness</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">|</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">Brightness</span><span style="color:#E1E4E8;">[]) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;">;</span></span>
<span class="line"><span style="color:#E1E4E8;">  </span><span style="color:#B392F0;">withMutagen</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> (</span><span style="color:#FFAB70;">mutagen</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">Mutagen</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">|</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">Mutagen</span><span style="color:#E1E4E8;">[]) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;">;</span></span>
<span class="line"><span style="color:#E1E4E8;">}</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">interface</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">IFunctionalStar</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">extends</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">Star</span><span style="color:#24292E;"> {</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6F42C1;">palace</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> () </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">IFunctionalPalace</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">|</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">undefined</span><span style="color:#24292E;">;</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6F42C1;">setPalace</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> (</span><span style="color:#E36209;">p</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">IFunctionalPalace</span><span style="color:#24292E;">) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">void</span><span style="color:#24292E;">;</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6F42C1;">setAstrolabe</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> (</span><span style="color:#E36209;">a</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">IFunctionalAstrolabe</span><span style="color:#24292E;">) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">void</span><span style="color:#24292E;">;</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6F42C1;">surroundedPalaces</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> () </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">IFunctionalSurpalaces</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">|</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">undefined</span><span style="color:#24292E;">;</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6F42C1;">oppositePalace</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> () </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">IFunctionalPalace</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">|</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">undefined</span><span style="color:#24292E;">;</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6F42C1;">withBrightness</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> (</span><span style="color:#E36209;">brightness</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">Brightness</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">|</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">Brightness</span><span style="color:#24292E;">[]) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;">;</span></span>
<span class="line"><span style="color:#24292E;">  </span><span style="color:#6F42C1;">withMutagen</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> (</span><span style="color:#E36209;">mutagen</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">Mutagen</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">|</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">Mutagen</span><span style="color:#24292E;">[]) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;">;</span></span>
<span class="line"><span style="color:#24292E;">}</span></span></code></pre></div></li><li><p>屬性</p><p>參考 <a href="/type-definition.html#star">Star</a></p></li><li><p>方法</p><div class="danger custom-block"><p class="custom-block-title">❗️註意</p><p>為了使 <code>FunctionalStar</code> 類使用起來更順暢，所以引入了 <code>setPalace()</code> 和 <code>setAstrolabe()</code> 兩個方法，但實際使用過程中請不要手動去調用這兩個方法，以免造成數據錯誤。</p></div><h5 id="palace" tabindex="-1">palace() <a class="header-anchor" href="#palace" aria-label="Permalink to &quot;palace()&quot;">​</a></h5><ul><li><p>用途</p><p>獲取星耀所在宮位</p></li><li><p>定義</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">type</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">palace</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> () </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">IFunctionalPalace</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">|</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">undefined</span><span style="color:#E1E4E8;">;</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">type</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">palace</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> () </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">IFunctionalPalace</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">|</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">undefined</span><span style="color:#24292E;">;</span></span></code></pre></div></li><li><p>參數</p><p><code>none</code></p></li><li><p>返回值</p><p><a href="./palace.html#functionalpalace"><code>FunctionalPalace</code></a> | <code>undefined</code></p></li><li><p>示例</p><p>獲取 <code>紫微星</code> 所在的宮位</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">import</span><span style="color:#E1E4E8;"> { astro } </span><span style="color:#F97583;">from</span><span style="color:#E1E4E8;"> </span><span style="color:#9ECBFF;">&quot;iztro&quot;</span><span style="color:#E1E4E8;">;</span></span>
<span class="line"></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">astrolabe</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astro.</span><span style="color:#B392F0;">astrolabeBySolarDate</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;2000-8-16&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">2</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;女&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">true</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;zh-CN&quot;</span><span style="color:#E1E4E8;">);</span></span>
<span class="line"></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">palace</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">star</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;紫微星&quot;</span><span style="color:#E1E4E8;">).</span><span style="color:#B392F0;">palece</span><span style="color:#E1E4E8;">();</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">import</span><span style="color:#24292E;"> { astro } </span><span style="color:#D73A49;">from</span><span style="color:#24292E;"> </span><span style="color:#032F62;">&quot;iztro&quot;</span><span style="color:#24292E;">;</span></span>
<span class="line"></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">astrolabe</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astro.</span><span style="color:#6F42C1;">astrolabeBySolarDate</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;2000-8-16&quot;</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">2</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;女&quot;</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">true</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;zh-CN&quot;</span><span style="color:#24292E;">);</span></span>
<span class="line"></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">palace</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">star</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;紫微星&quot;</span><span style="color:#24292E;">).</span><span style="color:#6F42C1;">palece</span><span style="color:#24292E;">();</span></span></code></pre></div></li></ul><hr><h5 id="surroundedpalaces" tabindex="-1">surroundedPalaces() <a class="header-anchor" href="#surroundedpalaces" aria-label="Permalink to &quot;surroundedPalaces()&quot;">​</a></h5><ul><li><p>用途</p><p>獲取當前星耀的三方四正宮位</p></li><li><p>定義</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">type</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">surroundedPalaces</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> () </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">IFunctionalSurpalaces</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">|</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">undefined</span><span style="color:#E1E4E8;">;</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">type</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">surroundedPalaces</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> () </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">IFunctionalSurpalaces</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">|</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">undefined</span><span style="color:#24292E;">;</span></span></code></pre></div></li><li><p>參數</p><p><code>none</code></p></li><li><p>返回值</p><p><a href="./palace.html#functionalsurpalaces"><code>FunctionalSurpalaces</code></a> | <code>undefined</code></p></li><li><p>示例</p><p>獲取 <code>紫微星</code> 的 <code>三方四正</code> 宮位</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">import</span><span style="color:#E1E4E8;"> { astro } </span><span style="color:#F97583;">from</span><span style="color:#E1E4E8;"> </span><span style="color:#9ECBFF;">&quot;iztro&quot;</span><span style="color:#E1E4E8;">;</span></span>
<span class="line"></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">astrolabe</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astro.</span><span style="color:#B392F0;">astrolabeBySolarDate</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;2000-8-16&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">2</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;女&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">true</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;zh-CN&quot;</span><span style="color:#E1E4E8;">);</span></span>
<span class="line"></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">palaces</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">star</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;紫微星&quot;</span><span style="color:#E1E4E8;">).</span><span style="color:#B392F0;">surroundedPalaces</span><span style="color:#E1E4E8;">();</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">import</span><span style="color:#24292E;"> { astro } </span><span style="color:#D73A49;">from</span><span style="color:#24292E;"> </span><span style="color:#032F62;">&quot;iztro&quot;</span><span style="color:#24292E;">;</span></span>
<span class="line"></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">astrolabe</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astro.</span><span style="color:#6F42C1;">astrolabeBySolarDate</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;2000-8-16&quot;</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">2</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;女&quot;</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">true</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;zh-CN&quot;</span><span style="color:#24292E;">);</span></span>
<span class="line"></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">palaces</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">star</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;紫微星&quot;</span><span style="color:#24292E;">).</span><span style="color:#6F42C1;">surroundedPalaces</span><span style="color:#24292E;">();</span></span></code></pre></div></li></ul><hr><h5 id="oppositepalace" tabindex="-1">oppositePalace() <a class="header-anchor" href="#oppositepalace" aria-label="Permalink to &quot;oppositePalace()&quot;">​</a></h5><ul><li><p>用途</p><p>獲取當前星耀的對宮</p></li><li><p>定義</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">type</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">oppositePalace</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> () </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">IFunctionalPalace</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">|</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">undefined</span><span style="color:#E1E4E8;">;</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">type</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">oppositePalace</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> () </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">IFunctionalPalace</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">|</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">undefined</span><span style="color:#24292E;">;</span></span></code></pre></div></li><li><p>參數</p><p><code>none</code></p></li><li><p>返回值</p><p><a href="./palace.html#functionalpalace"><code>FunctionalPalace</code></a> | <code>undefined</code></p></li><li><p>示例</p><p>獲取 <code>紫微星</code> 的 <code>對宮</code></p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">import</span><span style="color:#E1E4E8;"> { astro } </span><span style="color:#F97583;">from</span><span style="color:#E1E4E8;"> </span><span style="color:#9ECBFF;">&quot;iztro&quot;</span><span style="color:#E1E4E8;">;</span></span>
<span class="line"></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">astrolabe</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astro.</span><span style="color:#B392F0;">astrolabeBySolarDate</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;2000-8-16&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">2</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;女&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">true</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;zh-CN&quot;</span><span style="color:#E1E4E8;">);</span></span>
<span class="line"></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">palace</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">star</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;紫微星&quot;</span><span style="color:#E1E4E8;">).</span><span style="color:#B392F0;">oppositePalace</span><span style="color:#E1E4E8;">();</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">import</span><span style="color:#24292E;"> { astro } </span><span style="color:#D73A49;">from</span><span style="color:#24292E;"> </span><span style="color:#032F62;">&quot;iztro&quot;</span><span style="color:#24292E;">;</span></span>
<span class="line"></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">astrolabe</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astro.</span><span style="color:#6F42C1;">astrolabeBySolarDate</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;2000-8-16&quot;</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">2</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;女&quot;</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">true</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;zh-CN&quot;</span><span style="color:#24292E;">);</span></span>
<span class="line"></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">palace</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">star</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;紫微星&quot;</span><span style="color:#24292E;">).</span><span style="color:#6F42C1;">oppositePalace</span><span style="color:#24292E;">();</span></span></code></pre></div></li></ul><hr><h5 id="withbrightness" tabindex="-1">withBrightness() <a class="header-anchor" href="#withbrightness" aria-label="Permalink to &quot;withBrightness()&quot;">​</a></h5><ul><li><p>用途</p><p>判斷星耀是否是傳入的亮度，也可以傳入多個亮度，隻要匹配到壹個亮度就會返回 <code>true</code></p></li><li><p>定義</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">type</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">withBrightness</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> (</span><span style="color:#FFAB70;">brightness</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">Brightness</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">|</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">Brightness</span><span style="color:#E1E4E8;">[]) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;">;</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">type</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">withBrightness</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> (</span><span style="color:#E36209;">brightness</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">Brightness</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">|</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">Brightness</span><span style="color:#24292E;">[]) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;">;</span></span></code></pre></div></li><li><p>參數</p></li></ul><table><thead><tr><th>參數</th><th>類型</th><th>是否必填</th><th>默認值</th><th>說明</th></tr></thead><tbody><tr><td>brightness</td><td><a href="/type-definition.html#brightness"><code>Brightness</code></a> | <a href="./(/type-definition.html#brightness)"><code>Brightness[]</code></a></td><td><code>true</code></td><td>-</td><td>需要判斷的星耀亮度</td></tr></tbody></table><ul><li><p>返回值</p><p><code>boolean</code></p></li><li><p>示例</p><p>判斷 <code>紫微星</code> 是否處於 <code>廟</code> 或者 <code>旺</code> 的狀態</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">import</span><span style="color:#E1E4E8;"> { astro } </span><span style="color:#F97583;">from</span><span style="color:#E1E4E8;"> </span><span style="color:#9ECBFF;">&quot;iztro&quot;</span><span style="color:#E1E4E8;">;</span></span>
<span class="line"></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">astrolabe</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astro.</span><span style="color:#B392F0;">astrolabeBySolarDate</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;2000-8-16&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">2</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;女&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">true</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;zh-CN&quot;</span><span style="color:#E1E4E8;">);</span></span>
<span class="line"></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">result</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">star</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;紫微星&quot;</span><span style="color:#E1E4E8;">).</span><span style="color:#B392F0;">withBrightness</span><span style="color:#E1E4E8;">([</span><span style="color:#9ECBFF;">&quot;廟&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;旺&quot;</span><span style="color:#E1E4E8;">]);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">import</span><span style="color:#24292E;"> { astro } </span><span style="color:#D73A49;">from</span><span style="color:#24292E;"> </span><span style="color:#032F62;">&quot;iztro&quot;</span><span style="color:#24292E;">;</span></span>
<span class="line"></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">astrolabe</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astro.</span><span style="color:#6F42C1;">astrolabeBySolarDate</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;2000-8-16&quot;</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">2</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;女&quot;</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">true</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;zh-CN&quot;</span><span style="color:#24292E;">);</span></span>
<span class="line"></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">result</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">star</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;紫微星&quot;</span><span style="color:#24292E;">).</span><span style="color:#6F42C1;">withBrightness</span><span style="color:#24292E;">([</span><span style="color:#032F62;">&quot;廟&quot;</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;旺&quot;</span><span style="color:#24292E;">]);</span></span></code></pre></div></li></ul><hr><h5 id="withmutagen" tabindex="-1">withMutagen() <a class="header-anchor" href="#withmutagen" aria-label="Permalink to &quot;withMutagen()&quot;">​</a></h5><ul><li><p>用途</p><p>判斷星耀是否產生了四化，也可以傳入多個四化進行判斷，隻要匹配到壹個亮度就會返回 <code>true</code></p></li><li><p>定義</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">type</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">withMutagen</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> (</span><span style="color:#FFAB70;">mutagen</span><span style="color:#F97583;">:</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">Mutagen</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">|</span><span style="color:#E1E4E8;"> </span><span style="color:#B392F0;">Mutagen</span><span style="color:#E1E4E8;">[]) </span><span style="color:#F97583;">=&gt;</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">boolean</span><span style="color:#E1E4E8;">;</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">type</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">withMutagen</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> (</span><span style="color:#E36209;">mutagen</span><span style="color:#D73A49;">:</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">Mutagen</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">|</span><span style="color:#24292E;"> </span><span style="color:#6F42C1;">Mutagen</span><span style="color:#24292E;">[]) </span><span style="color:#D73A49;">=&gt;</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">boolean</span><span style="color:#24292E;">;</span></span></code></pre></div></li><li><p>參數</p></li></ul><table><thead><tr><th>參數</th><th>類型</th><th>是否必填</th><th>默認值</th><th>說明</th></tr></thead><tbody><tr><td>mutagen</td><td><a href="/type-definition.html#mutagen"><code>Mutagen</code></a> | <a href="./(/type-definition.html#mutagen)"><code>Mutagen[]</code></a></td><td><code>true</code></td><td>-</td><td>四化【祿｜權｜科｜忌】</td></tr></tbody></table><ul><li><p>返回值</p><p><code>boolean</code></p></li><li><p>示例</p><p>判斷 <code>紫微星</code> 是否處於 <code>化權</code> 或者 <code>華科</code> 的狀態</p><div class="language-ts vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ts</span><pre class="shiki github-dark vp-code-dark"><code><span class="line"><span style="color:#F97583;">import</span><span style="color:#E1E4E8;"> { astro } </span><span style="color:#F97583;">from</span><span style="color:#E1E4E8;"> </span><span style="color:#9ECBFF;">&quot;iztro&quot;</span><span style="color:#E1E4E8;">;</span></span>
<span class="line"></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">astrolabe</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astro.</span><span style="color:#B392F0;">astrolabeBySolarDate</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;2000-8-16&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">2</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;女&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#79B8FF;">true</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;zh-CN&quot;</span><span style="color:#E1E4E8;">);</span></span>
<span class="line"></span>
<span class="line"><span style="color:#F97583;">const</span><span style="color:#E1E4E8;"> </span><span style="color:#79B8FF;">result</span><span style="color:#E1E4E8;"> </span><span style="color:#F97583;">=</span><span style="color:#E1E4E8;"> astrolabe.</span><span style="color:#B392F0;">star</span><span style="color:#E1E4E8;">(</span><span style="color:#9ECBFF;">&quot;紫微星&quot;</span><span style="color:#E1E4E8;">).</span><span style="color:#B392F0;">withMutagen</span><span style="color:#E1E4E8;">([</span><span style="color:#9ECBFF;">&quot;權&quot;</span><span style="color:#E1E4E8;">, </span><span style="color:#9ECBFF;">&quot;科&quot;</span><span style="color:#E1E4E8;">]);</span></span></code></pre><pre class="shiki github-light vp-code-light"><code><span class="line"><span style="color:#D73A49;">import</span><span style="color:#24292E;"> { astro } </span><span style="color:#D73A49;">from</span><span style="color:#24292E;"> </span><span style="color:#032F62;">&quot;iztro&quot;</span><span style="color:#24292E;">;</span></span>
<span class="line"></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">astrolabe</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astro.</span><span style="color:#6F42C1;">astrolabeBySolarDate</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;2000-8-16&quot;</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">2</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;女&quot;</span><span style="color:#24292E;">, </span><span style="color:#005CC5;">true</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;zh-CN&quot;</span><span style="color:#24292E;">);</span></span>
<span class="line"></span>
<span class="line"><span style="color:#D73A49;">const</span><span style="color:#24292E;"> </span><span style="color:#005CC5;">result</span><span style="color:#24292E;"> </span><span style="color:#D73A49;">=</span><span style="color:#24292E;"> astrolabe.</span><span style="color:#6F42C1;">star</span><span style="color:#24292E;">(</span><span style="color:#032F62;">&quot;紫微星&quot;</span><span style="color:#24292E;">).</span><span style="color:#6F42C1;">withMutagen</span><span style="color:#24292E;">([</span><span style="color:#032F62;">&quot;權&quot;</span><span style="color:#24292E;">, </span><span style="color:#032F62;">&quot;科&quot;</span><span style="color:#24292E;">]);</span></span></code></pre></div></li></ul></li></ul>`,2);function h(C,g,B,q,b,A){const n=t("Badge");return e(),c("div",null,[y,a("h4",E,[s("FunctionalStar "),o(n,{type:"warning",text:"^1.2.0"}),s(),i]),d,o(n,{type:"tip",text:"implements"}),s(),F,s(),o(n,{type:"tip",text:"extends"}),s(),u])}const v=p(r,[["render",h]]);export{m as __pageData,v as default};
