/**
 * 公历每个月份的天数普通表
 * 1，3，5，7，8，10，12月为 31 天
 * 2月为28天，若闰年会在获取天数时+1天
 * 其余月份为30天
 */
export const SOLAR_MONTH = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31] as const;

/**
 * 24节气速查表
 */
export const SOLAR_STEM = [
  '小寒',
  '大寒',
  '立春',
  '雨水',
  '惊蛰',
  '春分',
  '清明',
  '谷雨',
  '立夏',
  '小满',
  '芒种',
  '夏至',
  '小暑',
  '大暑',
  '立秋',
  '处暑',
  '白露',
  '秋分',
  '寒露',
  '霜降',
  '立冬',
  '小雪',
  '大雪',
  '冬至',
] as const;

/**
 * 数字转中文速查表
 * 1. 星期取值范围从0～6，表示星期日到星期六
 * 2. 日期取值范围从1～10
 */
export const NUM_TO_CHAR = ['日', '一', '二', '三', '四', '五', '六', '七', '八', '九', '十'] as const;

/**
 * 日期转农历称呼速查表
 * 1. 将7日显示为 初七
 * 2. 将13日显示为 十三
 * 3. 将24日显示为 廿四
 * 4. 将31日显示为 卅一
 */
export const LUNAR_DAY_NAME = ['初', '十', '廿', '卅'] as const;

/**
 * 月份转农历称呼速查表
 * 1. 1月显示为正月
 * 2. 11月显示为冬月
 * 3. 12月显示为腊月
 * 4. 其他情况显示大写数字+月份
 */
export const LUNAR_MONTH_NAME = ['', '正', '二', '三', '四', '五', '六', '七', '八', '九', '十', '冬', '腊'] as const;
