// Code generated by go generate; DO NOT EDIT.
// This file was generated at
// 2021-01-30 11:07:14.593507 -0800 PST m=+0.001205313
package chat

import (
	"github.com/inklabs/rangedb"
	"github.com/inklabs/rangedb/pkg/cqrs"
)

func (a *room) Load(recordIterator rangedb.RecordIterator) {
	for recordIterator.Next() {
		if recordIterator.Err() == nil {
			if event, ok := recordIterator.Record().Data.(rangedb.Event); ok {
				a.apply(event)
			}
		}
	}
}

func (a *room) Handle(command cqrs.Command) []rangedb.Event {
	switch c := command.(type) {
	case OnBoardRoom:
		a.OnBoardRoom(c)

	case JoinRoom:
		a.JoinRoom(c)

	case SendMessageToRoom:
		a.SendMessageToRoom(c)

	case SendPrivateMessageToRoom:
		a.SendPrivateMessageToRoom(c)

	case RemoveUserFromRoom:
		a.RemoveUserFromRoom(c)

	case BanUserFromRoom:
		a.BanUserFromRoom(c)

	}

	defer a.resetPendingEvents()
	return a.pendingEvents
}

func (a *room) resetPendingEvents() {
	a.pendingEvents = nil
}

func (a *room) CommandTypes() []string {
	return []string{
		OnBoardRoom{}.CommandType(),
		JoinRoom{}.CommandType(),
		SendMessageToRoom{}.CommandType(),
		SendPrivateMessageToRoom{}.CommandType(),
		RemoveUserFromRoom{}.CommandType(),
		BanUserFromRoom{}.CommandType(),
	}
}

func (a *room) raise(events ...rangedb.Event) {
	a.pendingEvents = append(a.pendingEvents, events...)
}
