package commandgenerator

import (
	"fmt"
	"io"
	"text/template"
	"time"
)

var NowFunc = time.Now

func Write(out io.Writer, commands []string, pkg, id, aggregateType string) error {
	if len(commands) < 1 {
		return fmt.Errorf("no commands found")
	}

	return fileTemplate.Execute(out, templateData{
		Timestamp:     NowFunc(),
		Commands:      commands,
		AggregateType: aggregateType,
		ID:            id,
		Package:       pkg,
	})
}

type templateData struct {
	Timestamp     time.Time
	Commands      []string
	AggregateType string
	ID            string
	Package       string
}

var fileTemplate = template.Must(template.New("").Parse(`// Code generated by go generate; DO NOT EDIT.
// This file was generated at
// {{ .Timestamp }}
package {{ $.Package }}

{{- range .Commands }}

func (c {{ . }}) AggregateID() string   { return c.{{ $.ID }} }
func (c {{ . }}) AggregateType() string { return "{{ $.AggregateType }}" }
func (c {{ . }}) CommandType() string   { return "{{ . }}" }
{{- end }}
`))
