# Release Notes

## Microsoft.Data.SqlClient 1.0.19128.1 Preview released 8 May 2019

This update adds the Always Encrypted APIs to the reference layer, exposing them appropriately based on the application target. No other fixes or changes were made in this preview from the previous preview.

### Target Platform Support

* .NET Framework 4.6+ (x64 only)
* .NET Core 2.1+ (Windows x86, Windows x64, Linux, macOS)
* .NET Standard 2.0+ (Windows x86, Windows x64, Linux, macOS)

### Dependencies

#### .NET Framework

* System.Data.Common 4.3.0

#### .NET Core

* Microsoft.Win32.Registry 4.5.0
* runtime.native.System.Data.SqlClient.sni 4.4.0
* System.Security.Principal.Windows 4.5.0
* System.Text.Encoding.CodePages 4.5.0
* System.Configuration.ConfigurationManager 4.5.0

#### .NET Standard

* Microsoft.Win32.Registry 4.5.0
* runtime.native.System.Data.SqlClient.sni 4.4.0
* System.Buffers 4.4.0
* System.Diagnostics.DiagnosticSource 4.5.0
* System.Memory 4.5.1
* System.Security.Principal.Windows 4.5.0
* System.Text.Encoding.CodePages 4.5.0
* System.Configuration.ConfigurationManager 4.5.0

### New Features

New features over .NET Framework 4.7.2 System.Data.SqlClient.

* [Data Classification](#data-classification) - Available in Azure SQL Database and Microsoft SQL Server 2019 since CTP 2.0.
* [UTF-8 support](#utf-8-support) - Available in Microsoft SQL Server SQL Server 2019 since CTP 2.3.

New features over .NET Core 2.2 System.Data.SqlClient.

* [Data Classification](#data-classification) - Available in Azure SQL Database and Microsoft SQL Server 2019 since CTP 2.0.
* [UTF-8 support](#utf-8-support) - Available in Microsoft SQL Server SQL Server 2019 since CTP 2.3.
* [Always Encrypted](#always-encrypted) - Always Encrypted is available in Microsoft SQL Server 2016 and higher.

### Fixed

.NET Core

* Always Encrypted APIs do not show up in Intellisense
* Fixed in 1.0.19123.2
  * XEvents are arriving as expected, but with 1 XEvent delay [CoreFx PR 36015](https://github.com/dotnet/corefx/pull/36015)
  * Fix passing null for credentials in SqlConnectionPoolKey [CoreFx PR 34268](https://github.com/dotnet/corefx/pull/34268)
  * Potential race condition in SqlConnectionString.cs [CoreFx Issue 30659](https://github.com/dotnet/corefx/issues/30650)

### Changes

.NET Core performance improvements

* Changed in 1.0.19123.2
  * Memory allocation enhancement from [CoreFx PR 34047](https://github.com/dotnet/corefx/pull/34047)
  * TdsParser performance improvement [CoreFx PR 31044](https://github.com/dotnet/corefx/pull/31044)
  * Optimize SqlClient primitive type writes [CoreFx PR 34048](https://github.com/dotnet/corefx/pull/34048)
  * Optimize SqlClient SNIPacket async paths [CoreFx PR 34184](https://github.com/dotnet/corefx/pull/34184)
  * Optimize SqlClient tds state to remove handle boxing [CoreFx PR 34044](https://github.com/dotnet/corefx/pull/34044)
  * Optimize SqlClient connection pool performance [CoreFx PR 33580](https://github.com/dotnet/corefx/pull/33580)
  * Memory optimizations [CoreFx PR 35344](https://github.com/dotnet/corefx/pull/35344)
  * Improve managed memory usage [CoreFx PR 34234](https://github.com/dotnet/corefx/pull/34234)
  * Minor memory improvements [CoreFx PR 34134](https://github.com/dotnet/corefx/pull/34134)
  * Spanify netcore guid writes [CoreFx PR 34390](https://github.com/dotnet/corefx/pull/34390)

### Known Issues

1. When targeting **.NET Framework** and platform **AnyCPU** or **x86**, you may see a build warning about processor architecture mismatch:

    *Warning There was a mismatch between the processor architecture of the project being built "MSIL" and the processor architecture of the reference "Microsoft.Data.SqlClient*...

    This is because Microsoft.Data.SqlClient targeting .NET Framework contains a native code component and native components cannot target AnyCPU. Currently x64 is the only platform supported when targeting .NET Framework. To resolve the warning, change your application to target x64. This will be resolved in a future release.

### Data Classification

Data Classification brings a new set of APIs exposing read-only Data Sensitivity and Classification information about objects retrieved via SqlDataReader when the underlying source supports the feature and contains metadata about [data sensitivity and classification](https://docs.microsoft.com/en-us/sql/relational-databases/security/sql-data-discovery-and-classification?view=sql-server-2017):

```C#
public class SqlDataReader
{
    public Microsoft.Data.SqlClient.DataClassification.SensitivityClassification SensitivityClassification
}

namespace Microsoft.Data.SqlClient.DataClassification
{
    public class ColumnSensitivity
    {
        public System.Collections.ObjectModel.ReadOnlyCollection<Microsoft.Data.SqlClient.DataClassification.SensitivityProperty> SensitivityProperties
    }
    public class InformationType
    {
        public string Id
        public string Name
    }
    public class Label
    {
        public string Id
        public string Name
    }
    public class SensitivityClassification
    {
        public System.Collections.ObjectModel.ReadOnlyCollection<Microsoft.Data.SqlClient.DataClassification.ColumnSensitivity> ColumnSensitivities
        public System.Collections.ObjectModel.ReadOnlyCollection<Microsoft.Data.SqlClient.DataClassification.InformationType> InformationTypes
        public System.Collections.ObjectModel.ReadOnlyCollection<Microsoft.Data.SqlClient.DataClassification.Label> Labels
    }
    public class SensitivityProperty
    {
        public Microsoft.Data.SqlClient.DataClassification.InformationType InformationType
        public Microsoft.Data.SqlClient.DataClassification.Label Label
    }
}
```

### UTF-8 Support

UTF-8 support does not require any application code changes. These SqlClient changes simply optimize the communication between the client and server when the server supports UTF-8 and the underlying column collation is UTF-8. See the UTF-8 section under [What's new in SQL Server 2019 preview](https://docs.microsoft.com/en-us/sql/sql-server/what-s-new-in-sql-server-ver15?view=sqlallproducts-allversions#utf-8-support-ctp-23).

### Always Encrypted

In general, existing documentation which uses System.Data.SqlClient on .NET Framework **and built-in column master key store providers** should now work with .NET Core, too.

* [Develop using Always Encrypted with .NET Framework Data Provider](https://docs.microsoft.com/en-us/sql/relational-databases/security/encryption/develop-using-always-encrypted-with-net-framework-data-provider?view=sql-server-2017)
* [Always Encrypted: Protect sensitive data and store encryption keys in the Windows certificate store](https://docs.microsoft.com/en-us/azure/sql-database/sql-database-always-encrypted)

**Notes:**

* There is no key store provider for Azure Key Vault and Microsoft.Data.SqlClient at this time.
* Always Encrypted with secure enclaves is not supported with Microsoft.Data.SqlClient.
* Always Encrypted is only supported against .NET Framework and .NET Core targets. It is not supported against .NET Standard since .NET Standard is missing certain encryption dependencies.
