# Release Notes

## Hotfix & Stable release Microsoft.Data.SqlClient 1.0.19269.1 released 26 September 2019

This update brings the below changes over the previous stable release [v1.0.19249.1](1.0.19249.1.md):

### Fixed

- `SqlCommand.StatementCompleted` event never being fired [#212](https://github.com/dotnet/SqlClient/issues/212)
- Added missing `Authentication` property to `SqlConnectionStringBuilder` reference assembly
- Reverted API changes in `SqlAuthenticationParameters` which had changed the `public string Resource` property to `public string[] Scopes`

### Target Platform Support

- .NET Framework 4.6+
- .NET Core 2.1+ (Windows x86, Windows x64, Linux, macOS)
- .NET Standard 2.0+ (Windows x86, Windows x64, Linux, macOS)

### Dependencies

#### .NET Framework

- System.Data.Common 4.3.0
- Microsoft.Data.SqlClient.SNI 1.0.19235.1
- Microsoft.Identity.Client 3.0.8

#### .NET Core

- Microsoft.Win32.Registry 4.5.0
- runtime.native.System.Data.SqlClient.sni 4.4.0
- System.Security.Principal.Windows 4.5.0
- System.Text.Encoding.CodePages 4.5.0
- System.Configuration.ConfigurationManager 4.5.0
- Microsoft.Identity.Client 3.0.8

#### .NET Standard

- Microsoft.Win32.Registry 4.5.0
- runtime.native.System.Data.SqlClient.sni 4.4.0
- System.Buffers 4.4.0
- System.Diagnostics.DiagnosticSource 4.5.0
- System.Memory 4.5.1
- System.Security.Principal.Windows 4.5.0
- System.Text.Encoding.CodePages 4.5.0
- System.Configuration.ConfigurationManager 4.5.0
- Microsoft.Identity.Client 3.0.8

### New Features

#### New features over .NET Framework 4.7.2 System.Data.SqlClient

- [Active Directory Interactive Authentication](#active-directory-interactive-authentication-(In-.net-framework)) - Applicable to Azure SQL Database and Azure Data Warehouse
- [Data Classification](#data-classification) - Available in Azure SQL Database and Microsoft SQL Server 2019 since CTP 2.0.
- [UTF-8 support](#utf-8-support) - Available in Microsoft SQL Server SQL Server 2019 since CTP 2.3.

#### New features over .NET Core 2.2 System.Data.SqlClient

- [Active Directory Password Authentication](#active-directory-password-authentication-(in-.net-core)) - Applicable to Azure SQL Database and Azure Data Warehouse
- [Data Classification](#data-classification) - Available in Azure SQL Database and Microsoft SQL Server 2019 since CTP 2.0.
- [UTF-8 support](#utf-8-support) - Available in Microsoft SQL Server SQL Server 2019 since CTP 2.3.
- [Always Encrypted](#always-encrypted) - Always Encrypted is available in Microsoft SQL Server 2016 and higher.

### Active Directory Interactive Authentication (In .NET Framework)

Microsoft.Data.SqlClient now supports "**Interactive Authentication with Azure Active Directory (AAD)**" for .NET Framework applications, also known as "*Multi-factor AAD authentication*" and "*Active Directory Universal Authentication*". Azure MFA helps safeguard access to data and applications while meeting user demand for a simple sign-in process. It delivers strong authentication with a range of easy verification options (phone call, text message, smart cards with pin, or mobile app notification), allowing users to choose the method they prefer. Interactive MFA with Azure AD can result in a pop-up dialog box for validation.

To connect to a database using Interactive Authentication mode and an Azure AD identity, the `Authentication` keyword in the database connection string must be set to `Active Directory Interactive`. An example to connect using this mode of authentication is below:

```C#
string ConnectionString =
@"Data Source=n9lxnyuzhv.database.windows.net; Authentication=Active Directory Interactive; Initial Catalog=testdb;";
using (SqlConnection conn = new SqlConnection(ConnectionString)) {
    conn.Open();
}
```

### Active Directory Password Authentication (In .NET Core)
Microsoft.Data.SqlClient now supports "**Azure Active Directory (AAD) Password Authentication**" for .NET Core applications. This authentication mode supports authentication to Azure SQL DB/DW with Azure AD for native or federated Azure AD users.

To connect to a database using AD Password Authentication mode and an Azure AD identity, the `Authentication` keyword in the database connection string must be set to `Active Directory Password` and user credentials must be provided. An example to connect using this mode of authentication is below:

```C#
string ConnectionString =
@"Data Source=n9lxnyuzhv.database.windows.net; Authentication=Active Directory Password; Initial Catalog=testdb;UID=user@domain.com;PWD=***";
using (SqlConnection conn = new SqlConnection(ConnectionString)) {
    conn.Open();
}
```

### Data Classification

Data Classification brings a new set of APIs exposing read-only Data Sensitivity and Classification information about objects retrieved via SqlDataReader when the underlying source supports the feature and contains metadata about [data sensitivity and classification](https://docs.microsoft.com/sql/relational-databases/security/sql-data-discovery-and-classification?view=sql-server-2017):

```C#
public class SqlDataReader
{
    public Microsoft.Data.SqlClient.DataClassification.SensitivityClassification SensitivityClassification
}

namespace Microsoft.Data.SqlClient.DataClassification
{
    public class ColumnSensitivity
    {
        public System.Collections.ObjectModel.ReadOnlyCollection<Microsoft.Data.SqlClient.DataClassification.SensitivityProperty> SensitivityProperties
    }
    public class InformationType
    {
        public string Id
        public string Name
    }
    public class Label
    {
        public string Id
        public string Name
    }
    public class SensitivityClassification
    {
        public System.Collections.ObjectModel.ReadOnlyCollection<Microsoft.Data.SqlClient.DataClassification.ColumnSensitivity> ColumnSensitivities
        public System.Collections.ObjectModel.ReadOnlyCollection<Microsoft.Data.SqlClient.DataClassification.InformationType> InformationTypes
        public System.Collections.ObjectModel.ReadOnlyCollection<Microsoft.Data.SqlClient.DataClassification.Label> Labels
    }
    public class SensitivityProperty
    {
        public Microsoft.Data.SqlClient.DataClassification.InformationType InformationType
        public Microsoft.Data.SqlClient.DataClassification.Label Label
    }
}
```

### UTF-8 Support

UTF-8 support does not require any application code changes. These SqlClient changes simply optimize the communication between the client and server when the server supports UTF-8 and the underlying column collation is UTF-8. See the UTF-8 section under [What's new in SQL Server 2019 preview](https://docs.microsoft.com/sql/sql-server/what-s-new-in-sql-server-ver15?view=sqlallproducts-allversions#utf-8-support-ctp-23).

### Always Encrypted

In general, existing documentation which uses System.Data.SqlClient on .NET Framework **and built-in column master key store providers** should now work with .NET Core, too.

- [Develop using Always Encrypted with .NET Framework Data Provider](https://docs.microsoft.com/sql/relational-databases/security/encryption/develop-using-always-encrypted-with-net-framework-data-provider?view=sql-server-2017)
- [Always Encrypted: Protect sensitive data and store encryption keys in the Windows certificate store](https://docs.microsoft.com/azure/sql-database/sql-database-always-encrypted)

### Known Issues

- User Data Types (UDTs) may not work with Microsoft.Data.SqlClient.

**Notes:**

- There is no key store provider for Azure Key Vault and Microsoft.Data.SqlClient at this time.
- Always Encrypted with secure enclaves is not supported with Microsoft.Data.SqlClient.
- Always Encrypted is only supported against .NET Framework and .NET Core targets. It is not supported against .NET Standard since .NET Standard is missing certain encryption dependencies.
