---
title: Introduction
---

# ::hand:: Introduction

Instrata is a desktop tool that helps you create **step-by-step visual guides** by automatically capturing screenshots and letting you edit them with ease.  
It is designed for users who want to document workflows, tutorials, or bug reports quickly without switching between multiple applications.

## ::target:: What Instrata Does

Instrata observes your screen interactions, takes screenshots at key moments, and arranges them into a visual sequence.  
You can then edit, annotate, and export these steps into structured documents.

Typical uses include:

- Creating internal training material
- Writing setup or troubleshooting guides
- Preparing QA or bug reproduction reports
- Demonstrating product features or workflows

## ::circle-question-mark:: Why Use Instrata

Instrata saves time by merging **capture, edit, and export** into one process.  
Unlike traditional screenshot tools, it focuses on clarity and consistency across your entire guide.

### Key Benefits

- **Automatic capture:** Generate screenshots as you work.
- **Quick editing:** Blur sensitive areas, highlight actions, or add text directly.
- **Structured output:** Export clean, formatted documentation ready for publication.
- **Offline and private:** No uploads or third-party dependencies required.
- **Cross-platform:** Works on ::social/windows:: Windows, ::social/linux:: Linux, and ::social/apple:: macOS.

## ::footprints:: Next Steps

- [Install Instrata](./installation) to get started
- Learn the [Usage workflow](./usage) to create your first guide
- Check the [Features list](./features) for available and planned tools
