
[//]: # (CLASS:Company)

[//]: # (KIND:object)

### Company

#### Properties

[//]: # (START_DEFINITION)

Name | Type | Description
------------ | ------------- | -------------
**id** | String | The Intrinio ID of the company &nbsp;
**ticker** | String | The stock market ticker symbol associated with the company&#39;s common stock securities &nbsp;
**name** | String | The company&#39;s common name &nbsp;
**lei** | String | The Legal Entity Identifier (LEI) assigned to the company &nbsp;
**legalName** | String | The company&#39;s official legal name &nbsp;
**stockExchange** | String | The Stock Exchange where the company&#39;s common stock is primarily traded &nbsp;
**sic** | String | The Standard Industrial Classification (SIC) determined by the company and filed with the SEC &nbsp;
**shortDescription** | String | A one or two sentence description of the company&#39;s operations &nbsp;
**longDescription** | String | A one paragraph description of the company&#39;s operations and other corporate actions &nbsp;
**ceo** | String | The Chief Executive Officer of the company &nbsp;
**companyUrl** | String | The URL of the company&#39;s primary corporate website or primary internet property &nbsp;
**businessAddress** | String | The company&#39;s business address &nbsp;
**mailingAddress** | String | The mailing address reported by the company &nbsp;
**businessPhoneNo** | String | The phone number reported by the company &nbsp;
**hqAddress1** | String | The company&#39;s headquarters address - line 1 &nbsp;
**hqAddress2** | String | The company&#39;s headquarters address - line 2 &nbsp;
**hqAddressCity** | String | The company&#39;s headquarters city &nbsp;
**hqAddressPostalCode** | String | The company&#39;s headquarters postal code &nbsp;
**entityLegalForm** | String | The company&#39;s legal organization form &nbsp;
**cik** | String | The Central Index Key (CIK) assigned to the company by the SEC as a unique identifier, used in SEC filings &nbsp;
**latestFilingDate** | [**LocalDate**](LocalDate.md) | The date of the company&#39;s last filing with the SEC &nbsp;
**hqState** | String | The state (US &amp; Canada Only) where the company headquarters are located &nbsp;
**hqCountry** | String | The country where the company headquarters are located &nbsp;
**incState** | String | The state (US &amp; Canada Only) where the company is incorporated &nbsp;
**incCountry** | String | The country where the company is incorporated &nbsp;
**employees** | Integer | The number of employees working for the company &nbsp;
**entityStatus** | String |  &nbsp;
**sector** | String | The company&#39;s operating sector &nbsp;
**industryCategory** | String | The company&#39;s operating industry category &nbsp;
**industryGroup** | String | The company&#39;s operating industry group &nbsp;
**template** | String | The financial statement template used by Intrinio to standardize the as reported data &nbsp;
**standardizedActive** | Boolean | If true, the company has standardized and as reported fundamental data via the Intrinio API; if false, the company has as-reported data only &nbsp;
**firstFundamentalDate** | [**LocalDate**](LocalDate.md) | The period end date of the company&#39;s first reported fundamental &nbsp;
**lastFundamentalDate** | [**LocalDate**](LocalDate.md) | The period end date of the company&#39;s last reported fundamental &nbsp;
**firstStockPriceDate** | [**LocalDate**](LocalDate.md) | The date of the company&#39;s first stock price, based on the company&#39;s primary security, which is typically traded on US exchages &nbsp;
**lastStockPriceDate** | [**LocalDate**](LocalDate.md) | The date of the company&#39;s last stock price, based on the company&#39;s primary security, which is typically traded on US exchages &nbsp;

[//]: # (END_DEFINITION)


[//]: # (CONTAINED_CLASS:LocalDate)


[//]: # (CONTAINED_CLASS:LocalDate)


[//]: # (CONTAINED_CLASS:LocalDate)


[//]: # (CONTAINED_CLASS:LocalDate)


[//]: # (CONTAINED_CLASS:LocalDate)





