
[//]: # (CLASS:ESGComprehensiveRatingWithCompany)

[//]: # (KIND:object)

### ESGComprehensiveRatingWithCompany

#### Properties

[//]: # (START_DEFINITION)

Name | Type | Description
------------ | ------------- | -------------
**date** | [**LocalDate**](LocalDate.md) | Indicates the date on which the ESG Rating was calculated. &nbsp;
**countryAverageRating** | [**BigDecimal**](BigDecimal.md) | The average ESG rating of all companies in a particular country in which the company is a peer of. &nbsp;
**industryAverageRating** | [**BigDecimal**](BigDecimal.md) | The average ESG rating of all companies in a particular industry in which the company is a peer of. &nbsp;
**overallRating** | [**BigDecimal**](BigDecimal.md) | The company&#39;s overall aggregated ESG rating, taking into account its ESG scoring from the Community, Employee, Enviroment, and Governance categories. &nbsp;
**communityRating** | [**BigDecimal**](BigDecimal.md) | The Community Category reflects a companys citizenship, charitable giving, and volunteerism. This category covers the company&#39;s human rights record and treatment of its supply chain. It also covers the environmental and social impacts of the companys products and services, and the development of sustainable products, processes and technologies. &nbsp;
**employeeRating** | [**BigDecimal**](BigDecimal.md) | The Employees category includes disclosure of policies, programs, and performance in diversity, labor relations and labor rights. The evaluation focuses on the quality of policies and programs, compliance with national laws and regulations, and proactive management initiatives. The category includes evaluation of inclusive diversity policies, fair treatment of all employees, robust diversity (EEO-1) programs and training. &nbsp;
**environmentRating** | [**BigDecimal**](BigDecimal.md) | The Environment category data covers a company&#39;s interactions with the environment at large, including use of natural resources. The category evaluates corporate environmental performance, compliance with environmental regulations, and mitigation of environmental footprint. It also includes leadership in addressing climate change through appropriate policies and strategies. &nbsp;
**governanceRating** | [**BigDecimal**](BigDecimal.md) | Corporate governance refers to leadership structure and the values that determine corporate direction, ethics and performance. The Governance category covers disclosure of policies and procedures, board independence and diversity, executive compensation, attention to stakeholder concerns, and evaluation of a company&#39;s culture of ethical leadership and compliance. &nbsp;
**humanRightsAndSupplyChainRating** | [**BigDecimal**](BigDecimal.md) | The Human Rights and Supply Chain subcategory measures a company&#39;s commitment to respecting fundamental human rights conventions. This subcategory covers a company&#39;s transparency in overseas sourcing disclosure and monitoring. The subcategory also covers the relationship with and respect for the human rights of indigenous peoples near its proposed or current operations. &nbsp;
**communityDevAndPhilanthropyRating** | [**BigDecimal**](BigDecimal.md) | The Community Development and Philanthropy subcategory covers the relationship between a company and the communities within which it is embedded. It reflects a company&#39;s community citizenship through charitable giving, donations of goods, and volunteerism of staff time. It also includes protecting public health (e.g., avoidance of industrial accidents) and managing the social impacts of its operations. &nbsp;
**productRating** | [**BigDecimal**](BigDecimal.md) | The Product subcategory covers the responsibility of a company for the development, design, and management of its products and services. This subcategory reflects a company&#39;s capacity to reduce environmental costs, create new market opportunities, and produce or market goods and services that enhance the health and quality of life for consumers. &nbsp;
**compensationAndBenefitsRating** | [**BigDecimal**](BigDecimal.md) | The Compensation and Benefits subcategory covers a company&#39;s capacity to increase its workforce loyalty and productivity. It includes benefits that engage employees and improve worker development. This subcategory also focuses on long-term employment growth and stability by promotion practices, lay-off practices, and relations with retired employees. &nbsp;
**diversityAndLaborRightsRating** | [**BigDecimal**](BigDecimal.md) | The Diversity and Labor Rights subcategory covers workplace policies and practices covering fair and non-discriminatory treatment of employees. It covers a company&#39;s labor-management relations and participation by employees. Fundamental labor rights include freedom of association and protection of the right to organize. &nbsp;
**trainingHealthAndSafetyRating** | [**BigDecimal**](BigDecimal.md) | The Training, Safety and Health subcategory measures a company&#39;s effectiveness in providing a healthy and safe workplace. It includes programs to support the health, well-being and productivity of all employees. This subcategory includes workplace policies and programs that boost employee morale, workplace productivity and worker development. &nbsp;
**energyClimateChangeRating** | [**BigDecimal**](BigDecimal.md) | The Energy and Climate Change subcategory measures a company&#39;s effectiveness in addressing climate change through appropriate policies and strategies. The subcategory includes energy use, emissions to air of CO2 and other Greenhouse Gas Emissions (GHG) and other alternative environmental technologies. &nbsp;
**environmentPolicyAndReportingRating** | [**BigDecimal**](BigDecimal.md) | The Environmental Policy and Reporting subcategory includes a company&#39;s policies and intention to reduce the environmental impact of a company. The data includes the company&#39;s environmental reporting performance, adherence to environmental reporting standards and compliance with investor, regulatory and stakeholders&#39; requests for transparency. Compliance data consists of breaches of regulatory limits and accidental releases. &nbsp;
**resourceManagementRating** | [**BigDecimal**](BigDecimal.md) | The Resource Management subcategory covers how efficiently resources are used in manufacturing and delivering products and services. It includes a company&#39;s capacity to reduce the use of materials, energy or water, and to find more efficient solutions by improving its supply chain management. This subcategory includes environmental performance relative to production size. &nbsp;
**boardRating** | [**BigDecimal**](BigDecimal.md) | The Board subcategory covers a company&#39;s effectiveness in following best practices in corporate governance principles related to board membership. It includes how the company provides competitive and proportionate management compensation and its ability to incent executives and board members to achieve both financial and extra-financial targets. &nbsp;
**leadershipEthicsRating** | [**BigDecimal**](BigDecimal.md) | The Leadership Ethics subcategory measures how a company manages its relationships with its various stakeholders, including investors, customers, communities, and regulators. It measures a company&#39;s commitment and effectiveness toward the vision of integrating social and environmental aspects into the overall core strategy. It also measures whether sustainability principles are integrated from the top down into the day-to-day operations of the company. &nbsp;
**transparencyReportingRating** | [**BigDecimal**](BigDecimal.md) | The Transparency and Reporting subcategory rates factors including are corporate policies and practices aligned with sustainability goals. It also covers whether the company is a signatory of Global Compact and other leading global entities. It evaluates the assurance (3rd party audit) of the accuracy, completeness, and reliability of its Sustainability or Corporate Social Responsibility reports. &nbsp;
**countryPercentileRank** | [**BigDecimal**](BigDecimal.md) | The percentile rank of the company&#39;s ESG rating in comparison to it&#39;s country peers. &nbsp;
**industryPercentileRank** | [**BigDecimal**](BigDecimal.md) | The percentile rank of the company&#39;s ESG rating in comparison to it&#39;s industry peers. &nbsp;
**overallPercentileRank** | [**BigDecimal**](BigDecimal.md) | The percentile rank of the company&#39;s overall ESG rating in comparison to all companies within the CSRHub ESG universe. &nbsp;
**communityPercentileRank** | [**BigDecimal**](BigDecimal.md) | The percentile rank of the company&#39;s Community rating in comparison to all companies within the CSRHub ESG universe. &nbsp;
**employeePercentileRank** | [**BigDecimal**](BigDecimal.md) | The percentile rank of the company&#39;s Employee rating in comparison to all companies within the CSRHub ESG universe. &nbsp;
**environmentPercentileRank** | [**BigDecimal**](BigDecimal.md) | The percentile rank of the company&#39;s Environment rating in comparison to all companies within the CSRHub ESG universe. &nbsp;
**governancePercentileRank** | [**BigDecimal**](BigDecimal.md) | The percentile rank of the company&#39;s Governance rating in comparison to all companies within the CSRHub ESG universe. &nbsp;
**humanRightsAndSupplyChainPercentileRank** | [**BigDecimal**](BigDecimal.md) | The percentile rank of the company&#39;s Human Rights and Supply Chain rating in comparison to all companies within the CSRHub ESG universe. &nbsp;
**communityDevAndPhilanthropyPercentileRank** | [**BigDecimal**](BigDecimal.md) | The percentile rank of the company&#39;s Community, Dev, and Philanthropy rating in comparison to all companies within the CSRHub ESG universe. &nbsp;
**productPercentileRank** | [**BigDecimal**](BigDecimal.md) | The percentile rank of the company&#39;s Product rating in comparison to all companies within the CSRHub ESG universe. &nbsp;
**compensationAndBenefitsPercentileRank** | [**BigDecimal**](BigDecimal.md) | The percentile rank of the company&#39;s Compensation and Benefits rating in comparison to all companies within the CSRHub ESG universe. &nbsp;
**diversityAndLaborRightsPercentileRank** | [**BigDecimal**](BigDecimal.md) | The percentile rank of the company&#39;s Diversity and Labor Rights rating in comparison to all companies within the CSRHub ESG universe. &nbsp;
**trainingHealthAndSafetyPercentileRank** | [**BigDecimal**](BigDecimal.md) | The percentile rank of the company&#39;s Training, Health, and Safety rating in comparison to all companies within the CSRHub ESG universe. &nbsp;
**energyClimateChangePercentileRank** | [**BigDecimal**](BigDecimal.md) | The percentile rank of the company&#39;s Energy Climate Change rating in comparison to all companies within the CSRHub ESG universe. &nbsp;
**environmentPolicyAndReportingPercentileRank** | [**BigDecimal**](BigDecimal.md) | The percentile rank of the company&#39;s Environment Policy and Reporting rating in comparison to all companies within the CSRHub ESG universe. &nbsp;
**resourceManagementPercentileRank** | [**BigDecimal**](BigDecimal.md) | The percentile rank of the company&#39;s Resource Management rating in comparison to all companies within the CSRHub ESG universe. &nbsp;
**boardPercentileRank** | [**BigDecimal**](BigDecimal.md) | The percentile rank of the company&#39;s Board rating in comparison to all companies within the CSRHub ESG universe. &nbsp;
**leadershipEthicsPercentileRank** | [**BigDecimal**](BigDecimal.md) | The percentile rank of the company&#39;s Leadership Ethics rating in comparison to all companies within the CSRHub ESG universe. &nbsp;
**transparencyReportingPercentileRank** | [**BigDecimal**](BigDecimal.md) | The percentile rank of the company&#39;s Transaperency Reporting rating in comparison to all companies within the CSRHub ESG universe. &nbsp;
**company** | [**ESGCompanySummary**](ESGCompanySummary.md) |  &nbsp;

[//]: # (END_DEFINITION)


[//]: # (CONTAINED_CLASS:LocalDate)


[//]: # (CONTAINED_CLASS:BigDecimal)


[//]: # (CONTAINED_CLASS:BigDecimal)


[//]: # (CONTAINED_CLASS:BigDecimal)


[//]: # (CONTAINED_CLASS:BigDecimal)


[//]: # (CONTAINED_CLASS:BigDecimal)


[//]: # (CONTAINED_CLASS:BigDecimal)


[//]: # (CONTAINED_CLASS:BigDecimal)


[//]: # (CONTAINED_CLASS:BigDecimal)


[//]: # (CONTAINED_CLASS:BigDecimal)


[//]: # (CONTAINED_CLASS:BigDecimal)


[//]: # (CONTAINED_CLASS:BigDecimal)


[//]: # (CONTAINED_CLASS:BigDecimal)


[//]: # (CONTAINED_CLASS:BigDecimal)


[//]: # (CONTAINED_CLASS:BigDecimal)


[//]: # (CONTAINED_CLASS:BigDecimal)


[//]: # (CONTAINED_CLASS:BigDecimal)


[//]: # (CONTAINED_CLASS:BigDecimal)


[//]: # (CONTAINED_CLASS:BigDecimal)


[//]: # (CONTAINED_CLASS:BigDecimal)


[//]: # (CONTAINED_CLASS:BigDecimal)


[//]: # (CONTAINED_CLASS:BigDecimal)


[//]: # (CONTAINED_CLASS:BigDecimal)


[//]: # (CONTAINED_CLASS:BigDecimal)


[//]: # (CONTAINED_CLASS:BigDecimal)


[//]: # (CONTAINED_CLASS:BigDecimal)


[//]: # (CONTAINED_CLASS:BigDecimal)


[//]: # (CONTAINED_CLASS:BigDecimal)


[//]: # (CONTAINED_CLASS:BigDecimal)


[//]: # (CONTAINED_CLASS:BigDecimal)


[//]: # (CONTAINED_CLASS:BigDecimal)


[//]: # (CONTAINED_CLASS:BigDecimal)


[//]: # (CONTAINED_CLASS:BigDecimal)


[//]: # (CONTAINED_CLASS:BigDecimal)


[//]: # (CONTAINED_CLASS:BigDecimal)


[//]: # (CONTAINED_CLASS:BigDecimal)


[//]: # (CONTAINED_CLASS:BigDecimal)


[//]: # (CONTAINED_CLASS:BigDecimal)


[//]: # (CONTAINED_CLASS:BigDecimal)


[//]: # (CONTAINED_CLASS:ESGCompanySummary)





