// Copyright 2017 the V8 project authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Generated by tools/bigint-tester.py.

// Flags: --harmony-bigint

var data = [{
  a: 0xb3df90n,
  r: 0xb3df91n
}, {
  a: 0xaacd53fc9545eb394304a3c69caba730230a6527730an,
  r: 0xaacd53fc9545eb394304a3c69caba730230a6527730bn
}, {
  a: 0x32efa4ba1c29098be7df8fa0f3c74a183612ecn,
  r: 0x32efa4ba1c29098be7df8fa0f3c74a183612edn
}, {
  a: -0xcabed06f63ad50406b96187208cf9ec6faf46413ce83e280c31ben,
  r: -0xcabed06f63ad50406b96187208cf9ec6faf46413ce83e280c31bdn
}, {
  a: -0x8a40ce58f753466f4008faa0814e76d9b594908df0e42cf6ad4a781e60ce2n,
  r: -0x8a40ce58f753466f4008faa0814e76d9b594908df0e42cf6ad4a781e60ce1n
}, {
  a: -0x848c8fc23bc93801n,
  r: -0x848c8fc23bc93800n
}, {
  a: -0x13a8316c5af3f3b06aab6642e717a7bdn,
  r: -0x13a8316c5af3f3b06aab6642e717a7bcn
}, {
  a: -0x5f5e517cf7efe577cd689c36d1beb3d9df4cfdc3fcb55ed9e9d8fan,
  r: -0x5f5e517cf7efe577cd689c36d1beb3d9df4cfdc3fcb55ed9e9d8f9n
}, {
  a: 0n,
  r: 0x1n
}, {
  a: 0x107d5ec8048c4d715e213ec74f9f04006d3f2d90dd95d17c3e82f7a4ccn,
  r: 0x107d5ec8048c4d715e213ec74f9f04006d3f2d90dd95d17c3e82f7a4cdn
}, {
  a: 0xb8e09fc6037a75bbfn,
  r: 0xb8e09fc6037a75bc0n
}, {
  a: 0x515d1b999660074184n,
  r: 0x515d1b999660074185n
}, {
  a: 0xe12def67dc33628638612b8137d0fa425ea2dn,
  r: 0xe12def67dc33628638612b8137d0fa425ea2en
}, {
  a: 0x96a9n,
  r: 0x96aan
}, {
  a: -0x9df122a299a5e65b275028n,
  r: -0x9df122a299a5e65b275027n
}, {
  a: 0x20dd05bfb5ed6ebfb05da9a7488800b8895fbfe6d709eecb6071cda73e13n,
  r: 0x20dd05bfb5ed6ebfb05da9a7488800b8895fbfe6d709eecb6071cda73e14n
}, {
  a: 0xb38294d2e5523534c56dd6ef38ba744b29e3a3bb6f863f1aeaen,
  r: 0xb38294d2e5523534c56dd6ef38ba744b29e3a3bb6f863f1aeafn
}, {
  a: -0x6b58de4ba9b2699ea6777dc1adc0b2486n,
  r: -0x6b58de4ba9b2699ea6777dc1adc0b2485n
}, {
  a: 0xf40028a48894df5d81131046477a22e55cbead5n,
  r: 0xf40028a48894df5d81131046477a22e55cbead6n
}, {
  a: -0x44cbe6c7f5e7e879d3cb2eaffc4af0a43affc094218031a1f123746549dd7b8cdcbdn,
  r: -0x44cbe6c7f5e7e879d3cb2eaffc4af0a43affc094218031a1f123746549dd7b8cdcbcn
}];

var error_count = 0;
for (var i = 0; i < data.length; i++) {
  var d = data[i];
  var r = ++d.a;
  if (d.r !== r) {
    print("Input:    " + d.a.toString(16));
    print("Result:   " + r.toString(16));
    print("Expected: " + d.r);
    error_count++;
  }
}
if (error_count !== 0) {
  print("Finished with " + error_count + " errors.")
  quit(1);
}
