// Copyright 2017 the V8 project authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Generated by tools/bigint-tester.py.

// Flags: --harmony-bigint

var data = [{
  a: 0x2bf1f236c2df29f7c99be052dfe1b69ae158d777fea487af889f6259f472c0n,
  b: -0xae0090dfn,
  r: -0x1dde8b7f987479d7b308e2b8a122703d417f921fd4ab04fcac81439ace4f445c7bf540n
}, {
  a: -0x71cd629b6682b5b1c50f9436ded88468bcn,
  b: -0xb24ce1d11726048158fb42c02e9361973193n,
  r: 0x4f42fbebca0bc1746d114996d9c9cceb4065c347da31dc0efa88db41f1f724aef81ff4n
}, {
  a: 0xef7c15fb2256338bd0650fa51c28551108ccb9828850f1b415d0c8f1a47fc0e2f86n,
  b: 0xc17n,
  r: 0xb4f552dbf2c20292f5475d025276b9c70f16316c91e0a9a2833bf2d616bc484f808d0an
}, {
  a: 0xcc8a5a56c623d9f9be2103bc237976f26n,
  b: 0x13a02fec7cfd49c5a081c06bbbaac5c70dc3an,
  r: 0xfae417740ef1963ad78aa4252159d986593845690f4f5fe759f6d913d79810473d69cn
}, {
  a: -0x519n,
  b: 0x7de5551df3ec2619a89139153663a79f8bdb47047423c8070d7cfddc26d43af8ee9n,
  r: -0x281c60ee5b06ece38cc4c4bfd2242017c4ff0cd05b40a66abf3c22a1741efe09ef81c1n
}, {
  a: 0x6fb9ba0d0n,
  b: -0x86b45ffb80fbf2b61abc14b28855780f83e187fd6ae26e09d28d6f05260e1n,
  r: -0x3ac9efdd4e930fcbf654819060b858f182f7768db6bc72deb8d734d2ea10fa02b656d0n
}, {
  a: -0xde2e7a0883a63d69d2120108f92943e4a34b63e8468c12b38a0519a6498n,
  b: -0xb1857781fefn,
  r: 0x9a11f83db6da31f78a2415d3891f79a0f6aafc69553fb458a2bc3ae2e2f65cb09251e8n
}, {
  a: -0x2c90284ebdb5237ba7c9562f596ef9a21254a3n,
  b: -0xb55feab8b45cc1bcdcfc5585c9114de0n,
  r: 0x1f929eda8d33ec2ded8d76382a4cb731f805d28e827521a27154b6618a6f87ed5215a0n
}, {
  a: 0x11ffe68d26ca29eac43b64n,
  b: -0xe3311b278fec1fb3f8f59acfd9147c773197fc54c66b25bdn,
  r: -0xff95d530fd53e61744d86d09f9ab5401b1efb2133af5c47ffeca31aca22a4da414cd4n
}, {
  a: 0xbda74de44eeb2995a4185325014863n,
  b: 0xf99164c7248a0372d72d82cbf65fdb345c84bca6n,
  r: 0xb8e3712f119fefa47168950100b33aa1ec4e61a970d0eec2d2dd4b925cc4dfd709a432n
}, {
  a: 0x47fc0bb6d761e12a1f7cf2a14f4cc777486b22516ca339641fn,
  b: -0xd2fa2494ae242494f307n,
  r: -0x3b531808ad9095f9f904dba47ef4a0aef54f736cc2836accb7b1b70f07ee862e8729d9n
}, {
  a: 0x91d09f35203fcf69974d347ab718912cn,
  b: 0xfc2d9a00611e4e1767b67db898b951e5d2bbb9n,
  r: 0x8fa3561bff2cc00a780a71e5b16d6092296514d401c88fc54e04a91062775cb4e40cccn
}, {
  a: 0x5a5b1ede360dafcac08c92f4b809e401502df5ab8569303a2n,
  b: -0xb64d963b1ac4eb46ddd65n,
  r: -0x40582a6083cd0feb5b33ac138feaf9250b5084e561807e56a8415c810a1bf9861d48ean
}, {
  a: 0xf68275dc25d6af7dde130n,
  b: 0xfe330b766e44f479e342e3315812e977d4d5e39bffe42111dn,
  r: 0xf4c697f78dc7c9b3207b50cf2cf3035aa065e96c37c0be3345f71f34096f057e76b270n
}, {
  a: 0x77009ed053f71n,
  b: -0x647aecfc2af4079a586fbba99070c3f51d5465d9a4fd8c12cdab10854n,
  r: -0x2eb5627edb1072a65a1db2d243d0bf2eeb5c3ff6ad61ec1063e9ee40b783bd06d55914n
}, {
  a: 0xccfa15bb6125b01bece5a919ab5e9128e784d63e50b5990ba8047a7effn,
  b: 0x1a366ac48cdan,
  r: 0x14fcf8728aa3dc5ef26b077dfc012d592c3a0cdfc3331942f921f037eea5af9eff9926n
}, {
  a: 0x4fc54a59f2n,
  b: -0x93bbcbd684987407c4ec4a3cbdc7c4821c33ca20ca8449b0055905e9a8ffn,
  r: -0x2e08ce533fdc7bb8a3a2280cfb116c85837b74606ed25f8daad623baa4ac7de758680en
}, {
  a: -0xcf21626f318089a85738f7e9cdcf0a477f4d880ce58679n,
  b: -0xc7ca8704a49fdb8f9567c68cn,
  r: 0xa1a6d11a77d8e1b723bfa0242407a454274145c31bb6ede29bb0e3883b08951b36202cn
}, {
  a: 0x20c3cb19e51d4e2ac2c89f26e052bef8n,
  b: -0xab2a148297108425ebd2fd17d897f647e0792fn,
  r: -0x15e82b69a0eaed04cd140c6aed3b1f5bc0fc5de7ceddcb2d77615767b19dd82c744788n
}, {
  a: -0xcc4f48f45d8165569348fb995370n,
  b: 0x140cc111df0a06e32335478ded744eb3a737a53409n,
  r: -0x10005f808c07a1d91faac090aad06804b491919a9d2ed58f6caa52448ad97bd486aef0n
}];

var error_count = 0;
for (var i = 0; i < data.length; i++) {
  var d = data[i];
  var r = d.a * d.b;
  if (d.r !== r) {
    print("Input A:  " + d.a.toString(16));
    print("Input B:  " + d.b.toString(16));
    print("Result:   " + r.toString(16));
    print("Expected: " + d.r);
    print("Op: *");
    error_count++;
  }
}
if (error_count !== 0) {
  print("Finished with " + error_count + " errors.")
  quit(1);
}
