﻿using Gum.Attributes;
using System;

namespace Gum.Utilities
{
    internal static class OutputHelpers
    {
        internal static DiagnosticLevel Level = DiagnosticLevel.All;

        public static void Log(string message)
        {
            if (Level == DiagnosticLevel.ErrorsOnly)
            {
                return;
            }

            Console.ForegroundColor = ConsoleColor.Magenta;
            Console.WriteLine(message);
            Console.ResetColor();
        }

        public static void WriteError(string message)
        {
            Console.ForegroundColor = ConsoleColor.Red;
            Console.WriteLine($"🤚 Error! {message}");
            Console.ResetColor();
        }

        public static void WriteWarning(string message)
        {
            Console.ForegroundColor = ConsoleColor.Yellow;
            Console.WriteLine($"🚧 Warning! {message}");
            Console.ResetColor();
        }

        public static void Suggestion(string message)
        {
            Console.WriteLine($"💡 Did you mean {message}");
        }

        public static void Remark(string message)
        {
            Console.WriteLine(message);
        }

        public static void ProposeFix(int line, ReadOnlySpan<char> before, ReadOnlySpan<char> after)
        {
            Console.WriteLine("Suggestion:");
            Console.WriteLine($"\tLine {line} | {before}");
            Console.WriteLine($"\t   ⬇️");
            Console.WriteLine($"\tLine {line} | {after}");
        }

        public static void ProposeFixOnLineAbove(int line, ReadOnlySpan<char> currentLine, ReadOnlySpan<char> newLine)
        {
            Console.WriteLine("Suggestion:");
            Console.WriteLine($"\tLine {line} | {currentLine}");
            Console.WriteLine($"\t   ⬇️");
            Console.WriteLine($"\tLine {line} | {newLine}");
            Console.WriteLine($"\tLine {line + 1} | {currentLine}");
        }

        public static void ProposeFixOnLineBelow(int line, ReadOnlySpan<char> currentLine, ReadOnlySpan<char> newLine, ReadOnlySpan<char> newLineBelow)
        {
            Console.WriteLine("Suggestion:");
            Console.WriteLine($"\tLine {line} | {currentLine}");
            Console.WriteLine($"\t   ⬇️");
            Console.WriteLine($"\tLine {line} | {newLine}");
            Console.WriteLine($"\tLine {line + 1} | {newLineBelow}");
        }

        public static void ProposeFixAtColumn(int line, int column, int arrowLength, ReadOnlySpan<char> content, ReadOnlySpan<char> issue)
        {
            Console.WriteLine($"\tLine {line} | {content}");

            Console.Write("\t          ");

            while (column-- > 0)
            {
                Console.Write(' ');
            }

            // The emoji occupies sort of two characters?
            arrowLength = Math.Max(1, arrowLength / 2);

            while (arrowLength-- > 0)
            {
                Console.Write($"☝️");
            }
            Console.Write($" {issue}");
        }

        public static string ToCustomString<T>(this T value) where T : Enum
        {
            TokenNameAttribute[] attributes = (TokenNameAttribute[])typeof(T)
                .GetField(value.ToString())!
                .GetCustomAttributes(typeof(TokenNameAttribute), false);

            return attributes.Length > 0 ? attributes[0].Name : value.ToString();
        }
    }
}