import { Component, OnDestroy } from '@angular/core';
import { NbThemeService } from '@nebular/theme';

@Component({
	selector: 'ngx-chartjs-bar-horizontal',
	template: `
		<chart type="horizontalBar" [data]="data" [options]="options"></chart>
	`
})
export class ChartjsBarHorizontalComponent implements OnDestroy {
	data: any;
	options: any;
	themeSubscription: any;

	constructor(private theme: NbThemeService) {
		this.themeSubscription = this.theme.getJsTheme().subscribe((config) => {
			const colors: any = config.variables;
			const chartjs: any = config.variables.chartjs;

			this.data = {
				labels: [
					'January',
					'February',
					'March',
					'April',
					'May',
					'June'
				],
				datasets: [
					{
						label: 'Dataset 1',
						backgroundColor: colors.infoLight,
						borderWidth: 1,
						data: [
							this.random(),
							this.random(),
							this.random(),
							this.random(),
							this.random(),
							this.random()
						]
					},
					{
						label: 'Dataset 2',
						backgroundColor: colors.successLight,
						data: [
							this.random(),
							this.random(),
							this.random(),
							this.random(),
							this.random(),
							this.random()
						]
					}
				]
			};

			this.options = {
				responsive: true,
				maintainAspectRatio: false,
				elements: {
					rectangle: {
						borderWidth: 2
					}
				},
				scales: {
					xAxes: [
						{
							gridLines: {
								display: true,
								color: chartjs.axisLineColor
							},
							ticks: {
								fontColor: chartjs.textColor
							}
						}
					],
					yAxes: [
						{
							gridLines: {
								display: false,
								color: chartjs.axisLineColor
							},
							ticks: {
								fontColor: chartjs.textColor
							}
						}
					]
				},
				legend: {
					position: 'right',
					labels: {
						fontColor: chartjs.textColor
					}
				}
			};
		});
	}

	private random() {
		return Math.round(Math.random() * 100);
	}

	ngOnDestroy(): void {
		this.themeSubscription.unsubscribe();
	}
}
