import { Component, OnDestroy } from '@angular/core';
import { NbThemeService } from '@nebular/theme';

@Component({
	selector: 'ngx-chartjs-multiple-xaxis',
	template: `
		<chart type="line" [data]="data" [options]="options"></chart>
	`
})
export class ChartjsMultipleXaxisComponent implements OnDestroy {
	data: {};
	options: any;
	themeSubscription: any;

	constructor(private theme: NbThemeService) {
		this.themeSubscription = this.theme.getJsTheme().subscribe((config) => {
			const colors: any = config.variables;
			const chartjs: any = config.variables.chartjs;

			this.data = {
				labels: [
					'January',
					'February',
					'March',
					'April',
					'May',
					'June'
				],
				datasets: [
					{
						label: 'dataset - big points',
						data: [
							this.random(),
							this.random(),
							this.random(),
							this.random(),
							this.random(),
							this.random()
						],
						borderColor: colors.primary,
						backgroundColor: colors.primary,
						fill: false,
						borderDash: [5, 5],
						pointRadius: 8,
						pointHoverRadius: 10
					},
					{
						label: 'dataset - individual point sizes',
						data: [
							this.random(),
							this.random(),
							this.random(),
							this.random(),
							this.random(),
							this.random()
						],
						borderColor: colors.dangerLight,
						backgroundColor: colors.dangerLight,
						fill: false,
						borderDash: [5, 5],
						pointRadius: 8,
						pointHoverRadius: 10
					},
					{
						label: 'dataset - large pointHoverRadius',
						data: [
							this.random(),
							this.random(),
							this.random(),
							this.random(),
							this.random(),
							this.random()
						],
						borderColor: colors.info,
						backgroundColor: colors.info,
						fill: false,
						pointRadius: 8,
						pointHoverRadius: 10
					},
					{
						label: 'dataset - large pointHitRadius',
						data: [
							this.random(),
							this.random(),
							this.random(),
							this.random(),
							this.random(),
							this.random()
						],
						borderColor: colors.success,
						backgroundColor: colors.success,
						fill: false,
						pointRadius: 8,
						pointHoverRadius: 10
					}
				]
			};

			this.options = {
				responsive: true,
				maintainAspectRatio: false,
				legend: {
					position: 'bottom',
					labels: {
						fontColor: chartjs.textColor
					}
				},
				hover: {
					mode: 'index'
				},
				scales: {
					xAxes: [
						{
							display: true,
							scaleLabel: {
								display: true,
								labelString: 'Month'
							},
							gridLines: {
								display: true,
								color: chartjs.axisLineColor
							},
							ticks: {
								fontColor: chartjs.textColor
							}
						}
					],
					yAxes: [
						{
							display: true,
							scaleLabel: {
								display: true,
								labelString: 'Value'
							},
							gridLines: {
								display: true,
								color: chartjs.axisLineColor
							},
							ticks: {
								fontColor: chartjs.textColor
							}
						}
					]
				}
			};
		});
	}

	private random() {
		return Math.round(Math.random() * 100);
	}

	ngOnDestroy(): void {
		this.themeSubscription.unsubscribe();
	}
}
