import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';

import { FormsComponent } from './forms.component';
import { FormInputsComponent } from './form-inputs/form-inputs.component';
import { FormLayoutsComponent } from './form-layouts/form-layouts.component';

const routes: Routes = [
	{
		path: '',
		component: FormsComponent,
		children: [
			{
				path: 'inputs',
				component: FormInputsComponent
			}, {
				path: 'layouts',
				component: FormLayoutsComponent
			}
		]
	}
];

@NgModule({
	imports: [
		RouterModule.forChild(routes)
	],
	exports: [
		RouterModule
	]
})
export class FormsRoutingModule {

}

export const routedComponents = [
	FormsComponent,
	FormInputsComponent,
	FormLayoutsComponent
];
