import 'jasmine';
import { NO_ERRORS_SCHEMA } from '@angular/core';
import { async, TestBed, ComponentFixture } from '@angular/core/testing';
import { AppComponent } from './app.component';
import { AppState } from './app.service';

describe(`App`, () => {
	let comp: AppComponent;
	let fixture: ComponentFixture<AppComponent>;

	/**
	 * async beforeEach
	 */
	beforeEach(async(() => {
		TestBed.configureTestingModule({
			declarations: [AppComponent],
			schemas: [NO_ERRORS_SCHEMA],
			providers: [AppState]
		})
			/**
			 * Compile template and css
			 */
			.compileComponents();
	}));

	/**
	 * Synchronous beforeEach
	 */
	beforeEach(() => {
		fixture = TestBed.createComponent(AppComponent);
		comp = fixture.componentInstance;

		/**
		 * Trigger initial data binding
		 */
		fixture.detectChanges();
	});

	it(`should be readly initialized`, () => {
		expect(fixture).toBeDefined();
		expect(comp).toBeDefined();
	});

	it('should log ngOnInit', () => {
		spyOn(console, 'log');
		expect(console.log).not.toHaveBeenCalled();

		comp.ngOnInit();
		expect(console.log).toHaveBeenCalled();
	});
});
