# Node.js v6 ChangeLog

<table>
<tr>
<th title="Previously called 'Stable'">Current</th>
</tr>
<tr>
<td>
<a href="#6.8.1">6.8.1</a><br/>
<a href="#6.8.0">6.8.0</a><br/>
<a href="#6.7.0">6.7.0</a><br/>
<a href="#6.6.0">6.6.0</a><br/>
<a href="#6.5.0">6.5.0</a><br/>
<a href="#6.4.0">6.4.0</a><br/>
<a href="#6.3.1">6.3.1</a><br/>
<a href="#6.3.0">6.3.0</a><br/>
<a href="#6.2.2">6.2.2</a><br/>
<a href="#6.2.1">6.2.1</a><br/>
<a href="#6.2.0">6.2.0</a><br/>
<a href="#6.1.0">6.1.0</a><br/>
<a href="#6.0.0">6.0.0</a><br/>
</td>
</tr>
</table>

* Other Versions
  * [5.x](CHANGELOG_V5.md)
  * [4.x](CHANGELOG_V4.md)
  * [0.12.x](CHANGELOG_V012.md)
  * [0.10.x](CHANGELOG_V010.md)
  * [io.js](CHANGELOG_IOJS.md)
  * [Archive](CHANGELOG_ARCHIVE.md)

**Note:** The v6 release line will be covered by the
[Node.js Long Term Support plan](https://github.com/nodejs/LTS) starting in
October 2016.

<a id="6.8.1"></a>
## 2016-10-14, Version 6.8.1 (Current), @evanlucas

### Notable changes

* **build**: Fix building with shared zlib. (Bradley T. Hughes) [#9077](https://github.com/nodejs/node/pull/9077)
* **stream**: Fix regression in `stream.Writable` subclass `instanceof` checks. (Anna Henningsen) [#9088](https://github.com/nodejs/node/pull/9088)
* **timers**: Fix regression where immediates that are cleared in the callback would never be called. (Brian White) [#9086](https://github.com/nodejs/node/pull/9086)

### Commits

* [[`8d2206fe41`](https://github.com/nodejs/node/commit/8d2206fe41)] - **build**: add -DZLIB_CONST when building with --shared-zlib (Bradley T. Hughes) [#9077](https://github.com/nodejs/node/pull/9077)
* [[`8c4fab0a28`](https://github.com/nodejs/node/commit/8c4fab0a28)] - **stream**: fix `Writable` subclass instanceof checks (Anna Henningsen) [#9088](https://github.com/nodejs/node/pull/9088)
* [[`7171bd6311`](https://github.com/nodejs/node/commit/7171bd6311)] - **timers**: fix regression with clearImmediate() (Brian White) [#9086](https://github.com/nodejs/node/pull/9086)

<a id="6.8.0"></a>
## 2016-10-12, Version 6.8.0 (Current), @Fishrock123

### Notable changes

* **fs**:
  - `SyncWriteStream` now inherits from `Stream.Writable`. (Anna Henningsen) [#8830](https://github.com/nodejs/node/pull/8830)
    - Practically, this means that when stdio is piped to a file, stdout and stderr will still be `Writable` streams.
  - `fs.existsSync()` has been undeprecated. `fs.exists()` remains deprecated. (Dan Fabulich) [#8364](https://github.com/nodejs/node/pull/8364)
* **http**: `http.request()` now accepts a `timeout` option. (Rene Weber) [#8101](https://github.com/nodejs/node/pull/8101)
* **module**: The module loader now maintains its own realpath cache. (Anna Henningsen) [#8100](https://github.com/nodejs/node/pull/8100)
* **npm**: Upgraded to 3.10.8 (Kat Marchán) [#8706](https://github.com/nodejs/node/pull/8706)
* **stream**: `Duplex` streams now show proper `instanceof Stream.Writable`. (Anna Henningsen) [#8834](https://github.com/nodejs/node/pull/8834)
* **timers**: Improved `setTimeout`/`Interval` performance by up to 22%. (Brian White) [#8661](https://github.com/nodejs/node/pull/8661)

### Commits

* [[`1a6e8983a6`](https://github.com/nodejs/node/commit/1a6e8983a6)] - **benchmark**: add benchmarks for `Buffer.from()` (Anna Henningsen) [#8738](https://github.com/nodejs/node/pull/8738)
* [[`882f8b3d6c`](https://github.com/nodejs/node/commit/882f8b3d6c)] - **benchmark**: use 'yes' instead of echo in a loop (Bartosz Sosnowski) [#8721](https://github.com/nodejs/node/pull/8721)
* [[`999f727bb5`](https://github.com/nodejs/node/commit/999f727bb5)] - **benchmark**: add benchmark for destructuring object (Fangdun Cai (Fundon)) [#8680](https://github.com/nodejs/node/pull/8680)
* [[`5c10898e31`](https://github.com/nodejs/node/commit/5c10898e31)] - **buffer**: fix check for `.buffer` property (Ojas Shirekar) [#8739](https://github.com/nodejs/node/pull/8739)
* [[`b9c2270502`](https://github.com/nodejs/node/commit/b9c2270502)] - **buffer**: fix performance regression (Michaël Zasso) [#8754](https://github.com/nodejs/node/pull/8754)
* [[`3fcdf4e80a`](https://github.com/nodejs/node/commit/3fcdf4e80a)] - **buffer**: remove unnecessary argument check (Michaël Zasso) [#8552](https://github.com/nodejs/node/pull/8552)
* [[`ee319b739c`](https://github.com/nodejs/node/commit/ee319b739c)] - **buffer**: add isSharedArrayBuffer checks (Ojas Shirekar) [#8510](https://github.com/nodejs/node/pull/8510)
* [[`38fdbcd7f7`](https://github.com/nodejs/node/commit/38fdbcd7f7)] - **build**: make addons build dep. on node_version.h (Anna Henningsen) [#8861](https://github.com/nodejs/node/pull/8861)
* [[`f057d193ec`](https://github.com/nodejs/node/commit/f057d193ec)] - **build**: run cctests as part of test-ci target (Ben Noordhuis) [#8034](https://github.com/nodejs/node/pull/8034)
* [[`a202be6690`](https://github.com/nodejs/node/commit/a202be6690)] - **build**: don't build icu with -fno-rtti (Ben Noordhuis) [#8886](https://github.com/nodejs/node/pull/8886)
* [[`296254f141`](https://github.com/nodejs/node/commit/296254f141)] - **build**: remove VS 2013 switch from vcbuild.bat (Ben Noordhuis) [#8067](https://github.com/nodejs/node/pull/8067)
* [[`a425c4da98`](https://github.com/nodejs/node/commit/a425c4da98)] - **build**: run `npm install` for doc builds in tarball (Anna Henningsen) [#8413](https://github.com/nodejs/node/pull/8413)
* [[`3d3bce6ca1`](https://github.com/nodejs/node/commit/3d3bce6ca1)] - **cluster**: remove unused backlog argument (Brian White) [#8877](https://github.com/nodejs/node/pull/8877)
* [[`23a851dfe6`](https://github.com/nodejs/node/commit/23a851dfe6)] - **deps**: avoid single-byte buffer overwrite in ares_create_query (Daniel Stenberg) [#8849](https://github.com/nodejs/node/pull/8849)
* [[`46af58898c`](https://github.com/nodejs/node/commit/46af58898c)] - **deps**: make gtest output tap (Ben Noordhuis) [#8034](https://github.com/nodejs/node/pull/8034)
* [[`9d41e8913f`](https://github.com/nodejs/node/commit/9d41e8913f)] - **deps**: bump V8 patch to 84 (Myles Borins) [#8851](https://github.com/nodejs/node/pull/8851)
* [[`4d41bd9c68`](https://github.com/nodejs/node/commit/4d41bd9c68)] - **deps**: hotfix upgrade npm tap version for tests (Kat Marchán) [#8706](https://github.com/nodejs/node/pull/8706)
* [[`9ecfc32fde`](https://github.com/nodejs/node/commit/9ecfc32fde)] - **deps**: upgrade npm to 3.10.8 (Kat Marchán) [#8706](https://github.com/nodejs/node/pull/8706)
* [[`c4d9b54f75`](https://github.com/nodejs/node/commit/c4d9b54f75)] - **dgram**: use Buffer.alloc(0) for zero-size buffers (Сковорода Никита Андреевич) [#8751](https://github.com/nodejs/node/pull/8751)
* [[`e1a774d314`](https://github.com/nodejs/node/commit/e1a774d314)] - **dns**: remove internal variable from makeAsync (yorkie) [#8800](https://github.com/nodejs/node/pull/8800)
* [[`787558935c`](https://github.com/nodejs/node/commit/787558935c)] - **dns**: tweak regex for IPv6 addresses (Luigi Pinca) [#8665](https://github.com/nodejs/node/pull/8665)
* [[`4e8c03707a`](https://github.com/nodejs/node/commit/4e8c03707a)] - **dns**: handle array holes in setServers() (cjihrig) [#8567](https://github.com/nodejs/node/pull/8567)
* [[`5e6be7b4c2`](https://github.com/nodejs/node/commit/5e6be7b4c2)] - **doc**: fix typo in email address in README (Rich Trott) [#8941](https://github.com/nodejs/node/pull/8941)
* [[`72ed6aa205`](https://github.com/nodejs/node/commit/72ed6aa205)] - **doc**: make node(1) more consistent with tradition (Alex Jordan) [#8902](https://github.com/nodejs/node/pull/8902)
* [[`2fad4d29b0`](https://github.com/nodejs/node/commit/2fad4d29b0)] - **doc**: add example for file existence with fs.stat (Christopn Noelke) [#8585](https://github.com/nodejs/node/pull/8585)
* [[`0bdc363205`](https://github.com/nodejs/node/commit/0bdc363205)] - **doc**: add `added:` information for globals (Luigi Pinca) [#8901](https://github.com/nodejs/node/pull/8901)
* [[`bc2dd3e467`](https://github.com/nodejs/node/commit/bc2dd3e467)] - **doc**: change ./node to node in debugger.md (AnnaMag) [#8943](https://github.com/nodejs/node/pull/8943)
* [[`b212b9b44b`](https://github.com/nodejs/node/commit/b212b9b44b)] - **doc**: add CTC meeting minutes 2016-09-07 (Josh Gavant) [#8499](https://github.com/nodejs/node/pull/8499)
* [[`c31a3178e8`](https://github.com/nodejs/node/commit/c31a3178e8)] - **doc**: fixup link in fs.md (ss22ever) [#8940](https://github.com/nodejs/node/pull/8940)
* [[`e7039cdbb8`](https://github.com/nodejs/node/commit/e7039cdbb8)] - **doc**: fix markdown formatting in url.md (Bryan Bess) [#8933](https://github.com/nodejs/node/pull/8933)
* [[`ff9a84d324`](https://github.com/nodejs/node/commit/ff9a84d324)] - **doc**: update punctuation in README.md (Abner Chou) [#8892](https://github.com/nodejs/node/pull/8892)
* [[`c36c8dc3cc`](https://github.com/nodejs/node/commit/c36c8dc3cc)] - **doc**: add documentation for test common module (Paul Grock) [#8840](https://github.com/nodejs/node/pull/8840)
* [[`a604a82186`](https://github.com/nodejs/node/commit/a604a82186)] - **doc**: recommend using port 0 instead of common.PORT (Niklas Ingholt) [#8694](https://github.com/nodejs/node/pull/8694)
* [[`77fc5caceb`](https://github.com/nodejs/node/commit/77fc5caceb)] - **doc**: add CTC meeting minutes 2016-09-14 (Josh Gavant) [#8726](https://github.com/nodejs/node/pull/8726)
* [[`505b88d3c3`](https://github.com/nodejs/node/commit/505b88d3c3)] - **doc**: add CTC meeting minutes 2016-09-21 (Josh Gavant) [#8727](https://github.com/nodejs/node/pull/8727)
* [[`3e8c8f90bc`](https://github.com/nodejs/node/commit/3e8c8f90bc)] - **doc**: fix typo in repl doc (Franziska Hinkelmann) [#8826](https://github.com/nodejs/node/pull/8826)
* [[`a00ae75805`](https://github.com/nodejs/node/commit/a00ae75805)] - **doc**: improve documentation for commit subject line (Luigi Pinca) [#8546](https://github.com/nodejs/node/pull/8546)
* [[`aaebbf9708`](https://github.com/nodejs/node/commit/aaebbf9708)] - **doc**: encourage 2FA before onboarding (Rich Trott) [#8776](https://github.com/nodejs/node/pull/8776)
* [[`f07054dd49`](https://github.com/nodejs/node/commit/f07054dd49)] - **doc**: add optional step to onboarding doc (Rich Trott) [#8774](https://github.com/nodejs/node/pull/8774)
* [[`dceaa0ba4a`](https://github.com/nodejs/node/commit/dceaa0ba4a)] - **doc**: remove failing workaround in BUILDING.md (Christopher Fujino) [#8763](https://github.com/nodejs/node/pull/8763)
* [[`0522aa0dc0`](https://github.com/nodejs/node/commit/0522aa0dc0)] - **doc**: add commit formats for release blog posts (fen) [#8631](https://github.com/nodejs/node/pull/8631)
* [[`98e425eed4`](https://github.com/nodejs/node/commit/98e425eed4)] - **doc**: fix title level at tls.md (yorkie) [#8782](https://github.com/nodejs/node/pull/8782)
* [[`e7c0f34f20`](https://github.com/nodejs/node/commit/e7c0f34f20)] - **doc**: add added: info for crypto.timingSafeEqual() (Marc-Aurèle DARCHE) [#8796](https://github.com/nodejs/node/pull/8796)
* [[`4fb051426c`](https://github.com/nodejs/node/commit/4fb051426c)] - **doc**: enable no-file-name-articles remark-lint rule (Сковорода Никита Андреевич) [#8713](https://github.com/nodejs/node/pull/8713)
* [[`4699e3022b`](https://github.com/nodejs/node/commit/4699e3022b)] - **doc**: enable first-heading-level remark-lint rule (Сковорода Никита Андреевич) [#8716](https://github.com/nodejs/node/pull/8716)
* [[`3aec6a68bf`](https://github.com/nodejs/node/commit/3aec6a68bf)] - **doc**: improve child_process doc types (yorkie) [#8741](https://github.com/nodejs/node/pull/8741)
* [[`6fab334a73`](https://github.com/nodejs/node/commit/6fab334a73)] - **doc**: fix example in stream doc (Luigi Pinca) [#8378](https://github.com/nodejs/node/pull/8378)
* [[`f13089b834`](https://github.com/nodejs/node/commit/f13089b834)] - **doc**: update BUILDING.md (rainabba) [#8704](https://github.com/nodejs/node/pull/8704)
* [[`5c014bb532`](https://github.com/nodejs/node/commit/5c014bb532)] - **doc**: standardize on `make -j8` (Rich Trott) [#8678](https://github.com/nodejs/node/pull/8678)
* [[`98ca442cae`](https://github.com/nodejs/node/commit/98ca442cae)] - **doc**: add CTC meeting minutes 2016-08-24 (Josh Gavant) [#8423](https://github.com/nodejs/node/pull/8423)
* [[`28264f8da4`](https://github.com/nodejs/node/commit/28264f8da4)] - **doc**: add eugeneo to collaborators (Eugene Ostroukhov) [#8696](https://github.com/nodejs/node/pull/8696)
* [[`85ee89edd6`](https://github.com/nodejs/node/commit/85ee89edd6)] - **doc**: add ak239 to collaborators (Aleksey Kozyatinskiy) [#8676](https://github.com/nodejs/node/pull/8676)
* [[`5dd6229aeb`](https://github.com/nodejs/node/commit/5dd6229aeb)] - **doc**: clarify fs.utimes() arguments (Danny Guo) [#8651](https://github.com/nodejs/node/pull/8651)
* [[`42386d7229`](https://github.com/nodejs/node/commit/42386d7229)] - **doc**: add link to help repo in README (Rich Trott) [#8570](https://github.com/nodejs/node/pull/8570)
* [[`2f6101ed10`](https://github.com/nodejs/node/commit/2f6101ed10)] - **doc**: fix broken link in timers doc (Ltrlg) [#8562](https://github.com/nodejs/node/pull/8562)
* [[`e16f95db4d`](https://github.com/nodejs/node/commit/e16f95db4d)] - **doc**: update exercise portion of onboarding doc (Rich Trott) [#8559](https://github.com/nodejs/node/pull/8559)
* [[`a91050c57b`](https://github.com/nodejs/node/commit/a91050c57b)] - **doc**: fix typo in path doc (Kalman Hazins) [#8527](https://github.com/nodejs/node/pull/8527)
* [[`64b79eba42`](https://github.com/nodejs/node/commit/64b79eba42)] - **doc**: remove extra comma in cluster docs (Teddy Katz) [#8557](https://github.com/nodejs/node/pull/8557)
* [[`2d23227060`](https://github.com/nodejs/node/commit/2d23227060)] - **doc**: fix a formatting error in buffer.md (Сковорода Никита Андреевич) [#8553](https://github.com/nodejs/node/pull/8553)
* [[`eebecef9a4`](https://github.com/nodejs/node/commit/eebecef9a4)] - **doc**: link onboarding to contributing guide (Rich Trott) [#8529](https://github.com/nodejs/node/pull/8529)
* [[`8a1f74338c`](https://github.com/nodejs/node/commit/8a1f74338c)] - **doc**: remove duplicate content from readline doc (Italo A. Casas) [#8497](https://github.com/nodejs/node/pull/8497)
* [[`71dd4c193a`](https://github.com/nodejs/node/commit/71dd4c193a)] - **doc**: capitalize arguments' type names in url doc (yorkie) [#8489](https://github.com/nodejs/node/pull/8489)
* [[`8e28e03fb9`](https://github.com/nodejs/node/commit/8e28e03fb9)] - **doc**: add gibfahn to collaborators (Gibson Fahnestock) [#8533](https://github.com/nodejs/node/pull/8533)
* [[`c96618f241`](https://github.com/nodejs/node/commit/c96618f241)] - **doc**: add imyller to collaborators (Ilkka Myller) [#8530](https://github.com/nodejs/node/pull/8530)
* [[`929d9bb222`](https://github.com/nodejs/node/commit/929d9bb222)] - **doc**: standardize rest parameters (Timothy Gu) [#8485](https://github.com/nodejs/node/pull/8485)
* [[`125df45b80`](https://github.com/nodejs/node/commit/125df45b80)] - **doc**: add not-an-aardvark to collaborators (not-an-aardvark) [#8525](https://github.com/nodejs/node/pull/8525)
* [[`3eb93e1fe8`](https://github.com/nodejs/node/commit/3eb93e1fe8)] - **doc**: add example for running with v8-inspector (Franziska Hinkelmann) [#8845](https://github.com/nodejs/node/pull/8845)
* [[`d6dcbc212b`](https://github.com/nodejs/node/commit/d6dcbc212b)] - **doc,tool**: add tls.TLSSocket to typeMap (yorkie) [#8742](https://github.com/nodejs/node/pull/8742)
* [[`d69570d5fc`](https://github.com/nodejs/node/commit/d69570d5fc)] - **doc,tool**: add ref to Integer (yorkie) [#8740](https://github.com/nodejs/node/pull/8740)
* [[`688abac7b2`](https://github.com/nodejs/node/commit/688abac7b2)] - **(SEMVER-MINOR)** **fs**: make `SyncWriteStream` inherit from `Writable` (Anna Henningsen) [#8830](https://github.com/nodejs/node/pull/8830)
* [[`07d97f4f3e`](https://github.com/nodejs/node/commit/07d97f4f3e)] - **fs**: fix handling of `uv_stat_t` fields (Anna Henningsen) [#8515](https://github.com/nodejs/node/pull/8515)
* [[`14e2d67776`](https://github.com/nodejs/node/commit/14e2d67776)] - **(SEMVER-MINOR)** **fs,doc**: undeprecate existsSync (Dan Fabulich) [#8364](https://github.com/nodejs/node/pull/8364)
* [[`980c1edf63`](https://github.com/nodejs/node/commit/980c1edf63)] - **(SEMVER-MINOR)** **fs,module**: add module-loader-only realpath cache (Anna Henningsen) [#8100](https://github.com/nodejs/node/pull/8100)
* [[`ee7af01b93`](https://github.com/nodejs/node/commit/ee7af01b93)] - **(SEMVER-MINOR)** **http**: socket connection timeout for http request (Rene Weber) [#8101](https://github.com/nodejs/node/pull/8101)
* [[`7a59449478`](https://github.com/nodejs/node/commit/7a59449478)] - **https**: fix memory leak with https.request() (Ilkka Myller) [#8647](https://github.com/nodejs/node/pull/8647)
* [[`573d8bcee4`](https://github.com/nodejs/node/commit/573d8bcee4)] - **inspector**: fix minor issues (Brian White) [#8890](https://github.com/nodejs/node/pull/8890)
* [[`f4f9cf779f`](https://github.com/nodejs/node/commit/f4f9cf779f)] - **inspector**: build file cleanup (Eugene Ostroukhov) [#8753](https://github.com/nodejs/node/pull/8753)
* [[`e80ae1350c`](https://github.com/nodejs/node/commit/e80ae1350c)] - **inspector**: address race conditions (Eugene Ostroukhov) [#8672](https://github.com/nodejs/node/pull/8672)
* [[`f817875235`](https://github.com/nodejs/node/commit/f817875235)] - **inspector**: wait for both sides closing (Eugene Ostroukhov) [#8505](https://github.com/nodejs/node/pull/8505)
* [[`4ed46b47a1`](https://github.com/nodejs/node/commit/4ed46b47a1)] - **inspector**: report default context (Eugene Ostroukhov) [#8502](https://github.com/nodejs/node/pull/8502)
* [[`b05ce842ce`](https://github.com/nodejs/node/commit/b05ce842ce)] - **inspector**: zero out structure members (Eugene Ostroukhov) [#8536](https://github.com/nodejs/node/pull/8536)
* [[`0b90ff7a8d`](https://github.com/nodejs/node/commit/0b90ff7a8d)] - **inspector**: introduce a smoke test (Eugene Ostroukhov) [#8429](https://github.com/nodejs/node/pull/8429)
* [[`3222b66abe`](https://github.com/nodejs/node/commit/3222b66abe)] - **inspector**: fix tests on Windows (Eugene Ostroukhov) [#8528](https://github.com/nodejs/node/pull/8528)
* [[`a1925a7955`](https://github.com/nodejs/node/commit/a1925a7955)] - **lib**: minor improvements to bootstrap_node.js (Rémy MEJA) [#8906](https://github.com/nodejs/node/pull/8906)
* [[`313a45da24`](https://github.com/nodejs/node/commit/313a45da24)] - **lib**: changed var to const in linkedlist (Adri Van Houdt) [#8609](https://github.com/nodejs/node/pull/8609)
* [[`6cd5588a67`](https://github.com/nodejs/node/commit/6cd5588a67)] - **lib**: fix TypeError in v8-polyfill (Wyatt Preul) [#8863](https://github.com/nodejs/node/pull/8863)
* [[`ba361a2aa0`](https://github.com/nodejs/node/commit/ba361a2aa0)] - **lib**: remove let from for loops (Myles Borins) [#8873](https://github.com/nodejs/node/pull/8873)
* [[`beb288b639`](https://github.com/nodejs/node/commit/beb288b639)] - **lib**: changed var to const in internal/v8_polyfill (Adri Van Houdt) [#8615](https://github.com/nodejs/node/pull/8615)
* [[`858a7bbacf`](https://github.com/nodejs/node/commit/858a7bbacf)] - **lib**: changed var to const in bootstrap_node.js (Adri Van Houdt) [#8588](https://github.com/nodejs/node/pull/8588)
* [[`31232adebb`](https://github.com/nodejs/node/commit/31232adebb)] - **module**: fix comment from "read-only" to "shallow" (Bryan English) [#8887](https://github.com/nodejs/node/pull/8887)
* [[`0eaf3ff53c`](https://github.com/nodejs/node/commit/0eaf3ff53c)] - **path**: fallback to process cwd when resolving drive cwd (Jason Ginchereau) [#8541](https://github.com/nodejs/node/pull/8541)
* [[`d72a7b3d0c`](https://github.com/nodejs/node/commit/d72a7b3d0c)] - **path**: fix path.relative UNC path result (Jason Ginchereau) [#8523](https://github.com/nodejs/node/pull/8523)
* [[`e0c10f63b0`](https://github.com/nodejs/node/commit/e0c10f63b0)] - **process**: changed var to const in internal/process.js (Adri Van Houdt) [#8614](https://github.com/nodejs/node/pull/8614)
* [[`37ce6da59a`](https://github.com/nodejs/node/commit/37ce6da59a)] - **process**: changed var to const in internal/v8_prof_processor (Adri Van Houdt) [#8619](https://github.com/nodejs/node/pull/8619)
* [[`e8f1cf1bd8`](https://github.com/nodejs/node/commit/e8f1cf1bd8)] - **process**: changed var to const in internal/process/promises (Adri Van Houdt) [#8620](https://github.com/nodejs/node/pull/8620)
* [[`4c194ee7bd`](https://github.com/nodejs/node/commit/4c194ee7bd)] - **readline**: fix `concievably` typo in readline.js (Miguel Angel Asencio Hurtado) [#8953](https://github.com/nodejs/node/pull/8953)
* [[`8c91a9b848`](https://github.com/nodejs/node/commit/8c91a9b848)] - **repl**: improve .help message (Roman Reiss) [#8519](https://github.com/nodejs/node/pull/8519)
* [[`443bedeb68`](https://github.com/nodejs/node/commit/443bedeb68)] - **src**: remove out-of-date TODO comment (Daniel Bevenius) [#9000](https://github.com/nodejs/node/pull/9000)
* [[`59aa103df2`](https://github.com/nodejs/node/commit/59aa103df2)] - **src**: fix typo in #endif comment (Juan Andres Andrango) [#8989](https://github.com/nodejs/node/pull/8989)
* [[`8a2ba6fe83`](https://github.com/nodejs/node/commit/8a2ba6fe83)] - **src**: fix build for older clang (Zach Bjornson) [#7645](https://github.com/nodejs/node/pull/7645)
* [[`d8df78c573`](https://github.com/nodejs/node/commit/d8df78c573)] - **src**: remove unused function declaration (Brian White) [#8878](https://github.com/nodejs/node/pull/8878)
* [[`a6b9ffbf5b`](https://github.com/nodejs/node/commit/a6b9ffbf5b)] - **src**: refactor reading of options in contextify (Franziska Hinkelmann) [#8850](https://github.com/nodejs/node/pull/8850)
* [[`324c8b5f7e`](https://github.com/nodejs/node/commit/324c8b5f7e)] - **src**: fixes misplaced comment (Madhav Gharmalkar) [#8860](https://github.com/nodejs/node/pull/8860)
* [[`86b9db601d`](https://github.com/nodejs/node/commit/86b9db601d)] - **src**: add missing length argument to send comment (Daniel Bevenius) [#8816](https://github.com/nodejs/node/pull/8816)
* [[`aa11205f71`](https://github.com/nodejs/node/commit/aa11205f71)] - **src**: rename CHECK_NOT_OOB() macro (Ben Noordhuis) [#8784](https://github.com/nodejs/node/pull/8784)
* [[`8be818eb07`](https://github.com/nodejs/node/commit/8be818eb07)] - **src**: fix minor typo in comments (Daniel Bevenius) [#8736](https://github.com/nodejs/node/pull/8736)
* [[`41ad6e3965`](https://github.com/nodejs/node/commit/41ad6e3965)] - **src**: rename handle__ to handle_ in HandleWrap (Daniel Bevenius) [#8712](https://github.com/nodejs/node/pull/8712)
* [[`9205edc35c`](https://github.com/nodejs/node/commit/9205edc35c)] - **src**: don't abort when c-ares initialization fails (Ben Noordhuis) [#8710](https://github.com/nodejs/node/pull/8710)
* [[`6ddfe89fdf`](https://github.com/nodejs/node/commit/6ddfe89fdf)] - **src**: remove VS 2013 compatibility hacks (Ben Noordhuis) [#8067](https://github.com/nodejs/node/pull/8067)
* [[`a9491f1604`](https://github.com/nodejs/node/commit/a9491f1604)] - **src**: make ReqWrap req_ member private (Daniel Bevenius) [#8532](https://github.com/nodejs/node/pull/8532)
* [[`5ebce30468`](https://github.com/nodejs/node/commit/5ebce30468)] - **src**: remove unneeded ABORT after CHECK (yorkie) [#8593](https://github.com/nodejs/node/pull/8593)
* [[`2dbef79ca7`](https://github.com/nodejs/node/commit/2dbef79ca7)] - **src**: handle thrown errors in CopyProperties() (cjihrig) [#8649](https://github.com/nodejs/node/pull/8649)
* [[`52f0f64e79`](https://github.com/nodejs/node/commit/52f0f64e79)] - **src**: use MaybeStackBuffer on DoSend/Writev (Paul Kiddie) [#8626](https://github.com/nodejs/node/pull/8626)
* [[`a62999ac70`](https://github.com/nodejs/node/commit/a62999ac70)] - **src**: add /json/protocol endpoint to inspector (Ben Noordhuis) [#7491](https://github.com/nodejs/node/pull/7491)
* [[`4e7c67cf55`](https://github.com/nodejs/node/commit/4e7c67cf55)] - **(SEMVER-MINOR)** **stream**: proper `instanceof` for `Writable`s (Anna Henningsen) [#8834](https://github.com/nodejs/node/pull/8834)
* [[`56951b4367`](https://github.com/nodejs/node/commit/56951b4367)] - **test**: add coverage for spawnSync() killSignal (cjihrig) [#8960](https://github.com/nodejs/node/pull/8960)
* [[`05f74120e8`](https://github.com/nodejs/node/commit/05f74120e8)] - **test**: refactor `assert` in internet test-dns.js (Junshu Okamoto) [#8980](https://github.com/nodejs/node/pull/8980)
* [[`1a4207d91d`](https://github.com/nodejs/node/commit/1a4207d91d)] - **test**: various test improvements (James M Snell) [#8468](https://github.com/nodejs/node/pull/8468)
* [[`c4f0bb237a`](https://github.com/nodejs/node/commit/c4f0bb237a)] - **test**: expand test coverage for url.js (Junshu Okamoto) [#8976](https://github.com/nodejs/node/pull/8976)
* [[`4e9b6a0022`](https://github.com/nodejs/node/commit/4e9b6a0022)] - **test**: fix test-child-process-fork-regr-gh-2847 (Santiago Gimeno) [#8954](https://github.com/nodejs/node/pull/8954)
* [[`b579fcab45`](https://github.com/nodejs/node/commit/b579fcab45)] - **test**: remove FIXME pummel/test-tls-securepair-client (Alfred Cepeda) [#8757](https://github.com/nodejs/node/pull/8757)
* [[`9b0733fd49`](https://github.com/nodejs/node/commit/9b0733fd49)] - **test**: run faster and cleanup after run (Wyatt Preul) [#8848](https://github.com/nodejs/node/pull/8848)
* [[`df0211d95e`](https://github.com/nodejs/node/commit/df0211d95e)] - **test**: refactor test-net-server-max-connections (Rich Trott) [#8931](https://github.com/nodejs/node/pull/8931)
* [[`147a06d4a5`](https://github.com/nodejs/node/commit/147a06d4a5)] - **test**: enable addons test to pass with debug build (Daniel Bevenius) [#8836](https://github.com/nodejs/node/pull/8836)
* [[`636026a22d`](https://github.com/nodejs/node/commit/636026a22d)] - **test**: remove blank lines at end of files (Rich Trott) [#8920](https://github.com/nodejs/node/pull/8920)
* [[`93c48743f1`](https://github.com/nodejs/node/commit/93c48743f1)] - **test**: refactor test-file-write-stream (Sudaraka Wijesinghe) [#8894](https://github.com/nodejs/node/pull/8894)
* [[`516486526f`](https://github.com/nodejs/node/commit/516486526f)] - **test**: cleanup/update test-dgram-empty-packet.js (Michael Macherey) [#8896](https://github.com/nodejs/node/pull/8896)
* [[`2f0f596e07`](https://github.com/nodejs/node/commit/2f0f596e07)] - **test**: fix child-process-uid-gid on Windows (Michaël Zasso) [#8924](https://github.com/nodejs/node/pull/8924)
* [[`52d0424c56`](https://github.com/nodejs/node/commit/52d0424c56)] - **test**: mark test-tick-processor-unknown flaky (Rich Trott) [#8900](https://github.com/nodejs/node/pull/8900)
* [[`424c126742`](https://github.com/nodejs/node/commit/424c126742)] - **test**: fix -Wformat warnings in inspector cctest (Ben Noordhuis) [#8034](https://github.com/nodejs/node/pull/8034)
* [[`76f80a3f74`](https://github.com/nodejs/node/commit/76f80a3f74)] - **test**: fix running child-process-uid-gid as root (Wyatt Preul) [#8864](https://github.com/nodejs/node/pull/8864)
* [[`11ba56c83d`](https://github.com/nodejs/node/commit/11ba56c83d)] - **test**: expand test coverage for url.js (Junshu Okamoto) [#8859](https://github.com/nodejs/node/pull/8859)
* [[`c9450cef1b`](https://github.com/nodejs/node/commit/c9450cef1b)] - **test**: clean up test-timers-immediate (Rich Trott) [#8857](https://github.com/nodejs/node/pull/8857)
* [[`17922de555`](https://github.com/nodejs/node/commit/17922de555)] - **test**: add and assert readable/writable arguments (Daniel Bevenius) [#8815](https://github.com/nodejs/node/pull/8815)
* [[`bc710ef461`](https://github.com/nodejs/node/commit/bc710ef461)] - **test**: cleanup/update test-os.js (Mike Woods) [#8761](https://github.com/nodejs/node/pull/8761)
* [[`fc42825530`](https://github.com/nodejs/node/commit/fc42825530)] - **test**: modernize syntax, add strict checks (Lydia Kats) [#8841](https://github.com/nodejs/node/pull/8841)
* [[`72de8594fe`](https://github.com/nodejs/node/commit/72de8594fe)] - **test**: use common.skip for tap skip output (Lydia Kats) [#8841](https://github.com/nodejs/node/pull/8841)
* [[`4fa0fc59cd`](https://github.com/nodejs/node/commit/4fa0fc59cd)] - **test**: stream writable ended state (Italo A. Casas) [#8778](https://github.com/nodejs/node/pull/8778)
* [[`6dbda6aa86`](https://github.com/nodejs/node/commit/6dbda6aa86)] - **test**: clean up test-buffer-badhex (Jeremiah Senkpiel) [#7773](https://github.com/nodejs/node/pull/7773)
* [[`af092f1fc0`](https://github.com/nodejs/node/commit/af092f1fc0)] - **test**: cleanup test-net-server-address.js (Akito Ito) [#8586](https://github.com/nodejs/node/pull/8586)
* [[`af84528d41`](https://github.com/nodejs/node/commit/af84528d41)] - **test**: replace indexOf, assert.equal, add mustCall() (Richard Hong) [#8766](https://github.com/nodejs/node/pull/8766)
* [[`2e95b0e24b`](https://github.com/nodejs/node/commit/2e95b0e24b)] - **test**: fixed FIXME in test-repl-persistent-history (Alfred Cepeda) [#8756](https://github.com/nodejs/node/pull/8756)
* [[`76fd7db521`](https://github.com/nodejs/node/commit/76fd7db521)] - **test**: update var to const, use arrow functions (Matt Lang) [#8595](https://github.com/nodejs/node/pull/8595)
* [[`5bd13a3d6c`](https://github.com/nodejs/node/commit/5bd13a3d6c)] - **test**: cleanup parallel/test-fs-readfile-unlink.js (nohmapp) [#8764](https://github.com/nodejs/node/pull/8764)
* [[`f523b82c7b`](https://github.com/nodejs/node/commit/f523b82c7b)] - **test**: cleanup parallel/test-file-write-stream2.js (Jenna Vuong) [#8770](https://github.com/nodejs/node/pull/8770)
* [[`9252e7a52d`](https://github.com/nodejs/node/commit/9252e7a52d)] - **test**: cleanup parallel/test-fs-realpath.js (mpmckenna8) [#8769](https://github.com/nodejs/node/pull/8769)
* [[`6ba8aa963e`](https://github.com/nodejs/node/commit/6ba8aa963e)] - **test**: changed var to const, added strict equal checks (Lydia Katsamberis) [#8762](https://github.com/nodejs/node/pull/8762)
* [[`81ed50c5da`](https://github.com/nodejs/node/commit/81ed50c5da)] - **test**: add assertions to zero length buffer test (Lauren Spiegel) [#8729](https://github.com/nodejs/node/pull/8729)
* [[`b2aea505df`](https://github.com/nodejs/node/commit/b2aea505df)] - **test**: use Buffer.alloc (Eugene Ostroukhov) [#8748](https://github.com/nodejs/node/pull/8748)
* [[`5e4d8984b4`](https://github.com/nodejs/node/commit/5e4d8984b4)] - **test**: accept expected AIX result test-stdio-closed (Rich Trott) [#8755](https://github.com/nodejs/node/pull/8755)
* [[`906283837f`](https://github.com/nodejs/node/commit/906283837f)] - **test**: skip cpu-intensive tests on slow hosts (Rich Trott) [#8652](https://github.com/nodejs/node/pull/8652)
* [[`aa5a16a8ae`](https://github.com/nodejs/node/commit/aa5a16a8ae)] - **test**: add expectWarning to common (Michaël Zasso) [#8662](https://github.com/nodejs/node/pull/8662)
* [[`b46d8cdcde`](https://github.com/nodejs/node/commit/b46d8cdcde)] - **test**: cleanup vars to const and '==' to '===' (oogz) [#8705](https://github.com/nodejs/node/pull/8705)
* [[`5540e3d488`](https://github.com/nodejs/node/commit/5540e3d488)] - **test**: fix test-cluster-worker-init.js flakyness (Ilkka Myller) [#8703](https://github.com/nodejs/node/pull/8703)
* [[`ed625fefd2`](https://github.com/nodejs/node/commit/ed625fefd2)] - **test**: add tests for add/remove header after sent (Niklas Ingholt) [#8682](https://github.com/nodejs/node/pull/8682)
* [[`e9d1426080`](https://github.com/nodejs/node/commit/e9d1426080)] - **test**: enable cyrillic punycode test case (Ben Noordhuis) [#8695](https://github.com/nodejs/node/pull/8695)
* [[`b62735a302`](https://github.com/nodejs/node/commit/b62735a302)] - **test**: remove call to `net.Socket.resume()` (Alfred Cepeda) [#8679](https://github.com/nodejs/node/pull/8679)
* [[`9ca8722203`](https://github.com/nodejs/node/commit/9ca8722203)] - **test**: cleanup stream tests (Italo A. Casas) [#8668](https://github.com/nodejs/node/pull/8668)
* [[`dfd022ff9e`](https://github.com/nodejs/node/commit/dfd022ff9e)] - **test**: update test/parallel/test-child-process-stdio.js (matzavinos) [#8584](https://github.com/nodejs/node/pull/8584)
* [[`fef4341f46`](https://github.com/nodejs/node/commit/fef4341f46)] - **test**: update test/parallel/test-eval.js (Pavol Otcenas) [#8590](https://github.com/nodejs/node/pull/8590)
* [[`43d6212257`](https://github.com/nodejs/node/commit/43d6212257)] - **test**: update test/parallel/test-child-process-send-utf8.js (Jonathan Prince) [#8594](https://github.com/nodejs/node/pull/8594)
* [[`6924a4d237`](https://github.com/nodejs/node/commit/6924a4d237)] - **test**: update test/parallel/test-fs-read.js (Richard Walker) [#8596](https://github.com/nodejs/node/pull/8596)
* [[`1b494d3b96`](https://github.com/nodejs/node/commit/1b494d3b96)] - **test**: fixup parallel/test-async-wrap-post-did-throw.js (Jermaine Oppong) [#8625](https://github.com/nodejs/node/pull/8625)
* [[`edf9242f56`](https://github.com/nodejs/node/commit/edf9242f56)] - **test**: cleanup test-os.js (delvedor) [#8606](https://github.com/nodejs/node/pull/8606)
* [[`d4ad8d9619`](https://github.com/nodejs/node/commit/d4ad8d9619)] - **test**: refactor test-dgram-bind-shared-ports.js (Fikret Burak Gazioglu) [#8582](https://github.com/nodejs/node/pull/8582)
* [[`714cbfd46c`](https://github.com/nodejs/node/commit/714cbfd46c)] - **test**: update test-child-process-recv-handle (Jonathan Prince) [#8648](https://github.com/nodejs/node/pull/8648)
* [[`c664109c72`](https://github.com/nodejs/node/commit/c664109c72)] - **test**: improve test-child-process-stdout-flush (Wietse Venema) [#8581](https://github.com/nodejs/node/pull/8581)
* [[`c98d0c984d`](https://github.com/nodejs/node/commit/c98d0c984d)] - **test**: cleanup test-child-process-exec-env.js (Yevgen Safronov) [#8600](https://github.com/nodejs/node/pull/8600)
* [[`3269a7d6f5`](https://github.com/nodejs/node/commit/3269a7d6f5)] - **test**: cleanup test-tls-connect-given-socket.js (Thomas van Lankveld) [#8616](https://github.com/nodejs/node/pull/8616)
* [[`5e5a1c0e3c`](https://github.com/nodejs/node/commit/5e5a1c0e3c)] - **test**: cleanup test-child-process-buffering.js (Adri Van Houdt) [#8578](https://github.com/nodejs/node/pull/8578)
* [[`bcba27e8c6`](https://github.com/nodejs/node/commit/bcba27e8c6)] - **test**: update test-cluster-disconnect-unshared-udp (matt-in-a-hat) [#8599](https://github.com/nodejs/node/pull/8599)
* [[`5a59ca6168`](https://github.com/nodejs/node/commit/5a59ca6168)] - **test**: changing equal to strictEqual in path (lrlna) [#8628](https://github.com/nodejs/node/pull/8628)
* [[`3ddf77fc24`](https://github.com/nodejs/node/commit/3ddf77fc24)] - **test**: modernize js and tighten equality checking (Pavol Otcenas) [#8618](https://github.com/nodejs/node/pull/8618)
* [[`34f24e559d`](https://github.com/nodejs/node/commit/34f24e559d)] - **test**: refactor parallel/test-tcp-wrap-listen (scott stern) [#8640](https://github.com/nodejs/node/pull/8640)
* [[`6fb8ebd98c`](https://github.com/nodejs/node/commit/6fb8ebd98c)] - **test**: cleanup cluster-disconnect-unshared-tcp test (Rachel) [#8598](https://github.com/nodejs/node/pull/8598)
* [[`fd7f87ef40`](https://github.com/nodejs/node/commit/fd7f87ef40)] - **test**: var variables to const in zlib (Ishan Aditya) [#8627](https://github.com/nodejs/node/pull/8627)
* [[`fc6b4970b5`](https://github.com/nodejs/node/commit/fc6b4970b5)] - **test**: modernize JS and tighten equality checking (Pavol Otcenas) [#8580](https://github.com/nodejs/node/pull/8580)
* [[`f2f6353bc4`](https://github.com/nodejs/node/commit/f2f6353bc4)] - **test**: cleanup test-intl.js (Alessandro Metta) [#8641](https://github.com/nodejs/node/pull/8641)
* [[`14025db8c5`](https://github.com/nodejs/node/commit/14025db8c5)] - **test**: cleanup test-child-process-disconnect.js (Pavol Otcenas) [#8602](https://github.com/nodejs/node/pull/8602)
* [[`9032ba60a5`](https://github.com/nodejs/node/commit/9032ba60a5)] - **test**: replace var by const test-tls-zero-clear-in (Sébastien Barbieri) [#8621](https://github.com/nodejs/node/pull/8621)
* [[`1aa1740f12`](https://github.com/nodejs/node/commit/1aa1740f12)] - **test**: improve coverage of the util module (Michaël Zasso) [#8633](https://github.com/nodejs/node/pull/8633)
* [[`28d009be76`](https://github.com/nodejs/node/commit/28d009be76)] - **test**: refactored test-crypto-random.js (Tobias Kahse) [#8632](https://github.com/nodejs/node/pull/8632)
* [[`a89deb9c59`](https://github.com/nodejs/node/commit/a89deb9c59)] - **test**: cleanup test-c-ares.js (Yevgen Safronov) [#8577](https://github.com/nodejs/node/pull/8577)
* [[`9c3d521d90`](https://github.com/nodejs/node/commit/9c3d521d90)] - **test**: improve child_process tests (Dennis Schwartz) [#8617](https://github.com/nodejs/node/pull/8617)
* [[`ba88f5b8f8`](https://github.com/nodejs/node/commit/ba88f5b8f8)] - **test**: improve coverage of the buffer module (Michaël Zasso) [#8552](https://github.com/nodejs/node/pull/8552)
* [[`b10467cde2`](https://github.com/nodejs/node/commit/b10467cde2)] - **test**: improve test-https-agent.js (Dan.Williams) [#8517](https://github.com/nodejs/node/pull/8517)
* [[`82b7894d3b`](https://github.com/nodejs/node/commit/82b7894d3b)] - **test**: make test-tick-processor.js non-flaky (Fedor Indutny) [#8542](https://github.com/nodejs/node/pull/8542)
* [[`30e995f714`](https://github.com/nodejs/node/commit/30e995f714)] - **test**: add coverage for `client._addHandle()` (Rich Trott) [#8518](https://github.com/nodejs/node/pull/8518)
* [[`ff238c8d15`](https://github.com/nodejs/node/commit/ff238c8d15)] - **test**: fix flaky test-force-repl (Rich Trott) [#8484](https://github.com/nodejs/node/pull/8484)
* [[`83ed5085f4`](https://github.com/nodejs/node/commit/83ed5085f4)] - **test**: mark test-inspector flaky on windows (Rich Trott) [#8835](https://github.com/nodejs/node/pull/8835)
* [[`5a7dd18699`](https://github.com/nodejs/node/commit/5a7dd18699)] - **test,benchmark**: fix lint errors on v6.x (Jeremiah Senkpiel) [#9029](https://github.com/nodejs/node/pull/9029)
* [[`4492cc3e25`](https://github.com/nodejs/node/commit/4492cc3e25)] - **test,lib**: align arguments in multiline calls (Rich Trott) [#8642](https://github.com/nodejs/node/pull/8642)
* [[`3a72a606cb`](https://github.com/nodejs/node/commit/3a72a606cb)] - **timers**: improve setImmediate() performance (Brian White) [#8655](https://github.com/nodejs/node/pull/8655)
* [[`06c411753e`](https://github.com/nodejs/node/commit/06c411753e)] - **timers**: improve setTimeout/Interval performance (Brian White) [#8661](https://github.com/nodejs/node/pull/8661)
* [[`02da155e4b`](https://github.com/nodejs/node/commit/02da155e4b)] - **timers**: remove unreachable code (yorkie) [#8487](https://github.com/nodejs/node/pull/8487)
* [[`cf92be6939`](https://github.com/nodejs/node/commit/cf92be6939)] - **tls**: TLSSocket emits 'error' on handshake failure (Mariusz 'koder' Chwalba) [#8805](https://github.com/nodejs/node/pull/8805)
* [[`bee1955f4e`](https://github.com/nodejs/node/commit/bee1955f4e)] - **tls**: handle `error` events with `_tlsError` (Fedor Indutny) [#8889](https://github.com/nodejs/node/pull/8889)
* [[`d2eaa12a23`](https://github.com/nodejs/node/commit/d2eaa12a23)] - **tls**: improve createSecureContext in `_tls_common` (yorkie) [#8781](https://github.com/nodejs/node/pull/8781)
* [[`b0234e7968`](https://github.com/nodejs/node/commit/b0234e7968)] - **tls**: add 'new' keyword for Array constructor call (Mike Ralphson) [#8514](https://github.com/nodejs/node/pull/8514)
* [[`58c55108d2`](https://github.com/nodejs/node/commit/58c55108d2)] - **tools**: disallow extra blank lines at EOF/BOF (Rich Trott) [#8920](https://github.com/nodejs/node/pull/8920)
* [[`336d505dd9`](https://github.com/nodejs/node/commit/336d505dd9)] - **tools**: enable more remark-lint rules (Сковорода Никита Андреевич) [#8708](https://github.com/nodejs/node/pull/8708)
* [[`0310655cda`](https://github.com/nodejs/node/commit/0310655cda)] - **tools**: update remark configuration (Сковорода Никита Андреевич) [#8666](https://github.com/nodejs/node/pull/8666)
* [[`5c6284a417`](https://github.com/nodejs/node/commit/5c6284a417)] - **tools**: add additional ESLint rules (Teddy Katz) [#8643](https://github.com/nodejs/node/pull/8643)
* [[`73d54a6fc7`](https://github.com/nodejs/node/commit/73d54a6fc7)] - **tools**: add eslint rule prefer-assert-methods (Dany Shaanan) [#8622](https://github.com/nodejs/node/pull/8622)
* [[`ac6927f549`](https://github.com/nodejs/node/commit/ac6927f549)] - **tools**: make argument alignment linting more strict (Rich Trott) [#8642](https://github.com/nodejs/node/pull/8642)
* [[`8684cea9b7`](https://github.com/nodejs/node/commit/8684cea9b7)] - **tools**: make sure links are correctly passed to marked (Timothy Gu) [#8494](https://github.com/nodejs/node/pull/8494)
* [[`a12ff5cc5d`](https://github.com/nodejs/node/commit/a12ff5cc5d)] - **tools**: clean up icu/README.md formatting (Сковорода Никита Андреевич) [#8660](https://github.com/nodejs/node/pull/8660)
* [[`fc68b12bc3`](https://github.com/nodejs/node/commit/fc68b12bc3)] - **(SEMVER-MINOR)** **util**: Add format for SharedArrayBuffer (Yosuke Furukawa) [#8587](https://github.com/nodejs/node/pull/8587)
* [[`38be15549e`](https://github.com/nodejs/node/commit/38be15549e)] - **util**: don't init Debug if it's not needed yet (Bryan English) [#8452](https://github.com/nodejs/node/pull/8452)
* [[`7728f95967`](https://github.com/nodejs/node/commit/7728f95967)] - **util**: simplify SIMD setup (Dany Shaanan) [#8579](https://github.com/nodejs/node/pull/8579)
* [[`8282d6fc60`](https://github.com/nodejs/node/commit/8282d6fc60)] - **vm**: add error message if we abort (Franziska Hinkelmann) [#8634](https://github.com/nodejs/node/pull/8634)
* [[`b83f51a326`](https://github.com/nodejs/node/commit/b83f51a326)] - **win,msi**: mark INSTALLDIR property as secure (João Reis) [#8795](https://github.com/nodejs/node/pull/8795)
* [[`623d3c6eb5`](https://github.com/nodejs/node/commit/623d3c6eb5)] - **win,tools**: ignore linting for line breaks (João Reis) [#8785](https://github.com/nodejs/node/pull/8785)
* [[`7403aaa13f`](https://github.com/nodejs/node/commit/7403aaa13f)] - **zlib**: tighten up dictionary tests (Tarjei Husøy) [#8512](https://github.com/nodejs/node/pull/8512)
* [[`15474951a5`](https://github.com/nodejs/node/commit/15474951a5)] - **zlib**: fix raw inflate with custom dictionary (Tarjei Husøy) [#8512](https://github.com/nodejs/node/pull/8512)

<a id="6.7.0"></a>
## 2016-09-27, Version 6.7.0 (Current), @evanlucas

This is a security release. All Node.js users should consult the security release summary at https://nodejs.org/en/blog/vulnerability/september-2016-security-releases/ for details on patched vulnerabilities.

### Notable changes

Semver Minor:

* **openssl**:
  - Upgrade to 1.0.2i, fixes a number of defects impacting Node.js: CVE-2016-6304 ("OCSP Status Request extension unbounded memory growth", high severity), CVE-2016-2183, CVE-2016-2178 and CVE-2016-6306. (Shigeki Ohtsu) [#8714](https://github.com/nodejs/node/pull/8714)
  - Upgrade to 1.0.2j, fixes a defect included in 1.0.2i resulting in a crash when using CRLs, CVE-2016-7052. (Shigeki Ohtsu) [#8786](https://github.com/nodejs/node/pull/8786)
  - Remove support for loading dynamic third-party engine modules. An attacker may be able to hide malicious code to be inserted into Node.js at runtime by masquerading as one of the dynamic engine modules. Originally reported by Ahmed Zaki (Skype). (Ben Noordhuis) [nodejs/node-private#73](https://github.com/nodejs/node-private/pull/73)
* **http**: CVE-2016-5325 - Properly validate for allowable characters in the `reason` argument in `ServerResponse#writeHead()`. Fixes a possible response splitting attack vector. This introduces a new case where `throw` may occur when configuring HTTP responses, users should already be adopting try/catch here. Originally reported independently by Evan Lucas and Romain Gaucher. (Evan Lucas) [nodejs/node-private#60](https://github.com/nodejs/node-private/pull/60)

Semver Patch:

* **buffer**: Zero-fill excess bytes in new `Buffer` objects created with `Buffer.concat()` while providing a `totalLength` parameter that exceeds the total length of the original `Buffer` objects being concatenated. (Сковорода Никита Андреевич) [nodejs/node-private#64](https://github.com/nodejs/node-private/pull/64)
* **src**: Fix regression where passing an empty password and/or salt to crypto.pbkdf2() would cause a fatal error (Rich Trott) [#8572](https://github.com/nodejs/node/pull/8572)
* **tls**: CVE-2016-7099 - Fix invalid wildcard certificate validation check whereby a TLS server may be able to serve an invalid wildcard certificate for its hostname due to improper validation of `*.` in the wildcard string. Originally reported by Alexander Minozhenko and James Bunton (Atlassian). (Ben Noordhuis) [nodejs/node-private#75](https://github.com/nodejs/node-private/pull/75)
* **v8**: Fix regression where a regex on a frozen object was broken (Myles Borins) [#8673](https://github.com/nodejs/node/pull/8673)

### Commits

* [[`8fb8c46303`](https://github.com/nodejs/node/commit/8fb8c46303)] - **buffer**: zero-fill uninitialized bytes in .concat() (Сковорода Никита Андреевич) [nodejs/node-private#64](https://github.com/nodejs/node-private/pull/64)
* [[`e5998c44b4`](https://github.com/nodejs/node/commit/e5998c44b4)] - **crypto**: don't build hardware engines (Ben Noordhuis) [nodejs/node-private#73](https://github.com/nodejs/node-private/pull/73)
* [[`ed4cd2eebe`](https://github.com/nodejs/node/commit/ed4cd2eebe)] - **deps**: cherry-pick 34880eb3dc from V8 upstream (Myles Borins) [#8673](https://github.com/nodejs/node/pull/8673)
* [[`f8ad0dc0e2`](https://github.com/nodejs/node/commit/f8ad0dc0e2)] - **deps**: add -no_rand_screen to openssl s_client (Shigeki Ohtsu) [nodejs/io.js#1836](https://github.com/nodejs/io.js/pull/1836)
* [[`9181def9d4`](https://github.com/nodejs/node/commit/9181def9d4)] - **deps**: fix asm build error of openssl in x86_win32 (Shigeki Ohtsu) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`2dee4af5c3`](https://github.com/nodejs/node/commit/2dee4af5c3)] - **deps**: fix openssl assembly error on ia32 win32 (Fedor Indutny) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`4255dc82a9`](https://github.com/nodejs/node/commit/4255dc82a9)] - **deps**: copy all openssl header files to include dir (Shigeki Ohtsu) [#8786](https://github.com/nodejs/node/pull/8786)
* [[`c08d81df50`](https://github.com/nodejs/node/commit/c08d81df50)] - **deps**: upgrade openssl sources to 1.0.2j (Shigeki Ohtsu) [#8786](https://github.com/nodejs/node/pull/8786)
* [[`2573efc9df`](https://github.com/nodejs/node/commit/2573efc9df)] - **deps**: update openssl asm and asm_obsolete files (Shigeki Ohtsu) [#8714](https://github.com/nodejs/node/pull/8714)
* [[`67751f3d7e`](https://github.com/nodejs/node/commit/67751f3d7e)] - **deps**: add -no_rand_screen to openssl s_client (Shigeki Ohtsu) [nodejs/io.js#1836](https://github.com/nodejs/io.js/pull/1836)
* [[`4382de338b`](https://github.com/nodejs/node/commit/4382de338b)] - **deps**: fix asm build error of openssl in x86_win32 (Shigeki Ohtsu) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`cfa00611b0`](https://github.com/nodejs/node/commit/cfa00611b0)] - **deps**: fix openssl assembly error on ia32 win32 (Fedor Indutny) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`3e4ea603b3`](https://github.com/nodejs/node/commit/3e4ea603b3)] - **deps**: copy all openssl header files to include dir (Shigeki Ohtsu) [#8714](https://github.com/nodejs/node/pull/8714)
* [[`8937fd0dbb`](https://github.com/nodejs/node/commit/8937fd0dbb)] - **deps**: upgrade openssl sources to 1.0.2i (Shigeki Ohtsu) [#8714](https://github.com/nodejs/node/pull/8714)
* [[`c0f13e56a2`](https://github.com/nodejs/node/commit/c0f13e56a2)] - **http**: check reason chars in writeHead (Evan Lucas) [nodejs/node-private#60](https://github.com/nodejs/node-private/pull/60)
* [[`743f0c9164`](https://github.com/nodejs/node/commit/743f0c9164)] - **lib**: make tls.checkServerIdentity() more strict (Ben Noordhuis) [nodejs/node-private#75](https://github.com/nodejs/node-private/pull/75)
* [[`38bed98a92`](https://github.com/nodejs/node/commit/38bed98a92)] - **openssl**: fix keypress requirement in apps on win32 (Shigeki Ohtsu) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`a25fc3f715`](https://github.com/nodejs/node/commit/a25fc3f715)] - **openssl**: fix keypress requirement in apps on win32 (Shigeki Ohtsu) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`5902ba3989`](https://github.com/nodejs/node/commit/5902ba3989)] - **src**: Malloc/Calloc size 0 returns non-null pointer (Rich Trott) [#8572](https://github.com/nodejs/node/pull/8572)
* [[`a14d832884`](https://github.com/nodejs/node/commit/a14d832884)] - **test**: remove openssl options of -no_<prot> (Shigeki Ohtsu) [#8714](https://github.com/nodejs/node/pull/8714)

<a id="6.6.0"></a>
## 2016-09-14, Version 6.6.0 (Current), @Fishrock123

### Notable changes

* **crypto**: Added `crypto.timingSafeEqual()`. (not-an-aardvark) [#8304](https://github.com/nodejs/node/pull/8304)
* **events**: Made the "max event listeners" memory leak warning more accessible. (Anna Henningsen) [#8298](https://github.com/nodejs/node/pull/8298)
* **promises**: Unhandled rejections now emit a [process warning](https://nodejs.org/dist/latest-v6.x/docs/api/process.html#process_event_warning) after the first tick. (Benjamin Gruenbaum) [#8223](https://github.com/nodejs/node/pull/8223)
* **repl**: Added auto alignment for `.editor` mode. (Prince J Wesley) [#8241](https://github.com/nodejs/node/pull/8241)
* **util**: Some functionality has been added to `util.inspect()`:
  - Returning `this` from a custom inspect function now works. (Anna Henningsen) [#8174](https://github.com/nodejs/node/pull/8174)
  - Added support for Symbol-based custom inspection methods. (Anna Henningsen) [#8174](https://github.com/nodejs/node/pull/8174)

### Commits

* [[`2ecc8c4c23`](https://github.com/nodejs/node/commit/2ecc8c4c23)] - **async_wrap**: add a missing case to test-async-wrap-throw-no-init (yorkie) [#8198](https://github.com/nodejs/node/pull/8198)
* [[`00f4bc3105`](https://github.com/nodejs/node/commit/00f4bc3105)] - **benchmark**: add benches for fs.stat & fs.statSync (Anna Henningsen) [#8338](https://github.com/nodejs/node/pull/8338)
* [[`7cc1391287`](https://github.com/nodejs/node/commit/7cc1391287)] - **benchmark**: fix off-by-one error in fs benchmarks (Anna Henningsen) [#8338](https://github.com/nodejs/node/pull/8338)
* [[`6e3db283ed`](https://github.com/nodejs/node/commit/6e3db283ed)] - **buffer**: fix ArrayBuffer checks (Brian White) [#8453](https://github.com/nodejs/node/pull/8453)
* [[`dd51b1f428`](https://github.com/nodejs/node/commit/dd51b1f428)] - **buffer,string_decoder**: consolidate encoding validation logic (James M Snell) [#7207](https://github.com/nodejs/node/pull/7207)
* [[`a830e37dc9`](https://github.com/nodejs/node/commit/a830e37dc9)] - **build**: don't require processing docs for nightlies (Johan Bergström) [#8325](https://github.com/nodejs/node/pull/8325)
* [[`836bfc188b`](https://github.com/nodejs/node/commit/836bfc188b)] - **build**: fix dependencies on AIX (Michael Dawson) [#8285](https://github.com/nodejs/node/pull/8285)
* [[`bc9d2fb543`](https://github.com/nodejs/node/commit/bc9d2fb543)] - **build**: fix dependencies on AIX (Michael Dawson) [#8272](https://github.com/nodejs/node/pull/8272)
* [[`206b105b1e`](https://github.com/nodejs/node/commit/206b105b1e)] - **build**: add missing files to zip and 7z packages (Richard Lau) [#8069](https://github.com/nodejs/node/pull/8069)
* [[`afb9917f16`](https://github.com/nodejs/node/commit/afb9917f16)] - **(SEMVER-MINOR)** **crypto**: add crypto.timingSafeEqual() (not-an-aardvark) [#8304](https://github.com/nodejs/node/pull/8304)
* [[`1640e7a4da`](https://github.com/nodejs/node/commit/1640e7a4da)] - **crypto**: fix getDecoder() encoding check (atstojanov) [#8301](https://github.com/nodejs/node/pull/8301)
* [[`49f996f4f6`](https://github.com/nodejs/node/commit/49f996f4f6)] - **crypto**: make malloc failure check cross-platform (Rich Trott) [#8352](https://github.com/nodejs/node/pull/8352)
* [[`9c460d7475`](https://github.com/nodejs/node/commit/9c460d7475)] - **deps**: add back no-op harmony shipping flags (Ali Ijaz Sheikh) [#8445](https://github.com/nodejs/node/pull/8445)
* [[`c8bcf1b591`](https://github.com/nodejs/node/commit/c8bcf1b591)] - **deps**: workaround clang-3.4 ICE (Ali Ijaz Sheikh) [#8343](https://github.com/nodejs/node/pull/8343)
* [[`ac3471ca23`](https://github.com/nodejs/node/commit/ac3471ca23)] - **deps**: v8_inspector update (Eugene Ostroukhov) [#8150](https://github.com/nodejs/node/pull/8150)
* [[`f829660c71`](https://github.com/nodejs/node/commit/f829660c71)] - **deps**: cherry-pick 8ed65b97 from V8's upstream (Anna Henningsen) [#8411](https://github.com/nodejs/node/pull/8411)
* [[`c48cb2de48`](https://github.com/nodejs/node/commit/c48cb2de48)] - **doc**: link SIGTSTP / SIGCONT events in readline doc (Italo A. Casas) [#8475](https://github.com/nodejs/node/pull/8475)
* [[`ce1a46c02d`](https://github.com/nodejs/node/commit/ce1a46c02d)] - **doc**: update onboarding PR landing info (Rich Trott) [#8479](https://github.com/nodejs/node/pull/8479)
* [[`92acff82ea`](https://github.com/nodejs/node/commit/92acff82ea)] - **doc**: add CTC meeting minutes 2016-08-31 (Josh Gavant) [#8424](https://github.com/nodejs/node/pull/8424)
* [[`53877357fc`](https://github.com/nodejs/node/commit/53877357fc)] - **doc**: fix link on timers.md (yorkie) [#8488](https://github.com/nodejs/node/pull/8488)
* [[`09da5756e5`](https://github.com/nodejs/node/commit/09da5756e5)] - **doc**: add `added:` information for crypto (Luigi Pinca) [#8281](https://github.com/nodejs/node/pull/8281)
* [[`19df5cef3b`](https://github.com/nodejs/node/commit/19df5cef3b)] - **doc**: fix example in repl documentation (Franziska Hinkelmann) [#8469](https://github.com/nodejs/node/pull/8469)
* [[`3ce6eaa3b9`](https://github.com/nodejs/node/commit/3ce6eaa3b9)] - **doc**: note that listening on SIGSEGV & co is unsafe (Anna Henningsen) [#8410](https://github.com/nodejs/node/pull/8410)
* [[`c7771e6fbc`](https://github.com/nodejs/node/commit/c7771e6fbc)] - **doc**: clarify sentence in event loop doc (Luigi Pinca) [#8400](https://github.com/nodejs/node/pull/8400)
* [[`2c45782b12`](https://github.com/nodejs/node/commit/2c45782b12)] - **doc**: add CI help/support info to onboarding doc (Rich Trott) [#8407](https://github.com/nodejs/node/pull/8407)
* [[`cffe7b731d`](https://github.com/nodejs/node/commit/cffe7b731d)] - **doc**: add 2016-08-17 CTC meeting minutes (Josh Gavant) [#8245](https://github.com/nodejs/node/pull/8245)
* [[`fdd59cc04c`](https://github.com/nodejs/node/commit/fdd59cc04c)] - **doc**: update BUILDING.md (Rich Trott) [#8398](https://github.com/nodejs/node/pull/8398)
* [[`d0a92be798`](https://github.com/nodejs/node/commit/d0a92be798)] - **doc**: add 2016-08-10 CTC meeting minutes (Josh Gavant) [#8229](https://github.com/nodejs/node/pull/8229)
* [[`ca31187087`](https://github.com/nodejs/node/commit/ca31187087)] - **doc**: update CI content in onboarding doc (Rich Trott) [#8374](https://github.com/nodejs/node/pull/8374)
* [[`44983b1fdc`](https://github.com/nodejs/node/commit/44983b1fdc)] - **doc**: update authors list (James M Snell) [#8346](https://github.com/nodejs/node/pull/8346)
* [[`ee83f5d541`](https://github.com/nodejs/node/commit/ee83f5d541)] - **doc**: add return type of clientRequest.setTimeout (Mike Ralphson) [#8356](https://github.com/nodejs/node/pull/8356)
* [[`1695c84240`](https://github.com/nodejs/node/commit/1695c84240)] - **doc**: fix a wrong link,add '.md' to the link (Alexis374) [#8315](https://github.com/nodejs/node/pull/8315)
* [[`65096de443`](https://github.com/nodejs/node/commit/65096de443)] - **doc**: fix typos (Mike Ralphson) [#8370](https://github.com/nodejs/node/pull/8370)
* [[`6d421a2ee2`](https://github.com/nodejs/node/commit/6d421a2ee2)] - **doc**: fix broken link in dgram doc (Brian White) [#8365](https://github.com/nodejs/node/pull/8365)
* [[`fbabd36de9`](https://github.com/nodejs/node/commit/fbabd36de9)] - **doc**: update targos email in readme per request (James M Snell) [#8389](https://github.com/nodejs/node/pull/8389)
* [[`76a3050c34`](https://github.com/nodejs/node/commit/76a3050c34)] - **doc**: update landing pr info in onboarding doc (Rich Trott) [#8344](https://github.com/nodejs/node/pull/8344)
* [[`372e4f3f79`](https://github.com/nodejs/node/commit/372e4f3f79)] - **doc**: bad/better examples for fs.access() and fs.exists() (Dan Fabulich) [#7832](https://github.com/nodejs/node/pull/7832)
* [[`9f18878eee`](https://github.com/nodejs/node/commit/9f18878eee)] - **doc**: fix typo in stream doc (Hubert Mine) [#8326](https://github.com/nodejs/node/pull/8326)
* [[`59e96bb1af`](https://github.com/nodejs/node/commit/59e96bb1af)] - **doc**: adding danbev to collaborators (Daniel Bevenius) [#8359](https://github.com/nodejs/node/pull/8359)
* [[`b553e57f5f`](https://github.com/nodejs/node/commit/b553e57f5f)] - **doc**: clarify that path on windows accepts / and \ (James M Snell) [#8291](https://github.com/nodejs/node/pull/8291)
* [[`feab3d4c25`](https://github.com/nodejs/node/commit/feab3d4c25)] - **doc**: add lpinca to collaborators (Luigi Pinca) [#8331](https://github.com/nodejs/node/pull/8331)
* [[`d2b2abe9d9`](https://github.com/nodejs/node/commit/d2b2abe9d9)] - **doc**: doc that listen can be called multiple times (James M Snell) [#8294](https://github.com/nodejs/node/pull/8294)
* [[`54d76137cd`](https://github.com/nodejs/node/commit/54d76137cd)] - **doc**: readline write() is processed as input (James M Snell) [#8295](https://github.com/nodejs/node/pull/8295)
* [[`48be8bc4e1`](https://github.com/nodejs/node/commit/48be8bc4e1)] - **doc**: `'ipc'` is required with fork stdio option (James M Snell) [#8290](https://github.com/nodejs/node/pull/8290)
* [[`47ecd21133`](https://github.com/nodejs/node/commit/47ecd21133)] - **doc**: improve fs.truncate functions' documentation (Sakthipriyan Vairamani) [#7648](https://github.com/nodejs/node/pull/7648)
* [[`d565183c37`](https://github.com/nodejs/node/commit/d565183c37)] - **doc**: add `added:` information for modules (Luigi Pinca) [#8250](https://github.com/nodejs/node/pull/8250)
* [[`b6f5104145`](https://github.com/nodejs/node/commit/b6f5104145)] - **doc**: fix onReadable reentry after unshift called (Zwb) [#8200](https://github.com/nodejs/node/pull/8200)
* [[`93ac875d53`](https://github.com/nodejs/node/commit/93ac875d53)] - **doc**: add `added:` information for dgram (Luigi Pinca) [#8196](https://github.com/nodejs/node/pull/8196)
* [[`260663fbfa`](https://github.com/nodejs/node/commit/260663fbfa)] - **doc**: add Myles Borins to the CTC (Rod Vagg) [#8260](https://github.com/nodejs/node/pull/8260)
* [[`a7c21759d9`](https://github.com/nodejs/node/commit/a7c21759d9)] - **doc**: fix buf.readUIntBE, buf.readUIntLE examples (David Keeler) [#8240](https://github.com/nodejs/node/pull/8240)
* [[`e4fcf55701`](https://github.com/nodejs/node/commit/e4fcf55701)] - **doc**: fix "timout" typo in timeout (Fangshi He) [#8231](https://github.com/nodejs/node/pull/8231)
* [[`03f5297ccd`](https://github.com/nodejs/node/commit/03f5297ccd)] - **doc**: include the optional options parameter (Sakthipriyan Vairamani) [#7842](https://github.com/nodejs/node/pull/7842)
* [[`605db31fe7`](https://github.com/nodejs/node/commit/605db31fe7)] - **(SEMVER-MINOR)** **events**: make memory leak warning more accessible (Anna Henningsen) [#8298](https://github.com/nodejs/node/pull/8298)
* [[`fa4c4d655a`](https://github.com/nodejs/node/commit/fa4c4d655a)] - **http**: fix connection upgrade checks (Brian White) [#8238](https://github.com/nodejs/node/pull/8238)
* [[`b603ac24cb`](https://github.com/nodejs/node/commit/b603ac24cb)] - **inspector**: use script name for target title (Eugene Ostroukhov) [#8243](https://github.com/nodejs/node/pull/8243)
* [[`13a522ac39`](https://github.com/nodejs/node/commit/13a522ac39)] - **inspector**: make sure all messages are dispatched (Eugene Ostroukhov) [#8264](https://github.com/nodejs/node/pull/8264)
* [[`250a380231`](https://github.com/nodejs/node/commit/250a380231)] - **inspector**: simplify buffer management (Eugene Ostroukhov) [#8257](https://github.com/nodejs/node/pull/8257)
* [[`354166c061`](https://github.com/nodejs/node/commit/354166c061)] - **inspector**: use new inspector headers (Eugene Ostroukhov) [#8150](https://github.com/nodejs/node/pull/8150)
* [[`3ef8ba8bdc`](https://github.com/nodejs/node/commit/3ef8ba8bdc)] - **net**: make holding the buffer in memory more robust (Anna Henningsen) [#8252](https://github.com/nodejs/node/pull/8252)
* [[`180867d6a6`](https://github.com/nodejs/node/commit/180867d6a6)] - **(SEMVER-MINOR)** **promise**: warn on unhandled rejections (Benjamin Gruenbaum) [#8223](https://github.com/nodejs/node/pull/8223)
* [[`408308f2e6`](https://github.com/nodejs/node/commit/408308f2e6)] - **(SEMVER-MINOR)** **readline**: key interval delay for \r & \n (Prince J Wesley) [#8109](https://github.com/nodejs/node/pull/8109)
* [[`6f20f477c4`](https://github.com/nodejs/node/commit/6f20f477c4)] - **(SEMVER-MINOR)** **repl**: Auto alignment for .editor mode (Prince J Wesley) [#8241](https://github.com/nodejs/node/pull/8241)
* [[`0d24247e50`](https://github.com/nodejs/node/commit/0d24247e50)] - **src**: pull AfterConnect from pipe_wrap and tcp_wrap (Daniel Bevenius) [#8448](https://github.com/nodejs/node/pull/8448)
* [[`16202264d1`](https://github.com/nodejs/node/commit/16202264d1)] - **src**: remove unneeded Environment error methods (Ben Noordhuis) [#8427](https://github.com/nodejs/node/pull/8427)
* [[`8cbbb47e39`](https://github.com/nodejs/node/commit/8cbbb47e39)] - **src**: update f function call comment (Daniel Bevenius) [#8416](https://github.com/nodejs/node/pull/8416)
* [[`d1d1433b02`](https://github.com/nodejs/node/commit/d1d1433b02)] - **src**: normalize malloc, realloc (Michael Dawson) [#7564](https://github.com/nodejs/node/pull/7564)
* [[`2c2a21ab56`](https://github.com/nodejs/node/commit/2c2a21ab56)] - **src**: unbreak build when compiling against uclibc (Ben Noordhuis) [#8308](https://github.com/nodejs/node/pull/8308)
* [[`4e368c58ff`](https://github.com/nodejs/node/commit/4e368c58ff)] - **src**: moving f function call comment (Daniel Bevenius) [#8405](https://github.com/nodejs/node/pull/8405)
* [[`0f2c619f55`](https://github.com/nodejs/node/commit/0f2c619f55)] - **src**: avoid duplicate AtExit functions (Ali Ijaz Sheikh) [#8273](https://github.com/nodejs/node/pull/8273)
* [[`3358861470`](https://github.com/nodejs/node/commit/3358861470)] - **test**: refector parallel/test-http.js (Junshu Okamoto) [#8471](https://github.com/nodejs/node/pull/8471)
* [[`2ce364ad10`](https://github.com/nodejs/node/commit/2ce364ad10)] - **test**: modernize JS and tighten equality checking (Peter Ogilvie) [#8476](https://github.com/nodejs/node/pull/8476)
* [[`1a30fe563d`](https://github.com/nodejs/node/commit/1a30fe563d)] - **test**: swapped == and equal to === and strictEqual (Christopher Dunavan) [#8472](https://github.com/nodejs/node/pull/8472)
* [[`d2b6b66037`](https://github.com/nodejs/node/commit/d2b6b66037)] - **test**: refactor test-net-pipe-connect-errors (Rich Trott) [#8473](https://github.com/nodejs/node/pull/8473)
* [[`3294c2c82b`](https://github.com/nodejs/node/commit/3294c2c82b)] - **test**: skip pseudo-tty/no_dropped_stdio test (Michael Dawson) [#8470](https://github.com/nodejs/node/pull/8470)
* [[`5baa4e0156`](https://github.com/nodejs/node/commit/5baa4e0156)] - **test**: clean up net server try ports test (Thomas Hunter II) [#8458](https://github.com/nodejs/node/pull/8458)
* [[`d0e61d4cc3`](https://github.com/nodejs/node/commit/d0e61d4cc3)] - **test**: make crypto.timingSafeEqual test less flaky (not-an-aardvark) [#8456](https://github.com/nodejs/node/pull/8456)
* [[`154d6893b0`](https://github.com/nodejs/node/commit/154d6893b0)] - **test**: add test-debug-protocol-execute (Rich Trott) [#8454](https://github.com/nodejs/node/pull/8454)
* [[`6c30dddc36`](https://github.com/nodejs/node/commit/6c30dddc36)] - **test**: exercise EE function type checking paths (cjihrig) [#8168](https://github.com/nodejs/node/pull/8168)
* [[`d536d6d334`](https://github.com/nodejs/node/commit/d536d6d334)] - **test**: increase `_debugger` coverage (Rich Trott) [#8403](https://github.com/nodejs/node/pull/8403)
* [[`6d07e57a36`](https://github.com/nodejs/node/commit/6d07e57a36)] - **test**: mark pseudo-tty/no_dropped_stdio as flaky (Michael Dawson) [#8385](https://github.com/nodejs/node/pull/8385)
* [[`680a4c8b8e`](https://github.com/nodejs/node/commit/680a4c8b8e)] - **test**: test non-buffer/string with zlib (Rich Trott) [#8350](https://github.com/nodejs/node/pull/8350)
* [[`f0300eda27`](https://github.com/nodejs/node/commit/f0300eda27)] - **test**: fix test-cluster-dgram-1 flakiness (Santiago Gimeno) [#8383](https://github.com/nodejs/node/pull/8383)
* [[`b8fa7c949d`](https://github.com/nodejs/node/commit/b8fa7c949d)] - **test**: fix ::1 error in test-dns-ipv6 (Gibson Fahnestock) [#8254](https://github.com/nodejs/node/pull/8254)
* [[`c07e063dd9`](https://github.com/nodejs/node/commit/c07e063dd9)] - **test**: fix `fs-watch-recursive` flakiness on OS X (Santiago Gimeno) [#4629](https://github.com/nodejs/node/pull/4629)
* [[`1aa7168e91`](https://github.com/nodejs/node/commit/1aa7168e91)] - **test**: refactor/cleanup a number of cluster tests (James M Snell) [#8261](https://github.com/nodejs/node/pull/8261)
* [[`39cf7bf24d`](https://github.com/nodejs/node/commit/39cf7bf24d)] - **test**: refactor parallel/test-process-env.js (Rich Trott) [#8324](https://github.com/nodejs/node/pull/8324)
* [[`40e84218a0`](https://github.com/nodejs/node/commit/40e84218a0)] - **test**: add test for zlib.create*Raw() (Rich Trott) [#8306](https://github.com/nodejs/node/pull/8306)
* [[`cc61d1a3ba`](https://github.com/nodejs/node/commit/cc61d1a3ba)] - **test**: cleanup test require symlink (Paul Grock) [#8305](https://github.com/nodejs/node/pull/8305)
* [[`cde0a1edfd`](https://github.com/nodejs/node/commit/cde0a1edfd)] - **test**: refactor test-debug-signal-cluster (Rich Trott) [#8289](https://github.com/nodejs/node/pull/8289)
* [[`bc6a7ca8e7`](https://github.com/nodejs/node/commit/bc6a7ca8e7)] - **test**: additional refactoring/cleanup of buffer tests (James M Snell) [#8283](https://github.com/nodejs/node/pull/8283)
* [[`5d43131af4`](https://github.com/nodejs/node/commit/5d43131af4)] - **test**: add known issue test for path parse issue #6229 (James M Snell) [#8293](https://github.com/nodejs/node/pull/8293)
* [[`d2179bd6f1`](https://github.com/nodejs/node/commit/d2179bd6f1)] - **test**: make sure over truncation of file zero fills (Sakthipriyan Vairamani) [#7648](https://github.com/nodejs/node/pull/7648)
* [[`5cff625d6a`](https://github.com/nodejs/node/commit/5cff625d6a)] - **test**: add check in test-signal-handler (Rich Trott) [#8248](https://github.com/nodejs/node/pull/8248)
* [[`0b0a1ceac3`](https://github.com/nodejs/node/commit/0b0a1ceac3)] - **test**: clean up / refactor buffer tests, remove duplication (James M Snell) [#8256](https://github.com/nodejs/node/pull/8256)
* [[`0f977f9797`](https://github.com/nodejs/node/commit/0f977f9797)] - **test**: mark test-child-process-fork-dgram as flaky (Michael Dawson) [#8274](https://github.com/nodejs/node/pull/8274)
* [[`6f269bed99`](https://github.com/nodejs/node/commit/6f269bed99)] - **test**: refactor test-util-inspect (Rich Trott) [#8189](https://github.com/nodejs/node/pull/8189)
* [[`eff771f399`](https://github.com/nodejs/node/commit/eff771f399)] - **tickprocessor**: apply c++filt manually on mac (Fedor Indutny) [#8480](https://github.com/nodejs/node/pull/8480)
* [[`f47ce9d9f8`](https://github.com/nodejs/node/commit/f47ce9d9f8)] - **tools**: replace custom ESLint rule with built-in (Rich Trott) [#8478](https://github.com/nodejs/node/pull/8478)
* [[`36235ac323`](https://github.com/nodejs/node/commit/36235ac323)] - **tools**: update ESLint to 3.5.0 (Rich Trott) [#8478](https://github.com/nodejs/node/pull/8478)
* [[`ef5cb129ae`](https://github.com/nodejs/node/commit/ef5cb129ae)] - **tools**: fix new-parens violations (Rich Trott) [#8478](https://github.com/nodejs/node/pull/8478)
* [[`773e1c1304`](https://github.com/nodejs/node/commit/773e1c1304)] - **tools**: enable caching for jslint task (Rich Trott) [#8296](https://github.com/nodejs/node/pull/8296)
* [[`54f689fc1e`](https://github.com/nodejs/node/commit/54f689fc1e)] - **tools**: update ESLint to 3.4.0 (Rich Trott) [#8296](https://github.com/nodejs/node/pull/8296)
* [[`f840bc87d6`](https://github.com/nodejs/node/commit/f840bc87d6)] - **url**: fix off-by-one error in loop handling dots (Luigi Pinca) [#8420](https://github.com/nodejs/node/pull/8420)
* [[`6ae7af0fa3`](https://github.com/nodejs/node/commit/6ae7af0fa3)] - **url**: keep auth in `url.resolve()` if host matches (Ilkka Myller) [#8215](https://github.com/nodejs/node/pull/8215)
* [[`eec5d02266`](https://github.com/nodejs/node/commit/eec5d02266)] - **url**: `url.format()` encodes all `#` in `search` (Ilkka Myller) [#8072](https://github.com/nodejs/node/pull/8072)
* [[`d67ece2f68`](https://github.com/nodejs/node/commit/d67ece2f68)] - **util**: improve function signature of `util._extend` (Sakthipriyan Vairamani) [#8187](https://github.com/nodejs/node/pull/8187)
* [[`e9c4805c1f`](https://github.com/nodejs/node/commit/e9c4805c1f)] - **(SEMVER-MINOR)** **util**: allow returning `this` from custom inspect (Anna Henningsen) [#8174](https://github.com/nodejs/node/pull/8174)
* [[`4cb55ff392`](https://github.com/nodejs/node/commit/4cb55ff392)] - **(SEMVER-MINOR)** **util**: allow symbol-based custom inspection methods (Anna Henningsen) [#8174](https://github.com/nodejs/node/pull/8174)
* [[`151d1ea6a6`](https://github.com/nodejs/node/commit/151d1ea6a6)] - **vm**: change ContextifyScript to Script in comment (Daniel Bevenius) [#8415](https://github.com/nodejs/node/pull/8415)
* [[`f346dee940`](https://github.com/nodejs/node/commit/f346dee940)] - **win,build**: forward release_urlbase to configure (João Reis) [#8430](https://github.com/nodejs/node/pull/8430)
* [[`6bb057ec6a`](https://github.com/nodejs/node/commit/6bb057ec6a)] - **win,build**: exit when addons fail to build (João Reis) [#8412](https://github.com/nodejs/node/pull/8412)
* [[`14d356d0ab`](https://github.com/nodejs/node/commit/14d356d0ab)] - **win,build**: skip finding VS when not needed (João Reis) [#8412](https://github.com/nodejs/node/pull/8412)
* [[`81d063e174`](https://github.com/nodejs/node/commit/81d063e174)] - **win,build**: fail on invalid option in vcbuild (João Reis) [#8412](https://github.com/nodejs/node/pull/8412)

<a id="6.5.0"></a>
## 2016-08-26, Version 6.5.0 (Current), @evanlucas

### Notable changes

* **buffer**: Fix regression introduced in v6.4.0 that prevented .write() at buffer end (Anna Henningsen) [#8154](https://github.com/nodejs/node/pull/8154)
* **deps**: update V8 to 5.1.281.75 (Ali Ijaz Sheikh) [#8054](https://github.com/nodejs/node/pull/8054)
* **inspector**:
  * fix inspector hang while disconnecting (Aleksei Koziatinskii) [#8021](https://github.com/nodejs/node/pull/8021)
  * add support for uncaught exception (Aleksei Koziatinskii) [#8043](https://github.com/nodejs/node/pull/8043)
* **repl**: Fix saving editor mode text in `.save` (Prince J Wesley) [#8145](https://github.com/nodejs/node/pull/8145)
* ***Revert*** "**repl,util**: insert carriage returns in output" (Evan Lucas) [#8143](https://github.com/nodejs/node/pull/8143)

### Commits

* [[`5bc311909f`](https://github.com/nodejs/node/commit/5bc311909f)] - **assert**: remove code that is never reached (Rich Trott) [#8132](https://github.com/nodejs/node/pull/8132)
* [[`e371545dfe`](https://github.com/nodejs/node/commit/e371545dfe)] - **buffer**: allow .write() offset to be at buffer end (Anna Henningsen) [#8154](https://github.com/nodejs/node/pull/8154)
* [[`dcd065522e`](https://github.com/nodejs/node/commit/dcd065522e)] - **(SEMVER-MINOR)** **build**: don't include V8 from node.gyp (Michaël Zasso) [#7016](https://github.com/nodejs/node/pull/7016)
* [[`92ecbc4edc`](https://github.com/nodejs/node/commit/92ecbc4edc)] - **build**: cherry pick V8 change for windows DLL support (Stefan Budeanu) [#8084](https://github.com/nodejs/node/pull/8084)
* [[`4e4c091542`](https://github.com/nodejs/node/commit/4e4c091542)] - **build**: windows sharedlib support (Stefan Budeanu) [#8084](https://github.com/nodejs/node/pull/8084)
* [[`f4c3456610`](https://github.com/nodejs/node/commit/f4c3456610)] - **build**: do not lint src dir for JS errors (Rich Trott) [#8128](https://github.com/nodejs/node/pull/8128)
* [[`71343b6caa`](https://github.com/nodejs/node/commit/71343b6caa)] - **child_process**: reuse existing no-op function (cjihrig) [#8164](https://github.com/nodejs/node/pull/8164)
* [[`0884c70535`](https://github.com/nodejs/node/commit/0884c70535)] - **child_process**: workaround fd passing issue on OS X (Santiago Gimeno) [#7572](https://github.com/nodejs/node/pull/7572)
* [[`8eb6e71758`](https://github.com/nodejs/node/commit/8eb6e71758)] - **configure**: reword help for --without-npm (BlackYoup) [#7471](https://github.com/nodejs/node/pull/7471)
* [[`c406ad8258`](https://github.com/nodejs/node/commit/c406ad8258)] - **debugger**: use arrow function for lexical `this` (Guy Fraser) [#7415](https://github.com/nodejs/node/pull/7415)
* [[`723fa9637c`](https://github.com/nodejs/node/commit/723fa9637c)] - **deps**: cherry-pick de5aaad from V8's upstream (Michaël Zasso) [#8099](https://github.com/nodejs/node/pull/8099)
* [[`fc2a89ccb7`](https://github.com/nodejs/node/commit/fc2a89ccb7)] - **deps**: V8: cherry-pick 588e15c, c0d4bb8 (epertoso) [#8038](https://github.com/nodejs/node/pull/8038)
* [[`cd77ca397a`](https://github.com/nodejs/node/commit/cd77ca397a)] - **deps**: cherry-pick 6f68f30 from v8 upstream (Stefan Budeanu) [#7802](https://github.com/nodejs/node/pull/7802)
* [[`b4f11efafa`](https://github.com/nodejs/node/commit/b4f11efafa)] - **deps**: cherry-pick a51f429 from V8 upstream (Franziska Hinkelmann) [#7833](https://github.com/nodejs/node/pull/7833)
* [[`4a20869714`](https://github.com/nodejs/node/commit/4a20869714)] - **deps**: cherry-pick a76d133 from v8 upstream (Matt Loring) [#7689](https://github.com/nodejs/node/pull/7689)
* [[`3b2f692b23`](https://github.com/nodejs/node/commit/3b2f692b23)] - **deps**: cherry-pick b93c80a from v8 upstream (Matt Loring) [#7689](https://github.com/nodejs/node/pull/7689)
* [[`c4401d283b`](https://github.com/nodejs/node/commit/c4401d283b)] - **deps**: cherry-pick 2b4c9c1 from v8 upstream (Joran Siu) [#7771](https://github.com/nodejs/node/pull/7771)
* [[`0ac21bc860`](https://github.com/nodejs/node/commit/0ac21bc860)] - **deps**: cherry-pick 1f53e42 from v8 upstream (Ben Noordhuis) [#7612](https://github.com/nodejs/node/pull/7612)
* [[`fc442e0f43`](https://github.com/nodejs/node/commit/fc442e0f43)] - **deps**: cherry-pick d721121 from v8 upstream (Ben Noordhuis) [#7632](https://github.com/nodejs/node/pull/7632)
* [[`9a4b338f0c`](https://github.com/nodejs/node/commit/9a4b338f0c)] - **deps**: remove extra field from v8::HeapStatistics (Anna Henningsen) [#7526](https://github.com/nodejs/node/pull/7526)
* [[`2c46e23969`](https://github.com/nodejs/node/commit/2c46e23969)] - **(SEMVER-MINOR)** **deps**: bring in V8 5.1 - 5.0 ABI compatibility (Matt Loring) [#7016](https://github.com/nodejs/node/pull/7016)
* [[`06a6c03e57`](https://github.com/nodejs/node/commit/06a6c03e57)] - **(SEMVER-MINOR)** **deps**: revert removal of V8::PromiseEvent (Matt Loring) [#7016](https://github.com/nodejs/node/pull/7016)
* [[`a91f6b8433`](https://github.com/nodejs/node/commit/a91f6b8433)] - **deps**: backport IsValid changes from 4e8736d in V8 (Michaël Zasso) [#6544](https://github.com/nodejs/node/pull/6544)
* [[`b2f7c32a9f`](https://github.com/nodejs/node/commit/b2f7c32a9f)] - **deps**: cherry-pick 1ef7487b from v8 upstream (Michael Dawson) [#6218](https://github.com/nodejs/node/pull/6218)
* [[`7af2f63f10`](https://github.com/nodejs/node/commit/7af2f63f10)] - **deps**: limit regress/regress-crbug-514081 v8 test (Michael Dawson) [#6678](https://github.com/nodejs/node/pull/6678)
* [[`abbad66126`](https://github.com/nodejs/node/commit/abbad66126)] - **(SEMVER-MINOR)** **deps**: update V8 to 5.1.281.75 (Ali Ijaz Sheikh) [#8054](https://github.com/nodejs/node/pull/8054)
* [[`08e2b0408a`](https://github.com/nodejs/node/commit/08e2b0408a)] - **deps**: cherry-pick 7bd24767 from v8 upstream (v6.x) (Franziska Hinkelmann) [#8078](https://github.com/nodejs/node/pull/8078)
* [[`d0cb52b967`](https://github.com/nodejs/node/commit/d0cb52b967)] - **dns**: remove makeAsync() function check (cjihrig) [#8170](https://github.com/nodejs/node/pull/8170)
* [[`70648f47ca`](https://github.com/nodejs/node/commit/70648f47ca)] - **dns**: lookupService() callback must be a function (cjihrig) [#8170](https://github.com/nodejs/node/pull/8170)
* [[`d9142b4bd6`](https://github.com/nodejs/node/commit/d9142b4bd6)] - **doc**: add `added:` information for util (Luigi Pinca) [#8206](https://github.com/nodejs/node/pull/8206)
* [[`c2f5471f6d`](https://github.com/nodejs/node/commit/c2f5471f6d)] - **doc**: remove "feature branch" jargon (Rich Trott) [#8194](https://github.com/nodejs/node/pull/8194)
* [[`7f34cc3e03`](https://github.com/nodejs/node/commit/7f34cc3e03)] - **doc**: correct argument type for process.cpuUsage (Simen Bekkhus) [#8158](https://github.com/nodejs/node/pull/8158)
* [[`0c9960b3c5`](https://github.com/nodejs/node/commit/0c9960b3c5)] - **doc**: remove outdated LTS info from ROADMAP.md (Rich Trott) [#8161](https://github.com/nodejs/node/pull/8161)
* [[`afbe4d8ebd`](https://github.com/nodejs/node/commit/afbe4d8ebd)] - **doc**: add es6 code example in util.md (Shahid Shaikh) [#8183](https://github.com/nodejs/node/pull/8183)
* [[`4a8aca7f94`](https://github.com/nodejs/node/commit/4a8aca7f94)] - **doc**: script with spaces spawn example for windows (Bartosz Sosnowski) [#8035](https://github.com/nodejs/node/pull/8035)
* [[`82329b6e8f`](https://github.com/nodejs/node/commit/82329b6e8f)] - **doc**: fix variable scoping bug in server example code (lazlojuly) [#8124](https://github.com/nodejs/node/pull/8124)
* [[`d7ab1baed2`](https://github.com/nodejs/node/commit/d7ab1baed2)] - **doc**: update release announce instruction to tweet (Tracy Hinds) [#8126](https://github.com/nodejs/node/pull/8126)
* [[`5d37b49f90`](https://github.com/nodejs/node/commit/5d37b49f90)] - **doc**: add @joshgav to collaborators (Josh Gavant) [#8146](https://github.com/nodejs/node/pull/8146)
* [[`31653a5006`](https://github.com/nodejs/node/commit/31653a5006)] - **doc**: update Reviewing section of onboarding doc (Rich Trott)
* [[`bf5c5f3ce0`](https://github.com/nodejs/node/commit/bf5c5f3ce0)] - **doc**: fix "hashOwnProperty" typo in querystring (Ben Gourley) [#8107](https://github.com/nodejs/node/pull/8107)
* [[`b1922e7b5b`](https://github.com/nodejs/node/commit/b1922e7b5b)] - **dtrace**: fix ustack helper for V8 5.1 (Ali Ijaz Sheikh) [#6482](https://github.com/nodejs/node/pull/6482)
* [[`92de0bc1a6`](https://github.com/nodejs/node/commit/92de0bc1a6)] - **inspector**: fix inspector hang while disconnecting (Aleksei Koziatinskii) [#8021](https://github.com/nodejs/node/pull/8021)
* [[`bfd8265ec2`](https://github.com/nodejs/node/commit/bfd8265ec2)] - **inspector**: add support for uncaught exception (Aleksei Koziatinskii) [#8043](https://github.com/nodejs/node/pull/8043)
* [[`089a1cbecb`](https://github.com/nodejs/node/commit/089a1cbecb)] - **net**: add length check when normalizing args (Brian White) [#8112](https://github.com/nodejs/node/pull/8112)
* [[`17b8381585`](https://github.com/nodejs/node/commit/17b8381585)] - **net**: remove unnecessary variables (Brian White) [#8112](https://github.com/nodejs/node/pull/8112)
* [[`fbc5805e65`](https://github.com/nodejs/node/commit/fbc5805e65)] - **readline**: keypress trigger for escape character (Prince J Wesley) [#7382](https://github.com/nodejs/node/pull/7382)
* [[`66e66e59a4`](https://github.com/nodejs/node/commit/66e66e59a4)] - **(SEMVER-MINOR)** **repl**: fix repl after V8 upgrade (Ali Ijaz Sheikh) [#7016](https://github.com/nodejs/node/pull/7016)
* [[`60c50468e3`](https://github.com/nodejs/node/commit/60c50468e3)] - **repl**: Failed to save editor mode text in `.save` (Prince J Wesley) [#8145](https://github.com/nodejs/node/pull/8145)
* [[`ffb2db8285`](https://github.com/nodejs/node/commit/ffb2db8285)] - ***Revert*** "**repl,util**: insert carriage returns in output" (Evan Lucas) [#8143](https://github.com/nodejs/node/pull/8143)
* [[`4118598dbb`](https://github.com/nodejs/node/commit/4118598dbb)] - **src**: don't include a null character in the WriteConsoleW call (Nikolai Vavilov) [#7764](https://github.com/nodejs/node/pull/7764)
* [[`d863619a30`](https://github.com/nodejs/node/commit/d863619a30)] - **src**: clean up PER_ISOLATE_STRING_PROPERTIES, v2 (Ben Noordhuis) [#8207](https://github.com/nodejs/node/pull/8207)
* [[`d3950a2013`](https://github.com/nodejs/node/commit/d3950a2013)] - **src**: clean up PER_ISOLATE_STRING_PROPERTIES, v1 (Ben Noordhuis) [#8207](https://github.com/nodejs/node/pull/8207)
* [[`8f9fb8154d`](https://github.com/nodejs/node/commit/8f9fb8154d)] - **src**: updating references to the old node.js file (Daniel Bevenius) [#8092](https://github.com/nodejs/node/pull/8092)
* [[`091ba2c511`](https://github.com/nodejs/node/commit/091ba2c511)] - **src**: fix build break for !NODE_USE_V8_PLATFORM (Kunal Pathak) [#8114](https://github.com/nodejs/node/pull/8114)
* [[`1bf80a0a3f`](https://github.com/nodejs/node/commit/1bf80a0a3f)] - **stream**: avoid caching prepend check (Calvin Metcalf) [#8018](https://github.com/nodejs/node/pull/8018)
* [[`cda8bfc3c8`](https://github.com/nodejs/node/commit/cda8bfc3c8)] - **test**: fix tests after V8 upgrade (Ali Ijaz Sheikh) [#6482](https://github.com/nodejs/node/pull/6482)
* [[`441e8fe566`](https://github.com/nodejs/node/commit/441e8fe566)] - **test**: refactor test-timers-linked-list.js (Rich Trott) [#8193](https://github.com/nodejs/node/pull/8193)
* [[`bb6d6a677c`](https://github.com/nodejs/node/commit/bb6d6a677c)] - **test**: fix flaky `test-child-process-pass-fd` (Santiago Gimeno) [#8212](https://github.com/nodejs/node/pull/8212)
* [[`b0619e8dff`](https://github.com/nodejs/node/commit/b0619e8dff)] - **test**: comparison operator now more strict (Jason Hedrick) [#8190](https://github.com/nodejs/node/pull/8190)
* [[`923a61774d`](https://github.com/nodejs/node/commit/923a61774d)] - **test**: refactor test-tick-processor (Rich Trott) [#8180](https://github.com/nodejs/node/pull/8180)
* [[`b9b762f308`](https://github.com/nodejs/node/commit/b9b762f308)] - **test**: add test for invalid cert string (Rich Trott) [#8179](https://github.com/nodejs/node/pull/8179)
* [[`a6f83797df`](https://github.com/nodejs/node/commit/a6f83797df)] - **test**: add assert.notDeepStrictEqual() tests (Rich Trott) [#8177](https://github.com/nodejs/node/pull/8177)
* [[`29a71965c0`](https://github.com/nodejs/node/commit/29a71965c0)] - **test**: favor `===` over `==` in crypto tests (Rich Trott) [#8176](https://github.com/nodejs/node/pull/8176)
* [[`c568dfad39`](https://github.com/nodejs/node/commit/c568dfad39)] - **test**: refactor pummel/test-dtrace-jsstack (Rich Trott) [#8175](https://github.com/nodejs/node/pull/8175)
* [[`cfbafd7c7d`](https://github.com/nodejs/node/commit/cfbafd7c7d)] - **test**: favor strict equality in test-exec (Rich Trott) [#8173](https://github.com/nodejs/node/pull/8173)
* [[`b8f5a2b789`](https://github.com/nodejs/node/commit/b8f5a2b789)] - **test**: favor `===` over `==` in vm test (jun-oka) [#8191](https://github.com/nodejs/node/pull/8191)
* [[`498238f462`](https://github.com/nodejs/node/commit/498238f462)] - **test**: test sending over a closed IPC channel (cjihrig) [#8160](https://github.com/nodejs/node/pull/8160)
* [[`15bd48986b`](https://github.com/nodejs/node/commit/15bd48986b)] - **test**: add test for attempted multiple IPC channels (cjihrig) [#8159](https://github.com/nodejs/node/pull/8159)
* [[`4deb05434f`](https://github.com/nodejs/node/commit/4deb05434f)] - **test**: add assert.notDeepEqual() tests (Rich Trott) [#8156](https://github.com/nodejs/node/pull/8156)
* [[`3d0cf9e4f1`](https://github.com/nodejs/node/commit/3d0cf9e4f1)] - **test**: add missing assert.deepEqual() test case (Rich Trott) [#8152](https://github.com/nodejs/node/pull/8152)
* [[`6abbe17ab2`](https://github.com/nodejs/node/commit/6abbe17ab2)] - **test**: favor strict equality in http tests (Rich Trott) [#8151](https://github.com/nodejs/node/pull/8151)
* [[`cc9bb34120`](https://github.com/nodejs/node/commit/cc9bb34120)] - **test**: favor strict equality in pummel net tests (Rich Trott) [#8135](https://github.com/nodejs/node/pull/8135)
* [[`4b6ed24f02`](https://github.com/nodejs/node/commit/4b6ed24f02)] - **test**: confirm that assert truncates long values (Rich Trott) [#8134](https://github.com/nodejs/node/pull/8134)
* [[`e5a8790727`](https://github.com/nodejs/node/commit/e5a8790727)] - **test**: favor `===` over `==` in test-timers.js (Rich Trott) [#8131](https://github.com/nodejs/node/pull/8131)
* [[`086e57f404`](https://github.com/nodejs/node/commit/086e57f404)] - **test**: favor strict equality check (Rich Trott) [#8130](https://github.com/nodejs/node/pull/8130)
* [[`9a393a7ff4`](https://github.com/nodejs/node/commit/9a393a7ff4)] - **test**: fix assertion in test-watch-file.js (Rich Trott) [#8129](https://github.com/nodejs/node/pull/8129)
* [[`4f09886dce`](https://github.com/nodejs/node/commit/4f09886dce)] - **test**: fix flaky fs-watch tests (Santiago Gimeno) [#8115](https://github.com/nodejs/node/pull/8115)
* [[`d401e5575a`](https://github.com/nodejs/node/commit/d401e5575a)] - **test**: add an zlib binding addon test (Anna Henningsen) [#8039](https://github.com/nodejs/node/pull/8039)
* [[`6bdc0e54b4`](https://github.com/nodejs/node/commit/6bdc0e54b4)] - **test**: use strict equality in regression test (Rich Trott) [#8098](https://github.com/nodejs/node/pull/8098)
* [[`be41f584f3`](https://github.com/nodejs/node/commit/be41f584f3)] - **test**: remove extraneous space (Rich Trott) [#8097](https://github.com/nodejs/node/pull/8097)
* [[`853f605de4`](https://github.com/nodejs/node/commit/853f605de4)] - **test**: add test for assert.notStrictEqual() (Rich Trott) [#8091](https://github.com/nodejs/node/pull/8091)
* [[`f4698f3568`](https://github.com/nodejs/node/commit/f4698f3568)] - **test**: add uncaught exception test for debugger (Rich Trott) [#8087](https://github.com/nodejs/node/pull/8087)
* [[`c26b9af1e2`](https://github.com/nodejs/node/commit/c26b9af1e2)] - **tls**: copy the Buffer object before using (Sakthipriyan Vairamani) [#8055](https://github.com/nodejs/node/pull/8055)
* [[`cdcf23ab7f`](https://github.com/nodejs/node/commit/cdcf23ab7f)] - **tools**: update ESLint to 3.3.0 and enable rules (Rich Trott) [#8097](https://github.com/nodejs/node/pull/8097)
* [[`14c7dcbbcd`](https://github.com/nodejs/node/commit/14c7dcbbcd)] - **url**: fix inconsistent port in url.resolveObject (Ilkka Myller) [#8214](https://github.com/nodejs/node/pull/8214)
* [[`1f9fbade4c`](https://github.com/nodejs/node/commit/1f9fbade4c)] - **util**: fix deprecated class prototype (Bryan English) [#8105](https://github.com/nodejs/node/pull/8105)
* [[`44f781d06a`](https://github.com/nodejs/node/commit/44f781d06a)] - **v8**: warn in Template::Set() on improper use (Ben Noordhuis) [#6277](https://github.com/nodejs/node/pull/6277)
* [[`a146e683dd`](https://github.com/nodejs/node/commit/a146e683dd)] - **win,msi**: add zh-CN translations for the installer (Minqi Pan) [#2569](https://github.com/nodejs/node/pull/2569)

<a id="6.4.0"></a>
## 2016-08-15, Version 6.4.0 (Current), @cjihrig

### Notable changes

* **build**: zlib symbols and additional OpenSSL symbols are now exposed on Windows platforms. (Alex Hultman) [#7983](https://github.com/nodejs/node/pull/7983) and [#7576](https://github.com/nodejs/node/pull/7576)
* **child_process**, **cluster**: Forked child processes and cluster workers now support stdio configuration. (Colin Ihrig) [#7811](https://github.com/nodejs/node/pull/7811) and [#7838](https://github.com/nodejs/node/pull/7838)
* **child_process**: `argv[0]` can now be set to arbitrary values in spawned processes. (Pat Pannuto) [#7696](https://github.com/nodejs/node/pull/7696)
* **fs**: `fs.ReadStream` now exposes the number of bytes it has read so far. (Linus Unnebäck) [#7942](https://github.com/nodejs/node/pull/7942)
* **repl**: The REPL now supports editor mode. (Prince J Wesley) [#7275](https://github.com/nodejs/node/pull/7275)
* **util**: `inspect()` can now be configured globally using `util.inspect.defaultOptions`. (Roman Reiss) [#8013](https://github.com/nodejs/node/pull/8013)

### Commits

* [[`06a0a053ea`](https://github.com/nodejs/node/commit/06a0a053ea)] - 2016-08-15, Version 6.4.0 (Current) (cjihrig) [#8070](https://github.com/nodejs/node/pull/8070)
* [[`342a85b1a7`](https://github.com/nodejs/node/commit/342a85b1a7)] - Working on v6.3.2 (Evan Lucas) [#7782](https://github.com/nodejs/node/pull/7782)
* [[`f135a4c3d1`](https://github.com/nodejs/node/commit/f135a4c3d1)] - 2016-07-21, Version 6.3.1 (Current) (Evan Lucas) [#7782](https://github.com/nodejs/node/pull/7782)
* [[`57043aad33`](https://github.com/nodejs/node/commit/57043aad33)] - **assert**: fix deepEqual/deepStrictEqual on equivalent typed arrays (Feross Aboukhadijeh) [#8002](https://github.com/nodejs/node/pull/8002)
* [[`f6713bfabd`](https://github.com/nodejs/node/commit/f6713bfabd)] - **bench**: add bench for fs.realpath() fix (Trevor Norris) [#7899](https://github.com/nodejs/node/pull/7899)
* [[`0d4b04659f`](https://github.com/nodejs/node/commit/0d4b04659f)] - **benchmark**: favor === over == (Rich Trott) [#8000](https://github.com/nodejs/node/pull/8000)
* [[`98f51ffeb6`](https://github.com/nodejs/node/commit/98f51ffeb6)] - **buffer**: fix unintended unsigned overflow (Fedor Indutny) [#7494](https://github.com/nodejs/node/pull/7494)
* [[`28071a130e`](https://github.com/nodejs/node/commit/28071a130e)] - **buffer**: introduce latin1 encoding term (Trevor Norris) [#7111](https://github.com/nodejs/node/pull/7111)
* [[`b0a557eef7`](https://github.com/nodejs/node/commit/b0a557eef7)] - **build**: add correct shared library naming on OS X (Stewart Addison) [#7687](https://github.com/nodejs/node/pull/7687)
* [[`6ed4ea8fd6`](https://github.com/nodejs/node/commit/6ed4ea8fd6)] - **build**: turn on thin static archives (Ben Noordhuis) [#7957](https://github.com/nodejs/node/pull/7957)
* [[`c843e58914`](https://github.com/nodejs/node/commit/c843e58914)] - **(SEMVER-MINOR)** **build**: export zlib symbols on Windows (Alex Hultman) [#7983](https://github.com/nodejs/node/pull/7983)
* [[`889c62fec1`](https://github.com/nodejs/node/commit/889c62fec1)] - **build**: fix dependency on missing header file (Ben Noordhuis) [#7945](https://github.com/nodejs/node/pull/7945)
* [[`a4394b8745`](https://github.com/nodejs/node/commit/a4394b8745)] - **build**: fix typo in non-essential source file name (Ben Noordhuis) [#7945](https://github.com/nodejs/node/pull/7945)
* [[`636cf2236a`](https://github.com/nodejs/node/commit/636cf2236a)] - **build**: adding config.gypi dep to addons/.buildstamp (Daniel Bevenius) [#7893](https://github.com/nodejs/node/pull/7893)
* [[`ddf292fc32`](https://github.com/nodejs/node/commit/ddf292fc32)] - **build**: don't link against liblog on host system (Ben Noordhuis) [#7762](https://github.com/nodejs/node/pull/7762)
* [[`f0312e6560`](https://github.com/nodejs/node/commit/f0312e6560)] - **(SEMVER-MINOR)** **build**: export more openssl symbols on Windows (Alex Hultman) [#7576](https://github.com/nodejs/node/pull/7576)
* [[`e561895275`](https://github.com/nodejs/node/commit/e561895275)] - **(SEMVER-MINOR)** **child_process**: control argv0 for spawned processes (Pat Pannuto) [#7696](https://github.com/nodejs/node/pull/7696)
* [[`da481c634f`](https://github.com/nodejs/node/commit/da481c634f)] - **(SEMVER-MINOR)** **child_process**: support stdio option in fork() (cjihrig) [#7811](https://github.com/nodejs/node/pull/7811)
* [[`a4f0b13e2b`](https://github.com/nodejs/node/commit/a4f0b13e2b)] - **(SEMVER-MINOR)** **cluster**: support stdio option for workers (cjihrig) [#7838](https://github.com/nodejs/node/pull/7838)
* [[`5f3ab3ffd1`](https://github.com/nodejs/node/commit/5f3ab3ffd1)] - **(SEMVER-MINOR)** **crypto**: fix undefined behavior in ParseExtension (Fedor Indutny) [#7494](https://github.com/nodejs/node/pull/7494)
* [[`60d6e048f0`](https://github.com/nodejs/node/commit/60d6e048f0)] - **(SEMVER-MINOR)** **deps**: v8_inspector: console support (Aleksei Koziatinskii) [#7988](https://github.com/nodejs/node/pull/7988)
* [[`a9fe85ee9c`](https://github.com/nodejs/node/commit/a9fe85ee9c)] - **deps**: v8_inspector update (Ali Ijaz Sheikh) [#8014](https://github.com/nodejs/node/pull/8014)
* [[`4d81362b99`](https://github.com/nodejs/node/commit/4d81362b99)] - **deps**: v8_inspector: remove jinja2 tests (Ali Ijaz Sheikh) [#7796](https://github.com/nodejs/node/pull/7796)
* [[`57312fc0c5`](https://github.com/nodejs/node/commit/57312fc0c5)] - **deps**: remove jinja.el from deps/v8_inspector (Ali Ijaz Sheikh) [#7796](https://github.com/nodejs/node/pull/7796)
* [[`507c65d94a`](https://github.com/nodejs/node/commit/507c65d94a)] - **deps**: update v8_inspector (Ali Ijaz Sheikh) [#7796](https://github.com/nodejs/node/pull/7796)
* [[`3f46b5c18e`](https://github.com/nodejs/node/commit/3f46b5c18e)] - **deps**: float gyp patch for long filenames (Anna Henningsen) [#7963](https://github.com/nodejs/node/pull/7963)
* [[`e6887e2ceb`](https://github.com/nodejs/node/commit/e6887e2ceb)] - **deps**: cherry-pick a76d133 from v8 upstream (Matt Loring) [#7689](https://github.com/nodejs/node/pull/7689)
* [[`a03e3d3cff`](https://github.com/nodejs/node/commit/a03e3d3cff)] - **deps**: cherry-pick b93c80a from v8 upstream (Matt Loring) [#7689](https://github.com/nodejs/node/pull/7689)
* [[`75b37a6bac`](https://github.com/nodejs/node/commit/75b37a6bac)] - **deps**: cherry-pick 43547df from V8 upstream (Franziska Hinkelmann) [#7863](https://github.com/nodejs/node/pull/7863)
* [[`af63871593`](https://github.com/nodejs/node/commit/af63871593)] - **deps**: cherry-pick a51f429 from V8 upstream (Franziska Hinkelmann) [#7834](https://github.com/nodejs/node/pull/7834)
* [[`e82e80417b`](https://github.com/nodejs/node/commit/e82e80417b)] - **deps**: backport 2bcbe2f from V8 upstream (ofrobots) [#7814](https://github.com/nodejs/node/pull/7814)
* [[`51a2041b90`](https://github.com/nodejs/node/commit/51a2041b90)] - **(SEMVER-MINOR)** **dgram**: generalized send queue to handle close (Matteo Collina) [#7066](https://github.com/nodejs/node/pull/7066)
* [[`7eb95f6faa`](https://github.com/nodejs/node/commit/7eb95f6faa)] - **doc**: minor updates to onboarding doc (Rich Trott) [#8060](https://github.com/nodejs/node/pull/8060)
* [[`5259322e62`](https://github.com/nodejs/node/commit/5259322e62)] - **doc**: add POST_STATUS_TO_PR info to onboarding doc (Rich Trott) [#8059](https://github.com/nodejs/node/pull/8059)
* [[`1903275963`](https://github.com/nodejs/node/commit/1903275963)] - **doc**: update windows prerequisites (Ben Noordhuis) [#8049](https://github.com/nodejs/node/pull/8049)
* [[`3fe122f57e`](https://github.com/nodejs/node/commit/3fe122f57e)] - **doc**: update licenses (Ali Ijaz Sheikh) [#7796](https://github.com/nodejs/node/pull/7796)
* [[`14b762f81f`](https://github.com/nodejs/node/commit/14b762f81f)] - **doc**: move orangemocha to collaborators list (Rich Trott) [#8062](https://github.com/nodejs/node/pull/8062)
* [[`ffbead92a0`](https://github.com/nodejs/node/commit/ffbead92a0)] - **doc**: Add fhinkel to collaborators (Franziska Hinkelmann) [#8052](https://github.com/nodejs/node/pull/8052)
* [[`96d15e2f3c`](https://github.com/nodejs/node/commit/96d15e2f3c)] - **doc**: fix cluster message event docs (Zach Bjornson) [#8017](https://github.com/nodejs/node/pull/8017)
* [[`4a8b8048f2`](https://github.com/nodejs/node/commit/4a8b8048f2)] - **doc**: add `added:` information for cluster (Anna Henningsen) [#7640](https://github.com/nodejs/node/pull/7640)
* [[`38255080db`](https://github.com/nodejs/node/commit/38255080db)] - **doc**: remove spurious new line in CHANGELOG_V6.md (Luigi Pinca) [#8009](https://github.com/nodejs/node/pull/8009)
* [[`9f78c3f64f`](https://github.com/nodejs/node/commit/9f78c3f64f)] - **doc**: fix typo in vm.runInNewContext() description (Luigi Pinca) [#8005](https://github.com/nodejs/node/pull/8005)
* [[`c4765a1b66`](https://github.com/nodejs/node/commit/c4765a1b66)] - **doc**: Clean up roff source in manpage (Alhadis) [#7819](https://github.com/nodejs/node/pull/7819)
* [[`cbcd03c912`](https://github.com/nodejs/node/commit/cbcd03c912)] - **doc**: add CTC meeting minutes 2016-08-03 (Josh Gavant) [#7980](https://github.com/nodejs/node/pull/7980)
* [[`7d0e5a0622`](https://github.com/nodejs/node/commit/7d0e5a0622)] - **doc**: clarify collaborators & ctc members relationships (yorkie) [#7996](https://github.com/nodejs/node/pull/7996)
* [[`dedfcb7858`](https://github.com/nodejs/node/commit/dedfcb7858)] - **doc**: clarify fd closing by `fs.readFile` etc. (kibertoad) [#7561](https://github.com/nodejs/node/pull/7561)
* [[`ce776d22f9`](https://github.com/nodejs/node/commit/ce776d22f9)] - **doc**: fix a markdown error in CTC meeting minutes (Сковорода Никита Андреевич) [#7729](https://github.com/nodejs/node/pull/7729)
* [[`b20518a013`](https://github.com/nodejs/node/commit/b20518a013)] - **doc**: add `added:` information for events (Luigi Pinca) [#7822](https://github.com/nodejs/node/pull/7822)
* [[`7fa4be0f87`](https://github.com/nodejs/node/commit/7fa4be0f87)] - **doc**: improve server.listen() random port (Phillip Johnsen) [#7976](https://github.com/nodejs/node/pull/7976)
* [[`7c427bdccc`](https://github.com/nodejs/node/commit/7c427bdccc)] - **doc**: clarify "Reviewed-By" iff "LGTM" (Bryan English) [#7183](https://github.com/nodejs/node/pull/7183)
* [[`cdbeae9adc`](https://github.com/nodejs/node/commit/cdbeae9adc)] - **doc**: add CTC meeting minutes 2016-07-13 (Josh Gavant) [#7968](https://github.com/nodejs/node/pull/7968)
* [[`2245e843cc`](https://github.com/nodejs/node/commit/2245e843cc)] - **doc**: add CTC meeting minutes 2016-07-20 (Josh Gavant) [#7970](https://github.com/nodejs/node/pull/7970)
* [[`cb0baca982`](https://github.com/nodejs/node/commit/cb0baca982)] - **doc**: use consistent markdown in README (Rich Trott) [#7971](https://github.com/nodejs/node/pull/7971)
* [[`3d1a06451a`](https://github.com/nodejs/node/commit/3d1a06451a)] - **doc**: use `git-secure-tag` for release tags (Fedor Indutny) [#7603](https://github.com/nodejs/node/pull/7603)
* [[`e116cf96a0`](https://github.com/nodejs/node/commit/e116cf96a0)] - **doc**: use blockquotes for Stability: markers (Anna Henningsen) [#7757](https://github.com/nodejs/node/pull/7757)
* [[`c934f51aa4`](https://github.com/nodejs/node/commit/c934f51aa4)] - **doc**: fix default encoding mention in crypto.md (hugnosis) [#7805](https://github.com/nodejs/node/pull/7805)
* [[`df35ae6246`](https://github.com/nodejs/node/commit/df35ae6246)] - **doc**: fix minor formatting issue in 0.10 changelog (Сковорода Никита Андреевич) [#7727](https://github.com/nodejs/node/pull/7727)
* [[`5f12807c46`](https://github.com/nodejs/node/commit/5f12807c46)] - **doc**: remove extra indentation in iojs changelog (Сковорода Никита Андреевич) [#7727](https://github.com/nodejs/node/pull/7727)
* [[`abd0bc0523`](https://github.com/nodejs/node/commit/abd0bc0523)] - **doc**: *.md formatting fixes in the top-level dir (Сковорода Никита Андреевич) [#7727](https://github.com/nodejs/node/pull/7727)
* [[`c72019b75a`](https://github.com/nodejs/node/commit/c72019b75a)] - **doc**: convert tabs to spaces (Сковорода Никита Андреевич) [#7727](https://github.com/nodejs/node/pull/7727)
* [[`0fbb83a67b`](https://github.com/nodejs/node/commit/0fbb83a67b)] - **doc**: piscisaureus has stepped-down from the CTC (James M Snell) [#7969](https://github.com/nodejs/node/pull/7969)
* [[`48422c240a`](https://github.com/nodejs/node/commit/48422c240a)] - **doc**: add @addaleax to the CTC (Anna Henningsen) [#7966](https://github.com/nodejs/node/pull/7966)
* [[`0094adc0b2`](https://github.com/nodejs/node/commit/0094adc0b2)] - **doc**: add CTC meeting minutes 2016-06-22 (Josh Gavant) [#7390](https://github.com/nodejs/node/pull/7390)
* [[`fd9b7b4c5a`](https://github.com/nodejs/node/commit/fd9b7b4c5a)] - **doc**: add CTC meeting minutes 2016-07-06 (Josh Gavant) [#7570](https://github.com/nodejs/node/pull/7570)
* [[`4616261110`](https://github.com/nodejs/node/commit/4616261110)] - **doc**: add CTC meeting minutes 2016-06-29 (Josh Gavant) [#7571](https://github.com/nodejs/node/pull/7571)
* [[`bb90867339`](https://github.com/nodejs/node/commit/bb90867339)] - **doc**: add CTC meeting minutes 2016-07-27 (William Kapke) [#7900](https://github.com/nodejs/node/pull/7900)
* [[`7d0c1bf781`](https://github.com/nodejs/node/commit/7d0c1bf781)] - **doc**: fix path markdown formatting (Joey Cozza) [#7817](https://github.com/nodejs/node/pull/7817)
* [[`04ec64aacc`](https://github.com/nodejs/node/commit/04ec64aacc)] - **doc**: add missing semicolon (Ravindra barthwal) [#7915](https://github.com/nodejs/node/pull/7915)
* [[`8d8d70d826`](https://github.com/nodejs/node/commit/8d8d70d826)] - **doc**: fill in missing V8 version (Timothy Gu) [#7878](https://github.com/nodejs/node/pull/7878)
* [[`6ce9c80ccb`](https://github.com/nodejs/node/commit/6ce9c80ccb)] - **doc**: remove extra spaces and concats in examples (Joe Esposito) [#7885](https://github.com/nodejs/node/pull/7885)
* [[`23b6468667`](https://github.com/nodejs/node/commit/23b6468667)] - **doc**: add information about CTC quorum rules (Rich Trott) [#7813](https://github.com/nodejs/node/pull/7813)
* [[`0645c3d0c4`](https://github.com/nodejs/node/commit/0645c3d0c4)] - **doc**: align breakEvalOnSigint - repl option (Prince J Wesley) [#7849](https://github.com/nodejs/node/pull/7849)
* [[`14a0c3181c`](https://github.com/nodejs/node/commit/14a0c3181c)] - **doc**: remove platform assumption from CONTRIBUTING (Bethany N Griggs) [#7783](https://github.com/nodejs/node/pull/7783)
* [[`5c4b938665`](https://github.com/nodejs/node/commit/5c4b938665)] - **doc**: minor typo fixes in stream docs (Alex Perkins) [#7763](https://github.com/nodejs/node/pull/7763)
* [[`57fb0d2ee2`](https://github.com/nodejs/node/commit/57fb0d2ee2)] - **doc**: add/fix version metadata for Buffer methods (Brian White) [#7784](https://github.com/nodejs/node/pull/7784)
* [[`49a669bcda`](https://github.com/nodejs/node/commit/49a669bcda)] - **doc**: improve function parameter descriptions (Brian White) [#7784](https://github.com/nodejs/node/pull/7784)
* [[`bdc8690610`](https://github.com/nodejs/node/commit/bdc8690610)] - **doc**: add missing properties in Buffer docs (Brian White) [#7784](https://github.com/nodejs/node/pull/7784)
* [[`a8e7c7f2bf`](https://github.com/nodejs/node/commit/a8e7c7f2bf)] - **doc**: improve wording and style of Buffer docs (Brian White) [#7784](https://github.com/nodejs/node/pull/7784)
* [[`9a4a00bcdb`](https://github.com/nodejs/node/commit/9a4a00bcdb)] - **doc**: improve links in Buffer docs (Brian White) [#7784](https://github.com/nodejs/node/pull/7784)
* [[`0103d9dcea`](https://github.com/nodejs/node/commit/0103d9dcea)] - **doc**: reorganize Buffer link references (Brian White) [#7784](https://github.com/nodejs/node/pull/7784)
* [[`17ae49a055`](https://github.com/nodejs/node/commit/17ae49a055)] - **doc**: improve Buffer code examples (Brian White) [#7784](https://github.com/nodejs/node/pull/7784)
* [[`0ffeddb5b4`](https://github.com/nodejs/node/commit/0ffeddb5b4)] - **doc**: various documentation formatting fixes (Сковорода Никита Андреевич) [#7637](https://github.com/nodejs/node/pull/7637)
* [[`1fa9330ac6`](https://github.com/nodejs/node/commit/1fa9330ac6)] - **doc**: add princejwesley to collaborators (Prince J Wesley) [#7877](https://github.com/nodejs/node/pull/7877)
* [[`715ac62670`](https://github.com/nodejs/node/commit/715ac62670)] - **doc**: clarify that the node.js irc channel is not under tsc oversight (James M Snell) [#7810](https://github.com/nodejs/node/pull/7810)
* [[`edb877da65`](https://github.com/nodejs/node/commit/edb877da65)] - **doc**: fix `added:` date for `NODE_REPL_HISTORY` (Anna Henningsen) [#7775](https://github.com/nodejs/node/pull/7775)
* [[`27f92efaee`](https://github.com/nodejs/node/commit/27f92efaee)] - **doctool**: improve the title of pages in doc (yorkie) [#7939](https://github.com/nodejs/node/pull/7939)
* [[`18a3064937`](https://github.com/nodejs/node/commit/18a3064937)] - **fs**: restore JS implementation of realpath (Bartosz Sosnowski) [#7899](https://github.com/nodejs/node/pull/7899)
* [[`0bb9d21f0e`](https://github.com/nodejs/node/commit/0bb9d21f0e)] - **(SEMVER-MINOR)** **fs**: add bytesRead to ReadStream (Linus Unnebäck) [#7942](https://github.com/nodejs/node/pull/7942)
* [[`db3a7e83eb`](https://github.com/nodejs/node/commit/db3a7e83eb)] - **http**: specify \_implicitHeader in OutgoingMessage (yorkie) [#7949](https://github.com/nodejs/node/pull/7949)
* [[`b75ca50c90`](https://github.com/nodejs/node/commit/b75ca50c90)] - **inspector**: Do not crash if the port is n/a (Eugene Ostroukhov) [#7874](https://github.com/nodejs/node/pull/7874)
* [[`7dc66f82e3`](https://github.com/nodejs/node/commit/7dc66f82e3)] - **lib**: remove double check of string type (Franziska Hinkelmann) [#7985](https://github.com/nodejs/node/pull/7985)
* [[`5cc4b0ed15`](https://github.com/nodejs/node/commit/5cc4b0ed15)] - **meta**: clarify process for breaking changes (Rich Trott) [#7955](https://github.com/nodejs/node/pull/7955)
* [[`79ecfb5183`](https://github.com/nodejs/node/commit/79ecfb5183)] - **meta**: include a minimal CTC removal policy (Rich Trott) [#7720](https://github.com/nodejs/node/pull/7720)
* [[`376d73b3b9`](https://github.com/nodejs/node/commit/376d73b3b9)] - **meta**: provide example activities (Rich Trott) [#7744](https://github.com/nodejs/node/pull/7744)
* [[`ccbb46378f`](https://github.com/nodejs/node/commit/ccbb46378f)] - **module**: fix node_modules search path in edge case (hefangshi) [#6670](https://github.com/nodejs/node/pull/6670)
* [[`2f32191686`](https://github.com/nodejs/node/commit/2f32191686)] - **(SEMVER-MINOR)** **process**: save original argv\[0\] (Pat Pannuto) [#7696](https://github.com/nodejs/node/pull/7696)
* [[`d9c9e46780`](https://github.com/nodejs/node/commit/d9c9e46780)] - **repl**: disable Ctrl+C support on win32 for now (Anna Henningsen) [#7977](https://github.com/nodejs/node/pull/7977)
* [[`61e57e06a6`](https://github.com/nodejs/node/commit/61e57e06a6)] - **repl**: don't override all internal repl defaults (cjihrig) [#7826](https://github.com/nodejs/node/pull/7826)
* [[`4875aa2aa2`](https://github.com/nodejs/node/commit/4875aa2aa2)] - **(SEMVER-MINOR)** **repl**: Add editor mode support (Prince J Wesley) [#7275](https://github.com/nodejs/node/pull/7275)
* [[`fc3ba2ff4f`](https://github.com/nodejs/node/commit/fc3ba2ff4f)] - **(SEMVER-MINOR)** **repl**: Use displayErrors for SyntaxError (Prince J Wesley) [#7589](https://github.com/nodejs/node/pull/7589)
* [[`b3164ae22e`](https://github.com/nodejs/node/commit/b3164ae22e)] - **(SEMVER-MINOR)** **repl**: add support for custom completions (Diosney Sarmiento) [#7527](https://github.com/nodejs/node/pull/7527)
* [[`980f4da8c4`](https://github.com/nodejs/node/commit/980f4da8c4)] - **repl**: prevent undefined ref in completion (Evan Lucas) [#7718](https://github.com/nodejs/node/pull/7718)
* [[`6e6cf36761`](https://github.com/nodejs/node/commit/6e6cf36761)] - **repl**: default useGlobal to true (cjihrig) [#7795](https://github.com/nodejs/node/pull/7795)
* [[`08e6eeee70`](https://github.com/nodejs/node/commit/08e6eeee70)] - **repl,util**: insert carriage returns in output (JungMinu) [#8028](https://github.com/nodejs/node/pull/8028)
* [[`fb8840cac2`](https://github.com/nodejs/node/commit/fb8840cac2)] - **src**: use RAII for mutexes in node_watchdog.cc (Anna Henningsen) [#7933](https://github.com/nodejs/node/pull/7933)
* [[`780395ffca`](https://github.com/nodejs/node/commit/780395ffca)] - **src**: fix use-after-free in inspector agent (Ben Noordhuis) [#7907](https://github.com/nodejs/node/pull/7907)
* [[`9d45569ed4`](https://github.com/nodejs/node/commit/9d45569ed4)] - **src**: avoid manual memory management in inspector (Ben Noordhuis) [#7906](https://github.com/nodejs/node/pull/7906)
* [[`a20336e708`](https://github.com/nodejs/node/commit/a20336e708)] - **src**: remove unused using decls (Haojian Wu) [#7990](https://github.com/nodejs/node/pull/7990)
* [[`317ae96c33`](https://github.com/nodejs/node/commit/317ae96c33)] - **src**: make EnvDelete behave like the delete operator (Franziska Hinkelmann) [#7975](https://github.com/nodejs/node/pull/7975)
* [[`1ab796fa96`](https://github.com/nodejs/node/commit/1ab796fa96)] - **src**: do not copy on failing setProperty() (Franziska Hinkelmann) [#7908](https://github.com/nodejs/node/pull/7908)
* [[`cf65a7ce9e`](https://github.com/nodejs/node/commit/cf65a7ce9e)] - **src**: unifying PipeConnectWrap and TCPConnectWrap (Daniel Bevenius) [#7501](https://github.com/nodejs/node/pull/7501)
* [[`63c62cce35`](https://github.com/nodejs/node/commit/63c62cce35)] - **src**: Only use TR1 type_traits on OSX<10.9 (Ehsan Akhgari) [#7778](https://github.com/nodejs/node/pull/7778)
* [[`d7143095cb`](https://github.com/nodejs/node/commit/d7143095cb)] - **src**: fix build on CentOS (Rich Trott) [#7873](https://github.com/nodejs/node/pull/7873)
* [[`303f4102d3`](https://github.com/nodejs/node/commit/303f4102d3)] - **src**: pull OnConnection from pipe_wrap and tcp_wrap (Daniel Bevenius) [#7547](https://github.com/nodejs/node/pull/7547)
* [[`c967af8c07`](https://github.com/nodejs/node/commit/c967af8c07)] - **src**: suppress coverity message (cjihrig) [#7587](https://github.com/nodejs/node/pull/7587)
* [[`f3e5b39696`](https://github.com/nodejs/node/commit/f3e5b39696)] - **src**: guard against overflow in ParseArrayIndex() (Ben Noordhuis) [#7497](https://github.com/nodejs/node/pull/7497)
* [[`c730a5d026`](https://github.com/nodejs/node/commit/c730a5d026)] - **src**: move ParseArrayIndex() to src/node_buffer.cc (Ben Noordhuis) [#7497](https://github.com/nodejs/node/pull/7497)
* [[`da9bd2fc48`](https://github.com/nodejs/node/commit/da9bd2fc48)] - **src**: alias BINARY to LATIN1 (Ben Noordhuis) [#7284](https://github.com/nodejs/node/pull/7284)
* [[`7ba0f860a6`](https://github.com/nodejs/node/commit/7ba0f860a6)] - **src**: fix erroneous fallthrough in ParseEncoding() (Ben Noordhuis) [#7262](https://github.com/nodejs/node/pull/7262)
* [[`a059aea9a2`](https://github.com/nodejs/node/commit/a059aea9a2)] - **src**: remove final trace of raw encoding (Trevor Norris) [#7111](https://github.com/nodejs/node/pull/7111)
* [[`2db26cb165`](https://github.com/nodejs/node/commit/2db26cb165)] - **test**: add test for debug usage message (Rich Trott) [#8061](https://github.com/nodejs/node/pull/8061)
* [[`2e435998eb`](https://github.com/nodejs/node/commit/2e435998eb)] - **test**: mark test failing on AIX as flaky (Michael Dawson) [#8065](https://github.com/nodejs/node/pull/8065)
* [[`554b0f9d91`](https://github.com/nodejs/node/commit/554b0f9d91)] - **test**: fix failing inspector cctest (Eugene Ostroukhov) [#8019](https://github.com/nodejs/node/pull/8019)
* [[`c565c17636`](https://github.com/nodejs/node/commit/c565c17636)] - **test**: fix memory leaks in inspector tests (Ben Noordhuis) [#7906](https://github.com/nodejs/node/pull/7906)
* [[`5d68e4ba9b`](https://github.com/nodejs/node/commit/5d68e4ba9b)] - **test**: console constructor missing new keyword (Rich Trott) [#8003](https://github.com/nodejs/node/pull/8003)
* [[`9735accd3e`](https://github.com/nodejs/node/commit/9735accd3e)] - **test**: allow globals to be whitelisted (cjihrig) [#7826](https://github.com/nodejs/node/pull/7826)
* [[`a385277eb5`](https://github.com/nodejs/node/commit/a385277eb5)] - **test**: fix flaky test-vm-sigint-existing-handler (Anna Henningsen) [#7982](https://github.com/nodejs/node/pull/7982)
* [[`b5beae2529`](https://github.com/nodejs/node/commit/b5beae2529)] - **test**: remove internal headers from addons (Gibson Fahnestock) [#7947](https://github.com/nodejs/node/pull/7947)
* [[`02b12fe880`](https://github.com/nodejs/node/commit/02b12fe880)] - **test**: improve chained property readability (Rich Trott) [#7920](https://github.com/nodejs/node/pull/7920)
* [[`d94063a22b`](https://github.com/nodejs/node/commit/d94063a22b)] - **test**: fix test-vm-sigint flakiness (Santiago Gimeno) [#7854](https://github.com/nodejs/node/pull/7854)
* [[`facd7dade1`](https://github.com/nodejs/node/commit/facd7dade1)] - **test**: don't hard code deprecation count (Prince J Wesley) [#7927](https://github.com/nodejs/node/pull/7927)
* [[`4aee970d92`](https://github.com/nodejs/node/commit/4aee970d92)] - **test**: decrease inconsistency in the common.js (Vse Mozhet Byt) [#7758](https://github.com/nodejs/node/pull/7758)
* [[`10f0c94c35`](https://github.com/nodejs/node/commit/10f0c94c35)] - **test**: fix flaky test-tls-wrap-timeout (Rich Trott) [#7857](https://github.com/nodejs/node/pull/7857)
* [[`ccfa6bf4d4`](https://github.com/nodejs/node/commit/ccfa6bf4d4)] - **test**: speed up test-net-reconnect-error (Rich Trott) [#7886](https://github.com/nodejs/node/pull/7886)
* [[`577adc74cd`](https://github.com/nodejs/node/commit/577adc74cd)] - **test**: ensure stream preprocessing order (Vse Mozhet Byt) [#7741](https://github.com/nodejs/node/pull/7741)
* [[`8f51e36898`](https://github.com/nodejs/node/commit/8f51e36898)] - **test**: use common platform helpers everywhere (Santiago Gimeno) [#7845](https://github.com/nodejs/node/pull/7845)
* [[`2f45941807`](https://github.com/nodejs/node/commit/2f45941807)] - **test**: handle IPv6 localhost issues within tests (Rich Trott) [#7766](https://github.com/nodejs/node/pull/7766)
* [[`e56db1477c`](https://github.com/nodejs/node/commit/e56db1477c)] - **test**: fix flaky test-*-connect-address-family (Rich Trott) [#7605](https://github.com/nodejs/node/pull/7605)
* [[`1ab6df6b04`](https://github.com/nodejs/node/commit/1ab6df6b04)] - **test**: make import common as the first line (Sakthipriyan Vairamani) [#7786](https://github.com/nodejs/node/pull/7786)
* [[`0daceffd38`](https://github.com/nodejs/node/commit/0daceffd38)] - **test,assert**: add deepEqual/deepStrictEqual tests for typed arrays (Feross Aboukhadijeh) [#8002](https://github.com/nodejs/node/pull/8002)
* [[`4416ffab8a`](https://github.com/nodejs/node/commit/4416ffab8a)] - **test,util**: fix flaky test-util-sigint-watchdog (Anna Henningsen) [#7933](https://github.com/nodejs/node/pull/7933)
* [[`4535149794`](https://github.com/nodejs/node/commit/4535149794)] - **timers**: remove unused repeat param in timer_wrap (Jan Schär) [#7994](https://github.com/nodejs/node/pull/7994)
* [[`381aef8145`](https://github.com/nodejs/node/commit/381aef8145)] - **timers**: fix cleanup of nested same-timeout timers (Erin Spiceland) [#7827](https://github.com/nodejs/node/pull/7827)
* [[`e611c293bb`](https://github.com/nodejs/node/commit/e611c293bb)] - **tools**: enable rest-spread-spacing (Rich Trott) [#8073](https://github.com/nodejs/node/pull/8073)
* [[`7eb0e7a479`](https://github.com/nodejs/node/commit/7eb0e7a479)] - **tools**: favor === over == in license2rtf.js (Rich Trott)
* [[`583a2515da`](https://github.com/nodejs/node/commit/583a2515da)] - **tools**: update license-builder.sh for v8_inspector (Ali Ijaz Sheikh) [#7796](https://github.com/nodejs/node/pull/7796)
* [[`97934f99bb`](https://github.com/nodejs/node/commit/97934f99bb)] - **tools**: enable linting for chained properties (Rich Trott) [#7999](https://github.com/nodejs/node/pull/7999)
* [[`60ff991c09`](https://github.com/nodejs/node/commit/60ff991c09)] - **tools**: update to ESLint 3.2.2 (Rich Trott) [#7999](https://github.com/nodejs/node/pull/7999)
* [[`d37a17ec5f`](https://github.com/nodejs/node/commit/d37a17ec5f)] - **tools**: add remark-lint configuration in .remarkrc (Сковорода Никита Андреевич) [#7729](https://github.com/nodejs/node/pull/7729)
* [[`cb16e97e9f`](https://github.com/nodejs/node/commit/cb16e97e9f)] - **tools**: add .vscode folder to .gitignore (Josh Gavant) [#7967](https://github.com/nodejs/node/pull/7967)
* [[`fecf611ca8`](https://github.com/nodejs/node/commit/fecf611ca8)] - **tools,test**: show signal code when test crashes (Santiago Gimeno) [#7859](https://github.com/nodejs/node/pull/7859)
* [[`2f20910e24`](https://github.com/nodejs/node/commit/2f20910e24)] - **tty**: set the handle to blocking mode (Jeremiah Senkpiel) [#6816](https://github.com/nodejs/node/pull/6816)
* [[`cfec3ae5fd`](https://github.com/nodejs/node/commit/cfec3ae5fd)] - **(SEMVER-MINOR)** **util**: add inspect.defaultOptions (Roman Reiss) [#8013](https://github.com/nodejs/node/pull/8013)
* [[`295d1ea016`](https://github.com/nodejs/node/commit/295d1ea016)] - **util**: support classes in util.deprecate() (vladimir) [#7690](https://github.com/nodejs/node/pull/7690)
* [[`0a07201ca1`](https://github.com/nodejs/node/commit/0a07201ca1)] - **util**: fix formatting of objects with SIMD enabled (Anna Henningsen) [#7864](https://github.com/nodejs/node/pull/7864)
* [[`f1c50a8c5e`](https://github.com/nodejs/node/commit/f1c50a8c5e)] - **win,msi**: fix inclusion of translations (João Reis) [#7798](https://github.com/nodejs/node/pull/7798)
* [[`dbbcb9dbd9`](https://github.com/nodejs/node/commit/dbbcb9dbd9)] - **win,msi**: Added Italian translation (Matteo Collina) [#4647](https://github.com/nodejs/node/pull/4647)
* [[`909254c901`](https://github.com/nodejs/node/commit/909254c901)] - **zlib**: remove unneeded property (Jan Schär) [#7987](https://github.com/nodejs/node/pull/7987)

<a id="6.3.1"></a>
## 2016-07-21, Version 6.3.1 (Current), @evanlucas

### Notable changes

* **buffer**:
  * Improve performance of Buffer.from(str, 'hex') and Buffer#write(str, 'hex'). (Christopher Jeffrey) [#7602](https://github.com/nodejs/node/pull/7602)
  * Fix creating from zero-length ArrayBuffer. (Ingvar Stepanyan) [#7176](https://github.com/nodejs/node/pull/7176)
* **deps**:
  * Upgrade to V8 5.0.71.57. (Ben Noordhuis) [#7531](https://github.com/nodejs/node/pull/7531)
  * Backport V8 instanceof bugfix (Franziska Hinkelmann) [#7638](https://github.com/nodejs/node/pull/7638)
* **repl**: Fix issue with function redeclaration. (Prince J Wesley) [#7794](https://github.com/nodejs/node/pull/7794)
* **util**: Fix inspecting of boxed symbols. (Anna Henningsen) [#7641](https://github.com/nodejs/node/pull/7641)

### Commits

* [[`3747d910ec`](https://github.com/nodejs/node/commit/3747d910ec)] - **benchmark**: remove unused variables (Rich Trott) [#7600](https://github.com/nodejs/node/pull/7600)
* [[`41582722c8`](https://github.com/nodejs/node/commit/41582722c8)] - **buffer**: optimize hex_decode (Christopher Jeffrey) [#7602](https://github.com/nodejs/node/pull/7602)
* [[`4a3300e66b`](https://github.com/nodejs/node/commit/4a3300e66b)] - **buffer**: fix creating from zero-length ArrayBuffer (Ingvar Stepanyan) [#7176](https://github.com/nodejs/node/pull/7176)
* [[`71f84b5e6c`](https://github.com/nodejs/node/commit/71f84b5e6c)] - **build**: add conflict marker check during CI lint (Brian White) [#7625](https://github.com/nodejs/node/pull/7625)
* [[`4480b14fda`](https://github.com/nodejs/node/commit/4480b14fda)] - **build**: use BUILDTYPE when building V8 in Makefile (Michaël Zasso) [#7482](https://github.com/nodejs/node/pull/7482)
* [[`94a486a388`](https://github.com/nodejs/node/commit/94a486a388)] - **build**: add v8 requirement to test-v8* in Makefile (Michaël Zasso) [#7482](https://github.com/nodejs/node/pull/7482)
* [[`e5627278f1`](https://github.com/nodejs/node/commit/e5627278f1)] - **build**: add --enable-d8 configure option (Ben Noordhuis) [#7538](https://github.com/nodejs/node/pull/7538)
* [[`933ff62fa5`](https://github.com/nodejs/node/commit/933ff62fa5)] - **build**: respect --shared-* flags for inspector deps (Сковорода Никита Андреевич) [#7569](https://github.com/nodejs/node/pull/7569)
* [[`9bb1024dc3`](https://github.com/nodejs/node/commit/9bb1024dc3)] - **child_process**: Check stderr before accessing it (Robert Chiras) [#6877](https://github.com/nodejs/node/pull/6877)
* [[`f574bd4cec`](https://github.com/nodejs/node/commit/f574bd4cec)] - **cluster**: remove bind() and self (cjihrig) [#7710](https://github.com/nodejs/node/pull/7710)
* [[`164981af5f`](https://github.com/nodejs/node/commit/164981af5f)] - **deps**: bump V8 patchlevel for instanceof cherry-picks (Franziska Hinkelmann) [#7638](https://github.com/nodejs/node/pull/7638)
* [[`287006149b`](https://github.com/nodejs/node/commit/287006149b)] - **deps**: cherry-pick 5b5d24b for X87 from V8 upstream (Franziska Hinkelmann) [#7638](https://github.com/nodejs/node/pull/7638)
* [[`e5cce7acfe`](https://github.com/nodejs/node/commit/e5cce7acfe)] - **deps**: cherry-pick 3a903c4 for PPC from V8 upstream (Franziska Hinkelmann) [#7638](https://github.com/nodejs/node/pull/7638)
* [[`e23904523f`](https://github.com/nodejs/node/commit/e23904523f)] - **deps**: cherry-pick 2aa070be from V8 upstream (Franziska Hinkelmann) [#7638](https://github.com/nodejs/node/pull/7638)
* [[`d3f0a6a52f`](https://github.com/nodejs/node/commit/d3f0a6a52f)] - **deps**: cherry-pick 1f53e42 from v8 upstream (Ben Noordhuis) [#7612](https://github.com/nodejs/node/pull/7612)
* [[`cf8a4889db`](https://github.com/nodejs/node/commit/cf8a4889db)] - **deps**: v8_inspector no longer depends on wtf (Ali Ijaz Sheikh) [#7751](https://github.com/nodejs/node/pull/7751)
* [[`939cf6ddb2`](https://github.com/nodejs/node/commit/939cf6ddb2)] - **deps**: no /safeseh for ml64.exe (Fedor Indutny) [#7759](https://github.com/nodejs/node/pull/7759)
* [[`abf86adee1`](https://github.com/nodejs/node/commit/abf86adee1)] - **deps**: back-port d721121 from v8 upstream (Ben Noordhuis) [#7633](https://github.com/nodejs/node/pull/7633)
* [[`dbdcded866`](https://github.com/nodejs/node/commit/dbdcded866)] - **deps**: upgrade to V8 5.0.71.54 (Ben Noordhuis) [#7531](https://github.com/nodejs/node/pull/7531)
* [[`4839ef37a9`](https://github.com/nodejs/node/commit/4839ef37a9)] - **doc**: correcting misspelling (Vitaly Tomilov) [#7797](https://github.com/nodejs/node/pull/7797)
* [[`3343d46f2c`](https://github.com/nodejs/node/commit/3343d46f2c)] - **doc**: general improvments to events documentation (Sakthipriyan Vairamani) [#7480](https://github.com/nodejs/node/pull/7480)
* [[`e8a6a223ec`](https://github.com/nodejs/node/commit/e8a6a223ec)] - **doc**: update readme with andrasq as a collaborator (Andras) [#7801](https://github.com/nodejs/node/pull/7801)
* [[`59ed303612`](https://github.com/nodejs/node/commit/59ed303612)] - **doc**: update CTC governance information (Rich Trott) [#7719](https://github.com/nodejs/node/pull/7719)
* [[`4b320adb49`](https://github.com/nodejs/node/commit/4b320adb49)] - **doc**: correct sample output of buf.compare (Hargobind S. Khalsa) [#7777](https://github.com/nodejs/node/pull/7777)
* [[`9847f8459c`](https://github.com/nodejs/node/commit/9847f8459c)] - **doc**: add `added:` information for stream (Italo A. Casas) [#7287](https://github.com/nodejs/node/pull/7287)
* [[`1f003590d6`](https://github.com/nodejs/node/commit/1f003590d6)] - **doc**: fix inconsistencies in code style (saadq) [#7745](https://github.com/nodejs/node/pull/7745)
* [[`9c274e32fd`](https://github.com/nodejs/node/commit/9c274e32fd)] - **doc**: Warn against `uncaughtException` dependency. (Lance Ball) [#6378](https://github.com/nodejs/node/pull/6378)
* [[`fc4df0df6c`](https://github.com/nodejs/node/commit/fc4df0df6c)] - **doc**: fix typo in stream doc (Kevin Donahue) [#7738](https://github.com/nodejs/node/pull/7738)
* [[`2a023bfd00`](https://github.com/nodejs/node/commit/2a023bfd00)] - **doc**: removed old git conflict markers from fs.md (Jaime Hidalgo García) [#7590](https://github.com/nodejs/node/pull/7590)
* [[`1d07d29bfe`](https://github.com/nodejs/node/commit/1d07d29bfe)] - **doc**: fix typo in the CHANGELOG_V6 (vsemozhetbyt) [#7568](https://github.com/nodejs/node/pull/7568)
* [[`f15d2d6dae`](https://github.com/nodejs/node/commit/f15d2d6dae)] - **doc**: fix util.deprecate() example (Evan Lucas) [#7674](https://github.com/nodejs/node/pull/7674)
* [[`58b70d34ee`](https://github.com/nodejs/node/commit/58b70d34ee)] - **doc**: link and highlight Object.assign (Sakthipriyan Vairamani) [#7670](https://github.com/nodejs/node/pull/7670)
* [[`cc7fdf429e`](https://github.com/nodejs/node/commit/cc7fdf429e)] - **doc**: grammar fixes to event loop guide (Ryan Lewis) [#7479](https://github.com/nodejs/node/pull/7479)
* [[`a81ff702cc`](https://github.com/nodejs/node/commit/a81ff702cc)] - **doc**: dns.resolve fix callback argument description (Quentin Headen) [#7532](https://github.com/nodejs/node/pull/7532)
* [[`f0c335c347`](https://github.com/nodejs/node/commit/f0c335c347)] - **doc**: add benchmark who-to-CC info (Rich Trott) [#7604](https://github.com/nodejs/node/pull/7604)
* [[`9e0cba0552`](https://github.com/nodejs/node/commit/9e0cba0552)] - **doc**: added information on how to run the linter. (Diosney Sarmiento) [#7534](https://github.com/nodejs/node/pull/7534)
* [[`e13ee29cbd`](https://github.com/nodejs/node/commit/e13ee29cbd)] - **doc**: delete non-existing zlib constants (Franziska Hinkelmann) [#7520](https://github.com/nodejs/node/pull/7520)
* [[`663b103bc5`](https://github.com/nodejs/node/commit/663b103bc5)] - **doc**: fix minor style issues in http.md (Rich Trott) [#7528](https://github.com/nodejs/node/pull/7528)
* [[`6c4d4596cc`](https://github.com/nodejs/node/commit/6c4d4596cc)] - **doc**: updating REPLACEME tag during release (Gibson Fahnestock) [#7514](https://github.com/nodejs/node/pull/7514)
* [[`b4547340ee`](https://github.com/nodejs/node/commit/b4547340ee)] - **doc**: fix detached child stdio example (cjihrig) [#7540](https://github.com/nodejs/node/pull/7540)
* [[`0f7b4efaaf`](https://github.com/nodejs/node/commit/0f7b4efaaf)] - **doc**: add bartosz sosnowski to colaborators (Bartosz Sosnowski) [#7567](https://github.com/nodejs/node/pull/7567)
* [[`77afeb2ec7`](https://github.com/nodejs/node/commit/77afeb2ec7)] - **doc,dgram**: fix addMembership documentation (Santiago Gimeno) [#7244](https://github.com/nodejs/node/pull/7244)
* [[`11d6f1af59`](https://github.com/nodejs/node/commit/11d6f1af59)] - **fs**: rename event to eventType in fs.watch listener (Claudio Rodriguez) [#7506](https://github.com/nodejs/node/pull/7506)
* [[`989a2a1c92`](https://github.com/nodejs/node/commit/989a2a1c92)] - **inspector**: Unify event queues (Eugene Ostroukhov) [#7271](https://github.com/nodejs/node/pull/7271)
* [[`fc0ed2e8c7`](https://github.com/nodejs/node/commit/fc0ed2e8c7)] - **lib,benchmark,test**: implement consistent braces (Rich Trott) [#7630](https://github.com/nodejs/node/pull/7630)
* [[`80ca0630a6`](https://github.com/nodejs/node/commit/80ca0630a6)] - **net**: export isIPv4, isIPv6 directly from cares (Sakthipriyan Vairamani) [#7481](https://github.com/nodejs/node/pull/7481)
* [[`72fc4ebca2`](https://github.com/nodejs/node/commit/72fc4ebca2)] - **repl**: Mitigate vm #548 function redefinition issue (Prince J Wesley) [#7794](https://github.com/nodejs/node/pull/7794)
* [[`f97aa4be39`](https://github.com/nodejs/node/commit/f97aa4be39)] - **src**: remove unnecessary HandleScopes (Ben Noordhuis) [#7711](https://github.com/nodejs/node/pull/7711)
* [[`78dcf0d641`](https://github.com/nodejs/node/commit/78dcf0d641)] - **src**: fix handle leak in UDPWrap::Instantiate() (Ben Noordhuis) [#7711](https://github.com/nodejs/node/pull/7711)
* [[`dc766e6a6f`](https://github.com/nodejs/node/commit/dc766e6a6f)] - **src**: fix handle leak in BuildStatsObject() (Ben Noordhuis) [#7711](https://github.com/nodejs/node/pull/7711)
* [[`96882e14d1`](https://github.com/nodejs/node/commit/96882e14d1)] - **src**: fix handle leak in Buffer::New() (Ben Noordhuis) [#7711](https://github.com/nodejs/node/pull/7711)
* [[`fbc9ef84b8`](https://github.com/nodejs/node/commit/fbc9ef84b8)] - **src**: disable stdio buffering (Ben Noordhuis) [#7610](https://github.com/nodejs/node/pull/7610)
* [[`44c9a72aad`](https://github.com/nodejs/node/commit/44c9a72aad)] - **test**: add regression test for instanceof (Franziska Hinkelmann) [#7638](https://github.com/nodejs/node/pull/7638)
* [[`2e05e65916`](https://github.com/nodejs/node/commit/2e05e65916)] - **test**: add known issue test for #7788 (cjihrig) [#7793](https://github.com/nodejs/node/pull/7793)
* [[`7fb4794e19`](https://github.com/nodejs/node/commit/7fb4794e19)] - **test**: increase RAM requirement for intensive tests (Rich Trott) [#7772](https://github.com/nodejs/node/pull/7772)
* [[`61542e82c1`](https://github.com/nodejs/node/commit/61542e82c1)] - **test**: ensure callback runs in test-vm-sigint (Rich Trott) [#7768](https://github.com/nodejs/node/pull/7768)
* [[`9e9d499b8b`](https://github.com/nodejs/node/commit/9e9d499b8b)] - **test**: use mustCall() for simple flow tracking (cjihrig) [#7753](https://github.com/nodejs/node/pull/7753)
* [[`83cbf3175c`](https://github.com/nodejs/node/commit/83cbf3175c)] - **test**: avoid usage of mixed IPV6 addresses (Gireesh Punathil) [#7702](https://github.com/nodejs/node/pull/7702)
* [[`39f5d9ca7a`](https://github.com/nodejs/node/commit/39f5d9ca7a)] - **test**: fix flaky test-http-server-consumed-timeout (Rich Trott) [#7717](https://github.com/nodejs/node/pull/7717)
* [[`3ed0204f23`](https://github.com/nodejs/node/commit/3ed0204f23)] - **test**: s/assert.fail/common.fail as appropriate (cjihrig) [#7735](https://github.com/nodejs/node/pull/7735)
* [[`f7651d24d4`](https://github.com/nodejs/node/commit/f7651d24d4)] - **test**: improve error message in test-tick-processor (Rich Trott) [#7693](https://github.com/nodejs/node/pull/7693)
* [[`acb976ac26`](https://github.com/nodejs/node/commit/acb976ac26)] - **test**: cleanup IIFE tests (cjihrig) [#7694](https://github.com/nodejs/node/pull/7694)
* [[`432cb353e1`](https://github.com/nodejs/node/commit/432cb353e1)] - **test**: add common.rootDir (cjihrig) [#7685](https://github.com/nodejs/node/pull/7685)
* [[`9797969ad4`](https://github.com/nodejs/node/commit/9797969ad4)] - **test**: fix old tty tests (Jeremiah Senkpiel) [#7613](https://github.com/nodejs/node/pull/7613)
* [[`37dc7954d8`](https://github.com/nodejs/node/commit/37dc7954d8)] - **test**: move parallel/test-tty-* to pseudo-tty/ (Jeremiah Senkpiel) [#7613](https://github.com/nodejs/node/pull/7613)
* [[`5192bed68c`](https://github.com/nodejs/node/commit/5192bed68c)] - **test**: remove unused var from child-process-fork (Rich Trott) [#7599](https://github.com/nodejs/node/pull/7599)
* [[`e1aedbf671`](https://github.com/nodejs/node/commit/e1aedbf671)] - **test**: remove unused vars from http/https tests (Rich Trott) [#7598](https://github.com/nodejs/node/pull/7598)
* [[`64e2eed662`](https://github.com/nodejs/node/commit/64e2eed662)] - **test**: remove unused var in test-tls-server-verify (Rich Trott) [#7595](https://github.com/nodejs/node/pull/7595)
* [[`8e50413b7e`](https://github.com/nodejs/node/commit/8e50413b7e)] - **test**: fix flaky test-fs-read-buffer-tostring-fail (Rich Trott) [#7575](https://github.com/nodejs/node/pull/7575)
* [[`447a8f26e1`](https://github.com/nodejs/node/commit/447a8f26e1)] - **test**: remove unused var in net-server-try-ports (Rich Trott) [#7597](https://github.com/nodejs/node/pull/7597)
* [[`326006527d`](https://github.com/nodejs/node/commit/326006527d)] - **test**: remove unused var from stream2 test (Rich Trott) [#7596](https://github.com/nodejs/node/pull/7596)
* [[`97167291e7`](https://github.com/nodejs/node/commit/97167291e7)] - **test**: fix flaky test-net-write-slow (Rich Trott) [#7555](https://github.com/nodejs/node/pull/7555)
* [[`657fd7aee9`](https://github.com/nodejs/node/commit/657fd7aee9)] - **test**: skip doctool tests when js-yaml is missing (Anna Henningsen) [#7218](https://github.com/nodejs/node/pull/7218)
* [[`1576730ef3`](https://github.com/nodejs/node/commit/1576730ef3)] - **test,doc**: clarify `buf.indexOf(num)` input range (Anna Henningsen) [#7611](https://github.com/nodejs/node/pull/7611)
* [[`49a6ea1b73`](https://github.com/nodejs/node/commit/49a6ea1b73)] - **timers**: fix processing of nested timers (Jeremy Whitlock) [#3063](https://github.com/nodejs/node/pull/3063)
* [[`5a2ce3633f`](https://github.com/nodejs/node/commit/5a2ce3633f)] - **tools**: consistent .eslintrc formatting (silverwind) [#7691](https://github.com/nodejs/node/pull/7691)
* [[`2a84da5d09`](https://github.com/nodejs/node/commit/2a84da5d09)] - **tools**: increase lint coverage (Rich Trott) [#7647](https://github.com/nodejs/node/pull/7647)
* [[`a82573d480`](https://github.com/nodejs/node/commit/a82573d480)] - **tools**: enforce JS brace style with linting (Rich Trott) [#7630](https://github.com/nodejs/node/pull/7630)
* [[`8efca46e78`](https://github.com/nodejs/node/commit/8efca46e78)] - **tools**: fix broken format string (Sakthipriyan Vairamani) [#7620](https://github.com/nodejs/node/pull/7620)
* [[`2bef583f8a`](https://github.com/nodejs/node/commit/2bef583f8a)] - **tools**: cleanup no-build and build-only options (Sakthipriyan Vairamani) [#7620](https://github.com/nodejs/node/pull/7620)
* [[`df697c486e`](https://github.com/nodejs/node/commit/df697c486e)] - **tools**: update ESLint, fix unused vars bug (Rich Trott) [#7601](https://github.com/nodejs/node/pull/7601)
* [[`1a360d63db`](https://github.com/nodejs/node/commit/1a360d63db)] - **tools**: remove unused variable (Rich Trott) [#7594](https://github.com/nodejs/node/pull/7594)
* [[`fa99dadda4`](https://github.com/nodejs/node/commit/fa99dadda4)] - **tools**: remove unnecessary imports and assignments (Sakthipriyan Vairamani) [#7483](https://github.com/nodejs/node/pull/7483)
* [[`0858e620e9`](https://github.com/nodejs/node/commit/0858e620e9)] - **util**: inspect boxed symbols like other primitives (Anna Henningsen) [#7641](https://github.com/nodejs/node/pull/7641)

<a id="6.3.0"></a>
## 2016-07-06, Version 6.3.0 (Current), @Fishrock123

### Notable changes

* **buffer**: Added `buffer.swap64()` to complement `swap16()` & `swap32()`. (Zach Bjornson) [#7157](https://github.com/nodejs/node/pull/7157)
* **build**: New `configure` options have been added for building Node.js as a shared library. (Stefan Budeanu) [#6994](https://github.com/nodejs/node/pull/6994)
  - The options are: `--shared`, `--without-v8-platform` & `--without-bundled-v8`.
* **crypto**: Root certificates have been updated. (Ben Noordhuis) [#7363](https://github.com/nodejs/node/pull/7363)
* **debugger**: The server address is now configurable via `--debug=<address>:<port>`. (Ben Noordhuis) [#3316](https://github.com/nodejs/node/pull/3316)
* **npm**: Upgraded npm to v3.10.3 (Kat Marchán) [#7515](https://github.com/nodejs/node/pull/7515) & (Rebecca Turner) [#7410](https://github.com/nodejs/node/pull/7410)
* **readline**: Added the `prompt` option to the readline constructor. (Evan Lucas) [#7125](https://github.com/nodejs/node/pull/7125)
* **repl / vm**: `sigint`/`ctrl+c` will now break out of infinite loops without stopping the Node.js instance. (Anna Henningsen) [#6635](https://github.com/nodejs/node/pull/6635)
* **src**:
  - Added a `node::FreeEnvironment` public C++ API. (Cheng Zhao) [#3098](https://github.com/nodejs/node/pull/3098)
  - Refactored `require('constants')`, constants are now available directly from their respective modules. (James M Snell) [#6534](https://github.com/nodejs/node/pull/6534)
* **stream**: Improved `readable.read()` performance by up to 70%. (Brian White) [#7077](https://github.com/nodejs/node/pull/7077)
* **timers**: `setImmediate()` is now up to 150% faster in some situations. (Andras) [#6436](https://github.com/nodejs/node/pull/6436)
* **util**: Added a `breakLength` option to `util.inspect()` to control how objects are formatted across lines. (cjihrig) [#7499](https://github.com/nodejs/node/pull/7499)
* **v8-inspector**: Experimental support has been added for debugging Node.js over the inspector protocol. (Ali Ijaz Sheikh) [#6792](https://github.com/nodejs/node/pull/6792)
  - **Note: This feature is _experimental_, and it could be altered or removed.**
  - You can try this feature by running Node.js with the `--inspect` flag.

### Commits

* [[`40211e80f2`](https://github.com/nodejs/node/commit/40211e80f2)] - **assert**: remove unneeded arguments special handling (Rich Trott) [#7413](https://github.com/nodejs/node/pull/7413)
* [[`44f0f940c8`](https://github.com/nodejs/node/commit/44f0f940c8)] - **benchmark**: add `setImmediate()` benchmarks (Andras) [#6436](https://github.com/nodejs/node/pull/6436)
* [[`35c70b5668`](https://github.com/nodejs/node/commit/35c70b5668)] - **benchmark**: `util._extend` vs `object.assign` (surya panikkal) [#7255](https://github.com/nodejs/node/pull/7255)
* [[`4014ecbfb4`](https://github.com/nodejs/node/commit/4014ecbfb4)] - **(SEMVER-MINOR)** **buffer**: speed up swap16/32, add swap64 (Zach Bjornson) [#7157](https://github.com/nodejs/node/pull/7157)
* [[`ac8e1bf609`](https://github.com/nodejs/node/commit/ac8e1bf609)] - **buffer**: improve creation performance. (Ingvar Stepanyan) [#7349](https://github.com/nodejs/node/pull/7349)
* [[`5e4113e58d`](https://github.com/nodejs/node/commit/5e4113e58d)] - **build**: Fix compile failure in `backtrace_posix.cc` (Michael Dawson) [#7544](https://github.com/nodejs/node/pull/7544)
* [[`15a32dd42b`](https://github.com/nodejs/node/commit/15a32dd42b)] - **build**: export openssl symbols on windows (Ben Noordhuis) [#6274](https://github.com/nodejs/node/pull/6274)
* [[`b829a4969f`](https://github.com/nodejs/node/commit/b829a4969f)] - **build**: enable big toc for release builds in AIX (Gireesh Punathil) [#7508](https://github.com/nodejs/node/pull/7508)
* [[`9b5be44b01`](https://github.com/nodejs/node/commit/9b5be44b01)] - **build**: split CI rules in Makefile (João Reis) [#7317](https://github.com/nodejs/node/pull/7317)
* [[`1bd6a623a0`](https://github.com/nodejs/node/commit/1bd6a623a0)] - **build**: drop unconditional openssl dep from cctest (Ben Noordhuis) [#7486](https://github.com/nodejs/node/pull/7486)
* [[`8a31b234ee`](https://github.com/nodejs/node/commit/8a31b234ee)] - **build**: remove unused files from `CPPLINT_FILES` (Ben Noordhuis) [#7462](https://github.com/nodejs/node/pull/7462)
* [[`91744aaf00`](https://github.com/nodejs/node/commit/91744aaf00)] - **build**: configure `--shared` (Stefan Budeanu) [#6994](https://github.com/nodejs/node/pull/6994)
* [[`2aa06b9fa0`](https://github.com/nodejs/node/commit/2aa06b9fa0)] - **child\_process**: preserve argument type (Rich Trott) [#7391](https://github.com/nodejs/node/pull/7391)
* [[`4a0fb6fcb8`](https://github.com/nodejs/node/commit/4a0fb6fcb8)] - ***Revert*** "**child\_process**: measure buffer length in bytes" (Rich Trott) [#7391](https://github.com/nodejs/node/pull/7391)
* [[`c1bd3fe14c`](https://github.com/nodejs/node/commit/c1bd3fe14c)] - **(SEMVER-MINOR)** **cluster**: work with `v8_inspector` (cjihrig) [#6792](https://github.com/nodejs/node/pull/6792)
* [[`fa9e6f7463`](https://github.com/nodejs/node/commit/fa9e6f7463)] - **crypto**: Allow GCM ciphers to have a longer IV length (Michael Wain) [#6376](https://github.com/nodejs/node/pull/6376)
* [[`ef41c8bd8e`](https://github.com/nodejs/node/commit/ef41c8bd8e)] - **crypto**: update root certificates (Ben Noordhuis) [#7363](https://github.com/nodejs/node/pull/7363)
* [[`2c7804ad9e`](https://github.com/nodejs/node/commit/2c7804ad9e)] - **crypto,tls**: perf improvements for crypto and tls getCiphers (James M Snell) [#7225](https://github.com/nodejs/node/pull/7225)
* [[`4891001d7e`](https://github.com/nodejs/node/commit/4891001d7e)] - **(SEMVER-MINOR)** **debugger**: make listen address configurable (Ben Noordhuis) [#3316](https://github.com/nodejs/node/pull/3316)
* [[`5bb63e13d1`](https://github.com/nodejs/node/commit/5bb63e13d1)] - **deps**: upgrade npm to 3.10.3 (Kat Marchán) [#7515](https://github.com/nodejs/node/pull/7515)
* [[`581e6deeda`](https://github.com/nodejs/node/commit/581e6deeda)] - **deps**: upgrade npm to 3.10.2 (Rebecca Turner) [#7410](https://github.com/nodejs/node/pull/7410)
* [[`12b199369d`](https://github.com/nodejs/node/commit/12b199369d)] - **deps**: update `icu-small` to include punycode datafiles (James M Snell) [#7355](https://github.com/nodejs/node/pull/7355)
* [[`225f3b9f34`](https://github.com/nodejs/node/commit/225f3b9f34)] - **deps**: update `v8_inspector` (Michaël Zasso) [#7385](https://github.com/nodejs/node/pull/7385)
* [[`a4880b5b10`](https://github.com/nodejs/node/commit/a4880b5b10)] - **deps**: `MASM.UseSafeExceptionHandlers` for OpenSSL (Fedor Indutny) [#7427](https://github.com/nodejs/node/pull/7427)
* [[`cbe57479c4`](https://github.com/nodejs/node/commit/cbe57479c4)] - **deps**: switch to upstream `v8_inspector` (Ali Ijaz Sheikh) [#7302](https://github.com/nodejs/node/pull/7302)
* [[`f4777c77eb`](https://github.com/nodejs/node/commit/f4777c77eb)] - **deps**: update `v8_inspector` (Ali Ijaz Sheikh) [#7118](https://github.com/nodejs/node/pull/7118)
* [[`62105288d3`](https://github.com/nodejs/node/commit/62105288d3)] - **(SEMVER-MINOR)** **deps**: import `v8_inspector` (Ali Ijaz Sheikh) [#6792](https://github.com/nodejs/node/pull/6792)
* [[`c544213717`](https://github.com/nodejs/node/commit/c544213717)] - **deps**: backport 7dfb5beeec from V8 upstream (Myles Borins) [#7348](https://github.com/nodejs/node/pull/7348)
* [[`b0da07a788`](https://github.com/nodejs/node/commit/b0da07a788)] - **doc**: add `added:` information for timers (Anna Henningsen) [#7493](https://github.com/nodejs/node/pull/7493)
* [[`63d361b531`](https://github.com/nodejs/node/commit/63d361b531)] - **doc**: fix documentation of process.argv (Tarun Garg) [#7449](https://github.com/nodejs/node/pull/7449)
* [[`45f83e59c4`](https://github.com/nodejs/node/commit/45f83e59c4)] - **doc**: add guide for Node.js Timers (Ryan Lewis) [#6825](https://github.com/nodejs/node/pull/6825)
* [[`7d07a0b68e`](https://github.com/nodejs/node/commit/7d07a0b68e)] - **doc**: improve usage of `zero`/`0` (Rich Trott) [#7466](https://github.com/nodejs/node/pull/7466)
* [[`8d18aed59e`](https://github.com/nodejs/node/commit/8d18aed59e)] - **doc**: fixing minor typo in `AtExit` hooks section (Daniel Bevenius) [#7485](https://github.com/nodejs/node/pull/7485)
* [[`58ae35c34d`](https://github.com/nodejs/node/commit/58ae35c34d)] - **doc**: fix broken refs to `url.parse()` in http docs (Anna Henningsen) [#7392](https://github.com/nodejs/node/pull/7392)
* [[`f269c008f2`](https://github.com/nodejs/node/commit/f269c008f2)] - **doc**: add `added:` information for https (Anna Henningsen) [#7392](https://github.com/nodejs/node/pull/7392)
* [[`1c7b622cfc`](https://github.com/nodejs/node/commit/1c7b622cfc)] - **doc**: add `added:` information for http (Anna Henningsen) [#7392](https://github.com/nodejs/node/pull/7392)
* [[`bc37e6a22d`](https://github.com/nodejs/node/commit/bc37e6a22d)] - **doc**: general improvements to timers.md (James M Snell) [#6937](https://github.com/nodejs/node/pull/6937)
* [[`5f766ad6d0`](https://github.com/nodejs/node/commit/5f766ad6d0)] - **doc**: fix typographic error in process doc (Rich Trott) [#7431](https://github.com/nodejs/node/pull/7431)
* [[`3475591d1c`](https://github.com/nodejs/node/commit/3475591d1c)] - **doc**: fix "sign.verify" typo in crypto doc. (Ruslan Iusupov) [#7411](https://github.com/nodejs/node/pull/7411)
* [[`44bc638cdb`](https://github.com/nodejs/node/commit/44bc638cdb)] - **doc**: clarify `child_process` stdout/stderr types (sartrey) [#7361](https://github.com/nodejs/node/pull/7361)
* [[`efce335e63`](https://github.com/nodejs/node/commit/efce335e63)] - **doc**: add CTC meeting minutes 2016-06-15 (Josh Gavant) [#7320](https://github.com/nodejs/node/pull/7320)
* [[`b725437c81`](https://github.com/nodejs/node/commit/b725437c81)] - **doc**: minor rewording to the GitHub issue/pr templates (Jeremiah Senkpiel) [#7403](https://github.com/nodejs/node/pull/7403)
* [[`4486ba9ee1`](https://github.com/nodejs/node/commit/4486ba9ee1)] - **doc**: add lance to collaborators (Lance Ball) [#7407](https://github.com/nodejs/node/pull/7407)
* [[`09a7c91baa`](https://github.com/nodejs/node/commit/09a7c91baa)] - **doc**: update "who to cc in issues" chart (Jeremiah Senkpiel) [#6694](https://github.com/nodejs/node/pull/6694)
* [[`eed65973d5`](https://github.com/nodejs/node/commit/eed65973d5)] - **doc**: fix link in the stream doc (Italo A. Casas) [#7347](https://github.com/nodejs/node/pull/7347)
* [[`a04cd85667`](https://github.com/nodejs/node/commit/a04cd85667)] - **doc**: fix repl defineCommand example (akki) [#7365](https://github.com/nodejs/node/pull/7365)
* [[`029af2c1f6`](https://github.com/nodejs/node/commit/029af2c1f6)] - **doc**: update build instructions for Windows (João Reis) [#7285](https://github.com/nodejs/node/pull/7285)
* [[`7a0718bdc6`](https://github.com/nodejs/node/commit/7a0718bdc6)] - **doc**: add `added:` information for tls (Italo A. Casas) [#7018](https://github.com/nodejs/node/pull/7018)
* [[`ec515c5d3b`](https://github.com/nodejs/node/commit/ec515c5d3b)] - **doc**: mention http request "aborted" events (Kyle E. Mitchell) [#7270](https://github.com/nodejs/node/pull/7270)
* [[`0f434fee6e`](https://github.com/nodejs/node/commit/0f434fee6e)] - **doc**: add RReverser to collaborators (Ingvar Stepanyan) [#7370](https://github.com/nodejs/node/pull/7370)
* [[`7aa2125fae`](https://github.com/nodejs/node/commit/7aa2125fae)] - **doc**: add argument information for `socket.destroy()` (Rich Trott) [#7238](https://github.com/nodejs/node/pull/7238)
* [[`9e9d7b8fba`](https://github.com/nodejs/node/commit/9e9d7b8fba)] - **doc**: general improvements to os.md copy (James M Snell) [#7124](https://github.com/nodejs/node/pull/7124)
* [[`cd439465cc`](https://github.com/nodejs/node/commit/cd439465cc)] - **doc**: fix typos in the stream doc (vsemozhetbyt) [#7336](https://github.com/nodejs/node/pull/7336)
* [[`dddfed24db`](https://github.com/nodejs/node/commit/dddfed24db)] - **doc**: document `socket.destroyed` (Tushar Mathur) [#6128](https://github.com/nodejs/node/pull/6128)
* [[`cd7c29e471`](https://github.com/nodejs/node/commit/cd7c29e471)] - **doc**: correct `added:` information for fs.access (Richard Lau) [#7299](https://github.com/nodejs/node/pull/7299)
* [[`6aa179b4a6`](https://github.com/nodejs/node/commit/6aa179b4a6)] - **doc**: add `added:` information for repl (Anna Henningsen) [#7256](https://github.com/nodejs/node/pull/7256)
* [[`08a9aa31e1`](https://github.com/nodejs/node/commit/08a9aa31e1)] - **doc**: fix broken link in vm.md (Luigi Pinca) [#7304](https://github.com/nodejs/node/pull/7304)
* [[`12fbac102b`](https://github.com/nodejs/node/commit/12fbac102b)] - **doc**: fix cluster worker `'message'` event (cjihrig) [#7309](https://github.com/nodejs/node/pull/7309)
* [[`1a0ed26883`](https://github.com/nodejs/node/commit/1a0ed26883)] - **doc**: fix events typo (Greyson Parrelli) [#7329](https://github.com/nodejs/node/pull/7329)
* [[`1e7a7be1ad`](https://github.com/nodejs/node/commit/1e7a7be1ad)] - **doc**: clarify `fs.access()` works on directories too. (Lance Ball) [#7321](https://github.com/nodejs/node/pull/7321)
* [[`e7b84007be`](https://github.com/nodejs/node/commit/e7b84007be)] - **http**: replace finish() callback with arrow function (Guy Fraser) [#7378](https://github.com/nodejs/node/pull/7378)
* [[`c4aaf47f4d`](https://github.com/nodejs/node/commit/c4aaf47f4d)] - **inspector**: Do cleanups before notifying callback (Eugene Ostroukhov) [#7450](https://github.com/nodejs/node/pull/7450)
* [[`fe580eb578`](https://github.com/nodejs/node/commit/fe580eb578)] - **inspector**: print warning when used (Evan Lucas) [#7383](https://github.com/nodejs/node/pull/7383)
* [[`8dd48c9251`](https://github.com/nodejs/node/commit/8dd48c9251)] - **inspector**: fix inspector connection cleanup (Eugene Ostroukhov) [#7268](https://github.com/nodejs/node/pull/7268)
* [[`09ecd1fb58`](https://github.com/nodejs/node/commit/09ecd1fb58)] - **inspector**: fix coverity scan errors (Eugene Ostroukhov) [#7324](https://github.com/nodejs/node/pull/7324)
* [[`88b2aa3ce6`](https://github.com/nodejs/node/commit/88b2aa3ce6)] - **inspector**: `process.exit()` should wait for inspector (Eugene Ostroukhov) [#7252](https://github.com/nodejs/node/pull/7252)
* [[`7da8a413f6`](https://github.com/nodejs/node/commit/7da8a413f6)] - **inspector**: reduce implementation in header (Eugene Ostroukhov) [#7228](https://github.com/nodejs/node/pull/7228)
* [[`ec90a7a92e`](https://github.com/nodejs/node/commit/ec90a7a92e)] - **inspector**: change default port (Ali Ijaz Sheikh) [#7212](https://github.com/nodejs/node/pull/7212)
* [[`d0e24923a6`](https://github.com/nodejs/node/commit/d0e24923a6)] - **net**: use icu's punycode implementation (James M Snell) [#7355](https://github.com/nodejs/node/pull/7355)
* [[`fb39025e31`](https://github.com/nodejs/node/commit/fb39025e31)] - **punycode**: update to v2.0.0 (Mathias Bynens) [#7267](https://github.com/nodejs/node/pull/7267)
* [[`6b1fc63dcb`](https://github.com/nodejs/node/commit/6b1fc63dcb)] - **(SEMVER-MINOR)** **readline**: allow passing prompt to constructor (Evan Lucas) [#7125](https://github.com/nodejs/node/pull/7125)
* [[`72d659a000`](https://github.com/nodejs/node/commit/72d659a000)] - **(SEMVER-MINOR)** **readline**: return old status from `_setRawMode()` (Anna Henningsen) [#6635](https://github.com/nodejs/node/pull/6635)
* [[`7a7b8f7e67`](https://github.com/nodejs/node/commit/7a7b8f7e67)] - **repl**: Default `useGlobal` to false in CLI REPL. (Lance Ball) [#5703](https://github.com/nodejs/node/pull/5703)
* [[`c39f6c0204`](https://github.com/nodejs/node/commit/c39f6c0204)] - **repl**: Enable tab completion for global properties (Lance Ball) [#7369](https://github.com/nodejs/node/pull/7369)
* [[`ca95a84bc4`](https://github.com/nodejs/node/commit/ca95a84bc4)] - **repl**: fix tab completion for defined commands (Prince J Wesley) [#7364](https://github.com/nodejs/node/pull/7364)
* [[`da8e510ee0`](https://github.com/nodejs/node/commit/da8e510ee0)] - **(SEMVER-MINOR)** **repl**: break on sigint/ctrl+c (Anna Henningsen) [#6635](https://github.com/nodejs/node/pull/6635)
* [[`3cba8acc15`](https://github.com/nodejs/node/commit/3cba8acc15)] - **src**: remove obsolete `NOLINT` comments (Ben Noordhuis) [#7462](https://github.com/nodejs/node/pull/7462)
* [[`57cc4e3071`](https://github.com/nodejs/node/commit/57cc4e3071)] - **src**: print backtrace on failed `CHECK`/`ASSERT` (Ben Noordhuis) [#6734](https://github.com/nodejs/node/pull/6734)
* [[`b8919b1d23`](https://github.com/nodejs/node/commit/b8919b1d23)] - **src**: move `ABORT()` logic into `node::Abort()` (Ben Noordhuis) [#6734](https://github.com/nodejs/node/pull/6734)
* [[`c96d701769`](https://github.com/nodejs/node/commit/c96d701769)] - **src**: print backtrace on abort/unreachable code (Ben Noordhuis) [#6734](https://github.com/nodejs/node/pull/6734)
* [[`6cec90a611`](https://github.com/nodejs/node/commit/6cec90a611)] - **src**: print backtrace on fatal error (Ben Noordhuis) [#6734](https://github.com/nodejs/node/pull/6734)
* [[`8f7baffee4`](https://github.com/nodejs/node/commit/8f7baffee4)] - **src**: fix bad logic in uid/gid checks (Ben Noordhuis) [#7374](https://github.com/nodejs/node/pull/7374)
* [[`6fa560dce9`](https://github.com/nodejs/node/commit/6fa560dce9)] - **src**: fix memory leak in `WriteBuffers()` error path (Ben Noordhuis) [#7374](https://github.com/nodejs/node/pull/7374)
* [[`ce039c3240`](https://github.com/nodejs/node/commit/ce039c3240)] - **src**: fix use-after-return in zlib bindings (Ben Noordhuis) [#7374](https://github.com/nodejs/node/pull/7374)
* [[`2816418c04`](https://github.com/nodejs/node/commit/2816418c04)] - **src**: remove deprecated `HMAC_Init`, use `HMAC_Init_ex` (Ben Noordhuis) [#7374](https://github.com/nodejs/node/pull/7374)
* [[`b7e661b12c`](https://github.com/nodejs/node/commit/b7e661b12c)] - **src**: remove duplicate `HMAC_Init` calls (Ben Noordhuis) [#7374](https://github.com/nodejs/node/pull/7374)
* [[`25bc7fee34`](https://github.com/nodejs/node/commit/25bc7fee34)] - **src**: remove unused `md_` data members (Ben Noordhuis) [#7374](https://github.com/nodejs/node/pull/7374)
* [[`2228a656b0`](https://github.com/nodejs/node/commit/2228a656b0)] - **src**: remove unused data member `write_queue_size_` (Ben Noordhuis) [#7374](https://github.com/nodejs/node/pull/7374)
* [[`9945b4ecd6`](https://github.com/nodejs/node/commit/9945b4ecd6)] - **src**: guard against starting fs watcher twice (Ben Noordhuis) [#7374](https://github.com/nodejs/node/pull/7374)
* [[`3b1c19f90a`](https://github.com/nodejs/node/commit/3b1c19f90a)] - **src**: initialize `encoding_` data member (Ben Noordhuis) [#7374](https://github.com/nodejs/node/pull/7374)
* [[`c795d1ed9b`](https://github.com/nodejs/node/commit/c795d1ed9b)] - **src**: check `uv_async_init()` return value (Ben Noordhuis) [#7374](https://github.com/nodejs/node/pull/7374)
* [[`001aa06bc0`](https://github.com/nodejs/node/commit/001aa06bc0)] - **src**: lint v8abbr.h (Ben Noordhuis) [#7462](https://github.com/nodejs/node/pull/7462)
* [[`ca4fb084f6`](https://github.com/nodejs/node/commit/ca4fb084f6)] - **src**: lint `node_lttng_tp.h` (Ben Noordhuis) [#7462](https://github.com/nodejs/node/pull/7462)
* [[`da0ebf62c7`](https://github.com/nodejs/node/commit/da0ebf62c7)] - **src**: lint `node_win32_perfctr_provider.cc` (Ben Noordhuis) [#7462](https://github.com/nodejs/node/pull/7462)
* [[`3fa643b069`](https://github.com/nodejs/node/commit/3fa643b069)] - **src**: fix whitespace/indent cpplint warnings (Ben Noordhuis) [#7462](https://github.com/nodejs/node/pull/7462)
* [[`f72259aa89`](https://github.com/nodejs/node/commit/f72259aa89)] - **src**: fix whitespace/blank\_line cpplint warnings (Ben Noordhuis) [#7462](https://github.com/nodejs/node/pull/7462)
* [[`1b3c1b08a8`](https://github.com/nodejs/node/commit/1b3c1b08a8)] - **src**: fix runtime/references cpplint warnings (Ben Noordhuis) [#7462](https://github.com/nodejs/node/pull/7462)
* [[`be0c575ab4`](https://github.com/nodejs/node/commit/be0c575ab4)] - **src**: fix runtime/int cpplint warnings (Ben Noordhuis) [#7462](https://github.com/nodejs/node/pull/7462)
* [[`88c5183147`](https://github.com/nodejs/node/commit/88c5183147)] - **src**: fix runtime/indentation\_namespace warnings (Ben Noordhuis) [#7462](https://github.com/nodejs/node/pull/7462)
* [[`1fa6dba8f2`](https://github.com/nodejs/node/commit/1fa6dba8f2)] - **src**: fix readability/nolint cpplint warnings (Ben Noordhuis) [#7462](https://github.com/nodejs/node/pull/7462)
* [[`43e83576bd`](https://github.com/nodejs/node/commit/43e83576bd)] - **src**: fix readability/namespace cpplint warnings (Ben Noordhuis) [#7462](https://github.com/nodejs/node/pull/7462)
* [[`5fd158568f`](https://github.com/nodejs/node/commit/5fd158568f)] - **src**: fix readability/inheritance cpplint warnings (Ben Noordhuis) [#7462](https://github.com/nodejs/node/pull/7462)
* [[`b7e006b489`](https://github.com/nodejs/node/commit/b7e006b489)] - **src**: fix readability/constructors cpplint warnings (Ben Noordhuis) [#7462](https://github.com/nodejs/node/pull/7462)
* [[`7fe758de85`](https://github.com/nodejs/node/commit/7fe758de85)] - **src**: fix readability/braces cpplint warnings (Ben Noordhuis) [#7462](https://github.com/nodejs/node/pull/7462)
* [[`6280ccdaaa`](https://github.com/nodejs/node/commit/6280ccdaaa)] - **src**: fix build/header\_guard cpplint warnings (Ben Noordhuis) [#7462](https://github.com/nodejs/node/pull/7462)
* [[`5dfa234bae`](https://github.com/nodejs/node/commit/5dfa234bae)] - **src**: fix build/c++tr1 cpplint warnings (Ben Noordhuis) [#7462](https://github.com/nodejs/node/pull/7462)
* [[`84dd526f51`](https://github.com/nodejs/node/commit/84dd526f51)] - **src**: renaming `ares_task` struct to `node_ares_task` (Daniel Bevenius) [#7345](https://github.com/nodejs/node/pull/7345)
* [[`059335180d`](https://github.com/nodejs/node/commit/059335180d)] - **src**: use RAII for mutexes and condition variables (Ben Noordhuis) [#7334](https://github.com/nodejs/node/pull/7334)
* [[`3d69ad1cf3`](https://github.com/nodejs/node/commit/3d69ad1cf3)] - **src**: make Sec-WebSocket-Key check case-insensitive (Myles Borins) [#7248](https://github.com/nodejs/node/pull/7248)
* [[`38d36e3285`](https://github.com/nodejs/node/commit/38d36e3285)] - **src**: fix `--without-inspector` build (Anna Henningsen) [#7258](https://github.com/nodejs/node/pull/7258)
* [[`2fd140b949`](https://github.com/nodejs/node/commit/2fd140b949)] - **src**: fix json payload from inspector (Myles Borins) [#7232](https://github.com/nodejs/node/pull/7232)
* [[`643b33b497`](https://github.com/nodejs/node/commit/643b33b497)] - **src**: add linebreak to inspector message (Nicolas Romer) [#7070](https://github.com/nodejs/node/pull/7070)
* [[`ea2d661447`](https://github.com/nodejs/node/commit/ea2d661447)] - **src**: fix `--without-inspector` build (Anna Henningsen) [#7078](https://github.com/nodejs/node/pull/7078)
* [[`2a8bd35bac`](https://github.com/nodejs/node/commit/2a8bd35bac)] - **(SEMVER-MINOR)** **src**: add `node::FreeEnvironment` public API (Cheng Zhao) [#3098](https://github.com/nodejs/node/pull/3098)
* [[`929b6c29d8`](https://github.com/nodejs/node/commit/929b6c29d8)] - **(SEMVER-MINOR)** **src**: refactor `require('constants')` (James M Snell) [#6534](https://github.com/nodejs/node/pull/6534)
* [[`cd38401724`](https://github.com/nodejs/node/commit/cd38401724)] - **src**: fix Windows segfault with `--eval` (Bryce Simonds) [#6938](https://github.com/nodejs/node/pull/6938)
* [[`6dc0dae830`](https://github.com/nodejs/node/commit/6dc0dae830)] - **src**: rename "node" script to "bootstrap\_node" (Daniel Bevenius) [#7277](https://github.com/nodejs/node/pull/7277)
* [[`7d4f038a78`](https://github.com/nodejs/node/commit/7d4f038a78)] - **(SEMVER-MINOR)** **src,lib**: v8-inspector support (Pavel Feldman) [#6792](https://github.com/nodejs/node/pull/6792)
* [[`e1d6bd9e30`](https://github.com/nodejs/node/commit/e1d6bd9e30)] - **(SEMVER-MINOR)** **stream**: improve `Readable.read()` performance (Brian White) [#7077](https://github.com/nodejs/node/pull/7077)
* [[`962ac37e1f`](https://github.com/nodejs/node/commit/962ac37e1f)] - **string_decoder**: fix bad utf8 character handling (Brian White) [#7310](https://github.com/nodejs/node/pull/7310)
* [[`f6ba5f6380`](https://github.com/nodejs/node/commit/f6ba5f6380)] - **test**: really run addon tests on `make test` (Anna Henningsen) [#7542](https://github.com/nodejs/node/pull/7542)
* [[`c132e9cc24`](https://github.com/nodejs/node/commit/c132e9cc24)] - **test**: listen on and connect to `127.0.0.1` (Ben Noordhuis) [#7524](https://github.com/nodejs/node/pull/7524)
* [[`6da49ac1fd`](https://github.com/nodejs/node/commit/6da49ac1fd)] - **test**: handle SmartOS bug in test-tls-session-cache (Rich Trott) [#7505](https://github.com/nodejs/node/pull/7505)
* [[`b383fdde79`](https://github.com/nodejs/node/commit/b383fdde79)] - **test**: remove `common.PORT` from http tests (Rich Trott) [#7467](https://github.com/nodejs/node/pull/7467)
* [[`658ab3d1e6`](https://github.com/nodejs/node/commit/658ab3d1e6)] - **test**: check types for http request and response (Ben Noordhuis) [#7003](https://github.com/nodejs/node/pull/7003)
* [[`517e71508e`](https://github.com/nodejs/node/commit/517e71508e)] - **test**: add abort test for backtrace validation (cjihrig) [#6734](https://github.com/nodejs/node/pull/6734)
* [[`6de80fcaea`](https://github.com/nodejs/node/commit/6de80fcaea)] - **test**: don't use internal headers in add-on tests (Ben Noordhuis) [#6734](https://github.com/nodejs/node/pull/6734)
* [[`c7ab7a31d7`](https://github.com/nodejs/node/commit/c7ab7a31d7)] - **test**: fix abort/test-abort-uncaught-exception (Ben Noordhuis) [#6734](https://github.com/nodejs/node/pull/6734)
* [[`4b0ab5b308`](https://github.com/nodejs/node/commit/4b0ab5b308)] - **test**: add `testcfg.py` to test/abort/ (Ben Noordhuis) [#6734](https://github.com/nodejs/node/pull/6734)
* [[`365f5207b3`](https://github.com/nodejs/node/commit/365f5207b3)] - **test**: test `isFullWidthCodePoint()` with invalid input (Rich Trott) [#7422](https://github.com/nodejs/node/pull/7422)
* [[`e30f32f003`](https://github.com/nodejs/node/commit/e30f32f003)] - ***Revert*** "**test**: mark test-vm-timeout flaky on windows" (Anna Henningsen) [#7373](https://github.com/nodejs/node/pull/7373)
* [[`457d244170`](https://github.com/nodejs/node/commit/457d244170)] - **test**: fix flaky test-vm-timeout (Anna Henningsen) [#7373](https://github.com/nodejs/node/pull/7373)
* [[`16aff79dee`](https://github.com/nodejs/node/commit/16aff79dee)] - **test**: add test for `exec()` known issue (Rich Trott) [#7375](https://github.com/nodejs/node/pull/7375)
* [[`8f1733c4e7`](https://github.com/nodejs/node/commit/8f1733c4e7)] - **test**: add more `UTF-8` `StringDecoder` tests (Martin von Gagern) [#7310](https://github.com/nodejs/node/pull/7310)
* [[`0bbf2ef6ea`](https://github.com/nodejs/node/commit/0bbf2ef6ea)] - **test**: fix flaky test-fs-watch-encoding on OS X (Rich Trott) [#7356](https://github.com/nodejs/node/pull/7356)
* [[`009858bd0a`](https://github.com/nodejs/node/commit/009858bd0a)] - **test**: remove internet/test-tls-connnect-cnnic (Ben Noordhuis) [#7363](https://github.com/nodejs/node/pull/7363)
* [[`c236a13341`](https://github.com/nodejs/node/commit/c236a13341)] - **test**: mark test-vm-timeout flaky on windows (Rich Trott) [#7359](https://github.com/nodejs/node/pull/7359)
* [[`580e11026e`](https://github.com/nodejs/node/commit/580e11026e)] - **test**: refresh the tmpdir before using (Rich Trott) [#7327](https://github.com/nodejs/node/pull/7327)
* [[`e2bf250a29`](https://github.com/nodejs/node/commit/e2bf250a29)] - **test**: add tests for some `stream.Readable` uses (Anna Henningsen) [#7260](https://github.com/nodejs/node/pull/7260)
* [[`efb7a90fa9`](https://github.com/nodejs/node/commit/efb7a90fa9)] - **timers**: optimize `setImmediate()` (Andras) [#6436](https://github.com/nodejs/node/pull/6436)
* [[`a5d894590d`](https://github.com/nodejs/node/commit/a5d894590d)] - **timers**: optimize linkedlist (Andras) [#6436](https://github.com/nodejs/node/pull/6436)
* [[`77331a7c01`](https://github.com/nodejs/node/commit/77331a7c01)] - **tls**: avoid calling `Buffer.byteLength` multiple times (James M Snell) [#7236](https://github.com/nodejs/node/pull/7236)
* [[`d857e9a3e9`](https://github.com/nodejs/node/commit/d857e9a3e9)] - **tools**: explicit path for V8 test tap output (Myles Borins) [#7460](https://github.com/nodejs/node/pull/7460)
* [[`e727cb5021`](https://github.com/nodejs/node/commit/e727cb5021)] - **tools**: fix `-Wunused-variable` warning (Ben Noordhuis) [#7462](https://github.com/nodejs/node/pull/7462)
* [[`9d0641e20d`](https://github.com/nodejs/node/commit/9d0641e20d)] - **tools**: allow cpplint to run outside git repo (Ben Noordhuis) [#7462](https://github.com/nodejs/node/pull/7462)
* [[`01b7b9a2bc`](https://github.com/nodejs/node/commit/01b7b9a2bc)] - **tools**: add back `--mode=tap` to cpplint (Ben Noordhuis) [#7462](https://github.com/nodejs/node/pull/7462)
* [[`e3662a4386`](https://github.com/nodejs/node/commit/e3662a4386)] - **tools**: disable unwanted cpplint rules again (Ben Noordhuis) [#7462](https://github.com/nodejs/node/pull/7462)
* [[`5830ec5d41`](https://github.com/nodejs/node/commit/5830ec5d41)] - **tools**: update cpplint to r456 (Ben Noordhuis) [#7462](https://github.com/nodejs/node/pull/7462)
* [[`3eb02b6743`](https://github.com/nodejs/node/commit/3eb02b6743)] - **tools**: output include guards in mk-ca-bundle.pl (Ben Noordhuis) [#7363](https://github.com/nodejs/node/pull/7363)
* [[`32e068a5d0`](https://github.com/nodejs/node/commit/32e068a5d0)] - **tools**: update certdata.txt (Ben Noordhuis) [#7363](https://github.com/nodejs/node/pull/7363)
* [[`bd8c951757`](https://github.com/nodejs/node/commit/bd8c951757)] - **tools**: disable readability/function cpplint rule (Ben Noordhuis) [#7334](https://github.com/nodejs/node/pull/7334)
* [[`3b8914d5ce`](https://github.com/nodejs/node/commit/3b8914d5ce)] - **(SEMVER-MINOR)** **util**: add an option for configuring break length (cjihrig) [#7499](https://github.com/nodejs/node/pull/7499)
* [[`6151544751`](https://github.com/nodejs/node/commit/6151544751)] - **vm**: don't print out arrow message for custom error (Anna Henningsen) [#7398](https://github.com/nodejs/node/pull/7398)
* [[`55b87c0238`](https://github.com/nodejs/node/commit/55b87c0238)] - **vm**: test for abort condition of current invocation (Anna Henningsen) [#7373](https://github.com/nodejs/node/pull/7373)
* [[`d049919e7d`](https://github.com/nodejs/node/commit/d049919e7d)] - **(SEMVER-MINOR)** **vm**: add ability to break on sigint/ctrl+c (Anna Henningsen) [#6635](https://github.com/nodejs/node/pull/6635)

<a id="6.2.2"></a>
## 2016-06-17, Version 6.2.2 (Current), @evanlucas

### Notable changes

* **http**:
  - `req.read(0)` could cause incoming connections to stall and time out under certain conditions. (Fedor Indutny) [#7211](https://github.com/nodejs/node/pull/7211)
  - When freeing the socket to be reused in keep-alive Agent wait for both prefinish and end events. Otherwise the next request may be written before the previous one has finished sending the body, leading to a parser errors. (Fedor Indutny) [#7149](https://github.com/nodejs/node/pull/7149)
* **npm**: upgrade npm to 3.9.5 (Kat Marchán) [#7139](https://github.com/nodejs/node/pull/7139)

### Commits

* [[`d71ede8113`](https://github.com/nodejs/node/commit/d71ede8113)] - **benchmark**: don't convert arguments to numbers (Brian White) [#6570](https://github.com/nodejs/node/pull/6570)
* [[`32f76983e2`](https://github.com/nodejs/node/commit/32f76983e2)] - **benchmark**: increase http token check iterations (Brian White) [#6570](https://github.com/nodejs/node/pull/6570)
* [[`23a495a9a9`](https://github.com/nodejs/node/commit/23a495a9a9)] - **benchmark**: add benchmark for url.format() (Rich Trott) [#7250](https://github.com/nodejs/node/pull/7250)
* [[`27ed7fc56c`](https://github.com/nodejs/node/commit/27ed7fc56c)] - **benchmark**: fix child-process-exec-stdout on win (Bartosz Sosnowski) [#7178](https://github.com/nodejs/node/pull/7178)
* [[`5e5af8b4bb`](https://github.com/nodejs/node/commit/5e5af8b4bb)] - **benchmark**: fix child-process-read on Windows (Bartosz Sosnowski) [#6971](https://github.com/nodejs/node/pull/6971)
* [[`d24e4095bf`](https://github.com/nodejs/node/commit/d24e4095bf)] - **benchmark**: add benchmark for Buffer.concat (Anna Henningsen) [#7054](https://github.com/nodejs/node/pull/7054)
* [[`666b6f9302`](https://github.com/nodejs/node/commit/666b6f9302)] - **build**: add REPLACEME tag for version info in docs (Ben Noordhuis) [#6864](https://github.com/nodejs/node/pull/6864)
* [[`6d3d2d1ae4`](https://github.com/nodejs/node/commit/6d3d2d1ae4)] - **cluster**: don't send messages if no IPC channel (Santiago Gimeno) [#7132](https://github.com/nodejs/node/pull/7132)
* [[`068718c91c`](https://github.com/nodejs/node/commit/068718c91c)] - **debugger**: remove obsolete setTimeout (Rich Trott) [#7154](https://github.com/nodejs/node/pull/7154)
* [[`2961f06f6f`](https://github.com/nodejs/node/commit/2961f06f6f)] - **debugger**: fix --debug-brk interaction with -e (Rich Trott) [#7089](https://github.com/nodejs/node/pull/7089)
* [[`701e699d4f`](https://github.com/nodejs/node/commit/701e699d4f)] - **deps**: upgrade npm to 3.9.5 (Kat Marchán) [#7139](https://github.com/nodejs/node/pull/7139)
* [[`1095ae1ac5`](https://github.com/nodejs/node/commit/1095ae1ac5)] - **doc**: Add CII Best Practices badge to README.md (David A. Wheeler) [#6819](https://github.com/nodejs/node/pull/6819)
* [[`0198987b0d`](https://github.com/nodejs/node/commit/0198987b0d)] - **doc**: add internal link in GOVERNANCE.md (Rich Trott) [#7279](https://github.com/nodejs/node/pull/7279)
* [[`8e14f761bb`](https://github.com/nodejs/node/commit/8e14f761bb)] - **doc**: use `Buffer.byteLength` for Content-Length (kimown) [#7274](https://github.com/nodejs/node/pull/7274)
* [[`5d03bdd94f`](https://github.com/nodejs/node/commit/5d03bdd94f)] - **doc**: add information for IncomingMessage.destroy() (Rich Trott) [#7237](https://github.com/nodejs/node/pull/7237)
* [[`a113734099`](https://github.com/nodejs/node/commit/a113734099)] - **doc**: general improvements to path.md copy (James M Snell) [#7122](https://github.com/nodejs/node/pull/7122)
* [[`b5e44df9a3`](https://github.com/nodejs/node/commit/b5e44df9a3)] - **doc**: make pull request template more concise (Rich Trott) [#7239](https://github.com/nodejs/node/pull/7239)
* [[`40a5974a0e`](https://github.com/nodejs/node/commit/40a5974a0e)] - **doc**: `url.format()` parameter may be a string (Rich Trott) [#7235](https://github.com/nodejs/node/pull/7235)
* [[`a7d813915e`](https://github.com/nodejs/node/commit/a7d813915e)] - **doc**: clarify use of `0` port value (Rich Trott) [#7206](https://github.com/nodejs/node/pull/7206)
* [[`0fc8012b65`](https://github.com/nodejs/node/commit/0fc8012b65)] - **doc**: remove cluster.setupMaster() myth (cjihrig) [#7179](https://github.com/nodejs/node/pull/7179)
* [[`70167fd1d4`](https://github.com/nodejs/node/commit/70167fd1d4)] - **doc**: fix IRC link (Ilkka Myller) [#7210](https://github.com/nodejs/node/pull/7210)
* [[`4f2215fd98`](https://github.com/nodejs/node/commit/4f2215fd98)] - **doc**: fix minor nit introduced in readline.md (James M Snell) [#7198](https://github.com/nodejs/node/pull/7198)
* [[`d31f728e09`](https://github.com/nodejs/node/commit/d31f728e09)] - **doc**: clarify rl.question callback args (James M Snell) [#7022](https://github.com/nodejs/node/pull/7022)
* [[`70f2f357be`](https://github.com/nodejs/node/commit/70f2f357be)] - **doc**: general improvements to readline.md copy (James M Snell) [#7022](https://github.com/nodejs/node/pull/7022)
* [[`c2aba5ba27`](https://github.com/nodejs/node/commit/c2aba5ba27)] - **doc**: consolidate test/lint text in GH PR template (Rich Trott) [#7155](https://github.com/nodejs/node/pull/7155)
* [[`712120112f`](https://github.com/nodejs/node/commit/712120112f)] - **doc**: use consistent typography in streams.md (Rich Trott) [#6986](https://github.com/nodejs/node/pull/6986)
* [[`e2f6f8061b`](https://github.com/nodejs/node/commit/e2f6f8061b)] - **doc**: general improvements to process.md copy (James M Snell) [#7029](https://github.com/nodejs/node/pull/7029)
* [[`84ea6fc57c`](https://github.com/nodejs/node/commit/84ea6fc57c)] - **doc**: general improvements to repl.md copy (James M Snell) [#7002](https://github.com/nodejs/node/pull/7002)
* [[`bfb7e3cc6e`](https://github.com/nodejs/node/commit/bfb7e3cc6e)] - **doc**: add `added:` information for readline (Julian Duque) [#6996](https://github.com/nodejs/node/pull/6996)
* [[`632b411cd0`](https://github.com/nodejs/node/commit/632b411cd0)] - **doc**: improved syntax consistency in console.md (Jonathan Montane) [#7062](https://github.com/nodejs/node/pull/7062)
* [[`826bd99486`](https://github.com/nodejs/node/commit/826bd99486)] - **doc**: specify how to link issues in commit log (Luigi Pinca) [#7161](https://github.com/nodejs/node/pull/7161)
* [[`865644a604`](https://github.com/nodejs/node/commit/865644a604)] - **doc**: general improvements to querystring.md copy (James M Snell) [#7023](https://github.com/nodejs/node/pull/7023)
* [[`dd4c607267`](https://github.com/nodejs/node/commit/dd4c607267)] - **doc**: fix header depth of util.isSymbol (James M Snell) [#7138](https://github.com/nodejs/node/pull/7138)
* [[`5086e5f3ee`](https://github.com/nodejs/node/commit/5086e5f3ee)] - **doc**: general improvements to stream.md copy (James M Snell) [#6947](https://github.com/nodejs/node/pull/6947)
* [[`75d6875034`](https://github.com/nodejs/node/commit/75d6875034)] - **doc**: update licenses (Myles Borins) [#7121](https://github.com/nodejs/node/pull/7121)
* [[`dc8cb93c4f`](https://github.com/nodejs/node/commit/dc8cb93c4f)] - **doc**: add `added:` information for dns (Julian Duque) [#7021](https://github.com/nodejs/node/pull/7021)
* [[`a7c85e6fd5`](https://github.com/nodejs/node/commit/a7c85e6fd5)] - **doc**: add `added:` information for path (Julian Duque) [#6985](https://github.com/nodejs/node/pull/6985)
* [[`026bf17378`](https://github.com/nodejs/node/commit/026bf17378)] - **doc**: add `added` information for net (Italo A. Casas) [#7038](https://github.com/nodejs/node/pull/7038)
* [[`d4a2c82f5f`](https://github.com/nodejs/node/commit/d4a2c82f5f)] - **doc**: general improvements to punycode.md copy (James M Snell) [#7025](https://github.com/nodejs/node/pull/7025)
* [[`51d295efe6`](https://github.com/nodejs/node/commit/51d295efe6)] - **doc**: add links to platform specific mechanisms (Michael Dawson) [#7071](https://github.com/nodejs/node/pull/7071)
* [[`1600966f59`](https://github.com/nodejs/node/commit/1600966f59)] - **fs**: execute mkdtemp's callback with no context (Sakthipriyan Vairamani) [#7068](https://github.com/nodejs/node/pull/7068)
* [[`ad1045c829`](https://github.com/nodejs/node/commit/ad1045c829)] - **http**: fix no dumping after `maybeReadMore` (Fedor Indutny) [#7211](https://github.com/nodejs/node/pull/7211)
* [[`2a462ba1e2`](https://github.com/nodejs/node/commit/2a462ba1e2)] - **http**: optimize checkInvalidHeaderChar() (Brian White) [#6570](https://github.com/nodejs/node/pull/6570)
* [[`4a63be031f`](https://github.com/nodejs/node/commit/4a63be031f)] - **http**: optimize checkIsHttpToken() (Brian White) [#6570](https://github.com/nodejs/node/pull/6570)
* [[`40e49dee82`](https://github.com/nodejs/node/commit/40e49dee82)] - **http**: wait for both prefinish/end to keepalive (Fedor Indutny) [#7149](https://github.com/nodejs/node/pull/7149)
* [[`e8c91e7557`](https://github.com/nodejs/node/commit/e8c91e7557)] - **repl**: refine handling of illegal tokens (Rich Trott) [#7104](https://github.com/nodejs/node/pull/7104)
* [[`cf0928ccb7`](https://github.com/nodejs/node/commit/cf0928ccb7)] - **src**: clean up string_search (Brian White) [#7174](https://github.com/nodejs/node/pull/7174)
* [[`b0225e5926`](https://github.com/nodejs/node/commit/b0225e5926)] - **stream**: ensure awaitDrain is increased once (David Halls) [#7292](https://github.com/nodejs/node/pull/7292)
* [[`9c6b69ec1b`](https://github.com/nodejs/node/commit/9c6b69ec1b)] - **stream**: reset awaitDrain after manual .resume() (Anna Henningsen) [#7160](https://github.com/nodejs/node/pull/7160)
* [[`caa6718a01`](https://github.com/nodejs/node/commit/caa6718a01)] - **test**: fix test-net-* error code check for getaddrinfo(3) (Natanael Copa) [#5099](https://github.com/nodejs/node/pull/5099)
* [[`535c8dd554`](https://github.com/nodejs/node/commit/535c8dd554)] - **test**: add more http token/value checking tests (Brian White) [#6570](https://github.com/nodejs/node/pull/6570)
* [[`257f4e6202`](https://github.com/nodejs/node/commit/257f4e6202)] - **test**: add note about duration_ms in TAP reporter (Rod Vagg) [#7216](https://github.com/nodejs/node/pull/7216)
* [[`798a737f45`](https://github.com/nodejs/node/commit/798a737f45)] - ***Revert*** "**test**: change duration_ms to duration" (Rod Vagg) [#7216](https://github.com/nodejs/node/pull/7216)
* [[`72e4e43b91`](https://github.com/nodejs/node/commit/72e4e43b91)] - **test**: rebuild add-ons when their sources change (Ben Noordhuis) [#7262](https://github.com/nodejs/node/pull/7262)
* [[`eded11705b`](https://github.com/nodejs/node/commit/eded11705b)] - **test**: use random ports where possible (Brian White) [#7045](https://github.com/nodejs/node/pull/7045)
* [[`d54c7c19a6`](https://github.com/nodejs/node/commit/d54c7c19a6)] - **test**: fix spawn on windows (Brian White) [#7049](https://github.com/nodejs/node/pull/7049)
* [[`e873063a3c`](https://github.com/nodejs/node/commit/e873063a3c)] - **test**: enable test-debug-brk-no-arg (Rich Trott) [#7143](https://github.com/nodejs/node/pull/7143)
* [[`d6091c8194`](https://github.com/nodejs/node/commit/d6091c8194)] - **test**: use common.fixturesDir almost everywhere (Bryan English) [#6997](https://github.com/nodejs/node/pull/6997)
* [[`e8b1456d8b`](https://github.com/nodejs/node/commit/e8b1456d8b)] - **test**: change duration_ms to duration (Gibson Fahnestock) [#7133](https://github.com/nodejs/node/pull/7133)
* [[`6ce26c8c8b`](https://github.com/nodejs/node/commit/6ce26c8c8b)] - **test**: add test for uid/gid setting in spawn (Rich Trott) [#7084](https://github.com/nodejs/node/pull/7084)
* [[`40604b54d4`](https://github.com/nodejs/node/commit/40604b54d4)] - **test**: remove disabled eio race test (Rich Trott) [#7083](https://github.com/nodejs/node/pull/7083)
* [[`9545c41cba`](https://github.com/nodejs/node/commit/9545c41cba)] - **tools**: fix license builder to work with icu-small (Myles Borins) [#7119](https://github.com/nodejs/node/pull/7119)
* [[`6562c9fc75`](https://github.com/nodejs/node/commit/6562c9fc75)] - **tools,doc**: add example usage for REPLACEME tag (Anna Henningsen) [#6864](https://github.com/nodejs/node/pull/6864)

<a id="6.2.1"></a>
## 2016-06-02, Version 6.2.1 (Current), @rvagg

### Notable changes

* **buffer**: Ignore negative lengths in calls to `Buffer()` and `Buffer.allocUnsafe()`. This fixes a possible security concern (reported by Feross Aboukhadijeh) where user input is passed unchecked to the Buffer constructor or `allocUnsafe()` as it can expose parts of the memory slab used by other Buffers in the application. Note that negative lengths are not supported by the Buffer API and user input to the constructor should always be sanitised and type-checked. (Anna Henningsen) [#7051](https://github.com/nodejs/node/pull/7051)
* **npm**: Upgrade npm to 3.9.3 (Kat Marchán) [#7030](https://github.com/nodejs/node/pull/7030)
  - [`npm/npm@42d71be`](https://github.com/npm/npm/commit/42d71be2cec674dd9e860ad414f53184f667620d) [npm/npm#12685](https://github.com/npm/npm/pull/12685) When using `npm ls <pkg>` without a semver specifier, `npm ls` would skip any packages in your tree that matched by name, but had a prerelease version in their `package.json`. ([@zkat](https://github.com/zkat))
  - [`npm/npm@f04e05`](https://github.com/npm/npm/commit/df04e05af1f257a1903372e1baf334c0969fbdbd) [npm/npm#10013](https://github.com/npm/npm/issues/10013) `read-package-tree@5.1.4`: Fixes an issue where `npm install` would fail if your `node_modules` was symlinked. ([@iarna](https://github.com/iarna))
  - [`b894413`](https://github.com/npm/npm/commit/b8944139a935680c4a267468bb2d3c3082b5609f) [#12372](https://github.com/npm/npm/issues/12372) Changing a nested dependency in an `npm-shrinkwrap.json` and then running `npm install` would not get up the updated package. This corrects that. ([@misterbyrne](https://github.com/misterbyrne))
  - This release includes `npm@3.9.0`, which is the result of our Windows testing push -- the test suite (should) pass on Windows now. We're working on getting AppVeyor to a place where we can just rely on it like Travis.
* **tty**: Default to blocking mode for stdio on OS X. A bug fix in libuv 1.9.0, introduced in Node.js v6.0.0, exposed problems with Node's use of non-blocking stdio, particularly on OS X which has a small output buffer. This change should fix CLI applications that have been having problems with output since Node.js v6.0.0 on OS X. The core team is continuing to address stdio concerns that exist across supported platforms and progress can be tracked at <https://github.com/nodejs/node/issues/6980>. (Jeremiah Senkpiel) [#6895](https://github.com/nodejs/node/pull/6895)
* **V8**: Upgrade to V8 5.0.71.52. This includes a fix that addresses problems experienced by users of node-inspector since Node.js v6.0.0, see <https://github.com/node-inspector/node-inspector/issues/864> for details. (Michaël Zasso) [#6928](https://github.com/nodejs/node/pull/6928)

### Commits

* [[`99c05a1af0`](https://github.com/nodejs/node/commit/99c05a1af0)] - **async_wrap**: pass uid to JS as double (Trevor Norris) [#7096](https://github.com/nodejs/node/pull/7096)
* [[`371be9cd80`](https://github.com/nodejs/node/commit/371be9cd80)] - **buffer**: ignore negative allocation lengths (Anna Henningsen) [#7051](https://github.com/nodejs/node/pull/7051)
* [[`1bcc226edf`](https://github.com/nodejs/node/commit/1bcc226edf)] - **buffer**: fix dataview-set benchmark (Ingvar Stepanyan) [#6922](https://github.com/nodejs/node/pull/6922)
* [[`98270c6d15`](https://github.com/nodejs/node/commit/98270c6d15)] - **buffer**: fix single digit hex string handling (Justin Sprigg) [#6775](https://github.com/nodejs/node/pull/6775)
* [[`1fece2f8c0`](https://github.com/nodejs/node/commit/1fece2f8c0)] - **build**: re-add --ninja option to configure (Ehsan Akhgari) [#6780](https://github.com/nodejs/node/pull/6780)
* [[`e7b03be191`](https://github.com/nodejs/node/commit/e7b03be191)] - **build**: update build-addons when node-gyp changes (Lance Ball) [#6787](https://github.com/nodejs/node/pull/6787)
* [[`55c0b3e0e5`](https://github.com/nodejs/node/commit/55c0b3e0e5)] - **build**: unbreak configure with python 2.6 (Ben Noordhuis) [#6874](https://github.com/nodejs/node/pull/6874)
* [[`0503681348`](https://github.com/nodejs/node/commit/0503681348)] - **child_process**: measure buffer length in bytes (Rich Trott) [#6764](https://github.com/nodejs/node/pull/6764)
* [[`27d0eb054c`](https://github.com/nodejs/node/commit/27d0eb054c)] - **child_process**: emit IPC messages on next tick (cjihrig) [#6909](https://github.com/nodejs/node/pull/6909)
* [[`b28468e0a7`](https://github.com/nodejs/node/commit/b28468e0a7)] - **child_process**: allow buffer encoding in spawnSync (cjihrig) [#6939](https://github.com/nodejs/node/pull/6939)
* [[`6a62bb0070`](https://github.com/nodejs/node/commit/6a62bb0070)] - **cluster**: expose result of send() (cjihrig) [#6998](https://github.com/nodejs/node/pull/6998)
* [[`2132d349b5`](https://github.com/nodejs/node/commit/2132d349b5)] - **cluster**: rewrite debug ports consistently (cjihrig) [#7050](https://github.com/nodejs/node/pull/7050)
* [[`0bd8f4c4d8`](https://github.com/nodejs/node/commit/0bd8f4c4d8)] - **cluster**: reset handle index on close (Santiago Gimeno) [#6981](https://github.com/nodejs/node/pull/6981)
* [[`93e150f1d6`](https://github.com/nodejs/node/commit/93e150f1d6)] - **cluster**: guard against undefined message handlers (cjihrig) [#6902](https://github.com/nodejs/node/pull/6902)
* [[`28b73428e1`](https://github.com/nodejs/node/commit/28b73428e1)] - **cluster**: close ownerless handles on disconnect() (cjihrig) [#6909](https://github.com/nodejs/node/pull/6909)
* [[`2184e772d2`](https://github.com/nodejs/node/commit/2184e772d2)] - **debugger**: propagate --debug-port= to debuggee (Ben Noordhuis) [#3470](https://github.com/nodejs/node/pull/3470)
* [[`ded02b909f`](https://github.com/nodejs/node/commit/ded02b909f)] - **deps**: upgrade npm to 3.9.3 (Kat Marchán) [#7030](https://github.com/nodejs/node/pull/7030)
* [[`bfd7b24c63`](https://github.com/nodejs/node/commit/bfd7b24c63)] - **deps**: upgrade to V8 5.0.71.52 (Michaël Zasso) [#6928](https://github.com/nodejs/node/pull/6928)
* [[`8e6f8b2fb5`](https://github.com/nodejs/node/commit/8e6f8b2fb5)] - **dgram**: copy the list in send (Matteo Collina) [#6804](https://github.com/nodejs/node/pull/6804)
* [[`588c76cd5c`](https://github.com/nodejs/node/commit/588c76cd5c)] - **dgram,test**: add addMembership/dropMembership tests (Rich Trott) [#6753](https://github.com/nodejs/node/pull/6753)
* [[`e93198e86d`](https://github.com/nodejs/node/commit/e93198e86d)] - **doc**: edit pull request template (Rich Trott) [#7058](https://github.com/nodejs/node/pull/7058)
* [[`1c1256718e`](https://github.com/nodejs/node/commit/1c1256718e)] - **doc**: addresses nits in string_decoder, url, util (Jeremiah Senkpiel) [#7026](https://github.com/nodejs/node/pull/7026)
* [[`14b3ba35fc`](https://github.com/nodejs/node/commit/14b3ba35fc)] - **doc**: improve debugger doc prose (Rich Trott) [#7007](https://github.com/nodejs/node/pull/7007)
* [[`3c2c4c8d5c`](https://github.com/nodejs/node/commit/3c2c4c8d5c)] - **doc**: update labels and CI info in onboarding doc (Rich Trott) [#7006](https://github.com/nodejs/node/pull/7006)
* [[`b5e93c97f8`](https://github.com/nodejs/node/commit/b5e93c97f8)] - **doc**: fix typos in WORKING_GROUPS.md (Joao Andrade) [#7032](https://github.com/nodejs/node/pull/7032)
* [[`f15448681a`](https://github.com/nodejs/node/commit/f15448681a)] - **doc**: buffers are not sent over IPC with a socket (Tim Kuijsten) [#6951](https://github.com/nodejs/node/pull/6951)
* [[`3518ab93b1`](https://github.com/nodejs/node/commit/3518ab93b1)] - **doc**: minor improvements to util.md (Sakthipriyan Vairamani) [#6932](https://github.com/nodejs/node/pull/6932)
* [[`216a3cdcce`](https://github.com/nodejs/node/commit/216a3cdcce)] - **doc**: add `added:` information for vm (Anna Henningsen) [#7011](https://github.com/nodejs/node/pull/7011)
* [[`b30d07845d`](https://github.com/nodejs/node/commit/b30d07845d)] - **doc**: add `added:` information for console (Adrian Estrada) [#6995](https://github.com/nodejs/node/pull/6995)
* [[`72d4692e94`](https://github.com/nodejs/node/commit/72d4692e94)] - **doc**: add info on what's used for fswatch on AIX (Michael Dawson) [#6837](https://github.com/nodejs/node/pull/6837)
* [[`7c38327dee`](https://github.com/nodejs/node/commit/7c38327dee)] - **doc**: update process.hrtime docs to include optional parameter (doug.wade) [#6585](https://github.com/nodejs/node/pull/6585)
* [[`0f17a28a00`](https://github.com/nodejs/node/commit/0f17a28a00)] - **doc**: improve server.listen() documentation prose (Rich Trott) [#7000](https://github.com/nodejs/node/pull/7000)
* [[`3ae9f1469d`](https://github.com/nodejs/node/commit/3ae9f1469d)] - **doc**: improve `server.address()` doc text (Rich Trott) [#7001](https://github.com/nodejs/node/pull/7001)
* [[`ae1bf83b6c`](https://github.com/nodejs/node/commit/ae1bf83b6c)] - **doc**: clarified use of sexual language in the CoC (Bryan Hughes) [#6973](https://github.com/nodejs/node/pull/6973)
* [[`3909209e7a`](https://github.com/nodejs/node/commit/3909209e7a)] - **doc**: general improvements to tty.md (James M Snell) [#6931](https://github.com/nodejs/node/pull/6931)
* [[`bc2efe22f6`](https://github.com/nodejs/node/commit/bc2efe22f6)] - **doc**: add `added: ` data for cli.md (Rich Trott) [#6960](https://github.com/nodejs/node/pull/6960)
* [[`856638d0b7`](https://github.com/nodejs/node/commit/856638d0b7)] - **doc**: add `added:` information for child_process (Anna Henningsen) [#6927](https://github.com/nodejs/node/pull/6927)
* [[`a5e3eddfbf`](https://github.com/nodejs/node/commit/a5e3eddfbf)] - **doc**: general improvements to url.md copy (James M Snell) [#6904](https://github.com/nodejs/node/pull/6904)
* [[`b7ca0a2653`](https://github.com/nodejs/node/commit/b7ca0a2653)] - **doc**: add yorkie to collaborators (Yazhong Liu) [#7004](https://github.com/nodejs/node/pull/7004)
* [[`a9b90a6952`](https://github.com/nodejs/node/commit/a9b90a6952)] - **doc**: general improvements to tls.md copy (James M Snell) [#6933](https://github.com/nodejs/node/pull/6933)
* [[`5990a7fe91`](https://github.com/nodejs/node/commit/5990a7fe91)] - **doc**: fix broken references (Anna Henningsen) [#6941](https://github.com/nodejs/node/pull/6941)
* [[`98e497bdad`](https://github.com/nodejs/node/commit/98e497bdad)] - **doc**: fix broken references in changelogs (Anna Henningsen) [#6942](https://github.com/nodejs/node/pull/6942)
* [[`f3ae42168a`](https://github.com/nodejs/node/commit/f3ae42168a)] - **doc**: general improvements to string_decoder.md copy (James M Snell) [#6940](https://github.com/nodejs/node/pull/6940)
* [[`8f623a3c75`](https://github.com/nodejs/node/commit/8f623a3c75)] - **doc**: add firedfox to collaborators (Daniel Wang) [#6961](https://github.com/nodejs/node/pull/6961)
* [[`145a6b946a`](https://github.com/nodejs/node/commit/145a6b946a)] - **doc**: add bmeck to collaborators (Bradley Meck) [#6962](https://github.com/nodejs/node/pull/6962)
* [[`95f8d59e0d`](https://github.com/nodejs/node/commit/95f8d59e0d)] - **doc**: remove "\" within backticks (Rod Machen) [#6952](https://github.com/nodejs/node/pull/6952)
* [[`ee1865dd2f`](https://github.com/nodejs/node/commit/ee1865dd2f)] - **doc**: clarify buffer class (Steve Mao) [#6914](https://github.com/nodejs/node/pull/6914)
* [[`db3d2a7b96`](https://github.com/nodejs/node/commit/db3d2a7b96)] - **doc**: fix typos in timers topic to aid readability (Kevin Donahue) [#6916](https://github.com/nodejs/node/pull/6916)
* [[`0f0003fc54`](https://github.com/nodejs/node/commit/0f0003fc54)] - **doc**: add jhamhader to collaborators (Yuval Brik) [#6946](https://github.com/nodejs/node/pull/6946)
* [[`f6558ec537`](https://github.com/nodejs/node/commit/f6558ec537)] - **doc**: add @othiym23 to list of collaborators (Forrest L Norvell) [#6945](https://github.com/nodejs/node/pull/6945)
* [[`9fa1b19eda`](https://github.com/nodejs/node/commit/9fa1b19eda)] - **doc**: reference list of language-specific globals (Anna Henningsen) [#6900](https://github.com/nodejs/node/pull/6900)
* [[`15f6224418`](https://github.com/nodejs/node/commit/15f6224418)] - **doc**: make doc-only -> fallback to user binary (Robert Jefe Lindstaedt) [#6906](https://github.com/nodejs/node/pull/6906)
* [[`a320a019f1`](https://github.com/nodejs/node/commit/a320a019f1)] - **doc**: general improvements to util.md (James M Snell) [#6897](https://github.com/nodejs/node/pull/6897)
* [[`527a8a4844`](https://github.com/nodejs/node/commit/527a8a4844)] - **doc**: add `added:` information for zlib (Anna Henningsen) [#6840](https://github.com/nodejs/node/pull/6840)
* [[`cb8de85100`](https://github.com/nodejs/node/commit/cb8de85100)] - **doc**: make the api doc print-friendly (Marian) [#6748](https://github.com/nodejs/node/pull/6748)
* [[`f1a8c3164a`](https://github.com/nodejs/node/commit/f1a8c3164a)] - **doc**: add bengl to collaborators (Bryan English) [#6921](https://github.com/nodejs/node/pull/6921)
* [[`565d4ca12e`](https://github.com/nodejs/node/commit/565d4ca12e)] - **doc**: Update DCO to v1.1 (William Kapke) [#6353](https://github.com/nodejs/node/pull/6353)
* [[`eff73c78c5`](https://github.com/nodejs/node/commit/eff73c78c5)] - **doc**: general improvements to v8.md copy (James M Snell) [#6829](https://github.com/nodejs/node/pull/6829)
* [[`e5a7cec828`](https://github.com/nodejs/node/commit/e5a7cec828)] - **doc**: fix typo in Error.captureStackTrace (Mohsen) [#6811](https://github.com/nodejs/node/pull/6811)
* [[`5afb91bef7`](https://github.com/nodejs/node/commit/5afb91bef7)] - **doc**: make param names consistent & fix doc link (Sakthipriyan Vairamani) [#6832](https://github.com/nodejs/node/pull/6832)
* [[`e1fb4805cf`](https://github.com/nodejs/node/commit/e1fb4805cf)] - **doc**: add `added:` info for `process.cpuUsage` (Anna Henningsen) [#6863](https://github.com/nodejs/node/pull/6863)
* [[`8a0329f110`](https://github.com/nodejs/node/commit/8a0329f110)] - **doc**: fix mkdtemp example by removing hyphen (Sakthipriyan Vairamani) [#6834](https://github.com/nodejs/node/pull/6834)
* [[`45ca7cfcdd`](https://github.com/nodejs/node/commit/45ca7cfcdd)] - **doc**: reduce GitHub template verbosity (Rich Trott) [#6801](https://github.com/nodejs/node/pull/6801)
* [[`12a3d0120b`](https://github.com/nodejs/node/commit/12a3d0120b)] - **doc**: improve vm.md copy (James M Snell) [#6827](https://github.com/nodejs/node/pull/6827)
* [[`0ae512a3cf`](https://github.com/nodejs/node/commit/0ae512a3cf)] - **doc**: Add resolveNaptr and naptr rrtype docs (Doug Wade) [#6586](https://github.com/nodejs/node/pull/6586)
* [[`8309dbaf9c`](https://github.com/nodejs/node/commit/8309dbaf9c)] - **doc**: fix name to match git log (Robert Jefe Lindstaedt) [#6880](https://github.com/nodejs/node/pull/6880)
* [[`b52d838f0d`](https://github.com/nodejs/node/commit/b52d838f0d)] - **doc**: add note for fs.watch virtualized env (Robert Jefe Lindstaedt) [#6809](https://github.com/nodejs/node/pull/6809)
* [[`08f1361cb6`](https://github.com/nodejs/node/commit/08f1361cb6)] - **doc**: add `added:` information for punycode (Daniel Wang) [#6805](https://github.com/nodejs/node/pull/6805)
* [[`253db33527`](https://github.com/nodejs/node/commit/253db33527)] - **doc**: add `added:` info for dgram.*Membership() (Rich Trott) [#6753](https://github.com/nodejs/node/pull/6753)
* [[`5cad04b063`](https://github.com/nodejs/node/commit/5cad04b063)] - **doc**: clarify fs.mkdtemp prefix argument (James M Snell) [#6800](https://github.com/nodejs/node/pull/6800)
* [[`5a1e823fa5`](https://github.com/nodejs/node/commit/5a1e823fa5)] - **doc**: add `added:` information for fs (Anna Henningsen) [#6717](https://github.com/nodejs/node/pull/6717)
* [[`bf4724a7bb`](https://github.com/nodejs/node/commit/bf4724a7bb)] - **doc**: remove link to Sign in crypto.md (Kirill Fomichev) [#6812](https://github.com/nodejs/node/pull/6812)
* [[`ba3089970d`](https://github.com/nodejs/node/commit/ba3089970d)] - **doc**: add `added:` in for `tty` (Rich Trott) [#6783](https://github.com/nodejs/node/pull/6783)
* [[`758fadfa0d`](https://github.com/nodejs/node/commit/758fadfa0d)] - **doc**: update openssl.org hash links (silverwind) [#6817](https://github.com/nodejs/node/pull/6817)
* [[`b2c7d466d4`](https://github.com/nodejs/node/commit/b2c7d466d4)] - **doc,test**: add `How to write a Node.js test` guide (Santiago Gimeno) [#6984](https://github.com/nodejs/node/pull/6984)
* [[`c4329aa226`](https://github.com/nodejs/node/commit/c4329aa226)] - **fs**: move mkdtemp* functions near static functions (Sakthipriyan Vairamani) [#6828](https://github.com/nodejs/node/pull/6828)
* [[`c068880757`](https://github.com/nodejs/node/commit/c068880757)] - **fs**: mkdtemp shouldn't crash if no callback passed (Sakthipriyan Vairamani) [#6828](https://github.com/nodejs/node/pull/6828)
* [[`2ab36093e6`](https://github.com/nodejs/node/commit/2ab36093e6)] - **http**: use `localAddress` instead of `path` (Dirceu Pereira Tiegs) [#5190](https://github.com/nodejs/node/pull/5190)
* [[`6f0d8b3a1b`](https://github.com/nodejs/node/commit/6f0d8b3a1b)] - **installer**: don't install node_internals.h (Ben Noordhuis) [#6913](https://github.com/nodejs/node/pull/6913)
* [[`178f3080f8`](https://github.com/nodejs/node/commit/178f3080f8)] - **module**: don't cache uninitialized builtins (Anna Henningsen) [#6907](https://github.com/nodejs/node/pull/6907)
* [[`1908b7f00a`](https://github.com/nodejs/node/commit/1908b7f00a)] - **path**: fix basename() regressions (Brian White) [#6590](https://github.com/nodejs/node/pull/6590)
* [[`10671406ac`](https://github.com/nodejs/node/commit/10671406ac)] - **process**: internal/process/stdio.js cleanup / modernization (James M Snell) [#6766](https://github.com/nodejs/node/pull/6766)
* [[`64445674f0`](https://github.com/nodejs/node/commit/64445674f0)] - **src**: add include guards to internal headers (Ben Noordhuis) [#6948](https://github.com/nodejs/node/pull/6948)
* [[`4333fda46d`](https://github.com/nodejs/node/commit/4333fda46d)] - **src**: no abort from getter if object isn't wrapped (Trevor Norris) [#6184](https://github.com/nodejs/node/pull/6184)
* [[`4da3e1e461`](https://github.com/nodejs/node/commit/4da3e1e461)] - **src**: always clear wrap before persistent Reset() (Trevor Norris) [#6184](https://github.com/nodejs/node/pull/6184)
* [[`7e5775704e`](https://github.com/nodejs/node/commit/7e5775704e)] - **src**: inherit first from AsyncWrap (Trevor Norris) [#6184](https://github.com/nodejs/node/pull/6184)
* [[`0841496992`](https://github.com/nodejs/node/commit/0841496992)] - **src**: fix without-intl build (Anna Henningsen) [#6820](https://github.com/nodejs/node/pull/6820)
* [[`0d08fc415f`](https://github.com/nodejs/node/commit/0d08fc415f)] - **stream_base**: always use Base template class (Trevor Norris) [#6184](https://github.com/nodejs/node/pull/6184)
* [[`756ec80d50`](https://github.com/nodejs/node/commit/756ec80d50)] - **string_bytes**: Make base64 encode/decode reusable (Eugene Ostroukhov) [#6910](https://github.com/nodejs/node/pull/6910)
* [[`79ad172589`](https://github.com/nodejs/node/commit/79ad172589)] - **string_decoder**: rewrite implementation (Brian White) [#6777](https://github.com/nodejs/node/pull/6777)
* [[`8b720c4582`](https://github.com/nodejs/node/commit/8b720c4582)] - **test**: remove non-incremental common.PORT changes (Rich Trott) [#7055](https://github.com/nodejs/node/pull/7055)
* [[`6439fbfac0`](https://github.com/nodejs/node/commit/6439fbfac0)] - **test**: test TTY problems by fakeing a TTY using openpty (Jeremiah Senkpiel) [#6895](https://github.com/nodejs/node/pull/6895)
* [[`81a9f96a29`](https://github.com/nodejs/node/commit/81a9f96a29)] - **test**: make test-child-process-fork-net more robust (Rich Trott) [#7033](https://github.com/nodejs/node/pull/7033)
* [[`6cf0f622ef`](https://github.com/nodejs/node/commit/6cf0f622ef)] - **test**: fix spurious EADDRINUSE in test-https-strict (Rich Trott) [#7024](https://github.com/nodejs/node/pull/7024)
* [[`dea120f247`](https://github.com/nodejs/node/commit/dea120f247)] - **test**: update weak module for gc tests (Rich Trott) [#7014](https://github.com/nodejs/node/pull/7014)
* [[`3bfbe8a62a`](https://github.com/nodejs/node/commit/3bfbe8a62a)] - **test**: remove `common.PORT` from gc tests (Rich Trott) [#7013](https://github.com/nodejs/node/pull/7013)
* [[`b23cd48ca0`](https://github.com/nodejs/node/commit/b23cd48ca0)] - **test**: fix test-debug-port-numbers on OS X (Santiago Gimeno) [#7046](https://github.com/nodejs/node/pull/7046)
* [[`0a258e5369`](https://github.com/nodejs/node/commit/0a258e5369)] - **test**: remove modifcation to common.PORT (Rich Trott) [#6990](https://github.com/nodejs/node/pull/6990)
* [[`8c289df175`](https://github.com/nodejs/node/commit/8c289df175)] - **test**: use strictEqual consistently in agent test (Ben Noordhuis) [#6654](https://github.com/nodejs/node/pull/6654)
* [[`e4ac808c4d`](https://github.com/nodejs/node/commit/e4ac808c4d)] - **test**: work around debugger not killing inferior (Ben Noordhuis) [#7037](https://github.com/nodejs/node/pull/7037)
* [[`b5949f8bbc`](https://github.com/nodejs/node/commit/b5949f8bbc)] - **test**: verify cluster worker exit (cjihrig) [#6993](https://github.com/nodejs/node/pull/6993)
* [[`6f3f5af396`](https://github.com/nodejs/node/commit/6f3f5af396)] - **test**: add regression test for Proxy as vm context (Michaël Zasso) [#6967](https://github.com/nodejs/node/pull/6967)
* [[`38a3323cc9`](https://github.com/nodejs/node/commit/38a3323cc9)] - **test**: improve debug-break-on-uncaught reliability (Rich Trott) [#6793](https://github.com/nodejs/node/pull/6793)
* [[`83e6d53817`](https://github.com/nodejs/node/commit/83e6d53817)] - **test**: test cluster worker disconnection on error (Santiago Gimeno) [#6909](https://github.com/nodejs/node/pull/6909)
* [[`4cc6a18448`](https://github.com/nodejs/node/commit/4cc6a18448)] - **test**: verify IPC messages are emitted on next tick (Santiago Gimeno) [#6909](https://github.com/nodejs/node/pull/6909)
* [[`69e119dbfb`](https://github.com/nodejs/node/commit/69e119dbfb)] - **test**: refactor spawnSync() cwd test (cjihrig) [#6939](https://github.com/nodejs/node/pull/6939)
* [[`32cc43a1bd`](https://github.com/nodejs/node/commit/32cc43a1bd)] - **test**: fix component printing on windows (Ben Noordhuis) [#6915](https://github.com/nodejs/node/pull/6915)
* [[`c81b6f8d0d`](https://github.com/nodejs/node/commit/c81b6f8d0d)] - **test**: refactor to eliminate `__defineGetter__` (Rich Trott) [#6774](https://github.com/nodejs/node/pull/6774)
* [[`1965e445ec`](https://github.com/nodejs/node/commit/1965e445ec)] - **test**: refactor test-tls-reuse-host-from-socket (Rich Trott) [#6756](https://github.com/nodejs/node/pull/6756)
* [[`2cf3a53ce1`](https://github.com/nodejs/node/commit/2cf3a53ce1)] - **test**: fix test-debug-port-cluster flakiness (Rich Trott) [#6769](https://github.com/nodejs/node/pull/6769)
* [[`5374afdef8`](https://github.com/nodejs/node/commit/5374afdef8)] - **test**: add logging for test-debug-port-cluster (Rich Trott) [#6769](https://github.com/nodejs/node/pull/6769)
* [[`bae7adb6fa`](https://github.com/nodejs/node/commit/bae7adb6fa)] - **test**: fix flaky test-stdout-close-catch (Santiago Gimeno) [#6808](https://github.com/nodejs/node/pull/6808)
* [[`528ca04e8d`](https://github.com/nodejs/node/commit/528ca04e8d)] - **test**: add more path.basename() tests (Brian White) [#6590](https://github.com/nodejs/node/pull/6590)
* [[`1469b98fa1`](https://github.com/nodejs/node/commit/1469b98fa1)] - **test**: remove duplicate path tests (Brian White) [#6590](https://github.com/nodejs/node/pull/6590)
* [[`81e765f521`](https://github.com/nodejs/node/commit/81e765f521)] - **test**: robust handling of env for npm-test-install (Myles Borins) [#6797](https://github.com/nodejs/node/pull/6797)
* [[`2895860138`](https://github.com/nodejs/node/commit/2895860138)] - **test**: cluster-setup-master online workers check (Devon Rifkin) [#6535](https://github.com/nodejs/node/pull/6535)
* [[`7c932c2d49`](https://github.com/nodejs/node/commit/7c932c2d49)] - **test**: added tests for https-agent-getname (suryagh) [#6762](https://github.com/nodejs/node/pull/6762)
* [[`827b3eb503`](https://github.com/nodejs/node/commit/827b3eb503)] - **test**: add --repeat option to tools/test.py (Michael Dawson) [#6700](https://github.com/nodejs/node/pull/6700)
* [[`ea287fc1a6`](https://github.com/nodejs/node/commit/ea287fc1a6)] - **test,win**: skip addons/load-long-path on WOW64 (Alexis Campailla) [#6675](https://github.com/nodejs/node/pull/6675)
* [[`21e31352d7`](https://github.com/nodejs/node/commit/21e31352d7)] - **tls**: catch `certCbDone` exceptions (Fedor Indutny) [#6887](https://github.com/nodejs/node/pull/6887)
* [[`257e54b9c0`](https://github.com/nodejs/node/commit/257e54b9c0)] - **tls,https**: respect address family when connecting (Ben Noordhuis) [#6654](https://github.com/nodejs/node/pull/6654)
* [[`5779ed2a4a`](https://github.com/nodejs/node/commit/5779ed2a4a)] - **tls_wrap**: do not abort on new TLSWrap() (Trevor Norris) [#6184](https://github.com/nodejs/node/pull/6184)
* [[`108523e06e`](https://github.com/nodejs/node/commit/108523e06e)] - **tools**: make sure doctool anchors respect includes (Anna Henningsen) [#6943](https://github.com/nodejs/node/pull/6943)
* [[`bf3afce668`](https://github.com/nodejs/node/commit/bf3afce668)] - **tools**: restore change of signatures to opts hashes (Jesse McCarthy) [#6690](https://github.com/nodejs/node/pull/6690)
* [[`ceee56b28b`](https://github.com/nodejs/node/commit/ceee56b28b)] - **tools**: disallow deprecated define getter/setter (Rich Trott) [#6774](https://github.com/nodejs/node/pull/6774)
* [[`614907e516`](https://github.com/nodejs/node/commit/614907e516)] - **tools**: print stderr on bad test.py `vmArch` check (Jeremiah Senkpiel) [#6786](https://github.com/nodejs/node/pull/6786)
* [[`4d3a7594a5`](https://github.com/nodejs/node/commit/4d3a7594a5)] - **tty**: use blocking mode on OS X (Jeremiah Senkpiel) [#6895](https://github.com/nodejs/node/pull/6895)
* [[`36ed4a2d7a`](https://github.com/nodejs/node/commit/36ed4a2d7a)] - **udp**: use libuv API to get file descriptor (Saúl Ibarra Corretgé) [#6908](https://github.com/nodejs/node/pull/6908)
* [[`f3e3eebec8`](https://github.com/nodejs/node/commit/f3e3eebec8)] - **unix,stream**: fix getting the correct fd for a handle (Saúl Ibarra Corretgé) [#6753](https://github.com/nodejs/node/pull/6753)
* [[`d270706881`](https://github.com/nodejs/node/commit/d270706881)] - **util**: pretty-print SIMD types (Ben Noordhuis) [#6917](https://github.com/nodejs/node/pull/6917)
* [[`55b736a63b`](https://github.com/nodejs/node/commit/55b736a63b)] - **vm**: don't abort process when stack space runs out (Anna Henningsen) [#6907](https://github.com/nodejs/node/pull/6907)
* [[`cb2ef35b76`](https://github.com/nodejs/node/commit/cb2ef35b76)] - **win,build**: add creation of zip and 7z package (Bartosz Sosnowski) [#5995](https://github.com/nodejs/node/pull/5995)
* [[`1e26b82ce4`](https://github.com/nodejs/node/commit/1e26b82ce4)] - **zlib**: release callback and buffer after processing (Matt Lavin) [#6955](https://github.com/nodejs/node/pull/6955)
* [[`64415564de`](https://github.com/nodejs/node/commit/64415564de)] - **zlib**: remove `_closed` in source (Anna Henningsen) [#6574](https://github.com/nodejs/node/pull/6574)

<a id="6.2.0"></a>
## 2016-05-17, Version 6.2.0 (Current), @evanlucas

### Notable changes

- **buffer**: fix lastIndexOf and indexOf in various edge cases (Anna Henningsen) [#6511](https://github.com/nodejs/node/pull/6511)
- **child_process**: use /system/bin/sh on android (Ben Noordhuis) [#6745](https://github.com/nodejs/node/pull/6745)
- **deps**:
  - upgrade npm to 3.8.9 (Rebecca Turner) [#6664](https://github.com/nodejs/node/pull/6664)
  - upgrade to V8 5.0.71.47 (Ali Ijaz Sheikh) [#6572](https://github.com/nodejs/node/pull/6572)
  - upgrade libuv to 1.9.1 (Saúl Ibarra Corretgé) [#6796](https://github.com/nodejs/node/pull/6796)
  - Intl: ICU 57 bump (Steven R. Loomis) [#6088](https://github.com/nodejs/node/pull/6088)
- **repl**:
  - copying tabs shouldn't trigger completion (Eugene Obrezkov) [#5958](https://github.com/nodejs/node/pull/5958)
  - exports `Recoverable` (Blake Embrey) [#3488](https://github.com/nodejs/node/pull/3488)
- **src**: add O_NOATIME constant (Rich Trott) [#6492](https://github.com/nodejs/node/pull/6492)
- **src,module**: add --preserve-symlinks command line flag (James M Snell) [#6537](https://github.com/nodejs/node/pull/6537)
- **util**: adhere to `noDeprecation` set at runtime (Anna Henningsen) [#6683](https://github.com/nodejs/node/pull/6683)

As of this release the 6.X line now includes 64-bit binaries for Linux on Power Systems
running in big endian mode in addition to the existing 64-bit binaries for running in little endian mode.

### Commits

* [[`955c90d725`](https://github.com/nodejs/node/commit/955c90d725)] - **benchmark,test,lib**: remove extra spaces (Rich Trott) [#6645](https://github.com/nodejs/node/pull/6645)
* [[`9cd14ced09`](https://github.com/nodejs/node/commit/9cd14ced09)] - **buffer**: fix UCS2 indexOf for odd buffer length (Anna Henningsen) [#6511](https://github.com/nodejs/node/pull/6511)
* [[`a550ddbf3c`](https://github.com/nodejs/node/commit/a550ddbf3c)] - **buffer**: fix needle length misestimation for UCS2 (Anna Henningsen) [#6511](https://github.com/nodejs/node/pull/6511)
* [[`6fc20c5a97`](https://github.com/nodejs/node/commit/6fc20c5a97)] - **buffer**: fix lastIndexOf crash for overlong needle (Anna Henningsen) [#6511](https://github.com/nodejs/node/pull/6511)
* [[`44015754a3`](https://github.com/nodejs/node/commit/44015754a3)] - **buffer**: fix lastIndexOf index underflow issue (Anna Henningsen) [#6511](https://github.com/nodejs/node/pull/6511)
* [[`6032dc25cc`](https://github.com/nodejs/node/commit/6032dc25cc)] - **build**: add Make `doc-only` target (Jesse McCarthy) [#3888](https://github.com/nodejs/node/pull/3888)
* [[`3af9382a5d`](https://github.com/nodejs/node/commit/3af9382a5d)] - **build**: don't compile with -B, redux (Ben Noordhuis) [#6650](https://github.com/nodejs/node/pull/6650)
* [[`5149d66702`](https://github.com/nodejs/node/commit/5149d66702)] - **build**: fix DESTCPU detection for binary target (Richard Lau) [#6310](https://github.com/nodejs/node/pull/6310)
* [[`6eed6a3ac0`](https://github.com/nodejs/node/commit/6eed6a3ac0)] - **build,test**: fix build-addons dependency chain (Ben Noordhuis) [#6652](https://github.com/nodejs/node/pull/6652)
* [[`e0240ab592`](https://github.com/nodejs/node/commit/e0240ab592)] - **child_process**: use /system/bin/sh on android (Ben Noordhuis) [#6745](https://github.com/nodejs/node/pull/6745)
* [[`e8c9f01cdd`](https://github.com/nodejs/node/commit/e8c9f01cdd)] - **crypto**: disable ssl compression at build time (Ben Noordhuis) [#6582](https://github.com/nodejs/node/pull/6582)
* [[`62690aa0be`](https://github.com/nodejs/node/commit/62690aa0be)] - **deps**: update comment about PURIFY define (Ben Noordhuis) [#6582](https://github.com/nodejs/node/pull/6582)
* [[`bddf413412`](https://github.com/nodejs/node/commit/bddf413412)] - **deps**: upgrade npm to 3.8.9 (Rebecca Turner) [#6664](https://github.com/nodejs/node/pull/6664)
* [[`a6ca5e559a`](https://github.com/nodejs/node/commit/a6ca5e559a)] - **deps**: upgrade to V8 5.0.71.47 (Ali Ijaz Sheikh) [#6572](https://github.com/nodejs/node/pull/6572)
* [[`16159c23ed`](https://github.com/nodejs/node/commit/16159c23ed)] - **deps**: limit regress/regress-crbug-514081 v8 test (Michael Dawson) [#6678](https://github.com/nodejs/node/pull/6678)
* [[`2d84ac735a`](https://github.com/nodejs/node/commit/2d84ac735a)] - **deps**: upgrade libuv to 1.9.1 (Saúl Ibarra Corretgé) [#6796](https://github.com/nodejs/node/pull/6796)
* [[`7a6d2ad181`](https://github.com/nodejs/node/commit/7a6d2ad181)] - **deps**: Intl: Check in "small-icu" 57.1 (Steven R. Loomis) [#6088](https://github.com/nodejs/node/pull/6088)
* [[`ee1e5a267d`](https://github.com/nodejs/node/commit/ee1e5a267d)] - **deps**: Intl: ICU 57 bump (Steven R. Loomis) [#6088](https://github.com/nodejs/node/pull/6088)
* [[`a4ed7dfb3d`](https://github.com/nodejs/node/commit/a4ed7dfb3d)] - **doc**: Add CTC meeting minutes for 2016-05-04 (Michael Dawson) [#6579](https://github.com/nodejs/node/pull/6579)
* [[`5c7da210df`](https://github.com/nodejs/node/commit/5c7da210df)] - **doc**: refactor the changelog by version (James M Snell) [#6503](https://github.com/nodejs/node/pull/6503)
* [[`4f2a55f92f`](https://github.com/nodejs/node/commit/4f2a55f92f)] - **doc**: fix issues related to page scrolling (Roman Reiss)
* [[`b4fb95eade`](https://github.com/nodejs/node/commit/b4fb95eade)] - **doc**: add `added:` information for assert (Rich Trott) [#6688](https://github.com/nodejs/node/pull/6688)
* [[`64fcba2a2e`](https://github.com/nodejs/node/commit/64fcba2a2e)] - **doc**: appendFileSync accepts fd as well (Faiz Halde) [#6707](https://github.com/nodejs/node/pull/6707)
* [[`520369d8e0`](https://github.com/nodejs/node/commit/520369d8e0)] - **doc**: fix exec example in child_process (Evan Lucas) [#6660](https://github.com/nodejs/node/pull/6660)
* [[`51d1960955`](https://github.com/nodejs/node/commit/51d1960955)] - **doc**: undocument fs.open's 'rs' mode (Saúl Ibarra Corretgé) [#6732](https://github.com/nodejs/node/pull/6732)
* [[`f1c773d18b`](https://github.com/nodejs/node/commit/f1c773d18b)] - **doc**: add `added:` information for v8 (Rich Trott) [#6684](https://github.com/nodejs/node/pull/6684)
* [[`29b28a233c`](https://github.com/nodejs/node/commit/29b28a233c)] - **doc**: server.listen truncates socket path on unix (Jean Regisser) [#6659](https://github.com/nodejs/node/pull/6659)
* [[`c1d5f2e96e`](https://github.com/nodejs/node/commit/c1d5f2e96e)] - **doc**: update releases.md with new changelog structure (James M Snell) [#6503](https://github.com/nodejs/node/pull/6503)
* [[`d962fbafb2`](https://github.com/nodejs/node/commit/d962fbafb2)] - **doc**: "a" -> "an" in api/documentation.md (Anchika Agarwal) [#6689](https://github.com/nodejs/node/pull/6689)
* [[`26e22e200a`](https://github.com/nodejs/node/commit/26e22e200a)] - **doc**: move the readme newcomers section (Jeremiah Senkpiel) [#6681](https://github.com/nodejs/node/pull/6681)
* [[`8f526494b5`](https://github.com/nodejs/node/commit/8f526494b5)] - **doc**: fix deprecation warnings in addon examples (Ben Noordhuis) [#6652](https://github.com/nodejs/node/pull/6652)
* [[`d34343f0de`](https://github.com/nodejs/node/commit/d34343f0de)] - **doc**: mention existence/purpose of module wrapper (Matt Harrison) [#6433](https://github.com/nodejs/node/pull/6433)
* [[`5c154a87e0`](https://github.com/nodejs/node/commit/5c154a87e0)] - **doc**: add steps for running addons + npm tests (Myles Borins) [#6231](https://github.com/nodejs/node/pull/6231)
* [[`6ea43d12f4`](https://github.com/nodejs/node/commit/6ea43d12f4)] - **doc**: improve onboarding-extras.md formatting (Jeremiah Senkpiel) [#6548](https://github.com/nodejs/node/pull/6548)
* [[`38f5603e97`](https://github.com/nodejs/node/commit/38f5603e97)] - **doc**: fix linewrap in node.1 (Jeremiah Senkpiel) [#6532](https://github.com/nodejs/node/pull/6532)
* [[`5b47accfa6`](https://github.com/nodejs/node/commit/5b47accfa6)] - **doc**: v8 options can use either `_` or `-` (Jeremiah Senkpiel) [#6532](https://github.com/nodejs/node/pull/6532)
* [[`fa94a91bbd`](https://github.com/nodejs/node/commit/fa94a91bbd)] - **doc**: v8 functions as methods on v8 (Bryan English) [#6615](https://github.com/nodejs/node/pull/6615)
* [[`d49b49e8b1`](https://github.com/nodejs/node/commit/d49b49e8b1)] - **doc**: discourage use of util.inherits (Robert Jefe Lindstaedt) [#6514](https://github.com/nodejs/node/pull/6514)
* [[`925fc36dd9`](https://github.com/nodejs/node/commit/925fc36dd9)] - **doc**: add `added:` information for os (Bryan English) [#6609](https://github.com/nodejs/node/pull/6609)
* [[`58cd11c844`](https://github.com/nodejs/node/commit/58cd11c844)] - **doc**: add `added:` information for process (Bryan English) [#6589](https://github.com/nodejs/node/pull/6589)
* [[`d5f7f24aec`](https://github.com/nodejs/node/commit/d5f7f24aec)] - **doc**: add `added:` information for url (Bryan English) [#6593](https://github.com/nodejs/node/pull/6593)
* [[`715b48c1d3`](https://github.com/nodejs/node/commit/715b48c1d3)] - **doc**: add `added:` information for querystring (Bryan English) [#6593](https://github.com/nodejs/node/pull/6593)
* [[`04697a5023`](https://github.com/nodejs/node/commit/04697a5023)] - **doc**: correct anchors for buffer.md (Jackson Tian) [#6542](https://github.com/nodejs/node/pull/6542)
* [[`2d677411a4`](https://github.com/nodejs/node/commit/2d677411a4)] - **doc**: add `added:` information for buffer (Anna Henningsen) [#6495](https://github.com/nodejs/node/pull/6495)
* [[`49af20c2e6`](https://github.com/nodejs/node/commit/49af20c2e6)] - **doc**: update fs callback example error stack (DavidCai) [#6617](https://github.com/nodejs/node/pull/6617)
* [[`9196d87704`](https://github.com/nodejs/node/commit/9196d87704)] - **doc**: add `added:` info for `string_decoder` (Rich Trott) [#6741](https://github.com/nodejs/node/pull/6741)
* [[`688f563ca8`](https://github.com/nodejs/node/commit/688f563ca8)] - **doc**: update vm.runInDebugContext() example (Ben Noordhuis) [#6757](https://github.com/nodejs/node/pull/6757)
* [[`2273971a69`](https://github.com/nodejs/node/commit/2273971a69)] - **doc**: readline.emitKeypressEvents and raw mode (Arve Seljebu) [#6628](https://github.com/nodejs/node/pull/6628)
* [[`1c7b6e276f`](https://github.com/nodejs/node/commit/1c7b6e276f)] - **doc**: improve zlib docs (James M Snell) [#6746](https://github.com/nodejs/node/pull/6746)
* [[`897934a719`](https://github.com/nodejs/node/commit/897934a719)] - **doc**: copyedit maxBuffer note for child_process (Rich Trott) [#6760](https://github.com/nodejs/node/pull/6760)
* [[`c1bf3fc0b1`](https://github.com/nodejs/node/commit/c1bf3fc0b1)] - **doc**: fix links in socket.connecting (Kirill Fomichev) [#6657](https://github.com/nodejs/node/pull/6657)
* [[`ad895f490b`](https://github.com/nodejs/node/commit/ad895f490b)] - **doc**: trim GitHub template comments (Rich Trott) [#6755](https://github.com/nodejs/node/pull/6755)
* [[`af096f1172`](https://github.com/nodejs/node/commit/af096f1172)] - **doc**: add `added` info for `dgram.setBroadcast()` (Rich Trott) [#6750](https://github.com/nodejs/node/pull/6750)
* [[`e8c0dba4bd`](https://github.com/nodejs/node/commit/e8c0dba4bd)] - **doc,events**: fix a link typo (yorkie) [#6640](https://github.com/nodejs/node/pull/6640)
* [[`f31a5ec34a`](https://github.com/nodejs/node/commit/f31a5ec34a)] - **handle_wrap**: IsRefed() -> HasRef() (Jeremiah Senkpiel) [#6546](https://github.com/nodejs/node/pull/6546)
* [[`cc2af793d2`](https://github.com/nodejs/node/commit/cc2af793d2)] - ***Revert*** "**handle_wrap**: IsRefed -> Unrefed, no isAlive check" (Jeremiah Senkpiel) [#6546](https://github.com/nodejs/node/pull/6546)
* [[`2000072903`](https://github.com/nodejs/node/commit/2000072903)] - **handle_wrap**: IsRefed -> Unrefed, no isAlive check (Jeremiah Senkpiel) [#6204](https://github.com/nodejs/node/pull/6204)
* [[`d3132048cb`](https://github.com/nodejs/node/commit/d3132048cb)] - **(SEMVER-MINOR)** **handle_wrap**: expose an `isRefed()` check to JS (Jeremiah Senkpiel) [#5834](https://github.com/nodejs/node/pull/5834)
* [[`59666502c5`](https://github.com/nodejs/node/commit/59666502c5)] - **intl**: Don't crash if v8BreakIterator not available (Steven R. Loomis) [#4253](https://github.com/nodejs/node/pull/4253)
* [[`74582aa590`](https://github.com/nodejs/node/commit/74582aa590)] - **lib**: replace legacy uses of `__defineGetter__` (James M Snell) [#6768](https://github.com/nodejs/node/pull/6768)
* [[`559c2583e0`](https://github.com/nodejs/node/commit/559c2583e0)] - **lib,test**: update in preparation for linter update (Rich Trott) [#6498](https://github.com/nodejs/node/pull/6498)
* [[`226b9668db`](https://github.com/nodejs/node/commit/226b9668db)] - **(SEMVER-MINOR)** **repl**: copying tabs shouldn't trigger completion (Eugene Obrezkov) [#5958](https://github.com/nodejs/node/pull/5958)
* [[`ce2d5be4a1`](https://github.com/nodejs/node/commit/ce2d5be4a1)] - **(SEMVER-MINOR)** **repl**: exports `Recoverable` (Blake Embrey) [#3488](https://github.com/nodejs/node/pull/3488)
* [[`635357958d`](https://github.com/nodejs/node/commit/635357958d)] - **repl**: create history file with mode 0600 (Carl Lei) [#3394](https://github.com/nodejs/node/pull/3394)
* [[`e3920d12ef`](https://github.com/nodejs/node/commit/e3920d12ef)] - **src**: fix check-imports.py linter errors (Sakthipriyan Vairamani) [#6105](https://github.com/nodejs/node/pull/6105)
* [[`bbf3b3ebbb`](https://github.com/nodejs/node/commit/bbf3b3ebbb)] - **src**: simplify handlewrap state tracking logic (Ben Noordhuis) [#6395](https://github.com/nodejs/node/pull/6395)
* [[`965274d384`](https://github.com/nodejs/node/commit/965274d384)] - **src**: use libuv's refcounting directly (Ben Noordhuis) [#6395](https://github.com/nodejs/node/pull/6395)
* [[`316871f268`](https://github.com/nodejs/node/commit/316871f268)] - **src**: fix -Wunused-variable compiler warning (Ben Noordhuis) [#6129](https://github.com/nodejs/node/pull/6129)
* [[`1def098b9f`](https://github.com/nodejs/node/commit/1def098b9f)] - **src**: fix sporadic deadlock in SIGUSR1 handler (Ben Noordhuis) [#5904](https://github.com/nodejs/node/pull/5904)
* [[`477e61db9f`](https://github.com/nodejs/node/commit/477e61db9f)] - **src**: don't use locale-sensitive strcasecmp() (Ben Noordhuis) [#6582](https://github.com/nodejs/node/pull/6582)
* [[`1e99643fc9`](https://github.com/nodejs/node/commit/1e99643fc9)] - **src**: remove unused #include statement (Ben Noordhuis) [#6582](https://github.com/nodejs/node/pull/6582)
* [[`62593bd44c`](https://github.com/nodejs/node/commit/62593bd44c)] - **src**: remove pre-openssl 1.0 legacy code (Ben Noordhuis) [#6582](https://github.com/nodejs/node/pull/6582)
* [[`27c17ce9d1`](https://github.com/nodejs/node/commit/27c17ce9d1)] - **src**: fix FindFirstCharacter argument alignment (Anna Henningsen) [#6511](https://github.com/nodejs/node/pull/6511)
* [[`37736f4dad`](https://github.com/nodejs/node/commit/37736f4dad)] - **(SEMVER-MINOR)** **src**: add O_NOATIME constant (Rich Trott) [#6492](https://github.com/nodejs/node/pull/6492)
* [[`bd4454fa0f`](https://github.com/nodejs/node/commit/bd4454fa0f)] - **src,lib**: minor --debug-brk cleanup (Ali Ijaz Sheikh) [#6599](https://github.com/nodejs/node/pull/6599)
* [[`95b7560d8e`](https://github.com/nodejs/node/commit/95b7560d8e)] - **(SEMVER-MINOR)** **src,module**: add --preserve-symlinks command line flag (James M Snell) [#6537](https://github.com/nodejs/node/pull/6537)
* [[`8a7e68ff83`](https://github.com/nodejs/node/commit/8a7e68ff83)] - **test**: check that 2nd handle.close() call is a nop (Ben Noordhuis) [#6395](https://github.com/nodejs/node/pull/6395)
* [[`ccbc78cfc6`](https://github.com/nodejs/node/commit/ccbc78cfc6)] - **test**: remove common.getServiceName() (Rich Trott) [#6709](https://github.com/nodejs/node/pull/6709)
* [[`8c634d78f8`](https://github.com/nodejs/node/commit/8c634d78f8)] - **test**: favor strictEqual() in addon test (Rich Trott) [#6704](https://github.com/nodejs/node/pull/6704)
* [[`1389a4fc5e`](https://github.com/nodejs/node/commit/1389a4fc5e)] - **test**: fix flaky test-preload (Rich Trott) [#6728](https://github.com/nodejs/node/pull/6728)
* [[`adb2d610e6`](https://github.com/nodejs/node/commit/adb2d610e6)] - **test**: include component in tap output (Ben Noordhuis) [#6653](https://github.com/nodejs/node/pull/6653)
* [[`abb063a6a3`](https://github.com/nodejs/node/commit/abb063a6a3)] - **test**: fix test-debugger-repl-break-in-module (Rich Trott) [#6686](https://github.com/nodejs/node/pull/6686)
* [[`5701599767`](https://github.com/nodejs/node/commit/5701599767)] - **test**: fix test-debugger-repl-term (Rich Trott) [#6682](https://github.com/nodejs/node/pull/6682)
* [[`71c91747ef`](https://github.com/nodejs/node/commit/71c91747ef)] - **test**: add tests for stream3 buffering using cork (Alex J Burke) [#6493](https://github.com/nodejs/node/pull/6493)
* [[`b1f58edd54`](https://github.com/nodejs/node/commit/b1f58edd54)] - **test**: abstract skip functionality to common (Jeremiah Senkpiel) [#6697](https://github.com/nodejs/node/pull/6697)
* [[`7d3f5751b3`](https://github.com/nodejs/node/commit/7d3f5751b3)] - **test**: make sure O_NOATIME is present only in Linux (Sakthipriyan Vairamani) [#6614](https://github.com/nodejs/node/pull/6614)
* [[`75adc6a026`](https://github.com/nodejs/node/commit/75adc6a026)] - **test**: move test-debugger-debug-brk to sequential (Rich Trott) [#6731](https://github.com/nodejs/node/pull/6731)
* [[`0bc1784529`](https://github.com/nodejs/node/commit/0bc1784529)] - **test**: refactor doctool tests (Rich Trott) [#6719](https://github.com/nodejs/node/pull/6719)
* [[`89b25fac4c`](https://github.com/nodejs/node/commit/89b25fac4c)] - **test**: fix test-process-exec-argv flakiness (Santiago Gimeno) [#6575](https://github.com/nodejs/node/pull/6575)
* [[`3f9d72408f`](https://github.com/nodejs/node/commit/3f9d72408f)] - **test**: pass python path to node-gyp (hefangshi) [#6646](https://github.com/nodejs/node/pull/6646)
* [[`0c62bd13fb`](https://github.com/nodejs/node/commit/0c62bd13fb)] - **test**: ensure test-npm-install uses correct node (Myles Borins) [#6658](https://github.com/nodejs/node/pull/6658)
* [[`1b71231dd2`](https://github.com/nodejs/node/commit/1b71231dd2)] - **test**: fix test-vm-cached-data to work with old v8 (Myles Borins) [#6317](https://github.com/nodejs/node/pull/6317)
* [[`0eb25cb4b5`](https://github.com/nodejs/node/commit/0eb25cb4b5)] - **test**: test preloaded modules using stdin or repl (Bradley Meck) [#2253](https://github.com/nodejs/node/pull/2253)
* [[`577e132f00`](https://github.com/nodejs/node/commit/577e132f00)] - **test**: fix test-debugger-pid (Santiago Gimeno) [#6584](https://github.com/nodejs/node/pull/6584)
* [[`d74062454b`](https://github.com/nodejs/node/commit/d74062454b)] - **test**: make stdout buffer test more robust (Rich Trott) [#6633](https://github.com/nodejs/node/pull/6633)
* [[`f264749c5c`](https://github.com/nodejs/node/commit/f264749c5c)] - **test**: build addons with V8_DEPRECATION_WARNINGS=1 (Ben Noordhuis) [#6652](https://github.com/nodejs/node/pull/6652)
* [[`01f010f669`](https://github.com/nodejs/node/commit/01f010f669)] - **test**: allow out-of-order replies in dgram tests (Anna Henningsen) [#6607](https://github.com/nodejs/node/pull/6607)
* [[`be241c3262`](https://github.com/nodejs/node/commit/be241c3262)] - **test**: run known_issues tests in CI (Rich Trott) [#6559](https://github.com/nodejs/node/pull/6559)
* [[`8141c2fce2`](https://github.com/nodejs/node/commit/8141c2fce2)] - **test**: add tests for console.\[info|error|warn\] (Bryan English) [#6538](https://github.com/nodejs/node/pull/6538)
* [[`83dab801e2`](https://github.com/nodejs/node/commit/83dab801e2)] - **test**: fix unreliable known_issues test (Rich Trott) [#6555](https://github.com/nodejs/node/pull/6555)
* [[`8c434e6d84`](https://github.com/nodejs/node/commit/8c434e6d84)] - **test**: unmark test-http-regr-gh-2928 as flaky (Rich Trott) [#6540](https://github.com/nodejs/node/pull/6540)
* [[`916e694b2b`](https://github.com/nodejs/node/commit/916e694b2b)] - **test**: avoid test-cluster-master-* flakiness (Stefan Budeanu) [#6531](https://github.com/nodejs/node/pull/6531)
* [[`be5386e0cf`](https://github.com/nodejs/node/commit/be5386e0cf)] - **test,dgram**: add tests for setBroadcast() (Rich Trott) [#6750](https://github.com/nodejs/node/pull/6750)
* [[`1370fdcad5`](https://github.com/nodejs/node/commit/1370fdcad5)] - **test,tools**: test yaml parsing of doctool (Anna Henningsen) [#6495](https://github.com/nodejs/node/pull/6495)
* [[`347abf341d`](https://github.com/nodejs/node/commit/347abf341d)] - **tools**: enforce linting for unix-style line endings (Rich Trott) [#6685](https://github.com/nodejs/node/pull/6685)
* [[`a63c556c11`](https://github.com/nodejs/node/commit/a63c556c11)] - **tools**: remove the minifying logic (Sakthipriyan Vairamani) [#6636](https://github.com/nodejs/node/pull/6636)
* [[`efcbafa3f7`](https://github.com/nodejs/node/commit/efcbafa3f7)] - **tools**: fix regression in doctool (Myles Borins) [#6680](https://github.com/nodejs/node/pull/6680)
* [[`edb29b8096`](https://github.com/nodejs/node/commit/edb29b8096)] - **tools**: lint for object literal spacing (Rich Trott) [#6592](https://github.com/nodejs/node/pull/6592)
* [[`6806ebb608`](https://github.com/nodejs/node/commit/6806ebb608)] - **tools**: lint for use of space in template strings (Rich Trott) [#6591](https://github.com/nodejs/node/pull/6591)
* [[`341eaf202e`](https://github.com/nodejs/node/commit/341eaf202e)] - **tools**: update marked dependency (Daniel Wang) [#6396](https://github.com/nodejs/node/pull/6396)
* [[`94f82553aa`](https://github.com/nodejs/node/commit/94f82553aa)] - **tools**: allow multiple added: version entries (Anna Henningsen) [#6495](https://github.com/nodejs/node/pull/6495)
* [[`1de25f208c`](https://github.com/nodejs/node/commit/1de25f208c)] - **tools**: do not build addons during compilation (Myles Borins) [#6723](https://github.com/nodejs/node/pull/6723)
* [[`26805c97d0`](https://github.com/nodejs/node/commit/26805c97d0)] - **tools**: fix tools/doc/addon-verify.js regression (Anna Henningsen) [#6652](https://github.com/nodejs/node/pull/6652)
* [[`cea17775e0`](https://github.com/nodejs/node/commit/cea17775e0)] - **tools**: parse documentation metadata (Tristian Flanagan) [#6495](https://github.com/nodejs/node/pull/6495)
* [[`a568ad4205`](https://github.com/nodejs/node/commit/a568ad4205)] - **tools**: add mock-y js-yaml dependency to doctool (Anna Henningsen) [#6495](https://github.com/nodejs/node/pull/6495)
* [[`dce6413576`](https://github.com/nodejs/node/commit/dce6413576)] - **tools**: Check in tools for shrinking ICU size, change default to small-icu (Steven R. Loomis) [#6088](https://github.com/nodejs/node/pull/6088)
* [[`d629f265fe`](https://github.com/nodejs/node/commit/d629f265fe)] - **tools**: update ESLint to 2.9.0 (Rich Trott) [#6498](https://github.com/nodejs/node/pull/6498)
* [[`6aa92d5a98`](https://github.com/nodejs/node/commit/6aa92d5a98)] - **tools**: disallow multiple spaces except indentation (Rich Trott) [#6645](https://github.com/nodejs/node/pull/6645)
* [[`ceeae4b180`](https://github.com/nodejs/node/commit/ceeae4b180)] - **tools,test**: make argument linting more stringent (Rich Trott) [#6720](https://github.com/nodejs/node/pull/6720)
* [[`6d1527bb37`](https://github.com/nodejs/node/commit/6d1527bb37)] - **util**: fix invalid date output with util.inspect (Rumkin) [#6504](https://github.com/nodejs/node/pull/6504)
* [[`1d6c17efd7`](https://github.com/nodejs/node/commit/1d6c17efd7)] - **util**: adhere to `noDeprecation` set at runtime (Anna Henningsen) [#6683](https://github.com/nodejs/node/pull/6683)

<a id="6.1.0"></a>
## 2016-05-05, Version 6.1.0 (Current), @Fishrock123

### Notable Changes

* **assert**: `deep{Strict}Equal()` now works correctly with circular references. (Rich Trott) [#6432](https://github.com/nodejs/node/pull/6432)
* **debugger**: Arrays are now formatted correctly in the debugger repl. (cjihrig) [#6448](https://github.com/nodejs/node/pull/6448)
* **deps**: Upgrade OpenSSL sources to 1.0.2h (Shigeki Ohtsu) [#6550](https://github.com/nodejs/node/pull/6550)
  - Please see our [blog post](https://nodejs.org/en/blog/vulnerability/openssl-may-2016/) for more info on the security contents of this release.
* **net**: Introduced a `Socket#connecting` property. (Fedor Indutny) [#6404](https://github.com/nodejs/node/pull/6404)
  - Previously this information was only available as the undocumented, internal `_connecting` property.
* **process**: Introduced `process.cpuUsage()`. (Patrick Mueller) [#6157](https://github.com/nodejs/node/pull/6157)
* **stream**: `Writable#setDefaultEncoding()` now returns `this`. (Alexander Makarenko) [#5040](https://github.com/nodejs/node/pull/5040)
* **util**: Two new additions to `util.inspect()`:
  - Added a `maxArrayLength` option to truncate the formatting of Arrays. (James M Snell) [#6334](https://github.com/nodejs/node/pull/6334)
    - This is set to `100` by default.
  - Added a `showProxy` option for formatting proxy intercepting handlers. (James M Snell) [#6465](https://github.com/nodejs/node/pull/6465)
    - Inspecting proxies is non-trivial and as such this is off by default.

### Commits

* [[`76c9ab5fcf`](https://github.com/nodejs/node/commit/76c9ab5fcf)] - **assert**: allow circular references (Rich Trott) [#6432](https://github.com/nodejs/node/pull/6432)
* [[`7b9ae70757`](https://github.com/nodejs/node/commit/7b9ae70757)] - **benchmark**: Fix crash in net benchmarks (Matt Loring) [#6407](https://www.github.com/nodejs/node/pull/6407)
* [[`0d1985358a`](https://github.com/nodejs/node/commit/0d1985358a)] - **build**: use shorthand lint target from test (Johan Bergström) [#6406](https://github.com/nodejs/node/pull/6406)
* [[`7153f96f0e`](https://github.com/nodejs/node/commit/7153f96f0e)] - **build**: unbreak -prof, disable PIE on OS X (Ben Noordhuis) [#6453](https://github.com/nodejs/node/pull/6453)
* [[`8956432e18`](https://github.com/nodejs/node/commit/8956432e18)] - **build**: exclude tap files from tarballs (Brian White) [#6348](https://github.com/nodejs/node/pull/6348)
* [[`11e7cc5310`](https://github.com/nodejs/node/commit/11e7cc5310)] - **build**: don't compile with -B (Ben Noordhuis) [#6393](https://github.com/nodejs/node/pull/6393)
* [[`1330496bbf`](https://github.com/nodejs/node/commit/1330496bbf)] - **cluster**: remove use of bind() in destroy() (yorkie) [#6502](https://github.com/nodejs/node/pull/6502)
* [[`fdde36909c`](https://github.com/nodejs/node/commit/fdde36909c)] - **crypto**: fix error in deprecation message (Rich Trott) [#6344](https://github.com/nodejs/node/pull/6344)
* [[`2d503b1d4b`](https://github.com/nodejs/node/commit/2d503b1d4b)] - **debugger**: display array contents in repl (cjihrig) [#6448](https://github.com/nodejs/node/pull/6448)
* [[`54f8600613`](https://github.com/nodejs/node/commit/54f8600613)] - **deps**: update openssl asm and asm_obsolete files (Shigeki Ohtsu) [#6550](https://github.com/nodejs/node/pull/6550)
* [[`a5a2944877`](https://github.com/nodejs/node/commit/a5a2944877)] - **deps**: add -no_rand_screen to openssl s_client (Shigeki Ohtsu) [nodejs/io.js#1836](https://github.com/nodejs/io.js/pull/1836)
* [[`3fe68129c8`](https://github.com/nodejs/node/commit/3fe68129c8)] - **deps**: fix asm build error of openssl in x86_win32 (Shigeki Ohtsu) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`d159462fed`](https://github.com/nodejs/node/commit/d159462fed)] - **deps**: fix openssl assembly error on ia32 win32 (Fedor Indutny) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`3af28d3693`](https://github.com/nodejs/node/commit/3af28d3693)] - **deps**: copy all openssl header files to include dir (Shigeki Ohtsu) [#6550](https://github.com/nodejs/node/pull/6550)
* [[`e6ab3ece65`](https://github.com/nodejs/node/commit/e6ab3ece65)] - **deps**: upgrade openssl sources to 1.0.2h (Shigeki Ohtsu) [#6550](https://github.com/nodejs/node/pull/6550)
* [[`65b6574d59`](https://github.com/nodejs/node/commit/65b6574d59)] - **deps**: backport IsValid changes from 4e8736d in V8 (Michaël Zasso) [#6544](https://github.com/nodejs/node/pull/6544)
* [[`33f24c821b`](https://github.com/nodejs/node/commit/33f24c821b)] - **doc**: adds 'close' events to fs.ReadStream and fs.WriteStream (Jenna Vuong) [#6499](https://github.com/nodejs/node/pull/6499)
* [[`4f728df1bf`](https://github.com/nodejs/node/commit/4f728df1bf)] - **doc**: linkify remaining references to fs.Stats object (Kevin Donahue) [#6485](https://github.com/nodejs/node/pull/6485)
* [[`9a29b50c52`](https://github.com/nodejs/node/commit/9a29b50c52)] - **doc**: fix the lint of an example in cluster.md (yorkie) [#6516](https://github.com/nodejs/node/pull/6516)
* [[`d674493fa5`](https://github.com/nodejs/node/commit/d674493fa5)] - **doc**: add missing underscore for markdown italics (Kevin Donahue) [#6529](https://github.com/nodejs/node/pull/6529)
* [[`7c30f15e1b`](https://github.com/nodejs/node/commit/7c30f15e1b)] - **doc**: ensure consistent grammar in node.1 file (justshiv) [#6426](https://github.com/nodejs/node/pull/6426)
* [[`e5ce53a217`](https://github.com/nodejs/node/commit/e5ce53a217)] - **doc**: fix sentence fragment in fs doc (Rich Trott) [#6488](https://github.com/nodejs/node/pull/6488)
* [[`3e028a143c`](https://github.com/nodejs/node/commit/3e028a143c)] - **doc**: remove obsolete comment in isError() example (cjihrig) [#6486](https://github.com/nodejs/node/pull/6486)
* [[`969f96a019`](https://github.com/nodejs/node/commit/969f96a019)] - **doc**: fix a typo in `__dirname` section (William Luo) [#6473](https://github.com/nodejs/node/pull/6473)
* [[`ab7055b003`](https://github.com/nodejs/node/commit/ab7055b003)] - **doc**: fix fs.realpath man pg links (phette23) [#6451](https://github.com/nodejs/node/pull/6451)
* [[`13e660888f`](https://github.com/nodejs/node/commit/13e660888f)] - **doc**: extra clarification of historySize option (vsemozhetbyt) [#6397](https://github.com/nodejs/node/pull/6397)
* [[`3d5b732660`](https://github.com/nodejs/node/commit/3d5b732660)] - **doc**: clarifies http.serverResponse implementation (Allen Hernandez) [#6072](https://github.com/nodejs/node/pull/6072)
* [[`7034ebe2bc`](https://github.com/nodejs/node/commit/7034ebe2bc)] - **doc**: use `Node.js` in synopsis document (Rich Trott) [#6476](https://github.com/nodejs/node/pull/6476)
* [[`4ae39f9863`](https://github.com/nodejs/node/commit/4ae39f9863)] - **doc**: remove all scrollbar styling (Claudio Rodriguez) [#6479](https://github.com/nodejs/node/pull/6479)
* [[`e6c8da45b1`](https://github.com/nodejs/node/commit/e6c8da45b1)] - **(SEMVER-MINOR)** **doc**: make `writable.setDefaultEncoding()` return `this` (Alexander Makarenko) [#5040](https://github.com/nodejs/node/pull/5040)
* [[`4068d64f4f`](https://github.com/nodejs/node/commit/4068d64f4f)] - **doc**: fix EventEmitter#eventNames() example (Сковорода Никита Андреевич) [#6417](https://github.com/nodejs/node/pull/6417)
* [[`bfcde97251`](https://github.com/nodejs/node/commit/bfcde97251)] - **doc**: fix incorrect syntax in examples (Evan Lucas) [#6463](https://github.com/nodejs/node/pull/6463)
* [[`8eb87ee239`](https://github.com/nodejs/node/commit/8eb87ee239)] - **doc**: Remove extra space in REPL example (Juan) [#6447](https://github.com/nodejs/node/pull/6447)
* [[`fd37d54eb5`](https://github.com/nodejs/node/commit/fd37d54eb5)] - **doc**: added note warning about change to console.endTime() (Ben Page) [#6454](https://github.com/nodejs/node/pull/6454)
* [[`b3f75ec801`](https://github.com/nodejs/node/commit/b3f75ec801)] - **doc**: expand documentation for process.exit() (James M Snell) [#6410](https://github.com/nodejs/node/pull/6410)
* [[`fc0fbf1c63`](https://github.com/nodejs/node/commit/fc0fbf1c63)] - **doc**: subdivide TOC, add auxiliary links (Jeremiah Senkpiel) [#6167](https://github.com/nodejs/node/pull/6167)
* [[`150dd36503`](https://github.com/nodejs/node/commit/150dd36503)] - **doc**: no Node.js(1) (Jeremiah Senkpiel) [#6167](https://github.com/nodejs/node/pull/6167)
* [[`ab84d69048`](https://github.com/nodejs/node/commit/ab84d69048)] - **doc**: better example & synopsis (Jeremiah Senkpiel) [#6167](https://github.com/nodejs/node/pull/6167)
* [[`f6d72791a1`](https://github.com/nodejs/node/commit/f6d72791a1)] - **doc**: update build instructions for OS X (Rich Trott) [#6309](https://github.com/nodejs/node/pull/6309)
* [[`36207c6daf`](https://github.com/nodejs/node/commit/36207c6daf)] - **doc**: correctly document the behavior of ee.once(). (Lance Ball) [#6371](https://github.com/nodejs/node/pull/6371)
* [[`19fb1345ba`](https://github.com/nodejs/node/commit/19fb1345ba)] - **doc**: use Buffer.from() instead of new Buffer() (Jackson Tian) [#6367](https://github.com/nodejs/node/pull/6367)
* [[`fb6753c75c`](https://github.com/nodejs/node/commit/fb6753c75c)] - **doc**: fix v6 changelog (James M Snell) [#6435](https://github.com/nodejs/node/pull/6435)
* [[`2c92a1fe03`](https://github.com/nodejs/node/commit/2c92a1fe03)] - **events**: pass the original listener added by once (DavidCai) [#6394](https://github.com/nodejs/node/pull/6394)
* [[`9ea6b282e8`](https://github.com/nodejs/node/commit/9ea6b282e8)] - **meta**: split CHANGELOG into two files (Myles Borins) [#6337](https://github.com/nodejs/node/pull/6337)
* [[`cbbe95e1e1`](https://github.com/nodejs/node/commit/cbbe95e1e1)] - **(SEMVER-MINOR)** **net**: introduce `Socket#connecting` property (Fedor Indutny) [#6404](https://github.com/nodejs/node/pull/6404)
* [[`534f03c2f0`](https://github.com/nodejs/node/commit/534f03c2f0)] - **openssl**: fix keypress requirement in apps on win32 (Shigeki Ohtsu) [iojs/io.js#1389](https://github.com/iojs/io.js/pull/1389)
* [[`1b9fdba04e`](https://github.com/nodejs/node/commit/1b9fdba04e)] - **(SEMVER-MINOR)** **process**: add process.cpuUsage() - implementation, doc, tests (Patrick Mueller) [#6157](https://github.com/nodejs/node/pull/6157)
* [[`fa9d82d120`](https://github.com/nodejs/node/commit/fa9d82d120)] - **src**: unify implementations of Utf8Value etc. (Anna Henningsen) [#6357](https://github.com/nodejs/node/pull/6357)
* [[`65030c77b7`](https://github.com/nodejs/node/commit/65030c77b7)] - **test**: fix alpn tests for openssl1.0.2h (Shigeki Ohtsu) [#6550](https://github.com/nodejs/node/pull/6550)
* [[`7641f9a6de`](https://github.com/nodejs/node/commit/7641f9a6de)] - **test**: refactor large event emitter tests (cjihrig) [#6446](https://github.com/nodejs/node/pull/6446)
* [[`5fe5fa2897`](https://github.com/nodejs/node/commit/5fe5fa2897)] - **test**: make addon testing part of `make test` (Ben Noordhuis) [#6232](https://github.com/nodejs/node/pull/6232)
* [[`457d12a0a1`](https://github.com/nodejs/node/commit/457d12a0a1)] - **test**: add failing url parse tests as known_issue (James M Snell) [#5885](https://github.com/nodejs/node/pull/5885)
* [[`089362f8b8`](https://github.com/nodejs/node/commit/089362f8b8)] - **test,tools**: limit lint tolerance of gc global (Rich Trott) [#6324](https://github.com/nodejs/node/pull/6324)
* [[`6d1606ee94`](https://github.com/nodejs/node/commit/6d1606ee94)] - **test,tools**: adjust function argument alignment (Rich Trott) [#6390](https://github.com/nodejs/node/pull/6390)
* [[`08e0884ae0`](https://github.com/nodejs/node/commit/08e0884ae0)] - **tools**: add -F flag for fixing lint issues (Rich Trott) [#6483](https://github.com/nodejs/node/pull/6483)
* [[`9f23cb24f2`](https://github.com/nodejs/node/commit/9f23cb24f2)] - **tools**: fix exit code when linting from CI (Brian White) [#6412](https://github.com/nodejs/node/pull/6412)
* [[`e62c42b8f4`](https://github.com/nodejs/node/commit/e62c42b8f4)] - **tools**: remove default parameters from lint rule (Rich Trott) [#6411](https://github.com/nodejs/node/pull/6411)
* [[`66903f6695`](https://github.com/nodejs/node/commit/66903f6695)] - **tools**: add tests for the doctool (Ian Kronquist) [#6031](https://github.com/nodejs/node/pull/6031)
* [[`3f608b16a7`](https://github.com/nodejs/node/commit/3f608b16a7)] - **tools**: lint for function argument alignment (Rich Trott) [#6390](https://github.com/nodejs/node/pull/6390)
* [[`91ab769940`](https://github.com/nodejs/node/commit/91ab769940)] - **(SEMVER-MINOR)** **util**: truncate inspect array and typed array (James M Snell) [#6334](https://github.com/nodejs/node/pull/6334)
* [[`0bca959617`](https://github.com/nodejs/node/commit/0bca959617)] - **(SEMVER-MINOR)** **util**: fix inspecting of proxy objects (James M Snell) [#6465](https://github.com/nodejs/node/pull/6465)

<a id="6.0.0"></a>
## 2016-04-26, Version 6.0.0 (Current), @jasnell

### Notable changes

The following significant changes have been made since the previous Node.js
v5.0.0 release.

* Buffer
  * New Buffer constructors have been added
    [#4682](https://github.com/nodejs/node/pull/4682) and
    [#5833](https://github.com/nodejs/node/pull/5833).
  * Existing `Buffer()` and `SlowBuffer()` constructors have been deprecated
    in docs [#4682](https://github.com/nodejs/node/pull/4682) and
    [#5833](https://github.com/nodejs/node/pull/5833).
  * Previously deprecated Buffer APIs are removed
    [#5048](https://github.com/nodejs/node/pull/5048),
    [#4594](https://github.com/nodejs/node/pull/4594).
  * Improved error handling [#4514](https://github.com/nodejs/node/pull/4514).
  * The `Buffer.prototype.lastIndexOf()` method has been added
    [#4846](https://github.com/nodejs/node/pull/4846).
* Cluster
  * Worker emitted as first argument in 'message' event
    [#5361](https://github.com/nodejs/node/pull/5361).
  * The `worker.exitedAfterDisconnect` property replaces `worker.suicide`
    [#3743](https://github.com/nodejs/node/pull/3743).
* Console
  * Calling `console.timeEnd()` with an unknown label now emits a process
    warning rather than throwing
    [#5901](https://github.com/nodejs/node/pull/5901).
* Crypto
  * Improved error handling [#3100](https://github.com/nodejs/node/pull/3100),
    [#5611](https://github.com/nodejs/node/pull/5611).
  * Simplified Certificate class bindings
    [#5382](https://github.com/nodejs/node/pull/5382).
  * Improved control over FIPS mode
    [#5181](https://github.com/nodejs/node/pull/5181).
  * pbkdf2 digest overloading is deprecated
    [#4047](https://github.com/nodejs/node/pull/4047).
* Dependencies
  * Reintroduce shared c-ares build support
    [#5775](https://github.com/nodejs/node/pull/5775).
  * V8 updated to 5.0.71.35 [#6372](https://github.com/nodejs/node/pull/6372).
* DNS
  * Add `dns.resolvePtr()` API to query plain DNS PTR records
    [#4921](https://github.com/nodejs/node/pull/4921).
* Domains
  * Clear stack when no error handler
  [#4659](https://github.com/nodejs/node/pull/4659).
* Events
  * The `EventEmitter.prototype._events` object no longer inherits from
    Object.prototype [#6092](https://github.com/nodejs/node/pull/6092).
  * The `EventEmitter.prototype.prependListener()` and
    `EventEmitter.prototype.prependOnceListener()` methods have been added
    [#6032](https://github.com/nodejs/node/pull/6032).
* File System
  * The `fs.realpath()` and `fs.realpathSync()` methods have been updated
    to use a more efficient libuv-based implementation. This change includes
    the removal of the `cache` argument and the method can throw new errors
    [#3594](https://github.com/nodejs/node/pull/3594).
  * FS apis can now accept and return paths as Buffers
    [#5616](https://github.com/nodejs/node/pull/5616).
  * Error handling and type checking improvements
    [#5616](https://github.com/nodejs/node/pull/5616),
    [#5590](https://github.com/nodejs/node/pull/5590),
    [#4518](https://github.com/nodejs/node/pull/4518),
    [#3917](https://github.com/nodejs/node/pull/3917).
  * fs.read's string interface is deprecated
    [#4525](https://github.com/nodejs/node/pull/4525).
* HTTP
  * 'clientError' can now be used to return custom errors from an
    HTTP server [#4557](https://github.com/nodejs/node/pull/4557).
* Modules
  * Current directory is now prioritized for local lookups
    [#5689](https://github.com/nodejs/node/pull/5689).
  * Symbolic links are preserved when requiring modules
    [#5950](https://github.com/nodejs/node/pull/5950).
* Net
  * DNS hints no longer implicitly set
    [#6021](https://github.com/nodejs/node/pull/6021).
  * Improved error handling and type checking
    [#5981](https://github.com/nodejs/node/pull/5981),
    [#5733](https://github.com/nodejs/node/pull/5733),
    [#2904](https://github.com/nodejs/node/pull/2904).
* npm
  * Running npm requires the node binary to be in the path
    [#6098](https://github.com/nodejs/node/pull/6098).
* OS X
  * MACOSX_DEPLOYMENT_TARGET has been bumped up to 10.7
    [#6402](https://github.com/nodejs/node/pull/6402).
* Path
  * Improved type checking [#5348](https://github.com/nodejs/node/pull/5348).
* Process
  * Introduce process warnings API
    [#4782](https://github.com/nodejs/node/pull/4782).
  * Throw exception when non-function passed to nextTick
    [#3860](https://github.com/nodejs/node/pull/3860).
* Querystring
  * The object returned by `querystring.parse()` no longer inherits from
    Object.prototype [#6055](https://github.com/nodejs/node/pull/6055).
* Readline
  * Key info is emitted unconditionally
    [#6024](https://github.com/nodejs/node/pull/6024).
  * History can now be explicitly disabled
    [#6352](https://github.com/nodejs/node/pull/6352).
* REPL
  * Assignment to `_` will emit a warning
    [#5535](https://github.com/nodejs/node/pull/5535).
  * Expressions will no longer be completed when eval fails
    [#6328](https://github.com/nodejs/node/pull/6328).
* Timers
  * Fail early when callback is not a function
    [#4362](https://github.com/nodejs/node/pull/4362).
* Streams
  * `null` is now an invalid chunk to write in object mode
    [#6170](https://github.com/nodejs/node/pull/6170).
* TLS
  * Rename 'clientError' to 'tlsClientError'
    [#4557](https://github.com/nodejs/node/pull/4557).
  * SHA1 used for sessionIdContext
    [#3866](https://github.com/nodejs/node/pull/3866).
* TTY
  * Previously deprecated setRawMode wrapper is removed
    [#2528](https://github.com/nodejs/node/pull/2528).
* URL
  * Username and password will be dropped by `url.resolve()` if the host
    changes [#1480](https://github.com/nodejs/node/pull/1480).
* Util
  * Changes to Error object formatting
    [#4582](https://github.com/nodejs/node/pull/4582).
  * The `util._extend()` method has been deprecated
    [#4903](https://github.com/nodejs/node/pull/4903)
  * The `util.log()` method has been deprecated
    [#6161](https://github.com/nodejs/node/pull/6161).
* Windows
  * Windows XP and Vista are no longer supported
    [#5167](https://github.com/nodejs/node/pull/5167).
* Zlib
  * Multiple improvements have been made to Zlib processing
    [#5883](https://github.com/nodejs/node/pull/5883) and
    [#5707](https://github.com/nodejs/node/pull/5707).


### Commits

Semver-major Changes since v5.0.0

* [[`829d613daa`](https://github.com/nodejs/node/commit/829d613daa)] - **(SEMVER-MAJOR)** **buffer**: docs-only deprecate SlowBuffer (James M Snell) [#5833](https://github.com/nodejs/node/pull/5833)
* [[`d0c6e6f7c4`](https://github.com/nodejs/node/commit/d0c6e6f7c4)] - **(SEMVER-MAJOR)** **buffer**: add Buffer.allocUnsafeSlow(size) (James M Snell) [#5833](https://github.com/nodejs/node/pull/5833)
* [[`85ab4a5f12`](https://github.com/nodejs/node/commit/85ab4a5f12)] - **(SEMVER-MAJOR)** **buffer**: add .from(), .alloc() and .allocUnsafe() (James M Snell) [#4682](https://github.com/nodejs/node/pull/4682)
* [[`2c55cc2d2c`](https://github.com/nodejs/node/commit/2c55cc2d2c)] - **(SEMVER-MAJOR)** **buffer**: remove deprecated Buffer.write branch (dcposch@dcpos.ch) [#5048](https://github.com/nodejs/node/pull/5048)
* [[`101bca988c`](https://github.com/nodejs/node/commit/101bca988c)] - **(SEMVER-MAJOR)** **buffer**: remove deprecated buffer.get/.set methods (Feross Aboukhadijeh) [#4594](https://github.com/nodejs/node/pull/4594)
* [[`3b27dd5ce1`](https://github.com/nodejs/node/commit/3b27dd5ce1)] - **(SEMVER-MAJOR)** **buffer**: throw if both length and enc are passed (Mathias Buus) [#4514](https://github.com/nodejs/node/pull/4514)
* [[`ce864ef502`](https://github.com/nodejs/node/commit/ce864ef502)] - **(SEMVER-MAJOR)** **build**: Bump MACOSX_DEPLOYMENT_TARGET to 10.7 (Сковорода Никита Андреевич) [#6402](https://github.com/nodejs/node/pull/6402)
* [[`90a5fc20be`](https://github.com/nodejs/node/commit/90a5fc20be)] - **(SEMVER-MAJOR)** **build**: remove lint/dotfiles from release tarball (Johan Bergström) [#5695](https://github.com/nodejs/node/pull/5695)
* [[`66f048af6f`](https://github.com/nodejs/node/commit/66f048af6f)] - **(SEMVER-MAJOR)** **cluster**: migrate from worker.suicide (Evan Lucas) [#3743](https://github.com/nodejs/node/pull/3743)
* [[`66f4586dd0`](https://github.com/nodejs/node/commit/66f4586dd0)] - **(SEMVER-MAJOR)** **cluster**: emit worker as first 'message' event arg (Ben Noordhuis) [#5361](https://github.com/nodejs/node/pull/5361)
* [[`30507951d9`](https://github.com/nodejs/node/commit/30507951d9)] - **(SEMVER-MAJOR)** **console**: timeEnd() with no label emits warning (Eugene Obrezkov) [#5901](https://github.com/nodejs/node/pull/5901)
* [[`a5cce79ec3`](https://github.com/nodejs/node/commit/a5cce79ec3)] - **(SEMVER-MAJOR)** **console**: delete timers that have ended (Vladimir Varankin) [#3562](https://github.com/nodejs/node/pull/3562)
* [[`47cca06412`](https://github.com/nodejs/node/commit/47cca06412)] - **(SEMVER-MAJOR)** **crypto**: better error message for createHash (Calvin Metcalf) [#6042](https://github.com/nodejs/node/pull/6042)
* [[`41feaa89e0`](https://github.com/nodejs/node/commit/41feaa89e0)] - **(SEMVER-MAJOR)** **crypto**: improve error messages (Sakthipriyan Vairamani) [#3100](https://github.com/nodejs/node/pull/3100)
* [[`f429fe1b88`](https://github.com/nodejs/node/commit/f429fe1b88)] - **(SEMVER-MAJOR)** **crypto**: fail early when loading crypto without openssl (James M Snell) [#5611](https://github.com/nodejs/node/pull/5611)
* [[`a37401e061`](https://github.com/nodejs/node/commit/a37401e061)] - **(SEMVER-MAJOR)** **crypto**: simplify Certificate class bindings (Alexander Makarenko) [#5382](https://github.com/nodejs/node/pull/5382)
* [[`7c48cb5601`](https://github.com/nodejs/node/commit/7c48cb5601)] - **(SEMVER-MAJOR)** **crypto**: Improve control of FIPS mode (Stefan Budeanu) [#5181](https://github.com/nodejs/node/pull/5181)
* [[`a1163582c5`](https://github.com/nodejs/node/commit/a1163582c5)] - **(SEMVER-MAJOR)** **crypto**: pbkdf2 deprecate digest overload. (Tom Gallacher) [#4047](https://github.com/nodejs/node/pull/4047)
* [[`b010c87164`](https://github.com/nodejs/node/commit/b010c87164)] - **(SEMVER-MAJOR)** **crypto, string_bytes**: treat `buffer` str as `utf8` (Fedor Indutny) [#5522](https://github.com/nodejs/node/pull/5522)
* [[`a42453b085`](https://github.com/nodejs/node/commit/a42453b085)] - **(SEMVER-MAJOR)** **deps**: upgrade V8 to 5.0.71.32 (Ali Ijaz Sheikh) [#6111](https://github.com/nodejs/node/pull/6111)
* [[`2253be95d0`](https://github.com/nodejs/node/commit/2253be95d0)] - **(SEMVER-MAJOR)** **deps**: reintroduce supporting shared c-ares builds (Johan Bergström) [#5775](https://github.com/nodejs/node/pull/5775)
* [[`4bc1cccb22`](https://github.com/nodejs/node/commit/4bc1cccb22)] - **(SEMVER-MAJOR)** **dgram**: pass null as error on successful send() (cjihrig) [#5929](https://github.com/nodejs/node/pull/5929)
* [[`dbdbdd4998`](https://github.com/nodejs/node/commit/dbdbdd4998)] - **(SEMVER-MAJOR)** **dns**: add resolvePtr to query plain DNS PTR records (Daniel Turing) [#4921](https://github.com/nodejs/node/pull/4921)
* [[`c4ab861a49`](https://github.com/nodejs/node/commit/c4ab861a49)] - **(SEMVER-MAJOR)** **dns**: add failure test for dns.resolveXXX (Daniel Turing) [#4921](https://github.com/nodejs/node/pull/4921)
* [[`f3be421c1c`](https://github.com/nodejs/node/commit/f3be421c1c)] - **(SEMVER-MAJOR)** **dns**: coerce port to number in lookupService (Evan Lucas) [#4883](https://github.com/nodejs/node/pull/4883)
* [[`fa74805bac`](https://github.com/nodejs/node/commit/fa74805bac)] - **(SEMVER-MAJOR)** **doc**: doc-only deprecation for util.log() (Jackson Tian) [#6161](https://github.com/nodejs/node/pull/6161)
* [[`34b1a64068`](https://github.com/nodejs/node/commit/34b1a64068)] - **(SEMVER-MAJOR)** **doc**: minor copy improvement in buffer.markdown (James M Snell) [#5833](https://github.com/nodejs/node/pull/5833)
* [[`4d4f3535a9`](https://github.com/nodejs/node/commit/4d4f3535a9)] - **(SEMVER-MAJOR)** **doc**: general improvements to fs.markdown (James M Snell) [#5616](https://github.com/nodejs/node/pull/5616)
* [[`d8290286b3`](https://github.com/nodejs/node/commit/d8290286b3)] - **(SEMVER-MAJOR)** **doc**: document deprecation of util._extend (Benjamin Gruenbaum) [#4903](https://github.com/nodejs/node/pull/4903)
* [[`3abf9d5df5`](https://github.com/nodejs/node/commit/3abf9d5df5)] - **(SEMVER-MAJOR)** **doc, tls**: deprecate createSecurePair (Yuval Brik) [#6063](https://github.com/nodejs/node/pull/6063)
* [[`90204cc468`](https://github.com/nodejs/node/commit/90204cc468)] - **(SEMVER-MAJOR)** **domains**: clear stack when no error handler (Julien Gilli) [#4659](https://github.com/nodejs/node/pull/4659)
* [[`c3ad97d3cc`](https://github.com/nodejs/node/commit/c3ad97d3cc)] - **(SEMVER-MAJOR)** **events**: don't inherit from Object.prototype (Brian White) [#6092](https://github.com/nodejs/node/pull/6092)
* [[`a2492f989f`](https://github.com/nodejs/node/commit/a2492f989f)] - **(SEMVER-MAJOR)** **fs**: optimize realpath using uv_fs_realpath() (Yuval Brik) [#3594](https://github.com/nodejs/node/pull/3594)
* [[`53a95a5b12`](https://github.com/nodejs/node/commit/53a95a5b12)] - **(SEMVER-MAJOR)** **fs**: make fs.watch error message more useful (James M Snell) [#5616](https://github.com/nodejs/node/pull/5616)
* [[`060e5f0c00`](https://github.com/nodejs/node/commit/060e5f0c00)] - **(SEMVER-MAJOR)** **fs**: Buffer and encoding enhancements to fs API (James M Snell) [#5616](https://github.com/nodejs/node/pull/5616)
* [[`8bb60e3c8d`](https://github.com/nodejs/node/commit/8bb60e3c8d)] - **(SEMVER-MAJOR)** **fs**: improve error message for invalid flag (James M Snell) [#5590](https://github.com/nodejs/node/pull/5590)
* [[`1124de2d76`](https://github.com/nodejs/node/commit/1124de2d76)] - **(SEMVER-MAJOR)** **fs**: deprecate fs.read's string interface (Sakthipriyan Vairamani) [#4525](https://github.com/nodejs/node/pull/4525)
* [[`2b15e68bbe`](https://github.com/nodejs/node/commit/2b15e68bbe)] - **(SEMVER-MAJOR)** **fs**: fs.read into zero buffer should not throw exception (Feross Aboukhadijeh) [#4518](https://github.com/nodejs/node/pull/4518)
* [[`8b97249893`](https://github.com/nodejs/node/commit/8b97249893)] - **(SEMVER-MAJOR)** **fs**: fix the error report on fs.link(Sync) (yorkie) [#3917](https://github.com/nodejs/node/pull/3917)
* [[`5f76b24e5e`](https://github.com/nodejs/node/commit/5f76b24e5e)] - **(SEMVER-MAJOR)** **http**: overridable `clientError` (Fedor Indutny) [#4557](https://github.com/nodejs/node/pull/4557)
* [[`d01eb6882f`](https://github.com/nodejs/node/commit/d01eb6882f)] - **(SEMVER-MAJOR)** **lib**: add 'pid' prefix in `internal/util` (Minwoo Jung) [#3878](https://github.com/nodejs/node/pull/3878)
* [[`20285ad177`](https://github.com/nodejs/node/commit/20285ad177)] - **(SEMVER-MAJOR)** **lib**: Consistent error messages in all modules (micnic) [#3374](https://github.com/nodejs/node/pull/3374)
* [[`94b9948d63`](https://github.com/nodejs/node/commit/94b9948d63)] - **(SEMVER-MAJOR)** **lib,src**: ensure '(node:pid)' prefix for stdout logging (Minwoo Jung) [#3833](https://github.com/nodejs/node/pull/3833)
* [[`b70dc67828`](https://github.com/nodejs/node/commit/b70dc67828)] - **(SEMVER-MAJOR)** **lib,test**: remove publicly exposed freelist (cjihrig) [#3738](https://github.com/nodejs/node/pull/3738)
* [[`c43b182b11`](https://github.com/nodejs/node/commit/c43b182b11)] - **(SEMVER-MAJOR)** **module**: preserve symlinks when requiring (Alex Lamar) [#5950](https://github.com/nodejs/node/pull/5950)
* [[`d38503ab01`](https://github.com/nodejs/node/commit/d38503ab01)] - **(SEMVER-MAJOR)** **module**: prioritize current dir for local lookups (Phillip Johnsen) [#5689](https://github.com/nodejs/node/pull/5689)
* [[`71470a8e45`](https://github.com/nodejs/node/commit/71470a8e45)] - **(SEMVER-MAJOR)** **module**: pass v8::Object to linked module initialization function (Phillip Kovalev) [#4771](https://github.com/nodejs/node/pull/4771)
* [[`18490d3d5a`](https://github.com/nodejs/node/commit/18490d3d5a)] - **(SEMVER-MAJOR)** **module**: always decorate thrown errors (Brian White) [#4287](https://github.com/nodejs/node/pull/4287)
* [[`c32c889c45`](https://github.com/nodejs/node/commit/c32c889c45)] - **(SEMVER-MAJOR)** **net**: Validate port in createServer().listen() (Dirceu Pereira Tiegs) [#5732](https://github.com/nodejs/node/pull/5732)
* [[`b85a50b6da`](https://github.com/nodejs/node/commit/b85a50b6da)] - **(SEMVER-MAJOR)** **net**: remove implicit setting of DNS hints (cjihrig) [#6021](https://github.com/nodejs/node/pull/6021)
* [[`ec49fc8229`](https://github.com/nodejs/node/commit/ec49fc8229)] - **(SEMVER-MAJOR)** **net**: improve socket.write() error message (Phillip Johnsen) [#5981](https://github.com/nodejs/node/pull/5981)
* [[`d0edabecbf`](https://github.com/nodejs/node/commit/d0edabecbf)] - **(SEMVER-MAJOR)** **net**: strict checking for internal/net isLegalPort (James M Snell) [#5733](https://github.com/nodejs/node/pull/5733)
* [[`a78b3344f8`](https://github.com/nodejs/node/commit/a78b3344f8)] - **(SEMVER-MAJOR)** **net**: type check createServer options object (Sam Roberts) [#2904](https://github.com/nodejs/node/pull/2904)
* [[`25751bedfe`](https://github.com/nodejs/node/commit/25751bedfe)] - **(SEMVER-MAJOR)** **node**: deprecate process.EventEmitter (Evan Lucas) [#5049](https://github.com/nodejs/node/pull/5049)
* [[`08085c49b6`](https://github.com/nodejs/node/commit/08085c49b6)] - **(SEMVER-MAJOR)** **path**: assert inputs are strings (Brian White) [#5348](https://github.com/nodejs/node/pull/5348)
* [[`d1000b4137`](https://github.com/nodejs/node/commit/d1000b4137)] - **(SEMVER-MAJOR)** **path**: make format() consistent and more functional (Nathan Woltman) [#2408](https://github.com/nodejs/node/pull/2408)
* [[`c6656db352`](https://github.com/nodejs/node/commit/c6656db352)] - **(SEMVER-MAJOR)** **process**: add 'warning' event and process.emitWarning() (James M Snell) [#4782](https://github.com/nodejs/node/pull/4782)
* [[`72e3dd9f43`](https://github.com/nodejs/node/commit/72e3dd9f43)] - **(SEMVER-MAJOR)** **process**: throw on non-function to nextTick() (yorkie) [#3860](https://github.com/nodejs/node/pull/3860)
* [[`33c286154b`](https://github.com/nodejs/node/commit/33c286154b)] - **(SEMVER-MAJOR)** **querystring**: don't inherit from Object.prototype (Brian White) [#6055](https://github.com/nodejs/node/pull/6055)
* [[`5c8b5971eb`](https://github.com/nodejs/node/commit/5c8b5971eb)] - **(SEMVER-MAJOR)** **querystring**: using toString for objects on querystring.escape (Igor Kalashnikov) [#5341](https://github.com/nodejs/node/pull/5341)
* [[`9c6ef5b3e1`](https://github.com/nodejs/node/commit/9c6ef5b3e1)] - **(SEMVER-MAJOR)** **readline**: allow history to be disabled (surya panikkal) [#6352](https://github.com/nodejs/node/pull/6352)
* [[`0a62f929da`](https://github.com/nodejs/node/commit/0a62f929da)] - **(SEMVER-MAJOR)** **readline**: emit key info unconditionally (cjihrig) [#6024](https://github.com/nodejs/node/pull/6024)
* [[`3de9bc9429`](https://github.com/nodejs/node/commit/3de9bc9429)] - **(SEMVER-MAJOR)** **readline**: document emitKeypressEvents() (cjihrig) [#6024](https://github.com/nodejs/node/pull/6024)
* [[`ca2e8b292f`](https://github.com/nodejs/node/commit/ca2e8b292f)] - **(SEMVER-MAJOR)** **readline**: deprecate undocumented exports (cjihrig) [#3862](https://github.com/nodejs/node/pull/3862)
* [[`bd2cee1b10`](https://github.com/nodejs/node/commit/bd2cee1b10)] - **(SEMVER-MAJOR)** **repl**: don’t complete expressions when eval fails (Anna Henningsen) [#6328](https://github.com/nodejs/node/pull/6328)
* [[`ad8257fa5b`](https://github.com/nodejs/node/commit/ad8257fa5b)] - **(SEMVER-MAJOR)** **repl**: Assignment of _ allowed with warning (Lance Ball) [#5535](https://github.com/nodejs/node/pull/5535)
* [[`757fbac64b`](https://github.com/nodejs/node/commit/757fbac64b)] - **(SEMVER-MAJOR)** **src**: remove deprecated internal functions (Ben Noordhuis) [#6053](https://github.com/nodejs/node/pull/6053)
* [[`57003520f8`](https://github.com/nodejs/node/commit/57003520f8)] - **(SEMVER-MAJOR)** **src**: attach error to stack on displayErrors (cjihrig) [#4874](https://github.com/nodejs/node/pull/4874)
* [[`4e46931406`](https://github.com/nodejs/node/commit/4e46931406)] - **(SEMVER-MAJOR)** **src**: deprecate undocumented variables (Jackson Tian) [#1838](https://github.com/nodejs/node/pull/1838)
* [[`c0abecdaf3`](https://github.com/nodejs/node/commit/c0abecdaf3)] - **(SEMVER-MAJOR)** **stream**: make null an invalid chunk to write in object mode (Calvin Metcalf) [#6170](https://github.com/nodejs/node/pull/6170)
* [[`652782d137`](https://github.com/nodejs/node/commit/652782d137)] - **(SEMVER-MAJOR)** **test**: update test-repl-require for local paths (Myles Borins) [#5689](https://github.com/nodejs/node/pull/5689)
* [[`a5aa7c1713`](https://github.com/nodejs/node/commit/a5aa7c1713)] - **(SEMVER-MAJOR)** **test**: expand test case for unknown file open flags (James M Snell) [#5590](https://github.com/nodejs/node/pull/5590)
* [[`2c33819370`](https://github.com/nodejs/node/commit/2c33819370)] - **(SEMVER-MAJOR)** **test**: fix tests that check error messages (cjihrig) [#3727](https://github.com/nodejs/node/pull/3727)
* [[`ac153bd2a6`](https://github.com/nodejs/node/commit/ac153bd2a6)] - **(SEMVER-MAJOR)** **timers**: fail early when callback is not a function (Anna Henningsen) [#4362](https://github.com/nodejs/node/pull/4362)
* [[`1ab6b21360`](https://github.com/nodejs/node/commit/1ab6b21360)] - **(SEMVER-MAJOR)** **tls**: rename `clientError` to `tlsClientError` (Fedor Indutny) [#4557](https://github.com/nodejs/node/pull/4557)
* [[`df268f97bc`](https://github.com/nodejs/node/commit/df268f97bc)] - **(SEMVER-MAJOR)** **tls**: use SHA1 for sessionIdContext (Stefan Budeanu) [#3866](https://github.com/nodejs/node/pull/3866)
* [[`102a77655a`](https://github.com/nodejs/node/commit/102a77655a)] - **(SEMVER-MAJOR)** **tools**: do not rewrite npm shebang in install.py (Evan Lucas) [#6098](https://github.com/nodejs/node/pull/6098)
* [[`a2c0aa84e0`](https://github.com/nodejs/node/commit/a2c0aa84e0)] - **(SEMVER-MAJOR)** **tty**: Remove deprecated setRawMode wrapper (Wyatt Preul) [#2528](https://github.com/nodejs/node/pull/2528)
* [[`1b50b80e06`](https://github.com/nodejs/node/commit/1b50b80e06)] - **(SEMVER-MAJOR)** **url**: drop auth in `url.resolve()` if host changes (Alex Kocharin) [#1480](https://github.com/nodejs/node/pull/1480)
* [[`e2f47f5698`](https://github.com/nodejs/node/commit/e2f47f5698)] - **(SEMVER-MAJOR)** **util**: Change how Error objects are formatted (Mudit Ameta) [#4582](https://github.com/nodejs/node/pull/4582)
* [[`93d6b5fb68`](https://github.com/nodejs/node/commit/93d6b5fb68)] - **(SEMVER-MAJOR)** **util**: use consistent Dates in inspect() (Xotic750) [#4318](https://github.com/nodejs/node/pull/4318)
* [[`24012a879d`](https://github.com/nodejs/node/commit/24012a879d)] - **(SEMVER-MAJOR)** **util**: make inspect more reliable (Evan Lucas) [#4098](https://github.com/nodejs/node/pull/4098)
* [[`007cfea308`](https://github.com/nodejs/node/commit/007cfea308)] - **(SEMVER-MAJOR)** **util**: remove pump (Wyatt Preul) [#2531](https://github.com/nodejs/node/pull/2531)
* [[`4cf19ad1bb`](https://github.com/nodejs/node/commit/4cf19ad1bb)] - **(SEMVER-MAJOR)** **util**: Remove exec, has been deprecated for years (Wyatt Preul) [#2530](https://github.com/nodejs/node/pull/2530)
* [[`34a35919e1`](https://github.com/nodejs/node/commit/34a35919e1)] - **(SEMVER-MAJOR)** **util**: improve typed array formatting (Ben Noordhuis) [#3793](https://github.com/nodejs/node/pull/3793)
* [[`1cf26c036d`](https://github.com/nodejs/node/commit/1cf26c036d)] - **(SEMVER-MAJOR)** **win**: prevent node from running on Windows Vista or earlier (Alexis Campailla) [#5167](https://github.com/nodejs/node/pull/5167)
* [[`55db19074d`](https://github.com/nodejs/node/commit/55db19074d)] - **(SEMVER-MAJOR)** **win,msi**: prevent from installing on Windows Vista or earlier (Alexis Campailla) [#5167](https://github.com/nodejs/node/pull/5167)
* [[`54a5287e3e`](https://github.com/nodejs/node/commit/54a5287e3e)] - **(SEMVER-MAJOR)** **zlib**: fix gzip member head/buffer boundary issue (Anna Henningsen) [#5883](https://github.com/nodejs/node/pull/5883)
* [[`8b43d3f52d`](https://github.com/nodejs/node/commit/8b43d3f52d)] - **(SEMVER-MAJOR)** **zlib**: do not emit event on *Sync() methods (Rich Trott) [#5707](https://github.com/nodejs/node/pull/5707)


Semver-minor and patch commits since v5.11.0

* [[`7d4f652ced`](https://github.com/nodejs/node/commit/7d4f652ced)] - **benchmarks**: fix lint error (Myles Borins) [#6314](https://github.com/nodejs/node/pull/6314)
* [[`451f4fc88e`](https://github.com/nodejs/node/commit/451f4fc88e)] - **benchmarks**: add microbenchmarks for new ES6 features (James M Snell) [#6222](https://github.com/nodejs/node/pull/6222)
* [[`962c1e1cac`](https://github.com/nodejs/node/commit/962c1e1cac)] - **benchmarks**: add common.v8ForceOptimization (James M Snell) [#6222](https://github.com/nodejs/node/pull/6222)
* [[`d866438ce1`](https://github.com/nodejs/node/commit/d866438ce1)] - **buffer**: safeguard against accidental kNoZeroFill (Сковорода Никита Андреевич) [nodejs/node-private#30](https://github.com/nodejs/node-private/pull/30)
* [[`3350b4712b`](https://github.com/nodejs/node/commit/3350b4712b)] - **(SEMVER-MINOR)** **buffer**: add Buffer.prototype.lastIndexOf() (dcposch@dcpos.ch) [#4846](https://github.com/nodejs/node/pull/4846)
* [[`afd821a91d`](https://github.com/nodejs/node/commit/afd821a91d)] - **buffer**: faster case for create buffer from empty string (Jackson Tian) [#4414](https://github.com/nodejs/node/pull/4414)
* [[`73fc440870`](https://github.com/nodejs/node/commit/73fc440870)] - **buffer**: fix buffer alignment restriction (Ali Ijaz Sheikh) [#5752](https://github.com/nodejs/node/pull/5752)
* [[`206a81fb14`](https://github.com/nodejs/node/commit/206a81fb14)] - **buffer**: avoid undefined behaviour (Ali Ijaz Sheikh) [#5494](https://github.com/nodejs/node/pull/5494)
* [[`ebbbc5a790`](https://github.com/nodejs/node/commit/ebbbc5a790)] - **buffer**: replace deprecated SetWeak usage (Ali Ijaz Sheikh) [#5204](https://github.com/nodejs/node/pull/5204)
* [[`34aac23d0b`](https://github.com/nodejs/node/commit/34aac23d0b)] - **buffer**: cleanup CallbackInfo (Ali Ijaz Sheikh) [#5204](https://github.com/nodejs/node/pull/5204)
* [[`d7259280ee`](https://github.com/nodejs/node/commit/d7259280ee)] - **build**: update android-configure script for npm (Robert Chiras) [#6349](https://github.com/nodejs/node/pull/6349)
* [[`8cf94006c9`](https://github.com/nodejs/node/commit/8cf94006c9)] - **build**: do not ignore errors during build-addons (Ali Ijaz Sheikh) [#5494](https://github.com/nodejs/node/pull/5494)
* [[`704b68aeb9`](https://github.com/nodejs/node/commit/704b68aeb9)] - **cares**: Support malloc(0) scenarios for AIX (Gireesh Punathil) [#6305](https://github.com/nodejs/node/pull/6305)
* [[`77e2efec8c`](https://github.com/nodejs/node/commit/77e2efec8c)] - **console**: refactor to use rest params and template strings (James M Snell) [#6233](https://github.com/nodejs/node/pull/6233)
* [[`a53b2ac4b1`](https://github.com/nodejs/node/commit/a53b2ac4b1)] - **contextify**: tie lifetimes of context & sandbox (Ali Ijaz Sheikh) [#5786](https://github.com/nodejs/node/pull/5786)
* [[`d6237aa7c6`](https://github.com/nodejs/node/commit/d6237aa7c6)] - **(SEMVER-MINOR)** **crypto**: Read OpenSSL config before init (Stefan Budeanu) [#6374](https://github.com/nodejs/node/pull/6374)
* [[`c1729b0c38`](https://github.com/nodejs/node/commit/c1729b0c38)] - **deps**: upgrade to V8 5.0.71.35 (Ali Ijaz Sheikh) [#6372](https://github.com/nodejs/node/pull/6372)
* [[`7337693c33`](https://github.com/nodejs/node/commit/7337693c33)] - **deps**: upgrade to V8 5.0.71.34 (Ali Ijaz Sheikh) [#6320](https://github.com/nodejs/node/pull/6320)
* [[`809ed52147`](https://github.com/nodejs/node/commit/809ed52147)] - **deps**: upgrade to V8 5.0.71.33 (Ali Ijaz Sheikh) [#6290](https://github.com/nodejs/node/pull/6290)
* [[`19867cedfe`](https://github.com/nodejs/node/commit/19867cedfe)] - **deps**: exclude tests on ppc for v8 5.0 (Michael Dawson) [#6267](https://github.com/nodejs/node/pull/6267)
* [[`450418286a`](https://github.com/nodejs/node/commit/450418286a)] - **deps**: cherry-pick 1ef7487b from v8 upstream (Michael Dawson) [#6218](https://github.com/nodejs/node/pull/6218)
* [[`c3cec1eefc`](https://github.com/nodejs/node/commit/c3cec1eefc)] - **deps**: upgrade libuv to 1.9.0 (Saúl Ibarra Corretgé) [#5994](https://github.com/nodejs/node/pull/5994)
* [[`3a8e8230ee`](https://github.com/nodejs/node/commit/3a8e8230ee)] - **deps**: upgrade to V8 4.9.385.35 (Ben Noordhuis) [#6077](https://github.com/nodejs/node/pull/6077)
* [[`f8e8075a62`](https://github.com/nodejs/node/commit/f8e8075a62)] - **deps**: upgrade to V8 4.9.385.27 (Ali Ijaz Sheikh) [#5494](https://github.com/nodejs/node/pull/5494)
* [[`079973b96a`](https://github.com/nodejs/node/commit/079973b96a)] - **deps**: add V8 DEP trace_event (Ali Ijaz Sheikh) [#4722](https://github.com/nodejs/node/pull/4722)
* [[`89f234300a`](https://github.com/nodejs/node/commit/89f234300a)] - **deps**: edit v8 gitignore to allow trace_event copy (Ali Ijaz Sheikh) [#4722](https://github.com/nodejs/node/pull/4722)
* [[`069e02ab47`](https://github.com/nodejs/node/commit/069e02ab47)] - **deps**: upgrade to V8 4.9.385.18 (Ali Ijaz Sheikh) [#4722](https://github.com/nodejs/node/pull/4722)
* [[`674e5131ed`](https://github.com/nodejs/node/commit/674e5131ed)] - **deps**: backport bc2e393 from v8 upstream (evan.lucas) [#4106](https://github.com/nodejs/node/pull/4106)
* [[`113d1f3821`](https://github.com/nodejs/node/commit/113d1f3821)] - **deps**: cherry-pick 68e89fb from v8's upstream (Fedor Indutny) [#4106](https://github.com/nodejs/node/pull/4106)
* [[`ef4170ea03`](https://github.com/nodejs/node/commit/ef4170ea03)] - **deps**: upgrade to V8 4.8.271.17 (Ali Ijaz Sheikh) [#4785](https://github.com/nodejs/node/pull/4785)
* [[`384b20362c`](https://github.com/nodejs/node/commit/384b20362c)] - **deps**: upgrade to V8 4.7.80.32 (Ali Ijaz Sheikh) [#4699](https://github.com/nodejs/node/pull/4699)
* [[`36ac3d642e`](https://github.com/nodejs/node/commit/36ac3d642e)] - **deps**: backport 8d6a228 from the v8's upstream (Fedor Indutny) [#4259](https://github.com/nodejs/node/pull/4259)
* [[`e2dec98837`](https://github.com/nodejs/node/commit/e2dec98837)] - **deps**: upgrade to V8 4.7.80.25 (Ali Ijaz Sheikh) [#4160](https://github.com/nodejs/node/pull/4160)
* [[`1e324d883e`](https://github.com/nodejs/node/commit/1e324d883e)] - **deps**: backport bc2e393 from v8 upstream (evan.lucas) [#4106](https://github.com/nodejs/node/pull/4106)
* [[`d9d050d396`](https://github.com/nodejs/node/commit/d9d050d396)] - **deps**: cherry-pick 68e89fb from v8's upstream (Fedor Indutny) [#4106](https://github.com/nodejs/node/pull/4106)
* [[`edfc8cde04`](https://github.com/nodejs/node/commit/edfc8cde04)] - **deps**: backport 1ee712a from V8 upstream (Julien Gilli) [#4106](https://github.com/nodejs/node/pull/4106)
* [[`8a43a3d761`](https://github.com/nodejs/node/commit/8a43a3d761)] - **deps**: upgrade V8 to 4.7.80.24 (Ali Ijaz Sheikh) [#4106](https://github.com/nodejs/node/pull/4106)
* [[`61be0004a6`](https://github.com/nodejs/node/commit/61be0004a6)] - **doc**: fix position of `fs.readSync()` (Jeremiah Senkpiel) [#6399](https://github.com/nodejs/node/pull/6399)
* [[`27ce7fe953`](https://github.com/nodejs/node/commit/27ce7fe953)] - **doc**: change references to Stable to Current (Myles Borins) [#6318](https://github.com/nodejs/node/pull/6318)
* [[`547a6fecb9`](https://github.com/nodejs/node/commit/547a6fecb9)] - **doc**: update authors (James M Snell) [#6373](https://github.com/nodejs/node/pull/6373)
* [[`af8dd44d43`](https://github.com/nodejs/node/commit/af8dd44d43)] - **doc**: add JacksonTian to collaborators (Jackson Tian) [#6388](https://github.com/nodejs/node/pull/6388)
* [[`09f7b8a818`](https://github.com/nodejs/node/commit/09f7b8a818)] - **doc**: add Minqi Pan to collaborators (Minqi Pan) [#6387](https://github.com/nodejs/node/pull/6387)
* [[`dfc7ffd24d`](https://github.com/nodejs/node/commit/dfc7ffd24d)] - **doc**: add eljefedelrodeodeljefe to collaborators (Robert Jefe Lindstaedt) [#6389](https://github.com/nodejs/node/pull/6389)
* [[`e45dbd3089`](https://github.com/nodejs/node/commit/e45dbd3089)] - **doc**: add ronkorving to collaborators (ronkorving) [#6385](https://github.com/nodejs/node/pull/6385)
* [[`96f6af7b26`](https://github.com/nodejs/node/commit/96f6af7b26)] - **doc**: add estliberitas to collaborators (Alexander Makarenko) [#6386](https://github.com/nodejs/node/pull/6386)
* [[`8def5fa4e7`](https://github.com/nodejs/node/commit/8def5fa4e7)] - **doc**: fix broken references (Alexander Gromnitsky) [#6350](https://github.com/nodejs/node/pull/6350)
* [[`11d71da558`](https://github.com/nodejs/node/commit/11d71da558)] - **doc**: add note for platform specific flags `fs.open()` (Robert Jefe Lindstaedt) [#6136](https://github.com/nodejs/node/pull/6136)
* [[`e6d4f3befb`](https://github.com/nodejs/node/commit/e6d4f3befb)] - **doc**: improvements to child_process, process docs (Alexander Makarenko)
* [[`7c03595b2a`](https://github.com/nodejs/node/commit/7c03595b2a)] - **doc**: fix a typo in the CONTRIBUTING.md (vsemozhetbyt) [#6343](https://github.com/nodejs/node/pull/6343)
* [[`557c309447`](https://github.com/nodejs/node/commit/557c309447)] - **doc**: add vm example, be able to require modules (Robert Jefe Lindstaedt) [#5323](https://github.com/nodejs/node/pull/5323)
* [[`61a214e957`](https://github.com/nodejs/node/commit/61a214e957)] - **doc**: note that process.config can and will be changed (James M Snell) [#6266](https://github.com/nodejs/node/pull/6266)
* [[`09ec1cc1c7`](https://github.com/nodejs/node/commit/09ec1cc1c7)] - **doc**: path.resolve ignores zero-length strings (Igor Klopov) [#5928](https://github.com/nodejs/node/pull/5928)
* [[`b743d82ffc`](https://github.com/nodejs/node/commit/b743d82ffc)] - **doc**: improve github templates by using comments (Johan Bergström) [#5710](https://github.com/nodejs/node/pull/5710)
* [[`d939152230`](https://github.com/nodejs/node/commit/d939152230)] - **doc**: fix typo in fs writeSync param list (firedfox) [#5984](https://github.com/nodejs/node/pull/5984)
* [[`4039ef1a58`](https://github.com/nodejs/node/commit/4039ef1a58)] - **doc**: remove redundant parameter comments from fs (firedfox) [#5952](https://github.com/nodejs/node/pull/5952)
* [[`9b6440a86c`](https://github.com/nodejs/node/commit/9b6440a86c)] - **doc**: add simple http clientError example (James M Snell) [#5248](https://github.com/nodejs/node/pull/5248)
* [[`de91e9a8a7`](https://github.com/nodejs/node/commit/de91e9a8a7)] - **doc**: fix v4.3.0 changelog commit entries (James M Snell) [#5164](https://github.com/nodejs/node/pull/5164)
* [[`e31bda81dd`](https://github.com/nodejs/node/commit/e31bda81dd)] - **doc**: add CTC meeting minutes 2016-01-20 (Rod Vagg) [#4904](https://github.com/nodejs/node/pull/4904)
* [[`ce11a37c4a`](https://github.com/nodejs/node/commit/ce11a37c4a)] - **doc**: add CTC meeting minutes 2016-01-27 (Rod Vagg) [#5057](https://github.com/nodejs/node/pull/5057)
* [[`3c70dc83ed`](https://github.com/nodejs/node/commit/3c70dc83ed)] - **doc**: add CTC meeting minutes 2016-01-06 (Rod Vagg) [#4667](https://github.com/nodejs/node/pull/4667)
* [[`55326f5488`](https://github.com/nodejs/node/commit/55326f5488)] - **doc**: add CTC meeting minutes 2015-12-16 (Rod Vagg) [#4666](https://github.com/nodejs/node/pull/4666)
* [[`1a346840bf`](https://github.com/nodejs/node/commit/1a346840bf)] - **doc**: add CTC meeting minutes 2015-12-02 (Rod Vagg) [#4665](https://github.com/nodejs/node/pull/4665)
* [[`3ac5f8dcba`](https://github.com/nodejs/node/commit/3ac5f8dcba)] - **doc**: add CTC meeting minutes 2015-11-11 (Rod Vagg) [#4664](https://github.com/nodejs/node/pull/4664)
* [[`db39625a44`](https://github.com/nodejs/node/commit/db39625a44)] - **doc**: add CTC meeting minutes 2015-11-04 (Rod Vagg) [#4663](https://github.com/nodejs/node/pull/4663)
* [[`aa53bf2faa`](https://github.com/nodejs/node/commit/aa53bf2faa)] - **(SEMVER-MINOR)** **events**: add prependListener() and prependOnceListener() (James M Snell) [#6032](https://github.com/nodejs/node/pull/6032)
* [[`c9628c55fa`](https://github.com/nodejs/node/commit/c9628c55fa)] - **events**: make eventNames() use Reflect.ownKeys() (Luigi Pinca) [#5822](https://github.com/nodejs/node/pull/5822)
* [[`b6e3fa745b`](https://github.com/nodejs/node/commit/b6e3fa745b)] - **(SEMVER-MINOR)** **events**: add eventNames() method (James M Snell) [#5617](https://github.com/nodejs/node/pull/5617)
* [[`1d79787e2e`](https://github.com/nodejs/node/commit/1d79787e2e)] - **fs**: add a temporary fix for re-evaluation support (Сковорода Никита Андреевич) [#5102](https://github.com/nodejs/node/pull/5102)
* [[`3441a4178b`](https://github.com/nodejs/node/commit/3441a4178b)] - **fs**: revert "change statSync to accessSync..." (Rich Trott) [#4679](https://github.com/nodejs/node/pull/4679)
* [[`809bf5e38c`](https://github.com/nodejs/node/commit/809bf5e38c)] - **fs**: change statSync to accessSync in realpathSync (Ben Noordhuis) [#4575](https://github.com/nodejs/node/pull/4575)
* [[`4bd8b20f20`](https://github.com/nodejs/node/commit/4bd8b20f20)] - **github**: put description of PR to the end of tmpl (Fedor Indutny) [#5378](https://github.com/nodejs/node/pull/5378)
* [[`81e35b5a29`](https://github.com/nodejs/node/commit/81e35b5a29)] - **github**: add issue and pull request templates (Fedor Indutny) [#5291](https://github.com/nodejs/node/pull/5291)
* [[`7cbd9fe39a`](https://github.com/nodejs/node/commit/7cbd9fe39a)] - **gyp**: inherit parent for `*.host` (Johan Bergström) [#6173](https://github.com/nodejs/node/pull/6173)
* [[`c29b3c1808`](https://github.com/nodejs/node/commit/c29b3c1808)] - **lib**: improve module loading performance (Brian White) [#5172](https://github.com/nodejs/node/pull/5172)
* [[`953173b0d7`](https://github.com/nodejs/node/commit/953173b0d7)] - **lib**: wrap tick_processor scripts in IIFE (Ali Ijaz Sheikh) [#4722](https://github.com/nodejs/node/pull/4722)
* [[`f3d9de772c`](https://github.com/nodejs/node/commit/f3d9de772c)] - **module**: fix resolution of filename with trailing slash (Michaël Zasso) [#6215](https://github.com/nodejs/node/pull/6215)
* [[`5c14efbbe9`](https://github.com/nodejs/node/commit/5c14efbbe9)] - **module**: return correct exports from linked binding (Phillip Kovalev) [#5337](https://github.com/nodejs/node/pull/5337)
* [[`19f700859b`](https://github.com/nodejs/node/commit/19f700859b)] - **module**: revert "optimize js and json file i/o" (Rich Trott) [#4679](https://github.com/nodejs/node/pull/4679)
* [[`7c60328002`](https://github.com/nodejs/node/commit/7c60328002)] - **module**: optimize js and json file i/o (Ben Noordhuis) [#4575](https://github.com/nodejs/node/pull/4575)
* [[`aa395b78fe`](https://github.com/nodejs/node/commit/aa395b78fe)] - **net**: set ADDRCONFIG DNS hint in connections (cjihrig) [#6281](https://github.com/nodejs/node/pull/6281)
* [[`e052096ee0`](https://github.com/nodejs/node/commit/e052096ee0)] - **(SEMVER-MINOR)** **os**: add userInfo() method (cjihrig) [#6104](https://github.com/nodejs/node/pull/6104)
* [[`d18daaa4e7`](https://github.com/nodejs/node/commit/d18daaa4e7)] - **querystring**: fix comments (Brian White) [#6365](https://github.com/nodejs/node/pull/6365)
* [[`633268c6df`](https://github.com/nodejs/node/commit/633268c6df)] - **src**: fix check-imports.py linter errors (Sakthipriyan Vairamani) [#6105](https://github.com/nodejs/node/pull/6105)
* [[`b0b7f6a12b`](https://github.com/nodejs/node/commit/b0b7f6a12b)] - **src**: squelch -Wunused-variable in non-icu builds (Ben Noordhuis) [#6351](https://github.com/nodejs/node/pull/6351)
* [[`b6a41d6120`](https://github.com/nodejs/node/commit/b6a41d6120)] - **src**: fix out-of-bounds write in TwoByteValue (Anna Henningsen) [#6330](https://github.com/nodejs/node/pull/6330)
* [[`86ff8447f3`](https://github.com/nodejs/node/commit/86ff8447f3)] - **src**: add intl and icu configs to process.binding('config') (James M Snell) [#6266](https://github.com/nodejs/node/pull/6266)
* [[`5b7a011e1b`](https://github.com/nodejs/node/commit/5b7a011e1b)] - **src**: add process.binding('config') (James M Snell) [#6266](https://github.com/nodejs/node/pull/6266)
* [[`f286e1e1ad`](https://github.com/nodejs/node/commit/f286e1e1ad)] - **src**: fix -Wunused-result warning in e38bade (Sakthipriyan Vairamani) [#6276](https://github.com/nodejs/node/pull/6276)
* [[`2a4998c5c0`](https://github.com/nodejs/node/commit/2a4998c5c0)] - **src**: don't set non-primitive values on templates (Ben Noordhuis) [#6228](https://github.com/nodejs/node/pull/6228)
* [[`00c876dec5`](https://github.com/nodejs/node/commit/00c876dec5)] - **src**: fix ARRAY_SIZE() logic error (Ben Noordhuis) [#5969](https://github.com/nodejs/node/pull/5969)
* [[`ad0ce57432`](https://github.com/nodejs/node/commit/ad0ce57432)] - **src**: fix NewInstance deprecation warnings (Michaël Zasso) [#4722](https://github.com/nodejs/node/pull/4722)
* [[`67b5a8a936`](https://github.com/nodejs/node/commit/67b5a8a936)] - **src**: replace usage of deprecated ForceSet (Michaël Zasso) [#5159](https://github.com/nodejs/node/pull/5159)
* [[`536cfecd71`](https://github.com/nodejs/node/commit/536cfecd71)] - **src**: replace deprecated SetWeak in object_wrap (Ali Ijaz Sheikh) [#5494](https://github.com/nodejs/node/pull/5494)
* [[`492fbfbff8`](https://github.com/nodejs/node/commit/492fbfbff8)] - **src**: update uses of deprecated NewExternal (Ali Ijaz Sheikh) [#5462](https://github.com/nodejs/node/pull/5462)
* [[`a45e1f9f98`](https://github.com/nodejs/node/commit/a45e1f9f98)] - **src**: fix deprecated SetWeak usage in base-object (Ali Ijaz Sheikh) [#5204](https://github.com/nodejs/node/pull/5204)
* [[`c1649a7e4e`](https://github.com/nodejs/node/commit/c1649a7e4e)] - **src**: replace usage of deprecated SetAccessor (Ali Ijaz Sheikh) [#5204](https://github.com/nodejs/node/pull/5204)
* [[`cddd5347f6`](https://github.com/nodejs/node/commit/cddd5347f6)] - **src**: replace deprecated ProcessDebugMessages (Michaël Zasso) [#5159](https://github.com/nodejs/node/pull/5159)
* [[`d515a3f4b4`](https://github.com/nodejs/node/commit/d515a3f4b4)] - **src**: replace usage of deprecated GetDebugContext (Michaël Zasso) [#5159](https://github.com/nodejs/node/pull/5159)
* [[`4417f99432`](https://github.com/nodejs/node/commit/4417f99432)] - **src**: replace usage of deprecated SetMessageHandler (Michaël Zasso) [#5159](https://github.com/nodejs/node/pull/5159)
* [[`8894f2745f`](https://github.com/nodejs/node/commit/8894f2745f)] - **src**: replace deprecated CancelTerminateExecution (Michaël Zasso) [#5159](https://github.com/nodejs/node/pull/5159)
* [[`f50ef1a46f`](https://github.com/nodejs/node/commit/f50ef1a46f)] - **src**: replace deprecated TerminateExecution (Michaël Zasso) [#5159](https://github.com/nodejs/node/pull/5159)
* [[`ac32340997`](https://github.com/nodejs/node/commit/ac32340997)] - **src**: replace usage of deprecated HasOwnProperty (Michaël Zasso) [#5159](https://github.com/nodejs/node/pull/5159)
* [[`a729208808`](https://github.com/nodejs/node/commit/a729208808)] - **src**: replace usage of deprecated Has (Michaël Zasso) [#5159](https://github.com/nodejs/node/pull/5159)
* [[`3d7fd9aa22`](https://github.com/nodejs/node/commit/3d7fd9aa22)] - **src**: replace usage of deprecated GetEndColumn (Michaël Zasso) [#5159](https://github.com/nodejs/node/pull/5159)
* [[`d45045f318`](https://github.com/nodejs/node/commit/d45045f318)] - **src**: replace usage of deprecated Delete (Michaël Zasso) [#5159](https://github.com/nodejs/node/pull/5159)
* [[`16b0a8c1ac`](https://github.com/nodejs/node/commit/16b0a8c1ac)] - **src**: replace usage of deprecated CompileUnbound (Michaël Zasso) [#5159](https://github.com/nodejs/node/pull/5159)
* [[`023c317173`](https://github.com/nodejs/node/commit/023c317173)] - **src**: replace usage of deprecated Compile (Michaël Zasso) [#5159](https://github.com/nodejs/node/pull/5159)
* [[`79d7475604`](https://github.com/nodejs/node/commit/79d7475604)] - **src**: fix TryCatch deprecation warnings (Michaël Zasso) [#4722](https://github.com/nodejs/node/pull/4722)
* [[`81f1732a05`](https://github.com/nodejs/node/commit/81f1732a05)] - **src**: replace deprecated String::NewFromOneByte (Michaël Zasso) [#4722](https://github.com/nodejs/node/pull/4722)
* [[`924cc6c633`](https://github.com/nodejs/node/commit/924cc6c633)] - **src**: upgrade to new v8::Private api (Ben Noordhuis) [#5045](https://github.com/nodejs/node/pull/5045)
* [[`79dc1d7635`](https://github.com/nodejs/node/commit/79dc1d7635)] - **src**: remove forwards for v8::GC*logueCallback (Ali Ijaz Sheikh) [#4381](https://github.com/nodejs/node/pull/4381)
* [[`89abe86808`](https://github.com/nodejs/node/commit/89abe86808)] - ***Revert*** "**stream**: emit 'pause' on nextTick" (Evan Lucas) [#5947](https://github.com/nodejs/node/pull/5947)
* [[`ace1009456`](https://github.com/nodejs/node/commit/ace1009456)] - **stream**: emit 'pause' on nextTick (Alexis Campailla) [#5776](https://github.com/nodejs/node/pull/5776)
* [[`eee9dc7e9d`](https://github.com/nodejs/node/commit/eee9dc7e9d)] - ***Revert*** "**stream**: add bytesRead property for readable" (cjihrig) [#4746](https://github.com/nodejs/node/pull/4746)
* [[`bfb2cd0bfd`](https://github.com/nodejs/node/commit/bfb2cd0bfd)] - **stream**: add bytesRead property for readable (Jackson Tian) [#4372](https://github.com/nodejs/node/pull/4372)
* [[`0ed85e35a9`](https://github.com/nodejs/node/commit/0ed85e35a9)] - **test**: increase the platform timeout for AIX (Michael Dawson) [#6342](https://github.com/nodejs/node/pull/6342)
* [[`591ebe7d82`](https://github.com/nodejs/node/commit/591ebe7d82)] - **test**: add tests for console.assert (Evan Lucas) [#6302](https://github.com/nodejs/node/pull/6302)
* [[`a9bab5fddb`](https://github.com/nodejs/node/commit/a9bab5fddb)] - **test**: v8-flags is sensitive to script caching (Ali Ijaz Sheikh) [#6316](https://github.com/nodejs/node/pull/6316)
* [[`c83204e2d9`](https://github.com/nodejs/node/commit/c83204e2d9)] - **test**: don't assume IPv6 in test-regress-GH-5727 (cjihrig) [#6319](https://github.com/nodejs/node/pull/6319)
* [[`6e57d2d7c4`](https://github.com/nodejs/node/commit/6e57d2d7c4)] - **test**: spawn new processes in vm-cached-data (Fedor Indutny) [#6280](https://github.com/nodejs/node/pull/6280)
* [[`3ebabc95aa`](https://github.com/nodejs/node/commit/3ebabc95aa)] - **test**: update error message for JSON.parse (Michaël Zasso) [#5945](https://github.com/nodejs/node/pull/5945)
* [[`b73e1b3c5a`](https://github.com/nodejs/node/commit/b73e1b3c5a)] - **test**: fix another flaky stringbytes test (Ali Ijaz Sheikh) [#6073](https://github.com/nodejs/node/pull/6073)
* [[`f4ebd5989a`](https://github.com/nodejs/node/commit/f4ebd5989a)] - **test**: fix flakiness of stringbytes-external (Ali Ijaz Sheikh) [#6039](https://github.com/nodejs/node/pull/6039)
* [[`be97db92af`](https://github.com/nodejs/node/commit/be97db92af)] - **test**: add buffer alignment regression tests (Anna Henningsen) [#5752](https://github.com/nodejs/node/pull/5752)
* [[`01f82f0685`](https://github.com/nodejs/node/commit/01f82f0685)] - **test**: fix proxy tab-completion test (Ali Ijaz Sheikh) [#4722](https://github.com/nodejs/node/pull/4722)
* [[`9968941797`](https://github.com/nodejs/node/commit/9968941797)] - **test**: fix tests after V8 upgrade (Michaël Zasso) [#4722](https://github.com/nodejs/node/pull/4722)
* [[`db9e122182`](https://github.com/nodejs/node/commit/db9e122182)] - **test**: update ArrayBuffer alloc failure message (Ali Ijaz Sheikh) [#4785](https://github.com/nodejs/node/pull/4785)
* [[`dc09bbe3ee`](https://github.com/nodejs/node/commit/dc09bbe3ee)] - **test**: fix test-repl-tab-complete after V8 upgrade (Ali Ijaz Sheikh) [#4106](https://github.com/nodejs/node/pull/4106)
* [[`3a0eef7b99`](https://github.com/nodejs/node/commit/3a0eef7b99)] - **test,benchmark**: use deepStrictEqual() (Rich Trott) [#6213](https://github.com/nodejs/node/pull/6213)
* [[`e928edad65`](https://github.com/nodejs/node/commit/e928edad65)] - **tools**: rewrite check-install.sh in python (Sakthipriyan Vairamani) [#6105](https://github.com/nodejs/node/pull/6105)
* [[`96978768c9`](https://github.com/nodejs/node/commit/96978768c9)] - **tools**: enforce deepStrictEqual over deepEqual (Rich Trott) [#6213](https://github.com/nodejs/node/pull/6213)
* [[`9e30129fa7`](https://github.com/nodejs/node/commit/9e30129fa7)] - **(SEMVER-MINOR)** **tools**: add buffer-constructor eslint rule (James M Snell) [#5740](https://github.com/nodejs/node/pull/5740)
* [[`b6475b9a9d`](https://github.com/nodejs/node/commit/b6475b9a9d)] - ***Revert*** "**tty**: don't read from console stream upon creation" (Evan Lucas) [#5947](https://github.com/nodejs/node/pull/5947)
* [[`4611389294`](https://github.com/nodejs/node/commit/4611389294)] - **tty**: don't read from console stream upon creation (Alexis Campailla) [#5776](https://github.com/nodejs/node/pull/5776)
* [[`59737b29c7`](https://github.com/nodejs/node/commit/59737b29c7)] - **url**: use "empty" object for empty query strings (Brian White) [#6289](https://github.com/nodejs/node/pull/6289)
* [[`0b43c08f44`](https://github.com/nodejs/node/commit/0b43c08f44)] - **util**: pass on additional error() args (Brian White) [#4279](https://github.com/nodejs/node/pull/4279)
* [[`967a15541b`](https://github.com/nodejs/node/commit/967a15541b)] - **v8**: warn in Template::Set() on improper use (Ben Noordhuis) [#6277](https://github.com/nodejs/node/pull/6277)
