# Node Foundation CTC Meeting 2016-09-14

## Links

* **Audio Recording**: TBP
* **GitHub Issue**: [#8506](https://github.com/nodejs/node/issues/8506)
* **Minutes Google Doc**: <https://docs.google.com/document/d/1kW9wLdfojpIGbu3fQMrtr7S_RJFq8CWupoKnmtWw17Q>
* _Previous Minutes Google Doc_: <https://docs.google.com/document/d/1GRgBC5Dv5luqlRc6egtxmkrQULJXa3M3CqGqWfoogV8>

## Present

* Bradley Meck @bmeck (observer/GoDaddy/TC39)
* Сковорода Никита Андреевич @ChALkeR (CTC)
* Evan Lucas @evanlucas (CTC)
* Jeremiah Senkpiel @Fishrock123 (CTC)
* Josh Gavant @joshgav (observer/Microsoft)
* Julien Gilli @misterdjules (CTC)
* Brian White @mscdex (CTC)
* Jenn Turner @renrutnnej (observer/Node.js Foundation)
* Rod Vagg @rvagg (CTC)
* Seth Thompson @s3ththompson (observer/Google)
* Trevor Norris @trevnorris (CTC)
* Rich Trott @Trott (CTC)

## Standup

* Bradley Meck @bmeck (observer/GoDaddy/TC39)
    * Synched up with more people about ES Modules
* Сковорода Никита Андреевич @ChALkeR (CTC)
    * Mostly nothing this week.
* Evan Lucas @evanlucas (CTC)
    * Commented on issues/prs
* Jeremiah Senkpiel @Fishrock123 (CTC)
    * v6.6.0 Release WIP
    * ES Modules discussions
    * Misc PRs / Issues
    * Async_Hooks review / Thinking
* Josh Gavant @joshgav (observer/Microsoft)
    * Diag WG activity
    * modules discussion
* Julien Gilli @misterdjules (CTC)
    * Timers code reviews and investigating/fixing libuv bugs on SmartOS. Read Async Hooks EP.
* Brian White @mscdex (CTC)
    * Investigated UDP performance again for the purposes of a JS DNS resolver. With a few tweaks/optimizations, we can at least achieve performance very close to c-ares.
    * Reviewed PRs, commented on issues
* Jenn Turner @renrutnnej (observer/Node.js Foundation)
    * Observing, no update.
* Rod Vagg @rvagg (CTC)
    * Travel, administrative, board, TSC, meetings, yabba yabba
* Seth Thompson @s3ththompson (observer/Google)
    * v8_inspector move to v8 is almost done, builds in tree now
    * continued discussion on microtask queue inspection here: https://bugs.chromium.org/p/v8/issues/detail?id=4643
* Trevor Norris @trevnorris (CTC)
    * async_hooks. submitted PR and updated EP.
* Rich Trott @Trott (CTC)
    * Onboarded @not-an-aardvark (with @addaleax’s help), @imyller, and @gibfahn
    * ESLint update (replaced a custom rule with a built-in), test PRs, doc PRs
    * A burst of first-time-contributor PRs landed, woo hoo


## Agenda

Extracted from **ctc-agenda** labelled issues and pull requests from the **nodejs org** prior to the meeting.

* AsyncWrap public API proposal [node-eps#18](https://github.com/nodejs/node-eps/pull/18)


## Previous Meeting Review

Extracted from **ctc-agenda** labelled issues and pull requests from the **nodejs org** prior to the meeting.

* src: add no-op for --harmony-proxies flag [#8395](https://github.com/nodejs/node/pull/8395)

    * @ofrobots to float a patch on our branch of V8 5.1 and open a PR. Discussion to continue there.
    * Keep on agenda for next week just in case.

* AsyncWrap public API proposal [node-eps#18](https://github.com/nodejs/node-eps/pull/18)

    * Everyone read [node-eps#18](https://github.com/nodejs/node-eps/pull/18).
    * Vote next week on Node-EP.
    * Open a PR for code in nodejs/node.

---

## Minutes

### AsyncWrap public API proposal [node-eps#18](https://github.com/nodejs/node-eps/pull/18)

PR: [#8531](https://github.com/nodejs/node/pull/8531)

@trott: move to vote on the EP. Anything to discuss first?

@rvagg: One thing Trevor adjusted since discussion - some desire to have hooks that execute on one execution branch. Trevor can describe.

@trevnorris: if you were to enable a hook, run an async op, then disable the hook, any ops that took place during time when it was enabled will continue to have hooks called for them even after it’s disabled.

This was okay, I could’ve managed it, but `nextTick` alone increases the amount of hooks to be processed 3x.

**Votes**

* Yes     - 7 - @rvagg, @evanlucas, @Chalker, @Fishrock123, @trevnorris, @mscdex, @trott
* No      - 0
* Abstain - 1 - @misterdjules

---

### Other

@Chalker: Perhaps we should discuss GitHub functionality changes, such as the review capability in the web interface.

@trott: Open a PR to discuss. It could make fixing up the commit message simpler.

---

## Q/A on public channels

Q: @williamkapke: Live CTC meeting in Austin? [tsc#137](https://github.com/nodejs/tsc/issues/137)

A: @rvagg: More people probably and a good time too.

Q: What’s the status of ES6 modules? What’s the team’s personal opinion on that?

@Fishrock123: Mostly kept up in Node-EP 002 and related PRs. Some of us and @bmeck will be going to TC39 meeting at end of Sept. and have materials prepared to discuss problems we’re facing.

@trott: My personal opinion is that I hope we can work with TC39 and get alterations such that we can avoid `.mjs` extension, but if that doesn’t happen the `.mjs` extension isn’t ideal but I do believe that it’s better than other options.

@rvagg: My personal opinion is that we are unfortunately trapped in a tough corner where TC39 has created a spec which has technical problems for Node and we’ve had difficulty getting them to hear our concerns. They’d like us to make changes on our side and that would be enough, but that’s quite complicated.

We have many users who like the idea of modules, but they’re actually transpiled versions and not implemented by browsers.

@trott: I’m optimistic that things will work out well. I have a lot of faith in Bradley, Jeremiah, et al.

@Fishrock123: No browser / VM has this fully implemented yet. V8 would have to implement it first and it definitely won’t be done for Node.js v7.

@bmeck: Chakra’s impl is basically done for `type=module` spec in the browser, but that would drastically change if we went to TC39 and they changed the behavior.

@Chalker: Edge has modules in a preview release.

@Fishrock123: That’s Chakra, yes.

@rvagg: There will be a talk at Node Interactive Austin by Bradley, you should attend there. (CTC call at the same time, we might need to think about whether to have CTC call that day.)


## Upcoming Meetings

* CTC: 2016-09-21
* TSC: 2016-09-22
* Build: 2016-09-20
* Diagnostics: 2016-09-21
* Benchmarking: 2016-09-21? [Benchmarking#56](https://github.com/nodejs/benchmarking/issues/56)
* LTS:
* Post-Mortem:
* API:
