package com.kickstarter.services.gcm;

import android.content.Intent;

import com.google.android.gms.iid.InstanceIDListenerService;

import timber.log.Timber;

public class TokenListenerService extends InstanceIDListenerService {
  /**
   * Called if the InstanceID token is updated. This can occur in a variety of scenarios - the
   * InstanceID service might periodically request that we refresh a token every 6 months, or
   * it could force a refresh if a token is invalidated (e.g. security issues, device information
   * is no longer valid. When a token refresh event is received, we create a new register intent
   * to fetch the latest token and update it on the backend.
   *
   * This call is generated by the InstanceID service, not by the app.
   */
  @Override
  public void onTokenRefresh() {
    Timber.d("Token refreshed, creating new RegisterService intent");
    startService(new Intent(this, RegisterService.class));
  }
}
