/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.matchers;

import com.google.common.base.MoreObjects;
import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MethodVisibility;
import com.google.errorprone.matchers.MultiMatcher;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.util.Arrays;
import java.util.Collection;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;

public class JUnitMatchers {
    public static final String JUNIT4_TEST_ANNOTATION = "org.junit.Test";
    public static final String JUNIT_BEFORE_ANNOTATION = "org.junit.Before";
    public static final String JUNIT_AFTER_ANNOTATION = "org.junit.After";
    public static final String JUNIT_BEFORE_CLASS_ANNOTATION = "org.junit.BeforeClass";
    public static final String JUNIT_AFTER_CLASS_ANNOTATION = "org.junit.AfterClass";
    public static final String JUNIT4_RUN_WITH_ANNOTATION = "org.junit.runner.RunWith";
    private static final String JUNIT3_TEST_CASE_CLASS = "junit.framework.TestCase";
    private static final String JUNIT4_IGNORE_ANNOTATION = "org.junit.Ignore";
    public static final Matcher<MethodTree> hasJUnitAnnotation = Matchers.anyOf(Matchers.hasAnnotationOnAnyOverriddenMethod("org.junit.Test"), Matchers.hasAnnotationOnAnyOverriddenMethod("org.junit.Before"), Matchers.hasAnnotationOnAnyOverriddenMethod("org.junit.After"), Matchers.hasAnnotation("org.junit.BeforeClass"), Matchers.hasAnnotation("org.junit.AfterClass"));
    public static final Matcher<MethodTree> hasJUnit4BeforeAnnotations = Matchers.anyOf(Matchers.hasAnnotationOnAnyOverriddenMethod("org.junit.Before"), Matchers.hasAnnotation("org.junit.BeforeClass"));
    public static final Matcher<MethodTree> hasJUnit4AfterAnnotations = Matchers.anyOf(Matchers.hasAnnotationOnAnyOverriddenMethod("org.junit.After"), Matchers.hasAnnotation("org.junit.AfterClass"));
    public static final Matcher<ClassTree> isTestCaseDescendant = Matchers.isSubtypeOf("junit.framework.TestCase");
    public static final Matcher<ClassTree> isConcreteClassWithoutRunWith = Matchers.allOf(Matchers.not(Matchers.hasAnnotation("org.junit.runner.RunWith")), Matchers.not(Matchers.hasModifier(Modifier.ABSTRACT)), Matchers.nestingKind(NestingKind.TOP_LEVEL));
    public static final Matcher<ClassTree> hasJUnit4TestCases = Matchers.hasMethod(Matchers.hasAnnotationOnAnyOverriddenMethod("org.junit.Test"));
    public static final Matcher<ClassTree> isJUnit3TestClass = Matchers.allOf(isTestCaseDescendant, isConcreteClassWithoutRunWith, Matchers.not(hasJUnit4TestCases));
    public static final Matcher<MethodTree> isJunit3TestCase = Matchers.allOf(Matchers.methodNameStartsWith("test"), Matchers.methodHasParameters(new Matcher[0]), Matchers.hasModifier(Modifier.PUBLIC), Matchers.methodReturns(Suppliers.VOID_TYPE));
    public static final Matcher<MethodTree> looksLikeJUnit3SetUp = Matchers.allOf(Matchers.methodIsNamed("setUp"), Matchers.methodHasParameters(new Matcher[0]), Matchers.anyOf(Matchers.methodHasVisibility(MethodVisibility.Visibility.PUBLIC), Matchers.methodHasVisibility(MethodVisibility.Visibility.PROTECTED)), Matchers.not(Matchers.hasModifier(Modifier.ABSTRACT)), Matchers.not(Matchers.hasModifier(Modifier.STATIC)), Matchers.methodReturns(Suppliers.VOID_TYPE));
    public static final Matcher<MethodTree> looksLikeJUnit3TearDown = Matchers.allOf(Matchers.methodIsNamed("tearDown"), Matchers.methodHasParameters(new Matcher[0]), Matchers.anyOf(Matchers.methodHasVisibility(MethodVisibility.Visibility.PUBLIC), Matchers.methodHasVisibility(MethodVisibility.Visibility.PROTECTED)), Matchers.not(Matchers.hasModifier(Modifier.ABSTRACT)), Matchers.not(Matchers.hasModifier(Modifier.STATIC)), Matchers.methodReturns(Suppliers.VOID_TYPE));
    public static final Matcher<MethodTree> wouldRunInJUnit4 = Matchers.allOf(Matchers.hasAnnotationOnAnyOverriddenMethod("org.junit.Test"), Matchers.not(Matchers.hasAnnotationOnAnyOverriddenMethod("org.junit.Ignore")));
    private static final Collection<String> TEST_RUNNERS = Arrays.asList("org.mockito.runners.MockitoJUnitRunner", "org.junit.runners.BlockJUnit4ClassRunner");
    private static final Matcher<ExpressionTree> isJUnit4TestRunner = new Matcher<ExpressionTree>(){

        @Override
        public boolean matches(ExpressionTree t, VisitorState state) {
            Type type = ((JCTree)((Object)t)).type;
            if (!(type instanceof Type.ClassType)) {
                return false;
            }
            java.util.List typeArgs = ((Type.ClassType)type).getTypeArguments();
            if (((List)typeArgs).size() != 1) {
                return false;
            }
            Type runnerType = (Type)((List)typeArgs).get(0);
            for (String testRunner : TEST_RUNNERS) {
                Symbol parent = state.getSymbolFromString(testRunner);
                if (parent == null || !runnerType.tsym.isSubClass(parent, state.getTypes())) continue;
                return true;
            }
            return false;
        }
    };
    public static final MultiMatcher<ClassTree, AnnotationTree> hasJUnit4TestRunner = Matchers.annotations(ChildMultiMatcher.MatchType.AT_LEAST_ONE, Matchers.hasArgumentWithValue("value", isJUnit4TestRunner));
    public static final Matcher<ClassTree> isJUnit4TestClass = Matchers.allOf(Matchers.not(isTestCaseDescendant), Matchers.not(Matchers.enclosingClass(Matchers.hasModifier(Modifier.ABSTRACT))), Matchers.anyOf(hasJUnit4TestRunner, hasJUnit4TestCases));
    public static final Matcher<ClassTree> isAmbiguousJUnitVersion = Matchers.allOf(isTestCaseDescendant, Matchers.anyOf(hasJUnit4TestRunner, hasJUnit4TestCases));

    public static boolean containsTestMethod(Tree tree) {
        return (Boolean)MoreObjects.firstNonNull((Object)tree.accept(new TreeScanner<Boolean, Void>(){

            @Override
            public Boolean visitMethodInvocation(MethodInvocationTree node, Void unused) {
                String name = ((Name)ASTHelpers.getSymbol(node).getSimpleName()).toString();
                return name.contains("assert") || name.contains("verify") || name.contains("check") || name.contains("fail") || name.contains("expect") || (Boolean)MoreObjects.firstNonNull(super.visitMethodInvocation(node, null), (Object)false) != false;
            }

            @Override
            public Boolean reduce(Boolean a, Boolean b) {
                return (Boolean)MoreObjects.firstNonNull((Object)a, (Object)false) != false || (Boolean)MoreObjects.firstNonNull((Object)b, (Object)false) != false;
            }
        }, null), (Object)false);
    }
}

