/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.truth.FailureStrategy;
import com.google.common.truth.IterableSubject;
import com.google.common.truth.Ordered;
import com.google.common.truth.SubjectUtils;
import java.util.Collection;
import javax.annotation.CheckReturnValue;

public class CollectionSubject<S extends CollectionSubject<S, T, C>, T, C extends Collection<T>>
extends IterableSubject<S, T, C> {
    static <T, C extends Collection<T>> CollectionSubject<? extends CollectionSubject<?, T, C>, T, C> create(FailureStrategy failureStrategy, Collection<T> collection) {
        return new CollectionSubject(failureStrategy, collection);
    }

    CollectionSubject(FailureStrategy failureStrategy, C collection) {
        super(failureStrategy, collection);
    }

    @CheckReturnValue
    public Has<T, C> has() {
        return new Has();
    }

    public class Has<T, C extends Collection<T>> {
        @Deprecated
        public void item(T item) {
            CollectionSubject.this.contains(item);
        }

        @Deprecated
        public void anyOf(T first) {
            CollectionSubject.this.contains(first);
        }

        @Deprecated
        public void anyOf(T first, T second, T ... rest) {
            CollectionSubject.this.containsAnyOf(first, second, rest);
        }

        @Deprecated
        public void anyFrom(Iterable<T> col) {
            CollectionSubject.this.containsAnyIn(col);
        }

        @Deprecated
        public Ordered allOf(T first) {
            return this.allFrom(SubjectUtils.accumulate(first));
        }

        @Deprecated
        public Ordered allOf(T first, T second, T ... rest) {
            return CollectionSubject.this.containsAllOf(first, second, rest);
        }

        @Deprecated
        public Ordered allFrom(Iterable<T> required) {
            return CollectionSubject.this.containsAllIn(required);
        }

        @Deprecated
        public Ordered exactly(T first) {
            return this.exactlyAs(SubjectUtils.accumulate(first));
        }

        @Deprecated
        public Ordered exactly(T first, T second, T ... rest) {
            return CollectionSubject.this.containsOnlyElements(first, second, rest);
        }

        @Deprecated
        public Ordered exactlyAs(Iterable<T> required) {
            return CollectionSubject.this.containsOnlyElementsIn(required);
        }

        @Deprecated
        public void noneOf(T first) {
            CollectionSubject.this.doesNotContain(first);
        }

        @Deprecated
        public void noneOf(T first, T second, T ... rest) {
            CollectionSubject.this.containsNoneOf(first, second, rest);
        }

        @Deprecated
        public void noneFrom(Iterable<T> excluded) {
            CollectionSubject.this.containsNoneIn(excluded);
        }
    }
}

