/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.truth.AbstractArraySubject;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.ListSubject;
import com.google.common.truth.Platform;
import java.util.Arrays;
import java.util.List;

public class ObjectArraySubject<T>
extends AbstractArraySubject<ObjectArraySubject<T>, T[]> {
    private final String typeName;

    ObjectArraySubject(FailureStrategy failureStrategy, T[] o) {
        super(failureStrategy, o);
        this.typeName = this.typeNameFromInstance(o);
    }

    @Override
    protected String underlyingType() {
        return this.typeName;
    }

    @Override
    protected List<T> listRepresentation() {
        return Arrays.asList((Object[])this.getSubject());
    }

    private String typeNameFromInstance(Object instance) {
        if (instance == null) {
            return "null reference of unknown array type";
        }
        if (!instance.getClass().isArray()) {
            throw new IllegalArgumentException(String.valueOf(instance.getClass().getName()).concat(" instance passed into T[] subject."));
        }
        Class<?> type = instance.getClass().getComponentType();
        if (type.isPrimitive()) {
            throw new IllegalArgumentException("Primitive array passed into T[] subject.");
        }
        return Platform.compressType(type.toString());
    }

    @Override
    public void isEqualTo(Object expected) {
        Object[] actual = (Object[])this.getSubject();
        if (actual == expected) {
            return;
        }
        try {
            Object[] expectedArray = (Object[])expected;
            if (!Arrays.equals(actual, expectedArray)) {
                this.fail("is equal to", (Object)Arrays.asList(expectedArray));
            }
        }
        catch (ClassCastException e) {
            this.failWithBadType(expected);
        }
    }

    @Override
    public void isNotEqualTo(Object expected) {
        Object[] actual = (Object[])this.getSubject();
        try {
            Object[] expectedArray = (Object[])expected;
            if (actual == expected || Arrays.equals(actual, expectedArray)) {
                this.failWithRawMessage("%s unexpectedly equal to %s.", this.getDisplaySubject(), Arrays.asList(expectedArray));
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public ListSubject<?, T, List<T>> asList() {
        return ListSubject.create(this.failureStrategy, this.listRepresentation());
    }
}

