/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Optional;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.Subject;

public class OptionalSubject<T>
extends Subject<OptionalSubject<T>, Optional<T>> {
    OptionalSubject(FailureStrategy failureStrategy, Optional<T> subject) {
        super(failureStrategy, subject);
        this.check().that((Object)subject).named("Optional<T>").isNotNull();
    }

    public void isPresent() {
        if (!((Optional)this.getSubject()).isPresent()) {
            this.failWithoutSubject("is present");
        }
    }

    public void isAbsent() {
        if (((Optional)this.getSubject()).isPresent()) {
            this.fail("is absent");
        }
    }

    public void hasValue(Object expected) {
        if (expected == null) {
            throw new NullPointerException("Optional cannot have a null value.");
        }
        if (!((Optional)this.getSubject()).isPresent()) {
            this.fail("has value", expected);
        } else {
            Object actual = ((Optional)this.getSubject()).get();
            if (!actual.equals(expected)) {
                this.fail("has value", expected);
            }
        }
    }
}

