/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Optional;
import com.google.common.truth.AbstractVerb;
import com.google.common.truth.BooleanSubject;
import com.google.common.truth.ClassSubject;
import com.google.common.truth.CollectionSubject;
import com.google.common.truth.ComparableSubject;
import com.google.common.truth.DefaultSubject;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.IntegerSubject;
import com.google.common.truth.IterableSubject;
import com.google.common.truth.ListSubject;
import com.google.common.truth.LongSubject;
import com.google.common.truth.MapSubject;
import com.google.common.truth.ObjectArraySubject;
import com.google.common.truth.OptionalSubject;
import com.google.common.truth.Platform;
import com.google.common.truth.PrimitiveBooleanArraySubject;
import com.google.common.truth.PrimitiveByteArraySubject;
import com.google.common.truth.PrimitiveCharArraySubject;
import com.google.common.truth.PrimitiveDoubleArraySubject;
import com.google.common.truth.PrimitiveFloatArraySubject;
import com.google.common.truth.PrimitiveIntArraySubject;
import com.google.common.truth.PrimitiveLongArraySubject;
import com.google.common.truth.StringSubject;
import com.google.common.truth.Subject;
import com.google.common.truth.SubjectFactory;
import com.google.common.truth.TestVerb;
import com.google.common.truth.ThrowableSubject;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckReturnValue;

public final class Truth {
    public static final FailureStrategy THROW_ASSERTION_ERROR = new FailureStrategy(){

        @Override
        public void failComparing(String message, CharSequence expected, CharSequence actual) {
            throw Platform.comparisonFailure(message, expected.toString(), actual.toString());
        }
    };
    public static final TestVerb ASSERT = new TestVerb(THROW_ASSERTION_ERROR);

    public static TestVerb assert_() {
        return ASSERT;
    }

    public static TestVerb assertWithMessage(String messageToPrepend) {
        return Truth.assert_().withFailureMessage(messageToPrepend);
    }

    public static <S extends Subject<S, T>, T, SF extends SubjectFactory<S, T>> AbstractVerb.DelegatedVerb<S, T> assertAbout(SF factory) {
        return Truth.assert_().about(factory);
    }

    @CheckReturnValue
    public static <T extends Comparable<?>> ComparableSubject<?, T> assertThat(T target) {
        return Truth.assert_().that(target);
    }

    @CheckReturnValue
    public static Subject<DefaultSubject, Object> assertThat(Object target) {
        return Truth.assert_().that(target);
    }

    @CheckReturnValue
    @GwtIncompatible(value="ClassSubject.java")
    public static ClassSubject assertThat(Class<?> target) {
        return Truth.assert_().that(target);
    }

    @CheckReturnValue
    public static ThrowableSubject assertThat(Throwable target) {
        return Truth.assert_().that(target);
    }

    @CheckReturnValue
    public static LongSubject assertThat(Long target) {
        return Truth.assert_().that(target);
    }

    @CheckReturnValue
    public static IntegerSubject assertThat(Integer target) {
        return Truth.assert_().that(target);
    }

    @CheckReturnValue
    public static BooleanSubject assertThat(Boolean target) {
        return Truth.assert_().that(target);
    }

    @CheckReturnValue
    public static StringSubject assertThat(String target) {
        return Truth.assert_().that(target);
    }

    @CheckReturnValue
    public static <T, C extends Iterable<T>> IterableSubject<? extends IterableSubject<?, T, C>, T, C> assertThat(Iterable<T> target) {
        return Truth.assert_().that(target);
    }

    @CheckReturnValue
    public static <T, C extends Collection<T>> CollectionSubject<? extends CollectionSubject<?, T, C>, T, C> assertThat(Collection<T> target) {
        return Truth.assert_().that(target);
    }

    @CheckReturnValue
    public static <T, C extends List<T>> ListSubject<? extends ListSubject<?, T, C>, T, C> assertThat(List<T> target) {
        return Truth.assert_().that(target);
    }

    @CheckReturnValue
    public static <T> ObjectArraySubject<T> assertThat(T[] target) {
        return Truth.assert_().that(target);
    }

    @CheckReturnValue
    public static PrimitiveBooleanArraySubject assertThat(boolean[] target) {
        return Truth.assert_().that(target);
    }

    @CheckReturnValue
    public static PrimitiveIntArraySubject assertThat(int[] target) {
        return Truth.assert_().that(target);
    }

    @CheckReturnValue
    public static PrimitiveLongArraySubject assertThat(long[] target) {
        return Truth.assert_().that(target);
    }

    @CheckReturnValue
    public static PrimitiveByteArraySubject assertThat(byte[] target) {
        return Truth.assert_().that(target);
    }

    @CheckReturnValue
    public static PrimitiveCharArraySubject assertThat(char[] target) {
        return Truth.assert_().that(target);
    }

    @CheckReturnValue
    public static PrimitiveFloatArraySubject assertThat(float[] target) {
        return Truth.assert_().that(target);
    }

    @CheckReturnValue
    public static PrimitiveDoubleArraySubject assertThat(double[] target) {
        return Truth.assert_().that(target);
    }

    @CheckReturnValue
    public static <T> OptionalSubject<T> assertThat(Optional<T> target) {
        return Truth.assert_().that(target);
    }

    @CheckReturnValue
    public static <K, V, M extends Map<K, V>> MapSubject<? extends MapSubject<?, K, V, M>, K, V, M> assertThat(Map<K, V> target) {
        return Truth.assert_().that(target);
    }
}

