// Copyright 2014 Google Inc. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.google.devtools.build.lib.rules.cpp;

import com.google.devtools.build.lib.actions.Artifact;
import com.google.devtools.build.lib.concurrent.ThreadSafety.Immutable;

/**
 * Structure for C++ module maps. Stores the name of the module and a .cppmap artifact.
 */
@Immutable
public class CppModuleMap {
  private final Artifact artifact;
  private final String name;

  public CppModuleMap(Artifact artifact, String name) {
    this.artifact = artifact;
    this.name = name;
  }

  public Artifact getArtifact() {
    return artifact;
  }

  public String getName() {
    return name;
  }

  @Override
  public String toString() {
    return name + "@" + artifact;
  }
}
