/*
 * Decompiled with CFR 0.152.
 */
package javax.cim;

import java.util.Calendar;
import javax.cim.CIMDateTime;
import org.sblim.cimclient.internal.cim.DTStringReader;
import org.sblim.cimclient.internal.cim.DTStringWriter;

public class CIMDateTimeAbsolute
extends CIMDateTime {
    private static final long serialVersionUID = 7556792806296945178L;
    private int iYear;
    private int iMonth;
    private int iDay;
    private int iHour;
    private int iMin;
    private int iSec;
    private int iUSec;
    private int iUtc;
    private boolean iUnsignificantUtc;
    private String iStr;
    private static final int YEAR = 1;
    private static final int MONTH = 2;
    private static final int DAY = 4;
    private static final int HOUR = 8;
    private static final int MIN = 16;
    private static final int SEC = 32;
    private static final int USEC = 64;
    private static final int UTC = 128;

    public CIMDateTimeAbsolute() {
        this.set(Calendar.getInstance());
    }

    public CIMDateTimeAbsolute(Calendar pCalendar) throws IllegalArgumentException {
        if (pCalendar == null) {
            throw new IllegalArgumentException("Null Calendar is not allowed!");
        }
        if (pCalendar.get(1) > 9999) {
            throw new IllegalArgumentException("The year field cannot be greater than 9999!");
        }
        this.set(pCalendar);
    }

    public CIMDateTimeAbsolute(String pDateTime) throws IllegalArgumentException {
        if (pDateTime == null) {
            throw new IllegalArgumentException("Null DateTime is not allowed!");
        }
        DTStringReader reader = new DTStringReader(pDateTime);
        this.iYear = reader.readAndCheck(4, "year", 0, 9999, true);
        this.iMonth = reader.readAndCheck(2, "month", 1, 12, true);
        this.iDay = reader.readAndCheck(2, "day", 1, 31, true);
        this.iHour = reader.readAndCheck(2, "hour", 0, 23, true);
        this.iMin = reader.readAndCheck(2, "minute", 0, 59, true);
        this.iSec = reader.readAndCheck(2, "second", 0, 59, true);
        reader.read('.');
        this.iUSec = reader.readAndCheck(6, "microSeconds", 0, 999999, true);
        char sign = reader.read();
        if (sign != '+' && sign != '-') {
            String msg = "Illegal character '" + sign + "' at position " + reader.getPos() + "! '+' or '-' is expected.";
            throw new IllegalArgumentException(msg);
        }
        this.iUtc = reader.read(3, "utc", true);
        if (reader.isUnsignificant()) {
            this.iUnsignificantUtc = true;
        } else if (sign == '-') {
            this.iUtc = -this.iUtc;
        }
        if (reader.read() != '\u0000') {
            throw new IllegalArgumentException("Extra character at the end of " + pDateTime + " !");
        }
        this.iStr = pDateTime;
    }

    public int compareTo(CIMDateTime pDateTime) throws IllegalArgumentException {
        long thatMicros;
        if (!(pDateTime instanceof CIMDateTimeAbsolute)) {
            String msg = "pDateTime must be a CIMDateTimeAbsolute instance while it is a " + (pDateTime == null ? "null!" : pDateTime.getClass().getName() + " instance!");
            throw new IllegalArgumentException(msg);
        }
        CIMDateTimeAbsolute that = (CIMDateTimeAbsolute)pDateTime;
        int mask = this.getMask() & that.getMask();
        long thisMicros = this.getTotalUSec(mask);
        long val = thisMicros - (thatMicros = that.getTotalUSec(mask));
        if (val == 0L) {
            return 0;
        }
        return val < 0L ? -1 : 1;
    }

    public String getDateTimeString() {
        if (this.iStr != null) {
            return this.iStr;
        }
        DTStringWriter dTWriter = new DTStringWriter();
        dTWriter.write(4, this.iYear);
        dTWriter.write(2, this.iMonth);
        dTWriter.write(2, this.iDay);
        dTWriter.write(2, this.iHour);
        dTWriter.write(2, this.iMin);
        dTWriter.write(2, this.iSec);
        dTWriter.write('.');
        dTWriter.write(6, this.iUSec);
        if (this.iUnsignificantUtc) {
            dTWriter.write("+***");
        } else {
            dTWriter.writeSigned(3, this.iUtc);
        }
        this.iStr = dTWriter.toString();
        return this.iStr;
    }

    public int getDay() {
        return this.iDay;
    }

    public int getHour() {
        return this.iHour;
    }

    public int getMicrosecond() {
        return this.iUSec;
    }

    public int getMinute() {
        return this.iMin;
    }

    public int getMonth() {
        return this.iMonth;
    }

    public int getSecond() {
        return this.iSec;
    }

    public int getUTCOffset() {
        return this.iUnsignificantUtc ? -1 : this.iUtc;
    }

    public int getYear() {
        return this.iYear;
    }

    public int hashCode() {
        return this.getDateTimeString().hashCode();
    }

    public String toString() {
        return this.getDateTimeString();
    }

    private int getMask() {
        int mask = 0;
        if (this.iYear != -1) {
            mask |= 1;
        }
        if (this.iMonth != -1) {
            mask |= 2;
        }
        if (this.iDay != -1) {
            mask |= 4;
        }
        if (this.iHour != -1) {
            mask |= 8;
        }
        if (this.iMin != -1) {
            mask |= 0x10;
        }
        if (this.iSec != -1) {
            mask |= 0x20;
        }
        if (this.iUSec != -1) {
            mask |= 0x40;
        }
        if (!this.iUnsignificantUtc) {
            mask |= 0x80;
        }
        return mask;
    }

    private int mask(int pMask, int pField, int pValue, int pInitValue) {
        return (pMask & pField) > 0 ? pValue : pInitValue;
    }

    private long getTotalUSec(int pMask) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, this.mask(pMask, 1, this.iYear, 0));
        cal.set(2, this.mask(pMask, 2, this.iMonth - 1, 0));
        cal.set(5, this.mask(pMask, 4, this.iDay, 1));
        cal.set(11, this.mask(pMask, 8, this.iHour, 0));
        cal.set(12, this.mask(pMask, 16, this.iMin, 0));
        cal.set(13, this.mask(pMask, 32, this.iSec, 0));
        int millis = this.iUSec / 1000;
        int micros = this.iUSec % 1000;
        cal.set(14, this.mask(pMask, 64, millis, 0));
        long totalMicros = cal.getTimeInMillis() * 1000L;
        if ((pMask & 0x40) > 0) {
            totalMicros += (long)micros;
        }
        if ((pMask & 0x80) > 0) {
            totalMicros += (long)this.iUtc * 60000000L;
        }
        return totalMicros;
    }

    private void set(Calendar pCal) {
        this.iYear = pCal.get(1);
        this.iMonth = pCal.get(2) + 1;
        this.iDay = pCal.get(5);
        this.iHour = pCal.get(11);
        this.iMin = pCal.get(12);
        this.iSec = pCal.get(13);
        this.iUSec = pCal.get(14) * 1000;
        this.iUtc = pCal.getTimeZone().inDaylightTime(pCal.getTime()) ? (pCal.get(15) + pCal.get(16)) / 60000 : pCal.get(15) / 60000;
    }
}

