/*
 * Decompiled with CFR 0.152.
 */
package javax.cim;

import javax.cim.CIMDateTime;
import org.sblim.cimclient.internal.cim.DTStringReader;
import org.sblim.cimclient.internal.cim.DTStringWriter;

public class CIMDateTimeInterval
extends CIMDateTime {
    private static final long serialVersionUID = -7362881414085831668L;
    private int iDays;
    private int iHours;
    private int iMinutes;
    private int iSeconds;
    private int iUSeconds;
    private String iStr;
    private boolean iTotalMicrosCalced;
    private long iTotalMicros;
    private int iUnsignificantUSecDigits;
    private static final int MAX_DAY = 99999999;
    private static final int MAX_HOUR = 23;
    private static final int MAX_MIN = 59;
    private static final int MAX_SEC = 59;
    private static final int MAX_MILLISEC = 999;
    private static final int MAX_MICROSEC = 999999;
    private static final long MAX_INTERVAL = 8639999999999999L;
    private static final long MILLISEC_ACCURACY_DIV = 1000L;
    private static final long SEC_ACCURACY_DIV = 1000000L;
    private static final long MIN_ACCURACY_DIV = 60000000L;
    private static final long HOUR_ACCURACY_DIV = 3600000000L;
    private static final long DAY_ACCURACY_DIV = 86400000000L;
    private static final long NO_ACCURACY_DIV = 8640000000000000000L;
    private static final long[] USEC_ACCURACY_DIV_A = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L};
    private long iAccuracyDivisor = 1L;
    private static final int DAY_START_IDX = 0;
    private static final int HOUR_START_IDX = 8;
    private static final int MIN_START_IDX = 10;
    private static final int SEC_START_IDX = 12;
    private static final int DOT_IDX = 14;
    private static final int USEC_START_IDX = 15;
    private static final int UTC_START_IDX = 21;
    private static final int LENGTH = 25;

    public CIMDateTimeInterval(int pDays, int pHours, int pMinutes, int pSeconds, int pMicroseconds) throws IllegalArgumentException {
        boolean notSignificant = CIMDateTimeInterval.checkLimits("pDays", pDays, 0, 99999999, false);
        if (notSignificant) {
            this.iAccuracyDivisor = 8640000000000000000L;
        }
        if ((notSignificant = CIMDateTimeInterval.checkLimits("pHours", pHours, 0, 23, notSignificant)) && this.iAccuracyDivisor == 1L) {
            this.iAccuracyDivisor = 86400000000L;
        }
        if ((notSignificant = CIMDateTimeInterval.checkLimits("pMinutes", pMinutes, 0, 59, notSignificant)) && this.iAccuracyDivisor == 1L) {
            this.iAccuracyDivisor = 3600000000L;
        }
        if ((notSignificant = CIMDateTimeInterval.checkLimits("pSeconds", pSeconds, 0, 59, notSignificant)) && this.iAccuracyDivisor == 1L) {
            this.iAccuracyDivisor = 60000000L;
        }
        if (notSignificant = CIMDateTimeInterval.checkLimits("pMicroseconds", pMicroseconds, 0, 999999, notSignificant)) {
            this.iUnsignificantUSecDigits = 6;
            if (this.iAccuracyDivisor == 1L) {
                this.iAccuracyDivisor = USEC_ACCURACY_DIV_A[this.iUnsignificantUSecDigits];
            }
        } else {
            this.iUnsignificantUSecDigits = 0;
        }
        this.iDays = pDays;
        this.iHours = pHours;
        this.iMinutes = pMinutes;
        this.iSeconds = pSeconds;
        this.iUSeconds = pMicroseconds;
        CIMDateTimeInterval.debug("CIMDateTimeInterval(" + pDays + "," + pHours + "," + pMinutes + "," + pSeconds + "," + pMicroseconds + "): days=" + this.iDays + ", hours=" + this.iHours + ", mins=" + this.iMinutes + ", secs=" + this.iSeconds + ", usecs=" + this.iUSeconds + ", acc div=" + this.iAccuracyDivisor + ", unsig digits=" + this.iUnsignificantUSecDigits);
    }

    public CIMDateTimeInterval(long pMilliseconds) throws IllegalArgumentException {
        if (pMilliseconds < 0L || pMilliseconds > 8639999999999999L) {
            throw new IllegalArgumentException("pMilliseconds must be between 0 and 8639999999999999. " + pMilliseconds + " is illegal!");
        }
        long totalUSecs = pMilliseconds * 1000L;
        long totalSecs = pMilliseconds / 1000L;
        long totalMins = totalSecs / 60L;
        long totalHours = totalMins / 60L;
        long totalDays = totalHours / 24L;
        this.iUSeconds = (int)(totalUSecs % 1000000L);
        this.iSeconds = (int)(totalSecs % 60L);
        this.iMinutes = (int)(totalMins % 60L);
        this.iHours = (int)(totalHours % 24L);
        this.iDays = (int)totalDays;
        this.iUnsignificantUSecDigits = 3;
        this.iAccuracyDivisor = USEC_ACCURACY_DIV_A[this.iUnsignificantUSecDigits];
        this.iTotalMicrosCalced = true;
        this.iTotalMicros = pMilliseconds * 1000L;
        CIMDateTimeInterval.debug("CIMDateTimeInterval(" + pMilliseconds + "): days=" + this.iDays + ", hours=" + this.iHours + ", mins=" + this.iMinutes + ", secs=" + this.iSeconds + ", usecs=" + this.iUSeconds + ", acc div=" + this.iAccuracyDivisor + ", unsig digits=" + this.iUnsignificantUSecDigits);
    }

    public CIMDateTimeInterval(String pIntervalString) throws IllegalArgumentException {
        if (pIntervalString == null) {
            throw new IllegalArgumentException("Null IntervalString is not allowed!");
        }
        if (pIntervalString.length() != 25) {
            throw new IllegalArgumentException("Length of " + pIntervalString + " must be " + 25 + ", " + pIntervalString.length() + " is not valid!");
        }
        String intervalStr = this.setAccuracy(pIntervalString);
        DTStringReader dtReader = new DTStringReader(intervalStr);
        this.iDays = dtReader.readAndCheck(8, "days", 0, 99999999, true);
        this.iHours = dtReader.readAndCheck(2, "hours", 0, 23, true);
        this.iMinutes = dtReader.readAndCheck(2, "minutes", 0, 59, true);
        this.iSeconds = dtReader.readAndCheck(2, "seconds", 0, 59, true);
        dtReader.read('.');
        this.iUSeconds = dtReader.readAndCheck(6, "microseconds", 0, 999999, false);
        if (this.iAccuracyDivisor >= 1000000L) {
            this.iUSeconds = -1;
        }
        dtReader.read(':');
        int zeros = dtReader.read(3, "zeros", false);
        if (zeros != 0) {
            String msg = "In " + pIntervalString + " the last 3 characters after ':' must be zeros!";
            throw new IllegalArgumentException(msg);
        }
        CIMDateTimeInterval.debug("CIMDateTimeInterval(\"" + pIntervalString + "\"): days=" + this.iDays + ", hours=" + this.iHours + ", mins=" + this.iMinutes + ", secs=" + this.iSeconds + ", usecs=" + this.iUSeconds + ", acc div=" + this.iAccuracyDivisor + ", unsig digits=" + this.iUnsignificantUSecDigits);
    }

    public int compareTo(CIMDateTime pObj) throws IllegalArgumentException {
        if (!(pObj instanceof CIMDateTimeInterval)) {
            String msg = "This method requires a CIMDateTimeInterval instance, while it has received a " + (pObj == null ? "null!" : pObj.getClass().getName() + " instance!");
            throw new IllegalArgumentException(msg);
        }
        CIMDateTimeInterval that = (CIMDateTimeInterval)pObj;
        long accuracyDivisor = Math.max(this.iAccuracyDivisor, that.iAccuracyDivisor);
        CIMDateTimeInterval.debug("this.acDiv=" + this.iAccuracyDivisor + ", that.acDiv=" + that.iAccuracyDivisor + ", acDiv=" + accuracyDivisor);
        Long thisMicros = this.calcMicros(accuracyDivisor);
        Long thatMicros = that.calcMicros(accuracyDivisor);
        CIMDateTimeInterval.debug("thisUs=" + thisMicros + ", thatUs=" + thatMicros);
        return thisMicros.compareTo(thatMicros);
    }

    public String getDateTimeString() {
        if (this.iStr != null) {
            return this.iStr;
        }
        DTStringWriter dtWriter = new DTStringWriter();
        dtWriter.write(8, this.iDays);
        dtWriter.write(2, this.iHours);
        dtWriter.write(2, this.iMinutes);
        dtWriter.write(2, this.iSeconds);
        dtWriter.write('.');
        dtWriter.writeUSec(this.iUSeconds / (int)this.iAccuracyDivisor, this.iUnsignificantUSecDigits);
        dtWriter.write(":000");
        return dtWriter.toString();
    }

    public int getDays() {
        return this.iDays;
    }

    public int getHours() {
        return this.iHours;
    }

    public int getMicroseconds() {
        return this.iUSeconds;
    }

    public int getMinutes() {
        return this.iMinutes;
    }

    public int getSeconds() {
        return this.iSeconds;
    }

    public long getTotalMilliseconds() {
        return this.getTotalMicros() / 1000L;
    }

    public int hashCode() {
        return this.getDateTimeString().hashCode();
    }

    public String toString() {
        return this.getDateTimeString();
    }

    private boolean checkGranularity(int pIdx, String pFieldName, int pFieldStartIdx, int pNextStartIdx) throws IllegalArgumentException {
        if (pIdx > pFieldStartIdx && pIdx < pNextStartIdx) {
            throw new IllegalArgumentException("Partial unsignificant digits are not allowed for field " + pFieldName + " in " + this.iStr + "!");
        }
        return pIdx == pFieldStartIdx;
    }

    private static int findStar(String pIvStr) {
        for (int i = 0; i < 21; ++i) {
            if (pIvStr.charAt(i) != '*') continue;
            return i;
        }
        return -1;
    }

    private static void checkStars(String pIvStr, int pStartIdx) {
        for (int i = pStartIdx; i < 21; ++i) {
            char ch = pIvStr.charAt(i);
            if (i == 14 || ch == '*') continue;
            throw new IllegalArgumentException("In " + pIvStr + " every digit character after the first '*' character must be '*', '" + ch + "' is invalid!");
        }
    }

    private String setAccuracy(String pIntervalStr) throws IllegalArgumentException {
        this.iStr = pIntervalStr;
        int startIdx = CIMDateTimeInterval.findStar(this.iStr);
        if (startIdx < 0) {
            return this.iStr;
        }
        CIMDateTimeInterval.checkStars(this.iStr, startIdx + 1);
        if (this.checkGranularity(startIdx, "Day", 0, 8)) {
            this.iAccuracyDivisor = 8640000000000000000L;
        } else if (this.checkGranularity(startIdx, "Hour", 8, 10)) {
            this.iAccuracyDivisor = 86400000000L;
        } else if (this.checkGranularity(startIdx, "Minute", 10, 12)) {
            this.iAccuracyDivisor = 3600000000L;
        } else if (this.checkGranularity(startIdx, "Second", 12, 14)) {
            this.iAccuracyDivisor = 60000000L;
        } else {
            this.iUnsignificantUSecDigits = 21 - startIdx;
            this.iAccuracyDivisor = USEC_ACCURACY_DIV_A[this.iUnsignificantUSecDigits];
        }
        char[] buf = this.iStr.toCharArray();
        if (startIdx < 15) {
            startIdx = 15;
        }
        for (int i = startIdx; i < 21; ++i) {
            if (i == 14) continue;
            if (this.iStr.charAt(i) != '*') {
                throw new IllegalArgumentException("All remaining digits must be marked as unsignificant in " + this.iStr + " !");
            }
            buf[i] = 48;
        }
        return new String(buf);
    }

    private long getTotalMicros() {
        if (this.iTotalMicrosCalced) {
            return this.iTotalMicros;
        }
        this.iTotalMicrosCalced = true;
        long l = this.iTotalMicros = this.iUSeconds > 0 ? (long)this.iUSeconds : 0L;
        if (this.iSeconds > 0) {
            this.iTotalMicros += 1000000L * (long)this.iSeconds;
        }
        if (this.iMinutes > 0) {
            this.iTotalMicros += 60000000L * (long)this.iMinutes;
        }
        if (this.iHours > 0) {
            this.iTotalMicros += 3600000000L * (long)this.iHours;
        }
        if (this.iDays > 0) {
            this.iTotalMicros += 86400000000L * (long)this.iDays;
        }
        CIMDateTimeInterval.debug("days=" + this.iDays + " ,hours=" + this.iHours + " ,mins=" + this.iMinutes + ", secs=" + this.iSeconds + ", usecs=" + this.iUSeconds + ", totalMicros=" + this.iTotalMicros);
        return this.iTotalMicros;
    }

    private long calcMicros(long pAccuracyDivisor) {
        long remainder = this.getTotalMicros() % pAccuracyDivisor;
        return this.getTotalMicros() - remainder;
    }

    private static boolean checkLimits(String pName, int pValue, int pLow, int pHigh, boolean pNotSignificant) throws IllegalArgumentException {
        if (pValue == -1) {
            return true;
        }
        if (pNotSignificant) {
            throw new IllegalArgumentException("Not significant fields must be followed by not significant fields!");
        }
        if (pValue < pLow || pValue > pHigh) {
            throw new IllegalArgumentException(pName + " must be between " + pLow + " and " + pHigh + ". " + pValue + " is invalid!");
        }
        return false;
    }

    private static void debug(String pMsg) {
    }
}

