/*
 * Decompiled with CFR 0.152.
 */
package javax.cim;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnsignedInteger32
extends Number
implements Comparable<UnsignedInteger32> {
    private static final long serialVersionUID = -8861436527534071393L;
    public static final long MAX_VALUE = 0xFFFFFFFFL;
    public static final long MIN_VALUE = 0L;
    private long iValue;

    private void setValue(long pValue) throws NumberFormatException {
        if (pValue > 0xFFFFFFFFL || pValue < 0L) {
            String msg = "uint32:" + pValue + " is out of range!";
            throw new NumberFormatException(msg);
        }
        this.iValue = pValue;
    }

    public UnsignedInteger32(long pValue) throws NumberFormatException {
        this.setValue(pValue);
    }

    public UnsignedInteger32(String pValue) throws NumberFormatException {
        if (pValue == null) {
            throw new IllegalArgumentException("String value cannot be null!");
        }
        this.setValue(Long.parseLong(pValue));
    }

    @Override
    public int compareTo(UnsignedInteger32 pOther) {
        if (pOther == null) {
            throw new IllegalArgumentException("Other UnsignedInteger32 cannot be null!");
        }
        UnsignedInteger32 that = pOther;
        long d = this.iValue - that.iValue;
        if (d == 0L) {
            return 0;
        }
        return d < 0L ? -1 : 1;
    }

    public boolean equals(Object pObj) {
        if (!(pObj instanceof UnsignedInteger32)) {
            return false;
        }
        return this.iValue == ((UnsignedInteger32)pObj).iValue;
    }

    @Override
    public byte byteValue() {
        return (byte)this.iValue;
    }

    @Override
    public double doubleValue() {
        return this.iValue;
    }

    @Override
    public float floatValue() {
        return this.iValue;
    }

    public int hashCode() {
        return Long.valueOf(this.iValue).hashCode();
    }

    @Override
    public int intValue() {
        return (int)this.iValue;
    }

    @Override
    public long longValue() {
        return this.iValue;
    }

    @Override
    public short shortValue() {
        return (short)this.iValue;
    }

    public String toString() {
        return Long.toString(this.iValue);
    }
}

