/*
 * Decompiled with CFR 0.152.
 */
package javax.cim;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnsignedInteger8
extends Number
implements Comparable<UnsignedInteger8> {
    private static final long serialVersionUID = 4392496278679167896L;
    public static final short MAX_VALUE = 255;
    public static final short MIN_VALUE = 0;
    private short iValue;

    private void setValue(short pValue) throws NumberFormatException {
        if (pValue > 255 || pValue < 0) {
            String msg = "uint8:" + pValue + " is out of range!";
            throw new NumberFormatException(msg);
        }
        this.iValue = pValue;
    }

    public UnsignedInteger8(short pValue) throws NumberFormatException {
        this.setValue(pValue);
    }

    public UnsignedInteger8(String pValue) throws NumberFormatException {
        if (pValue == null) {
            throw new IllegalArgumentException("String value cannot be null!");
        }
        this.setValue(Short.parseShort(pValue));
    }

    @Override
    public int compareTo(UnsignedInteger8 pOther) {
        if (pOther == null) {
            throw new IllegalArgumentException("Other UnsignedInteger8 cannot be null!");
        }
        UnsignedInteger8 that = pOther;
        int d = this.iValue - that.iValue;
        if (d == 0) {
            return 0;
        }
        return d < 0 ? -1 : 1;
    }

    public boolean equals(Object pObj) {
        if (!(pObj instanceof UnsignedInteger8)) {
            return false;
        }
        return this.iValue == ((UnsignedInteger8)pObj).iValue;
    }

    @Override
    public byte byteValue() {
        return (byte)this.iValue;
    }

    @Override
    public double doubleValue() {
        return this.iValue;
    }

    @Override
    public float floatValue() {
        return this.iValue;
    }

    public int hashCode() {
        return Short.valueOf(this.iValue).hashCode();
    }

    @Override
    public int intValue() {
        return this.iValue;
    }

    @Override
    public long longValue() {
        return this.iValue;
    }

    @Override
    public short shortValue() {
        return this.iValue;
    }

    public String toString() {
        return Short.toString(this.iValue);
    }
}

