/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.cimclient;

import java.io.IOException;
import java.net.BindException;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.wbem.listener.IndicationListener;
import javax.wbem.listener.WBEMListener;
import org.sblim.cimclient.IndicationListenerSBLIM;
import org.sblim.cimclient.internal.http.HttpConnectionHandler;
import org.sblim.cimclient.internal.http.HttpServerConnection;
import org.sblim.cimclient.internal.util.WBEMConfiguration;
import org.sblim.cimclient.internal.wbem.indications.CIMEventDispatcher;
import org.sblim.cimclient.internal.wbem.indications.CIMIndicationHandler;

public class WBEMListenerSBLIM
implements WBEMListener {
    protected final WBEMConfiguration iConfiguration = new WBEMConfiguration(new Properties());
    private Map<Integer, WBEMListenerImpl> iPortMap = new HashMap<Integer, WBEMListenerImpl>();

    public int addListener(IndicationListener pListener, int pPort, String pTransport) throws IOException {
        return this.addListener((EventListener)pListener, pPort, pTransport, null, null);
    }

    public int addListener(IndicationListener pListener, int pPort, String pTransport, String pLocalAddr) throws IOException {
        return this.addListener((EventListener)pListener, pPort, pTransport, pLocalAddr, null);
    }

    public int addListener(IndicationListener pListener, int pPort, String pTransport, String pLocalAddr, Properties pConfigurationProperties) throws IOException {
        return this.addListener((EventListener)pListener, pPort, pTransport, pLocalAddr, pConfigurationProperties);
    }

    public int addListener(IndicationListenerSBLIM pListener, int pPort, String pTransport) throws IOException {
        return this.addListener((EventListener)pListener, pPort, pTransport, null, null);
    }

    public int addListener(IndicationListenerSBLIM pListener, int pPort, String pTransport, String pLocalAddr) throws IOException {
        return this.addListener((EventListener)pListener, pPort, pTransport, pLocalAddr, null);
    }

    public int addListener(IndicationListenerSBLIM pListener, int pPort, String pTransport, String pLocalAddr, Properties pConfigurationProperties) throws IOException {
        return this.addListener((EventListener)pListener, pPort, pTransport, pLocalAddr, pConfigurationProperties);
    }

    private synchronized int addListener(EventListener pListener, int pPort, String pTransport, String pLocalAddr, Properties pConfigurationProperties) throws IOException {
        boolean ssl;
        if (pPort > 0 && this.iPortMap.containsKey(pPort)) {
            throw new BindException("Port already in use.");
        }
        if (pTransport.equalsIgnoreCase("HTTP")) {
            ssl = false;
        } else if (pTransport.equalsIgnoreCase("HTTPS")) {
            ssl = true;
        } else {
            throw new IllegalArgumentException("Unknown transport: " + pTransport + "! Valid values are http and https.");
        }
        WBEMListenerImpl listener = new WBEMListenerImpl(pLocalAddr, pPort, ssl, pListener, pConfigurationProperties);
        listener.start();
        this.iPortMap.put(listener.getListenerPort(), listener);
        return listener.getListenerPort();
    }

    public String getBlockedIPs(int pPort) {
        if (pPort <= 0 || !this.iPortMap.containsKey(pPort)) {
            throw new IllegalArgumentException("Port not in use.");
        }
        WBEMListenerImpl listener = this.iPortMap.get(pPort);
        return listener != null ? listener.getBlockedIPs() : null;
    }

    public String getProperty(String pName) {
        if (pName.startsWith("javax.wbem.")) {
            if (pName.equals("javax.wbem.listener.keyStore")) {
                return this.iConfiguration.getSslKeyStorePath();
            }
            if (pName.equals("javax.wbem.listener.keyStorePassword")) {
                return this.iConfiguration.getSslKeyStorePassword();
            }
            if (pName.equals("javax.wbem.listener.trustStore")) {
                return this.iConfiguration.getSslTrustStorePath();
            }
            return null;
        }
        return this.iConfiguration.getDomainProperty(pName);
    }

    public synchronized void removeListener(int pPort) {
        WBEMListenerImpl listener = this.iPortMap.remove(pPort);
        if (listener != null) {
            listener.stop();
        }
    }

    public void setBlockedIPs(int pPort, String pIPs) {
        if (pPort <= 0 || !this.iPortMap.containsKey(pPort)) {
            throw new IllegalArgumentException("Port not in use.");
        }
        WBEMListenerImpl listener = this.iPortMap.get(pPort);
        if (listener != null) {
            listener.setBlockedIPs(pIPs);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setProperty(String pName, String pValue) {
        if (pName.startsWith("javax.wbem.")) {
            if (pName.equals("javax.wbem.listener.keyStore")) {
                this.iConfiguration.setDomainProperty("javax.net.ssl.keyStore", pValue);
                return;
            } else if (pName.equals("javax.wbem.listener.keyStorePassword")) {
                this.iConfiguration.setDomainProperty("javax.net.ssl.keyStorePassword", pValue);
                return;
            } else {
                if (!pName.equals("javax.wbem.listener.trustStore")) throw new IllegalArgumentException(pName);
                this.iConfiguration.setDomainProperty("javax.net.ssl.trustStore", pValue);
            }
            return;
        } else {
            this.iConfiguration.setDomainProperty(pName, pValue);
        }
    }

    public class WBEMListenerImpl {
        private EventListener iIndicationListener;
        private HttpServerConnection iConnection;
        private CIMIndicationHandler iIndicationHandler;
        private HttpConnectionHandler iConnectionHandler;

        public WBEMListenerImpl(String pLocalAddress, int pPort, boolean pSSL, EventListener pIndicationListener, Properties pProperties) throws IOException {
            if (pProperties != null) {
                Enumeration<Object> e = pProperties.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    String value = pProperties.getProperty(key);
                    WBEMListenerSBLIM.this.setProperty(key, value);
                }
            }
            WBEMConfiguration config = WBEMListenerSBLIM.this.iConfiguration;
            if (!(pIndicationListener instanceof IndicationListener) && !(pIndicationListener instanceof IndicationListenerSBLIM)) {
                throw new IllegalArgumentException("Listener must be instance of IndicationListener or IndicationListenerSBLIM");
            }
            this.iIndicationListener = pIndicationListener;
            CIMEventDispatcher eventDispatcher = new CIMEventDispatcher(this.iIndicationListener, config.getListenerMaxQueuedEvents());
            this.iIndicationHandler = new CIMIndicationHandler(eventDispatcher, config);
            this.iConnectionHandler = new HttpConnectionHandler(this.iIndicationHandler, config);
            this.iConnection = new HttpServerConnection(this.iConnectionHandler, pLocalAddress, pPort, pSSL, config);
        }

        protected void finalize() throws Throwable {
            try {
                this.stop();
            }
            finally {
                super.finalize();
            }
        }

        public void start() {
            this.iConnection.start();
        }

        public void stop() {
            this.iConnection.close();
            this.iIndicationHandler.close();
        }

        public IndicationListener getIndicationListener() {
            return this.iIndicationListener instanceof IndicationListener ? (IndicationListener)this.iIndicationListener : null;
        }

        public IndicationListenerSBLIM getIndicationListenerSBLIM() {
            return this.iIndicationListener instanceof IndicationListenerSBLIM ? (IndicationListenerSBLIM)this.iIndicationListener : null;
        }

        public int getListenerPort() {
            return this.iConnection.getPort();
        }

        public String getBlockedIPs() {
            return this.iConnectionHandler.getBlockedIPs();
        }

        public void setBlockedIPs(String pIPs) {
            this.iConnectionHandler.setBlockedIPs(pIPs);
        }
    }
}

