/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.cimclient.internal.cim;

import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.cim.UnsignedInteger64;
import javax.cim.UnsignedInteger8;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CIMHelper {
    private static CIMDataType[] CIMScalarDataTypes = new CIMDataType[]{CIMDataType.UINT8_T, CIMDataType.SINT8_T, CIMDataType.UINT16_T, CIMDataType.SINT16_T, CIMDataType.UINT32_T, CIMDataType.SINT32_T, CIMDataType.UINT64_T, CIMDataType.SINT64_T, CIMDataType.STRING_T, CIMDataType.BOOLEAN_T, CIMDataType.REAL32_T, CIMDataType.REAL64_T, CIMDataType.DATETIME_T, CIMDataType.CHAR16_T, new CIMDataType(""), CIMDataType.OBJECT_T, null, CIMDataType.CLASS_T};
    private static CIMDataType[] CIMArrayDataTypes = new CIMDataType[]{CIMDataType.UINT8_ARRAY_T, CIMDataType.SINT8_ARRAY_T, CIMDataType.UINT16_ARRAY_T, CIMDataType.SINT16_ARRAY_T, CIMDataType.UINT32_ARRAY_T, CIMDataType.SINT32_ARRAY_T, CIMDataType.UINT64_ARRAY_T, CIMDataType.SINT64_ARRAY_T, CIMDataType.STRING_ARRAY_T, CIMDataType.BOOLEAN_ARRAY_T, CIMDataType.REAL32_ARRAY_T, CIMDataType.REAL64_ARRAY_T, CIMDataType.DATETIME_ARRAY_T, CIMDataType.CHAR16_ARRAY_T, new CIMDataType("", 0), CIMDataType.OBJECT_ARRAY_T, null, CIMDataType.CLASS_ARRAY_T};

    private CIMHelper() {
    }

    public static URI createCimomUri(CIMObjectPath pPath) throws URISyntaxException {
        String scheme = pPath.getScheme();
        String host = pPath.getHost();
        int port = 5988;
        try {
            port = Integer.parseInt(pPath.getPort());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return new URI(scheme, null, host, port, "/cimom", null, null);
    }

    public static URI createCimomUri(URI pUri) throws URISyntaxException {
        String scheme = pUri.getScheme();
        String host = pUri.getHost();
        int port = pUri.getPort();
        if (port == -1) {
            port = 5988;
        }
        return new URI(scheme, null, host, port, "/cimom", null, null);
    }

    public static CIMDataType ScalarDataType(int pType) {
        if (pType < 0 || pType >= CIMScalarDataTypes.length) {
            return null;
        }
        return CIMScalarDataTypes[pType];
    }

    public static CIMDataType UnboundedArrayDataType(int pType) {
        if (pType < 0 || pType >= CIMArrayDataTypes.length) {
            return null;
        }
        return CIMArrayDataTypes[pType];
    }

    public static CIMInstance CIMInstanceWithSynchonizedNumericKeyDataTypes(CIMObjectPath pObjectPath, CIMProperty<?>[] pProps) {
        CIMInstance inst = new CIMInstance(pObjectPath, pProps);
        CIMProperty<?>[] oldKeys = inst.getKeys();
        CIMProperty[] newKeys = new CIMProperty[oldKeys.length];
        boolean update = false;
        for (int i = 0; i < oldKeys.length; ++i) {
            CIMDataType oldType = oldKeys[i].getDataType();
            CIMProperty<?> prop = inst.getProperty(oldKeys[i].getName());
            if (oldType != null && prop != null && prop.getDataType() != null && !prop.getDataType().equals(oldType) && CIMHelper.isNumericObject(oldType) && CIMHelper.isNumericObject(prop.getDataType())) {
                update = true;
                newKeys[i] = new CIMProperty<Object>(oldKeys[i].getName(), prop.getDataType(), CIMHelper.translateNumericObject(oldKeys[i].getValue(), oldType, prop.getDataType()), oldKeys[i].isKey(), oldKeys[i].isPropagated(), oldKeys[i].getOriginClass());
                continue;
            }
            newKeys[i] = oldKeys[i];
        }
        return update ? inst.deriveInstance(new CIMObjectPath(pObjectPath.getScheme(), pObjectPath.getHost(), pObjectPath.getPort(), pObjectPath.getNamespace(), pObjectPath.getObjectName(), newKeys)) : inst;
    }

    private static boolean isNumericObject(CIMDataType type) {
        switch (type.getType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    private static Object translateNumericObject(Object oldValue, CIMDataType oldType, CIMDataType newType) {
        if (oldValue == null) {
            return null;
        }
        int from = oldType.getType();
        int to = newType.getType();
        long newInt = 0L;
        double newDec = 0.0;
        Number o = null;
        boolean useInt = true;
        switch (from) {
            case 1: {
                Byte b = (Byte)oldValue;
                newInt = b.longValue();
                break;
            }
            case 3: {
                Short s = (Short)oldValue;
                newInt = s.longValue();
                break;
            }
            case 5: {
                Integer i = (Integer)oldValue;
                newInt = i.longValue();
                break;
            }
            case 7: {
                Long l = (Long)oldValue;
                newInt = l;
                break;
            }
            case 0: {
                UnsignedInteger8 u8 = (UnsignedInteger8)oldValue;
                newInt = u8.longValue();
                break;
            }
            case 2: {
                UnsignedInteger16 u16 = (UnsignedInteger16)oldValue;
                newInt = u16.longValue();
                break;
            }
            case 4: {
                UnsignedInteger32 u32 = (UnsignedInteger32)oldValue;
                newInt = u32.longValue();
                break;
            }
            case 6: {
                UnsignedInteger64 u64 = (UnsignedInteger64)oldValue;
                newInt = u64.longValue();
                break;
            }
            case 10: {
                Float f = (Float)oldValue;
                newDec = f.doubleValue();
                useInt = false;
                break;
            }
            case 11: {
                Double d = (Double)oldValue;
                newDec = d;
                useInt = false;
            }
        }
        switch (to) {
            case 1: {
                byte b = (byte)(useInt ? (double)newInt : newDec);
                o = new Byte(b);
                break;
            }
            case 3: {
                short s = (short)(useInt ? (double)newInt : newDec);
                o = new Short(s);
                break;
            }
            case 5: {
                int i = (int)(useInt ? (double)newInt : newDec);
                o = new Integer(i);
                break;
            }
            case 7: {
                long l = (long)(useInt ? (double)newInt : newDec);
                o = new Long(l);
                break;
            }
            case 0: {
                byte u8 = (byte)(useInt ? (double)newInt : newDec);
                o = new UnsignedInteger8(u8);
                break;
            }
            case 2: {
                short u16 = (short)(useInt ? (double)newInt : newDec);
                o = new UnsignedInteger16(u16);
                break;
            }
            case 4: {
                int u32 = (int)(useInt ? (double)newInt : newDec);
                o = new UnsignedInteger32(u32);
                break;
            }
            case 6: {
                long u64 = (long)(useInt ? (double)newInt : newDec);
                o = new UnsignedInteger64(BigInteger.valueOf(u64));
                break;
            }
            case 10: {
                float f = (float)(useInt ? (double)newInt : newDec);
                o = new Float(f);
                break;
            }
            case 11: {
                double d = useInt ? (double)newInt : newDec;
                o = new Double(d);
            }
        }
        return o;
    }
}

