/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.cimclient.internal.cim;

import javax.cim.UnsignedInteger8;

public class CIMOctetString {
    private UnsignedInteger8[] iBytes;
    private String iASCIIString;
    private char iReplacementChar;
    private String iHexString;
    private int iLength;

    public CIMOctetString(UnsignedInteger8[] pBytes) throws IllegalArgumentException {
        int i;
        if (pBytes == null || pBytes.length < 4) {
            throw new IllegalArgumentException("Array of bytes must contain at least four bytes");
        }
        for (i = pBytes.length - 1; i >= 0; --i) {
            if (pBytes[i] != null) continue;
            throw new IllegalArgumentException("Array of bytes must not contain any null bytes");
        }
        this.iLength = pBytes[3].byteValue() + pBytes[2].byteValue() * 256 + pBytes[1].byteValue() * 65536 + pBytes[0].byteValue() * 0x1000000;
        if (this.iLength != pBytes.length) {
            throw new IllegalArgumentException("Array of bytes contains invalid length: found " + this.iLength + ", expected " + pBytes.length);
        }
        this.iBytes = new UnsignedInteger8[this.iLength];
        for (i = this.iLength - 1; i >= 0; --i) {
            this.iBytes[i] = pBytes[i];
        }
    }

    public CIMOctetString(String pString, boolean pIsHex) throws IllegalArgumentException {
        if (pString == null) {
            throw new IllegalArgumentException("String cannot be null");
        }
        if (pIsHex) {
            if (pString.length() < 10) {
                throw new IllegalArgumentException("Hexadecimal string must contain \"0x\" and at least four pairs of hex digits");
            }
            if (pString.charAt(0) != '0' || pString.charAt(1) != 'x') {
                throw new IllegalArgumentException("Hexadecimal string must begin with \"0x\"");
            }
            try {
                this.iLength = Integer.parseInt(pString.substring(2, 10), 16);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Hexadecimal string length could not be parsed: " + e.toString());
            }
            if (this.iLength * 2 + 2 != pString.length()) {
                throw new IllegalArgumentException("Hexadecimal string contains invalid length: found " + this.iLength + ", expected " + (pString.length() - 1));
            }
            for (int i = pString.length() - 1; i >= 10; --i) {
                char ch = pString.charAt(i);
                if (ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'f' || ch >= 'A' && ch <= 'F') continue;
                throw new IllegalArgumentException("Hexadecimal string could not be parsed, invalid character '" + ch + "' at index " + i);
            }
            this.iHexString = new String(pString);
        } else {
            this.iLength = pString.length() + 4;
            this.iASCIIString = new String(pString);
            this.iReplacementChar = (char)255;
        }
    }

    public synchronized boolean equals(Object pObj) {
        int i;
        if (!(pObj instanceof CIMOctetString)) {
            return false;
        }
        CIMOctetString that = (CIMOctetString)pObj;
        int numCompares = 0;
        if (this.iLength != that.iLength) {
            return false;
        }
        if (this.iBytes != null && that.iBytes != null) {
            for (i = this.iLength - 1; i >= 0; --i) {
                if (this.iBytes[i].byteValue() == that.iBytes[i].byteValue()) continue;
                return false;
            }
            ++numCompares;
        }
        if (this.iHexString != null && that.iHexString != null) {
            if (!this.iHexString.equalsIgnoreCase(that.iHexString)) {
                return false;
            }
            ++numCompares;
        }
        if (this.iASCIIString != null && that.iASCIIString != null && this.iReplacementChar == that.iReplacementChar) {
            if (!this.iASCIIString.equalsIgnoreCase(that.iASCIIString)) {
                return false;
            }
            ++numCompares;
        }
        if (numCompares > 0) {
            return true;
        }
        if (this.iBytes != null && that.iBytes == null) {
            that.getBytes();
            if (this.iBytes != null && that.iBytes != null) {
                for (i = this.iLength - 1; i >= 0; --i) {
                    if (this.iBytes[i].byteValue() == that.iBytes[i].byteValue()) continue;
                    return false;
                }
                ++numCompares;
            }
        }
        if (numCompares > 0) {
            return true;
        }
        if (this.iBytes == null && that.iBytes != null) {
            this.getBytes();
            if (this.iBytes != null && that.iBytes != null) {
                for (i = this.iLength - 1; i >= 0; --i) {
                    if (this.iBytes[i].byteValue() == that.iBytes[i].byteValue()) continue;
                    return false;
                }
                ++numCompares;
            }
        }
        if (numCompares > 0) {
            return true;
        }
        if (this.iHexString != null && that.iHexString == null) {
            that.getHexString();
            if (this.iHexString != null && that.iHexString != null) {
                if (!this.iHexString.equalsIgnoreCase(that.iHexString)) {
                    return false;
                }
                ++numCompares;
            }
        }
        if (numCompares > 0) {
            return true;
        }
        if (this.iHexString == null && that.iHexString != null) {
            this.getHexString();
            if (this.iHexString != null && that.iHexString != null) {
                if (!this.iHexString.equalsIgnoreCase(that.iHexString)) {
                    return false;
                }
                ++numCompares;
            }
        }
        return numCompares > 0;
    }

    public synchronized String getASCIIString(char pReplacementChar) {
        if (this.iASCIIString != null && this.iReplacementChar == '\u00ff') {
            return this.iASCIIString;
        }
        if (pReplacementChar <= '\u001f' || pReplacementChar >= '\u007f') {
            throw new IllegalArgumentException("Replacement character not printable");
        }
        if (this.iASCIIString != null && this.iReplacementChar == pReplacementChar) {
            return this.iASCIIString;
        }
        StringBuilder str = new StringBuilder("");
        if (this.iBytes != null) {
            for (int i = 4; i < this.iBytes.length; ++i) {
                char ch = (char)this.iBytes[i].byteValue();
                if (ch <= '\u001f' || ch >= '\u007f') {
                    str.append(pReplacementChar);
                    continue;
                }
                str.append(ch);
            }
        } else {
            for (int i = 10; i < this.iHexString.length(); i += 2) {
                char ch = (char)Integer.parseInt(this.iHexString.substring(i, i + 2), 16);
                if (ch <= '\u001f' || ch >= '\u007f') {
                    str.append(pReplacementChar);
                    continue;
                }
                str.append(ch);
            }
        }
        this.iASCIIString = new String(str);
        this.iReplacementChar = pReplacementChar;
        return this.iASCIIString;
    }

    public synchronized UnsignedInteger8[] getBytes() {
        if (this.iBytes != null) {
            return this.iBytes;
        }
        if (this.iHexString != null) {
            this.convertHexStringToBytes();
        } else {
            this.convertASCIIStringToBytes();
        }
        return this.iBytes;
    }

    public synchronized String getHexString() {
        if (this.iHexString != null) {
            return this.iHexString;
        }
        if (this.iBytes != null) {
            this.convertBytesToHexString();
        } else {
            this.convertASCIIStringToHexString();
        }
        return this.iHexString;
    }

    public int hashCode() {
        return this.toString().toLowerCase().hashCode();
    }

    public int length() {
        return this.iLength;
    }

    public String toString() {
        return this.getHexString();
    }

    private void convertBytesToHexString() {
        int i;
        StringBuilder str = new StringBuilder("0x");
        String len = Integer.toHexString(this.iLength);
        for (i = 8 - len.length(); i > 0; --i) {
            str.append('0');
        }
        str.append(len);
        for (i = 4; i < this.iLength; ++i) {
            String octet = Integer.toHexString(this.iBytes[i].intValue());
            if (octet.length() == 1) {
                str.append('0');
            }
            str.append(octet);
        }
        this.iHexString = new String(str);
    }

    private void convertHexStringToBytes() {
        this.iBytes = new UnsignedInteger8[this.iLength];
        int idxByte = 0;
        int len = this.iHexString.length();
        for (int idxStr = 2; idxStr < len; idxStr += 2) {
            short s;
            try {
                s = Short.parseShort(this.iHexString.substring(idxStr, idxStr + 2), 16);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Hex string length could not be parsed: " + e.toString());
            }
            this.iBytes[idxByte] = new UnsignedInteger8(s);
            ++idxByte;
        }
    }

    private void convertASCIIStringToBytes() {
        this.iBytes = new UnsignedInteger8[this.iLength];
        this.iBytes[0] = new UnsignedInteger8((short)(this.iLength >> 24 & 0xFF));
        this.iBytes[1] = new UnsignedInteger8((short)(this.iLength >> 16 & 0xFF));
        this.iBytes[2] = new UnsignedInteger8((short)(this.iLength >> 8 & 0xFF));
        this.iBytes[3] = new UnsignedInteger8((short)(this.iLength & 0xFF));
        int idxStr = 0;
        int idxByte = 4;
        while (idxStr < this.iASCIIString.length()) {
            this.iBytes[idxByte] = new UnsignedInteger8((short)this.iASCIIString.charAt(idxStr));
            ++idxStr;
            ++idxByte;
        }
    }

    private void convertASCIIStringToHexString() {
        StringBuilder str = new StringBuilder("0x");
        String len = Integer.toHexString(this.iLength);
        for (int i = 8 - len.length(); i > 0; --i) {
            str.append('0');
        }
        str.append(len);
        int idxAsc = 0;
        int idxHex = 10;
        while (idxAsc < this.iASCIIString.length()) {
            String octet = Integer.toHexString(this.iASCIIString.charAt(idxAsc));
            if (octet.length() == 1) {
                str.append('0');
            }
            str.append(octet);
            ++idxAsc;
            ++idxHex;
        }
        this.iHexString = new String(str);
    }
}

