/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.cimclient.internal.cimxml;

import java.io.StringReader;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Level;
import javax.cim.CIMArgument;
import javax.cim.CIMClass;
import javax.cim.CIMClassProperty;
import javax.cim.CIMDataType;
import javax.cim.CIMDateTime;
import javax.cim.CIMDateTimeAbsolute;
import javax.cim.CIMDateTimeInterval;
import javax.cim.CIMInstance;
import javax.cim.CIMMethod;
import javax.cim.CIMNamedElementInterface;
import javax.cim.CIMObjectPath;
import javax.cim.CIMParameter;
import javax.cim.CIMProperty;
import javax.cim.CIMQualifier;
import javax.cim.CIMQualifierType;
import javax.cim.CIMTypedElement;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.cim.UnsignedInteger64;
import javax.cim.UnsignedInteger8;
import javax.wbem.WBEMException;
import org.sblim.cimclient.internal.cim.CIMHelper;
import org.sblim.cimclient.internal.cim.CIMQualifiedElementInterfaceImpl;
import org.sblim.cimclient.internal.cimxml.CIMClientXML_HelperImpl;
import org.sblim.cimclient.internal.cimxml.CIMMessage;
import org.sblim.cimclient.internal.cimxml.CIMRequest;
import org.sblim.cimclient.internal.cimxml.CIMResponse;
import org.sblim.cimclient.internal.cimxml.CIMXMLParseException;
import org.sblim.cimclient.internal.cimxml.LocalPathBuilder;
import org.sblim.cimclient.internal.cimxml.TypedValue;
import org.sblim.cimclient.internal.logging.LogAndTraceBroker;
import org.sblim.cimclient.internal.util.Util;
import org.sblim.cimclient.internal.util.WBEMConfiguration;
import org.sblim.cimclient.internal.util.XMLHostStr;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CIMXMLParserImpl {
    private static LocalPathBuilder cLocalPathBuilder = new LocalPathBuilder(null);
    private static final String[] nodesVALUENAMEDINSTANCE = new String[]{"INSTANCENAME", "INSTANCE"};
    private static final String[] nodesVALUEINSTANCEWITHPATH = new String[]{"INSTANCEPATH", "INSTANCE"};
    private static final String[] nodesVALUENAMEDOBJECTi = new String[]{"INSTANCENAME", "INSTANCE"};
    private static final String[] nodesVALUEOBJECTWITHPATHcls = new String[]{"CLASSPATH", "CLASS"};
    private static final String[] nodesVALUEOBJECTWITHPATHins = new String[]{"INSTANCEPATH", "INSTANCE"};
    private static final String[] nodesVALUEOBJECTWITHLOCALPATHcls = new String[]{"LOCALCLASSPATH", "CLASS"};
    private static final String[] nodesVALUEOBJECTWITHLOCALPATHins = new String[]{"LOCALINSTANCEPATH", "INSTANCE"};
    private static final String[] nodesNAMESPACEPATH = new String[]{"HOST", "LOCALNAMESPACEPATH"};
    private static final String[] nodesNAMESPACE = new String[0];
    private static final String[] nodesCLASSPATH = new String[]{"NAMESPACEPATH", "CLASSNAME"};
    private static final String[] nodesLOCALCLASSPATH = new String[]{"LOCALNAMESPACEPATH", "CLASSNAME"};
    private static final String[] nodesCLASSNAME = new String[0];
    private static final String[] nodesINSTANCEPATH = new String[]{"NAMESPACEPATH", "INSTANCENAME"};
    private static final String[] nodesLOCALINSTANCEPATH = new String[]{"LOCALNAMESPACEPATH", "INSTANCENAME"};
    private static final String[] nodesINSTANCENAME = new String[]{"KEYBINDING", "KEYVALUE", "VALUE.REFERENCE"};
    private static final TreeMap<String, CIMDataType> TYPESTR_MAP = new TreeMap(new Comparator<Object>(){

        @Override
        public int compare(Object pO1, Object pO2) {
            return ((String)pO1).compareToIgnoreCase((String)pO2);
        }
    });
    private static final String[] nodesCLASS;
    private static final String[] nodesMETHOD;
    private static final String[] nodesPARAMETER;
    private static final String[] nodesPARAMETERREFERENCE;
    private static final String[] nodesPARAMETERARRAY;
    private static final String[] nodesPARAMETERREFARRAY;
    private static final String[] nodesINSTANCE;
    private static final int VALUE = 1;
    private static final int VALUEA = 2;
    private static final int VALUEREF = 4;
    private static final int VALUEREFA = 8;
    private static final String[] nodesQUALIFIER;
    private static final String[] nodesPROPERTY;
    private static final String[] nodesPROPERTYARRAY;
    private static final String[] nodesPROPERTYREFERENCE;
    private static final String[] nodesPARAMVALUE;
    private static final String[] nodesIPARAMVALUE;
    private static final String[] nodesSIMPLEREQ;
    private static final String[] nodesMETHODCALL;
    private static final String[] nodesIMETHODCALL;
    private static final String[] nodesSIMPLEEXPREQ;
    private static final String[] nodesEXPMETHODCALL;
    private static final String[] nodesEXPPARAMVALUE;
    private static final String[] nodesMETHODRESPONSE;
    private static final String[] nodesIMETHODRESPONSE;
    private static final String[] nodesERROR;
    private static final String[] nodesRETURNVALUE;
    private static final String[] nodesIRETURNVALUE;
    private static final HashMap<String, String> NODENAME_HASH;
    private static final String[] nodesEXPMETHODRESPONSE;
    private static final String[] nodesCORRELATOR;

    public static void setLocalObjectPath(CIMObjectPath pLocalOp) {
        cLocalPathBuilder = new LocalPathBuilder(pLocalOp);
    }

    public static CIMMessage parseCIM(Element pCimE) throws CIMXMLParseException {
        Attr cim_cimversionA = (Attr)CIMXMLParserImpl.searchAttribute(pCimE, "CIMVERSION");
        if (cim_cimversionA == null) {
            throw new CIMXMLParseException("CIM element missing CIMVERSION attribute!");
        }
        String cimversion = cim_cimversionA.getNodeValue();
        Attr cim_dtdversionA = (Attr)CIMXMLParserImpl.searchAttribute(pCimE, "DTDVERSION");
        if (cim_dtdversionA == null) {
            throw new CIMXMLParseException("CIM element missing DTDVERSION attribute!");
        }
        String dtdversion = cim_dtdversionA.getNodeValue();
        Element[] messageA = CIMXMLParserImpl.searchNodes(pCimE, "MESSAGE", 0, 1, false);
        if (messageA != null) {
            CIMMessage message = CIMXMLParserImpl.parseMESSAGE(cimversion, dtdversion, messageA[0]);
            message.setCIMVersion(cimversion);
            message.setDTDVersion(dtdversion);
            return message;
        }
        if (CIMXMLParserImpl.searchNodes(pCimE, "DECLARATION", 0, 1, false) != null) {
            throw new CIMXMLParseException("DECLARATION element not supported!");
        }
        throw new CIMXMLParseException("CIM element missing required child element!");
    }

    public static TypedValue parseVALUE(Element pValueE) throws CIMXMLParseException {
        String typeStr = CIMXMLParserImpl.attribute(pValueE, "TYPE");
        CIMDataType type = typeStr == null ? null : CIMXMLParserImpl.parseScalarTypeStr(typeStr);
        NodeList list = pValueE.getChildNodes();
        StringBuilder valueStr = new StringBuilder();
        for (int i = 0; i < list.getLength(); ++i) {
            String nodeValue;
            Text t = (Text)list.item(i);
            if (t == null || (nodeValue = t.getNodeValue()) == null) continue;
            valueStr.append(nodeValue);
        }
        return new TypedValue(type, valueStr.toString());
    }

    public static TypedValue parseVALUEARRAY(Element pValueArrayE) throws CIMXMLParseException {
        String typeStr = CIMXMLParserImpl.attribute(pValueArrayE, "TYPE");
        CIMDataType type = typeStr == null ? null : CIMXMLParserImpl.parseArrayTypeStr(typeStr);
        NodeList nl = pValueArrayE.getChildNodes();
        if (nl == null || nl.getLength() == 0) {
            return new TypedValue(type, new String[0]);
        }
        Vector<String> resStringV = new Vector<String>();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n instanceof Text && "".equalsIgnoreCase(n.getNodeValue().trim())) continue;
            String name = n.getNodeName();
            if (name.equals("VALUE")) {
                resStringV.add((String)CIMXMLParserImpl.parseVALUE((Element)n).getValue());
                continue;
            }
            if (name.equals("VALUE.NULL")) {
                resStringV.add(null);
                continue;
            }
            if (!NODENAME_HASH.containsKey(name)) continue;
            throw new CIMXMLParseException("VALUE.ARRAY element contains invalid child element " + name + "!");
        }
        return new TypedValue(type, resStringV.toArray(new String[0]));
    }

    public static CIMObjectPath parseVALUEREFERENCE(Element pValuereferenceE) throws CIMXMLParseException {
        Element[] classpathA = CIMXMLParserImpl.searchNodes(pValuereferenceE, "CLASSPATH", 0, 1, false);
        if (classpathA != null) {
            CIMObjectPath op = CIMXMLParserImpl.parseCLASSPATH(classpathA[0]);
            return op;
        }
        Element[] localclasspathA = CIMXMLParserImpl.searchNodes(pValuereferenceE, "LOCALCLASSPATH", 0, 1, false);
        if (localclasspathA != null) {
            CIMObjectPath op = CIMXMLParserImpl.parseLOCALCLASSPATH(localclasspathA[0]);
            return op;
        }
        Element[] classnameA = CIMXMLParserImpl.searchNodes(pValuereferenceE, "CLASSNAME", 0, 1, false);
        if (classnameA != null) {
            CIMObjectPath op = CIMXMLParserImpl.parseCLASSNAME(classnameA[0]);
            if (op != null && op.getNamespace() != null) {
                op = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), null, op.getObjectName(), op.getKeys(), op.getXmlSchemaName());
            }
            return op;
        }
        Element[] instancepathA = CIMXMLParserImpl.searchNodes(pValuereferenceE, "INSTANCEPATH", 0, 1, false);
        if (instancepathA != null) {
            CIMObjectPath op = CIMXMLParserImpl.parseINSTANCEPATH(instancepathA[0]);
            return op;
        }
        Element[] localinstancepathA = CIMXMLParserImpl.searchNodes(pValuereferenceE, "LOCALINSTANCEPATH", 0, 1, false);
        if (localinstancepathA != null) {
            CIMObjectPath op = CIMXMLParserImpl.parseLOCALINSTANCEPATH(localinstancepathA[0]);
            return op;
        }
        Element[] instancenameA = CIMXMLParserImpl.searchNodes(pValuereferenceE, "INSTANCENAME", 0, 1, false);
        if (instancenameA != null) {
            CIMObjectPath op = CIMXMLParserImpl.parseINSTANCENAME(instancenameA[0]);
            if (op != null && op.getNamespace() != null) {
                op = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), null, op.getObjectName(), op.getKeys(), op.getXmlSchemaName());
            }
            return op;
        }
        throw new CIMXMLParseException("VALUE.REFERENCE element missing required child element!");
    }

    public static CIMObjectPath[] parseVALUEREFARRAY(Element pValueRefArrayE) throws CIMXMLParseException {
        NodeList nl = pValueRefArrayE.getChildNodes();
        if (nl == null || nl.getLength() == 0) {
            return new CIMObjectPath[0];
        }
        Vector<CIMObjectPath> resObjectPathV = new Vector<CIMObjectPath>();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n instanceof Text && "".equalsIgnoreCase(n.getNodeValue().trim())) continue;
            String name = n.getNodeName();
            if (name.equals("VALUE.REFERENCE")) {
                resObjectPathV.add(CIMXMLParserImpl.parseVALUEREFERENCE((Element)n));
                continue;
            }
            if (name.equals("VALUE.NULL")) {
                resObjectPathV.add(null);
                continue;
            }
            if (!NODENAME_HASH.containsKey(name)) continue;
            throw new CIMXMLParseException("VALUE.REFARRAY element contains invalid child element " + name + "!");
        }
        return resObjectPathV.toArray(new CIMObjectPath[0]);
    }

    public static CIMNamedElementInterface parseVALUEOBJECT(Element pValueObjectE) throws CIMXMLParseException {
        Element[] classA = CIMXMLParserImpl.searchNodes(pValueObjectE, "CLASS", 0, 1, false);
        if (classA != null) {
            CIMClass obj = CIMXMLParserImpl.parseCLASS(classA[0]);
            return obj;
        }
        Element[] instanceA = CIMXMLParserImpl.searchNodes(pValueObjectE, "INSTANCE", 0, 1, false);
        if (instanceA != null) {
            CIMInstance obj = CIMXMLParserImpl.parseINSTANCE(instanceA[0]);
            return obj;
        }
        throw new CIMXMLParseException("VALUE.OBJECT element missing required child element!");
    }

    public static CIMInstance parseVALUENAMEDINSTANCE(Element pValueNamedInstanceE) throws CIMXMLParseException {
        Element[] instancenameA = CIMXMLParserImpl.searchNodes(pValueNamedInstanceE, "INSTANCENAME", 1, 1, true);
        if (instancenameA == null) {
            throw new CIMXMLParseException("VALUE.NAMEDINSTANCE element missing INSTANCENAME child element!");
        }
        CIMObjectPath op = CIMXMLParserImpl.parseINSTANCENAME(instancenameA[0]);
        Element[] instanceA = CIMXMLParserImpl.searchNodes(pValueNamedInstanceE, "INSTANCE", 1, 1, true);
        if (instanceA == null) {
            throw new CIMXMLParseException("VALUE.NAMEDINSTANCE element missing INSTANCE child element!");
        }
        CIMInstance inst = CIMXMLParserImpl.parseINSTANCE(instanceA[0], op);
        CIMXMLParserImpl.checkOtherNodes(pValueNamedInstanceE, nodesVALUENAMEDINSTANCE);
        return inst;
    }

    public static CIMInstance parseVALUEINSTANCEWITHPATH(Element pValueNamedInstanceE) throws CIMXMLParseException {
        Element[] instancepathA = CIMXMLParserImpl.searchNodes(pValueNamedInstanceE, "INSTANCEPATH", 1, 1, true);
        if (instancepathA == null) {
            throw new CIMXMLParseException("VALUE.INSTANCEWITHPATH element missing INSTANCEPATH child element!");
        }
        CIMObjectPath op = CIMXMLParserImpl.parseINSTANCEPATH(instancepathA[0]);
        Element[] instanceA = CIMXMLParserImpl.searchNodes(pValueNamedInstanceE, "INSTANCE", 1, 1, true);
        if (instanceA == null) {
            throw new CIMXMLParseException("VALUE.INSTANCEWITHPATH element missing INSTANCE child element!");
        }
        CIMInstance inst = CIMXMLParserImpl.parseINSTANCE(instanceA[0], op);
        CIMXMLParserImpl.checkOtherNodes(pValueNamedInstanceE, nodesVALUEINSTANCEWITHPATH);
        return inst;
    }

    public static CIMNamedElementInterface parseVALUENAMEDOBJECT(Element pValueNamedObjectE) throws CIMXMLParseException {
        Element[] classA = CIMXMLParserImpl.searchNodes(pValueNamedObjectE, "CLASS", 0, 1, false);
        if (classA != null) {
            CIMClass obj = CIMXMLParserImpl.parseCLASS(classA[0]);
            return obj;
        }
        Element[] instancenameA = CIMXMLParserImpl.searchNodes(pValueNamedObjectE, "INSTANCENAME", 0, 1, true);
        if (instancenameA != null) {
            CIMObjectPath op = CIMXMLParserImpl.parseINSTANCENAME(instancenameA[0]);
            Element[] instanceA = CIMXMLParserImpl.searchNodes(pValueNamedObjectE, "INSTANCE", 0, 1, true);
            if (instanceA == null) {
                throw new CIMXMLParseException("VALUE.NAMEDOBJECT element missing INSTANCE child element!");
            }
            CIMInstance inst = CIMXMLParserImpl.parseINSTANCE(instanceA[0], op);
            CIMXMLParserImpl.checkOtherNodes(pValueNamedObjectE, nodesVALUENAMEDOBJECTi);
            return inst;
        }
        throw new CIMXMLParseException("VALUE.NAMEDOBJECT element missing required child element!");
    }

    public static CIMNamedElementInterface parseVALUEOBJECTWITHPATH(Element pValueObjectWithPathE) throws CIMXMLParseException {
        Element[] classpathA = CIMXMLParserImpl.searchNodes(pValueObjectWithPathE, "CLASSPATH", 0, 1, true);
        if (classpathA != null) {
            CIMObjectPath op = CIMXMLParserImpl.parseCLASSPATH(classpathA[0]);
            Element[] classA = CIMXMLParserImpl.searchNodes(pValueObjectWithPathE, "CLASS", 0, 1, true);
            if (classA == null) {
                throw new CIMXMLParseException("VALUE.OBJECTWITHPATH element missing CLASS child element!");
            }
            CIMClass obj = CIMXMLParserImpl.parseCLASS(classA[0], op);
            CIMXMLParserImpl.checkOtherNodes(pValueObjectWithPathE, nodesVALUEOBJECTWITHPATHcls);
            return obj;
        }
        Element[] instancepathA = CIMXMLParserImpl.searchNodes(pValueObjectWithPathE, "INSTANCEPATH", 0, 1, true);
        if (instancepathA != null) {
            CIMObjectPath op = CIMXMLParserImpl.parseINSTANCEPATH(instancepathA[0]);
            Element[] instanceA = CIMXMLParserImpl.searchNodes(pValueObjectWithPathE, "INSTANCE", 0, 1, true);
            if (instanceA == null) {
                throw new CIMXMLParseException("VALUE.OBJECTWITHPATH element missing INSTANCE child element!");
            }
            CIMInstance inst = CIMXMLParserImpl.parseINSTANCE(instanceA[0], op);
            CIMXMLParserImpl.checkOtherNodes(pValueObjectWithPathE, nodesVALUEOBJECTWITHPATHins);
            return inst;
        }
        throw new CIMXMLParseException("VALUE.OBJECTWITHPATH element missing required child element!");
    }

    public static CIMNamedElementInterface parseVALUEOBJECTWITHLOCALPATH(Element pValueObjectWithLocalPathE) throws CIMXMLParseException {
        Element[] localclasspathA = CIMXMLParserImpl.searchNodes(pValueObjectWithLocalPathE, "LOCALCLASSPATH", 0, 1, true);
        if (localclasspathA != null) {
            CIMObjectPath op = CIMXMLParserImpl.parseLOCALCLASSPATH(localclasspathA[0]);
            Element[] classA = CIMXMLParserImpl.searchNodes(pValueObjectWithLocalPathE, "CLASS", 0, 1, true);
            if (classA == null) {
                throw new CIMXMLParseException("VALUE.OBJECTWITHLOCALPATH element missing CLASS child element!");
            }
            CIMClass obj = CIMXMLParserImpl.parseCLASS(classA[0], op);
            CIMXMLParserImpl.checkOtherNodes(pValueObjectWithLocalPathE, nodesVALUEOBJECTWITHLOCALPATHcls);
            return obj;
        }
        Element[] localinstancepathA = CIMXMLParserImpl.searchNodes(pValueObjectWithLocalPathE, "LOCALINSTANCEPATH", 0, 1, true);
        if (localinstancepathA != null) {
            CIMObjectPath op = CIMXMLParserImpl.parseLOCALINSTANCEPATH(localinstancepathA[0]);
            Element[] instanceA = CIMXMLParserImpl.searchNodes(pValueObjectWithLocalPathE, "INSTANCE", 0, 1, true);
            if (instanceA == null) {
                throw new CIMXMLParseException("VALUE.OBJECTWITHLOCALPATH element missing INSTANCE child element!");
            }
            CIMInstance inst = CIMXMLParserImpl.parseINSTANCE(instanceA[0], op);
            CIMXMLParserImpl.checkOtherNodes(pValueObjectWithLocalPathE, nodesVALUEOBJECTWITHLOCALPATHins);
            return inst;
        }
        throw new CIMXMLParseException("VALUE.OBJECTWITHLOCALPATH element missing required child element!");
    }

    public static CIMObjectPath parseNAMESPACEPATH(Element pNameSpacePathE) throws CIMXMLParseException {
        Element[] hostA = CIMXMLParserImpl.searchNodes(pNameSpacePathE, "HOST", 1, 1, true);
        if (hostA == null) {
            throw new CIMXMLParseException("NAMESPACEPATH element missing HOST child element!");
        }
        XMLHostStr xmlHostStr = new XMLHostStr(CIMXMLParserImpl.parseHOST(hostA[0]));
        Element[] localnamespacepathA = CIMXMLParserImpl.searchNodes(pNameSpacePathE, "LOCALNAMESPACEPATH", 1, 1, true);
        if (localnamespacepathA == null) {
            throw new CIMXMLParseException("NAMESPACEPATH element missing LOCALNAMESPACEPATH child element!");
        }
        String nameSpace = CIMXMLParserImpl.parseLOCALNAMESPACEPATH(localnamespacepathA[0]);
        CIMXMLParserImpl.checkOtherNodes(pNameSpacePathE, nodesNAMESPACEPATH);
        return new CIMObjectPath(xmlHostStr.getProtocol(), xmlHostStr.getHost(), xmlHostStr.getPort(), nameSpace, null, null);
    }

    public static String parseLOCALNAMESPACEPATH(Element pLocalNameSpaceE) throws CIMXMLParseException {
        Element[] nameSpaceElementA = CIMXMLParserImpl.searchNodes(pLocalNameSpaceE, "NAMESPACE", 1, Integer.MAX_VALUE, false);
        if (nameSpaceElementA == null) {
            if (WBEMConfiguration.getGlobalConfiguration().allowEmptyLocalNameSpacePath() && cLocalPathBuilder != null) {
                return cLocalPathBuilder.getBasePath().getNamespace();
            }
            throw new CIMXMLParseException("LOCALNAMESPACEPATH element missing NAMESPACE child element!");
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < nameSpaceElementA.length; ++i) {
            Element namespaceE = nameSpaceElementA[i];
            String s = CIMXMLParserImpl.parseNAMESPACE(namespaceE);
            if (i > 0) {
                sb.append("/" + s);
                continue;
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static String parseHOST(Element pHostE) {
        Text valueT = (Text)CIMXMLParserImpl.searchFirstChild(pHostE);
        String host = valueT.getNodeValue();
        return host;
    }

    public static String parseNAMESPACE(Element pNameSpaceE) throws CIMXMLParseException {
        Attr namespace_nameA = (Attr)CIMXMLParserImpl.searchAttribute(pNameSpaceE, "NAME");
        if (namespace_nameA == null) {
            throw new CIMXMLParseException("NAMESPACE element missing NAME attribute!");
        }
        String n = namespace_nameA.getValue();
        CIMXMLParserImpl.checkOtherNodes(pNameSpaceE, nodesNAMESPACE);
        return n;
    }

    public static CIMObjectPath parseCLASSPATH(Element pClassPathE) throws CIMXMLParseException {
        Element[] namespacepathA = CIMXMLParserImpl.searchNodes(pClassPathE, "NAMESPACEPATH", 1, 1, true);
        if (namespacepathA == null) {
            throw new CIMXMLParseException("CLASSPATH element missing NAMESPACEPATH child element!");
        }
        CIMObjectPath nsPath = CIMXMLParserImpl.parseNAMESPACEPATH(namespacepathA[0]);
        Element[] classnameA = CIMXMLParserImpl.searchNodes(pClassPathE, "CLASSNAME", 1, 1, true);
        if (classnameA == null) {
            throw new CIMXMLParseException("CLASSPATH element missing CLASSNAME child element!");
        }
        String className = CIMXMLParserImpl.parseClassName(classnameA[0]);
        CIMXMLParserImpl.checkOtherNodes(pClassPathE, nodesCLASSPATH);
        return new CIMObjectPath(nsPath.getScheme(), nsPath.getHost(), nsPath.getPort(), nsPath.getNamespace(), className, null);
    }

    public static CIMObjectPath parseLOCALCLASSPATH(Element pClassPathE) throws CIMXMLParseException {
        Element[] localnamespacepathA = CIMXMLParserImpl.searchNodes(pClassPathE, "LOCALNAMESPACEPATH", 1, 1, true);
        if (localnamespacepathA == null) {
            throw new CIMXMLParseException("LOCALCLASSPATH element missing LOCALNAMESPACEPATH child element!");
        }
        String nameSpace = CIMXMLParserImpl.parseLOCALNAMESPACEPATH(localnamespacepathA[0]);
        Element[] classnameA = CIMXMLParserImpl.searchNodes(pClassPathE, "CLASSNAME", 1, 1, true);
        if (classnameA == null) {
            throw new CIMXMLParseException("LOCALCLASSPATH element missing CLASSNAME child element!");
        }
        CIMObjectPath op = CIMXMLParserImpl.parseCLASSNAME(classnameA[0]);
        CIMXMLParserImpl.checkOtherNodes(pClassPathE, nodesLOCALCLASSPATH);
        return cLocalPathBuilder.build(op.getObjectName(), nameSpace);
    }

    public static String parseClassName(Element pClassNameE) throws CIMXMLParseException {
        Attr classname_nameA = (Attr)CIMXMLParserImpl.searchAttribute(pClassNameE, "NAME");
        if (classname_nameA == null) {
            throw new CIMXMLParseException("CLASSNAME element missing NAME attribute!");
        }
        CIMXMLParserImpl.checkOtherNodes(pClassNameE, nodesCLASSNAME);
        return classname_nameA.getNodeValue();
    }

    public static CIMObjectPath parseCLASSNAME(Element pClassNameE) throws CIMXMLParseException {
        return cLocalPathBuilder.build(CIMXMLParserImpl.parseClassName(pClassNameE), null);
    }

    public static CIMObjectPath parseINSTANCEPATH(Element pInstancePathE) throws CIMXMLParseException {
        Element[] namespacepathA = CIMXMLParserImpl.searchNodes(pInstancePathE, "NAMESPACEPATH", 1, 1, true);
        if (namespacepathA == null) {
            throw new CIMXMLParseException("INSTANCEPATH element missing NAMESPACEPATH child element!");
        }
        CIMObjectPath nsPath = CIMXMLParserImpl.parseNAMESPACEPATH(namespacepathA[0]);
        Element[] instancenameA = CIMXMLParserImpl.searchNodes(pInstancePathE, "INSTANCENAME", 1, 1, true);
        if (instancenameA == null) {
            throw new CIMXMLParseException("INSTANCEPATH element missing INSTANCENAME child element!");
        }
        CIMObjectPath op = CIMXMLParserImpl.parseINSTANCENAME(instancenameA[0]);
        CIMXMLParserImpl.checkOtherNodes(pInstancePathE, nodesINSTANCEPATH);
        return new CIMObjectPath(nsPath.getScheme(), nsPath.getHost(), nsPath.getPort(), nsPath.getNamespace(), op.getObjectName(), op.getKeys());
    }

    public static CIMObjectPath parseLOCALINSTANCEPATH(Element pLocalInstancePathE) throws CIMXMLParseException {
        Element[] localnamespacepathA = CIMXMLParserImpl.searchNodes(pLocalInstancePathE, "LOCALNAMESPACEPATH", 1, 1, true);
        if (localnamespacepathA == null) {
            throw new CIMXMLParseException("LOCALINSTANCEPATH element missing LOCALNAMESPACEPATH child element!");
        }
        String nameSpace = CIMXMLParserImpl.parseLOCALNAMESPACEPATH(localnamespacepathA[0]);
        Element[] instancenameA = CIMXMLParserImpl.searchNodes(pLocalInstancePathE, "INSTANCENAME", 1, 1, true);
        if (instancenameA == null) {
            throw new CIMXMLParseException("LOCALINSTANCEPATH element missing INSTANCENAME child element!");
        }
        CIMObjectPath op = CIMXMLParserImpl.parseINSTANCENAME(instancenameA[0]);
        CIMXMLParserImpl.checkOtherNodes(pLocalInstancePathE, nodesLOCALINSTANCEPATH);
        return cLocalPathBuilder.build(op.getObjectName(), nameSpace, op.getKeys());
    }

    public static CIMObjectPath parseINSTANCENAME(Element pInstanceNameE) throws CIMXMLParseException {
        Attr instance_classnameA = (Attr)CIMXMLParserImpl.searchAttribute(pInstanceNameE, "CLASSNAME");
        if (instance_classnameA == null) {
            throw new CIMXMLParseException("INSTANCENAME element missing CLASSNAME attribute!");
        }
        String opClassName = instance_classnameA.getNodeValue();
        Element[] keyBindingElementA = CIMXMLParserImpl.searchNodes(pInstanceNameE, "KEYBINDING", 0, Integer.MAX_VALUE, false);
        if (keyBindingElementA != null) {
            CIMProperty[] keys = new CIMProperty[keyBindingElementA.length];
            for (int i = 0; i < keyBindingElementA.length; ++i) {
                Element keybindingE = keyBindingElementA[i];
                keys[i] = CIMXMLParserImpl.parseKEYBINDING(keybindingE);
            }
            return cLocalPathBuilder.build(opClassName, null, keys);
        }
        Element[] keyvalueA = CIMXMLParserImpl.searchNodes(pInstanceNameE, "KEYVALUE", 0, 1, false);
        if (keyvalueA != null) {
            CIMProperty[] keys = new CIMProperty[1];
            TypedValue propTypedVal = CIMXMLParserImpl.parseKEYVALUE(keyvalueA[0]);
            keys[0] = new CIMProperty<Object>("", propTypedVal.getType(), propTypedVal.getValue(), true, false, null);
            return cLocalPathBuilder.build(opClassName, null, keys);
        }
        Element[] valuereferenceA = CIMXMLParserImpl.searchNodes(pInstanceNameE, "VALUE.REFERENCE", 0, 1, false);
        if (valuereferenceA != null) {
            CIMProperty[] keys = new CIMProperty[1];
            CIMObjectPath op = CIMXMLParserImpl.parseVALUEREFERENCE(valuereferenceA[0]);
            keys[0] = new CIMProperty<CIMObjectPath>("", new CIMDataType(op.getObjectName()), op, true, false, null);
            return cLocalPathBuilder.build(opClassName, null, keys);
        }
        CIMXMLParserImpl.checkOtherNodes(pInstanceNameE, nodesINSTANCENAME);
        return new CIMObjectPath(null, null, null, null, opClassName, null);
    }

    public static CIMObjectPath parseOBJECTPATH(Element pObjectPathE) throws CIMXMLParseException {
        Element[] instancepathA = CIMXMLParserImpl.searchNodes(pObjectPathE, "INSTANCEPATH", 0, 1, false);
        if (instancepathA != null) {
            CIMObjectPath op = CIMXMLParserImpl.parseINSTANCEPATH(instancepathA[0]);
            return op;
        }
        Element[] classpathA = CIMXMLParserImpl.searchNodes(pObjectPathE, "CLASSPATH", 0, 1, false);
        if (classpathA != null) {
            CIMObjectPath op = CIMXMLParserImpl.parseCLASSPATH(classpathA[0]);
            return op;
        }
        throw new CIMXMLParseException("OBJECTPATH element missing required child element!");
    }

    public static CIMProperty<?> parseKEYBINDING(Element pKeyBindingE) throws CIMXMLParseException {
        Attr keybinding_nameA = (Attr)CIMXMLParserImpl.searchAttribute(pKeyBindingE, "NAME");
        if (keybinding_nameA == null) {
            throw new CIMXMLParseException("KEYBINDING element missing NAME attribute!");
        }
        String propName = keybinding_nameA.getValue();
        Element[] keyvalueA = CIMXMLParserImpl.searchNodes(pKeyBindingE, "KEYVALUE", 0, 1, false);
        if (keyvalueA != null) {
            TypedValue propTypedVal = CIMXMLParserImpl.parseKEYVALUE(keyvalueA[0]);
            return new CIMProperty<Object>(propName, propTypedVal.getType(), propTypedVal.getValue(), true, false, null);
        }
        Element[] valuereferenceA = CIMXMLParserImpl.searchNodes(pKeyBindingE, "VALUE.REFERENCE", 0, 1, false);
        if (valuereferenceA != null) {
            CIMObjectPath op = CIMXMLParserImpl.parseVALUEREFERENCE(valuereferenceA[0]);
            return new CIMProperty<CIMObjectPath>(propName, new CIMDataType(op.getObjectName()), op, true, false, null);
        }
        throw new CIMXMLParseException("KEYBINDING element missing required child element!");
    }

    public static CIMDataType parseScalarTypeStr(String pTypeStr) throws CIMXMLParseException {
        return CIMXMLParserImpl.parseTypeStr(pTypeStr, false);
    }

    public static CIMDataType parseArrayTypeStr(String pTypeStr) throws CIMXMLParseException {
        return CIMXMLParserImpl.parseTypeStr(pTypeStr, true);
    }

    public static CIMDataType parseTypeStr(String pTypeStr, boolean pArray) throws CIMXMLParseException {
        if (pTypeStr == null) {
            return pArray ? CIMDataType.STRING_ARRAY_T : CIMDataType.STRING_T;
        }
        CIMDataType type = TYPESTR_MAP.get(pTypeStr);
        if (type == null) {
            throw new CIMXMLParseException("Unknown TYPE string:" + pTypeStr);
        }
        if (pArray) {
            if (type.getType() == 14) {
                return new CIMDataType(type.getRefClassName(), 0);
            }
            return CIMHelper.UnboundedArrayDataType(type.getType());
        }
        return type;
    }

    public static TypedValue parseKEYVALUE(Element pKeyValueE) throws CIMXMLParseException {
        String valueStr;
        String typeStr = CIMXMLParserImpl.attribute(pKeyValueE, "TYPE");
        Text valueT = (Text)CIMXMLParserImpl.searchFirstChild(pKeyValueE);
        String string = valueStr = valueT == null ? null : valueT.getNodeValue();
        if (typeStr == null) {
            String valueTypeStr = CIMXMLParserImpl.attribute(pKeyValueE, "VALUETYPE");
            if (valueTypeStr == null) {
                valueTypeStr = "string";
            }
            ValueTypeHandler vtHandler = new ValueTypeHandler(valueTypeStr, valueStr);
            return new TypedValue(vtHandler.getType(), vtHandler.getValue());
        }
        String value = valueStr == null ? "" : CIMXMLParserImpl.createJavaObject(typeStr, valueStr);
        return new TypedValue(CIMXMLParserImpl.parseScalarTypeStr(typeStr), value);
    }

    private static String attribute(Element pElement, String pName) {
        String attrib = pElement.getAttribute(pName);
        if (attrib == null || attrib.length() == 0) {
            return null;
        }
        return attrib;
    }

    public static CIMClass parseCLASS(Element pClassE) throws CIMXMLParseException {
        return CIMXMLParserImpl.parseCLASS(pClassE, null);
    }

    public static CIMClass parseCLASS(Element pClassE, CIMObjectPath pObjectPath) throws CIMXMLParseException {
        CIMMethod[] methods;
        Attr class_nameA = (Attr)CIMXMLParserImpl.searchAttribute(pClassE, "NAME");
        if (class_nameA == null) {
            throw new CIMXMLParseException("CLASS element missing NAME attribute!");
        }
        String name = class_nameA.getNodeValue();
        String superClass = CIMXMLParserImpl.attribute(pClassE, "SUPERCLASS");
        CIMQualifier<?>[] qualis = CIMXMLParserImpl.parseQUALIFIERS(pClassE);
        CIMClassProperty<?>[] props = CIMXMLParserImpl.parseCLASSPROPERTIES(pClassE);
        Element[] methodElementA = CIMXMLParserImpl.searchNodes(pClassE, "METHOD", 0, Integer.MAX_VALUE, true);
        if (methodElementA != null) {
            methods = new CIMMethod[methodElementA.length];
            for (int i = 0; i < methodElementA.length; ++i) {
                Element methodE = methodElementA[i];
                methods[i] = CIMXMLParserImpl.parseMETHOD(methodE);
            }
        } else {
            methods = null;
        }
        CIMXMLParserImpl.checkOtherNodes(pClassE, nodesCLASS);
        return new CIMClass(pObjectPath == null ? cLocalPathBuilder.build(name, null) : pObjectPath, superClass, qualis, props, methods, CIMXMLParserImpl.hasAssocQuali(qualis), CIMXMLParserImpl.hasKeyProp(props));
    }

    private static boolean hasAssocQuali(CIMQualifier<?>[] pQualis) {
        if (pQualis == null) {
            return false;
        }
        for (int i = 0; i < pQualis.length; ++i) {
            CIMQualifier<?> quali = pQualis[i];
            if (!"ASSOCIATION".equalsIgnoreCase(quali.getName()) || !Boolean.TRUE.equals(quali.getValue())) continue;
            return true;
        }
        return false;
    }

    private static boolean hasKeyProp(CIMProperty<?>[] pProps) {
        if (pProps == null) {
            return false;
        }
        for (int i = 0; i < pProps.length; ++i) {
            if (!pProps[i].isKey()) continue;
            return true;
        }
        return false;
    }

    private static CIMParameter<?>[] parseParameters(Element pMethodE) throws CIMXMLParseException {
        Element[] paramRefArrayElementA;
        Element[] paramArrayElementA;
        Element[] paramRefElementA;
        Vector<CIMParameter<Object>> paramV = new Vector<CIMParameter<Object>>();
        Element[] paramElementA = CIMXMLParserImpl.searchNodes(pMethodE, "PARAMETER");
        if (paramElementA != null) {
            for (int i = 0; i < paramElementA.length; ++i) {
                Element parameterE = paramElementA[i];
                CIMParameter<Object> p = CIMXMLParserImpl.parsePARAMETER(parameterE);
                paramV.add(p);
            }
        }
        if ((paramRefElementA = CIMXMLParserImpl.searchNodes(pMethodE, "PARAMETER.REFERENCE")) != null) {
            for (int i = 0; i < paramRefElementA.length; ++i) {
                Element parameterE = paramRefElementA[i];
                CIMParameter<Object> p = CIMXMLParserImpl.parsePARAMETERREFERENCE(parameterE);
                paramV.add(p);
            }
        }
        if ((paramArrayElementA = CIMXMLParserImpl.searchNodes(pMethodE, "PARAMETER.ARRAY")) != null) {
            for (int i = 0; i < paramArrayElementA.length; ++i) {
                Element parameterE = paramArrayElementA[i];
                CIMParameter<Object> p = CIMXMLParserImpl.parsePARAMETERARRAY(parameterE);
                paramV.add(p);
            }
        }
        if ((paramRefArrayElementA = CIMXMLParserImpl.searchNodes(pMethodE, "PARAMETER.REFARRAY")) != null) {
            for (int i = 0; i < paramRefArrayElementA.length; ++i) {
                Element parameterE = paramRefArrayElementA[i];
                CIMParameter<Object> p = CIMXMLParserImpl.parsePARAMETERREFARRAY(parameterE);
                paramV.add(p);
            }
        }
        return paramV.toArray(new CIMParameter[0]);
    }

    public static CIMMethod<Object> parseMETHOD(Element pMethodE) throws CIMXMLParseException {
        String name = CIMXMLParserImpl.attribute(pMethodE, "NAME");
        if (name == null) {
            throw new CIMXMLParseException("METHOD element missing NAME attribute!");
        }
        EmbObjHandler embObjHandler = new EmbObjHandler(pMethodE);
        CIMDataType type = embObjHandler.getType();
        if (type != null && type.isArray()) {
            throw new CIMXMLParseException("Method's type cannot be Array!");
        }
        String classOrigin = CIMXMLParserImpl.attribute(pMethodE, "CLASSORIGIN");
        String propagatedStr = pMethodE.getAttribute("PROPAGATED");
        boolean propagated = "true".equalsIgnoreCase(propagatedStr);
        CIMXMLParserImpl.checkOtherNodes(pMethodE, nodesMETHOD);
        CIMParameter<?>[] params = CIMXMLParserImpl.parseParameters(pMethodE);
        return new CIMMethod<Object>(name, type, embObjHandler.getQualifiers(), params, propagated, classOrigin);
    }

    public static CIMParameter<Object> parsePARAMETER(Element pParamE) throws CIMXMLParseException {
        String name = CIMXMLParserImpl.attribute(pParamE, "NAME");
        if (name == null) {
            throw new CIMXMLParseException("PARAMETER element missing NAME attribute!");
        }
        if (CIMXMLParserImpl.attribute(pParamE, "TYPE") == null) {
            throw new CIMXMLParseException("PARAMETER element missing TYPE attribute!");
        }
        CIMXMLParserImpl.checkOtherNodes(pParamE, nodesPARAMETER);
        EmbObjHandler iEmbObjHandler = new EmbObjHandler(pParamE);
        return new CIMParameter<Object>(name, iEmbObjHandler.getType(), iEmbObjHandler.getQualifiers());
    }

    public static CIMParameter<Object> parsePARAMETERREFERENCE(Element pParamE) throws CIMXMLParseException {
        String name = CIMXMLParserImpl.attribute(pParamE, "NAME");
        if (name == null) {
            throw new CIMXMLParseException("PARAMETER.REFERENCE element missing NAME attribute!");
        }
        String referenceClass = CIMXMLParserImpl.attribute(pParamE, "REFERENCECLASS");
        CIMDataType type = new CIMDataType(referenceClass != null ? referenceClass : "");
        CIMXMLParserImpl.checkOtherNodes(pParamE, nodesPARAMETERREFERENCE);
        CIMQualifier<?>[] qualis = CIMXMLParserImpl.parseQUALIFIERS(pParamE);
        return new CIMParameter<Object>(name, type, qualis);
    }

    public static CIMParameter<Object> parsePARAMETERARRAY(Element pParamE) throws CIMXMLParseException {
        String name = CIMXMLParserImpl.attribute(pParamE, "NAME");
        if (name == null) {
            throw new CIMXMLParseException("PARAMETER.ARRAY element missing NAME attribute!");
        }
        if (CIMXMLParserImpl.attribute(pParamE, "TYPE") == null) {
            throw new CIMXMLParseException("PARAMETER.ARRAY element missing TYPE attribute!");
        }
        String arraySizeStr = pParamE.getAttribute("ARRAYSIZE");
        try {
            if (arraySizeStr.length() > 0) {
                Integer.parseInt(arraySizeStr);
            }
        }
        catch (NumberFormatException e) {
            throw new CIMXMLParseException(arraySizeStr + " is not a valid ARRAYSIZE attribute for PARAMETER.ARRAY!");
        }
        CIMXMLParserImpl.checkOtherNodes(pParamE, nodesPARAMETERARRAY);
        EmbObjHandler iEmbObjHandler = new EmbObjHandler(pParamE);
        return new CIMParameter<Object>(name, iEmbObjHandler.getArrayType(), iEmbObjHandler.getQualifiers());
    }

    public static CIMParameter<Object> parsePARAMETERREFARRAY(Element pParamE) throws CIMXMLParseException {
        String name = CIMXMLParserImpl.attribute(pParamE, "NAME");
        if (name == null) {
            throw new CIMXMLParseException("PARAMETER.REFARRAY element missing NAME attribute!");
        }
        String referenceClass = CIMXMLParserImpl.attribute(pParamE, "REFERENCECLASS");
        int arraySize = 0;
        String arraySizeStr = pParamE.getAttribute("ARRAYSIZE");
        try {
            if (arraySizeStr.length() > 0) {
                arraySize = Integer.parseInt(arraySizeStr);
            }
        }
        catch (NumberFormatException e) {
            throw new CIMXMLParseException(arraySizeStr + " is not a valid ARRAYSIZE attribute for PARAMETER.REFARRAY!");
        }
        CIMDataType type = new CIMDataType(referenceClass != null ? referenceClass : "", arraySize);
        CIMXMLParserImpl.checkOtherNodes(pParamE, nodesPARAMETERREFARRAY);
        CIMQualifier<?>[] qualis = CIMXMLParserImpl.parseQUALIFIERS(pParamE);
        return new CIMParameter<Object>(name, type, qualis);
    }

    public static CIMInstance parseINSTANCE(Element pInstanceE) throws CIMXMLParseException {
        return CIMXMLParserImpl.parseINSTANCE(pInstanceE, null);
    }

    public static CIMInstance parseINSTANCE(Element pInstanceE, CIMObjectPath pObjPath) throws CIMXMLParseException {
        String className = CIMXMLParserImpl.attribute(pInstanceE, "CLASSNAME");
        if (className == null) {
            throw new CIMXMLParseException("INSTANCE element missing CLASSNAME attribute!");
        }
        CIMProperty<?>[] props = CIMXMLParserImpl.parsePROPERTIES(pInstanceE);
        CIMXMLParserImpl.checkOtherNodes(pInstanceE, nodesINSTANCE);
        if (pObjPath == null) {
            return new CIMInstance(cLocalPathBuilder.build(className, null), props);
        }
        if (WBEMConfiguration.getGlobalConfiguration().synchronizeNumericKeyDataTypes()) {
            return CIMHelper.CIMInstanceWithSynchonizedNumericKeyDataTypes(pObjPath, props);
        }
        return new CIMInstance(pObjPath, props);
    }

    public static CIMQualifier<?>[] parseQUALIFIERS(Element pElement) throws CIMXMLParseException {
        CIMQualifier[] qualis;
        Element[] qualiElementA = CIMXMLParserImpl.searchNodes(pElement, "QUALIFIER");
        if (qualiElementA != null) {
            qualis = new CIMQualifier[qualiElementA.length];
            for (int i = 0; i < qualiElementA.length; ++i) {
                Element qualifierE = qualiElementA[i];
                qualis[i] = CIMXMLParserImpl.parseQUALIFIER(qualifierE);
            }
        } else {
            qualis = null;
        }
        return qualis;
    }

    private static int parseFLAVORS(Element pElement) {
        int flavors = 0;
        if (!CIMXMLParserImpl.getBoolAttribute(pElement, "OVERRIDABLE", true)) {
            flavors |= 1;
        }
        if (!CIMXMLParserImpl.getBoolAttribute(pElement, "TOSUBCLASS", true)) {
            flavors |= 2;
        }
        if (CIMXMLParserImpl.getBoolAttribute(pElement, "TRANSLATABLE", false)) {
            flavors |= 4;
        }
        return flavors;
    }

    private static TypedValue parseSingleValue(Element pElement) throws CIMXMLParseException {
        return CIMXMLParserImpl.parseSingleValue(pElement, 3);
    }

    private static TypedValue parseSingleValue(Element pElement, int pMask) throws CIMXMLParseException {
        Element valueRefArrayE;
        Element valuearrayE;
        Element valuereferenceE;
        Element valueE;
        boolean foundSingleValue = false;
        String typeStr = CIMXMLParserImpl.attribute(pElement, "TYPE");
        if (typeStr == null) {
            typeStr = CIMXMLParserImpl.attribute(pElement, "PARAMTYPE");
        }
        CIMDataType type = null;
        Object[] value = null;
        if ((pMask & 1) > 0 && (valueE = (Element)CIMXMLParserImpl.searchFirstNode(pElement, "VALUE")) != null) {
            TypedValue tVal = CIMXMLParserImpl.parseVALUE(valueE);
            String valueStr = (String)tVal.getValue();
            type = typeStr == null ? tVal.getType() : CIMXMLParserImpl.parseScalarTypeStr(typeStr);
            value = CIMXMLParserImpl.createJavaObject(type == null ? null : type.toString(), valueStr);
            foundSingleValue = true;
        }
        if (!foundSingleValue && (pMask & 4) > 0 && (valuereferenceE = (Element)CIMXMLParserImpl.searchFirstNode(pElement, "VALUE.REFERENCE")) != null) {
            CIMObjectPath op = CIMXMLParserImpl.parseVALUEREFERENCE(valuereferenceE);
            value = op;
            type = new CIMDataType(op.getObjectName());
            foundSingleValue = true;
        }
        if (!foundSingleValue && (pMask & 2) > 0 && (valuearrayE = (Element)CIMXMLParserImpl.searchFirstNode(pElement, "VALUE.ARRAY")) != null) {
            TypedValue tValA = CIMXMLParserImpl.parseVALUEARRAY(valuearrayE);
            type = typeStr == null ? tValA.getType() : CIMXMLParserImpl.parseArrayTypeStr(typeStr);
            String[] valStrA = (String[])tValA.getValue();
            if (valStrA != null) {
                Object[] values = new Object[valStrA.length];
                for (int i = 0; i < valStrA.length; ++i) {
                    values[i] = CIMXMLParserImpl.createJavaObject(type == null ? null : type.toString(), valStrA[i]);
                }
                value = values;
            }
            foundSingleValue = true;
        }
        if (!foundSingleValue && (pMask & 8) > 0 && (valueRefArrayE = (Element)CIMXMLParserImpl.searchFirstNode(pElement, "VALUE.REFARRAY")) != null) {
            type = new CIMDataType("", 0);
            CIMObjectPath[] opA = CIMXMLParserImpl.parseVALUEREFARRAY(valueRefArrayE);
            value = opA;
            foundSingleValue = true;
        }
        if (!foundSingleValue) {
            type = value instanceof Object[] ? CIMDataType.STRING_ARRAY_T : (value != null ? CIMDataType.STRING_T : CIMDataType.STRING_T);
        }
        return new TypedValue(type, value);
    }

    public static CIMQualifier<?> parseQUALIFIER(Element pQualifierE) throws CIMXMLParseException {
        String name = CIMXMLParserImpl.attribute(pQualifierE, "NAME");
        if (name == null) {
            throw new CIMXMLParseException("QUALIFIER element missing NAME attribute!");
        }
        String typeStr = CIMXMLParserImpl.attribute(pQualifierE, "TYPE");
        if (typeStr == null && !CIMXMLParserImpl.hasTypeAttrsInNodes(pQualifierE)) {
            throw new CIMXMLParseException("QUALIFIER element missing TYPE attribute!");
        }
        boolean propagated = "true".equalsIgnoreCase(pQualifierE.getAttribute("PROPAGATED"));
        int flavors = CIMXMLParserImpl.parseFLAVORS(pQualifierE);
        if (CIMXMLParserImpl.searchNodes(pQualifierE, "VALUE", 0, 1, false) != null || CIMXMLParserImpl.searchNodes(pQualifierE, "VALUE.ARRAY", 0, 1, false) != null) {
            TypedValue typedValue = CIMXMLParserImpl.parseSingleValue(pQualifierE);
            if (typedValue.getType() == null) {
                throw new CIMXMLParseException("Qualifier's type is null!");
            }
            return new CIMQualifier<Object>(name, typedValue.getType(), typedValue.getValue(), flavors, propagated);
        }
        CIMXMLParserImpl.checkOtherNodes(pQualifierE, nodesQUALIFIER);
        CIMDataType type = CIMXMLParserImpl.parseScalarTypeStr(typeStr);
        return new CIMQualifier<Object>(name, type != null ? type : CIMDataType.STRING_T, null, flavors, propagated);
    }

    /*
     * Unable to fully structure code
     */
    public static CIMQualifierType<Object> parseQUALIFIERDECLARATION(Element pQualifierTypeE) throws CIMXMLParseException {
        name = CIMXMLParserImpl.attribute(pQualifierTypeE, "NAME");
        if (name == null) {
            throw new CIMXMLParseException("QUALIFIER.DECLARATION element missing NAME attribute!");
        }
        type = CIMXMLParserImpl.attribute(pQualifierTypeE, "TYPE");
        if (type == null && !CIMXMLParserImpl.hasTypeAttrsInNodes(pQualifierTypeE)) {
            throw new CIMXMLParseException("QUALIFIER.DECLARATION element missing TYPE attribute!");
        }
        scopeElementA = CIMXMLParserImpl.searchNodes(pQualifierTypeE, "SCOPE", 0, 1, true);
        scopes = scopeElementA == null ? 0 : CIMXMLParserImpl.parseSCOPES(scopeElementA[0]);
        nodes = null;
        if (CIMXMLParserImpl.searchNodes(pQualifierTypeE, "VALUE", 0, 1, true) != null) {
            nodes = new String[]{"SCOPE", "VALUE"};
        } else if (CIMXMLParserImpl.searchNodes(pQualifierTypeE, "VALUE.ARRAY", 0, 1, true) != null) {
            nodes = new String[]{"SCOPE", "VALUE.ARRAY"};
        }
        if (nodes != null) {
            typedValue = CIMXMLParserImpl.parseSingleValue(pQualifierTypeE);
            qdType = typedValue.getType();
            qdValue = typedValue.getValue();
            isArray = CIMXMLParserImpl.hasTrueAttribute(pQualifierTypeE, "ISARRAY");
            arraySizeStr = CIMXMLParserImpl.attribute(pQualifierTypeE, "ARRAYSIZE");
            try {
                v0 = arraySizeStr == null ? (isArray ? 0 : -1) : (arraySize = Integer.parseInt(arraySizeStr));
                if (!isArray && arraySize < 0) ** GOTO lbl33
                qdType = arraySize > 0 ? new CIMDataType(qdType.getType(), arraySize) : CIMHelper.UnboundedArrayDataType(qdType.getType());
            }
            catch (NumberFormatException e) {
                throw new CIMXMLParseException(arraySizeStr + " is not a valid ARRAYSIZE attribute for QUALIFIER.DECLARATION!");
            }
        } else {
            nodes = new String[]{"SCOPE"};
            qdType = CIMXMLParserImpl.parseScalarTypeStr(type);
            if (qdType == null) {
                qdType = CIMDataType.STRING_T;
            }
            qdValue = null;
        }
lbl33:
        // 3 sources

        CIMXMLParserImpl.checkOtherNodes(pQualifierTypeE, nodes);
        return new CIMQualifierType<Object>(new CIMObjectPath(null, null, null, null, name, null), qdType, qdValue, scopes, 0);
    }

    private static boolean hasTrueAttribute(Element pElement, String pName) {
        String valueStr = pElement.getAttribute(pName);
        return "true".equalsIgnoreCase(valueStr);
    }

    private static boolean getBoolAttribute(Element pElement, String pName, boolean pDefVal) {
        String val = pElement.getAttribute(pName);
        if ("true".equalsIgnoreCase(val)) {
            return true;
        }
        if ("false".equalsIgnoreCase(val)) {
            return false;
        }
        return pDefVal;
    }

    public static int parseSCOPES(Element pScopeE) {
        int scopes = 0;
        if (CIMXMLParserImpl.hasTrueAttribute(pScopeE, "CLASS")) {
            scopes |= 1;
        }
        if (CIMXMLParserImpl.hasTrueAttribute(pScopeE, "ASSOCIATION")) {
            scopes |= 2;
        }
        if (CIMXMLParserImpl.hasTrueAttribute(pScopeE, "REFERENCE")) {
            scopes |= 0x10;
        }
        if (CIMXMLParserImpl.hasTrueAttribute(pScopeE, "PROPERTY")) {
            scopes |= 8;
        }
        if (CIMXMLParserImpl.hasTrueAttribute(pScopeE, "METHOD")) {
            scopes |= 0x20;
        }
        if (CIMXMLParserImpl.hasTrueAttribute(pScopeE, "PARAMETER")) {
            scopes |= 0x40;
        }
        if (CIMXMLParserImpl.hasTrueAttribute(pScopeE, "INDICATION")) {
            scopes |= 4;
        }
        return scopes;
    }

    private static Vector<CIMClassProperty<?>> parseClassPropsToVec(Element pElement) throws CIMXMLParseException {
        Element[] propRefElementA;
        Element[] propArrayElementA;
        Element[] propElementA = CIMXMLParserImpl.searchNodes(pElement, "PROPERTY");
        Vector propVec = new Vector();
        if (propElementA != null) {
            for (int i = 0; i < propElementA.length; ++i) {
                Element propertyE = propElementA[i];
                propVec.add(CIMXMLParserImpl.parseCLASSPROPERTY(propertyE));
            }
        }
        if ((propArrayElementA = CIMXMLParserImpl.searchNodes(pElement, "PROPERTY.ARRAY")) != null) {
            for (int i = 0; i < propArrayElementA.length; ++i) {
                Element propertyarrayE = propArrayElementA[i];
                propVec.add(CIMXMLParserImpl.parseCLASSPROPERTYARRAY(propertyarrayE));
            }
        }
        if ((propRefElementA = CIMXMLParserImpl.searchNodes(pElement, "PROPERTY.REFERENCE")) != null) {
            for (int i = 0; i < propRefElementA.length; ++i) {
                Element propertyreferenceE = propRefElementA[i];
                propVec.add(CIMXMLParserImpl.parseCLASSPROPERTYREFERENCE(propertyreferenceE));
            }
        }
        return propVec;
    }

    public static CIMProperty<?>[] parsePROPERTIES(Element pElement) throws CIMXMLParseException {
        Vector<CIMClassProperty<?>> classPropVec = CIMXMLParserImpl.parseClassPropsToVec(pElement);
        int arraySize = classPropVec.size();
        CIMProperty[] retA = new CIMProperty[arraySize];
        for (int i = 0; i < arraySize; ++i) {
            CIMClassProperty<?> prop = classPropVec.get(i);
            retA[i] = new CIMProperty(prop.getName(), prop.getDataType(), prop.getValue(), prop.isKey(), prop.isPropagated(), prop.getOriginClass());
        }
        return retA;
    }

    public static CIMClassProperty<?>[] parseCLASSPROPERTIES(Element pElement) throws CIMXMLParseException {
        Vector<CIMClassProperty<?>> classPropVec = CIMXMLParserImpl.parseClassPropsToVec(pElement);
        return classPropVec.toArray(new CIMClassProperty[0]);
    }

    public static CIMProperty<?> parsePROPERTY(Element pPropertyE) throws CIMXMLParseException {
        return CIMXMLParserImpl.parseCLASSPROPERTY(pPropertyE);
    }

    public static CIMClassProperty<Object> parseCLASSPROPERTY(Element pPropertyE) throws CIMXMLParseException {
        Attr property_nameA = (Attr)CIMXMLParserImpl.searchAttribute(pPropertyE, "NAME");
        if (property_nameA == null) {
            throw new CIMXMLParseException("PROPERTY element missing NAME attribute!");
        }
        String name = property_nameA.getNodeValue();
        if (CIMXMLParserImpl.attribute(pPropertyE, "TYPE") == null && !CIMXMLParserImpl.hasTypeAttrsInNodes(pPropertyE)) {
            throw new CIMXMLParseException("PROPERTY element missing TYPE attribute!");
        }
        String classOrigin = pPropertyE.getAttribute("CLASSORIGIN");
        if (classOrigin != null && classOrigin.length() == 0) {
            classOrigin = null;
        }
        String propagatedStr = pPropertyE.getAttribute("PROPAGATED");
        boolean propagated = "true".equalsIgnoreCase(propagatedStr);
        CIMXMLParserImpl.searchNodes(pPropertyE, "VALUE", 0, 1, true);
        CIMXMLParserImpl.checkOtherNodes(pPropertyE, nodesPROPERTY);
        EmbObjHandler embObjHandler = new EmbObjHandler(pPropertyE);
        return new CIMClassProperty<Object>(name, embObjHandler.getType(), embObjHandler.getValue(), embObjHandler.getQualifiers(), embObjHandler.isKeyed(), propagated, classOrigin);
    }

    public static CIMProperty<Object> parsePROPERTYARRAY(Element pPropertyArrayE) throws CIMXMLParseException {
        return CIMXMLParserImpl.parseCLASSPROPERTYARRAY(pPropertyArrayE);
    }

    public static CIMClassProperty<Object> parseCLASSPROPERTYARRAY(Element pPropArrayE) throws CIMXMLParseException {
        String valuePropagatedStr;
        String name = CIMXMLParserImpl.attribute(pPropArrayE, "NAME");
        if (name == null) {
            throw new CIMXMLParseException("PROPERTY.ARRAY element missing NAME attribute!");
        }
        if (CIMXMLParserImpl.attribute(pPropArrayE, "TYPE") == null && !CIMXMLParserImpl.hasTypeAttrsInNodes(pPropArrayE)) {
            throw new CIMXMLParseException("PROPERTY.ARRAY element missing TYPE attribute!");
        }
        String valueArraysizeStr = pPropArrayE.getAttribute("ARRAYSIZE");
        try {
            if (valueArraysizeStr.length() > 0) {
                Integer.parseInt(valueArraysizeStr);
            }
        }
        catch (NumberFormatException e) {
            throw new CIMXMLParseException(valueArraysizeStr + " is not a valid ARRAYSIZE attribute for VALUE.ARRAY!");
        }
        String classOrigin = pPropArrayE.getAttribute("CLASSORIGIN");
        if (classOrigin != null && classOrigin.length() == 0) {
            classOrigin = null;
        }
        boolean propagated = (valuePropagatedStr = pPropArrayE.getAttribute("PROPAGATED")) != null && valuePropagatedStr.equalsIgnoreCase("true");
        CIMXMLParserImpl.searchNodes(pPropArrayE, "VALUE.ARRAY", 0, 1, true);
        CIMXMLParserImpl.checkOtherNodes(pPropArrayE, nodesPROPERTYARRAY);
        EmbObjHandler embObjHandler = new EmbObjHandler(pPropArrayE);
        return new CIMClassProperty<Object>(name, embObjHandler.getArrayType(), embObjHandler.getValue(), embObjHandler.getQualifiers(), embObjHandler.isKeyed(), propagated, classOrigin);
    }

    public static CIMProperty<Object> parsePROPERTYREFERENCE(Element pPropRefE) throws CIMXMLParseException {
        return CIMXMLParserImpl.parseCLASSPROPERTYREFERENCE(pPropRefE);
    }

    public static CIMClassProperty<Object> parseCLASSPROPERTYREFERENCE(Element pPropRefE) throws CIMXMLParseException {
        String name = CIMXMLParserImpl.attribute(pPropRefE, "NAME");
        if (name == null) {
            throw new CIMXMLParseException("PROPERTY.REFERENCE element missing NAME attribute!");
        }
        String classOrigin = pPropRefE.getAttribute("CLASSORIGIN");
        if (classOrigin != null && classOrigin.length() == 0) {
            classOrigin = null;
        }
        String referenceClass = pPropRefE.getAttribute("REFERENCECLASS");
        String propagatedStr = pPropRefE.getAttribute("PROPAGATED");
        boolean propagated = "true".equalsIgnoreCase(propagatedStr);
        CIMQualifier<?>[] qualis = CIMXMLParserImpl.parseQUALIFIERS(pPropRefE);
        CIMDataType type = new CIMDataType(referenceClass != null ? referenceClass : "");
        Element[] valueRefA = CIMXMLParserImpl.searchNodes(pPropRefE, "VALUE.REFERENCE", 0, 1, true);
        CIMObjectPath value = valueRefA != null ? CIMXMLParserImpl.parseVALUEREFERENCE(valueRefA[0]) : null;
        CIMXMLParserImpl.checkOtherNodes(pPropRefE, nodesPROPERTYREFERENCE);
        CIMQualifiedElementInterfaceImpl qualiImpl = new CIMQualifiedElementInterfaceImpl(qualis);
        return new CIMClassProperty<Object>(name, type, value, qualis, qualiImpl.isKeyed(), propagated, classOrigin);
    }

    public static CIMMessage parseMESSAGE(String pCimVersion, String pDtdVersion, Element pMessageE) throws CIMXMLParseException {
        Attr idA = (Attr)CIMXMLParserImpl.searchAttribute(pMessageE, "ID");
        if (idA == null) {
            throw new CIMXMLParseException("MESSAGE element missing ID attribute!");
        }
        String id = idA.getNodeValue();
        Attr protocolA = (Attr)CIMXMLParserImpl.searchAttribute(pMessageE, "PROTOCOLVERSION");
        if (protocolA == null) {
            throw new CIMXMLParseException("MESSAGE element missing PROTOCOLVERSION attribute!");
        }
        if (pCimVersion.startsWith("2.") && pDtdVersion.startsWith("2.")) {
            Element[] simplerspA = CIMXMLParserImpl.searchNodes(pMessageE, "SIMPLERSP", 0, 1, false);
            if (simplerspA != null) {
                CIMResponse response = CIMXMLParserImpl.parseSIMPLERSP(simplerspA[0]);
                response.setMethod("SIMPLERSP");
                response.setId(id);
                return response;
            }
            Element[] multirspA = CIMXMLParserImpl.searchNodes(pMessageE, "MULTIRSP", 0, 1, false);
            if (multirspA != null) {
                CIMResponse response = CIMXMLParserImpl.parseMULTIRSP(multirspA[0]);
                response.setMethod("MULTIRSP");
                response.setId(id);
                return response;
            }
            Element[] simpleexpreqA = CIMXMLParserImpl.searchNodes(pMessageE, "SIMPLEEXPREQ", 0, 1, false);
            if (simpleexpreqA != null) {
                CIMRequest request = CIMXMLParserImpl.parseSIMPLEEXPREQ(simpleexpreqA[0]);
                request.setMethod("SIMPLEEXPREQ");
                request.setId(id);
                return request;
            }
            Element[] multiexpreqA = CIMXMLParserImpl.searchNodes(pMessageE, "MULTIEXPREQ", 0, 1, false);
            if (multiexpreqA != null) {
                CIMRequest request = CIMXMLParserImpl.parseMULTIEXPREQ(multiexpreqA[0]);
                request.setMethod("MULTIEXPREQ");
                request.setId(id);
                return request;
            }
            Element[] simpleexprspA = CIMXMLParserImpl.searchNodes(pMessageE, "SIMPLEEXPRSP", 0, 1, false);
            if (simpleexprspA != null) {
                CIMResponse response = CIMXMLParserImpl.parseSIMPLEEXPRSP(simpleexprspA[0]);
                response.setMethod("SIMPLEEXPRSP");
                response.setId(id);
                return response;
            }
            Element[] multiexprspA = CIMXMLParserImpl.searchNodes(pMessageE, "MULTIEXPRSP", 0, 1, false);
            if (multiexprspA != null) {
                CIMResponse response = CIMXMLParserImpl.parseMULTIEXPRSP(multiexprspA[0]);
                response.setMethod("MULTIEXPRSP");
                response.setId(id);
                return response;
            }
            Element[] simplereqA = CIMXMLParserImpl.searchNodes(pMessageE, "SIMPLEREQ", 0, 1, false);
            if (simplereqA != null) {
                CIMRequest request = CIMXMLParserImpl.parseSIMPLEREQ(simplereqA[0]);
                request.setMethod("SIMPLEREQ");
                request.setId(id);
                return request;
            }
            Element[] multireqA = CIMXMLParserImpl.searchNodes(pMessageE, "MULTIREQ", 0, 1, false);
            if (multireqA != null) {
                CIMRequest request = CIMXMLParserImpl.parseMULTIREQ(multireqA[0]);
                request.setMethod("MULTIREQ");
                request.setId(id);
                return request;
            }
            throw new CIMXMLParseException("MESSAGE element missing required child element!");
        }
        throw new CIMXMLParseException("Unsupported CIMVERSION/DTDVERSION");
    }

    public static CIMArgument<Object> parsePARAMVALUE(Element pParamValueE) throws CIMXMLParseException {
        String name = CIMXMLParserImpl.attribute(pParamValueE, "NAME");
        if (name == null) {
            throw new CIMXMLParseException("PARAMVALUE element missing NAME attribute!");
        }
        if (CIMXMLParserImpl.searchNodes(pParamValueE, "VALUE.REFERENCE", 0, 1, false) != null || CIMXMLParserImpl.searchNodes(pParamValueE, "VALUE.REFARRAY", 0, 1, false) != null) {
            TypedValue typedValue = CIMXMLParserImpl.parseSingleValue(pParamValueE, 12);
            CIMDataType type = typedValue.getType();
            Object value = typedValue.getValue();
            if (type == null) {
                throw new CIMXMLParseException("PARAMVALUE element type is null!");
            }
            return new CIMArgument<Object>(name, type, value);
        }
        if (CIMXMLParserImpl.searchNodes(pParamValueE, "VALUE", 0, 1, false) != null || CIMXMLParserImpl.searchNodes(pParamValueE, "VALUE.ARRAY", 0, 1, false) != null || !CIMXMLParserImpl.hasNodes(pParamValueE)) {
            EmbObjHandler embObjHandler = new EmbObjHandler(pParamValueE);
            return new CIMArgument<Object>(name, embObjHandler.getType(), embObjHandler.getValue());
        }
        Element[] classNameA = CIMXMLParserImpl.searchNodes(pParamValueE, "CLASSNAME", 0, 1, false);
        if (classNameA != null) {
            CIMObjectPath op = CIMXMLParserImpl.parseCLASSNAME(classNameA[0]);
            CIMDataType type = new CIMDataType(op.getObjectName());
            return new CIMArgument<Object>(name, type, op);
        }
        Element[] instNameA = CIMXMLParserImpl.searchNodes(pParamValueE, "INSTANCENAME", 0, 1, false);
        if (instNameA != null) {
            CIMObjectPath op = CIMXMLParserImpl.parseINSTANCENAME(instNameA[0]);
            CIMDataType type = new CIMDataType(op.getObjectName());
            return new CIMArgument<Object>(name, type, op);
        }
        Element[] classA = CIMXMLParserImpl.searchNodes(pParamValueE, "CLASS", 0, 1, false);
        if (classA != null) {
            CIMClass cl = CIMXMLParserImpl.parseCLASS(classA[0]);
            return new CIMArgument<Object>(name, CIMDataType.CLASS_T, cl);
        }
        Element[] instanceA = CIMXMLParserImpl.searchNodes(pParamValueE, "INSTANCE", 0, 1, false);
        if (instanceA != null) {
            CIMInstance inst = CIMXMLParserImpl.parseINSTANCE(instanceA[0]);
            return new CIMArgument<Object>(name, CIMDataType.OBJECT_T, inst);
        }
        Element[] valuenamedisntanceA = CIMXMLParserImpl.searchNodes(pParamValueE, "VALUE.NAMEDINSTANCE", 0, 1, false);
        if (valuenamedisntanceA != null) {
            CIMInstance inst = CIMXMLParserImpl.parseVALUENAMEDINSTANCE(valuenamedisntanceA[0]);
            return new CIMArgument<Object>(name, CIMDataType.OBJECT_T, inst);
        }
        CIMXMLParserImpl.checkOtherNodes(pParamValueE, nodesPARAMVALUE);
        return new CIMArgument<Object>(name, CIMDataType.STRING_T, null);
    }

    public static CIMArgument<Object> parseIPARAMVALUE(Element pParamValueE) throws CIMXMLParseException {
        TypedValue typedValue;
        String name = CIMXMLParserImpl.attribute(pParamValueE, "NAME");
        if (name == null) {
            throw new CIMXMLParseException("IPARAMVALUE element missing NAME attribute!");
        }
        if ((CIMXMLParserImpl.searchNodes(pParamValueE, "VALUE", 0, 1, false) != null || CIMXMLParserImpl.searchNodes(pParamValueE, "VALUE.ARRAY", 0, 1, false) != null || CIMXMLParserImpl.searchNodes(pParamValueE, "VALUE.REFERENCE", 0, 1, false) != null) && (typedValue = CIMXMLParserImpl.parseSingleValue(pParamValueE, 7)).getType() != null) {
            return new CIMArgument<Object>(name, typedValue.getType(), typedValue.getValue());
        }
        Element[] instNameA = CIMXMLParserImpl.searchNodes(pParamValueE, "INSTANCENAME", 0, 1, false);
        if (instNameA != null) {
            CIMObjectPath op = CIMXMLParserImpl.parseINSTANCENAME(instNameA[0]);
            CIMDataType type = new CIMDataType(op.getObjectName());
            return new CIMArgument<Object>(name, type, op);
        }
        Element[] classNameA = CIMXMLParserImpl.searchNodes(pParamValueE, "CLASSNAME", 0, 1, false);
        if (classNameA != null) {
            CIMObjectPath op = CIMXMLParserImpl.parseCLASSNAME(classNameA[0]);
            CIMDataType type = new CIMDataType(op.getObjectName());
            return new CIMArgument<Object>(name, type, op);
        }
        Element[] qualiDeclarationA = CIMXMLParserImpl.searchNodes(pParamValueE, "QUALIFIER.DECLARATION", 0, 1, false);
        if (qualiDeclarationA != null) {
            CIMQualifierType<Object> qualiType = CIMXMLParserImpl.parseQUALIFIERDECLARATION(qualiDeclarationA[0]);
            return new CIMArgument<Object>(name, new CIMDataType(qualiType.getName()), qualiType);
        }
        Element[] classA = CIMXMLParserImpl.searchNodes(pParamValueE, "CLASS", 0, 1, false);
        if (classA != null) {
            CIMClass cl = CIMXMLParserImpl.parseCLASS(classA[0]);
            return new CIMArgument<Object>(name, CIMDataType.CLASS_T, cl);
        }
        Element[] instanceA = CIMXMLParserImpl.searchNodes(pParamValueE, "INSTANCE", 0, 1, false);
        if (instanceA != null) {
            CIMInstance inst = CIMXMLParserImpl.parseINSTANCE(instanceA[0]);
            return new CIMArgument<Object>(name, CIMDataType.OBJECT_T, inst);
        }
        Element[] valuenamedisntanceA = CIMXMLParserImpl.searchNodes(pParamValueE, "VALUE.NAMEDINSTANCE", 0, 1, false);
        if (valuenamedisntanceA != null) {
            CIMInstance inst = CIMXMLParserImpl.parseVALUENAMEDINSTANCE(valuenamedisntanceA[0]);
            return new CIMArgument<Object>(name, CIMDataType.OBJECT_T, inst);
        }
        CIMXMLParserImpl.checkOtherNodes(pParamValueE, nodesIPARAMVALUE);
        return new CIMArgument<Object>(name, CIMDataType.STRING_T, null);
    }

    public static CIMResponse parseSIMPLERSP(Element pSimpleRspE) throws CIMXMLParseException {
        Element[] methodresponseA = CIMXMLParserImpl.searchNodes(pSimpleRspE, "METHODRESPONSE", 0, 1, false);
        if (methodresponseA != null) {
            return CIMXMLParserImpl.parseMETHODRESPONSE(methodresponseA[0]);
        }
        Element[] imethodresponseA = CIMXMLParserImpl.searchNodes(pSimpleRspE, "IMETHODRESPONSE", 0, 1, false);
        if (imethodresponseA != null) {
            return CIMXMLParserImpl.parseIMETHODRESPONSE(imethodresponseA[0]);
        }
        throw new CIMXMLParseException("SIMPLERSP element missing required child element!");
    }

    public static CIMResponse parseMULTIRSP(Element pSimpleRspE) throws CIMXMLParseException {
        Element[] multiRespElementA = CIMXMLParserImpl.searchNodes(pSimpleRspE, "SIMPLERSP", 2, Integer.MAX_VALUE, false);
        if (multiRespElementA != null) {
            CIMResponse multiRsp = new CIMResponse();
            for (int i = 0; i < multiRespElementA.length; ++i) {
                Element methodresponseE = multiRespElementA[i];
                CIMResponse rsp = CIMXMLParserImpl.parseSIMPLERSP(methodresponseE);
                rsp.setMethod("SIMPLERSP");
                multiRsp.addResponse(rsp);
            }
            return multiRsp;
        }
        throw new CIMXMLParseException("MULTIRSP element missing SIMPLERSP child element!");
    }

    public static CIMRequest parseSIMPLEREQ(Element pSimpleReqE) throws CIMXMLParseException {
        Element[] imethodcallA;
        CIMRequest request = null;
        Element[] methodcallA = CIMXMLParserImpl.searchNodes(pSimpleReqE, "METHODCALL", 0, 1, true);
        if (methodcallA != null) {
            request = CIMXMLParserImpl.parseMETHODCALL(methodcallA[0]);
        }
        if ((imethodcallA = CIMXMLParserImpl.searchNodes(pSimpleReqE, "IMETHODCALL", 0, 1, true)) != null) {
            if (request != null) {
                throw new CIMXMLParseException("SIMPLEREQ element cannot have METHODCALL and IMETHODCALL child elements!");
            }
            request = CIMXMLParserImpl.parseIMETHODCALL(imethodcallA[0]);
        }
        if (request == null) {
            throw new CIMXMLParseException("SIMPLEREQ element missing required child element!");
        }
        Element[] correlatorA = CIMXMLParserImpl.searchNodes(pSimpleReqE, "CORRELATOR", 0, Integer.MAX_VALUE, true);
        if (correlatorA != null) {
            for (int i = 0; i < correlatorA.length; ++i) {
                CIMXMLParserImpl.parseCORRELATOR(correlatorA[i]);
            }
        }
        CIMXMLParserImpl.checkOtherNodes(pSimpleReqE, nodesSIMPLEREQ);
        return request;
    }

    public static CIMRequest parseMULTIREQ(Element pMultiReqE) throws CIMXMLParseException {
        Element[] methodReqElementA = CIMXMLParserImpl.searchNodes(pMultiReqE, "SIMPLEREQ", 2, Integer.MAX_VALUE, false);
        if (methodReqElementA != null) {
            CIMRequest multiReq = new CIMRequest();
            for (int i = 0; i < methodReqElementA.length; ++i) {
                Element methodrequestE = methodReqElementA[i];
                CIMRequest req = CIMXMLParserImpl.parseSIMPLEREQ(methodrequestE);
                req.setMethod("SIMPLEREQ");
                multiReq.addRequest(req);
            }
            return multiReq;
        }
        throw new CIMXMLParseException("MULTIREQ element missing SIMPLEREQ child element!");
    }

    public static CIMRequest parseMETHODCALL(Element pMethodCallE) throws CIMXMLParseException {
        Element[] localinstancepathA;
        CIMRequest request = new CIMRequest();
        String methodname = CIMXMLParserImpl.attribute(pMethodCallE, "NAME");
        if (methodname == null) {
            throw new CIMXMLParseException("METHODCALL element missing NAME attribute!");
        }
        request.setMethodName(methodname);
        boolean localclasspathFound = false;
        Element[] localclasspathA = CIMXMLParserImpl.searchNodes(pMethodCallE, "LOCALCLASSPATH", 0, 1, true);
        if (localclasspathA != null) {
            CIMObjectPath path = CIMXMLParserImpl.parseLOCALCLASSPATH(localclasspathA[0]);
            request.setObjectPath(path);
            localclasspathFound = true;
        }
        if ((localinstancepathA = CIMXMLParserImpl.searchNodes(pMethodCallE, "LOCALINSTANCEPATH", 0, 1, true)) != null) {
            if (localclasspathFound) {
                throw new CIMXMLParseException("METHODCALL element cannot have both LOCALCLASSPATH and LOCALINSTANCEPATH child elements!");
            }
            CIMObjectPath path = CIMXMLParserImpl.parseLOCALINSTANCEPATH(localinstancepathA[0]);
            request.setObjectPath(path);
        } else if (!localclasspathFound) {
            throw new CIMXMLParseException("METHODCALL element missing required child element!");
        }
        Element[] paramValueElementA = CIMXMLParserImpl.searchNodes(pMethodCallE, "PARAMVALUE", 0, Integer.MAX_VALUE, true);
        if (paramValueElementA != null) {
            CIMArgument[] argA = new CIMArgument[paramValueElementA.length];
            for (int i = 0; i < paramValueElementA.length; ++i) {
                Element paramvalueE = paramValueElementA[i];
                argA[i] = CIMXMLParserImpl.parsePARAMVALUE(paramvalueE);
            }
            request.addParamValue(argA);
        }
        CIMXMLParserImpl.checkOtherNodes(pMethodCallE, nodesMETHODCALL);
        return request;
    }

    public static CIMRequest parseIMETHODCALL(Element pIMethodCallE) throws CIMXMLParseException {
        Element[] iParamValElementA;
        CIMRequest request = new CIMRequest();
        String methodname = CIMXMLParserImpl.attribute(pIMethodCallE, "NAME");
        if (methodname == null) {
            throw new CIMXMLParseException("IMETHODCALL element missing NAME attribute!");
        }
        request.setMethodName(methodname);
        Element[] localnamespacepathA = CIMXMLParserImpl.searchNodes(pIMethodCallE, "LOCALNAMESPACEPATH", 1, 1, true);
        if (localnamespacepathA != null) {
            String nameSpace = CIMXMLParserImpl.parseLOCALNAMESPACEPATH(localnamespacepathA[0]);
            request.setNameSpace(nameSpace);
        }
        if ((iParamValElementA = CIMXMLParserImpl.searchNodes(pIMethodCallE, "IPARAMVALUE", 0, Integer.MAX_VALUE, true)) != null) {
            CIMArgument[] argA = new CIMArgument[iParamValElementA.length];
            for (int i = 0; i < iParamValElementA.length; ++i) {
                CIMObjectPath op;
                Element paramvalueE = iParamValElementA[i];
                CIMArgument<Object> arg = CIMXMLParserImpl.parseIPARAMVALUE(paramvalueE);
                Object value = arg.getValue();
                if (value instanceof CIMObjectPath && ((op = (CIMObjectPath)value).getNamespace() == null || op.getNamespace().length() == 0)) {
                    arg = new CIMArgument<CIMObjectPath>(arg.getName(), arg.getDataType(), new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), request.getNameSpace(), op.getObjectName(), op.getKeys()));
                }
                argA[i] = arg;
            }
            request.addParamValue(argA);
        }
        CIMXMLParserImpl.checkOtherNodes(pIMethodCallE, nodesIMETHODCALL);
        return request;
    }

    public static CIMRequest parseSIMPLEEXPREQ(Element pSimpleExpReqE) throws CIMXMLParseException {
        CIMRequest request = null;
        Element[] expmethodcallA = CIMXMLParserImpl.searchNodes(pSimpleExpReqE, "EXPMETHODCALL", 1, 1, true);
        if (expmethodcallA == null) {
            throw new CIMXMLParseException("SIMPLEEXPREQ element missing EXPMETHODCALL child element!");
        }
        request = CIMXMLParserImpl.parseEXPMETHODCALL(expmethodcallA[0]);
        Element[] correlatorA = CIMXMLParserImpl.searchNodes(pSimpleExpReqE, "CORRELATOR", 0, Integer.MAX_VALUE, true);
        if (correlatorA != null) {
            for (int i = 0; i < correlatorA.length; ++i) {
                CIMXMLParserImpl.parseCORRELATOR(correlatorA[i]);
            }
        }
        CIMXMLParserImpl.checkOtherNodes(pSimpleExpReqE, nodesSIMPLEEXPREQ);
        return request;
    }

    public static CIMRequest parseMULTIEXPREQ(Element pMultiExpReqE) throws CIMXMLParseException {
        Element[] methodReqElementA = CIMXMLParserImpl.searchNodes(pMultiExpReqE, "SIMPLEEXPREQ", 2, Integer.MAX_VALUE, false);
        if (methodReqElementA != null) {
            CIMRequest multiReq = new CIMRequest();
            for (int i = 0; i < methodReqElementA.length; ++i) {
                Element methodrequestE = methodReqElementA[i];
                CIMRequest req = CIMXMLParserImpl.parseSIMPLEEXPREQ(methodrequestE);
                req.setMethod("SIMPLEEXPREQ");
                multiReq.addRequest(req);
            }
            return multiReq;
        }
        throw new CIMXMLParseException("MULTIEXPREQ element missing SIMPLEEXPREQ child element!");
    }

    public static CIMRequest parseEXPMETHODCALL(Element pExpMethodCallE) throws CIMXMLParseException {
        CIMRequest request = new CIMRequest();
        String methodname = CIMXMLParserImpl.attribute(pExpMethodCallE, "NAME");
        if (methodname == null) {
            throw new CIMXMLParseException("EXPMETHODCALL element missing NAME attribute!");
        }
        request.setMethodName(methodname);
        Element[] paramValElementA = CIMXMLParserImpl.searchNodes(pExpMethodCallE, "EXPPARAMVALUE", 0, Integer.MAX_VALUE, false);
        Vector<CIMInstance> v = new Vector<CIMInstance>();
        if (paramValElementA != null) {
            for (int i = 0; i < paramValElementA.length; ++i) {
                Element expparamvalueE = paramValElementA[i];
                CIMInstance inst = CIMXMLParserImpl.parseEXPPARAMVALUE(expparamvalueE);
                v.add(inst);
            }
        }
        request.addParamValue(v);
        CIMXMLParserImpl.checkOtherNodes(pExpMethodCallE, nodesEXPMETHODCALL);
        return request;
    }

    public static CIMInstance parseEXPPARAMVALUE(Element pExpParamValueE) throws CIMXMLParseException {
        if (CIMXMLParserImpl.attribute(pExpParamValueE, "NAME") == null) {
            throw new CIMXMLParseException("EXPPARAMVALUE element missing NAME attribute!");
        }
        Element[] instanceA = CIMXMLParserImpl.searchNodes(pExpParamValueE, "INSTANCE", 0, 1, false);
        if (instanceA != null) {
            CIMInstance inst = CIMXMLParserImpl.parseINSTANCE(instanceA[0]);
            return inst;
        }
        CIMXMLParserImpl.checkOtherNodes(pExpParamValueE, nodesEXPPARAMVALUE);
        return null;
    }

    public static CIMResponse parseMETHODRESPONSE(Element pMethodResponseE) throws CIMXMLParseException {
        Element[] paramValElementA;
        int i;
        if (CIMXMLParserImpl.attribute(pMethodResponseE, "NAME") == null) {
            throw new CIMXMLParseException("METHODRESPONSE element missing NAME attribute!");
        }
        CIMResponse response = new CIMResponse();
        Element[] errorA = CIMXMLParserImpl.searchNodes(pMethodResponseE, "ERROR", 0, 1, false);
        if (errorA != null) {
            WBEMException exception = CIMXMLParserImpl.parseERROR(errorA[0]);
            response.setError(exception);
            return response;
        }
        Element[] retValElementA = CIMXMLParserImpl.searchNodes(pMethodResponseE, "RETURNVALUE", 0, 1, true);
        if (retValElementA != null) {
            Vector<Object> v = new Vector<Object>();
            for (i = 0; i < retValElementA.length; ++i) {
                Element returnvalueE = retValElementA[i];
                v.add(CIMXMLParserImpl.parseRETURNVALUE(returnvalueE));
            }
            response.setReturnValue(v);
        }
        if ((paramValElementA = CIMXMLParserImpl.searchNodes(pMethodResponseE, "PARAMVALUE", 0, Integer.MAX_VALUE, true)) != null) {
            Vector<Object> v = new Vector<Object>();
            for (int i2 = 0; i2 < paramValElementA.length; ++i2) {
                Element paramvalueE = paramValElementA[i2];
                CIMArgument<Object> arg = CIMXMLParserImpl.parsePARAMVALUE(paramvalueE);
                v.add(arg);
            }
            response.addParamValue(v);
        }
        if (retValElementA != null) {
            for (i = 0; i < retValElementA.length; ++i) {
                Element retValE = retValElementA[i];
                paramValElementA = CIMXMLParserImpl.searchNodes(retValE, "PARAMVALUE");
                if (paramValElementA == null) continue;
                Vector<CIMArgument<Object>> v = new Vector<CIMArgument<Object>>();
                for (int j = 0; j < paramValElementA.length; ++j) {
                    Element paramvalueE = paramValElementA[j];
                    CIMArgument<Object> arg = CIMXMLParserImpl.parsePARAMVALUE(paramvalueE);
                    v.add(arg);
                }
                response.addParamValue(v);
            }
        }
        CIMXMLParserImpl.checkOtherNodes(pMethodResponseE, nodesMETHODRESPONSE);
        return response;
    }

    public static CIMResponse parseIMETHODRESPONSE(Element pIMethodResponseE) throws CIMXMLParseException {
        Element[] paramValElementA;
        if (CIMXMLParserImpl.attribute(pIMethodResponseE, "NAME") == null) {
            throw new CIMXMLParseException("IMETHODRESPONSE element missing NAME attribute!");
        }
        CIMResponse response = new CIMResponse();
        Element[] errorA = CIMXMLParserImpl.searchNodes(pIMethodResponseE, "ERROR", 0, 1, false);
        if (errorA != null) {
            WBEMException exception = CIMXMLParserImpl.parseERROR(errorA[0]);
            response.setError(exception);
            return response;
        }
        Element[] retValElementA = CIMXMLParserImpl.searchNodes(pIMethodResponseE, "IRETURNVALUE", 0, 1, true);
        if (retValElementA != null) {
            for (int i = 0; i < retValElementA.length; ++i) {
                Element ireturnvalueE = retValElementA[i];
                Vector<Object> rtnV = CIMXMLParserImpl.parseIRETURNVALUE(ireturnvalueE);
                response.setReturnValue(rtnV);
            }
        }
        if ((paramValElementA = CIMXMLParserImpl.searchNodes(pIMethodResponseE, "PARAMVALUE", 0, Integer.MAX_VALUE, true)) != null) {
            Vector<Object> v = new Vector<Object>();
            for (int i = 0; i < paramValElementA.length; ++i) {
                Element paramvalueE = paramValElementA[i];
                CIMArgument<Object> arg = CIMXMLParserImpl.parsePARAMVALUE(paramvalueE);
                v.add(arg);
            }
            response.addParamValue(v);
        }
        CIMXMLParserImpl.checkOtherNodes(pIMethodResponseE, nodesIMETHODRESPONSE);
        return response;
    }

    public static WBEMException parseERROR(Element pErrorE) throws CIMXMLParseException {
        Attr error_codeA = (Attr)CIMXMLParserImpl.searchAttribute(pErrorE, "CODE");
        if (error_codeA == null) {
            throw new CIMXMLParseException("ERROR element missing CODE attribute!");
        }
        String code = error_codeA.getNodeValue();
        int errorCode = 0;
        try {
            if (code.length() > 0) {
                errorCode = Integer.parseInt(code);
            }
        }
        catch (Exception e) {
            LogAndTraceBroker.getBroker().trace(Level.WARNING, "exception while parsing error code from XML", e);
            errorCode = 1;
        }
        Attr error_descriptionA = (Attr)CIMXMLParserImpl.searchAttribute(pErrorE, "DESCRIPTION");
        String description = "";
        if (error_descriptionA != null) {
            description = error_descriptionA.getNodeValue();
        }
        Vector<CIMInstance> rtnV = new Vector<CIMInstance>();
        Element[] instElementA = CIMXMLParserImpl.searchNodes(pErrorE, "INSTANCE", 0, Integer.MAX_VALUE, false);
        if (instElementA != null) {
            for (int i = 0; i < instElementA.length; ++i) {
                Element instanceE = instElementA[i];
                CIMInstance inst = CIMXMLParserImpl.parseINSTANCE(instanceE);
                rtnV.add(inst);
            }
        }
        CIMXMLParserImpl.checkOtherNodes(pErrorE, nodesERROR);
        if (!rtnV.isEmpty()) {
            return new WBEMException(errorCode, "ErrorCode:" + errorCode + " description:" + description, rtnV.toArray(new CIMInstance[0]));
        }
        return new WBEMException(errorCode, "ErrorCode:" + errorCode + " description:" + description);
    }

    public static Object parseRETURNVALUE(Element pRetValE) throws CIMXMLParseException {
        CIMXMLParserImpl.checkOtherNodes(pRetValE, nodesRETURNVALUE);
        if (CIMXMLParserImpl.searchNodes(pRetValE, "VALUE", 0, 1, false) != null) {
            EmbObjHandler embObjHandler = new EmbObjHandler(pRetValE);
            return embObjHandler.getValue();
        }
        if (CIMXMLParserImpl.searchNodes(pRetValE, "VALUE.REFERENCE", 0, 1, false) != null) {
            TypedValue typedVal = CIMXMLParserImpl.parseSingleValue(pRetValE, 4);
            Object value = typedVal.getValue();
            return value;
        }
        CIMXMLParserImpl.checkOtherNodes(pRetValE, nodesRETURNVALUE);
        return null;
    }

    public static Vector<Object> parseIRETURNVALUE(Element pIRetValE) throws CIMXMLParseException {
        Vector<Object> rtnV = new Vector<Object>();
        Element[] classElementA = CIMXMLParserImpl.searchNodes(pIRetValE, "CLASS", 0, Integer.MAX_VALUE, false);
        if (classElementA != null) {
            for (int i = 0; i < classElementA.length; ++i) {
                Element classE = classElementA[i];
                CIMClass c = CIMXMLParserImpl.parseCLASS(classE);
                rtnV.add(c);
            }
            return rtnV;
        }
        Element[] instElementA = CIMXMLParserImpl.searchNodes(pIRetValE, "INSTANCE", 0, Integer.MAX_VALUE, false);
        if (instElementA != null) {
            for (int i = 0; i < instElementA.length; ++i) {
                Element instanceE = instElementA[i];
                CIMInstance inst = CIMXMLParserImpl.parseINSTANCE(instanceE);
                rtnV.add(inst);
            }
            return rtnV;
        }
        Element[] classNameElementA = CIMXMLParserImpl.searchNodes(pIRetValE, "CLASSNAME", 0, Integer.MAX_VALUE, false);
        if (classNameElementA != null) {
            for (int i = 0; i < classNameElementA.length; ++i) {
                Element classnameE = classNameElementA[i];
                CIMObjectPath op = CIMXMLParserImpl.parseCLASSNAME(classnameE);
                rtnV.add(op);
            }
            return rtnV;
        }
        Element[] instNameElementA = CIMXMLParserImpl.searchNodes(pIRetValE, "INSTANCENAME", 0, Integer.MAX_VALUE, false);
        if (instNameElementA != null) {
            for (int i = 0; i < instNameElementA.length; ++i) {
                Element instancenameE = instNameElementA[i];
                CIMObjectPath op = CIMXMLParserImpl.parseINSTANCENAME(instancenameE);
                rtnV.add(op);
            }
            return rtnV;
        }
        Element[] instpathElementA = CIMXMLParserImpl.searchNodes(pIRetValE, "INSTANCEPATH", 0, Integer.MAX_VALUE, false);
        if (instpathElementA != null) {
            for (int i = 0; i < instpathElementA.length; ++i) {
                Element instancePathE = instpathElementA[i];
                CIMObjectPath op = CIMXMLParserImpl.parseINSTANCEPATH(instancePathE);
                rtnV.add(op);
            }
            return rtnV;
        }
        Element[] objPathElementA = CIMXMLParserImpl.searchNodes(pIRetValE, "OBJECTPATH", 0, Integer.MAX_VALUE, false);
        if (objPathElementA != null) {
            for (int i = 0; i < objPathElementA.length; ++i) {
                Element objectpathE = objPathElementA[i];
                CIMObjectPath op = CIMXMLParserImpl.parseOBJECTPATH(objectpathE);
                rtnV.add(op);
            }
            return rtnV;
        }
        Element[] valueElementA = CIMXMLParserImpl.searchNodes(pIRetValE, "VALUE", 0, Integer.MAX_VALUE, false);
        if (valueElementA != null) {
            for (int i = 0; i < valueElementA.length; ++i) {
                Element valueE = valueElementA[i];
                TypedValue tv = CIMXMLParserImpl.parseVALUE(valueE);
                rtnV.add(tv.getValue());
            }
            return rtnV;
        }
        Element[] valueArrayElementA = CIMXMLParserImpl.searchNodes(pIRetValE, "VALUE.ARRAY", 0, 1, false);
        if (valueArrayElementA != null) {
            Element valuearrayE = valueArrayElementA[0];
            TypedValue tv = CIMXMLParserImpl.parseVALUEARRAY(valuearrayE);
            rtnV.add(tv.getValue());
            return rtnV;
        }
        Element[] valRefElementA = CIMXMLParserImpl.searchNodes(pIRetValE, "VALUE.REFERENCE", 0, 1, false);
        if (valRefElementA != null) {
            Element valuereferenceE = valRefElementA[0];
            CIMObjectPath op = CIMXMLParserImpl.parseVALUEREFERENCE(valuereferenceE);
            rtnV.add(op);
            return rtnV;
        }
        Element[] valObjElementA = CIMXMLParserImpl.searchNodes(pIRetValE, "VALUE.OBJECT", 0, Integer.MAX_VALUE, false);
        if (valObjElementA != null) {
            for (int i = 0; i < valObjElementA.length; ++i) {
                Element valueobjectE = valObjElementA[i];
                CIMNamedElementInterface obj = CIMXMLParserImpl.parseVALUEOBJECT(valueobjectE);
                rtnV.add(obj);
            }
            return rtnV;
        }
        Element[] valNamedInstElementA = CIMXMLParserImpl.searchNodes(pIRetValE, "VALUE.NAMEDINSTANCE", 0, Integer.MAX_VALUE, false);
        if (valNamedInstElementA != null) {
            for (int i = 0; i < valNamedInstElementA.length; ++i) {
                Element valuenamedisntanceE = valNamedInstElementA[i];
                CIMInstance inst = CIMXMLParserImpl.parseVALUENAMEDINSTANCE(valuenamedisntanceE);
                rtnV.add(inst);
            }
            return rtnV;
        }
        Element[] valInstWithPathElementA = CIMXMLParserImpl.searchNodes(pIRetValE, "VALUE.INSTANCEWITHPATH", 0, Integer.MAX_VALUE, false);
        if (valInstWithPathElementA != null) {
            for (int i = 0; i < valInstWithPathElementA.length; ++i) {
                Element valueinstancewithpathE = valInstWithPathElementA[i];
                CIMInstance inst = CIMXMLParserImpl.parseVALUEINSTANCEWITHPATH(valueinstancewithpathE);
                rtnV.add(inst);
            }
            return rtnV;
        }
        Element[] valObjWithPathElementA = CIMXMLParserImpl.searchNodes(pIRetValE, "VALUE.OBJECTWITHPATH", 0, Integer.MAX_VALUE, false);
        if (valObjWithPathElementA != null) {
            for (int i = 0; i < valObjWithPathElementA.length; ++i) {
                Element valueobjectwithpathE = valObjWithPathElementA[i];
                CIMNamedElementInterface namedIF = CIMXMLParserImpl.parseVALUEOBJECTWITHPATH(valueobjectwithpathE);
                rtnV.add(namedIF);
            }
            return rtnV;
        }
        Element[] valObjWithLocalPathElementA = CIMXMLParserImpl.searchNodes(pIRetValE, "VALUE.OBJECTWITHLOCALPATH", 0, Integer.MAX_VALUE, false);
        if (valObjWithLocalPathElementA != null) {
            for (int i = 0; i < valObjWithLocalPathElementA.length; ++i) {
                Element valueobjectwithlocalpathE = valObjWithLocalPathElementA[i];
                CIMNamedElementInterface namedIF = CIMXMLParserImpl.parseVALUEOBJECTWITHLOCALPATH(valueobjectwithlocalpathE);
                rtnV.add(namedIF);
            }
            return rtnV;
        }
        Element[] qualiDeclElementA = CIMXMLParserImpl.searchNodes(pIRetValE, "QUALIFIER.DECLARATION", 0, Integer.MAX_VALUE, false);
        if (qualiDeclElementA != null) {
            for (int i = 0; i < qualiDeclElementA.length; ++i) {
                Element qualifierdeclarationE = qualiDeclElementA[i];
                CIMQualifierType<Object> o = CIMXMLParserImpl.parseQUALIFIERDECLARATION(qualifierdeclarationE);
                rtnV.add(o);
            }
            return rtnV;
        }
        CIMXMLParserImpl.checkOtherNodes(pIRetValE, nodesIRETURNVALUE);
        return rtnV;
    }

    public static Object parseObject(Element pRootE) throws CIMXMLParseException {
        CIMTypedElement o = null;
        String nodeName = pRootE.getNodeName();
        if (nodeName.equalsIgnoreCase("INSTANCE")) {
            o = CIMXMLParserImpl.parseINSTANCE(pRootE);
        } else if (nodeName.equalsIgnoreCase("VALUE.NAMEDINSTANCE")) {
            o = CIMXMLParserImpl.parseVALUENAMEDINSTANCE(pRootE);
        } else if (nodeName.equalsIgnoreCase("VALUE.NAMEDOBJECT")) {
            o = CIMXMLParserImpl.parseVALUENAMEDOBJECT(pRootE);
        } else if (nodeName.equalsIgnoreCase("VALUE.OBJECTWITHPATH")) {
            o = CIMXMLParserImpl.parseVALUEOBJECTWITHPATH(pRootE);
        } else if (nodeName.equalsIgnoreCase("VALUE.OBJECTWITHLOCALPATH")) {
            o = CIMXMLParserImpl.parseVALUEOBJECTWITHLOCALPATH(pRootE);
        } else if (nodeName.equalsIgnoreCase("CLASS")) {
            o = CIMXMLParserImpl.parseCLASS(pRootE);
        } else if (nodeName.equalsIgnoreCase("CLASSPATH")) {
            o = CIMXMLParserImpl.parseCLASSPATH(pRootE);
        } else if (nodeName.equalsIgnoreCase("LOCALCLASSPATH")) {
            o = CIMXMLParserImpl.parseLOCALCLASSPATH(pRootE);
        } else if (nodeName.equalsIgnoreCase("OBJECTPATH")) {
            o = CIMXMLParserImpl.parseOBJECTPATH(pRootE);
        } else if (nodeName.equalsIgnoreCase("CLASSNAME")) {
            o = CIMXMLParserImpl.parseCLASSNAME(pRootE);
        } else if (nodeName.equalsIgnoreCase("INSTANCEPATH")) {
            o = CIMXMLParserImpl.parseINSTANCEPATH(pRootE);
        } else if (nodeName.equalsIgnoreCase("LOCALINSTANCEPATH")) {
            o = CIMXMLParserImpl.parseLOCALINSTANCEPATH(pRootE);
        } else if (nodeName.equalsIgnoreCase("INSTANCENAME")) {
            o = CIMXMLParserImpl.parseINSTANCENAME(pRootE);
        } else if (nodeName.equalsIgnoreCase("QUALIFIER")) {
            o = CIMXMLParserImpl.parseQUALIFIER(pRootE);
        } else if (nodeName.equalsIgnoreCase("PROPERTY")) {
            o = CIMXMLParserImpl.parsePROPERTY(pRootE);
        } else if (nodeName.equalsIgnoreCase("PROPERTY.ARRAY")) {
            o = CIMXMLParserImpl.parsePROPERTYARRAY(pRootE);
        } else if (nodeName.equalsIgnoreCase("PROPERTY.REFERENCE")) {
            o = CIMXMLParserImpl.parsePROPERTYREFERENCE(pRootE);
        } else if (nodeName.equalsIgnoreCase("METHOD")) {
            o = CIMXMLParserImpl.parseMETHOD(pRootE);
        } else if (nodeName.equalsIgnoreCase("PARAMETER")) {
            o = CIMXMLParserImpl.parsePARAMETER(pRootE);
        } else if (nodeName.equalsIgnoreCase("PARAMETER.REFERENCE")) {
            o = CIMXMLParserImpl.parsePARAMETERREFERENCE(pRootE);
        } else if (nodeName.equalsIgnoreCase("PARAMETER.ARRAY")) {
            o = CIMXMLParserImpl.parsePARAMETERARRAY(pRootE);
        } else if (nodeName.equalsIgnoreCase("PARAMETER.REFARRAY")) {
            o = CIMXMLParserImpl.parsePARAMETERREFARRAY(pRootE);
        }
        return o;
    }

    private static boolean hasNodes(Element pParentE) {
        NodeList nl = pParentE.getChildNodes();
        if (nl == null || nl.getLength() == 0) {
            return false;
        }
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n instanceof Text && "".equalsIgnoreCase(n.getNodeValue().trim())) continue;
            return true;
        }
        return false;
    }

    private static boolean hasTypeAttrsInNodes(Element pParentE) {
        NodeList nl = pParentE.getChildNodes();
        if (nl == null || nl.getLength() == 0) {
            return false;
        }
        for (int i = 0; i < nl.getLength(); ++i) {
            NamedNodeMap nm;
            Node n = nl.item(i);
            String name = n.getNodeName();
            if (!"VALUE".equalsIgnoreCase(name) && !"VALUE.ARRAY".equalsIgnoreCase(name) || (nm = n.getAttributes()) == null || nm.getNamedItem("TYPE") == null && nm.getNamedItem("PARAMTYPE") == null) continue;
            return true;
        }
        return false;
    }

    private static void initNodeNameHash(String[] pEnumA) {
        for (int i = 0; i < pEnumA.length; ++i) {
            NODENAME_HASH.put(pEnumA[i], pEnumA[i]);
        }
    }

    private static void checkOtherNodes(Element pParentE, String[] pAllowedChildNodes) throws CIMXMLParseException {
        NodeList nl = pParentE.getChildNodes();
        if (nl == null || nl.getLength() == 0) {
            return;
        }
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n instanceof Text && "".equalsIgnoreCase(n.getNodeValue().trim())) continue;
            boolean found = false;
            String name = n.getNodeName().toUpperCase();
            for (int j = 0; j < pAllowedChildNodes.length; ++j) {
                if (!pAllowedChildNodes[j].equalsIgnoreCase(name)) continue;
                found = true;
                break;
            }
            if (found || !NODENAME_HASH.containsKey(name)) continue;
            throw new CIMXMLParseException(pParentE.getNodeName() + " element contains invalid child element " + name + "!");
        }
    }

    public static Element[] searchNodes(Element pParentE, String pTagName) {
        NodeList nl = pParentE.getChildNodes();
        if (nl == null || nl.getLength() == 0) {
            return null;
        }
        Vector<Node> resElementV = new Vector<Node>();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!n.getNodeName().equals(pTagName)) continue;
            resElementV.add(n);
        }
        return resElementV.toArray(new Element[0]);
    }

    public static Element[] searchNodes(Element pParentE, String pTagName, int pMin, int pMax, boolean pAllowOtherNodes) throws CIMXMLParseException {
        NodeList nl = pParentE.getChildNodes();
        if (nl == null || nl.getLength() == 0) {
            if (pMin > 0) {
                throw new CIMXMLParseException(pParentE.getNodeName() + " element must have at least " + pMin + " " + pTagName + " child element(s)!");
            }
            return null;
        }
        String otherNode = null;
        Vector<Node> resElementV = new Vector<Node>();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            String name = n.getNodeName().toUpperCase();
            if (name.equals(pTagName)) {
                resElementV.add(n);
                continue;
            }
            if (!NODENAME_HASH.containsKey(name)) continue;
            otherNode = name;
        }
        if (resElementV.size() < pMin) {
            throw new CIMXMLParseException(pParentE.getNodeName() + " element must have at least " + pMin + " " + pTagName + " child element(s)!");
        }
        if (resElementV.size() > pMax) {
            throw new CIMXMLParseException(pParentE.getNodeName() + " element can have no more than " + pMax + " " + pTagName + " child element(s)!");
        }
        if (resElementV.size() > 0 && !pAllowOtherNodes && otherNode != null) {
            throw new CIMXMLParseException(pParentE.getNodeName() + " element cannot have " + otherNode + " child element(s) when it already has " + pTagName + " element(s)!");
        }
        if (resElementV.size() == 0) {
            return null;
        }
        return resElementV.toArray(new Element[0]);
    }

    public static Node searchFirstNode(Element pParentE, String pTagName) {
        NodeList nl = pParentE.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!n.getNodeName().equals(pTagName)) continue;
            return n;
        }
        return null;
    }

    public static Node searchAttribute(Node pParentN, String pAttrName) {
        NamedNodeMap nnm = pParentN.getAttributes();
        return nnm.getNamedItem(pAttrName);
    }

    public static Node searchFirstChild(Element pParentE) {
        return pParentE.getFirstChild();
    }

    public static Object createJavaObject(String pTypeStr, String pValue) throws CIMXMLParseException {
        if (pTypeStr == null) {
            pTypeStr = "string";
        }
        if ("null".equalsIgnoreCase(pTypeStr)) {
            return null;
        }
        Object o = null;
        CIMDataType cimType = CIMXMLParserImpl.parseTypeStr(pTypeStr, false);
        int radix = 10;
        if ((pTypeStr.toLowerCase().startsWith("sint") || pTypeStr.toLowerCase().startsWith("uint")) && ((pValue = pValue.toLowerCase()).startsWith("0x") || pValue.startsWith("+0x") || pValue.startsWith("-0x"))) {
            radix = 16;
            pValue = pValue.startsWith("-") ? "-" + pValue.substring(3) : pValue.substring(pValue.indexOf(120) + 1);
        }
        switch (cimType.getType()) {
            case 0: {
                o = new UnsignedInteger8(Short.parseShort(pValue, radix));
                break;
            }
            case 2: {
                o = new UnsignedInteger16(Integer.parseInt(pValue, radix));
                break;
            }
            case 4: {
                o = new UnsignedInteger32(Long.parseLong(pValue, radix));
                break;
            }
            case 6: {
                o = new UnsignedInteger64(new BigInteger(pValue, radix));
                break;
            }
            case 1: {
                o = Byte.valueOf(pValue, radix);
                break;
            }
            case 3: {
                o = Short.valueOf(pValue, radix);
                break;
            }
            case 5: {
                o = Integer.valueOf(pValue, radix);
                break;
            }
            case 7: {
                o = Long.valueOf(pValue, radix);
                break;
            }
            case 8: {
                o = pValue;
                break;
            }
            case 9: {
                o = Boolean.valueOf(pValue);
                break;
            }
            case 10: {
                o = new Float(pValue);
                break;
            }
            case 11: {
                if (WBEMConfiguration.getGlobalConfiguration().verifyJavaLangDoubleStrings() && Util.isBadDoubleString(pValue)) {
                    throw new IllegalArgumentException("Double value string hangs older JVMs!\n" + pValue);
                }
                o = new Double(pValue);
                break;
            }
            case 12: {
                o = CIMXMLParserImpl.getDateTime(pValue);
                break;
            }
            case 14: {
                o = new CIMObjectPath(pValue);
                break;
            }
            case 13: {
                o = Character.valueOf(pValue.charAt(0));
            }
        }
        return o;
    }

    private static CIMDateTime getDateTime(String pValue) throws CIMXMLParseException {
        try {
            return new CIMDateTimeAbsolute(pValue);
        }
        catch (IllegalArgumentException eAbs) {
            try {
                return new CIMDateTimeInterval(pValue);
            }
            catch (IllegalArgumentException eInt) {
                throw new CIMXMLParseException("Failed to parse dateTime string: " + pValue + "!\nCIMDateTimeAbsolute parsing error:\n" + eAbs.getMessage() + "\nCIMDateTimeInterval parsing error:\n" + eInt.getMessage());
            }
        }
    }

    public static CIMResponse parseSIMPLEEXPRSP(Element pSimpleExpRspE) throws CIMXMLParseException {
        Element[] expmethodresponseA = CIMXMLParserImpl.searchNodes(pSimpleExpRspE, "EXPMETHODRESPONSE", 1, 1, false);
        if (expmethodresponseA != null) {
            return CIMXMLParserImpl.parseEXPMETHODRESPONSE(expmethodresponseA[0]);
        }
        throw new CIMXMLParseException("SIMPLEEXPRSP element missing EXPMETHODRESPONSE child element!");
    }

    public static CIMResponse parseMULTIEXPRSP(Element pMultiExpRspE) throws CIMXMLParseException {
        Element[] multiExpRespElementA = CIMXMLParserImpl.searchNodes(pMultiExpRspE, "SIMPLEEXPRSP", 2, Integer.MAX_VALUE, false);
        if (multiExpRespElementA != null) {
            CIMResponse multiExpRsp = new CIMResponse();
            for (int i = 0; i < multiExpRespElementA.length; ++i) {
                Element methodresponseE = multiExpRespElementA[i];
                CIMResponse rsp = CIMXMLParserImpl.parseSIMPLEEXPRSP(methodresponseE);
                rsp.setMethod("SIMPLEEXPRSP");
                multiExpRsp.addResponse(rsp);
            }
            return multiExpRsp;
        }
        throw new CIMXMLParseException("MULTIEXPRSP element missing SIMPLEEXPRSP child element!");
    }

    public static CIMResponse parseEXPMETHODRESPONSE(Element pExpMethodResponseE) throws CIMXMLParseException {
        CIMResponse response = new CIMResponse();
        if (CIMXMLParserImpl.attribute(pExpMethodResponseE, "NAME") == null) {
            throw new CIMXMLParseException("EXPMETHODRESPONSE element missing NAME attribute!");
        }
        Element[] errorA = CIMXMLParserImpl.searchNodes(pExpMethodResponseE, "ERROR", 0, 1, false);
        if (errorA != null) {
            WBEMException exception = CIMXMLParserImpl.parseERROR(errorA[0]);
            response.setError(exception);
            return response;
        }
        Element[] retValElementA = CIMXMLParserImpl.searchNodes(pExpMethodResponseE, "IRETURNVALUE", 0, 1, false);
        if (retValElementA != null) {
            Vector<Object> v = new Vector<Object>();
            Element returnvalueE = retValElementA[0];
            v.add(CIMXMLParserImpl.parseIRETURNVALUE(returnvalueE));
            response.setReturnValue(v);
            return response;
        }
        CIMXMLParserImpl.checkOtherNodes(pExpMethodResponseE, nodesEXPMETHODRESPONSE);
        return response;
    }

    public static void parseCORRELATOR(Element pCorrelatorE) throws CIMXMLParseException {
        String name = CIMXMLParserImpl.attribute(pCorrelatorE, "NAME");
        if (name == null) {
            throw new CIMXMLParseException("CORRELATOR element missing NAME attribute!");
        }
        String type = CIMXMLParserImpl.attribute(pCorrelatorE, "TYPE");
        if (type == null) {
            throw new CIMXMLParseException("CORRELATOR element missing TYPE attribute!");
        }
        Element[] valueA = CIMXMLParserImpl.searchNodes(pCorrelatorE, "VALUE", 1, 1, false);
        if (valueA != null) {
            // empty if block
        }
        CIMXMLParserImpl.checkOtherNodes(pCorrelatorE, nodesCORRELATOR);
    }

    static {
        TYPESTR_MAP.put("uint8", CIMDataType.UINT8_T);
        TYPESTR_MAP.put("uint16", CIMDataType.UINT16_T);
        TYPESTR_MAP.put("uint32", CIMDataType.UINT32_T);
        TYPESTR_MAP.put("uint64", CIMDataType.UINT64_T);
        TYPESTR_MAP.put("sint8", CIMDataType.SINT8_T);
        TYPESTR_MAP.put("sint16", CIMDataType.SINT16_T);
        TYPESTR_MAP.put("sint32", CIMDataType.SINT32_T);
        TYPESTR_MAP.put("sint64", CIMDataType.SINT64_T);
        TYPESTR_MAP.put("real32", CIMDataType.REAL32_T);
        TYPESTR_MAP.put("real64", CIMDataType.REAL64_T);
        TYPESTR_MAP.put("char16", CIMDataType.CHAR16_T);
        TYPESTR_MAP.put("string", CIMDataType.STRING_T);
        TYPESTR_MAP.put("boolean", CIMDataType.BOOLEAN_T);
        TYPESTR_MAP.put("datetime", CIMDataType.DATETIME_T);
        TYPESTR_MAP.put("invalid", CIMDataType.INVALID_T);
        TYPESTR_MAP.put("object", CIMDataType.OBJECT_T);
        TYPESTR_MAP.put("class", CIMDataType.CLASS_T);
        TYPESTR_MAP.put("reference", new CIMDataType(""));
        nodesCLASS = new String[]{"QUALIFIER", "PROPERTY", "PROPERTY.ARRAY", "PROPERTY.REFERENCE", "METHOD"};
        nodesMETHOD = new String[]{"QUALIFIER", "PARAMETER", "PARAMETER.REFERENCE", "PARAMETER.ARRAY", "PARAMETER.REFARRAY"};
        nodesPARAMETER = new String[]{"QUALIFIER"};
        nodesPARAMETERREFERENCE = new String[]{"QUALIFIER"};
        nodesPARAMETERARRAY = new String[]{"QUALIFIER"};
        nodesPARAMETERREFARRAY = new String[]{"QUALIFIER"};
        nodesINSTANCE = new String[]{"QUALIFIER", "PROPERTY", "PROPERTY.ARRAY", "PROPERTY.REFERENCE"};
        nodesQUALIFIER = new String[]{"VALUE", "VALUE.ARRAY"};
        nodesPROPERTY = new String[]{"QUALIFIER", "VALUE"};
        nodesPROPERTYARRAY = new String[]{"QUALIFIER", "VALUE.ARRAY"};
        nodesPROPERTYREFERENCE = new String[]{"QUALIFIER", "VALUE.REFERENCE"};
        nodesPARAMVALUE = new String[]{"VALUE", "VALUE.REFERENCE", "VALUE.ARRAY", "VALUE.REFARRAY", "CLASSNAME", "INSTANCENAME", "CLASS", "INSTANCE", "VALUE.NAMEDINSTANCE"};
        nodesIPARAMVALUE = new String[]{"VALUE", "VALUE.ARRAY", "VALUE.REFERENCE", "CLASSNAME", "INSTANCENAME", "QUALIFIER.DECLARATION", "CLASS", "INSTANCE", "VALUE.NAMEDINSTANCE"};
        nodesSIMPLEREQ = new String[]{"CORRELATOR", "METHODCALL", "IMETHODCALL"};
        nodesMETHODCALL = new String[]{"LOCALCLASSPATH", "LOCALINSTANCEPATH", "PARAMVALUE"};
        nodesIMETHODCALL = new String[]{"LOCALNAMESPACEPATH", "IPARAMVALUE"};
        nodesSIMPLEEXPREQ = new String[]{"CORRELATOR", "EXPMETHODCALL"};
        nodesEXPMETHODCALL = new String[]{"EXPPARAMVALUE"};
        nodesEXPPARAMVALUE = new String[]{"INSTANCE"};
        nodesMETHODRESPONSE = new String[]{"ERROR", "RETURNVALUE", "PARAMVALUE"};
        nodesIMETHODRESPONSE = new String[]{"ERROR", "IRETURNVALUE", "PARAMVALUE"};
        nodesERROR = new String[]{"INSTANCE"};
        nodesRETURNVALUE = new String[]{"VALUE", "VALUE.REFERENCE"};
        nodesIRETURNVALUE = new String[]{"CLASSNAME", "INSTANCENAME", "VALUE", "VALUE.OBJECTWITHPATH", "VALUE.OBJECTWITHLOCALPATH", "VALUE.OBJECT", "OBJECTPATH", "QUALIFIER.DECLARATION", "VALUE.ARRAY", "VALUE.REFERENCE", "CLASS", "INSTANCE", "INSTANCEPATH", "VALUE.NAMEDINSTANCE"};
        NODENAME_HASH = new HashMap();
        CIMXMLParserImpl.initNodeNameHash(new String[]{"CIM", "DECLARATION", "DECLGROUP", "DECLGROUP.WITHNAME", "DECLGROUP.WITHPATH", "QUALIFIER.DECLARATION", "SCOPE", "VALUE", "VALUE.ARRAY", "VALUE.REFERENCE", "VALUE.REFARRAY", "VALUE.OBJECT", "VALUE.NAMEDINSTANCE", "VALUE.NAMEDOBJECT", "VALUE.OBJECTWITHLOCALPATH", "VALUE.OBJECTWITHPATH", "VALUE.NULL", "VALUE.INSTANCEWITHPATH", "NAMESPACEPATH", "LOCALNAMESPACEPATH", "HOST", "NAMESPACE", "CLASSPATH", "LOCALCLASSPATH", "CLASSNAME", "INSTANCEPATH", "LOCALINSTANCEPATH", "INSTANCENAME", "OBJECTPATH", "KEYBINDING", "KEYVALUE", "CLASS", "INSTANCE", "QUALIFIER", "PROPERTY", "PROPERTY.ARRAY", "PROPERTY.REFERENCE", "METHOD", "PARAMETER", "PARAMETER.REFERENCE", "PARAMETER.ARRAY", "PARAMETER.REFARRAY", "MESSAGE", "MULTIREQ", "MULTIEXPREQ", "SIMPLEREQ", "SIMPLEEXPREQ", "IMETHODCALL", "METHODCALL", "EXPMETHODCALL", "PARAMVALUE", "IPARAMVALUE", "EXPPARAMVALUE", "MULTIRSP", "MULTIEXPRSP", "SIMPLERSP", "SIMPLEEXPRSP", "METHODRESPONSE", "EXPMETHODRESPONSE", "IMETHODRESPONSE", "ERROR", "RETURNVALUE", "IRETURNVALUE", "CORRELATOR"});
        nodesEXPMETHODRESPONSE = new String[]{"ERROR", "IRETURNVALUE"};
        nodesCORRELATOR = new String[]{"VALUE"};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmbObjHandler {
        private CIMQualifier<?>[] iQualiA;
        private boolean iHasEmbObjAttr;
        private boolean iHasEmbInstAttr;
        private boolean iHasEmbObjQuali;
        private boolean iHasEmbInstQuali;
        private boolean iKeyed;
        private CIMDataType iRawType;
        private CIMDataType iType;
        private Object iRawValue;
        private Object iValue;
        private Element iElement;
        private boolean iStrictParsing = WBEMConfiguration.getGlobalConfiguration().strictEmbObjTypes();

        public EmbObjHandler(Element pElement) throws CIMXMLParseException {
            this.iElement = pElement;
            this.handleQualis();
            this.handleAttribs();
            Element valueE = (Element)CIMXMLParserImpl.searchFirstNode(pElement, "VALUE");
            if (valueE != null) {
                TypedValue tv = CIMXMLParserImpl.parseVALUE(valueE);
                if (this.iRawType == null) {
                    this.iRawType = tv.getType();
                }
                if (this.iRawType == null) {
                    this.iRawType = CIMDataType.STRING_T;
                }
                this.iRawValue = tv.getValue();
            } else {
                valueE = (Element)CIMXMLParserImpl.searchFirstNode(pElement, "VALUE.ARRAY");
                if (valueE != null) {
                    TypedValue tv = CIMXMLParserImpl.parseVALUEARRAY(valueE);
                    if (this.iRawType == null) {
                        this.iRawType = tv.getType();
                    }
                    if (this.iRawType == null) {
                        this.iRawType = CIMDataType.STRING_ARRAY_T;
                    }
                    this.iRawValue = tv.getValue();
                }
            }
        }

        private void handleQualis() throws CIMXMLParseException {
            this.iQualiA = CIMXMLParserImpl.parseQUALIFIERS(this.iElement);
            if (this.iQualiA != null) {
                for (int idx = 0; idx < this.iQualiA.length; ++idx) {
                    String qualiName = this.iQualiA[idx].getName();
                    if ("EmbeddedObject".equalsIgnoreCase(qualiName)) {
                        this.iHasEmbObjQuali = true;
                    } else if ("EMBEDDEDINSTANCE".equalsIgnoreCase(qualiName)) {
                        this.iHasEmbInstQuali = true;
                    } else if ("KEY".equalsIgnoreCase(qualiName)) {
                        this.iKeyed = true;
                    }
                    if (!this.iHasEmbObjQuali && !this.iHasEmbInstQuali || !this.iKeyed) continue;
                    return;
                }
            }
        }

        private void handleAttribs() throws CIMXMLParseException {
            String embObjAttrStr;
            String typeStr = this.iElement.getAttribute("TYPE");
            if (!(typeStr != null && typeStr.length() != 0 || (typeStr = this.iElement.getAttribute("PARAMTYPE")) != null && typeStr.length() != 0)) {
                typeStr = null;
            }
            if (typeStr != null) {
                this.iRawType = CIMXMLParserImpl.parseScalarTypeStr(typeStr);
            }
            if ((embObjAttrStr = this.iElement.getAttribute("EmbeddedObject")) == null || embObjAttrStr.length() == 0) {
                embObjAttrStr = this.iElement.getAttribute("EMBEDDEDOBJECT");
            }
            if (embObjAttrStr == null || embObjAttrStr.length() == 0) {
                this.iHasEmbInstAttr = false;
                this.iHasEmbObjAttr = false;
            } else if ("object".equalsIgnoreCase(embObjAttrStr)) {
                this.iHasEmbObjAttr = true;
                this.iHasEmbInstAttr = false;
            } else if ("instance".equalsIgnoreCase(embObjAttrStr)) {
                this.iHasEmbObjAttr = false;
                this.iHasEmbInstAttr = true;
            } else {
                throw new CIMXMLParseException("EmbeddedObject attribute cannot contain \"" + embObjAttrStr + "\" value!");
            }
        }

        public CIMQualifier<?>[] getQualifiers() throws CIMXMLParseException {
            this.transform();
            CIMQualifiedElementInterfaceImpl qualiImpl = new CIMQualifiedElementInterfaceImpl(this.iQualiA, this.isKeyed(), this.iType == null || this.iType.getType() == 8);
            return qualiImpl.getQualifiers();
        }

        public boolean isKeyed() {
            return this.iKeyed;
        }

        private boolean isEmbeddedObject() {
            return this.iHasEmbObjAttr || this.iHasEmbInstAttr || this.iHasEmbObjQuali || this.iHasEmbInstQuali;
        }

        private boolean isEmbeddedClass() {
            return this.iHasEmbObjAttr || this.iHasEmbObjQuali;
        }

        private boolean isEmbeddedInstance() {
            return this.iHasEmbInstAttr || this.iHasEmbInstQuali;
        }

        public CIMDataType getType() throws CIMXMLParseException {
            this.transform();
            return this.iType;
        }

        public CIMDataType getArrayType() throws CIMXMLParseException {
            this.transform();
            return this.iType.isArray() ? this.iType : CIMHelper.UnboundedArrayDataType(this.iType.getType());
        }

        public Object getValue() throws CIMXMLParseException {
            this.transform();
            return this.iValue;
        }

        private void transform() throws CIMXMLParseException {
            if (this.iType != null) {
                return;
            }
            if (this.iRawValue == null) {
                if (this.isEmbeddedObject()) {
                    if (this.iRawType != CIMDataType.STRING_T) {
                        throw new CIMXMLParseException("Embedded Object CIM-XML element's type must be string. " + this.iRawType + " is invalid!");
                    }
                    this.iType = this.iStrictParsing ? (this.isEmbeddedInstance() ? CIMDataType.OBJECT_T : CIMDataType.CLASS_T) : (this.isEmbeddedInstance() ? CIMDataType.OBJECT_T : CIMDataType.STRING_T);
                } else {
                    this.iType = this.iRawType;
                }
                this.iValue = null;
            } else if (this.isEmbeddedObject()) {
                this.transformEmbObj();
            } else {
                this.transformNormObj();
            }
        }

        private void transformEmbObj() throws CIMXMLParseException {
            if (this.iRawValue instanceof String) {
                this.iValue = EmbObjHandler.parseXmlStr((String)this.iRawValue);
                this.iType = EmbObjHandler.getCIMObjType(this.iValue);
            } else {
                this.iValue = EmbObjHandler.parseXmlStrA((String[])this.iRawValue);
                this.iType = EmbObjHandler.getCIMObjAType((Object[])this.iValue);
            }
            if (this.isEmbeddedInstance() && this.iType.getType() != 15) {
                throw new CIMXMLParseException(this.iElement.getNodeName() + " element is an EmbeddedInstance with non INSTANCE value. It's not valid!");
            }
            if (this.isEmbeddedClass() && this.iType.getType() != 17 && this.iType.getType() != 15) {
                throw new CIMXMLParseException(this.iElement.getNodeName() + " element is an EmbeddedObject with non CLASS/INSTANCE value. It's not valid!");
            }
        }

        private void transformNormObj() throws CIMXMLParseException {
            if (this.iRawValue instanceof String) {
                this.iType = this.iRawType;
                this.iValue = CIMXMLParserImpl.createJavaObject(this.iType == null ? null : this.iType.toString(), (String)this.iRawValue);
            } else {
                String[] rawValueA = (String[])this.iRawValue;
                String typeStr = this.iRawType.toString();
                Object[] objA = new Object[rawValueA.length];
                for (int i = 0; i < objA.length; ++i) {
                    objA[i] = CIMXMLParserImpl.createJavaObject(typeStr, rawValueA[i]);
                }
                this.iType = CIMHelper.UnboundedArrayDataType(this.iRawType.getType());
                this.iValue = objA;
            }
        }

        public static Object parseXmlStr(String pXmlStr) throws CIMXMLParseException {
            if (pXmlStr == null || pXmlStr.length() == 0) {
                return null;
            }
            try {
                CIMClientXML_HelperImpl builder = new CIMClientXML_HelperImpl();
                Document doc = builder.parse(new InputSource(new StringReader(pXmlStr)));
                return CIMXMLParserImpl.parseObject(doc.getDocumentElement());
            }
            catch (CIMXMLParseException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMXMLParseException(e.getMessage() + "\npXmlStr=" + pXmlStr);
            }
        }

        public static Object[] parseXmlStrA(String[] pXmlStrA) throws CIMXMLParseException {
            if (pXmlStrA == null || pXmlStrA.length == 0) {
                return null;
            }
            Object[] objA = new Object[pXmlStrA.length];
            for (int i = 0; i < objA.length; ++i) {
                String xmlStr = pXmlStrA[i];
                objA[i] = xmlStr == null ? null : EmbObjHandler.parseXmlStr(xmlStr);
            }
            return objA;
        }

        public static CIMDataType getCIMObjType(Object pCIMObj) throws CIMXMLParseException {
            if (pCIMObj == null) {
                throw new CIMXMLParseException("cannot have null CIM object! (CIMClass or CIMInstance)");
            }
            if (pCIMObj instanceof CIMInstance) {
                return CIMDataType.OBJECT_T;
            }
            if (pCIMObj instanceof CIMClass) {
                return CIMDataType.CLASS_T;
            }
            throw new CIMXMLParseException(pCIMObj.getClass().getName() + " is not a CIM object! (CIMClass or CIMInstance)");
        }

        public static CIMDataType getCIMObjAType(Object[] pCIMObjA) throws CIMXMLParseException {
            if (pCIMObjA == null || pCIMObjA.length == 0) {
                return CIMDataType.STRING_ARRAY_T;
            }
            CIMDataType type = null;
            for (int i = 0; i < pCIMObjA.length; ++i) {
                if (pCIMObjA[i] == null) continue;
                CIMDataType currType = EmbObjHandler.getCIMObjType(pCIMObjA[i]);
                if (type == null) {
                    type = currType;
                    continue;
                }
                if (type == currType) continue;
                throw new CIMXMLParseException("Embedded Object arrays with different types are not supported");
            }
            if (type == CIMDataType.OBJECT_T) {
                return CIMDataType.OBJECT_ARRAY_T;
            }
            if (type == CIMDataType.CLASS_T) {
                return CIMDataType.CLASS_ARRAY_T;
            }
            return CIMDataType.STRING_ARRAY_T;
        }
    }

    private static class ValueTypeHandler {
        private CIMDataType iType;
        private Object iValue;

        public ValueTypeHandler(String pValueTypeStr, String pValueStr) throws CIMXMLParseException {
            if (pValueTypeStr == null) {
                throw new CIMXMLParseException("KEYVALUE element missing VALUETYPE attribute!");
            }
            if (pValueTypeStr.equals("numeric")) {
                if (!(this.setUInt64(pValueStr) || this.setSInt64(pValueStr) || this.setReal64(pValueStr))) {
                    throw new CIMXMLParseException("Unparseable \"number\" value: " + pValueStr + " !");
                }
            } else if (pValueTypeStr.equals("string")) {
                if (!this.setDTAbsolute(pValueStr) && !this.setDTInterval(pValueStr)) {
                    this.iValue = pValueStr;
                    this.iType = CIMDataType.STRING_T;
                }
            } else if (pValueTypeStr.equals("boolean")) {
                if (!this.setBoolean(pValueStr)) {
                    throw new CIMXMLParseException("Unparseable \"boolean\" value: " + pValueStr + " !");
                }
            } else {
                throw new CIMXMLParseException("KEYVALUE element's VALUETYPE attribute must be string, boolean or numeric! " + pValueStr + " is not allowed!");
            }
        }

        public CIMDataType getType() {
            return this.iType;
        }

        public Object getValue() {
            return this.iValue;
        }

        private boolean setUInt64(String pValue) {
            try {
                this.iValue = new UnsignedInteger64(pValue);
            }
            catch (NumberFormatException e) {
                return false;
            }
            this.iType = CIMDataType.UINT64_T;
            return true;
        }

        private boolean setSInt64(String pValue) {
            try {
                this.iValue = new Long(pValue);
            }
            catch (NumberFormatException e) {
                return false;
            }
            this.iType = CIMDataType.SINT64_T;
            return true;
        }

        private boolean setReal64(String pValue) {
            try {
                if (WBEMConfiguration.getGlobalConfiguration().verifyJavaLangDoubleStrings() && Util.isBadDoubleString(pValue)) {
                    return false;
                }
                this.iValue = new Double(pValue);
            }
            catch (NumberFormatException e) {
                return false;
            }
            this.iType = CIMDataType.REAL64_T;
            return true;
        }

        private boolean setBoolean(String pValue) {
            this.iValue = Boolean.valueOf(pValue);
            this.iType = CIMDataType.BOOLEAN_T;
            return true;
        }

        private boolean setDTAbsolute(String pValue) {
            try {
                this.iValue = new CIMDateTimeAbsolute(pValue);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
            this.iType = CIMDataType.DATETIME_T;
            return true;
        }

        private boolean setDTInterval(String pValue) {
            try {
                this.iValue = new CIMDateTimeInterval(pValue);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
            this.iType = CIMDataType.DATETIME_T;
            return true;
        }
    }
}

