/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.cimclient.internal.cimxml.sax;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.cim.CIMClass;
import javax.cim.CIMDataType;
import javax.cim.CIMDateTime;
import javax.cim.CIMDateTimeAbsolute;
import javax.cim.CIMDateTimeInterval;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.cim.UnsignedInteger64;
import javax.cim.UnsignedInteger8;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.sblim.cimclient.internal.cimxml.sax.SAXSession;
import org.sblim.cimclient.internal.cimxml.sax.XMLDefaultHandlerImpl;
import org.sblim.cimclient.internal.cimxml.sax.node.ClassNode;
import org.sblim.cimclient.internal.cimxml.sax.node.InstanceNode;
import org.sblim.cimclient.internal.cimxml.sax.node.Node;
import org.sblim.cimclient.internal.cimxml.sax.node.ValueArrayNode;
import org.sblim.cimclient.internal.cimxml.sax.node.ValueNode;
import org.sblim.cimclient.internal.util.Util;
import org.sblim.cimclient.internal.util.WBEMConfiguration;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CIMObjectFactory {
    static final CIMInstance[] EMPTY_INST_A = new CIMInstance[0];
    static final CIMClass[] EMPTY_CLASS_A = new CIMClass[0];
    static final String[] EMPTY_STR_A = new String[0];
    static final UnsignedInteger8[] EMPTY_UINT8_A = new UnsignedInteger8[0];
    static final UnsignedInteger16[] EMPTY_UINT16_A = new UnsignedInteger16[0];
    static final UnsignedInteger32[] EMPTY_UINT32_A = new UnsignedInteger32[0];
    static final UnsignedInteger64[] EMPTY_UINT64_A = new UnsignedInteger64[0];
    static final Byte[] EMPTY_BYTE_A = new Byte[0];
    static final Short[] EMPTY_SHORT_A = new Short[0];
    static final Integer[] EMPTY_INT_A = new Integer[0];
    static final Long[] EMPTY_LONG_A = new Long[0];
    static final Float[] EMPTY_FLOAT_A = new Float[0];
    static final Double[] EMPTY_DOUBLE_A = new Double[0];
    static final Character[] EMPTY_CHAR_A = new Character[0];
    static final Boolean[] EMPTY_BOOL_A = new Boolean[0];
    static final CIMDateTime[] EMPTY_DT_A = new CIMDateTime[0];
    static final CIMObjectPath[] EMPTY_OP_A = new CIMObjectPath[0];
    private static HashMap<String, CIMDataType> cTypeStrMap;
    private static ValueFactory[] cValFactoryA;

    public static Object[] getEmbeddedObjA(CIMDataType pType, ValueArrayNode pValueArrayNode, SAXSession pSession) throws SAXException {
        if (pValueArrayNode == null) {
            return null;
        }
        return CIMObjectFactory.getEmbeddedObjA(pType, (String[])pValueArrayNode.getValue(), pSession);
    }

    public static Object[] getEmbeddedObjA(CIMDataType pType, String[] pValueStrA, SAXSession pSession) throws SAXException {
        CIMObjectFactory.embeddedObjTypeCheck(pType);
        if (pValueStrA == null || pValueStrA.length == 0) {
            return null;
        }
        CIMDataType type = null;
        ArrayList<Object> objAL = new ArrayList<Object>(pValueStrA.length);
        for (int i = 0; i < pValueStrA.length; ++i) {
            Object obj = CIMObjectFactory.parseEmbeddedObj(pValueStrA[i], pSession);
            if (type == null) {
                type = CIMObjectFactory.getCIMObjScalarType(obj, false);
            } else {
                CIMDataType type2 = CIMObjectFactory.getCIMObjScalarType(obj, false);
                if (type2 != null && type != type2) {
                    throw new SAXException("Embedded Object array contains both Instance and Class objects. This is not handled!");
                }
            }
            objAL.add(obj);
        }
        if (type == CIMDataType.OBJECT_T) {
            return objAL.toArray(EMPTY_INST_A);
        }
        if (type == CIMDataType.CLASS_T) {
            return objAL.toArray(EMPTY_CLASS_A);
        }
        return objAL.toArray(EMPTY_STR_A);
    }

    public static Object getEmbeddedObj(CIMDataType pType, String pValueStr, SAXSession pSession) throws SAXException {
        CIMObjectFactory.embeddedObjTypeCheck(pType);
        return CIMObjectFactory.parseEmbeddedObj(pValueStr, pSession);
    }

    public static Object getEmbeddedObj(CIMDataType pType, Object pValObj, SAXSession pSession) throws SAXException {
        if (pValObj instanceof String) {
            return CIMObjectFactory.getEmbeddedObj(pType, (String)pValObj, pSession);
        }
        return CIMObjectFactory.getEmbeddedObjA(pType, (String[])pValObj, pSession);
    }

    public static Object[] getObjectArray(CIMDataType pType, ArrayList<Object> pAL) {
        CIMObjectFactory.createValFactoryA();
        ValueFactory factory = cValFactoryA[pType.getType()];
        return factory.make(pAL);
    }

    public static Object getObject(CIMDataType pType, String pValueStr) throws SAXException {
        if (pValueStr == null) {
            return null;
        }
        CIMObjectFactory.createValFactoryA();
        ValueFactory factory = cValFactoryA[pType.getType()];
        try {
            return factory.make(pValueStr);
        }
        catch (NumberFormatException e) {
            throw new SAXException(e);
        }
    }

    public static Object getObject(CIMDataType pType, ValueNode pValueNode) throws SAXException {
        if (pValueNode == null) {
            return null;
        }
        return CIMObjectFactory.getObject(pType, (String)pValueNode.getValue());
    }

    public static Object getObject(CIMDataType pType, ValueArrayNode pValueArrayNode) throws SAXException {
        if (pValueArrayNode == null) {
            return null;
        }
        ArrayList<Object> objAL = new ArrayList<Object>(pValueArrayNode.size());
        for (int i = 0; i < pValueArrayNode.size(); ++i) {
            objAL.add(CIMObjectFactory.getObject(pType, (String)pValueArrayNode.elementAt(i)));
        }
        return CIMObjectFactory.getObjectArray(pType, objAL);
    }

    public static CIMDataType getCIMObjScalarType(Object pObj, boolean pNullToString) throws SAXException {
        if (pObj == null) {
            return pNullToString ? CIMDataType.STRING_T : null;
        }
        if (pObj instanceof CIMInstance) {
            return CIMDataType.OBJECT_T;
        }
        if (pObj instanceof CIMClass) {
            return CIMDataType.CLASS_T;
        }
        if (pObj instanceof String) {
            return CIMDataType.STRING_T;
        }
        throw new SAXException(pObj.getClass().getName() + " is not a CIMObject!");
    }

    public static CIMDataType getCIMObjScalarType(Object pObj) throws SAXException {
        return CIMObjectFactory.getCIMObjScalarType(pObj, true);
    }

    public static CIMDataType getCIMObjArrayType(Object pObj) throws SAXException {
        return CIMObjectFactory.getCIMObjArrayType(pObj, true);
    }

    public static CIMDataType getCIMObjArrayType(Object pObj, boolean pNullToString) throws SAXException {
        if (pObj == null) {
            return pNullToString ? CIMDataType.STRING_ARRAY_T : null;
        }
        if (pObj instanceof CIMInstance[]) {
            return CIMDataType.OBJECT_ARRAY_T;
        }
        if (pObj instanceof CIMClass[]) {
            return CIMDataType.CLASS_ARRAY_T;
        }
        if (pObj instanceof String[]) {
            return CIMDataType.STRING_ARRAY_T;
        }
        throw new SAXException(pObj.getClass().getName() + " is not a CIMObject array!");
    }

    public static CIMDataType getType(String pTypeStr) throws SAXException {
        if (pTypeStr == null) {
            return null;
        }
        CIMObjectFactory.createTypeStrMap();
        CIMDataType type = cTypeStrMap.get(pTypeStr);
        if (type == null && !cTypeStrMap.containsKey(pTypeStr)) {
            throw new SAXException(pTypeStr + " is invalid PARAMTYPE!");
        }
        return type;
    }

    private static void embeddedObjTypeCheck(CIMDataType pType) throws SAXException {
        if (pType.getType() != 8) {
            throw new SAXException("TYPE attribute should be 'string' for EmbeddedObjects!");
        }
    }

    private static Object parseEmbeddedObj(String pValueStr, SAXSession pSession) throws SAXException {
        if (pValueStr == null || pValueStr.length() == 0) {
            return null;
        }
        XMLDefaultHandlerImpl ourHandler = new XMLDefaultHandlerImpl(pSession, true);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse((InputStream)new ByteArrayInputStream(pValueStr.getBytes()), (DefaultHandler)ourHandler);
        }
        catch (SAXException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SAXException("Exception occurred during embedded object parsing!", e);
        }
        Node node = ourHandler.getRootNode();
        if (node instanceof InstanceNode) {
            return ((InstanceNode)node).getCIMInstance();
        }
        if (node instanceof ClassNode) {
            return ((ClassNode)node).getCIMClass();
        }
        throw new SAXException(node.getNodeName() + " root element is unexpected for Embedded Object XML String!");
    }

    private static synchronized void createTypeStrMap() {
        if (cTypeStrMap != null) {
            return;
        }
        cTypeStrMap = new HashMap();
        cTypeStrMap.put("uint8", CIMDataType.UINT8_T);
        cTypeStrMap.put("uint16", CIMDataType.UINT16_T);
        cTypeStrMap.put("uint32", CIMDataType.UINT32_T);
        cTypeStrMap.put("uint64", CIMDataType.UINT64_T);
        cTypeStrMap.put("sint8", CIMDataType.SINT8_T);
        cTypeStrMap.put("sint16", CIMDataType.SINT16_T);
        cTypeStrMap.put("sint32", CIMDataType.SINT32_T);
        cTypeStrMap.put("sint64", CIMDataType.SINT64_T);
        cTypeStrMap.put("real32", CIMDataType.REAL32_T);
        cTypeStrMap.put("real64", CIMDataType.REAL64_T);
        cTypeStrMap.put("char16", CIMDataType.CHAR16_T);
        cTypeStrMap.put("string", CIMDataType.STRING_T);
        cTypeStrMap.put("boolean", CIMDataType.BOOLEAN_T);
        cTypeStrMap.put("datetime", CIMDataType.DATETIME_T);
        cTypeStrMap.put("reference", new CIMDataType(""));
    }

    private static void putFactory(int pTypeCode, ValueFactory pFactory) {
        CIMObjectFactory.cValFactoryA[pTypeCode] = pFactory;
    }

    private static synchronized void createValFactoryA() {
        if (cValFactoryA != null) {
            return;
        }
        cValFactoryA = new ValueFactory[64];
        CIMObjectFactory.putFactory(0, new ValueFactory(){

            @Override
            public Object make(String pStr) {
                return new UnsignedInteger8(pStr);
            }

            @Override
            public Object[] make(ArrayList<Object> pAL) {
                return pAL.toArray(EMPTY_UINT8_A);
            }
        });
        CIMObjectFactory.putFactory(2, new ValueFactory(){

            @Override
            public Object make(String pStr) {
                return new UnsignedInteger16(pStr);
            }

            @Override
            public Object[] make(ArrayList<Object> pAL) {
                return pAL.toArray(EMPTY_UINT16_A);
            }
        });
        CIMObjectFactory.putFactory(4, new ValueFactory(){

            @Override
            public Object make(String pStr) {
                return new UnsignedInteger32(pStr);
            }

            @Override
            public Object[] make(ArrayList<Object> pAL) {
                return pAL.toArray(EMPTY_UINT32_A);
            }
        });
        CIMObjectFactory.putFactory(6, new ValueFactory(){

            @Override
            public Object make(String pStr) {
                return new UnsignedInteger64(pStr);
            }

            @Override
            public Object[] make(ArrayList<Object> pAL) {
                return pAL.toArray(EMPTY_UINT64_A);
            }
        });
        CIMObjectFactory.putFactory(1, new ValueFactory(){

            @Override
            public Object make(String pStr) {
                return new Byte(pStr);
            }

            @Override
            public Object[] make(ArrayList<Object> pAL) {
                return pAL.toArray(EMPTY_BYTE_A);
            }
        });
        CIMObjectFactory.putFactory(3, new ValueFactory(){

            @Override
            public Object make(String pStr) {
                return new Short(pStr);
            }

            @Override
            public Object[] make(ArrayList<Object> pAL) {
                return pAL.toArray(EMPTY_SHORT_A);
            }
        });
        CIMObjectFactory.putFactory(5, new ValueFactory(){

            @Override
            public Object make(String pStr) {
                return new Integer(pStr);
            }

            @Override
            public Object[] make(ArrayList<Object> pAL) {
                return pAL.toArray(EMPTY_INT_A);
            }
        });
        CIMObjectFactory.putFactory(7, new ValueFactory(){

            @Override
            public Object make(String pStr) {
                return new Long(pStr);
            }

            @Override
            public Object[] make(ArrayList<Object> pAL) {
                return pAL.toArray(EMPTY_LONG_A);
            }
        });
        CIMObjectFactory.putFactory(10, new ValueFactory(){

            @Override
            public Object make(String pStr) {
                return new Float(pStr);
            }

            @Override
            public Object[] make(ArrayList<Object> pAL) {
                return pAL.toArray(EMPTY_FLOAT_A);
            }
        });
        CIMObjectFactory.putFactory(11, new ValueFactory(){

            @Override
            public Object make(String pStr) {
                if (WBEMConfiguration.getGlobalConfiguration().verifyJavaLangDoubleStrings() && Util.isBadDoubleString(pStr)) {
                    throw new IllegalArgumentException("Double value string hangs older JVMs!\n" + pStr);
                }
                return new Double(pStr);
            }

            @Override
            public Object[] make(ArrayList<Object> pAL) {
                return pAL.toArray(EMPTY_DOUBLE_A);
            }
        });
        CIMObjectFactory.putFactory(13, new ValueFactory(){

            @Override
            public Object make(String pStr) {
                if (pStr == null || pStr.length() == 0) {
                    throw new IllegalArgumentException("Cannot make Character from empty String!");
                }
                return Character.valueOf(pStr.charAt(0));
            }

            @Override
            public Object[] make(ArrayList<Object> pAL) {
                return pAL.toArray(EMPTY_CHAR_A);
            }
        });
        CIMObjectFactory.putFactory(8, new ValueFactory(){

            @Override
            public Object make(String pStr) {
                return pStr;
            }

            @Override
            public Object[] make(ArrayList<Object> pAL) {
                return pAL.toArray(EMPTY_STR_A);
            }
        });
        CIMObjectFactory.putFactory(9, new ValueFactory(){

            @Override
            public Object make(String pStr) {
                return Boolean.valueOf(pStr);
            }

            @Override
            public Object[] make(ArrayList<Object> pAL) {
                return pAL.toArray(EMPTY_BOOL_A);
            }
        });
        CIMObjectFactory.putFactory(12, new ValueFactory(){

            @Override
            public Object make(String pStr) {
                try {
                    return new CIMDateTimeAbsolute(pStr);
                }
                catch (IllegalArgumentException eA) {
                    try {
                        return new CIMDateTimeInterval(pStr);
                    }
                    catch (IllegalArgumentException eI) {
                        throw new IllegalArgumentException("CIMDataTimeAbsolute:" + eA.getMessage() + "\nCIMDateTimeInterval:" + eI.getMessage());
                    }
                }
            }

            @Override
            public Object[] make(ArrayList<Object> pAL) {
                return pAL.toArray(EMPTY_DT_A);
            }
        });
        CIMObjectFactory.putFactory(14, new ValueFactory(){

            @Override
            public Object make(String pStr) {
                return new CIMObjectPath(pStr);
            }

            @Override
            public Object[] make(ArrayList<Object> pAL) {
                return pAL.toArray(EMPTY_OP_A);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface ValueFactory {
        public Object make(String var1);

        public Object[] make(ArrayList<Object> var1);
    }
}

