/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.cimclient.internal.cimxml.sax.node;

import javax.cim.CIMObjectPath;
import org.sblim.cimclient.internal.cimxml.sax.SAXSession;
import org.sblim.cimclient.internal.cimxml.sax.node.AbstractObjectPathNode;
import org.sblim.cimclient.internal.cimxml.sax.node.ClassNameNode;
import org.sblim.cimclient.internal.cimxml.sax.node.NameSpacePathNode;
import org.sblim.cimclient.internal.cimxml.sax.node.Node;
import org.sblim.cimclient.internal.util.XMLHostStr;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ClassPathNode
extends AbstractObjectPathNode {
    private boolean iHasNameSpacePath;
    private boolean iHasClassName;
    private String iLocalNameSpacePathStr;
    private XMLHostStr iHostStr;
    private String iClassNameStr;

    public ClassPathNode() {
        super("CLASSPATH");
    }

    public void init(Attributes pAttribs, SAXSession pSession) {
        this.iHasClassName = false;
        this.iHasNameSpacePath = false;
        this.iClassNameStr = null;
        this.iLocalNameSpacePathStr = null;
        this.iHostStr = new XMLHostStr();
    }

    public void parseData(String pData) {
    }

    public void testChild(String pNodeNameEnum) throws SAXException {
        if (pNodeNameEnum == "NAMESPACEPATH") {
            if (this.iHasNameSpacePath) {
                throw new SAXException("CLASSPATH node already has a NAMESPACEPATH child node!");
            }
        } else if (pNodeNameEnum == "CLASSNAME") {
            if (this.iHasClassName) {
                throw new SAXException("CLASSPATH node already has a CLASSNAME child node!");
            }
        } else {
            throw new SAXException("CLASSPATH node cannot have " + pNodeNameEnum + " child node! It can have NAMESPACEPATH and CLASSNAME child nodes only!");
        }
    }

    public void childParsed(Node pChild) {
        if (pChild instanceof NameSpacePathNode) {
            NameSpacePathNode nsPathNode = (NameSpacePathNode)pChild;
            this.iLocalNameSpacePathStr = nsPathNode.getLocalNameSpacePath();
            this.iHostStr.set(nsPathNode.getHostStr());
            this.iHasNameSpacePath = true;
        } else {
            this.iClassNameStr = ((ClassNameNode)pChild).getClassName();
            this.iHasClassName = true;
        }
    }

    public void testCompletness() throws SAXException {
        if (!this.iHasNameSpacePath) {
            throw new SAXException("NAMESPACEPATH child node is mandatory for CLASSPATH node!");
        }
        if (!this.iHasClassName) {
            throw new SAXException("CLASSNAME child node is mandatory for CLASSPATH node!");
        }
    }

    public CIMObjectPath getCIMObjectPath() {
        return new CIMObjectPath(this.iHostStr.getProtocol(), this.iHostStr.getHost(), this.iHostStr.getPort(), this.iLocalNameSpacePathStr, this.iClassNameStr, null);
    }
}

